#ifdef WIN32
/* Wu Yongwei's quick hacks for MinGW, referenced in 
http://osdir.com/ml/gnu.mingw.devel/2003-03/msg00070.html
 */
#include <windows.h>
#include <errno.h>
#define dlsym(D,F) (void*)GetProcAddress((HMODULE)D,F)
#define dlerror() (char*)GetLastError()
#define dlopen(P,G) (void*)LoadLibrary(P)
#define dlclose(D) FreeLibrary((HMODULE)D)
#else
#include <dlfcn.h>
#endif
#include <stdlib.h>

#include "repl_glue.h"

#define OP_PLUS 0
#define OP_MINUS 1
#define OP_TIMES 2
#define OP_DIVIDE 3
#define OP_MODULO 4
#define OP_POWER 5
#define OP_EQUAL 6
#define OP_NEQUAL 7
#define OP_LT 8
#define OP_GT 9
#define OP_LE 10
#define OP_GE 11
#define OP_AND 12
#define OP_OR 13
#define OP_XOR 14
#define OP_BAND 15
#define OP_BOR 16
#define OP_SHLEFT 17
#define OP_SHRIGHT 18
#define OP_ANDBOOL 19
#define OP_ORBOOL 20 

#define OP_NOT 0
#define OP_NEG 1

static VMState* vm;

void interp_init()
{
    GC_init();
    vm = initstack();
}

/*
void interp_load(const char* pathname)
{

    program = dlopen(pathname, RTLD_LAZY);

    if (program==NULL) {
	cout << dlerror() << endl;
	exit(-1);
    }
}
*/

void interp_prepare_call() 
{
    // Create space for the result on the stack
    vm->push(newKayaValue());
}

void interp_clear()
{
    while(!vm->emptyStack()) {
	vm->discardPop();
    }
}

void interp_push_int(kint v)
{
    vm->push(MKINT(v));
}

void interp_push_float(double v)
{
    vm->push(MKREAL(v));
}

void interp_push_string(char* v)
{
    vm->push(MKSTR(KSTRING(v)));
}

// Call a function in the given vm, in the loaded program.
// FIXME: This has to deal with exceptions at some point! Probably putting
// try/catch VM instructions around it will work...
kint interp_call(void* handle, const char* function)
{
    // Look up the function symbol and run it
    func sym = (func)(dlsym(handle, function));

    if (sym==NULL) {
	cout << dlerror() << endl;
	exit(-1);
    }

    TRY(catchcode);
    sym(vm);
    TRIED;
    JUMP(okay);
    LABEL(catchcode);
    PRINTEXC;
    return 0;
    LABEL(okay);
    return 1;
}

void interp_array(kint len)
{
    MKARRAY(len);
}

void interp_op(kint opid)
{
    kint l,r;
    kint ans = 0;
    GETVAL(l);
    GETVAL(r);
    switch(opid) {
    case OP_PLUS:
	ans = l+r;
	break;
    case OP_MINUS:
	ans = l-r;
	break;
    case OP_TIMES:
	ans = l*r;
	break;
    case OP_DIVIDE:
	ans = l/r;
	break;
    case OP_MODULO:
	ans = l%r;
	break;
    case OP_POWER:
	ans = intpower(l, r);
	break;
    case OP_EQUAL:
	ans = l == r;
	break;
    case OP_NEQUAL:
	ans = l != r;
	break;
    case OP_LT:
	ans = l < r;
	break;
    case OP_GT:
	ans = l > r;
	break;
    case OP_LE:
	ans = l <= r;
	break;
    case OP_GE:
	ans = l >= r;
	break;
    case OP_AND:
	ans = l & r;
	break;
    case OP_OR:
	ans = l | r;
	break;
    case OP_XOR:
	ans = l ^ r;
	break;
    case OP_BAND:
	ans = l && r;
	break;
    case OP_BOR:
	ans = l || r;
	break;
    case OP_SHLEFT:
	ans = l << r;
	break;
    case OP_SHRIGHT:
	ans = l >> r;
	break;
    case OP_ANDBOOL:
	ans = l && r;
	break;
    case OP_ORBOOL:
	ans = l || r;
	break;
    default:
	cerr << "Warning; unknown operator" << endl;
    }
    vm->push(mkint((void*)ans));
}

void interp_floatopfn(kint opid)
{
    double l,r;
    double ans = 0;
    GETRVAL(l);
    GETRVAL(r);

    switch(opid) {
    case OP_PLUS:
	ans = l+r;
	break;
    case OP_MINUS:
	ans = l-r;
	break;
    case OP_TIMES:
	ans = l*r;
	break;
    case OP_DIVIDE:
	ans = l/r;
	break;
    case OP_POWER:
	ans = realpower(l, r);
	break;
    case OP_EQUAL:
	ans = l == r;
	break;
    case OP_NEQUAL:
	ans = l != r;
	break;
    case OP_LT:
	ans = l < r;
	break;
    case OP_GT:
	ans = l > r;
	break;
    case OP_LE:
	ans = l <= r;
	break;
    case OP_GE:
	ans = l >= r;
	break;
    default:
	cerr << "Warning; unknown operator" << endl;
    }
    vm->push(MKREAL(ans));
}

void interp_unop(kint opid)
{
    kint l;
    kint ans = 0;
    GETVAL(l);
    switch(opid) {
    case OP_NOT:
	ans = !l;
	break;
    case OP_NEG:
	ans = -l;
	break;
    default:
	cerr << "Warning; unknown operator" << endl;
    }
    vm->push(mkint((void*)ans));
}

void interp_floatunop(kint opid)
{
    double l;
    double ans = 0;
    GETRVAL(l);
    switch(opid) {
    case OP_NEG:
	ans = -l;
	break;
    default:
	cerr << "Warning; unknown operator" << endl;
    }
    vm->push(MKREAL(ans));
}

void interp_append()
{
    APPEND;
}

void interp_str2int()
{
    STR2INT;
}

void interp_int2str()
{
    INT2STR;
}

void interp_str2real()
{
    STR2REAL;
}

void interp_real2str()
{
    REAL2STR;
}

void interp_str2chr()
{
    STR2CHR;
}

void interp_chr2str()
{
    CHR2STR;
}

void interp_int2real()
{
    INT2REAL;
}

void interp_real2int()
{
    REAL2INT;
}

void interp_bool2str()
{
    BOOL2STR;
}


