/*
 * AM65X Clocks Info
 *
 * Copyright (C) 2020 Texas Instruments Incorporated - https://www.ti.com/
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <tisci.h>
#include <socinfo.h>

struct ti_sci_clocks_info am65x_clocks_info[] = {
	{157, 0, "DEV_BOARD0_BUS_SCL3_IN", "Input clock"},
	{157, 1, "DEV_BOARD0_BUS_SCL2_IN", "Input clock"},
	{157, 2, "DEV_BOARD0_BUS_SCL1_IN", "Input clock"},
	{157, 3, "DEV_BOARD0_BUS_SCL0_IN", "Input clock"},
	{157, 4, "DEV_BOARD0_BUS_PRG2_RGMII2_TCLK_IN", "Input clock"},
	{157, 5, "DEV_BOARD0_BUS_MCU_OSPI1CLK_IN", "Input clock"},
	{157, 6, "DEV_BOARD0_BUS_PRG1_RGMII1_TCLK_IN", "Input clock"},
	{157, 7, "DEV_BOARD0_BUS_REFCLK1P_IN", "Input muxed clock"},
	{157, 8, "DEV_BOARD0_BUS_REFCLK1P_IN_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_BOARD0_BUS_REFCLK1P_IN"},
	{157, 9, "DEV_BOARD0_BUS_REFCLK1P_IN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_BOARD0_BUS_REFCLK1P_IN"},
	{157, 10, "DEV_BOARD0_BUS_REFCLK1P_IN_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_CLKOUT_CLK", "Parent input clock option to DEV_BOARD0_BUS_REFCLK1P_IN"},
	{157, 11, "DEV_BOARD0_BUS_REFCLK1P_IN_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT4_CLK", "Parent input clock option to DEV_BOARD0_BUS_REFCLK1P_IN"},
	{157, 12, "DEV_BOARD0_BUS_MCU_OSPI1LBCLKO_IN", "Input clock"},
	{157, 13, "DEV_BOARD0_BUS_MCU_OBSCLK_IN", "Input clock"},
	{157, 14, "DEV_BOARD0_BUS_MCU_OBSCLK_IN_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_BOARD0_BUS_MCU_OBSCLK_IN"},
	{157, 15, "DEV_BOARD0_BUS_MCU_OBSCLK_IN_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_BOARD0_BUS_MCU_OBSCLK_IN"},
	{157, 16, "DEV_BOARD0_BUS_MCU_OBSCLK_IN_PARENT_ADPLLM_HSDIV_WRAP_MCU_0_BUS_CLKOUT_CLK", "Parent input clock option to DEV_BOARD0_BUS_MCU_OBSCLK_IN"},
	{157, 17, "DEV_BOARD0_BUS_MCU_OBSCLK_IN_PARENT_ADPLLM_HSDIV_WRAP_MCU_0_BUS_CLKOUT_CLK_DUP0", "Parent input clock option to DEV_BOARD0_BUS_MCU_OBSCLK_IN"},
	{157, 18, "DEV_BOARD0_BUS_MCU_OBSCLK_IN_PARENT_ADPLLM_HSDIV_WRAP_MCU_0_BUS_HSDIV_CLKOUT1_CLK", "Parent input clock option to DEV_BOARD0_BUS_MCU_OBSCLK_IN"},
	{157, 19, "DEV_BOARD0_BUS_MCU_OBSCLK_IN_PARENT_ADPLLM_HSDIV_WRAP_MCU_0_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_BOARD0_BUS_MCU_OBSCLK_IN"},
	{157, 20, "DEV_BOARD0_BUS_MCU_OBSCLK_IN_PARENT_ADPLLM_HSDIV_WRAP_MCU_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_BOARD0_BUS_MCU_OBSCLK_IN"},
	{157, 21, "DEV_BOARD0_BUS_MCU_OBSCLK_IN_PARENT_ADPLLM_HSDIV_WRAP_MCU_0_BUS_HSDIV_CLKOUT4_CLK", "Parent input clock option to DEV_BOARD0_BUS_MCU_OBSCLK_IN"},
	{157, 22, "DEV_BOARD0_BUS_MCU_OBSCLK_IN_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_CLKOUT_CLK", "Parent input clock option to DEV_BOARD0_BUS_MCU_OBSCLK_IN"},
	{157, 23, "DEV_BOARD0_BUS_MCU_OBSCLK_IN_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_BOARD0_BUS_MCU_OBSCLK_IN"},
	{157, 24, "DEV_BOARD0_BUS_MCU_OBSCLK_IN_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT1_CLK", "Parent input clock option to DEV_BOARD0_BUS_MCU_OBSCLK_IN"},
	{157, 25, "DEV_BOARD0_BUS_MCU_OBSCLK_IN_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_BOARD0_BUS_MCU_OBSCLK_IN"},
	{157, 26, "DEV_BOARD0_BUS_MCU_OBSCLK_IN_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_BOARD0_BUS_MCU_OBSCLK_IN"},
	{157, 27, "DEV_BOARD0_BUS_MCU_OBSCLK_IN_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT4_CLK", "Parent input clock option to DEV_BOARD0_BUS_MCU_OBSCLK_IN"},
	{157, 28, "DEV_BOARD0_BUS_MCU_OBSCLK_IN_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK_DUP0", "Parent input clock option to DEV_BOARD0_BUS_MCU_OBSCLK_IN"},
	{157, 29, "DEV_BOARD0_BUS_MCU_OBSCLK_IN_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_BOARD0_BUS_MCU_OBSCLK_IN"},
	{157, 30, "DEV_BOARD0_BUS_PRG2_RGMII1_TCLK_IN", "Input clock"},
	{157, 31, "DEV_BOARD0_BUS_REFCLK1M_IN", "Input muxed clock"},
	{157, 32, "DEV_BOARD0_BUS_REFCLK1M_IN_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_BOARD0_BUS_REFCLK1M_IN"},
	{157, 33, "DEV_BOARD0_BUS_REFCLK1M_IN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_BOARD0_BUS_REFCLK1M_IN"},
	{157, 34, "DEV_BOARD0_BUS_REFCLK1M_IN_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_CLKOUT_CLK", "Parent input clock option to DEV_BOARD0_BUS_REFCLK1M_IN"},
	{157, 35, "DEV_BOARD0_BUS_REFCLK1M_IN_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT4_CLK", "Parent input clock option to DEV_BOARD0_BUS_REFCLK1M_IN"},
	{157, 36, "DEV_BOARD0_BUS_OBSCLK_IN", "Input clock"},
	{157, 37, "DEV_BOARD0_BUS_OBSCLK_IN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_BOARD0_BUS_OBSCLK_IN"},
	{157, 38, "DEV_BOARD0_BUS_OBSCLK_IN_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_BOARD0_BUS_OBSCLK_IN"},
	{157, 39, "DEV_BOARD0_BUS_OBSCLK_IN_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_CLKOUT_CLK", "Parent input clock option to DEV_BOARD0_BUS_OBSCLK_IN"},
	{157, 40, "DEV_BOARD0_BUS_OBSCLK_IN_PARENT_ADPLLLJM_WRAP_MAIN_1_BUS_CLKOUT_CLK", "Parent input clock option to DEV_BOARD0_BUS_OBSCLK_IN"},
	{157, 41, "DEV_BOARD0_BUS_OBSCLK_IN_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_BOARD0_BUS_OBSCLK_IN"},
	{157, 42, "DEV_BOARD0_BUS_OBSCLK_IN_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_CLKOUT_CLK", "Parent input clock option to DEV_BOARD0_BUS_OBSCLK_IN"},
	{157, 43, "DEV_BOARD0_BUS_OBSCLK_IN_PARENT_ADPLLLJM_WRAP_MAIN_4_BUS_CLKOUT_CLK", "Parent input clock option to DEV_BOARD0_BUS_OBSCLK_IN"},
	{157, 44, "DEV_BOARD0_BUS_OBSCLK_IN_PARENT_ADPLLM_WRAP_MAIN_6_BUS_CLKOUT_CLK", "Parent input clock option to DEV_BOARD0_BUS_OBSCLK_IN"},
	{157, 45, "DEV_BOARD0_BUS_OBSCLK_IN_PARENT_ADPLLLJM_WRAP_MAIN_3_BUS_CLKOUT_CLK", "Parent input clock option to DEV_BOARD0_BUS_OBSCLK_IN"},
	{157, 46, "DEV_BOARD0_BUS_OBSCLK_IN_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_CLKOUT_CLK", "Parent input clock option to DEV_BOARD0_BUS_OBSCLK_IN"},
	{157, 47, "DEV_BOARD0_BUS_OBSCLK_IN_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT1_CLK", "Parent input clock option to DEV_BOARD0_BUS_OBSCLK_IN"},
	{157, 48, "DEV_BOARD0_BUS_OBSCLK_IN_PARENT_ADPLLM_WRAP_MAIN_7_BUS_CLKOUT_CLK", "Parent input clock option to DEV_BOARD0_BUS_OBSCLK_IN"},
	{157, 49, "DEV_BOARD0_BUS_OBSCLK_IN_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF2_0", "Parent input clock option to DEV_BOARD0_BUS_OBSCLK_IN"},
	{157, 50, "DEV_BOARD0_BUS_OBSCLK_IN_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF3_0", "Parent input clock option to DEV_BOARD0_BUS_OBSCLK_IN"},
	{157, 51, "DEV_BOARD0_BUS_OBSCLK_IN_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF4_0", "Parent input clock option to DEV_BOARD0_BUS_OBSCLK_IN"},
	{157, 52, "DEV_BOARD0_BUS_OBSCLK_IN_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF5_0", "Parent input clock option to DEV_BOARD0_BUS_OBSCLK_IN"},
	{157, 53, "DEV_BOARD0_BUS_PRG0_RGMII1_TCLK_IN", "Input clock"},
	{157, 54, "DEV_BOARD0_BUS_MCU_OSPI0CLK_IN", "Input clock"},
	{157, 55, "DEV_BOARD0_BUS_DSS0PCLK_IN", "Input clock"},
	{157, 56, "DEV_BOARD0_BUS_PRG0_RGMII2_TCLK_IN", "Input clock"},
	{157, 57, "DEV_BOARD0_BUS_WKUP_SCL0_IN", "Input clock"},
	{157, 58, "DEV_BOARD0_BUS_REFCLK0P_IN", "Input muxed clock"},
	{157, 59, "DEV_BOARD0_BUS_REFCLK0P_IN_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_BOARD0_BUS_REFCLK0P_IN"},
	{157, 60, "DEV_BOARD0_BUS_REFCLK0P_IN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_BOARD0_BUS_REFCLK0P_IN"},
	{157, 61, "DEV_BOARD0_BUS_REFCLK0P_IN_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_CLKOUT_CLK", "Parent input clock option to DEV_BOARD0_BUS_REFCLK0P_IN"},
	{157, 62, "DEV_BOARD0_BUS_REFCLK0P_IN_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT4_CLK", "Parent input clock option to DEV_BOARD0_BUS_REFCLK0P_IN"},
	{157, 63, "DEV_BOARD0_BUS_REFCLK0M_IN", "Input muxed clock"},
	{157, 64, "DEV_BOARD0_BUS_REFCLK0M_IN_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_BOARD0_BUS_REFCLK0M_IN"},
	{157, 65, "DEV_BOARD0_BUS_REFCLK0M_IN_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_BOARD0_BUS_REFCLK0M_IN"},
	{157, 66, "DEV_BOARD0_BUS_REFCLK0M_IN_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_CLKOUT_CLK", "Parent input clock option to DEV_BOARD0_BUS_REFCLK0M_IN"},
	{157, 67, "DEV_BOARD0_BUS_REFCLK0M_IN_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT4_CLK", "Parent input clock option to DEV_BOARD0_BUS_REFCLK0M_IN"},
	{157, 68, "DEV_BOARD0_BUS_MCU_OSPI0LBCLKO_IN", "Input clock"},
	{157, 69, "DEV_BOARD0_BUS_MCU_CLKOUT_IN", "Input muxed clock"},
	{157, 70, "DEV_BOARD0_BUS_MCU_CLKOUT_IN_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_CLKOUT_CLK5", "Parent input clock option to DEV_BOARD0_BUS_MCU_CLKOUT_IN"},
	{157, 71, "DEV_BOARD0_BUS_MCU_CLKOUT_IN_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_CLKOUT_CLK10", "Parent input clock option to DEV_BOARD0_BUS_MCU_CLKOUT_IN"},
	{157, 72, "DEV_BOARD0_BUS_MCU_SCL0_IN", "Input clock"},
	{157, 73, "DEV_BOARD0_BUS_SYSCLKOUT_IN", "Input clock"},
	{157, 74, "DEV_BOARD0_BUS_MCU_SYSCLKOUT_IN", "Input clock"},
	{157, 75, "DEV_BOARD0_BUS_PRG1_RGMII1_RCLK_OUT", "Output clock"},
	{157, 76, "DEV_BOARD0_BUS_PRG1_RGMII2_RCLK_OUT", "Output clock"},
	{157, 77, "DEV_BOARD0_BUS_GPMCCLK_OUT", "Output clock"},
	{157, 78, "DEV_BOARD0_BUS_MCASP2AHCLKX_OUT", "Output clock"},
	{157, 79, "DEV_BOARD0_BUS_MCASP2AHCLKR_OUT", "Output clock"},
	{157, 80, "DEV_BOARD0_BUS_PRG2_RGMII2_RCLK_OUT", "Output clock"},
	{157, 81, "DEV_BOARD0_BUS_CPTS_RFT_CLK_OUT", "Output clock"},
	{157, 82, "DEV_BOARD0_BUS_MCASP0ACLKR_OUT", "Output clock"},
	{157, 83, "DEV_BOARD0_BUS_MCASP0ACLKX_OUT", "Output clock"},
	{157, 84, "DEV_BOARD0_BUS_EXT_REFCLK1_OUT", "Output clock"},
	{157, 85, "DEV_BOARD0_BUS_PRG0_RGMII2_RCLK_OUT", "Output clock"},
	{157, 86, "DEV_BOARD0_BUS_MCU_OSPI0DQS_OUT", "Output clock"},
	{157, 87, "DEV_BOARD0_BUS_USB0REFCLKP_OUT", "Output clock"},
	{157, 88, "DEV_BOARD0_BUS_DSS0EXTPCLKIN_OUT", "Output clock"},
	{157, 89, "DEV_BOARD0_BUS_SPI1CLK_OUT", "Output clock"},
	{157, 90, "DEV_BOARD0_BUS_MCASP2ACLKR_OUT", "Output clock"},
	{157, 91, "DEV_BOARD0_BUS_MCASP1ACLKX_OUT", "Output clock"},
	{157, 92, "DEV_BOARD0_BUS_MCASP1ACLKR_OUT", "Output clock"},
	{157, 93, "DEV_BOARD0_BUS_MCASP2ACLKX_OUT", "Output clock"},
	{157, 94, "DEV_BOARD0_BUS_MCU_RMII1_REFCLK_OUT", "Output clock"},
	{157, 95, "DEV_BOARD0_BUS_MCU_CPTS_RFT_CLK_OUT", "Output clock"},
	{157, 96, "DEV_BOARD0_BUS_MCU_RGMII1_TCLK_OUT", "Output clock"},
	{157, 97, "DEV_BOARD0_BUS_MCU_SPI0CLK_OUT", "Output clock"},
	{157, 98, "DEV_BOARD0_BUS_MCU_SPI1CLK_OUT", "Output clock"},
	{157, 99, "DEV_BOARD0_BUS_PRG0_RGMII1_RCLK_OUT", "Output clock"},
	{157, 100, "DEV_BOARD0_BUS_SPI2CLK_OUT", "Output clock"},
	{157, 101, "DEV_BOARD0_BUS_WKUP_TCK_OUT", "Output clock"},
	{157, 102, "DEV_BOARD0_BUS_SPI3CLK_OUT", "Output clock"},
	{157, 103, "DEV_BOARD0_BUS_USB0REFCLKM_OUT", "Output clock"},
	{157, 104, "DEV_BOARD0_BUS_MCU_RGMII1_RCLK_OUT", "Output clock"},
	{157, 105, "DEV_BOARD0_BUS_MCASP0AHCLKR_OUT", "Output clock"},
	{157, 106, "DEV_BOARD0_BUS_MCU_EXT_REFCLK0_OUT", "Output clock"},
	{157, 107, "DEV_BOARD0_BUS_MCASP0AHCLKX_OUT", "Output clock"},
	{157, 108, "DEV_BOARD0_BUS_CCDC0_PCLK_OUT", "Output clock"},
	{157, 109, "DEV_BOARD0_HFOSC1_CLK_OUT", "Output clock"},
	{157, 110, "DEV_BOARD0_BUS_MCU_OSPI1DQS_OUT", "Output clock"},
	{157, 111, "DEV_BOARD0_BUS_MCASP1AHCLKX_OUT", "Output clock"},
	{157, 112, "DEV_BOARD0_BUS_PCIE1REFCLKM_OUT", "Output clock"},
	{157, 113, "DEV_BOARD0_BUS_MCASP1AHCLKR_OUT", "Output clock"},
	{157, 114, "DEV_BOARD0_BUS_PCIE1REFCLKP_OUT", "Output clock"},
	{157, 115, "DEV_BOARD0_BUS_PRG2_RGMII1_RCLK_OUT", "Output clock"},
	{157, 116, "DEV_BOARD0_BUS_SPI0CLK_OUT", "Output clock"},
	{157, 117, "DEV_BOARD0_BUS_MCU_HYPERBUS_CLK_IN", "Input clock"},
	{157, 118, "DEV_BOARD0_BUS_MCU_HYPERBUS_NCLK_IN", "Input clock"},
	{2, 0, "DEV_CAL0_BUS_CLK", "Input clock"},
	{2, 1, "DEV_CAL0_BUS_CP_C_CLK", "Input clock"},
	{82, 0, "DEV_CBASS0_BUS_MAIN_SYSCLK0_2_CLK", "Input clock"},
	{82, 1, "DEV_CBASS0_BUS_MAIN_SYSCLK0_4_CLK", "Input clock"},
	{83, 0, "DEV_CBASS_DEBUG0_BUS_MAIN_SYSCLK0_2_CLK", "Input clock"},
	{83, 1, "DEV_CBASS_DEBUG0_BUS_MAIN_SYSCLK0_4_CLK", "Input clock"},
	{84, 0, "DEV_CBASS_FW0_BUS_MAIN_SYSCLK0_2_CLK", "Input clock"},
	{84, 1, "DEV_CBASS_FW0_BUS_MAIN_SYSCLK0_4_CLK", "Input clock"},
	{85, 0, "DEV_CBASS_INFRA0_BUS_GTC_CLOCK_1_CLK", "Input muxed clock"},
	{85, 1, "DEV_CBASS_INFRA0_BUS_GTC_CLOCK_1_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_CBASS_INFRA0_BUS_GTC_CLOCK_1_CLK"},
	{85, 2, "DEV_CBASS_INFRA0_BUS_GTC_CLOCK_1_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_CBASS_INFRA0_BUS_GTC_CLOCK_1_CLK"},
	{85, 3, "DEV_CBASS_INFRA0_BUS_GTC_CLOCK_1_CLK_PARENT_BOARD_0_BUS_MCU_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_CBASS_INFRA0_BUS_GTC_CLOCK_1_CLK"},
	{85, 4, "DEV_CBASS_INFRA0_BUS_GTC_CLOCK_1_CLK_PARENT_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_CBASS_INFRA0_BUS_GTC_CLOCK_1_CLK"},
	{85, 5, "DEV_CBASS_INFRA0_BUS_GTC_CLOCK_1_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_CBASS_INFRA0_BUS_GTC_CLOCK_1_CLK"},
	{85, 6, "DEV_CBASS_INFRA0_BUS_GTC_CLOCK_1_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_CBASS_INFRA0_BUS_GTC_CLOCK_1_CLK"},
	{85, 7, "DEV_CBASS_INFRA0_BUS_GTC_CLOCK_1_CLK_PARENT_WIZ8B2M4VSB_MAIN_0_BUS_LN0_TXCLK", "Parent input clock option to DEV_CBASS_INFRA0_BUS_GTC_CLOCK_1_CLK"},
	{85, 8, "DEV_CBASS_INFRA0_BUS_GTC_CLOCK_1_CLK_PARENT_WIZ8B2M4VSB_MAIN_1_BUS_LN0_TXCLK", "Parent input clock option to DEV_CBASS_INFRA0_BUS_GTC_CLOCK_1_CLK"},
	{85, 9, "DEV_CBASS_INFRA0_BUS_MAIN_SYSCLK0_2_CLK", "Input clock"},
	{85, 10, "DEV_CBASS_INFRA0_BUS_MAIN_SYSCLK0_4_CLK", "Input clock"},
	{66, 0, "DEV_CCDEBUGSS0_BUS_ATB1_CLK", "Input clock"},
	{66, 1, "DEV_CCDEBUGSS0_BUS_ATB0_CLK", "Input clock"},
	{66, 2, "DEV_CCDEBUGSS0_BUS_SYS_CLK", "Input clock"},
	{66, 3, "DEV_CCDEBUGSS0_BUS_DBG_CLK", "Input clock"},
	{66, 4, "DEV_CCDEBUGSS0_BUS_CFG_CLK", "Input clock"},
	{3, 0, "DEV_CMPEVENT_INTRTR0_BUS_INTR_CLK", "Input clock"},
	{202, 0, "DEV_COMPUTE_CLUSTER_A53_0_BUS_ARM0_CLK", "Input clock"},
	{203, 0, "DEV_COMPUTE_CLUSTER_A53_1_BUS_ARM0_CLK", "Input clock"},
	{204, 0, "DEV_COMPUTE_CLUSTER_A53_2_BUS_ARM1_CLK", "Input clock"},
	{205, 0, "DEV_COMPUTE_CLUSTER_A53_3_BUS_ARM1_CLK", "Input clock"},
	{198, 0, "DEV_COMPUTE_CLUSTER_CPAC0_BUS_ARM0_CLK", "Input clock"},
	{200, 0, "DEV_COMPUTE_CLUSTER_CPAC1_BUS_ARM1_CLK", "Input clock"},
	{196, 0, "DEV_COMPUTE_CLUSTER_MSMC0_BUS_TB_SOC_VBUSP_DMSC_CLK", "Input clock"},
	{196, 1, "DEV_COMPUTE_CLUSTER_MSMC0_BUS_TB_SOC_VBUSP_DBG_CLK", "Input clock"},
	{196, 2, "DEV_COMPUTE_CLUSTER_MSMC0_BUS_MSMC_CLK", "Input clock"},
	{196, 3, "DEV_COMPUTE_CLUSTER_MSMC0_BUS_TB_SOC_VBUSP_CFG_CLK", "Input clock"},
	{196, 4, "DEV_COMPUTE_CLUSTER_MSMC0_BUS_TB_SOC_GIC_CLK", "Input clock"},
	{6, 0, "DEV_CPT2_AGGR0_BUS_VCLK_CLK", "Input clock"},
	{213, 0, "DEV_CPT2_PROBE_VBUSM_MAIN_CAL0_0_BUS_VBUS_CLK", "Input clock"},
	{213, 1, "DEV_CPT2_PROBE_VBUSM_MAIN_CAL0_0_BUS_PROBE_CLK", "Input clock"},
	{214, 0, "DEV_CPT2_PROBE_VBUSM_MAIN_DSS_2_BUS_VBUS_CLK", "Input clock"},
	{214, 1, "DEV_CPT2_PROBE_VBUSM_MAIN_DSS_2_BUS_PROBE_CLK", "Input clock"},
	{211, 0, "DEV_CPT2_PROBE_VBUSM_MAIN_NAVDDRHI_5_BUS_VBUS_CLK", "Input clock"},
	{211, 1, "DEV_CPT2_PROBE_VBUSM_MAIN_NAVDDRHI_5_BUS_PROBE_CLK", "Input clock"},
	{212, 0, "DEV_CPT2_PROBE_VBUSM_MAIN_NAVDDRLO_6_BUS_VBUS_CLK", "Input clock"},
	{212, 1, "DEV_CPT2_PROBE_VBUSM_MAIN_NAVDDRLO_6_BUS_PROBE_CLK", "Input clock"},
	{209, 0, "DEV_CPT2_PROBE_VBUSM_MAIN_NAVSRAMHI_3_BUS_VBUS_CLK", "Input clock"},
	{209, 1, "DEV_CPT2_PROBE_VBUSM_MAIN_NAVSRAMHI_3_BUS_PROBE_CLK", "Input clock"},
	{206, 0, "DEV_CPT2_PROBE_VBUSM_MAIN_NAVSRAMLO_4_BUS_VBUS_CLK", "Input clock"},
	{206, 1, "DEV_CPT2_PROBE_VBUSM_MAIN_NAVSRAMLO_4_BUS_PROBE_CLK", "Input clock"},
	{208, 0, "DEV_CPT2_PROBE_VBUSM_MCU_EXPORT_SLV_0_BUS_VBUS_CLK", "Input clock"},
	{208, 1, "DEV_CPT2_PROBE_VBUSM_MCU_EXPORT_SLV_0_BUS_PROBE_CLK", "Input clock"},
	{215, 0, "DEV_CPT2_PROBE_VBUSM_MCU_FSS_S0_2_BUS_VBUS_CLK", "Input clock"},
	{215, 1, "DEV_CPT2_PROBE_VBUSM_MCU_FSS_S0_2_BUS_PROBE_CLK", "Input clock"},
	{207, 0, "DEV_CPT2_PROBE_VBUSM_MCU_FSS_S1_3_BUS_VBUS_CLK", "Input clock"},
	{207, 1, "DEV_CPT2_PROBE_VBUSM_MCU_FSS_S1_3_BUS_PROBE_CLK", "Input clock"},
	{210, 0, "DEV_CPT2_PROBE_VBUSM_MCU_SRAM_SLV_1_BUS_VBUS_CLK", "Input clock"},
	{210, 1, "DEV_CPT2_PROBE_VBUSM_MCU_SRAM_SLV_1_BUS_PROBE_CLK", "Input clock"},
	{99, 0, "DEV_CTRL_MMR0_BUS_VBUSP_CLK", "Input clock"},
	{9, 0, "DEV_DCC0_BUS_DCC_INPUT00_CLK", "Input clock"},
	{9, 1, "DEV_DCC0_BUS_DCC_CLKSRC4_CLK", "Input clock"},
	{9, 2, "DEV_DCC0_BUS_DCC_CLKSRC3_CLK", "Input clock"},
	{9, 3, "DEV_DCC0_BUS_VBUS_CLK", "Input clock"},
	{9, 4, "DEV_DCC0_BUS_DCC_CLKSRC1_CLK", "Input clock"},
	{9, 5, "DEV_DCC0_BUS_DCC_INPUT01_CLK", "Input clock"},
	{9, 6, "DEV_DCC0_BUS_DCC_CLKSRC5_CLK", "Input clock"},
	{9, 7, "DEV_DCC0_BUS_DCC_INPUT02_CLK", "Input clock"},
	{9, 8, "DEV_DCC0_BUS_DCC_CLKSRC0_CLK", "Input clock"},
	{9, 9, "DEV_DCC0_BUS_DCC_CLKSRC6_CLK", "Input clock"},
	{9, 10, "DEV_DCC0_BUS_DCC_INPUT10_CLK", "Input clock"},
	{9, 11, "DEV_DCC0_BUS_DCC_CLKSRC2_CLK", "Input clock"},
	{10, 0, "DEV_DCC1_BUS_DCC_INPUT00_CLK", "Input clock"},
	{10, 1, "DEV_DCC1_BUS_DCC_CLKSRC7_CLK", "Input clock"},
	{10, 2, "DEV_DCC1_BUS_DCC_CLKSRC4_CLK", "Input clock"},
	{10, 3, "DEV_DCC1_BUS_DCC_CLKSRC3_CLK", "Input clock"},
	{10, 4, "DEV_DCC1_BUS_VBUS_CLK", "Input clock"},
	{10, 5, "DEV_DCC1_BUS_DCC_CLKSRC1_CLK", "Input clock"},
	{10, 6, "DEV_DCC1_BUS_DCC_INPUT01_CLK", "Input clock"},
	{10, 7, "DEV_DCC1_BUS_DCC_CLKSRC5_CLK", "Input clock"},
	{10, 8, "DEV_DCC1_BUS_DCC_INPUT02_CLK", "Input clock"},
	{10, 9, "DEV_DCC1_BUS_DCC_CLKSRC0_CLK", "Input clock"},
	{10, 10, "DEV_DCC1_BUS_DCC_CLKSRC6_CLK", "Input clock"},
	{10, 11, "DEV_DCC1_BUS_DCC_INPUT10_CLK", "Input clock"},
	{10, 12, "DEV_DCC1_BUS_DCC_CLKSRC2_CLK", "Input clock"},
	{11, 0, "DEV_DCC2_BUS_DCC_INPUT00_CLK", "Input clock"},
	{11, 1, "DEV_DCC2_BUS_DCC_CLKSRC7_CLK", "Input clock"},
	{11, 2, "DEV_DCC2_BUS_DCC_CLKSRC4_CLK", "Input clock"},
	{11, 3, "DEV_DCC2_BUS_DCC_CLKSRC3_CLK", "Input clock"},
	{11, 4, "DEV_DCC2_BUS_VBUS_CLK", "Input clock"},
	{11, 5, "DEV_DCC2_BUS_DCC_CLKSRC1_CLK", "Input clock"},
	{11, 6, "DEV_DCC2_BUS_DCC_INPUT01_CLK", "Input clock"},
	{11, 7, "DEV_DCC2_BUS_DCC_CLKSRC5_CLK", "Input clock"},
	{11, 8, "DEV_DCC2_BUS_DCC_INPUT02_CLK", "Input clock"},
	{11, 9, "DEV_DCC2_BUS_DCC_CLKSRC0_CLK", "Input clock"},
	{11, 10, "DEV_DCC2_BUS_DCC_CLKSRC6_CLK", "Input clock"},
	{11, 11, "DEV_DCC2_BUS_DCC_INPUT10_CLK", "Input clock"},
	{11, 12, "DEV_DCC2_BUS_DCC_CLKSRC2_CLK", "Input clock"},
	{12, 0, "DEV_DCC3_BUS_DCC_INPUT00_CLK", "Input clock"},
	{12, 1, "DEV_DCC3_BUS_DCC_CLKSRC7_CLK", "Input clock"},
	{12, 2, "DEV_DCC3_BUS_DCC_CLKSRC4_CLK", "Input clock"},
	{12, 3, "DEV_DCC3_BUS_DCC_CLKSRC3_CLK", "Input clock"},
	{12, 4, "DEV_DCC3_BUS_VBUS_CLK", "Input clock"},
	{12, 5, "DEV_DCC3_BUS_DCC_CLKSRC1_CLK", "Input clock"},
	{12, 6, "DEV_DCC3_BUS_DCC_INPUT01_CLK", "Input clock"},
	{12, 7, "DEV_DCC3_BUS_DCC_CLKSRC5_CLK", "Input clock"},
	{12, 8, "DEV_DCC3_BUS_DCC_INPUT02_CLK", "Input clock"},
	{12, 9, "DEV_DCC3_BUS_DCC_CLKSRC0_CLK", "Input clock"},
	{12, 10, "DEV_DCC3_BUS_DCC_INPUT10_CLK", "Input clock"},
	{12, 11, "DEV_DCC3_BUS_DCC_CLKSRC2_CLK", "Input clock"},
	{13, 0, "DEV_DCC4_BUS_DCC_INPUT00_CLK", "Input clock"},
	{13, 1, "DEV_DCC4_BUS_DCC_CLKSRC7_CLK", "Input clock"},
	{13, 2, "DEV_DCC4_BUS_DCC_CLKSRC4_CLK", "Input clock"},
	{13, 3, "DEV_DCC4_BUS_DCC_CLKSRC3_CLK", "Input clock"},
	{13, 4, "DEV_DCC4_BUS_VBUS_CLK", "Input clock"},
	{13, 5, "DEV_DCC4_BUS_DCC_INPUT01_CLK", "Input clock"},
	{13, 6, "DEV_DCC4_BUS_DCC_CLKSRC5_CLK", "Input clock"},
	{13, 7, "DEV_DCC4_BUS_DCC_INPUT02_CLK", "Input clock"},
	{13, 8, "DEV_DCC4_BUS_DCC_CLKSRC0_CLK", "Input clock"},
	{13, 9, "DEV_DCC4_BUS_DCC_CLKSRC6_CLK", "Input clock"},
	{13, 10, "DEV_DCC4_BUS_DCC_INPUT10_CLK", "Input clock"},
	{13, 11, "DEV_DCC4_BUS_DCC_CLKSRC2_CLK", "Input clock"},
	{14, 0, "DEV_DCC5_BUS_DCC_INPUT00_CLK", "Input clock"},
	{14, 1, "DEV_DCC5_BUS_DCC_CLKSRC7_CLK", "Input clock"},
	{14, 2, "DEV_DCC5_BUS_DCC_CLKSRC4_CLK", "Input clock"},
	{14, 3, "DEV_DCC5_BUS_DCC_CLKSRC3_CLK", "Input clock"},
	{14, 4, "DEV_DCC5_BUS_VBUS_CLK", "Input clock"},
	{14, 5, "DEV_DCC5_BUS_DCC_CLKSRC1_CLK", "Input clock"},
	{14, 6, "DEV_DCC5_BUS_DCC_INPUT01_CLK", "Input clock"},
	{14, 7, "DEV_DCC5_BUS_DCC_CLKSRC5_CLK", "Input clock"},
	{14, 8, "DEV_DCC5_BUS_DCC_INPUT02_CLK", "Input clock"},
	{14, 9, "DEV_DCC5_BUS_DCC_CLKSRC0_CLK", "Input clock"},
	{14, 10, "DEV_DCC5_BUS_DCC_CLKSRC6_CLK", "Input clock"},
	{14, 11, "DEV_DCC5_BUS_DCC_INPUT10_CLK", "Input clock"},
	{14, 12, "DEV_DCC5_BUS_DCC_CLKSRC2_CLK", "Input clock"},
	{15, 0, "DEV_DCC6_BUS_DCC_INPUT00_CLK", "Input clock"},
	{15, 1, "DEV_DCC6_BUS_DCC_CLKSRC7_CLK", "Input clock"},
	{15, 2, "DEV_DCC6_BUS_DCC_CLKSRC4_CLK", "Input clock"},
	{15, 3, "DEV_DCC6_BUS_DCC_CLKSRC3_CLK", "Input clock"},
	{15, 4, "DEV_DCC6_BUS_VBUS_CLK", "Input clock"},
	{15, 5, "DEV_DCC6_BUS_DCC_CLKSRC1_CLK", "Input clock"},
	{15, 6, "DEV_DCC6_BUS_DCC_INPUT01_CLK", "Input clock"},
	{15, 7, "DEV_DCC6_BUS_DCC_CLKSRC5_CLK", "Input clock"},
	{15, 8, "DEV_DCC6_BUS_DCC_INPUT02_CLK", "Input clock"},
	{15, 9, "DEV_DCC6_BUS_DCC_CLKSRC0_CLK", "Input clock"},
	{15, 10, "DEV_DCC6_BUS_DCC_CLKSRC6_CLK", "Input clock"},
	{15, 11, "DEV_DCC6_BUS_DCC_INPUT10_CLK", "Input clock"},
	{15, 12, "DEV_DCC6_BUS_DCC_CLKSRC2_CLK", "Input clock"},
	{16, 0, "DEV_DCC7_BUS_DCC_INPUT00_CLK", "Input clock"},
	{16, 1, "DEV_DCC7_BUS_DCC_CLKSRC7_CLK", "Input clock"},
	{16, 2, "DEV_DCC7_BUS_DCC_CLKSRC4_CLK", "Input clock"},
	{16, 3, "DEV_DCC7_BUS_DCC_CLKSRC3_CLK", "Input clock"},
	{16, 4, "DEV_DCC7_BUS_VBUS_CLK", "Input clock"},
	{16, 5, "DEV_DCC7_BUS_DCC_CLKSRC1_CLK", "Input clock"},
	{16, 6, "DEV_DCC7_BUS_DCC_INPUT01_CLK", "Input clock"},
	{16, 7, "DEV_DCC7_BUS_DCC_CLKSRC5_CLK", "Input clock"},
	{16, 8, "DEV_DCC7_BUS_DCC_INPUT02_CLK", "Input clock"},
	{16, 9, "DEV_DCC7_BUS_DCC_CLKSRC0_CLK", "Input clock"},
	{16, 10, "DEV_DCC7_BUS_DCC_CLKSRC6_CLK", "Input clock"},
	{16, 11, "DEV_DCC7_BUS_DCC_INPUT10_CLK", "Input clock"},
	{16, 12, "DEV_DCC7_BUS_DCC_CLKSRC2_CLK", "Input clock"},
	{20, 0, "DEV_DDRSS0_BUS_DDRSS_VBUS_CLK", "Input clock"},
	{20, 1, "DEV_DDRSS0_BUS_DDRSS_BYP_4X_CLK", "Input clock"},
	{20, 2, "DEV_DDRSS0_BUS_DDRSS_CTL_CLK_BUS_IN1_ADPLLLJM_WRAP_MAIN_3_BUS_CLKOUT_CLK", "Input clock"},
	{20, 3, "DEV_DDRSS0_BUS_DDRSS_TCLK", "Input clock"},
	{20, 4, "DEV_DDRSS0_BUS_DDRSS_PHY_CTL_CLK_BUS_IN1_ADPLLLJM_WRAP_MAIN_3_BUS_CLKOUT_CLK", "Input clock"},
	{20, 5, "DEV_DDRSS0_BUS_DDRSS_PHY_CTL_CLK_BUS_IN0_ADPLLLJM_WRAP_MAIN_3_BUS_CLKOUT_CLK", "Input clock"},
	{20, 6, "DEV_DDRSS0_BUS_DDRSS_CFG_CLK", "Input clock"},
	{20, 7, "DEV_DDRSS0_BUS_DDRSS_CTL_CLK_BUS_IN0_ADPLLLJM_WRAP_MAIN_3_BUS_CLKOUT_CLK", "Input clock"},
	{20, 8, "DEV_DDRSS0_BUS_DDRSS_BYP_CLK_BUS_IN1_ADPLLLJM_WRAP_MAIN_3_BUS_CLKOUT_CLK", "Input clock"},
	{20, 9, "DEV_DDRSS0_BUS_DDRSS_BYP_CLK_BUS_IN0_ADPLLLJM_WRAP_MAIN_3_BUS_CLKOUT_CLK", "Input clock"},
	{68, 0, "DEV_DEBUGSS0_BUS_ATB1_CLK", "Input clock"},
	{68, 1, "DEV_DEBUGSS0_BUS_ATB5_CLK", "Input clock"},
	{68, 2, "DEV_DEBUGSS0_BUS_ATB0_CLK", "Input clock"},
	{68, 3, "DEV_DEBUGSS0_BUS_SYS_CLK", "Input clock"},
	{68, 4, "DEV_DEBUGSS0_BUS_ATB4_CLK", "Input clock"},
	{68, 5, "DEV_DEBUGSS0_BUS_CFG_CLK", "Input clock"},
	{68, 6, "DEV_DEBUGSS0_BUS_ATB2_CLK", "Input clock"},
	{68, 7, "DEV_DEBUGSS0_BUS_DBG_CLK", "Input clock"},
	{68, 8, "DEV_DEBUGSS0_BUS_ATB3_CLK", "Input clock"},
	{21, 0, "DEV_DEBUGSS_WRAP0_BUS_JTAG_TCK", "Input clock"},
	{21, 1, "DEV_DEBUGSS_WRAP0_BUS_ATB_CLK", "Input clock"},
	{21, 2, "DEV_DEBUGSS_WRAP0_BUS_TREXPT_CLK", "Input clock"},
	{21, 3, "DEV_DEBUGSS_WRAP0_BUS_CORE_CLK", "Input clock"},
	{81, 0, "DEV_DEBUGSUSPENDRTR0_BUS_INTR_CLK", "Input clock"},
	{117, 0, "DEV_DFTSS0_BUS_VBUSP_CLK_CLK", "Input clock"},
	{67, 0, "DEV_DSS0_BUS_DPI_0_IN_CLK_BUS_IN1_CLOCKDIVIDER_DSS_BUS_OUT0", "Input clock"},
	{67, 1, "DEV_DSS0_BUS_DSS_FUNC_CLK", "Input clock"},
	{67, 2, "DEV_DSS0_BUS_DPI_1_IN_CLK", "Input muxed clock"},
	{67, 3, "DEV_DSS0_BUS_DPI_1_IN_CLK_PARENT_CLOCKDIVIDER_DSS_BUS_OUT07", "Parent input clock option to DEV_DSS0_BUS_DPI_1_IN_CLK"},
	{67, 4, "DEV_DSS0_BUS_DPI_1_IN_CLK_PARENT_BOARD_0_BUS_DSS0EXTPCLKIN_OUT", "Parent input clock option to DEV_DSS0_BUS_DPI_1_IN_CLK"},
	{67, 5, "DEV_DSS0_BUS_DPI_1_IN_CLK_PARENT_CLOCKDIVIDER_DSS_BUS_OUT1", "Parent input clock option to DEV_DSS0_BUS_DPI_1_IN_CLK"},
	{67, 6, "DEV_DSS0_BUS_DPI_0_IN_CLK_BUS_IN0_CLOCKDIVIDER_DSS_BUS_OUT0", "Input clock"},
	{67, 7, "DEV_DSS0_BUS_DPI_1_OUT_CLK", "Output clock"},
	{39, 0, "DEV_ECAP0_BUS_VBUS_CLK", "Input clock"},
	{86, 0, "DEV_ECC_AGGR0_BUS_AGGR_CLK", "Input clock"},
	{87, 0, "DEV_ECC_AGGR1_BUS_AGGR_CLK", "Input clock"},
	{88, 0, "DEV_ECC_AGGR2_BUS_AGGR_CLK", "Input clock"},
	{69, 0, "DEV_EFUSE0_BUS_VBUSP_PLL_CLK_CLK", "Input clock"},
	{69, 1, "DEV_EFUSE0_BUS_EFC1_CTL_FCLK", "Output clock"},
	{69, 2, "DEV_EFUSE0_BUS_EFC0_CTL_FCLK", "Output clock"},
	{40, 0, "DEV_EHRPWM0_BUS_VBUSP_CLK", "Input clock"},
	{41, 0, "DEV_EHRPWM1_BUS_VBUSP_CLK", "Input clock"},
	{42, 0, "DEV_EHRPWM2_BUS_VBUSP_CLK", "Input clock"},
	{43, 0, "DEV_EHRPWM3_BUS_VBUSP_CLK", "Input clock"},
	{44, 0, "DEV_EHRPWM4_BUS_VBUSP_CLK", "Input clock"},
	{45, 0, "DEV_EHRPWM5_BUS_VBUSP_CLK", "Input clock"},
	{46, 0, "DEV_ELM0_BUS_VBUSP_CLK", "Input clock"},
	{49, 0, "DEV_EQEP0_BUS_VBUS_CLK", "Input clock"},
	{50, 0, "DEV_EQEP1_BUS_VBUS_CLK", "Input clock"},
	{51, 0, "DEV_EQEP2_BUS_VBUS_CLK", "Input clock"},
	{52, 0, "DEV_ESM0_BUS_CLK", "Input clock"},
	{56, 0, "DEV_GIC0_BUS_VCLK_CLK", "Input clock"},
	{57, 0, "DEV_GPIO0_BUS_MMR_CLK", "Input clock"},
	{58, 0, "DEV_GPIO1_BUS_MMR_CLK", "Input clock"},
	{100, 0, "DEV_GPIOMUX_INTRTR0_BUS_INTR_CLK", "Input clock"},
	{60, 0, "DEV_GPMC0_BUS_FUNC_CLK", "Input muxed clock"},
	{60, 1, "DEV_GPMC0_BUS_FUNC_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_GPMC0_BUS_FUNC_CLK"},
	{60, 2, "DEV_GPMC0_BUS_FUNC_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_CLKOUT_CLK3", "Parent input clock option to DEV_GPMC0_BUS_FUNC_CLK"},
	{60, 3, "DEV_GPMC0_BUS_FUNC_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_CLKOUT_CLK2", "Parent input clock option to DEV_GPMC0_BUS_FUNC_CLK"},
	{60, 4, "DEV_GPMC0_BUS_FUNC_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_BUS_CHIP_DIV1_CLK_CLK4", "Parent input clock option to DEV_GPMC0_BUS_FUNC_CLK"},
	{60, 5, "DEV_GPMC0_BUS_PI_GPMC_RET_CLK", "Input clock"},
	{60, 6, "DEV_GPMC0_BUS_VBUSP_CLK", "Input clock"},
	{60, 7, "DEV_GPMC0_BUS_PO_GPMC_DEV_CLK", "Output clock"},
	{65, 0, "DEV_GPU0_BUS_MEM_CLK", "Input clock"},
	{65, 1, "DEV_GPU0_BUS_HYD_CORE_CLK", "Input clock"},
	{65, 2, "DEV_GPU0_BUS_SGX_CORE_CLK", "Input clock"},
	{65, 3, "DEV_GPU0_BUS_SYS_CLK", "Input clock"},
	{232, 0, "DEV_GS80PRG_MCU_WRAP_WKUP_0_BUS_OSC_CLK", "Input clock"},
	{232, 1, "DEV_GS80PRG_MCU_WRAP_WKUP_0_BUS_CLK", "Input clock"},
	{231, 0, "DEV_GS80PRG_SOC_WRAP_WKUP_0_BUS_OSC_CLK", "Input clock"},
	{231, 1, "DEV_GS80PRG_SOC_WRAP_WKUP_0_BUS_CLK", "Input clock"},
	{61, 0, "DEV_GTC0_BUS_VBUSP_CLK", "Input muxed clock"},
	{61, 1, "DEV_GTC0_BUS_VBUSP_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_GTC0_BUS_VBUSP_CLK"},
	{61, 2, "DEV_GTC0_BUS_VBUSP_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_GTC0_BUS_VBUSP_CLK"},
	{61, 3, "DEV_GTC0_BUS_VBUSP_CLK_PARENT_BOARD_0_BUS_MCU_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_GTC0_BUS_VBUSP_CLK"},
	{61, 4, "DEV_GTC0_BUS_VBUSP_CLK_PARENT_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_GTC0_BUS_VBUSP_CLK"},
	{61, 5, "DEV_GTC0_BUS_VBUSP_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_GTC0_BUS_VBUSP_CLK"},
	{61, 6, "DEV_GTC0_BUS_VBUSP_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_GTC0_BUS_VBUSP_CLK"},
	{61, 7, "DEV_GTC0_BUS_VBUSP_CLK_PARENT_WIZ8B2M4VSB_MAIN_0_BUS_LN0_TXCLK", "Parent input clock option to DEV_GTC0_BUS_VBUSP_CLK"},
	{61, 8, "DEV_GTC0_BUS_VBUSP_CLK_PARENT_WIZ8B2M4VSB_MAIN_1_BUS_LN0_TXCLK", "Parent input clock option to DEV_GTC0_BUS_VBUSP_CLK"},
	{110, 0, "DEV_I2C0_BUS_CLK", "Input clock"},
	{110, 1, "DEV_I2C0_BUS_PISYS_CLK", "Input clock"},
	{110, 2, "DEV_I2C0_BUS_PISCL", "Output clock"},
	{111, 0, "DEV_I2C1_BUS_CLK", "Input clock"},
	{111, 1, "DEV_I2C1_BUS_PISYS_CLK", "Input clock"},
	{111, 2, "DEV_I2C1_BUS_PISCL", "Output clock"},
	{112, 0, "DEV_I2C2_BUS_CLK", "Input clock"},
	{112, 1, "DEV_I2C2_BUS_PISYS_CLK", "Input clock"},
	{112, 2, "DEV_I2C2_BUS_PISCL", "Output clock"},
	{113, 0, "DEV_I2C3_BUS_CLK", "Input clock"},
	{113, 1, "DEV_I2C3_BUS_PISYS_CLK", "Input clock"},
	{113, 2, "DEV_I2C3_BUS_PISCL", "Output clock"},
	{217, 0, "DEV_K3_ARM_ATB_FUNNEL_3_32_MCU_0_BUS_DBG_CLK", "Input clock"},
	{97, 0, "DEV_MAIN2MCU_LVL_INTRTR0_BUS_INTR_CLK", "Input clock"},
	{98, 0, "DEV_MAIN2MCU_PLS_INTRTR0_BUS_INTR_CLK", "Input clock"},
	{104, 0, "DEV_MCASP0_BUS_AUX_CLK", "Input muxed clock"},
	{104, 1, "DEV_MCASP0_BUS_AUX_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP0_BUS_AUX_CLK"},
	{104, 2, "DEV_MCASP0_BUS_AUX_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_MCASP0_BUS_AUX_CLK"},
	{104, 3, "DEV_MCASP0_BUS_AUX_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP0_BUS_AUX_CLK"},
	{104, 4, "DEV_MCASP0_BUS_AUX_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_MCASP0_BUS_AUX_CLK"},
	{104, 5, "DEV_MCASP0_BUS_AUX_CLK_PARENT_CLOCKDIVIDER_MCASP_ARM1_PLL_DIV_BUS_OUT0", "Parent input clock option to DEV_MCASP0_BUS_AUX_CLK"},
	{104, 6, "DEV_MCASP0_BUS_AUX_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP0_BUS_AUX_CLK"},
	{104, 7, "DEV_MCASP0_BUS_AUX_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_MCASP0_BUS_AUX_CLK"},
	{104, 8, "DEV_MCASP0_BUS_AUX_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_MCASP0_BUS_AUX_CLK"},
	{104, 9, "DEV_MCASP0_BUS_VBUSP_CLK", "Input clock"},
	{104, 10, "DEV_MCASP0_BUS_MCASP_AHCLKX_PIN", "Input clock"},
	{104, 11, "DEV_MCASP0_BUS_MCASP_AHCLKR_PIN", "Input clock"},
	{105, 0, "DEV_MCASP1_BUS_AUX_CLK", "Input muxed clock"},
	{105, 1, "DEV_MCASP1_BUS_AUX_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP1_BUS_AUX_CLK"},
	{105, 2, "DEV_MCASP1_BUS_AUX_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_MCASP1_BUS_AUX_CLK"},
	{105, 3, "DEV_MCASP1_BUS_AUX_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP1_BUS_AUX_CLK"},
	{105, 4, "DEV_MCASP1_BUS_AUX_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_MCASP1_BUS_AUX_CLK"},
	{105, 5, "DEV_MCASP1_BUS_AUX_CLK_PARENT_CLOCKDIVIDER_MCASP_ARM1_PLL_DIV_BUS_OUT1", "Parent input clock option to DEV_MCASP1_BUS_AUX_CLK"},
	{105, 6, "DEV_MCASP1_BUS_AUX_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP1_BUS_AUX_CLK"},
	{105, 7, "DEV_MCASP1_BUS_AUX_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_MCASP1_BUS_AUX_CLK"},
	{105, 8, "DEV_MCASP1_BUS_AUX_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_MCASP1_BUS_AUX_CLK"},
	{105, 9, "DEV_MCASP1_BUS_VBUSP_CLK", "Input clock"},
	{105, 10, "DEV_MCASP1_BUS_MCASP_AHCLKX_PIN", "Input clock"},
	{105, 11, "DEV_MCASP1_BUS_MCASP_AHCLKR_PIN", "Input clock"},
	{106, 0, "DEV_MCASP2_BUS_AUX_CLK", "Input muxed clock"},
	{106, 1, "DEV_MCASP2_BUS_AUX_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_MCASP2_BUS_AUX_CLK"},
	{106, 2, "DEV_MCASP2_BUS_AUX_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_MCASP2_BUS_AUX_CLK"},
	{106, 3, "DEV_MCASP2_BUS_AUX_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCASP2_BUS_AUX_CLK"},
	{106, 4, "DEV_MCASP2_BUS_AUX_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_MCASP2_BUS_AUX_CLK"},
	{106, 5, "DEV_MCASP2_BUS_AUX_CLK_PARENT_CLOCKDIVIDER_MCASP_ARM1_PLL_DIV_BUS_OUT2", "Parent input clock option to DEV_MCASP2_BUS_AUX_CLK"},
	{106, 6, "DEV_MCASP2_BUS_AUX_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCASP2_BUS_AUX_CLK"},
	{106, 7, "DEV_MCASP2_BUS_AUX_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_MCASP2_BUS_AUX_CLK"},
	{106, 8, "DEV_MCASP2_BUS_AUX_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_MCASP2_BUS_AUX_CLK"},
	{106, 9, "DEV_MCASP2_BUS_VBUSP_CLK", "Input clock"},
	{106, 10, "DEV_MCASP2_BUS_MCASP_AHCLKX_PIN", "Input clock"},
	{106, 11, "DEV_MCASP2_BUS_MCASP_AHCLKR_PIN", "Input clock"},
	{137, 0, "DEV_MCSPI0_BUS_IO_CLKSPII_CLK", "Input clock"},
	{137, 1, "DEV_MCSPI0_BUS_CLKSPIREF_CLK", "Input clock"},
	{137, 2, "DEV_MCSPI0_BUS_VBUSP_CLK", "Input clock"},
	{137, 3, "DEV_MCSPI0_BUS_IO_CLKSPIO_CLK", "Output clock"},
	{138, 0, "DEV_MCSPI1_BUS_IO_CLKSPII_CLK", "Input clock"},
	{138, 1, "DEV_MCSPI1_BUS_CLKSPIREF_CLK", "Input clock"},
	{138, 2, "DEV_MCSPI1_BUS_VBUSP_CLK", "Input clock"},
	{138, 3, "DEV_MCSPI1_BUS_IO_CLKSPIO_CLK", "Output clock"},
	{139, 0, "DEV_MCSPI2_BUS_IO_CLKSPII_CLK", "Input clock"},
	{139, 1, "DEV_MCSPI2_BUS_CLKSPIREF_CLK", "Input clock"},
	{139, 2, "DEV_MCSPI2_BUS_VBUSP_CLK", "Input clock"},
	{139, 3, "DEV_MCSPI2_BUS_IO_CLKSPIO_CLK", "Output clock"},
	{140, 0, "DEV_MCSPI3_BUS_IO_CLKSPII_CLK", "Input clock"},
	{140, 1, "DEV_MCSPI3_BUS_CLKSPIREF_CLK", "Input clock"},
	{140, 2, "DEV_MCSPI3_BUS_VBUSP_CLK", "Input clock"},
	{140, 3, "DEV_MCSPI3_BUS_IO_CLKSPIO_CLK", "Output clock"},
	{141, 0, "DEV_MCSPI4_BUS_CLKSPIREF_CLK", "Input clock"},
	{141, 1, "DEV_MCSPI4_BUS_VBUSP_CLK", "Input clock"},
	{0, 0, "DEV_MCU_ADC0_BUS_VBUS_CLK", "Input clock"},
	{0, 1, "DEV_MCU_ADC0_BUS_SYS_CLK", "Input clock"},
	{0, 2, "DEV_MCU_ADC0_BUS_ADC_CLK", "Input muxed clock"},
	{0, 3, "DEV_MCU_ADC0_BUS_ADC_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_MCU_ADC0_BUS_ADC_CLK"},
	{0, 4, "DEV_MCU_ADC0_BUS_ADC_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_0_BUS_HSDIV_CLKOUT1_CLK", "Parent input clock option to DEV_MCU_ADC0_BUS_ADC_CLK"},
	{0, 5, "DEV_MCU_ADC0_BUS_ADC_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_MCU_ADC0_BUS_ADC_CLK"},
	{0, 6, "DEV_MCU_ADC0_BUS_ADC_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_ADC0_BUS_ADC_CLK"},
	{1, 0, "DEV_MCU_ADC1_BUS_VBUS_CLK", "Input clock"},
	{1, 1, "DEV_MCU_ADC1_BUS_SYS_CLK", "Input clock"},
	{1, 2, "DEV_MCU_ADC1_BUS_ADC_CLK", "Input muxed clock"},
	{1, 3, "DEV_MCU_ADC1_BUS_ADC_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_MCU_ADC1_BUS_ADC_CLK"},
	{1, 4, "DEV_MCU_ADC1_BUS_ADC_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_0_BUS_HSDIV_CLKOUT1_CLK", "Parent input clock option to DEV_MCU_ADC1_BUS_ADC_CLK"},
	{1, 5, "DEV_MCU_ADC1_BUS_ADC_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_MCU_ADC1_BUS_ADC_CLK"},
	{1, 6, "DEV_MCU_ADC1_BUS_ADC_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_ADC1_BUS_ADC_CLK"},
	{129, 0, "DEV_MCU_ARMSS0_BUS_INTERFACE_CLK", "Input clock"},
	{159, 0, "DEV_MCU_ARMSS0_CPU0_BUS_INTERFACE_CLK", "Input clock"},
	{159, 1, "DEV_MCU_ARMSS0_CPU0_BUS_INTERFACE_PHASE", "Input muxed clock"},
	{159, 2, "DEV_MCU_ARMSS0_CPU0_BUS_INTERFACE_PHASE_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_BUS_CHIP_DIV1_CLK_CLK2", "Parent input clock option to DEV_MCU_ARMSS0_CPU0_BUS_INTERFACE_PHASE"},
	{159, 3, "DEV_MCU_ARMSS0_CPU0_BUS_CPU_CLK", "Input muxed clock"},
	{159, 4, "DEV_MCU_ARMSS0_CPU0_BUS_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_BUS_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_MCU_ARMSS0_CPU0_BUS_CPU_CLK"},
	{159, 5, "DEV_MCU_ARMSS0_CPU0_BUS_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_BUS_CHIP_DIV1_CLK_CLK2", "Parent input clock option to DEV_MCU_ARMSS0_CPU0_BUS_CPU_CLK"},
	{245, 0, "DEV_MCU_ARMSS0_CPU1_BUS_INTERFACE_CLK", "Input clock"},
	{245, 1, "DEV_MCU_ARMSS0_CPU1_BUS_INTERFACE_PHASE", "Input muxed clock"},
	{245, 2, "DEV_MCU_ARMSS0_CPU1_BUS_INTERFACE_PHASE_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_BUS_CHIP_DIV1_CLK_CLK2", "Parent input clock option to DEV_MCU_ARMSS0_CPU1_BUS_INTERFACE_PHASE"},
	{245, 3, "DEV_MCU_ARMSS0_CPU1_BUS_CPU_CLK", "Input muxed clock"},
	{245, 4, "DEV_MCU_ARMSS0_CPU1_BUS_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_BUS_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_MCU_ARMSS0_CPU1_BUS_CPU_CLK"},
	{245, 5, "DEV_MCU_ARMSS0_CPU1_BUS_CPU_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_BUS_CHIP_DIV1_CLK_CLK2", "Parent input clock option to DEV_MCU_ARMSS0_CPU1_BUS_CPU_CLK"},
	{89, 0, "DEV_MCU_CBASS0_BUS_MCU_SYSCLK0_8_CLK", "Input clock"},
	{89, 1, "DEV_MCU_CBASS0_BUS_MCU_SYSCLK0_4_CLK", "Input clock"},
	{89, 2, "DEV_MCU_CBASS0_BUS_MCU_SYSCLK0_2_CLK", "Input clock"},
	{90, 0, "DEV_MCU_CBASS_DEBUG0_BUS_MCU_SYSCLK0_2_CLK", "Input clock"},
	{91, 0, "DEV_MCU_CBASS_FW0_BUS_MCU_SYSCLK0_4_CLK", "Input clock"},
	{91, 1, "DEV_MCU_CBASS_FW0_BUS_MCU_SYSCLK0_2_CLK", "Input clock"},
	{5, 0, "DEV_MCU_CPSW0_BUS_GMII1_MR_CLK", "Input clock"},
	{5, 1, "DEV_MCU_CPSW0_BUS_RGMII_MHZ_250_CLK", "Input clock"},
	{5, 2, "DEV_MCU_CPSW0_BUS_CPTS_RFT_CLK", "Input clock"},
	{5, 3, "DEV_MCU_CPSW0_BUS_GMII1_MT_CLK", "Input clock"},
	{5, 4, "DEV_MCU_CPSW0_BUS_RGMII_MHZ_5_CLK", "Input clock"},
	{5, 5, "DEV_MCU_CPSW0_BUS_RGMII_MHZ_50_CLK", "Input clock"},
	{5, 6, "DEV_MCU_CPSW0_BUS_RMII_MHZ_50_CLK", "Input muxed clock"},
	{5, 7, "DEV_MCU_CPSW0_BUS_RMII_MHZ_50_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_CLKOUT_CLK5", "Parent input clock option to DEV_MCU_CPSW0_BUS_RMII_MHZ_50_CLK"},
	{5, 8, "DEV_MCU_CPSW0_BUS_RMII_MHZ_50_CLK_PARENT_BOARD_0_BUS_MCU_RMII1_REFCLK_OUT", "Parent input clock option to DEV_MCU_CPSW0_BUS_RMII_MHZ_50_CLK"},
	{5, 9, "DEV_MCU_CPSW0_BUS_GMII_RFT_CLK", "Input clock"},
	{5, 10, "DEV_MCU_CPSW0_BUS_CPPI_CLK_CLK", "Input clock"},
	{5, 11, "DEV_MCU_CPSW0_BUS_CPTS_GENF0_0", "Output clock"},
	{7, 0, "DEV_MCU_CPT2_AGGR0_BUS_VCLK_CLK", "Input clock"},
	{107, 0, "DEV_MCU_CTRL_MMR0_BUS_VBUSP_CLK", "Input clock"},
	{17, 0, "DEV_MCU_DCC0_BUS_DCC_INPUT00_CLK", "Input clock"},
	{17, 1, "DEV_MCU_DCC0_BUS_DCC_CLKSRC7_CLK", "Input clock"},
	{17, 2, "DEV_MCU_DCC0_BUS_DCC_CLKSRC4_CLK", "Input clock"},
	{17, 3, "DEV_MCU_DCC0_BUS_DCC_CLKSRC3_CLK", "Input clock"},
	{17, 4, "DEV_MCU_DCC0_BUS_VBUS_CLK", "Input clock"},
	{17, 5, "DEV_MCU_DCC0_BUS_DCC_CLKSRC1_CLK", "Input clock"},
	{17, 6, "DEV_MCU_DCC0_BUS_DCC_INPUT01_CLK", "Input clock"},
	{17, 7, "DEV_MCU_DCC0_BUS_DCC_CLKSRC5_CLK", "Input clock"},
	{17, 8, "DEV_MCU_DCC0_BUS_DCC_INPUT02_CLK", "Input clock"},
	{17, 9, "DEV_MCU_DCC0_BUS_DCC_CLKSRC0_CLK", "Input clock"},
	{17, 10, "DEV_MCU_DCC0_BUS_DCC_CLKSRC6_CLK", "Input clock"},
	{17, 11, "DEV_MCU_DCC0_BUS_DCC_INPUT10_CLK", "Input clock"},
	{17, 12, "DEV_MCU_DCC0_BUS_DCC_CLKSRC2_CLK", "Input clock"},
	{18, 0, "DEV_MCU_DCC1_BUS_DCC_INPUT00_CLK", "Input clock"},
	{18, 1, "DEV_MCU_DCC1_BUS_DCC_CLKSRC7_CLK", "Input clock"},
	{18, 2, "DEV_MCU_DCC1_BUS_DCC_CLKSRC4_CLK", "Input clock"},
	{18, 3, "DEV_MCU_DCC1_BUS_DCC_CLKSRC3_CLK", "Input clock"},
	{18, 4, "DEV_MCU_DCC1_BUS_VBUS_CLK", "Input clock"},
	{18, 5, "DEV_MCU_DCC1_BUS_DCC_CLKSRC1_CLK", "Input clock"},
	{18, 6, "DEV_MCU_DCC1_BUS_DCC_INPUT01_CLK", "Input clock"},
	{18, 7, "DEV_MCU_DCC1_BUS_DCC_CLKSRC5_CLK", "Input clock"},
	{18, 8, "DEV_MCU_DCC1_BUS_DCC_INPUT02_CLK", "Input clock"},
	{18, 9, "DEV_MCU_DCC1_BUS_DCC_CLKSRC0_CLK", "Input clock"},
	{18, 10, "DEV_MCU_DCC1_BUS_DCC_CLKSRC6_CLK", "Input clock"},
	{18, 11, "DEV_MCU_DCC1_BUS_DCC_INPUT10_CLK", "Input clock"},
	{18, 12, "DEV_MCU_DCC1_BUS_DCC_CLKSRC2_CLK", "Input clock"},
	{19, 0, "DEV_MCU_DCC2_BUS_DCC_INPUT00_CLK", "Input clock"},
	{19, 1, "DEV_MCU_DCC2_BUS_DCC_CLKSRC7_CLK", "Input clock"},
	{19, 2, "DEV_MCU_DCC2_BUS_DCC_CLKSRC4_CLK", "Input clock"},
	{19, 3, "DEV_MCU_DCC2_BUS_DCC_CLKSRC3_CLK", "Input clock"},
	{19, 4, "DEV_MCU_DCC2_BUS_VBUS_CLK", "Input clock"},
	{19, 5, "DEV_MCU_DCC2_BUS_DCC_CLKSRC1_CLK", "Input clock"},
	{19, 6, "DEV_MCU_DCC2_BUS_DCC_INPUT01_CLK", "Input clock"},
	{19, 7, "DEV_MCU_DCC2_BUS_DCC_CLKSRC5_CLK", "Input clock"},
	{19, 8, "DEV_MCU_DCC2_BUS_DCC_INPUT02_CLK", "Input clock"},
	{19, 9, "DEV_MCU_DCC2_BUS_DCC_CLKSRC0_CLK", "Input clock"},
	{19, 10, "DEV_MCU_DCC2_BUS_DCC_CLKSRC6_CLK", "Input clock"},
	{19, 11, "DEV_MCU_DCC2_BUS_DCC_INPUT10_CLK", "Input clock"},
	{19, 12, "DEV_MCU_DCC2_BUS_DCC_CLKSRC2_CLK", "Input clock"},
	{71, 0, "DEV_MCU_DEBUGSS0_BUS_ATB1_CLK", "Input clock"},
	{71, 1, "DEV_MCU_DEBUGSS0_BUS_ATB0_CLK", "Input clock"},
	{71, 2, "DEV_MCU_DEBUGSS0_BUS_SYS_CLK", "Input clock"},
	{71, 3, "DEV_MCU_DEBUGSS0_BUS_CFG_CLK", "Input clock"},
	{71, 4, "DEV_MCU_DEBUGSS0_BUS_ATB2_CLK", "Input clock"},
	{71, 5, "DEV_MCU_DEBUGSS0_BUS_DBG_CLK", "Input clock"},
	{71, 6, "DEV_MCU_DEBUGSS0_BUS_ATB3_CLK", "Input clock"},
	{92, 0, "DEV_MCU_ECC_AGGR0_BUS_AGGR_CLK", "Input clock"},
	{93, 0, "DEV_MCU_ECC_AGGR1_BUS_AGGR_CLK", "Input clock"},
	{72, 0, "DEV_MCU_EFUSE0_BUS_VBUSP_CLK_CLK", "Input clock"},
	{72, 1, "DEV_MCU_EFUSE0_BUS_EFC3_CTL_FCLK", "Output clock"},
	{72, 2, "DEV_MCU_EFUSE0_BUS_EFC0_CTL_FCLK", "Output clock"},
	{72, 3, "DEV_MCU_EFUSE0_BUS_EFC1_CTL_FCLK", "Output clock"},
	{72, 4, "DEV_MCU_EFUSE0_BUS_EFC2_CTL_FCLK", "Output clock"},
	{53, 0, "DEV_MCU_ESM0_BUS_CLK", "Input clock"},
	{247, 0, "DEV_MCU_FSS0_HYPERBUS0_BUS_HPB_CLKX1_INV_CLK", "Input clock"},
	{247, 1, "DEV_MCU_FSS0_HYPERBUS0_BUS_HPB_CLKX1_CLK", "Input clock"},
	{247, 2, "DEV_MCU_FSS0_HYPERBUS0_BUS_HPB_CLKX2_CLK", "Input clock"},
	{247, 3, "DEV_MCU_FSS0_HYPERBUS0_BUS_CBA_CLK", "Input clock"},
	{247, 4, "DEV_MCU_FSS0_HYPERBUS0_BUS_HPB_CLKX2_INV_CLK", "Input clock"},
	{247, 5, "DEV_MCU_FSS0_HYPERBUS0_HPB_OUT_CLK_N", "Output clock"},
	{247, 6, "DEV_MCU_FSS0_HYPERBUS0_HPB_OUT_CLK_P", "Output clock"},
	{248, 0, "DEV_MCU_FSS0_OSPI_0_BUS_OSPI0_RCLK_CLK", "Input muxed clock"},
	{248, 1, "DEV_MCU_FSS0_OSPI_0_BUS_OSPI0_RCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_0_BUS_HSDIV_CLKOUT4_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_BUS_OSPI0_RCLK_CLK"},
	{248, 2, "DEV_MCU_FSS0_OSPI_0_BUS_OSPI0_RCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT4_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_BUS_OSPI0_RCLK_CLK"},
	{248, 3, "DEV_MCU_FSS0_OSPI_0_BUS_OSPI0_ICLK_CLK", "Input muxed clock"},
	{248, 4, "DEV_MCU_FSS0_OSPI_0_BUS_OSPI0_ICLK_CLK_PARENT_BOARD_0_BUS_MCU_OSPI0DQS_OUT", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_BUS_OSPI0_ICLK_CLK"},
	{248, 5, "DEV_MCU_FSS0_OSPI_0_BUS_OSPI0_ICLK_CLK_PARENT_FSS_MCU_0_OSPI_0_BUS_OSPI0_OCLK_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_0_BUS_OSPI0_ICLK_CLK"},
	{248, 6, "DEV_MCU_FSS0_OSPI_0_BUS_OSPI0_PCLK_CLK", "Input clock"},
	{248, 7, "DEV_MCU_FSS0_OSPI_0_BUS_OSPI0_DQS_CLK", "Input clock"},
	{248, 8, "DEV_MCU_FSS0_OSPI_0_BUS_OSPI0_HCLK_CLK", "Input clock"},
	{248, 9, "DEV_MCU_FSS0_OSPI_0_BUS_OSPI0_OCLK_CLK", "Output clock"},
	{249, 0, "DEV_MCU_FSS0_OSPI_1_BUS_OSPI1_PCLK_CLK", "Input clock"},
	{249, 1, "DEV_MCU_FSS0_OSPI_1_BUS_OSPI1_ICLK_CLK", "Input muxed clock"},
	{249, 2, "DEV_MCU_FSS0_OSPI_1_BUS_OSPI1_ICLK_CLK_PARENT_BOARD_0_BUS_MCU_OSPI1DQS_OUT", "Parent input clock option to DEV_MCU_FSS0_OSPI_1_BUS_OSPI1_ICLK_CLK"},
	{249, 3, "DEV_MCU_FSS0_OSPI_1_BUS_OSPI1_ICLK_CLK_PARENT_FSS_MCU_0_OSPI_1_BUS_OSPI1_OCLK_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_1_BUS_OSPI1_ICLK_CLK"},
	{249, 4, "DEV_MCU_FSS0_OSPI_1_BUS_OSPI1_HCLK_CLK", "Input clock"},
	{249, 5, "DEV_MCU_FSS0_OSPI_1_BUS_OSPI1_DQS_CLK", "Input clock"},
	{249, 6, "DEV_MCU_FSS0_OSPI_1_BUS_OSPI1_RCLK_CLK", "Input muxed clock"},
	{249, 7, "DEV_MCU_FSS0_OSPI_1_BUS_OSPI1_RCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_0_BUS_HSDIV_CLKOUT4_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_1_BUS_OSPI1_RCLK_CLK"},
	{249, 8, "DEV_MCU_FSS0_OSPI_1_BUS_OSPI1_RCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT4_CLK", "Parent input clock option to DEV_MCU_FSS0_OSPI_1_BUS_OSPI1_RCLK_CLK"},
	{249, 9, "DEV_MCU_FSS0_OSPI_1_BUS_OSPI1_OCLK_CLK", "Output clock"},
	{114, 0, "DEV_MCU_I2C0_BUS_CLK", "Input clock"},
	{114, 1, "DEV_MCU_I2C0_BUS_PISYS_CLK", "Input clock"},
	{114, 2, "DEV_MCU_I2C0_BUS_PISCL", "Output clock"},
	{102, 0, "DEV_MCU_MCAN0_BUS_MCANSS_CCLK_CLK", "Input muxed clock"},
	{102, 1, "DEV_MCU_MCAN0_BUS_MCANSS_CCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_0_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_MCU_MCAN0_BUS_MCANSS_CCLK_CLK"},
	{102, 2, "DEV_MCU_MCAN0_BUS_MCANSS_CCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_0_BUS_HSDIV_CLKOUT2_CLK2", "Parent input clock option to DEV_MCU_MCAN0_BUS_MCANSS_CCLK_CLK"},
	{102, 3, "DEV_MCU_MCAN0_BUS_MCANSS_CCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT3_CLK2", "Parent input clock option to DEV_MCU_MCAN0_BUS_MCANSS_CCLK_CLK"},
	{102, 4, "DEV_MCU_MCAN0_BUS_MCANSS_CCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_MCU_MCAN0_BUS_MCANSS_CCLK_CLK"},
	{102, 5, "DEV_MCU_MCAN0_BUS_MCANSS_HCLK_CLK", "Input clock"},
	{103, 0, "DEV_MCU_MCAN1_BUS_MCANSS_CCLK_CLK", "Input muxed clock"},
	{103, 1, "DEV_MCU_MCAN1_BUS_MCANSS_CCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_0_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_MCU_MCAN1_BUS_MCANSS_CCLK_CLK"},
	{103, 2, "DEV_MCU_MCAN1_BUS_MCANSS_CCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_0_BUS_HSDIV_CLKOUT2_CLK2", "Parent input clock option to DEV_MCU_MCAN1_BUS_MCANSS_CCLK_CLK"},
	{103, 3, "DEV_MCU_MCAN1_BUS_MCANSS_CCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT3_CLK2", "Parent input clock option to DEV_MCU_MCAN1_BUS_MCANSS_CCLK_CLK"},
	{103, 4, "DEV_MCU_MCAN1_BUS_MCANSS_CCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_MCU_MCAN1_BUS_MCANSS_CCLK_CLK"},
	{103, 5, "DEV_MCU_MCAN1_BUS_MCANSS_HCLK_CLK", "Input clock"},
	{142, 0, "DEV_MCU_MCSPI0_BUS_IO_CLKSPII_CLK", "Input clock"},
	{142, 1, "DEV_MCU_MCSPI0_BUS_CLKSPIREF_CLK", "Input clock"},
	{142, 2, "DEV_MCU_MCSPI0_BUS_VBUSP_CLK", "Input clock"},
	{142, 3, "DEV_MCU_MCSPI0_BUS_IO_CLKSPIO_CLK", "Output clock"},
	{143, 0, "DEV_MCU_MCSPI1_BUS_IO_CLKSPII_CLK", "Input clock"},
	{143, 1, "DEV_MCU_MCSPI1_BUS_CLKSPIREF_CLK", "Input clock"},
	{143, 2, "DEV_MCU_MCSPI1_BUS_VBUSP_CLK", "Input clock"},
	{143, 3, "DEV_MCU_MCSPI1_BUS_IO_CLKSPIO_CLK", "Output clock"},
	{144, 0, "DEV_MCU_MCSPI2_BUS_CLKSPIREF_CLK", "Input clock"},
	{144, 1, "DEV_MCU_MCSPI2_BUS_VBUSP_CLK", "Input clock"},
	{116, 0, "DEV_MCU_MSRAM0_BUS_CCLK_CLK", "Input clock"},
	{116, 1, "DEV_MCU_MSRAM0_BUS_VCLK_CLK", "Input clock"},
	{119, 0, "DEV_MCU_NAVSS0_BUS_UDMASS_VD2CLK", "Input clock"},
	{119, 1, "DEV_MCU_NAVSS0_BUS_CPSW0CLK", "Input clock"},
	{119, 2, "DEV_MCU_NAVSS0_BUS_MODSS_VD2CLK", "Input clock"},
	{119, 3, "DEV_MCU_NAVSS0_BUS_PDMA_MCU1CLK", "Input clock"},
	{75, 0, "DEV_MCU_PBIST0_BUS_CLK1_CLK", "Input clock"},
	{75, 1, "DEV_MCU_PBIST0_BUS_CLK4_CLK", "Input clock"},
	{75, 2, "DEV_MCU_PBIST0_BUS_CLK2_CLK", "Input clock"},
	{125, 0, "DEV_MCU_PDMA0_BUS_VCLK", "Input clock"},
	{126, 0, "DEV_MCU_PDMA1_BUS_VCLK", "Input clock"},
	{108, 0, "DEV_MCU_PLL_MMR0_BUS_VBUSP_CLK", "Input clock"},
	{127, 0, "DEV_MCU_PSRAM0_BUS_CLK_CLK", "Input clock"},
	{78, 0, "DEV_MCU_ROM0_BUS_CLK_CLK", "Input clock"},
	{134, 0, "DEV_MCU_RTI0_BUS_RTI_CLK", "Input muxed clock"},
	{134, 1, "DEV_MCU_RTI0_BUS_RTI_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_MCU_RTI0_BUS_RTI_CLK"},
	{134, 2, "DEV_MCU_RTI0_BUS_RTI_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_MCU_RTI0_BUS_RTI_CLK"},
	{134, 3, "DEV_MCU_RTI0_BUS_RTI_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_RTI0_BUS_RTI_CLK"},
	{134, 4, "DEV_MCU_RTI0_BUS_RTI_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_RTI0_BUS_RTI_CLK"},
	{134, 5, "DEV_MCU_RTI0_BUS_VBUSP_CLK", "Input clock"},
	{135, 0, "DEV_MCU_RTI1_BUS_RTI_CLK", "Input muxed clock"},
	{135, 1, "DEV_MCU_RTI1_BUS_RTI_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_MCU_RTI1_BUS_RTI_CLK"},
	{135, 2, "DEV_MCU_RTI1_BUS_RTI_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_MCU_RTI1_BUS_RTI_CLK"},
	{135, 3, "DEV_MCU_RTI1_BUS_RTI_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_RTI1_BUS_RTI_CLK"},
	{135, 4, "DEV_MCU_RTI1_BUS_RTI_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_RTI1_BUS_RTI_CLK"},
	{135, 5, "DEV_MCU_RTI1_BUS_VBUSP_CLK", "Input clock"},
	{109, 0, "DEV_MCU_SEC_MMR0_BUS_VBUSP_CLK", "Input clock"},
	{35, 0, "DEV_MCU_TIMER0_BUS_TIMER_TCLK_CLK", "Input muxed clock"},
	{35, 1, "DEV_MCU_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_MCU_TIMER0_BUS_TIMER_TCLK_CLK"},
	{35, 2, "DEV_MCU_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_BUS_CHIP_DIV1_CLK_CLK2", "Parent input clock option to DEV_MCU_TIMER0_BUS_TIMER_TCLK_CLK"},
	{35, 3, "DEV_MCU_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER0_BUS_TIMER_TCLK_CLK"},
	{35, 4, "DEV_MCU_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_CLKOUT_CLK", "Parent input clock option to DEV_MCU_TIMER0_BUS_TIMER_TCLK_CLK"},
	{35, 5, "DEV_MCU_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER0_BUS_TIMER_TCLK_CLK"},
	{35, 6, "DEV_MCU_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_MCU_TIMER0_BUS_TIMER_TCLK_CLK"},
	{35, 7, "DEV_MCU_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_BUS_CPTS_GENF0_0", "Parent input clock option to DEV_MCU_TIMER0_BUS_TIMER_TCLK_CLK"},
	{35, 8, "DEV_MCU_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER0_BUS_TIMER_TCLK_CLK"},
	{35, 9, "DEV_MCU_TIMER0_BUS_TIMER_HCLK_CLK", "Input clock"},
	{36, 0, "DEV_MCU_TIMER1_BUS_TIMER_TCLK_CLK", "Input muxed clock"},
	{36, 1, "DEV_MCU_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_MCU_TIMER1_BUS_TIMER_TCLK_CLK"},
	{36, 2, "DEV_MCU_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_BUS_CHIP_DIV1_CLK_CLK2", "Parent input clock option to DEV_MCU_TIMER1_BUS_TIMER_TCLK_CLK"},
	{36, 3, "DEV_MCU_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER1_BUS_TIMER_TCLK_CLK"},
	{36, 4, "DEV_MCU_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_CLKOUT_CLK", "Parent input clock option to DEV_MCU_TIMER1_BUS_TIMER_TCLK_CLK"},
	{36, 5, "DEV_MCU_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER1_BUS_TIMER_TCLK_CLK"},
	{36, 6, "DEV_MCU_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_MCU_TIMER1_BUS_TIMER_TCLK_CLK"},
	{36, 7, "DEV_MCU_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_BUS_CPTS_GENF0_0", "Parent input clock option to DEV_MCU_TIMER1_BUS_TIMER_TCLK_CLK"},
	{36, 8, "DEV_MCU_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER1_BUS_TIMER_TCLK_CLK"},
	{36, 9, "DEV_MCU_TIMER1_BUS_TIMER_HCLK_CLK", "Input clock"},
	{37, 0, "DEV_MCU_TIMER2_BUS_TIMER_TCLK_CLK", "Input muxed clock"},
	{37, 1, "DEV_MCU_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_MCU_TIMER2_BUS_TIMER_TCLK_CLK"},
	{37, 2, "DEV_MCU_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_BUS_CHIP_DIV1_CLK_CLK2", "Parent input clock option to DEV_MCU_TIMER2_BUS_TIMER_TCLK_CLK"},
	{37, 3, "DEV_MCU_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER2_BUS_TIMER_TCLK_CLK"},
	{37, 4, "DEV_MCU_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_CLKOUT_CLK", "Parent input clock option to DEV_MCU_TIMER2_BUS_TIMER_TCLK_CLK"},
	{37, 5, "DEV_MCU_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER2_BUS_TIMER_TCLK_CLK"},
	{37, 6, "DEV_MCU_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_MCU_TIMER2_BUS_TIMER_TCLK_CLK"},
	{37, 7, "DEV_MCU_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_BUS_CPTS_GENF0_0", "Parent input clock option to DEV_MCU_TIMER2_BUS_TIMER_TCLK_CLK"},
	{37, 8, "DEV_MCU_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER2_BUS_TIMER_TCLK_CLK"},
	{37, 9, "DEV_MCU_TIMER2_BUS_TIMER_HCLK_CLK", "Input clock"},
	{38, 0, "DEV_MCU_TIMER3_BUS_TIMER_TCLK_CLK", "Input muxed clock"},
	{38, 1, "DEV_MCU_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_MCU_TIMER3_BUS_TIMER_TCLK_CLK"},
	{38, 2, "DEV_MCU_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_BUS_CHIP_DIV1_CLK_CLK2", "Parent input clock option to DEV_MCU_TIMER3_BUS_TIMER_TCLK_CLK"},
	{38, 3, "DEV_MCU_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_MCU_TIMER3_BUS_TIMER_TCLK_CLK"},
	{38, 4, "DEV_MCU_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_CLKOUT_CLK", "Parent input clock option to DEV_MCU_TIMER3_BUS_TIMER_TCLK_CLK"},
	{38, 5, "DEV_MCU_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER3_BUS_TIMER_TCLK_CLK"},
	{38, 6, "DEV_MCU_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_MCU_TIMER3_BUS_TIMER_TCLK_CLK"},
	{38, 7, "DEV_MCU_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_CPSW_2GUSS_MCU_0_BUS_CPTS_GENF0_0", "Parent input clock option to DEV_MCU_TIMER3_BUS_TIMER_TCLK_CLK"},
	{38, 8, "DEV_MCU_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_MCU_TIMER3_BUS_TIMER_TCLK_CLK"},
	{38, 9, "DEV_MCU_TIMER3_BUS_TIMER_HCLK_CLK", "Input clock"},
	{149, 0, "DEV_MCU_UART0_BUS_FCLK_CLK", "Input muxed clock"},
	{149, 1, "DEV_MCU_UART0_BUS_FCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_MCU_UART0_BUS_FCLK_CLK"},
	{149, 2, "DEV_MCU_UART0_BUS_FCLK_CLK_PARENT_ADPLLLJM_WRAP_MAIN_1_BUS_CLKOUT_CLK5", "Parent input clock option to DEV_MCU_UART0_BUS_FCLK_CLK"},
	{149, 3, "DEV_MCU_UART0_BUS_VBUSP_CLK", "Input clock"},
	{47, 0, "DEV_MMCSD0_BUS_EMMCSDSS_VBUS_CLK", "Input clock"},
	{47, 1, "DEV_MMCSD0_BUS_EMMCSDSS_XIN_CLK", "Input clock"},
	{48, 0, "DEV_MMCSD1_BUS_EMMCSDSS_VBUS_CLK", "Input clock"},
	{48, 1, "DEV_MMCSD1_BUS_EMMCSDSS_XIN_CLK", "Input clock"},
	{234, 0, "DEV_MX_EFUSE_MAIN_CHAIN_MAIN_0_BUS_UNDEFINEDCHAIN1_FCLK", "Input clock"},
	{234, 1, "DEV_MX_EFUSE_MAIN_CHAIN_MAIN_0_BUS_UNDEFINEDCHAIN0_FCLK", "Input clock"},
	{235, 0, "DEV_MX_EFUSE_MCU_CHAIN_MCU_0_BUS_UNDEFINEDCHAIN1_FCLK", "Input clock"},
	{235, 1, "DEV_MX_EFUSE_MCU_CHAIN_MCU_0_BUS_UNDEFINEDCHAIN0_FCLK", "Input clock"},
	{235, 2, "DEV_MX_EFUSE_MCU_CHAIN_MCU_0_BUS_UNDEFINEDCHAIN2_FCLK", "Input clock"},
	{118, 0, "DEV_NAVSS0_BUS_UDMASS_VD2CLK", "Input clock"},
	{118, 1, "DEV_NAVSS0_BUS_ICSS_G2CLK", "Input clock"},
	{118, 2, "DEV_NAVSS0_BUS_ICSS_G0CLK", "Input clock"},
	{118, 3, "DEV_NAVSS0_BUS_RCLK_BUS_IN3_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Input clock"},
	{118, 4, "DEV_NAVSS0_BUS_MSMC0CLK", "Input clock"},
	{118, 5, "DEV_NAVSS0_BUS_RCLK_BUS_IN0_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Input clock"},
	{118, 6, "DEV_NAVSS0_BUS_RCLK_BUS_IN2_BOARD_0_BUS_MCU_CPTS_RFT_CLK_OUT", "Input clock"},
	{118, 7, "DEV_NAVSS0_BUS_MODSS_VD2CLK", "Input clock"},
	{118, 8, "DEV_NAVSS0_BUS_RCLK_BUS_IN4_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Input clock"},
	{118, 9, "DEV_NAVSS0_BUS_PDMA_MAIN1CLK", "Input clock"},
	{118, 10, "DEV_NAVSS0_BUS_NBSS_VCLK", "Input clock"},
	{118, 11, "DEV_NAVSS0_BUS_RCLK_BUS_IN1_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Input clock"},
	{118, 12, "DEV_NAVSS0_BUS_NBSS_VD2CLK", "Input clock"},
	{118, 13, "DEV_NAVSS0_BUS_ICSS_G1CLK", "Input clock"},
	{118, 14, "DEV_NAVSS0_BUS_RCLK_BUS_IN5_BOARD_0_BUS_EXT_REFCLK1_OUT", "Input clock"},
	{118, 15, "DEV_NAVSS0_BUS_CPTS0_GENF4_0", "Output clock"},
	{118, 16, "DEV_NAVSS0_BUS_CPTS0_GENF5_0", "Output clock"},
	{118, 17, "DEV_NAVSS0_BUS_CPTS0_GENF2_0", "Output clock"},
	{118, 18, "DEV_NAVSS0_BUS_CPTS0_GENF3_0", "Output clock"},
	{216, 0, "DEV_OLDI_TX_CORE_MAIN_0_BUS_OLDI_PLL_CLK", "Input clock"},
	{216, 1, "DEV_OLDI_TX_CORE_MAIN_0_BUS_OLDI_0_FWD_P_CLK_BUS_IN1_CLOCKDIVIDER_DSS_BUS_OUT0", "Input clock"},
	{216, 2, "DEV_OLDI_TX_CORE_MAIN_0_BUS_OLDI_0_FWD_P_CLK_BUS_IN0_CLOCKDIVIDER_DSS_BUS_OUT0", "Input clock"},
	{73, 0, "DEV_PBIST0_BUS_CLK1_CLK", "Input clock"},
	{73, 1, "DEV_PBIST0_BUS_CLK4_CLK", "Input clock"},
	{73, 2, "DEV_PBIST0_BUS_CLK2_CLK", "Input clock"},
	{74, 0, "DEV_PBIST1_BUS_CLK1_CLK", "Input clock"},
	{74, 1, "DEV_PBIST1_BUS_CLK4_CLK", "Input clock"},
	{74, 2, "DEV_PBIST1_BUS_CLK2_CLK", "Input clock"},
	{120, 0, "DEV_PCIE0_BUS_PCIE_CPTS_RCLK_CLK_BUS_IN5_BOARD_0_BUS_EXT_REFCLK1_OUT", "Input clock"},
	{120, 1, "DEV_PCIE0_BUS_PCIE_CBA_CLK", "Input clock"},
	{120, 2, "DEV_PCIE0_BUS_PCIE_CPTS_RCLK_CLK_BUS_IN3_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Input clock"},
	{120, 3, "DEV_PCIE0_BUS_PCIE_TXI0_CLK", "Input clock"},
	{120, 4, "DEV_PCIE0_BUS_PCIE_CPTS_RCLK_CLK_BUS_IN1_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Input clock"},
	{120, 5, "DEV_PCIE0_BUS_PCIE_CPTS_RCLK_CLK_BUS_IN0_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Input clock"},
	{120, 6, "DEV_PCIE0_BUS_PCIE_CPTS_RCLK_CLK_BUS_IN4_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Input clock"},
	{120, 7, "DEV_PCIE0_BUS_PCIE_CPTS_RCLK_CLK_BUS_IN2_BOARD_0_BUS_MCU_CPTS_RFT_CLK_OUT", "Input clock"},
	{120, 8, "DEV_PCIE0_BUS_PCIE_TXR1_CLK", "Output clock"},
	{120, 9, "DEV_PCIE0_BUS_PCIE_TXR0_CLK", "Output clock"},
	{121, 0, "DEV_PCIE1_BUS_PCIE_CPTS_RCLK_CLK_BUS_IN5_BOARD_0_BUS_EXT_REFCLK1_OUT", "Input clock"},
	{121, 1, "DEV_PCIE1_BUS_PCIE_CBA_CLK", "Input clock"},
	{121, 2, "DEV_PCIE1_BUS_PCIE_CPTS_RCLK_CLK_BUS_IN3_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Input clock"},
	{121, 3, "DEV_PCIE1_BUS_PCIE_TXI0_CLK", "Input clock"},
	{121, 4, "DEV_PCIE1_BUS_PCIE_CPTS_RCLK_CLK_BUS_IN1_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Input clock"},
	{121, 5, "DEV_PCIE1_BUS_PCIE_CPTS_RCLK_CLK_BUS_IN0_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Input clock"},
	{121, 6, "DEV_PCIE1_BUS_PCIE_CPTS_RCLK_CLK_BUS_IN4_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Input clock"},
	{121, 7, "DEV_PCIE1_BUS_PCIE_CPTS_RCLK_CLK_BUS_IN2_BOARD_0_BUS_MCU_CPTS_RFT_CLK_OUT", "Input clock"},
	{121, 8, "DEV_PCIE1_BUS_PCIE_TXR0_CLK", "Output clock"},
	{123, 0, "DEV_PDMA0_BUS_VCLK", "Input clock"},
	{124, 0, "DEV_PDMA1_BUS_VCLK", "Input clock"},
	{122, 0, "DEV_PDMA_DEBUG0_BUS_VCLK", "Input clock"},
	{76, 0, "DEV_PLLCTRL0_BUS_VBUS_SLV_REFCLK_CLK", "Input clock"},
	{76, 1, "DEV_PLLCTRL0_BUS_PLL_CLKOUT_CLK", "Input clock"},
	{76, 2, "DEV_PLLCTRL0_BUS_PLL_REFCLK_CLK", "Input muxed clock"},
	{76, 3, "DEV_PLLCTRL0_BUS_PLL_REFCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_PLLCTRL0_BUS_PLL_REFCLK_CLK"},
	{76, 4, "DEV_PLLCTRL0_BUS_PLL_REFCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_PLLCTRL0_BUS_PLL_REFCLK_CLK"},
	{101, 0, "DEV_PLL_MMR0_BUS_VBUSP_CLK", "Input clock"},
	{62, 0, "DEV_PRU_ICSSG0_BUS_RGMII_MHZ_5_CLK", "Input clock"},
	{62, 1, "DEV_PRU_ICSSG0_BUS_WIZ1_TX_SLV_CLK", "Input clock"},
	{62, 2, "DEV_PRU_ICSSG0_BUS_WIZ0_RX_SLV_CLK", "Input clock"},
	{62, 3, "DEV_PRU_ICSSG0_BUS_VCLK_CLK", "Input clock"},
	{62, 4, "DEV_PRU_ICSSG0_BUS_UCLK_CLK", "Input clock"},
	{62, 5, "DEV_PRU_ICSSG0_BUS_WIZ0_TX_SLV_CLK", "Input clock"},
	{62, 6, "DEV_PRU_ICSSG0_BUS_WIZ1_RX_SLV_CLK", "Input clock"},
	{62, 7, "DEV_PRU_ICSSG0_BUS_PR1_RGMII1_RXC_I", "Input clock"},
	{62, 8, "DEV_PRU_ICSSG0_BUS_RGMII_MHZ_250_CLK", "Input clock"},
	{62, 9, "DEV_PRU_ICSSG0_BUS_RGMII_MHZ_50_CLK", "Input clock"},
	{62, 10, "DEV_PRU_ICSSG0_BUS_IEP_CLK", "Input muxed clock"},
	{62, 11, "DEV_PRU_ICSSG0_BUS_IEP_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_PRU_ICSSG0_BUS_IEP_CLK"},
	{62, 12, "DEV_PRU_ICSSG0_BUS_IEP_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_PRU_ICSSG0_BUS_IEP_CLK"},
	{62, 13, "DEV_PRU_ICSSG0_BUS_IEP_CLK_PARENT_BOARD_0_BUS_MCU_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_PRU_ICSSG0_BUS_IEP_CLK"},
	{62, 14, "DEV_PRU_ICSSG0_BUS_IEP_CLK_PARENT_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_PRU_ICSSG0_BUS_IEP_CLK"},
	{62, 15, "DEV_PRU_ICSSG0_BUS_IEP_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_PRU_ICSSG0_BUS_IEP_CLK"},
	{62, 16, "DEV_PRU_ICSSG0_BUS_IEP_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_PRU_ICSSG0_BUS_IEP_CLK"},
	{62, 17, "DEV_PRU_ICSSG0_BUS_IEP_CLK_PARENT_WIZ8B2M4VSB_MAIN_0_BUS_LN0_TXCLK", "Parent input clock option to DEV_PRU_ICSSG0_BUS_IEP_CLK"},
	{62, 18, "DEV_PRU_ICSSG0_BUS_IEP_CLK_PARENT_WIZ8B2M4VSB_MAIN_1_BUS_LN0_TXCLK", "Parent input clock option to DEV_PRU_ICSSG0_BUS_IEP_CLK"},
	{62, 19, "DEV_PRU_ICSSG0_BUS_CORE_CLK", "Input muxed clock"},
	{62, 20, "DEV_PRU_ICSSG0_BUS_CORE_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_HSDIV_CLKOUT1_CLK", "Parent input clock option to DEV_PRU_ICSSG0_BUS_CORE_CLK"},
	{62, 21, "DEV_PRU_ICSSG0_BUS_CORE_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_PRU_ICSSG0_BUS_CORE_CLK"},
	{62, 22, "DEV_PRU_ICSSG0_BUS_PR1_RGMII0_RXC_I", "Input clock"},
	{62, 23, "DEV_PRU_ICSSG0_BUS_PR1_RGMII1_TXC_I", "Output clock"},
	{62, 24, "DEV_PRU_ICSSG0_BUS_PR1_RGMII0_TXC_I", "Output clock"},
	{63, 0, "DEV_PRU_ICSSG1_BUS_RGMII_MHZ_5_CLK", "Input clock"},
	{63, 1, "DEV_PRU_ICSSG1_BUS_WIZ1_TX_SLV_CLK", "Input clock"},
	{63, 2, "DEV_PRU_ICSSG1_BUS_WIZ0_RX_SLV_CLK", "Input clock"},
	{63, 3, "DEV_PRU_ICSSG1_BUS_VCLK_CLK", "Input clock"},
	{63, 4, "DEV_PRU_ICSSG1_BUS_UCLK_CLK", "Input clock"},
	{63, 5, "DEV_PRU_ICSSG1_BUS_WIZ0_TX_SLV_CLK", "Input clock"},
	{63, 6, "DEV_PRU_ICSSG1_BUS_WIZ1_RX_SLV_CLK", "Input clock"},
	{63, 7, "DEV_PRU_ICSSG1_BUS_PR1_RGMII1_RXC_I", "Input clock"},
	{63, 8, "DEV_PRU_ICSSG1_BUS_RGMII_MHZ_250_CLK", "Input clock"},
	{63, 9, "DEV_PRU_ICSSG1_BUS_RGMII_MHZ_50_CLK", "Input clock"},
	{63, 10, "DEV_PRU_ICSSG1_BUS_IEP_CLK", "Input muxed clock"},
	{63, 11, "DEV_PRU_ICSSG1_BUS_IEP_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_PRU_ICSSG1_BUS_IEP_CLK"},
	{63, 12, "DEV_PRU_ICSSG1_BUS_IEP_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_PRU_ICSSG1_BUS_IEP_CLK"},
	{63, 13, "DEV_PRU_ICSSG1_BUS_IEP_CLK_PARENT_BOARD_0_BUS_MCU_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_PRU_ICSSG1_BUS_IEP_CLK"},
	{63, 14, "DEV_PRU_ICSSG1_BUS_IEP_CLK_PARENT_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_PRU_ICSSG1_BUS_IEP_CLK"},
	{63, 15, "DEV_PRU_ICSSG1_BUS_IEP_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_PRU_ICSSG1_BUS_IEP_CLK"},
	{63, 16, "DEV_PRU_ICSSG1_BUS_IEP_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_PRU_ICSSG1_BUS_IEP_CLK"},
	{63, 17, "DEV_PRU_ICSSG1_BUS_IEP_CLK_PARENT_WIZ8B2M4VSB_MAIN_0_BUS_LN0_TXCLK", "Parent input clock option to DEV_PRU_ICSSG1_BUS_IEP_CLK"},
	{63, 18, "DEV_PRU_ICSSG1_BUS_IEP_CLK_PARENT_WIZ8B2M4VSB_MAIN_1_BUS_LN0_TXCLK", "Parent input clock option to DEV_PRU_ICSSG1_BUS_IEP_CLK"},
	{63, 19, "DEV_PRU_ICSSG1_BUS_CORE_CLK", "Input muxed clock"},
	{63, 20, "DEV_PRU_ICSSG1_BUS_CORE_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_HSDIV_CLKOUT1_CLK", "Parent input clock option to DEV_PRU_ICSSG1_BUS_CORE_CLK"},
	{63, 21, "DEV_PRU_ICSSG1_BUS_CORE_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_PRU_ICSSG1_BUS_CORE_CLK"},
	{63, 22, "DEV_PRU_ICSSG1_BUS_PR1_RGMII0_RXC_I", "Input clock"},
	{63, 23, "DEV_PRU_ICSSG1_BUS_PR1_RGMII1_TXC_I", "Output clock"},
	{63, 24, "DEV_PRU_ICSSG1_BUS_PR1_RGMII0_TXC_I", "Output clock"},
	{64, 0, "DEV_PRU_ICSSG2_BUS_RGMII_MHZ_5_CLK", "Input clock"},
	{64, 1, "DEV_PRU_ICSSG2_BUS_WIZ1_TX_SLV_CLK", "Input clock"},
	{64, 2, "DEV_PRU_ICSSG2_BUS_WIZ0_RX_SLV_CLK", "Input clock"},
	{64, 3, "DEV_PRU_ICSSG2_BUS_VCLK_CLK", "Input clock"},
	{64, 4, "DEV_PRU_ICSSG2_BUS_UCLK_CLK", "Input clock"},
	{64, 5, "DEV_PRU_ICSSG2_BUS_WIZ0_TX_SLV_CLK", "Input clock"},
	{64, 6, "DEV_PRU_ICSSG2_BUS_WIZ1_RX_SLV_CLK", "Input clock"},
	{64, 7, "DEV_PRU_ICSSG2_BUS_PR1_RGMII1_RXC_I", "Input clock"},
	{64, 8, "DEV_PRU_ICSSG2_BUS_RGMII_MHZ_250_CLK", "Input clock"},
	{64, 9, "DEV_PRU_ICSSG2_BUS_RGMII_MHZ_50_CLK", "Input clock"},
	{64, 10, "DEV_PRU_ICSSG2_BUS_IEP_CLK", "Input muxed clock"},
	{64, 11, "DEV_PRU_ICSSG2_BUS_IEP_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_PRU_ICSSG2_BUS_IEP_CLK"},
	{64, 12, "DEV_PRU_ICSSG2_BUS_IEP_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_PRU_ICSSG2_BUS_IEP_CLK"},
	{64, 13, "DEV_PRU_ICSSG2_BUS_IEP_CLK_PARENT_BOARD_0_BUS_MCU_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_PRU_ICSSG2_BUS_IEP_CLK"},
	{64, 14, "DEV_PRU_ICSSG2_BUS_IEP_CLK_PARENT_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_PRU_ICSSG2_BUS_IEP_CLK"},
	{64, 15, "DEV_PRU_ICSSG2_BUS_IEP_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_PRU_ICSSG2_BUS_IEP_CLK"},
	{64, 16, "DEV_PRU_ICSSG2_BUS_IEP_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_PRU_ICSSG2_BUS_IEP_CLK"},
	{64, 17, "DEV_PRU_ICSSG2_BUS_IEP_CLK_PARENT_WIZ8B2M4VSB_MAIN_0_BUS_LN0_TXCLK", "Parent input clock option to DEV_PRU_ICSSG2_BUS_IEP_CLK"},
	{64, 18, "DEV_PRU_ICSSG2_BUS_IEP_CLK_PARENT_WIZ8B2M4VSB_MAIN_1_BUS_LN0_TXCLK", "Parent input clock option to DEV_PRU_ICSSG2_BUS_IEP_CLK"},
	{64, 19, "DEV_PRU_ICSSG2_BUS_CORE_CLK", "Input muxed clock"},
	{64, 20, "DEV_PRU_ICSSG2_BUS_CORE_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_HSDIV_CLKOUT1_CLK", "Parent input clock option to DEV_PRU_ICSSG2_BUS_CORE_CLK"},
	{64, 21, "DEV_PRU_ICSSG2_BUS_CORE_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_PRU_ICSSG2_BUS_CORE_CLK"},
	{64, 22, "DEV_PRU_ICSSG2_BUS_PR1_RGMII0_RXC_I", "Input clock"},
	{64, 23, "DEV_PRU_ICSSG2_BUS_PR1_RGMII1_TXC_I", "Output clock"},
	{64, 24, "DEV_PRU_ICSSG2_BUS_PR1_RGMII0_TXC_I", "Output clock"},
	{64, 25, "DEV_PRU_ICSSG2_BUS_WIZ1_TX_MST_CLK", "Output clock"},
	{64, 26, "DEV_PRU_ICSSG2_BUS_WIZ0_TX_MST_CLK", "Output clock"},
	{70, 0, "DEV_PSC0_BUS_CLK", "Input clock"},
	{70, 1, "DEV_PSC0_BUS_SLOW_CLK", "Input clock"},
	{128, 0, "DEV_PSRAMECC0_BUS_CLK_CLK", "Input clock"},
	{130, 0, "DEV_RTI0_BUS_RTI_CLK", "Input muxed clock"},
	{130, 1, "DEV_RTI0_BUS_RTI_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_RTI0_BUS_RTI_CLK"},
	{130, 2, "DEV_RTI0_BUS_RTI_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_RTI0_BUS_RTI_CLK"},
	{130, 3, "DEV_RTI0_BUS_RTI_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI0_BUS_RTI_CLK"},
	{130, 4, "DEV_RTI0_BUS_RTI_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI0_BUS_RTI_CLK"},
	{130, 5, "DEV_RTI0_BUS_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI0_BUS_RTI_CLK"},
	{130, 6, "DEV_RTI0_BUS_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI0_BUS_RTI_CLK"},
	{130, 7, "DEV_RTI0_BUS_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI0_BUS_RTI_CLK"},
	{130, 8, "DEV_RTI0_BUS_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI0_BUS_RTI_CLK"},
	{130, 9, "DEV_RTI0_BUS_VBUSP_CLK", "Input clock"},
	{131, 0, "DEV_RTI1_BUS_RTI_CLK", "Input muxed clock"},
	{131, 1, "DEV_RTI1_BUS_RTI_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_RTI1_BUS_RTI_CLK"},
	{131, 2, "DEV_RTI1_BUS_RTI_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_RTI1_BUS_RTI_CLK"},
	{131, 3, "DEV_RTI1_BUS_RTI_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI1_BUS_RTI_CLK"},
	{131, 4, "DEV_RTI1_BUS_RTI_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI1_BUS_RTI_CLK"},
	{131, 5, "DEV_RTI1_BUS_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI1_BUS_RTI_CLK"},
	{131, 6, "DEV_RTI1_BUS_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI1_BUS_RTI_CLK"},
	{131, 7, "DEV_RTI1_BUS_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI1_BUS_RTI_CLK"},
	{131, 8, "DEV_RTI1_BUS_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI1_BUS_RTI_CLK"},
	{131, 9, "DEV_RTI1_BUS_VBUSP_CLK", "Input clock"},
	{132, 0, "DEV_RTI2_BUS_RTI_CLK", "Input muxed clock"},
	{132, 1, "DEV_RTI2_BUS_RTI_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_RTI2_BUS_RTI_CLK"},
	{132, 2, "DEV_RTI2_BUS_RTI_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_RTI2_BUS_RTI_CLK"},
	{132, 3, "DEV_RTI2_BUS_RTI_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI2_BUS_RTI_CLK"},
	{132, 4, "DEV_RTI2_BUS_RTI_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI2_BUS_RTI_CLK"},
	{132, 5, "DEV_RTI2_BUS_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI2_BUS_RTI_CLK"},
	{132, 6, "DEV_RTI2_BUS_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI2_BUS_RTI_CLK"},
	{132, 7, "DEV_RTI2_BUS_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI2_BUS_RTI_CLK"},
	{132, 8, "DEV_RTI2_BUS_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI2_BUS_RTI_CLK"},
	{132, 9, "DEV_RTI2_BUS_VBUSP_CLK", "Input clock"},
	{133, 0, "DEV_RTI3_BUS_RTI_CLK", "Input muxed clock"},
	{133, 1, "DEV_RTI3_BUS_RTI_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_RTI3_BUS_RTI_CLK"},
	{133, 2, "DEV_RTI3_BUS_RTI_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_RTI3_BUS_RTI_CLK"},
	{133, 3, "DEV_RTI3_BUS_RTI_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_RTI3_BUS_RTI_CLK"},
	{133, 4, "DEV_RTI3_BUS_RTI_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_RTI3_BUS_RTI_CLK"},
	{133, 5, "DEV_RTI3_BUS_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_RTI3_BUS_RTI_CLK"},
	{133, 6, "DEV_RTI3_BUS_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP0", "Parent input clock option to DEV_RTI3_BUS_RTI_CLK"},
	{133, 7, "DEV_RTI3_BUS_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP1", "Parent input clock option to DEV_RTI3_BUS_RTI_CLK"},
	{133, 8, "DEV_RTI3_BUS_RTI_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT_DUP2", "Parent input clock option to DEV_RTI3_BUS_RTI_CLK"},
	{133, 9, "DEV_RTI3_BUS_VBUSP_CLK", "Input clock"},
	{136, 0, "DEV_SA2_UL0_BUS_PKA_IN_CLK", "Input clock"},
	{136, 1, "DEV_SA2_UL0_BUS_X1_CLK", "Input clock"},
	{136, 2, "DEV_SA2_UL0_BUS_X2_CLK", "Input clock"},
	{153, 0, "DEV_SERDES0_BUS_IP3_LN0_TXRCLK", "Input clock"},
	{153, 1, "DEV_SERDES0_BUS_REFCLKPP", "Input clock"},
	{153, 2, "DEV_SERDES0_BUS_CLK", "Input clock"},
	{153, 3, "DEV_SERDES0_BUS_IP2_LN0_TXRCLK", "Input clock"},
	{153, 4, "DEV_SERDES0_BUS_LI_REFCLK", "Input muxed clock"},
	{153, 5, "DEV_SERDES0_BUS_LI_REFCLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_SERDES0_BUS_LI_REFCLK"},
	{153, 6, "DEV_SERDES0_BUS_LI_REFCLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_SERDES0_BUS_LI_REFCLK"},
	{153, 7, "DEV_SERDES0_BUS_LI_REFCLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_CLKOUT_CLK", "Parent input clock option to DEV_SERDES0_BUS_LI_REFCLK"},
	{153, 8, "DEV_SERDES0_BUS_LI_REFCLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT4_CLK", "Parent input clock option to DEV_SERDES0_BUS_LI_REFCLK"},
	{153, 9, "DEV_SERDES0_BUS_REFCLKPN", "Input clock"},
	{153, 10, "DEV_SERDES0_BUS_LN0_TXCLK", "Output clock"},
	{153, 11, "DEV_SERDES0_BUS_LN0_RXCLK", "Output clock"},
	{154, 0, "DEV_SERDES1_BUS_IP3_LN0_TXRCLK", "Input clock"},
	{154, 1, "DEV_SERDES1_BUS_REFCLKPP", "Input clock"},
	{154, 2, "DEV_SERDES1_BUS_CLK", "Input clock"},
	{154, 3, "DEV_SERDES1_BUS_IP1_LN0_TXRCLK", "Input clock"},
	{154, 4, "DEV_SERDES1_BUS_IP2_LN0_TXRCLK", "Input clock"},
	{154, 5, "DEV_SERDES1_BUS_RI_REFCLK", "Input muxed clock"},
	{154, 6, "DEV_SERDES1_BUS_RI_REFCLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_SERDES1_BUS_RI_REFCLK"},
	{154, 7, "DEV_SERDES1_BUS_RI_REFCLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_SERDES1_BUS_RI_REFCLK"},
	{154, 8, "DEV_SERDES1_BUS_RI_REFCLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_CLKOUT_CLK", "Parent input clock option to DEV_SERDES1_BUS_RI_REFCLK"},
	{154, 9, "DEV_SERDES1_BUS_RI_REFCLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT4_CLK", "Parent input clock option to DEV_SERDES1_BUS_RI_REFCLK"},
	{154, 10, "DEV_SERDES1_BUS_REFCLKPN", "Input clock"},
	{154, 11, "DEV_SERDES1_BUS_LN0_TXCLK", "Output clock"},
	{154, 12, "DEV_SERDES1_BUS_LN0_RXCLK", "Output clock"},
	{8, 0, "DEV_STM0_BUS_CORE_CLK", "Input clock"},
	{8, 1, "DEV_STM0_BUS_ATB_CLK", "Input clock"},
	{8, 2, "DEV_STM0_BUS_VBUSP_CLK", "Input clock"},
	{23, 0, "DEV_TIMER0_BUS_TIMER_TCLK_CLK", "Input muxed clock"},
	{23, 1, "DEV_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_TIMER0_BUS_TIMER_TCLK_CLK"},
	{23, 2, "DEV_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER0_BUS_TIMER_TCLK_CLK"},
	{23, 3, "DEV_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_TIMER0_BUS_TIMER_TCLK_CLK"},
	{23, 4, "DEV_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER0_BUS_TIMER_TCLK_CLK"},
	{23, 5, "DEV_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER0_BUS_TIMER_TCLK_CLK"},
	{23, 6, "DEV_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER0_BUS_TIMER_TCLK_CLK"},
	{23, 7, "DEV_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER0_BUS_TIMER_TCLK_CLK"},
	{23, 8, "DEV_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_TIMER0_BUS_TIMER_TCLK_CLK"},
	{23, 9, "DEV_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER0_BUS_TIMER_TCLK_CLK"},
	{23, 10, "DEV_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER0_BUS_TIMER_TCLK_CLK"},
	{23, 11, "DEV_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_WRAP_MAIN_1_BUS_CLKOUT_CLK5", "Parent input clock option to DEV_TIMER0_BUS_TIMER_TCLK_CLK"},
	{23, 12, "DEV_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_TIMER0_BUS_TIMER_TCLK_CLK"},
	{23, 13, "DEV_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF2_0", "Parent input clock option to DEV_TIMER0_BUS_TIMER_TCLK_CLK"},
	{23, 14, "DEV_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF3_0", "Parent input clock option to DEV_TIMER0_BUS_TIMER_TCLK_CLK"},
	{23, 15, "DEV_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF4_0", "Parent input clock option to DEV_TIMER0_BUS_TIMER_TCLK_CLK"},
	{23, 16, "DEV_TIMER0_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF5_0", "Parent input clock option to DEV_TIMER0_BUS_TIMER_TCLK_CLK"},
	{23, 17, "DEV_TIMER0_BUS_TIMER_HCLK_CLK", "Input clock"},
	{24, 0, "DEV_TIMER1_BUS_TIMER_TCLK_CLK", "Input muxed clock"},
	{24, 1, "DEV_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_TIMER1_BUS_TIMER_TCLK_CLK"},
	{24, 2, "DEV_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER1_BUS_TIMER_TCLK_CLK"},
	{24, 3, "DEV_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_TIMER1_BUS_TIMER_TCLK_CLK"},
	{24, 4, "DEV_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER1_BUS_TIMER_TCLK_CLK"},
	{24, 5, "DEV_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER1_BUS_TIMER_TCLK_CLK"},
	{24, 6, "DEV_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER1_BUS_TIMER_TCLK_CLK"},
	{24, 7, "DEV_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER1_BUS_TIMER_TCLK_CLK"},
	{24, 8, "DEV_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_TIMER1_BUS_TIMER_TCLK_CLK"},
	{24, 9, "DEV_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER1_BUS_TIMER_TCLK_CLK"},
	{24, 10, "DEV_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER1_BUS_TIMER_TCLK_CLK"},
	{24, 11, "DEV_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_WRAP_MAIN_1_BUS_CLKOUT_CLK5", "Parent input clock option to DEV_TIMER1_BUS_TIMER_TCLK_CLK"},
	{24, 12, "DEV_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_TIMER1_BUS_TIMER_TCLK_CLK"},
	{24, 13, "DEV_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF2_0", "Parent input clock option to DEV_TIMER1_BUS_TIMER_TCLK_CLK"},
	{24, 14, "DEV_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF3_0", "Parent input clock option to DEV_TIMER1_BUS_TIMER_TCLK_CLK"},
	{24, 15, "DEV_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF4_0", "Parent input clock option to DEV_TIMER1_BUS_TIMER_TCLK_CLK"},
	{24, 16, "DEV_TIMER1_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF5_0", "Parent input clock option to DEV_TIMER1_BUS_TIMER_TCLK_CLK"},
	{24, 17, "DEV_TIMER1_BUS_TIMER_HCLK_CLK", "Input clock"},
	{25, 0, "DEV_TIMER10_BUS_TIMER_TCLK_CLK", "Input muxed clock"},
	{25, 1, "DEV_TIMER10_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_TIMER10_BUS_TIMER_TCLK_CLK"},
	{25, 2, "DEV_TIMER10_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER10_BUS_TIMER_TCLK_CLK"},
	{25, 3, "DEV_TIMER10_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_TIMER10_BUS_TIMER_TCLK_CLK"},
	{25, 4, "DEV_TIMER10_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER10_BUS_TIMER_TCLK_CLK"},
	{25, 5, "DEV_TIMER10_BUS_TIMER_TCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER10_BUS_TIMER_TCLK_CLK"},
	{25, 6, "DEV_TIMER10_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER10_BUS_TIMER_TCLK_CLK"},
	{25, 7, "DEV_TIMER10_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER10_BUS_TIMER_TCLK_CLK"},
	{25, 8, "DEV_TIMER10_BUS_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_TIMER10_BUS_TIMER_TCLK_CLK"},
	{25, 9, "DEV_TIMER10_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER10_BUS_TIMER_TCLK_CLK"},
	{25, 10, "DEV_TIMER10_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER10_BUS_TIMER_TCLK_CLK"},
	{25, 11, "DEV_TIMER10_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_WRAP_MAIN_1_BUS_CLKOUT_CLK5", "Parent input clock option to DEV_TIMER10_BUS_TIMER_TCLK_CLK"},
	{25, 12, "DEV_TIMER10_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_TIMER10_BUS_TIMER_TCLK_CLK"},
	{25, 13, "DEV_TIMER10_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF2_0", "Parent input clock option to DEV_TIMER10_BUS_TIMER_TCLK_CLK"},
	{25, 14, "DEV_TIMER10_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF3_0", "Parent input clock option to DEV_TIMER10_BUS_TIMER_TCLK_CLK"},
	{25, 15, "DEV_TIMER10_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF4_0", "Parent input clock option to DEV_TIMER10_BUS_TIMER_TCLK_CLK"},
	{25, 16, "DEV_TIMER10_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF5_0", "Parent input clock option to DEV_TIMER10_BUS_TIMER_TCLK_CLK"},
	{25, 17, "DEV_TIMER10_BUS_TIMER_HCLK_CLK", "Input clock"},
	{26, 0, "DEV_TIMER11_BUS_TIMER_TCLK_CLK", "Input muxed clock"},
	{26, 1, "DEV_TIMER11_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_TIMER11_BUS_TIMER_TCLK_CLK"},
	{26, 2, "DEV_TIMER11_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER11_BUS_TIMER_TCLK_CLK"},
	{26, 3, "DEV_TIMER11_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_TIMER11_BUS_TIMER_TCLK_CLK"},
	{26, 4, "DEV_TIMER11_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER11_BUS_TIMER_TCLK_CLK"},
	{26, 5, "DEV_TIMER11_BUS_TIMER_TCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER11_BUS_TIMER_TCLK_CLK"},
	{26, 6, "DEV_TIMER11_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER11_BUS_TIMER_TCLK_CLK"},
	{26, 7, "DEV_TIMER11_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER11_BUS_TIMER_TCLK_CLK"},
	{26, 8, "DEV_TIMER11_BUS_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_TIMER11_BUS_TIMER_TCLK_CLK"},
	{26, 9, "DEV_TIMER11_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER11_BUS_TIMER_TCLK_CLK"},
	{26, 10, "DEV_TIMER11_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER11_BUS_TIMER_TCLK_CLK"},
	{26, 11, "DEV_TIMER11_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_WRAP_MAIN_1_BUS_CLKOUT_CLK5", "Parent input clock option to DEV_TIMER11_BUS_TIMER_TCLK_CLK"},
	{26, 12, "DEV_TIMER11_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_TIMER11_BUS_TIMER_TCLK_CLK"},
	{26, 13, "DEV_TIMER11_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF2_0", "Parent input clock option to DEV_TIMER11_BUS_TIMER_TCLK_CLK"},
	{26, 14, "DEV_TIMER11_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF3_0", "Parent input clock option to DEV_TIMER11_BUS_TIMER_TCLK_CLK"},
	{26, 15, "DEV_TIMER11_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF4_0", "Parent input clock option to DEV_TIMER11_BUS_TIMER_TCLK_CLK"},
	{26, 16, "DEV_TIMER11_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF5_0", "Parent input clock option to DEV_TIMER11_BUS_TIMER_TCLK_CLK"},
	{26, 17, "DEV_TIMER11_BUS_TIMER_HCLK_CLK", "Input clock"},
	{27, 0, "DEV_TIMER2_BUS_TIMER_TCLK_CLK", "Input muxed clock"},
	{27, 1, "DEV_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_TIMER2_BUS_TIMER_TCLK_CLK"},
	{27, 2, "DEV_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER2_BUS_TIMER_TCLK_CLK"},
	{27, 3, "DEV_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_TIMER2_BUS_TIMER_TCLK_CLK"},
	{27, 4, "DEV_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER2_BUS_TIMER_TCLK_CLK"},
	{27, 5, "DEV_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER2_BUS_TIMER_TCLK_CLK"},
	{27, 6, "DEV_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER2_BUS_TIMER_TCLK_CLK"},
	{27, 7, "DEV_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER2_BUS_TIMER_TCLK_CLK"},
	{27, 8, "DEV_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_TIMER2_BUS_TIMER_TCLK_CLK"},
	{27, 9, "DEV_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER2_BUS_TIMER_TCLK_CLK"},
	{27, 10, "DEV_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER2_BUS_TIMER_TCLK_CLK"},
	{27, 11, "DEV_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_WRAP_MAIN_1_BUS_CLKOUT_CLK5", "Parent input clock option to DEV_TIMER2_BUS_TIMER_TCLK_CLK"},
	{27, 12, "DEV_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_TIMER2_BUS_TIMER_TCLK_CLK"},
	{27, 13, "DEV_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF2_0", "Parent input clock option to DEV_TIMER2_BUS_TIMER_TCLK_CLK"},
	{27, 14, "DEV_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF3_0", "Parent input clock option to DEV_TIMER2_BUS_TIMER_TCLK_CLK"},
	{27, 15, "DEV_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF4_0", "Parent input clock option to DEV_TIMER2_BUS_TIMER_TCLK_CLK"},
	{27, 16, "DEV_TIMER2_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF5_0", "Parent input clock option to DEV_TIMER2_BUS_TIMER_TCLK_CLK"},
	{27, 17, "DEV_TIMER2_BUS_TIMER_HCLK_CLK", "Input clock"},
	{28, 0, "DEV_TIMER3_BUS_TIMER_TCLK_CLK", "Input muxed clock"},
	{28, 1, "DEV_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_TIMER3_BUS_TIMER_TCLK_CLK"},
	{28, 2, "DEV_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER3_BUS_TIMER_TCLK_CLK"},
	{28, 3, "DEV_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_TIMER3_BUS_TIMER_TCLK_CLK"},
	{28, 4, "DEV_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER3_BUS_TIMER_TCLK_CLK"},
	{28, 5, "DEV_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER3_BUS_TIMER_TCLK_CLK"},
	{28, 6, "DEV_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER3_BUS_TIMER_TCLK_CLK"},
	{28, 7, "DEV_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER3_BUS_TIMER_TCLK_CLK"},
	{28, 8, "DEV_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_TIMER3_BUS_TIMER_TCLK_CLK"},
	{28, 9, "DEV_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER3_BUS_TIMER_TCLK_CLK"},
	{28, 10, "DEV_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER3_BUS_TIMER_TCLK_CLK"},
	{28, 11, "DEV_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_WRAP_MAIN_1_BUS_CLKOUT_CLK5", "Parent input clock option to DEV_TIMER3_BUS_TIMER_TCLK_CLK"},
	{28, 12, "DEV_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_TIMER3_BUS_TIMER_TCLK_CLK"},
	{28, 13, "DEV_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF2_0", "Parent input clock option to DEV_TIMER3_BUS_TIMER_TCLK_CLK"},
	{28, 14, "DEV_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF3_0", "Parent input clock option to DEV_TIMER3_BUS_TIMER_TCLK_CLK"},
	{28, 15, "DEV_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF4_0", "Parent input clock option to DEV_TIMER3_BUS_TIMER_TCLK_CLK"},
	{28, 16, "DEV_TIMER3_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF5_0", "Parent input clock option to DEV_TIMER3_BUS_TIMER_TCLK_CLK"},
	{28, 17, "DEV_TIMER3_BUS_TIMER_HCLK_CLK", "Input clock"},
	{29, 0, "DEV_TIMER4_BUS_TIMER_TCLK_CLK", "Input muxed clock"},
	{29, 1, "DEV_TIMER4_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_TIMER4_BUS_TIMER_TCLK_CLK"},
	{29, 2, "DEV_TIMER4_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER4_BUS_TIMER_TCLK_CLK"},
	{29, 3, "DEV_TIMER4_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_TIMER4_BUS_TIMER_TCLK_CLK"},
	{29, 4, "DEV_TIMER4_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER4_BUS_TIMER_TCLK_CLK"},
	{29, 5, "DEV_TIMER4_BUS_TIMER_TCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER4_BUS_TIMER_TCLK_CLK"},
	{29, 6, "DEV_TIMER4_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER4_BUS_TIMER_TCLK_CLK"},
	{29, 7, "DEV_TIMER4_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER4_BUS_TIMER_TCLK_CLK"},
	{29, 8, "DEV_TIMER4_BUS_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_TIMER4_BUS_TIMER_TCLK_CLK"},
	{29, 9, "DEV_TIMER4_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER4_BUS_TIMER_TCLK_CLK"},
	{29, 10, "DEV_TIMER4_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER4_BUS_TIMER_TCLK_CLK"},
	{29, 11, "DEV_TIMER4_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_WRAP_MAIN_1_BUS_CLKOUT_CLK5", "Parent input clock option to DEV_TIMER4_BUS_TIMER_TCLK_CLK"},
	{29, 12, "DEV_TIMER4_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_TIMER4_BUS_TIMER_TCLK_CLK"},
	{29, 13, "DEV_TIMER4_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF2_0", "Parent input clock option to DEV_TIMER4_BUS_TIMER_TCLK_CLK"},
	{29, 14, "DEV_TIMER4_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF3_0", "Parent input clock option to DEV_TIMER4_BUS_TIMER_TCLK_CLK"},
	{29, 15, "DEV_TIMER4_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF4_0", "Parent input clock option to DEV_TIMER4_BUS_TIMER_TCLK_CLK"},
	{29, 16, "DEV_TIMER4_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF5_0", "Parent input clock option to DEV_TIMER4_BUS_TIMER_TCLK_CLK"},
	{29, 17, "DEV_TIMER4_BUS_TIMER_HCLK_CLK", "Input clock"},
	{30, 0, "DEV_TIMER5_BUS_TIMER_TCLK_CLK", "Input muxed clock"},
	{30, 1, "DEV_TIMER5_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_TIMER5_BUS_TIMER_TCLK_CLK"},
	{30, 2, "DEV_TIMER5_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER5_BUS_TIMER_TCLK_CLK"},
	{30, 3, "DEV_TIMER5_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_TIMER5_BUS_TIMER_TCLK_CLK"},
	{30, 4, "DEV_TIMER5_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER5_BUS_TIMER_TCLK_CLK"},
	{30, 5, "DEV_TIMER5_BUS_TIMER_TCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER5_BUS_TIMER_TCLK_CLK"},
	{30, 6, "DEV_TIMER5_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER5_BUS_TIMER_TCLK_CLK"},
	{30, 7, "DEV_TIMER5_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER5_BUS_TIMER_TCLK_CLK"},
	{30, 8, "DEV_TIMER5_BUS_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_TIMER5_BUS_TIMER_TCLK_CLK"},
	{30, 9, "DEV_TIMER5_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER5_BUS_TIMER_TCLK_CLK"},
	{30, 10, "DEV_TIMER5_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER5_BUS_TIMER_TCLK_CLK"},
	{30, 11, "DEV_TIMER5_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_WRAP_MAIN_1_BUS_CLKOUT_CLK5", "Parent input clock option to DEV_TIMER5_BUS_TIMER_TCLK_CLK"},
	{30, 12, "DEV_TIMER5_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_TIMER5_BUS_TIMER_TCLK_CLK"},
	{30, 13, "DEV_TIMER5_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF2_0", "Parent input clock option to DEV_TIMER5_BUS_TIMER_TCLK_CLK"},
	{30, 14, "DEV_TIMER5_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF3_0", "Parent input clock option to DEV_TIMER5_BUS_TIMER_TCLK_CLK"},
	{30, 15, "DEV_TIMER5_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF4_0", "Parent input clock option to DEV_TIMER5_BUS_TIMER_TCLK_CLK"},
	{30, 16, "DEV_TIMER5_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF5_0", "Parent input clock option to DEV_TIMER5_BUS_TIMER_TCLK_CLK"},
	{30, 17, "DEV_TIMER5_BUS_TIMER_HCLK_CLK", "Input clock"},
	{31, 0, "DEV_TIMER6_BUS_TIMER_TCLK_CLK", "Input muxed clock"},
	{31, 1, "DEV_TIMER6_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_TIMER6_BUS_TIMER_TCLK_CLK"},
	{31, 2, "DEV_TIMER6_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER6_BUS_TIMER_TCLK_CLK"},
	{31, 3, "DEV_TIMER6_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_TIMER6_BUS_TIMER_TCLK_CLK"},
	{31, 4, "DEV_TIMER6_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER6_BUS_TIMER_TCLK_CLK"},
	{31, 5, "DEV_TIMER6_BUS_TIMER_TCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER6_BUS_TIMER_TCLK_CLK"},
	{31, 6, "DEV_TIMER6_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER6_BUS_TIMER_TCLK_CLK"},
	{31, 7, "DEV_TIMER6_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER6_BUS_TIMER_TCLK_CLK"},
	{31, 8, "DEV_TIMER6_BUS_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_TIMER6_BUS_TIMER_TCLK_CLK"},
	{31, 9, "DEV_TIMER6_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER6_BUS_TIMER_TCLK_CLK"},
	{31, 10, "DEV_TIMER6_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER6_BUS_TIMER_TCLK_CLK"},
	{31, 11, "DEV_TIMER6_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_WRAP_MAIN_1_BUS_CLKOUT_CLK5", "Parent input clock option to DEV_TIMER6_BUS_TIMER_TCLK_CLK"},
	{31, 12, "DEV_TIMER6_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_TIMER6_BUS_TIMER_TCLK_CLK"},
	{31, 13, "DEV_TIMER6_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF2_0", "Parent input clock option to DEV_TIMER6_BUS_TIMER_TCLK_CLK"},
	{31, 14, "DEV_TIMER6_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF3_0", "Parent input clock option to DEV_TIMER6_BUS_TIMER_TCLK_CLK"},
	{31, 15, "DEV_TIMER6_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF4_0", "Parent input clock option to DEV_TIMER6_BUS_TIMER_TCLK_CLK"},
	{31, 16, "DEV_TIMER6_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF5_0", "Parent input clock option to DEV_TIMER6_BUS_TIMER_TCLK_CLK"},
	{31, 17, "DEV_TIMER6_BUS_TIMER_HCLK_CLK", "Input clock"},
	{32, 0, "DEV_TIMER7_BUS_TIMER_TCLK_CLK", "Input muxed clock"},
	{32, 1, "DEV_TIMER7_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_TIMER7_BUS_TIMER_TCLK_CLK"},
	{32, 2, "DEV_TIMER7_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER7_BUS_TIMER_TCLK_CLK"},
	{32, 3, "DEV_TIMER7_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_TIMER7_BUS_TIMER_TCLK_CLK"},
	{32, 4, "DEV_TIMER7_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER7_BUS_TIMER_TCLK_CLK"},
	{32, 5, "DEV_TIMER7_BUS_TIMER_TCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER7_BUS_TIMER_TCLK_CLK"},
	{32, 6, "DEV_TIMER7_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER7_BUS_TIMER_TCLK_CLK"},
	{32, 7, "DEV_TIMER7_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER7_BUS_TIMER_TCLK_CLK"},
	{32, 8, "DEV_TIMER7_BUS_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_TIMER7_BUS_TIMER_TCLK_CLK"},
	{32, 9, "DEV_TIMER7_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER7_BUS_TIMER_TCLK_CLK"},
	{32, 10, "DEV_TIMER7_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER7_BUS_TIMER_TCLK_CLK"},
	{32, 11, "DEV_TIMER7_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_WRAP_MAIN_1_BUS_CLKOUT_CLK5", "Parent input clock option to DEV_TIMER7_BUS_TIMER_TCLK_CLK"},
	{32, 12, "DEV_TIMER7_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_TIMER7_BUS_TIMER_TCLK_CLK"},
	{32, 13, "DEV_TIMER7_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF2_0", "Parent input clock option to DEV_TIMER7_BUS_TIMER_TCLK_CLK"},
	{32, 14, "DEV_TIMER7_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF3_0", "Parent input clock option to DEV_TIMER7_BUS_TIMER_TCLK_CLK"},
	{32, 15, "DEV_TIMER7_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF4_0", "Parent input clock option to DEV_TIMER7_BUS_TIMER_TCLK_CLK"},
	{32, 16, "DEV_TIMER7_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF5_0", "Parent input clock option to DEV_TIMER7_BUS_TIMER_TCLK_CLK"},
	{32, 17, "DEV_TIMER7_BUS_TIMER_HCLK_CLK", "Input clock"},
	{33, 0, "DEV_TIMER8_BUS_TIMER_TCLK_CLK", "Input muxed clock"},
	{33, 1, "DEV_TIMER8_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_TIMER8_BUS_TIMER_TCLK_CLK"},
	{33, 2, "DEV_TIMER8_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER8_BUS_TIMER_TCLK_CLK"},
	{33, 3, "DEV_TIMER8_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_TIMER8_BUS_TIMER_TCLK_CLK"},
	{33, 4, "DEV_TIMER8_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER8_BUS_TIMER_TCLK_CLK"},
	{33, 5, "DEV_TIMER8_BUS_TIMER_TCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER8_BUS_TIMER_TCLK_CLK"},
	{33, 6, "DEV_TIMER8_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER8_BUS_TIMER_TCLK_CLK"},
	{33, 7, "DEV_TIMER8_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER8_BUS_TIMER_TCLK_CLK"},
	{33, 8, "DEV_TIMER8_BUS_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_TIMER8_BUS_TIMER_TCLK_CLK"},
	{33, 9, "DEV_TIMER8_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER8_BUS_TIMER_TCLK_CLK"},
	{33, 10, "DEV_TIMER8_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER8_BUS_TIMER_TCLK_CLK"},
	{33, 11, "DEV_TIMER8_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_WRAP_MAIN_1_BUS_CLKOUT_CLK5", "Parent input clock option to DEV_TIMER8_BUS_TIMER_TCLK_CLK"},
	{33, 12, "DEV_TIMER8_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_TIMER8_BUS_TIMER_TCLK_CLK"},
	{33, 13, "DEV_TIMER8_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF2_0", "Parent input clock option to DEV_TIMER8_BUS_TIMER_TCLK_CLK"},
	{33, 14, "DEV_TIMER8_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF3_0", "Parent input clock option to DEV_TIMER8_BUS_TIMER_TCLK_CLK"},
	{33, 15, "DEV_TIMER8_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF4_0", "Parent input clock option to DEV_TIMER8_BUS_TIMER_TCLK_CLK"},
	{33, 16, "DEV_TIMER8_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF5_0", "Parent input clock option to DEV_TIMER8_BUS_TIMER_TCLK_CLK"},
	{33, 17, "DEV_TIMER8_BUS_TIMER_HCLK_CLK", "Input clock"},
	{34, 0, "DEV_TIMER9_BUS_TIMER_TCLK_CLK", "Input muxed clock"},
	{34, 1, "DEV_TIMER9_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_TIMER9_BUS_TIMER_TCLK_CLK"},
	{34, 2, "DEV_TIMER9_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_HFOSC1_CLK_OUT", "Parent input clock option to DEV_TIMER9_BUS_TIMER_TCLK_CLK"},
	{34, 3, "DEV_TIMER9_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_TIMER9_BUS_TIMER_TCLK_CLK"},
	{34, 4, "DEV_TIMER9_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_TIMER9_BUS_TIMER_TCLK_CLK"},
	{34, 5, "DEV_TIMER9_BUS_TIMER_TCLK_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_1_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER9_BUS_TIMER_TCLK_CLK"},
	{34, 6, "DEV_TIMER9_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER9_BUS_TIMER_TCLK_CLK"},
	{34, 7, "DEV_TIMER9_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER9_BUS_TIMER_TCLK_CLK"},
	{34, 8, "DEV_TIMER9_BUS_TIMER_TCLK_CLK_PARENT_GLUELOGIC_LFOSC_CLK_BUS_OUT", "Parent input clock option to DEV_TIMER9_BUS_TIMER_TCLK_CLK"},
	{34, 9, "DEV_TIMER9_BUS_TIMER_TCLK_CLK_PARENT_BOARD_0_BUS_CPTS_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER9_BUS_TIMER_TCLK_CLK"},
	{34, 10, "DEV_TIMER9_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_HSDIV_WRAP_MAIN_2_BUS_HSDIV_CLKOUT2_CLK", "Parent input clock option to DEV_TIMER9_BUS_TIMER_TCLK_CLK"},
	{34, 11, "DEV_TIMER9_BUS_TIMER_TCLK_CLK_PARENT_ADPLLLJM_WRAP_MAIN_1_BUS_CLKOUT_CLK5", "Parent input clock option to DEV_TIMER9_BUS_TIMER_TCLK_CLK"},
	{34, 12, "DEV_TIMER9_BUS_TIMER_TCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_TIMER9_BUS_TIMER_TCLK_CLK"},
	{34, 13, "DEV_TIMER9_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF2_0", "Parent input clock option to DEV_TIMER9_BUS_TIMER_TCLK_CLK"},
	{34, 14, "DEV_TIMER9_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF3_0", "Parent input clock option to DEV_TIMER9_BUS_TIMER_TCLK_CLK"},
	{34, 15, "DEV_TIMER9_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF4_0", "Parent input clock option to DEV_TIMER9_BUS_TIMER_TCLK_CLK"},
	{34, 16, "DEV_TIMER9_BUS_TIMER_TCLK_CLK_PARENT_NAVSS256L_MAIN_0_BUS_CPTS0_GENF5_0", "Parent input clock option to DEV_TIMER9_BUS_TIMER_TCLK_CLK"},
	{34, 17, "DEV_TIMER9_BUS_TIMER_HCLK_CLK", "Input clock"},
	{145, 0, "DEV_TIMESYNC_INTRTR0_BUS_INTR_CLK", "Input clock"},
	{146, 0, "DEV_UART0_BUS_FCLK_CLK", "Input clock"},
	{146, 1, "DEV_UART0_BUS_VBUSP_CLK", "Input clock"},
	{147, 0, "DEV_UART1_BUS_FCLK_CLK", "Input clock"},
	{147, 1, "DEV_UART1_BUS_VBUSP_CLK", "Input clock"},
	{148, 0, "DEV_UART2_BUS_FCLK_CLK", "Input clock"},
	{148, 1, "DEV_UART2_BUS_VBUSP_CLK", "Input clock"},
	{151, 0, "DEV_USB3SS0_BUS_SUSP_CLK", "Input clock"},
	{151, 1, "DEV_USB3SS0_BUS_PHY2_REFCLK960M_CLK", "Input clock"},
	{151, 2, "DEV_USB3SS0_BUS_REF_CLK", "Input muxed clock"},
	{151, 3, "DEV_USB3SS0_BUS_REF_CLK_PARENT_CLOCKMUX_HFOSC_SEL_BUS_OUT0", "Parent input clock option to DEV_USB3SS0_BUS_REF_CLK"},
	{151, 4, "DEV_USB3SS0_BUS_REF_CLK_PARENT_ADPLLLJM_WRAP_MAIN_1_BUS_CLKOUT_CLK48", "Parent input clock option to DEV_USB3SS0_BUS_REF_CLK"},
	{151, 5, "DEV_USB3SS0_BUS_HSIC_CLK_CLK", "Input clock"},
	{151, 6, "DEV_USB3SS0_BUS_BUS_CLK", "Input clock"},
	{151, 7, "DEV_USB3SS0_BUS_PIPE3_TXB_CLK", "Input muxed clock"},
	{151, 8, "DEV_USB3SS0_BUS_PIPE3_TXB_CLK_PARENT_WIZ8B2M4VSB_MAIN_0_BUS_LN0_TXCLK", "Parent input clock option to DEV_USB3SS0_BUS_PIPE3_TXB_CLK"},
	{151, 9, "DEV_USB3SS0_BUS_PIPE3_TXB_CLK_PARENT_CLOCKMUX_USB0_PIPE3_CLK_SEL_DIV_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_USB3SS0_BUS_PIPE3_TXB_CLK"},
	{151, 10, "DEV_USB3SS0_BUS_UTMI_CLK_CLK", "Input clock"},
	{152, 0, "DEV_USB3SS1_BUS_SUSP_CLK", "Input clock"},
	{152, 1, "DEV_USB3SS1_BUS_PHY2_REFCLK960M_CLK", "Input clock"},
	{152, 2, "DEV_USB3SS1_BUS_REF_CLK", "Input muxed clock"},
	{152, 3, "DEV_USB3SS1_BUS_REF_CLK_PARENT_CLOCKMUX_HFOSC_SEL_BUS_OUT0", "Parent input clock option to DEV_USB3SS1_BUS_REF_CLK"},
	{152, 4, "DEV_USB3SS1_BUS_REF_CLK_PARENT_ADPLLLJM_WRAP_MAIN_1_BUS_CLKOUT_CLK48", "Parent input clock option to DEV_USB3SS1_BUS_REF_CLK"},
	{152, 5, "DEV_USB3SS1_BUS_HSIC_CLK_CLK", "Input clock"},
	{152, 6, "DEV_USB3SS1_BUS_BUS_CLK", "Input clock"},
	{152, 7, "DEV_USB3SS1_BUS_PIPE3_TXB_CLK", "Input clock"},
	{152, 8, "DEV_USB3SS1_BUS_UTMI_CLK_CLK", "Input clock"},
	{94, 0, "DEV_WKUP_CBASS0_BUS_WKUP_MCU_PLL_OUT_2_CLK", "Input clock"},
	{94, 1, "DEV_WKUP_CBASS0_BUS_WKUP_MCU_PLL_OUT_4_CLK", "Input clock"},
	{96, 0, "DEV_WKUP_CBASS_FW0_BUS_WKUP_MCU_PLL_OUT_2_CLK", "Input clock"},
	{155, 0, "DEV_WKUP_CTRL_MMR0_BUS_VBUSP_CLK", "Input clock"},
	{22, 0, "DEV_WKUP_DMSC0_BUS_FUNC_32K_RT_CLK", "Input clock"},
	{22, 1, "DEV_WKUP_DMSC0_BUS_FUNC_MOSC_CLK", "Input clock"},
	{22, 2, "DEV_WKUP_DMSC0_BUS_VBUS_CLK", "Input clock"},
	{22, 3, "DEV_WKUP_DMSC0_BUS_FUNC_32K_RC_CLK", "Input clock"},
	{22, 4, "DEV_WKUP_DMSC0_BUS_SEC_EFC_FCLK", "Input clock"},
	{22, 5, "DEV_WKUP_DMSC0_BUS_DAP_CLK", "Input clock"},
	{22, 6, "DEV_WKUP_DMSC0_BUS_EXT_CLK", "Input clock"},
	{95, 0, "DEV_WKUP_ECC_AGGR0_BUS_AGGR_CLK", "Input clock"},
	{54, 0, "DEV_WKUP_ESM0_BUS_CLK", "Input clock"},
	{59, 0, "DEV_WKUP_GPIO0_BUS_MMR_CLK", "Input muxed clock"},
	{59, 1, "DEV_WKUP_GPIO0_BUS_MMR_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_BUS_CHIP_DIV1_CLK_CLK4", "Parent input clock option to DEV_WKUP_GPIO0_BUS_MMR_CLK"},
	{59, 2, "DEV_WKUP_GPIO0_BUS_MMR_CLK_PARENT_K3_PLL_CTRL_WRAP_WKUP_0_BUS_CHIP_DIV1_CLK_CLK4_DUP0", "Parent input clock option to DEV_WKUP_GPIO0_BUS_MMR_CLK"},
	{59, 3, "DEV_WKUP_GPIO0_BUS_MMR_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_32K_CLK", "Parent input clock option to DEV_WKUP_GPIO0_BUS_MMR_CLK"},
	{59, 4, "DEV_WKUP_GPIO0_BUS_MMR_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_RCOSC_12P5M_CLK", "Parent input clock option to DEV_WKUP_GPIO0_BUS_MMR_CLK"},
	{156, 0, "DEV_WKUP_GPIOMUX_INTRTR0_BUS_INTR_CLK", "Input clock"},
	{115, 0, "DEV_WKUP_I2C0_BUS_CLK", "Input clock"},
	{115, 1, "DEV_WKUP_I2C0_BUS_PISYS_CLK", "Input muxed clock"},
	{115, 2, "DEV_WKUP_I2C0_BUS_PISYS_CLK_PARENT_ADPLLM_HSDIV_WRAP_MCU_0_BUS_HSDIV_CLKOUT3_CLK", "Parent input clock option to DEV_WKUP_I2C0_BUS_PISYS_CLK"},
	{115, 3, "DEV_WKUP_I2C0_BUS_PISYS_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_WKUP_I2C0_BUS_PISYS_CLK"},
	{115, 4, "DEV_WKUP_I2C0_BUS_PISCL", "Output clock"},
	{77, 0, "DEV_WKUP_PLLCTRL0_BUS_VBUS_SLV_REFCLK_CLK", "Input clock"},
	{77, 1, "DEV_WKUP_PLLCTRL0_BUS_PLL_CLKOUT_CLK", "Input clock"},
	{77, 2, "DEV_WKUP_PLLCTRL0_BUS_PLL_REFCLK_CLK", "Input clock"},
	{79, 0, "DEV_WKUP_PSC0_BUS_CLK", "Input clock"},
	{79, 1, "DEV_WKUP_PSC0_BUS_SLOW_CLK", "Input clock"},
	{150, 0, "DEV_WKUP_UART0_BUS_FCLK_CLK", "Input muxed clock"},
	{150, 1, "DEV_WKUP_UART0_BUS_FCLK_CLK_PARENT_CLOCKMUX_WKUPUSART_CLK_SEL_BUS_OUT0", "Parent input clock option to DEV_WKUP_UART0_BUS_FCLK_CLK"},
	{150, 2, "DEV_WKUP_UART0_BUS_FCLK_CLK_PARENT_MX_WAKEUP_GS80_WKUP_0_BUS_WKUP_OSC0_CLK", "Parent input clock option to DEV_WKUP_UART0_BUS_FCLK_CLK"},
	{150, 3, "DEV_WKUP_UART0_BUS_VBUSP_CLK", "Input clock"},
	{80, 0, "DEV_WKUP_VTM0_BUS_FIX_REF_CLK", "Input clock"},
	{80, 1, "DEV_WKUP_VTM0_BUS_VBUSP_CLK", "Input clock"},
};
