/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import org.fusesource.scalate.RenderContext

package

/**
 * <p>
 * </p>
 *
 * @author <a href="http://hiramchirino.com">Hiram Chirino</a>
 */
object Website {

  val project_name= "HawtDispatch"
  val project_slogan= "The libdispatch style API for Java and Scala"
  val project_id= "hawtdispatch"
  val project_jira_key= "HAWTDISPATCH"
  val project_issue_url= "http://hawtdispatch.assembla.com/spaces/hawtdispatch/support/tickets"
  val project_forums_url= "http://groups.google.com/group/hawtdispatch"
  val project_wiki_url= "http://wiki.github.com/fusesource/hawtdispatch"
  val project_logo= "/images/project-logo.png"
  val project_version= "1.16"
  val project_snapshot_version= "1.17-SNAPSHOT"
  val project_versions = List(
        project_version,
        "1.15",
        "1.14","1.13","1.12","1.11","1.10",
        "1.9","1.8","1.7","1.6","1.5","1.4","1.3","1.2","1.1","1.0")  

  val project_keywords= "dispatch,executor,java,scala,libdispatch,gcd,actor,thread,pool"

  // -------------------------------------------------------------------
  val github_page = "http://github.com/fusesource/hawtdispatch"
  val git_user_url = "git://github.com/fusesource/hawtdispatch.git"
  val git_commiter_url = "git@github.com:fusesource/hawtdispatch.git"
  
  val project_maven_groupId= "org.fusesource.hawtdispatch"
  val project_maven_artifactId= "hawtdispatch"

  val website_base_url= "http://hawtdispatch.fusesource.org"
  
  val api_dir = "http://hawtdispatch.fusesource.org/versions/"+project_version+"/maven/hawtdispatch/apidocs/org/fusesource/hawtdispatch"
  val scala_api_dir = "http://hawtdispatch.fusesource.org/versions/"+project_version+"/maven/hawtdispatch-scala/scaladocs"

}