/*
 * JIS X 0208 implementation for libcharset. (This is the character
 * set itself, not any particular multibyte encoding of it.
 * Multibyte encodings of this character set are handled
 * separately.)
 */

#include <assert.h>

#include "charset.h"
#include "internal.h"

/*
 * These tables are generated from the JIS X 0208 <-> Unicode
 * character mapping found at
 * 
 * http://www.unicode.org/Public/MAPPINGS/OBSOLETE/EASTASIA/JIS/JIS0208.TXT
 */

/*
 * Mapping from JIS X 0208 to Unicode. For these purposes JIS X
 * 0208 is considered to be a 94x94 square array, with coordinates
 * running from (0,0) to (93,93).
 * 
 * Generated by running the following sh+Perl over JIS0208.TXT:

cat JIS0208.TXT | \
perl -ne '$a{hex$1,hex$2}=$3 if /^[^#]\S+\s+0x(\S\S)(\S\S)\s+(0x\S+)\s/;' \
      -e 'END {for $r (0..93) { $o="    {"; for $c (0..93) {' \
      -e '$k=$a{$r+33,$c+33}; $k=" ERROR" unless defined $k;' \
      -e '$o .= ", " if $c > 0; (print "$o\n"), $o="    " if length $o > 70;' \
      -e '$o .= $k; } print "$o},\n"; }}'

 */

static const unsigned short jisx0208_forward[94][94] = {
    {0x3000, 0x3001, 0x3002, 0xFF0C, 0xFF0E, 0x30FB, 0xFF1A, 0xFF1B, 0xFF1F, 
    0xFF01, 0x309B, 0x309C, 0x00B4, 0xFF40, 0x00A8, 0xFF3E, 0xFFE3, 0xFF3F, 
    0x30FD, 0x30FE, 0x309D, 0x309E, 0x3003, 0x4EDD, 0x3005, 0x3006, 0x3007, 
    0x30FC, 0x2015, 0x2010, 0xFF0F, 0x005C, 0x301C, 0x2016, 0xFF5C, 0x2026, 
    0x2025, 0x2018, 0x2019, 0x201C, 0x201D, 0xFF08, 0xFF09, 0x3014, 0x3015, 
    0xFF3B, 0xFF3D, 0xFF5B, 0xFF5D, 0x3008, 0x3009, 0x300A, 0x300B, 0x300C, 
    0x300D, 0x300E, 0x300F, 0x3010, 0x3011, 0xFF0B, 0x2212, 0x00B1, 0x00D7, 
    0x00F7, 0xFF1D, 0x2260, 0xFF1C, 0xFF1E, 0x2266, 0x2267, 0x221E, 0x2234, 
    0x2642, 0x2640, 0x00B0, 0x2032, 0x2033, 0x2103, 0xFFE5, 0xFF04, 0x00A2, 
    0x00A3, 0xFF05, 0xFF03, 0xFF06, 0xFF0A, 0xFF20, 0x00A7, 0x2606, 0x2605, 
    0x25CB, 0x25CF, 0x25CE, 0x25C7},
    {0x25C6, 0x25A1, 0x25A0, 0x25B3, 0x25B2, 0x25BD, 0x25BC, 0x203B, 0x3012, 
    0x2192, 0x2190, 0x2191, 0x2193, 0x3013,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 0x2208, 0x220B, 
    0x2286, 0x2287, 0x2282, 0x2283, 0x222A, 0x2229,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 0x2227, 0x2228, 0x00AC, 0x21D2, 
    0x21D4, 0x2200, 0x2203,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 0x2220, 0x22A5, 0x2312, 0x2202, 
    0x2207, 0x2261, 0x2252, 0x226A, 0x226B, 0x221A, 0x223D, 0x221D, 0x2235, 
    0x222B, 0x222C,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
    0x212B, 0x2030, 0x266F, 0x266D, 0x266A, 0x2020, 0x2021, 0x00B6,  ERROR, 
     ERROR,  ERROR,  ERROR, 0x25EF},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 0xFF10, 0xFF11, 0xFF12, 
    0xFF13, 0xFF14, 0xFF15, 0xFF16, 0xFF17, 0xFF18, 0xFF19,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 0xFF21, 0xFF22, 0xFF23, 0xFF24, 
    0xFF25, 0xFF26, 0xFF27, 0xFF28, 0xFF29, 0xFF2A, 0xFF2B, 0xFF2C, 0xFF2D, 
    0xFF2E, 0xFF2F, 0xFF30, 0xFF31, 0xFF32, 0xFF33, 0xFF34, 0xFF35, 0xFF36, 
    0xFF37, 0xFF38, 0xFF39, 0xFF3A,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR, 0xFF41, 0xFF42, 0xFF43, 0xFF44, 0xFF45, 0xFF46, 0xFF47, 0xFF48, 
    0xFF49, 0xFF4A, 0xFF4B, 0xFF4C, 0xFF4D, 0xFF4E, 0xFF4F, 0xFF50, 0xFF51, 
    0xFF52, 0xFF53, 0xFF54, 0xFF55, 0xFF56, 0xFF57, 0xFF58, 0xFF59, 0xFF5A, 
     ERROR,  ERROR,  ERROR,  ERROR},
    {0x3041, 0x3042, 0x3043, 0x3044, 0x3045, 0x3046, 0x3047, 0x3048, 0x3049, 
    0x304A, 0x304B, 0x304C, 0x304D, 0x304E, 0x304F, 0x3050, 0x3051, 0x3052, 
    0x3053, 0x3054, 0x3055, 0x3056, 0x3057, 0x3058, 0x3059, 0x305A, 0x305B, 
    0x305C, 0x305D, 0x305E, 0x305F, 0x3060, 0x3061, 0x3062, 0x3063, 0x3064, 
    0x3065, 0x3066, 0x3067, 0x3068, 0x3069, 0x306A, 0x306B, 0x306C, 0x306D, 
    0x306E, 0x306F, 0x3070, 0x3071, 0x3072, 0x3073, 0x3074, 0x3075, 0x3076,
    0x3077, 0x3078, 0x3079, 0x307A, 0x307B, 0x307C, 0x307D, 0x307E, 0x307F, 
    0x3080, 0x3081, 0x3082, 0x3083, 0x3084, 0x3085, 0x3086, 0x3087, 0x3088, 
    0x3089, 0x308A, 0x308B, 0x308C, 0x308D, 0x308E, 0x308F, 0x3090, 0x3091, 
    0x3092, 0x3093,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    {0x30A1, 0x30A2, 0x30A3, 0x30A4, 0x30A5, 0x30A6, 0x30A7, 0x30A8, 0x30A9, 
    0x30AA, 0x30AB, 0x30AC, 0x30AD, 0x30AE, 0x30AF, 0x30B0, 0x30B1, 0x30B2, 
    0x30B3, 0x30B4, 0x30B5, 0x30B6, 0x30B7, 0x30B8, 0x30B9, 0x30BA, 0x30BB, 
    0x30BC, 0x30BD, 0x30BE, 0x30BF, 0x30C0, 0x30C1, 0x30C2, 0x30C3, 0x30C4, 
    0x30C5, 0x30C6, 0x30C7, 0x30C8, 0x30C9, 0x30CA, 0x30CB, 0x30CC, 0x30CD, 
    0x30CE, 0x30CF, 0x30D0, 0x30D1, 0x30D2, 0x30D3, 0x30D4, 0x30D5, 0x30D6, 
    0x30D7, 0x30D8, 0x30D9, 0x30DA, 0x30DB, 0x30DC, 0x30DD, 0x30DE, 0x30DF, 
    0x30E0, 0x30E1, 0x30E2, 0x30E3, 0x30E4, 0x30E5, 0x30E6, 0x30E7, 0x30E8, 
    0x30E9, 0x30EA, 0x30EB, 0x30EC, 0x30ED, 0x30EE, 0x30EF, 0x30F0, 0x30F1, 
    0x30F2, 0x30F3, 0x30F4, 0x30F5, 0x30F6,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    {0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 0x0399, 
    0x039A, 0x039B, 0x039C, 0x039D, 0x039E, 0x039F, 0x03A0, 0x03A1, 0x03A3, 
    0x03A4, 0x03A5, 0x03A6, 0x03A7, 0x03A8, 0x03A9,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 
    0x03B5, 0x03B6, 0x03B7, 0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD, 
    0x03BE, 0x03BF, 0x03C0, 0x03C1, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7, 
    0x03C8, 0x03C9,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    {0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0401, 0x0416, 0x0417, 
    0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 0x041F, 0x0420, 
    0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 
    0x042A, 0x042B, 0x042C, 0x042D, 0x042E, 0x042F,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR, 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 
    0x0451, 0x0436, 0x0437, 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 
    0x043E, 0x043F, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 
    0x0447, 0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    {0x2500, 0x2502, 0x250C, 0x2510, 0x2518, 0x2514, 0x251C, 0x252C, 0x2524, 
    0x2534, 0x253C, 0x2501, 0x2503, 0x250F, 0x2513, 0x251B, 0x2517, 0x2523, 
    0x2533, 0x252B, 0x253B, 0x254B, 0x2520, 0x252F, 0x2528, 0x2537, 0x253F, 
    0x251D, 0x2530, 0x2525, 0x2538, 0x2542,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    {0x4E9C, 0x5516, 0x5A03, 0x963F, 0x54C0, 0x611B, 0x6328, 0x59F6, 0x9022, 
    0x8475, 0x831C, 0x7A50, 0x60AA, 0x63E1, 0x6E25, 0x65ED, 0x8466, 0x82A6, 
    0x9BF5, 0x6893, 0x5727, 0x65A1, 0x6271, 0x5B9B, 0x59D0, 0x867B, 0x98F4, 
    0x7D62, 0x7DBE, 0x9B8E, 0x6216, 0x7C9F, 0x88B7, 0x5B89, 0x5EB5, 0x6309, 
    0x6697, 0x6848, 0x95C7, 0x978D, 0x674F, 0x4EE5, 0x4F0A, 0x4F4D, 0x4F9D, 
    0x5049, 0x56F2, 0x5937, 0x59D4, 0x5A01, 0x5C09, 0x60DF, 0x610F, 0x6170, 
    0x6613, 0x6905, 0x70BA, 0x754F, 0x7570, 0x79FB, 0x7DAD, 0x7DEF, 0x80C3, 
    0x840E, 0x8863, 0x8B02, 0x9055, 0x907A, 0x533B, 0x4E95, 0x4EA5, 0x57DF, 
    0x80B2, 0x90C1, 0x78EF, 0x4E00, 0x58F1, 0x6EA2, 0x9038, 0x7A32, 0x8328, 
    0x828B, 0x9C2F, 0x5141, 0x5370, 0x54BD, 0x54E1, 0x56E0, 0x59FB, 0x5F15, 
    0x98F2, 0x6DEB, 0x80E4, 0x852D},
    {0x9662, 0x9670, 0x96A0, 0x97FB, 0x540B, 0x53F3, 0x5B87, 0x70CF, 0x7FBD, 
    0x8FC2, 0x96E8, 0x536F, 0x9D5C, 0x7ABA, 0x4E11, 0x7893, 0x81FC, 0x6E26, 
    0x5618, 0x5504, 0x6B1D, 0x851A, 0x9C3B, 0x59E5, 0x53A9, 0x6D66, 0x74DC, 
    0x958F, 0x5642, 0x4E91, 0x904B, 0x96F2, 0x834F, 0x990C, 0x53E1, 0x55B6, 
    0x5B30, 0x5F71, 0x6620, 0x66F3, 0x6804, 0x6C38, 0x6CF3, 0x6D29, 0x745B, 
    0x76C8, 0x7A4E, 0x9834, 0x82F1, 0x885B, 0x8A60, 0x92ED, 0x6DB2, 0x75AB, 
    0x76CA, 0x99C5, 0x60A6, 0x8B01, 0x8D8A, 0x95B2, 0x698E, 0x53AD, 0x5186, 
    0x5712, 0x5830, 0x5944, 0x5BB4, 0x5EF6, 0x6028, 0x63A9, 0x63F4, 0x6CBF, 
    0x6F14, 0x708E, 0x7114, 0x7159, 0x71D5, 0x733F, 0x7E01, 0x8276, 0x82D1, 
    0x8597, 0x9060, 0x925B, 0x9D1B, 0x5869, 0x65BC, 0x6C5A, 0x7525, 0x51F9, 
    0x592E, 0x5965, 0x5F80, 0x5FDC},
    {0x62BC, 0x65FA, 0x6A2A, 0x6B27, 0x6BB4, 0x738B, 0x7FC1, 0x8956, 0x9D2C, 
    0x9D0E, 0x9EC4, 0x5CA1, 0x6C96, 0x837B, 0x5104, 0x5C4B, 0x61B6, 0x81C6, 
    0x6876, 0x7261, 0x4E59, 0x4FFA, 0x5378, 0x6069, 0x6E29, 0x7A4F, 0x97F3, 
    0x4E0B, 0x5316, 0x4EEE, 0x4F55, 0x4F3D, 0x4FA1, 0x4F73, 0x52A0, 0x53EF, 
    0x5609, 0x590F, 0x5AC1, 0x5BB6, 0x5BE1, 0x79D1, 0x6687, 0x679C, 0x67B6, 
    0x6B4C, 0x6CB3, 0x706B, 0x73C2, 0x798D, 0x79BE, 0x7A3C, 0x7B87, 0x82B1, 
    0x82DB, 0x8304, 0x8377, 0x83EF, 0x83D3, 0x8766, 0x8AB2, 0x5629, 0x8CA8, 
    0x8FE6, 0x904E, 0x971E, 0x868A, 0x4FC4, 0x5CE8, 0x6211, 0x7259, 0x753B, 
    0x81E5, 0x82BD, 0x86FE, 0x8CC0, 0x96C5, 0x9913, 0x99D5, 0x4ECB, 0x4F1A, 
    0x89E3, 0x56DE, 0x584A, 0x58CA, 0x5EFB, 0x5FEB, 0x602A, 0x6094, 0x6062, 
    0x61D0, 0x6212, 0x62D0, 0x6539},
    {0x9B41, 0x6666, 0x68B0, 0x6D77, 0x7070, 0x754C, 0x7686, 0x7D75, 0x82A5, 
    0x87F9, 0x958B, 0x968E, 0x8C9D, 0x51F1, 0x52BE, 0x5916, 0x54B3, 0x5BB3, 
    0x5D16, 0x6168, 0x6982, 0x6DAF, 0x788D, 0x84CB, 0x8857, 0x8A72, 0x93A7, 
    0x9AB8, 0x6D6C, 0x99A8, 0x86D9, 0x57A3, 0x67FF, 0x86CE, 0x920E, 0x5283, 
    0x5687, 0x5404, 0x5ED3, 0x62E1, 0x64B9, 0x683C, 0x6838, 0x6BBB, 0x7372, 
    0x78BA, 0x7A6B, 0x899A, 0x89D2, 0x8D6B, 0x8F03, 0x90ED, 0x95A3, 0x9694, 
    0x9769, 0x5B66, 0x5CB3, 0x697D, 0x984D, 0x984E, 0x639B, 0x7B20, 0x6A2B, 
    0x6A7F, 0x68B6, 0x9C0D, 0x6F5F, 0x5272, 0x559D, 0x6070, 0x62EC, 0x6D3B, 
    0x6E07, 0x6ED1, 0x845B, 0x8910, 0x8F44, 0x4E14, 0x9C39, 0x53F6, 0x691B, 
    0x6A3A, 0x9784, 0x682A, 0x515C, 0x7AC3, 0x84B2, 0x91DC, 0x938C, 0x565B, 
    0x9D28, 0x6822, 0x8305, 0x8431},
    {0x7CA5, 0x5208, 0x82C5, 0x74E6, 0x4E7E, 0x4F83, 0x51A0, 0x5BD2, 0x520A, 
    0x52D8, 0x52E7, 0x5DFB, 0x559A, 0x582A, 0x59E6, 0x5B8C, 0x5B98, 0x5BDB, 
    0x5E72, 0x5E79, 0x60A3, 0x611F, 0x6163, 0x61BE, 0x63DB, 0x6562, 0x67D1, 
    0x6853, 0x68FA, 0x6B3E, 0x6B53, 0x6C57, 0x6F22, 0x6F97, 0x6F45, 0x74B0, 
    0x7518, 0x76E3, 0x770B, 0x7AFF, 0x7BA1, 0x7C21, 0x7DE9, 0x7F36, 0x7FF0, 
    0x809D, 0x8266, 0x839E, 0x89B3, 0x8ACC, 0x8CAB, 0x9084, 0x9451, 0x9593, 
    0x9591, 0x95A2, 0x9665, 0x97D3, 0x9928, 0x8218, 0x4E38, 0x542B, 0x5CB8, 
    0x5DCC, 0x73A9, 0x764C, 0x773C, 0x5CA9, 0x7FEB, 0x8D0B, 0x96C1, 0x9811, 
    0x9854, 0x9858, 0x4F01, 0x4F0E, 0x5371, 0x559C, 0x5668, 0x57FA, 0x5947, 
    0x5B09, 0x5BC4, 0x5C90, 0x5E0C, 0x5E7E, 0x5FCC, 0x63EE, 0x673A, 0x65D7, 
    0x65E2, 0x671F, 0x68CB, 0x68C4},
    {0x6A5F, 0x5E30, 0x6BC5, 0x6C17, 0x6C7D, 0x757F, 0x7948, 0x5B63, 0x7A00, 
    0x7D00, 0x5FBD, 0x898F, 0x8A18, 0x8CB4, 0x8D77, 0x8ECC, 0x8F1D, 0x98E2, 
    0x9A0E, 0x9B3C, 0x4E80, 0x507D, 0x5100, 0x5993, 0x5B9C, 0x622F, 0x6280, 
    0x64EC, 0x6B3A, 0x72A0, 0x7591, 0x7947, 0x7FA9, 0x87FB, 0x8ABC, 0x8B70, 
    0x63AC, 0x83CA, 0x97A0, 0x5409, 0x5403, 0x55AB, 0x6854, 0x6A58, 0x8A70, 
    0x7827, 0x6775, 0x9ECD, 0x5374, 0x5BA2, 0x811A, 0x8650, 0x9006, 0x4E18, 
    0x4E45, 0x4EC7, 0x4F11, 0x53CA, 0x5438, 0x5BAE, 0x5F13, 0x6025, 0x6551, 
    0x673D, 0x6C42, 0x6C72, 0x6CE3, 0x7078, 0x7403, 0x7A76, 0x7AAE, 0x7B08, 
    0x7D1A, 0x7CFE, 0x7D66, 0x65E7, 0x725B, 0x53BB, 0x5C45, 0x5DE8, 0x62D2, 
    0x62E0, 0x6319, 0x6E20, 0x865A, 0x8A31, 0x8DDD, 0x92F8, 0x6F01, 0x79A6, 
    0x9B5A, 0x4EA8, 0x4EAB, 0x4EAC},
    {0x4F9B, 0x4FA0, 0x50D1, 0x5147, 0x7AF6, 0x5171, 0x51F6, 0x5354, 0x5321, 
    0x537F, 0x53EB, 0x55AC, 0x5883, 0x5CE1, 0x5F37, 0x5F4A, 0x602F, 0x6050, 
    0x606D, 0x631F, 0x6559, 0x6A4B, 0x6CC1, 0x72C2, 0x72ED, 0x77EF, 0x80F8, 
    0x8105, 0x8208, 0x854E, 0x90F7, 0x93E1, 0x97FF, 0x9957, 0x9A5A, 0x4EF0, 
    0x51DD, 0x5C2D, 0x6681, 0x696D, 0x5C40, 0x66F2, 0x6975, 0x7389, 0x6850, 
    0x7C81, 0x50C5, 0x52E4, 0x5747, 0x5DFE, 0x9326, 0x65A4, 0x6B23, 0x6B3D, 
    0x7434, 0x7981, 0x79BD, 0x7B4B, 0x7DCA, 0x82B9, 0x83CC, 0x887F, 0x895F, 
    0x8B39, 0x8FD1, 0x91D1, 0x541F, 0x9280, 0x4E5D, 0x5036, 0x53E5, 0x533A, 
    0x72D7, 0x7396, 0x77E9, 0x82E6, 0x8EAF, 0x99C6, 0x99C8, 0x99D2, 0x5177, 
    0x611A, 0x865E, 0x55B0, 0x7A7A, 0x5076, 0x5BD3, 0x9047, 0x9685, 0x4E32, 
    0x6ADB, 0x91E7, 0x5C51, 0x5C48},
    {0x6398, 0x7A9F, 0x6C93, 0x9774, 0x8F61, 0x7AAA, 0x718A, 0x9688, 0x7C82, 
    0x6817, 0x7E70, 0x6851, 0x936C, 0x52F2, 0x541B, 0x85AB, 0x8A13, 0x7FA4, 
    0x8ECD, 0x90E1, 0x5366, 0x8888, 0x7941, 0x4FC2, 0x50BE, 0x5211, 0x5144, 
    0x5553, 0x572D, 0x73EA, 0x578B, 0x5951, 0x5F62, 0x5F84, 0x6075, 0x6176, 
    0x6167, 0x61A9, 0x63B2, 0x643A, 0x656C, 0x666F, 0x6842, 0x6E13, 0x7566, 
    0x7A3D, 0x7CFB, 0x7D4C, 0x7D99, 0x7E4B, 0x7F6B, 0x830E, 0x834A, 0x86CD, 
    0x8A08, 0x8A63, 0x8B66, 0x8EFD, 0x981A, 0x9D8F, 0x82B8, 0x8FCE, 0x9BE8, 
    0x5287, 0x621F, 0x6483, 0x6FC0, 0x9699, 0x6841, 0x5091, 0x6B20, 0x6C7A, 
    0x6F54, 0x7A74, 0x7D50, 0x8840, 0x8A23, 0x6708, 0x4EF6, 0x5039, 0x5026, 
    0x5065, 0x517C, 0x5238, 0x5263, 0x55A7, 0x570F, 0x5805, 0x5ACC, 0x5EFA, 
    0x61B2, 0x61F8, 0x62F3, 0x6372},
    {0x691C, 0x6A29, 0x727D, 0x72AC, 0x732E, 0x7814, 0x786F, 0x7D79, 0x770C, 
    0x80A9, 0x898B, 0x8B19, 0x8CE2, 0x8ED2, 0x9063, 0x9375, 0x967A, 0x9855, 
    0x9A13, 0x9E78, 0x5143, 0x539F, 0x53B3, 0x5E7B, 0x5F26, 0x6E1B, 0x6E90, 
    0x7384, 0x73FE, 0x7D43, 0x8237, 0x8A00, 0x8AFA, 0x9650, 0x4E4E, 0x500B, 
    0x53E4, 0x547C, 0x56FA, 0x59D1, 0x5B64, 0x5DF1, 0x5EAB, 0x5F27, 0x6238, 
    0x6545, 0x67AF, 0x6E56, 0x72D0, 0x7CCA, 0x88B4, 0x80A1, 0x80E1, 0x83F0, 
    0x864E, 0x8A87, 0x8DE8, 0x9237, 0x96C7, 0x9867, 0x9F13, 0x4E94, 0x4E92, 
    0x4F0D, 0x5348, 0x5449, 0x543E, 0x5A2F, 0x5F8C, 0x5FA1, 0x609F, 0x68A7, 
    0x6A8E, 0x745A, 0x7881, 0x8A9E, 0x8AA4, 0x8B77, 0x9190, 0x4E5E, 0x9BC9, 
    0x4EA4, 0x4F7C, 0x4FAF, 0x5019, 0x5016, 0x5149, 0x516C, 0x529F, 0x52B9, 
    0x52FE, 0x539A, 0x53E3, 0x5411},
    {0x540E, 0x5589, 0x5751, 0x57A2, 0x597D, 0x5B54, 0x5B5D, 0x5B8F, 0x5DE5, 
    0x5DE7, 0x5DF7, 0x5E78, 0x5E83, 0x5E9A, 0x5EB7, 0x5F18, 0x6052, 0x614C, 
    0x6297, 0x62D8, 0x63A7, 0x653B, 0x6602, 0x6643, 0x66F4, 0x676D, 0x6821, 
    0x6897, 0x69CB, 0x6C5F, 0x6D2A, 0x6D69, 0x6E2F, 0x6E9D, 0x7532, 0x7687, 
    0x786C, 0x7A3F, 0x7CE0, 0x7D05, 0x7D18, 0x7D5E, 0x7DB1, 0x8015, 0x8003, 
    0x80AF, 0x80B1, 0x8154, 0x818F, 0x822A, 0x8352, 0x884C, 0x8861, 0x8B1B, 
    0x8CA2, 0x8CFC, 0x90CA, 0x9175, 0x9271, 0x783F, 0x92FC, 0x95A4, 0x964D, 
    0x9805, 0x9999, 0x9AD8, 0x9D3B, 0x525B, 0x52AB, 0x53F7, 0x5408, 0x58D5, 
    0x62F7, 0x6FE0, 0x8C6A, 0x8F5F, 0x9EB9, 0x514B, 0x523B, 0x544A, 0x56FD, 
    0x7A40, 0x9177, 0x9D60, 0x9ED2, 0x7344, 0x6F09, 0x8170, 0x7511, 0x5FFD, 
    0x60DA, 0x9AA8, 0x72DB, 0x8FBC},
    {0x6B64, 0x9803, 0x4ECA, 0x56F0, 0x5764, 0x58BE, 0x5A5A, 0x6068, 0x61C7, 
    0x660F, 0x6606, 0x6839, 0x68B1, 0x6DF7, 0x75D5, 0x7D3A, 0x826E, 0x9B42, 
    0x4E9B, 0x4F50, 0x53C9, 0x5506, 0x5D6F, 0x5DE6, 0x5DEE, 0x67FB, 0x6C99, 
    0x7473, 0x7802, 0x8A50, 0x9396, 0x88DF, 0x5750, 0x5EA7, 0x632B, 0x50B5, 
    0x50AC, 0x518D, 0x6700, 0x54C9, 0x585E, 0x59BB, 0x5BB0, 0x5F69, 0x624D, 
    0x63A1, 0x683D, 0x6B73, 0x6E08, 0x707D, 0x91C7, 0x7280, 0x7815, 0x7826, 
    0x796D, 0x658E, 0x7D30, 0x83DC, 0x88C1, 0x8F09, 0x969B, 0x5264, 0x5728, 
    0x6750, 0x7F6A, 0x8CA1, 0x51B4, 0x5742, 0x962A, 0x583A, 0x698A, 0x80B4, 
    0x54B2, 0x5D0E, 0x57FC, 0x7895, 0x9DFA, 0x4F5C, 0x524A, 0x548B, 0x643E, 
    0x6628, 0x6714, 0x67F5, 0x7A84, 0x7B56, 0x7D22, 0x932F, 0x685C, 0x9BAD, 
    0x7B39, 0x5319, 0x518A, 0x5237},
    {0x5BDF, 0x62F6, 0x64AE, 0x64E6, 0x672D, 0x6BBA, 0x85A9, 0x96D1, 0x7690, 
    0x9BD6, 0x634C, 0x9306, 0x9BAB, 0x76BF, 0x6652, 0x4E09, 0x5098, 0x53C2, 
    0x5C71, 0x60E8, 0x6492, 0x6563, 0x685F, 0x71E6, 0x73CA, 0x7523, 0x7B97, 
    0x7E82, 0x8695, 0x8B83, 0x8CDB, 0x9178, 0x9910, 0x65AC, 0x66AB, 0x6B8B, 
    0x4ED5, 0x4ED4, 0x4F3A, 0x4F7F, 0x523A, 0x53F8, 0x53F2, 0x55E3, 0x56DB, 
    0x58EB, 0x59CB, 0x59C9, 0x59FF, 0x5B50, 0x5C4D, 0x5E02, 0x5E2B, 0x5FD7, 
    0x601D, 0x6307, 0x652F, 0x5B5C, 0x65AF, 0x65BD, 0x65E8, 0x679D, 0x6B62, 
    0x6B7B, 0x6C0F, 0x7345, 0x7949, 0x79C1, 0x7CF8, 0x7D19, 0x7D2B, 0x80A2, 
    0x8102, 0x81F3, 0x8996, 0x8A5E, 0x8A69, 0x8A66, 0x8A8C, 0x8AEE, 0x8CC7, 
    0x8CDC, 0x96CC, 0x98FC, 0x6B6F, 0x4E8B, 0x4F3C, 0x4F8D, 0x5150, 0x5B57, 
    0x5BFA, 0x6148, 0x6301, 0x6642},
    {0x6B21, 0x6ECB, 0x6CBB, 0x723E, 0x74BD, 0x75D4, 0x78C1, 0x793A, 0x800C, 
    0x8033, 0x81EA, 0x8494, 0x8F9E, 0x6C50, 0x9E7F, 0x5F0F, 0x8B58, 0x9D2B, 
    0x7AFA, 0x8EF8, 0x5B8D, 0x96EB, 0x4E03, 0x53F1, 0x57F7, 0x5931, 0x5AC9, 
    0x5BA4, 0x6089, 0x6E7F, 0x6F06, 0x75BE, 0x8CEA, 0x5B9F, 0x8500, 0x7BE0, 
    0x5072, 0x67F4, 0x829D, 0x5C61, 0x854A, 0x7E1E, 0x820E, 0x5199, 0x5C04, 
    0x6368, 0x8D66, 0x659C, 0x716E, 0x793E, 0x7D17, 0x8005, 0x8B1D, 0x8ECA, 
    0x906E, 0x86C7, 0x90AA, 0x501F, 0x52FA, 0x5C3A, 0x6753, 0x707C, 0x7235, 
    0x914C, 0x91C8, 0x932B, 0x82E5, 0x5BC2, 0x5F31, 0x60F9, 0x4E3B, 0x53D6, 
    0x5B88, 0x624B, 0x6731, 0x6B8A, 0x72E9, 0x73E0, 0x7A2E, 0x816B, 0x8DA3, 
    0x9152, 0x9996, 0x5112, 0x53D7, 0x546A, 0x5BFF, 0x6388, 0x6A39, 0x7DAC, 
    0x9700, 0x56DA, 0x53CE, 0x5468},
    {0x5B97, 0x5C31, 0x5DDE, 0x4FEE, 0x6101, 0x62FE, 0x6D32, 0x79C0, 0x79CB, 
    0x7D42, 0x7E4D, 0x7FD2, 0x81ED, 0x821F, 0x8490, 0x8846, 0x8972, 0x8B90, 
    0x8E74, 0x8F2F, 0x9031, 0x914B, 0x916C, 0x96C6, 0x919C, 0x4EC0, 0x4F4F, 
    0x5145, 0x5341, 0x5F93, 0x620E, 0x67D4, 0x6C41, 0x6E0B, 0x7363, 0x7E26, 
    0x91CD, 0x9283, 0x53D4, 0x5919, 0x5BBF, 0x6DD1, 0x795D, 0x7E2E, 0x7C9B, 
    0x587E, 0x719F, 0x51FA, 0x8853, 0x8FF0, 0x4FCA, 0x5CFB, 0x6625, 0x77AC, 
    0x7AE3, 0x821C, 0x99FF, 0x51C6, 0x5FAA, 0x65EC, 0x696F, 0x6B89, 0x6DF3, 
    0x6E96, 0x6F64, 0x76FE, 0x7D14, 0x5DE1, 0x9075, 0x9187, 0x9806, 0x51E6, 
    0x521D, 0x6240, 0x6691, 0x66D9, 0x6E1A, 0x5EB6, 0x7DD2, 0x7F72, 0x66F8, 
    0x85AF, 0x85F7, 0x8AF8, 0x52A9, 0x53D9, 0x5973, 0x5E8F, 0x5F90, 0x6055, 
    0x92E4, 0x9664, 0x50B7, 0x511F},
    {0x52DD, 0x5320, 0x5347, 0x53EC, 0x54E8, 0x5546, 0x5531, 0x5617, 0x5968, 
    0x59BE, 0x5A3C, 0x5BB5, 0x5C06, 0x5C0F, 0x5C11, 0x5C1A, 0x5E84, 0x5E8A, 
    0x5EE0, 0x5F70, 0x627F, 0x6284, 0x62DB, 0x638C, 0x6377, 0x6607, 0x660C, 
    0x662D, 0x6676, 0x677E, 0x68A2, 0x6A1F, 0x6A35, 0x6CBC, 0x6D88, 0x6E09, 
    0x6E58, 0x713C, 0x7126, 0x7167, 0x75C7, 0x7701, 0x785D, 0x7901, 0x7965, 
    0x79F0, 0x7AE0, 0x7B11, 0x7CA7, 0x7D39, 0x8096, 0x83D6, 0x848B, 0x8549, 
    0x885D, 0x88F3, 0x8A1F, 0x8A3C, 0x8A54, 0x8A73, 0x8C61, 0x8CDE, 0x91A4, 
    0x9266, 0x937E, 0x9418, 0x969C, 0x9798, 0x4E0A, 0x4E08, 0x4E1E, 0x4E57, 
    0x5197, 0x5270, 0x57CE, 0x5834, 0x58CC, 0x5B22, 0x5E38, 0x60C5, 0x64FE, 
    0x6761, 0x6756, 0x6D44, 0x72B6, 0x7573, 0x7A63, 0x84B8, 0x8B72, 0x91B8, 
    0x9320, 0x5631, 0x57F4, 0x98FE},
    {0x62ED, 0x690D, 0x6B96, 0x71ED, 0x7E54, 0x8077, 0x8272, 0x89E6, 0x98DF, 
    0x8755, 0x8FB1, 0x5C3B, 0x4F38, 0x4FE1, 0x4FB5, 0x5507, 0x5A20, 0x5BDD, 
    0x5BE9, 0x5FC3, 0x614E, 0x632F, 0x65B0, 0x664B, 0x68EE, 0x699B, 0x6D78, 
    0x6DF1, 0x7533, 0x75B9, 0x771F, 0x795E, 0x79E6, 0x7D33, 0x81E3, 0x82AF, 
    0x85AA, 0x89AA, 0x8A3A, 0x8EAB, 0x8F9B, 0x9032, 0x91DD, 0x9707, 0x4EBA, 
    0x4EC1, 0x5203, 0x5875, 0x58EC, 0x5C0B, 0x751A, 0x5C3D, 0x814E, 0x8A0A, 
    0x8FC5, 0x9663, 0x976D, 0x7B25, 0x8ACF, 0x9808, 0x9162, 0x56F3, 0x53A8, 
    0x9017, 0x5439, 0x5782, 0x5E25, 0x63A8, 0x6C34, 0x708A, 0x7761, 0x7C8B, 
    0x7FE0, 0x8870, 0x9042, 0x9154, 0x9310, 0x9318, 0x968F, 0x745E, 0x9AC4, 
    0x5D07, 0x5D69, 0x6570, 0x67A2, 0x8DA8, 0x96DB, 0x636E, 0x6749, 0x6919, 
    0x83C5, 0x9817, 0x96C0, 0x88FE},
    {0x6F84, 0x647A, 0x5BF8, 0x4E16, 0x702C, 0x755D, 0x662F, 0x51C4, 0x5236, 
    0x52E2, 0x59D3, 0x5F81, 0x6027, 0x6210, 0x653F, 0x6574, 0x661F, 0x6674, 
    0x68F2, 0x6816, 0x6B63, 0x6E05, 0x7272, 0x751F, 0x76DB, 0x7CBE, 0x8056, 
    0x58F0, 0x88FD, 0x897F, 0x8AA0, 0x8A93, 0x8ACB, 0x901D, 0x9192, 0x9752, 
    0x9759, 0x6589, 0x7A0E, 0x8106, 0x96BB, 0x5E2D, 0x60DC, 0x621A, 0x65A5, 
    0x6614, 0x6790, 0x77F3, 0x7A4D, 0x7C4D, 0x7E3E, 0x810A, 0x8CAC, 0x8D64, 
    0x8DE1, 0x8E5F, 0x78A9, 0x5207, 0x62D9, 0x63A5, 0x6442, 0x6298, 0x8A2D, 
    0x7A83, 0x7BC0, 0x8AAC, 0x96EA, 0x7D76, 0x820C, 0x8749, 0x4ED9, 0x5148, 
    0x5343, 0x5360, 0x5BA3, 0x5C02, 0x5C16, 0x5DDD, 0x6226, 0x6247, 0x64B0, 
    0x6813, 0x6834, 0x6CC9, 0x6D45, 0x6D17, 0x67D3, 0x6F5C, 0x714E, 0x717D, 
    0x65CB, 0x7A7F, 0x7BAD, 0x7DDA},
    {0x7E4A, 0x7FA8, 0x817A, 0x821B, 0x8239, 0x85A6, 0x8A6E, 0x8CCE, 0x8DF5, 
    0x9078, 0x9077, 0x92AD, 0x9291, 0x9583, 0x9BAE, 0x524D, 0x5584, 0x6F38, 
    0x7136, 0x5168, 0x7985, 0x7E55, 0x81B3, 0x7CCE, 0x564C, 0x5851, 0x5CA8, 
    0x63AA, 0x66FE, 0x66FD, 0x695A, 0x72D9, 0x758F, 0x758E, 0x790E, 0x7956, 
    0x79DF, 0x7C97, 0x7D20, 0x7D44, 0x8607, 0x8A34, 0x963B, 0x9061, 0x9F20, 
    0x50E7, 0x5275, 0x53CC, 0x53E2, 0x5009, 0x55AA, 0x58EE, 0x594F, 0x723D, 
    0x5B8B, 0x5C64, 0x531D, 0x60E3, 0x60F3, 0x635C, 0x6383, 0x633F, 0x63BB, 
    0x64CD, 0x65E9, 0x66F9, 0x5DE3, 0x69CD, 0x69FD, 0x6F15, 0x71E5, 0x4E89, 
    0x75E9, 0x76F8, 0x7A93, 0x7CDF, 0x7DCF, 0x7D9C, 0x8061, 0x8349, 0x8358, 
    0x846C, 0x84BC, 0x85FB, 0x88C5, 0x8D70, 0x9001, 0x906D, 0x9397, 0x971C, 
    0x9A12, 0x50CF, 0x5897, 0x618E},
    {0x81D3, 0x8535, 0x8D08, 0x9020, 0x4FC3, 0x5074, 0x5247, 0x5373, 0x606F, 
    0x6349, 0x675F, 0x6E2C, 0x8DB3, 0x901F, 0x4FD7, 0x5C5E, 0x8CCA, 0x65CF, 
    0x7D9A, 0x5352, 0x8896, 0x5176, 0x63C3, 0x5B58, 0x5B6B, 0x5C0A, 0x640D, 
    0x6751, 0x905C, 0x4ED6, 0x591A, 0x592A, 0x6C70, 0x8A51, 0x553E, 0x5815, 
    0x59A5, 0x60F0, 0x6253, 0x67C1, 0x8235, 0x6955, 0x9640, 0x99C4, 0x9A28, 
    0x4F53, 0x5806, 0x5BFE, 0x8010, 0x5CB1, 0x5E2F, 0x5F85, 0x6020, 0x614B, 
    0x6234, 0x66FF, 0x6CF0, 0x6EDE, 0x80CE, 0x817F, 0x82D4, 0x888B, 0x8CB8, 
    0x9000, 0x902E, 0x968A, 0x9EDB, 0x9BDB, 0x4EE3, 0x53F0, 0x5927, 0x7B2C, 
    0x918D, 0x984C, 0x9DF9, 0x6EDD, 0x7027, 0x5353, 0x5544, 0x5B85, 0x6258, 
    0x629E, 0x62D3, 0x6CA2, 0x6FEF, 0x7422, 0x8A17, 0x9438, 0x6FC1, 0x8AFE, 
    0x8338, 0x51E7, 0x86F8, 0x53EA},
    {0x53E9, 0x4F46, 0x9054, 0x8FB0, 0x596A, 0x8131, 0x5DFD, 0x7AEA, 0x8FBF, 
    0x68DA, 0x8C37, 0x72F8, 0x9C48, 0x6A3D, 0x8AB0, 0x4E39, 0x5358, 0x5606, 
    0x5766, 0x62C5, 0x63A2, 0x65E6, 0x6B4E, 0x6DE1, 0x6E5B, 0x70AD, 0x77ED, 
    0x7AEF, 0x7BAA, 0x7DBB, 0x803D, 0x80C6, 0x86CB, 0x8A95, 0x935B, 0x56E3, 
    0x58C7, 0x5F3E, 0x65AD, 0x6696, 0x6A80, 0x6BB5, 0x7537, 0x8AC7, 0x5024, 
    0x77E5, 0x5730, 0x5F1B, 0x6065, 0x667A, 0x6C60, 0x75F4, 0x7A1A, 0x7F6E, 
    0x81F4, 0x8718, 0x9045, 0x99B3, 0x7BC9, 0x755C, 0x7AF9, 0x7B51, 0x84C4, 
    0x9010, 0x79E9, 0x7A92, 0x8336, 0x5AE1, 0x7740, 0x4E2D, 0x4EF2, 0x5B99, 
    0x5FE0, 0x62BD, 0x663C, 0x67F1, 0x6CE8, 0x866B, 0x8877, 0x8A3B, 0x914E, 
    0x92F3, 0x99D0, 0x6A17, 0x7026, 0x732A, 0x82E7, 0x8457, 0x8CAF, 0x4E01, 
    0x5146, 0x51CB, 0x558B, 0x5BF5},
    {0x5E16, 0x5E33, 0x5E81, 0x5F14, 0x5F35, 0x5F6B, 0x5FB4, 0x61F2, 0x6311, 
    0x66A2, 0x671D, 0x6F6E, 0x7252, 0x753A, 0x773A, 0x8074, 0x8139, 0x8178, 
    0x8776, 0x8ABF, 0x8ADC, 0x8D85, 0x8DF3, 0x929A, 0x9577, 0x9802, 0x9CE5, 
    0x52C5, 0x6357, 0x76F4, 0x6715, 0x6C88, 0x73CD, 0x8CC3, 0x93AE, 0x9673, 
    0x6D25, 0x589C, 0x690E, 0x69CC, 0x8FFD, 0x939A, 0x75DB, 0x901A, 0x585A, 
    0x6802, 0x63B4, 0x69FB, 0x4F43, 0x6F2C, 0x67D8, 0x8FBB, 0x8526, 0x7DB4, 
    0x9354, 0x693F, 0x6F70, 0x576A, 0x58F7, 0x5B2C, 0x7D2C, 0x722A, 0x540A, 
    0x91E3, 0x9DB4, 0x4EAD, 0x4F4E, 0x505C, 0x5075, 0x5243, 0x8C9E, 0x5448, 
    0x5824, 0x5B9A, 0x5E1D, 0x5E95, 0x5EAD, 0x5EF7, 0x5F1F, 0x608C, 0x62B5, 
    0x633A, 0x63D0, 0x68AF, 0x6C40, 0x7887, 0x798E, 0x7A0B, 0x7DE0, 0x8247, 
    0x8A02, 0x8AE6, 0x8E44, 0x9013},
    {0x90B8, 0x912D, 0x91D8, 0x9F0E, 0x6CE5, 0x6458, 0x64E2, 0x6575, 0x6EF4, 
    0x7684, 0x7B1B, 0x9069, 0x93D1, 0x6EBA, 0x54F2, 0x5FB9, 0x64A4, 0x8F4D, 
    0x8FED, 0x9244, 0x5178, 0x586B, 0x5929, 0x5C55, 0x5E97, 0x6DFB, 0x7E8F, 
    0x751C, 0x8CBC, 0x8EE2, 0x985B, 0x70B9, 0x4F1D, 0x6BBF, 0x6FB1, 0x7530, 
    0x96FB, 0x514E, 0x5410, 0x5835, 0x5857, 0x59AC, 0x5C60, 0x5F92, 0x6597, 
    0x675C, 0x6E21, 0x767B, 0x83DF, 0x8CED, 0x9014, 0x90FD, 0x934D, 0x7825, 
    0x783A, 0x52AA, 0x5EA6, 0x571F, 0x5974, 0x6012, 0x5012, 0x515A, 0x51AC, 
    0x51CD, 0x5200, 0x5510, 0x5854, 0x5858, 0x5957, 0x5B95, 0x5CF6, 0x5D8B, 
    0x60BC, 0x6295, 0x642D, 0x6771, 0x6843, 0x68BC, 0x68DF, 0x76D7, 0x6DD8, 
    0x6E6F, 0x6D9B, 0x706F, 0x71C8, 0x5F53, 0x75D8, 0x7977, 0x7B49, 0x7B54, 
    0x7B52, 0x7CD6, 0x7D71, 0x5230},
    {0x8463, 0x8569, 0x85E4, 0x8A0E, 0x8B04, 0x8C46, 0x8E0F, 0x9003, 0x900F, 
    0x9419, 0x9676, 0x982D, 0x9A30, 0x95D8, 0x50CD, 0x52D5, 0x540C, 0x5802, 
    0x5C0E, 0x61A7, 0x649E, 0x6D1E, 0x77B3, 0x7AE5, 0x80F4, 0x8404, 0x9053, 
    0x9285, 0x5CE0, 0x9D07, 0x533F, 0x5F97, 0x5FB3, 0x6D9C, 0x7279, 0x7763, 
    0x79BF, 0x7BE4, 0x6BD2, 0x72EC, 0x8AAD, 0x6803, 0x6A61, 0x51F8, 0x7A81, 
    0x6934, 0x5C4A, 0x9CF6, 0x82EB, 0x5BC5, 0x9149, 0x701E, 0x5678, 0x5C6F, 
    0x60C7, 0x6566, 0x6C8C, 0x8C5A, 0x9041, 0x9813, 0x5451, 0x66C7, 0x920D, 
    0x5948, 0x90A3, 0x5185, 0x4E4D, 0x51EA, 0x8599, 0x8B0E, 0x7058, 0x637A, 
    0x934B, 0x6962, 0x99B4, 0x7E04, 0x7577, 0x5357, 0x6960, 0x8EDF, 0x96E3, 
    0x6C5D, 0x4E8C, 0x5C3C, 0x5F10, 0x8FE9, 0x5302, 0x8CD1, 0x8089, 0x8679, 
    0x5EFF, 0x65E5, 0x4E73, 0x5165},
    {0x5982, 0x5C3F, 0x97EE, 0x4EFB, 0x598A, 0x5FCD, 0x8A8D, 0x6FE1, 0x79B0, 
    0x7962, 0x5BE7, 0x8471, 0x732B, 0x71B1, 0x5E74, 0x5FF5, 0x637B, 0x649A, 
    0x71C3, 0x7C98, 0x4E43, 0x5EFC, 0x4E4B, 0x57DC, 0x56A2, 0x60A9, 0x6FC3, 
    0x7D0D, 0x80FD, 0x8133, 0x81BF, 0x8FB2, 0x8997, 0x86A4, 0x5DF4, 0x628A, 
    0x64AD, 0x8987, 0x6777, 0x6CE2, 0x6D3E, 0x7436, 0x7834, 0x5A46, 0x7F75, 
    0x82AD, 0x99AC, 0x4FF3, 0x5EC3, 0x62DD, 0x6392, 0x6557, 0x676F, 0x76C3, 
    0x724C, 0x80CC, 0x80BA, 0x8F29, 0x914D, 0x500D, 0x57F9, 0x5A92, 0x6885, 
    0x6973, 0x7164, 0x72FD, 0x8CB7, 0x58F2, 0x8CE0, 0x966A, 0x9019, 0x877F, 
    0x79E4, 0x77E7, 0x8429, 0x4F2F, 0x5265, 0x535A, 0x62CD, 0x67CF, 0x6CCA, 
    0x767D, 0x7B94, 0x7C95, 0x8236, 0x8584, 0x8FEB, 0x66DD, 0x6F20, 0x7206, 
    0x7E1B, 0x83AB, 0x99C1, 0x9EA6},
    {0x51FD, 0x7BB1, 0x7872, 0x7BB8, 0x8087, 0x7B48, 0x6AE8, 0x5E61, 0x808C, 
    0x7551, 0x7560, 0x516B, 0x9262, 0x6E8C, 0x767A, 0x9197, 0x9AEA, 0x4F10, 
    0x7F70, 0x629C, 0x7B4F, 0x95A5, 0x9CE9, 0x567A, 0x5859, 0x86E4, 0x96BC, 
    0x4F34, 0x5224, 0x534A, 0x53CD, 0x53DB, 0x5E06, 0x642C, 0x6591, 0x677F, 
    0x6C3E, 0x6C4E, 0x7248, 0x72AF, 0x73ED, 0x7554, 0x7E41, 0x822C, 0x85E9, 
    0x8CA9, 0x7BC4, 0x91C6, 0x7169, 0x9812, 0x98EF, 0x633D, 0x6669, 0x756A, 
    0x76E4, 0x78D0, 0x8543, 0x86EE, 0x532A, 0x5351, 0x5426, 0x5983, 0x5E87, 
    0x5F7C, 0x60B2, 0x6249, 0x6279, 0x62AB, 0x6590, 0x6BD4, 0x6CCC, 0x75B2, 
    0x76AE, 0x7891, 0x79D8, 0x7DCB, 0x7F77, 0x80A5, 0x88AB, 0x8AB9, 0x8CBB, 
    0x907F, 0x975E, 0x98DB, 0x6A0B, 0x7C38, 0x5099, 0x5C3E, 0x5FAE, 0x6787, 
    0x6BD8, 0x7435, 0x7709, 0x7F8E},
    {0x9F3B, 0x67CA, 0x7A17, 0x5339, 0x758B, 0x9AED, 0x5F66, 0x819D, 0x83F1, 
    0x8098, 0x5F3C, 0x5FC5, 0x7562, 0x7B46, 0x903C, 0x6867, 0x59EB, 0x5A9B, 
    0x7D10, 0x767E, 0x8B2C, 0x4FF5, 0x5F6A, 0x6A19, 0x6C37, 0x6F02, 0x74E2, 
    0x7968, 0x8868, 0x8A55, 0x8C79, 0x5EDF, 0x63CF, 0x75C5, 0x79D2, 0x82D7, 
    0x9328, 0x92F2, 0x849C, 0x86ED, 0x9C2D, 0x54C1, 0x5F6C, 0x658C, 0x6D5C, 
    0x7015, 0x8CA7, 0x8CD3, 0x983B, 0x654F, 0x74F6, 0x4E0D, 0x4ED8, 0x57E0, 
    0x592B, 0x5A66, 0x5BCC, 0x51A8, 0x5E03, 0x5E9C, 0x6016, 0x6276, 0x6577, 
    0x65A7, 0x666E, 0x6D6E, 0x7236, 0x7B26, 0x8150, 0x819A, 0x8299, 0x8B5C, 
    0x8CA0, 0x8CE6, 0x8D74, 0x961C, 0x9644, 0x4FAE, 0x64AB, 0x6B66, 0x821E, 
    0x8461, 0x856A, 0x90E8, 0x5C01, 0x6953, 0x98A8, 0x847A, 0x8557, 0x4F0F, 
    0x526F, 0x5FA9, 0x5E45, 0x670D},
    {0x798F, 0x8179, 0x8907, 0x8986, 0x6DF5, 0x5F17, 0x6255, 0x6CB8, 0x4ECF, 
    0x7269, 0x9B92, 0x5206, 0x543B, 0x5674, 0x58B3, 0x61A4, 0x626E, 0x711A, 
    0x596E, 0x7C89, 0x7CDE, 0x7D1B, 0x96F0, 0x6587, 0x805E, 0x4E19, 0x4F75, 
    0x5175, 0x5840, 0x5E63, 0x5E73, 0x5F0A, 0x67C4, 0x4E26, 0x853D, 0x9589, 
    0x965B, 0x7C73, 0x9801, 0x50FB, 0x58C1, 0x7656, 0x78A7, 0x5225, 0x77A5, 
    0x8511, 0x7B86, 0x504F, 0x5909, 0x7247, 0x7BC7, 0x7DE8, 0x8FBA, 0x8FD4, 
    0x904D, 0x4FBF, 0x52C9, 0x5A29, 0x5F01, 0x97AD, 0x4FDD, 0x8217, 0x92EA, 
    0x5703, 0x6355, 0x6B69, 0x752B, 0x88DC, 0x8F14, 0x7A42, 0x52DF, 0x5893, 
    0x6155, 0x620A, 0x66AE, 0x6BCD, 0x7C3F, 0x83E9, 0x5023, 0x4FF8, 0x5305, 
    0x5446, 0x5831, 0x5949, 0x5B9D, 0x5CF0, 0x5CEF, 0x5D29, 0x5E96, 0x62B1, 
    0x6367, 0x653E, 0x65B9, 0x670B},
    {0x6CD5, 0x6CE1, 0x70F9, 0x7832, 0x7E2B, 0x80DE, 0x82B3, 0x840C, 0x84EC, 
    0x8702, 0x8912, 0x8A2A, 0x8C4A, 0x90A6, 0x92D2, 0x98FD, 0x9CF3, 0x9D6C, 
    0x4E4F, 0x4EA1, 0x508D, 0x5256, 0x574A, 0x59A8, 0x5E3D, 0x5FD8, 0x5FD9, 
    0x623F, 0x66B4, 0x671B, 0x67D0, 0x68D2, 0x5192, 0x7D21, 0x80AA, 0x81A8, 
    0x8B00, 0x8C8C, 0x8CBF, 0x927E, 0x9632, 0x5420, 0x982C, 0x5317, 0x50D5, 
    0x535C, 0x58A8, 0x64B2, 0x6734, 0x7267, 0x7766, 0x7A46, 0x91E6, 0x52C3, 
    0x6CA1, 0x6B86, 0x5800, 0x5E4C, 0x5954, 0x672C, 0x7FFB, 0x51E1, 0x76C6, 
    0x6469, 0x78E8, 0x9B54, 0x9EBB, 0x57CB, 0x59B9, 0x6627, 0x679A, 0x6BCE, 
    0x54E9, 0x69D9, 0x5E55, 0x819C, 0x6795, 0x9BAA, 0x67FE, 0x9C52, 0x685D, 
    0x4EA6, 0x4FE3, 0x53C8, 0x62B9, 0x672B, 0x6CAB, 0x8FC4, 0x4FAD, 0x7E6D, 
    0x9EBF, 0x4E07, 0x6162, 0x6E80},
    {0x6F2B, 0x8513, 0x5473, 0x672A, 0x9B45, 0x5DF3, 0x7B95, 0x5CAC, 0x5BC6, 
    0x871C, 0x6E4A, 0x84D1, 0x7A14, 0x8108, 0x5999, 0x7C8D, 0x6C11, 0x7720, 
    0x52D9, 0x5922, 0x7121, 0x725F, 0x77DB, 0x9727, 0x9D61, 0x690B, 0x5A7F, 
    0x5A18, 0x51A5, 0x540D, 0x547D, 0x660E, 0x76DF, 0x8FF7, 0x9298, 0x9CF4, 
    0x59EA, 0x725D, 0x6EC5, 0x514D, 0x68C9, 0x7DBF, 0x7DEC, 0x9762, 0x9EBA, 
    0x6478, 0x6A21, 0x8302, 0x5984, 0x5B5F, 0x6BDB, 0x731B, 0x76F2, 0x7DB2, 
    0x8017, 0x8499, 0x5132, 0x6728, 0x9ED9, 0x76EE, 0x6762, 0x52FF, 0x9905, 
    0x5C24, 0x623B, 0x7C7E, 0x8CB0, 0x554F, 0x60B6, 0x7D0B, 0x9580, 0x5301, 
    0x4E5F, 0x51B6, 0x591C, 0x723A, 0x8036, 0x91CE, 0x5F25, 0x77E2, 0x5384, 
    0x5F79, 0x7D04, 0x85AC, 0x8A33, 0x8E8D, 0x9756, 0x67F3, 0x85AE, 0x9453, 
    0x6109, 0x6108, 0x6CB9, 0x7652},
    {0x8AED, 0x8F38, 0x552F, 0x4F51, 0x512A, 0x52C7, 0x53CB, 0x5BA5, 0x5E7D, 
    0x60A0, 0x6182, 0x63D6, 0x6709, 0x67DA, 0x6E67, 0x6D8C, 0x7336, 0x7337, 
    0x7531, 0x7950, 0x88D5, 0x8A98, 0x904A, 0x9091, 0x90F5, 0x96C4, 0x878D, 
    0x5915, 0x4E88, 0x4F59, 0x4E0E, 0x8A89, 0x8F3F, 0x9810, 0x50AD, 0x5E7C, 
    0x5996, 0x5BB9, 0x5EB8, 0x63DA, 0x63FA, 0x64C1, 0x66DC, 0x694A, 0x69D8, 
    0x6D0B, 0x6EB6, 0x7194, 0x7528, 0x7AAF, 0x7F8A, 0x8000, 0x8449, 0x84C9, 
    0x8981, 0x8B21, 0x8E0A, 0x9065, 0x967D, 0x990A, 0x617E, 0x6291, 0x6B32, 
    0x6C83, 0x6D74, 0x7FCC, 0x7FFC, 0x6DC0, 0x7F85, 0x87BA, 0x88F8, 0x6765, 
    0x83B1, 0x983C, 0x96F7, 0x6D1B, 0x7D61, 0x843D, 0x916A, 0x4E71, 0x5375, 
    0x5D50, 0x6B04, 0x6FEB, 0x85CD, 0x862D, 0x89A7, 0x5229, 0x540F, 0x5C65, 
    0x674E, 0x68A8, 0x7406, 0x7483},
    {0x75E2, 0x88CF, 0x88E1, 0x91CC, 0x96E2, 0x9678, 0x5F8B, 0x7387, 0x7ACB, 
    0x844E, 0x63A0, 0x7565, 0x5289, 0x6D41, 0x6E9C, 0x7409, 0x7559, 0x786B, 
    0x7C92, 0x9686, 0x7ADC, 0x9F8D, 0x4FB6, 0x616E, 0x65C5, 0x865C, 0x4E86, 
    0x4EAE, 0x50DA, 0x4E21, 0x51CC, 0x5BEE, 0x6599, 0x6881, 0x6DBC, 0x731F, 
    0x7642, 0x77AD, 0x7A1C, 0x7CE7, 0x826F, 0x8AD2, 0x907C, 0x91CF, 0x9675, 
    0x9818, 0x529B, 0x7DD1, 0x502B, 0x5398, 0x6797, 0x6DCB, 0x71D0, 0x7433, 
    0x81E8, 0x8F2A, 0x96A3, 0x9C57, 0x9E9F, 0x7460, 0x5841, 0x6D99, 0x7D2F, 
    0x985E, 0x4EE4, 0x4F36, 0x4F8B, 0x51B7, 0x52B1, 0x5DBA, 0x601C, 0x73B2, 
    0x793C, 0x82D3, 0x9234, 0x96B7, 0x96F6, 0x970A, 0x9E97, 0x9F62, 0x66A6, 
    0x6B74, 0x5217, 0x52A3, 0x70C8, 0x88C2, 0x5EC9, 0x604B, 0x6190, 0x6F23, 
    0x7149, 0x7C3E, 0x7DF4, 0x806F},
    {0x84EE, 0x9023, 0x932C, 0x5442, 0x9B6F, 0x6AD3, 0x7089, 0x8CC2, 0x8DEF, 
    0x9732, 0x52B4, 0x5A41, 0x5ECA, 0x5F04, 0x6717, 0x697C, 0x6994, 0x6D6A, 
    0x6F0F, 0x7262, 0x72FC, 0x7BED, 0x8001, 0x807E, 0x874B, 0x90CE, 0x516D, 
    0x9E93, 0x7984, 0x808B, 0x9332, 0x8AD6, 0x502D, 0x548C, 0x8A71, 0x6B6A, 
    0x8CC4, 0x8107, 0x60D1, 0x67A0, 0x9DF2, 0x4E99, 0x4E98, 0x9C10, 0x8A6B, 
    0x85C1, 0x8568, 0x6900, 0x6E7E, 0x7897, 0x8155,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    {0x5F0C, 0x4E10, 0x4E15, 0x4E2A, 0x4E31, 0x4E36, 0x4E3C, 0x4E3F, 0x4E42, 
    0x4E56, 0x4E58, 0x4E82, 0x4E85, 0x8C6B, 0x4E8A, 0x8212, 0x5F0D, 0x4E8E, 
    0x4E9E, 0x4E9F, 0x4EA0, 0x4EA2, 0x4EB0, 0x4EB3, 0x4EB6, 0x4ECE, 0x4ECD, 
    0x4EC4, 0x4EC6, 0x4EC2, 0x4ED7, 0x4EDE, 0x4EED, 0x4EDF, 0x4EF7, 0x4F09, 
    0x4F5A, 0x4F30, 0x4F5B, 0x4F5D, 0x4F57, 0x4F47, 0x4F76, 0x4F88, 0x4F8F, 
    0x4F98, 0x4F7B, 0x4F69, 0x4F70, 0x4F91, 0x4F6F, 0x4F86, 0x4F96, 0x5118, 
    0x4FD4, 0x4FDF, 0x4FCE, 0x4FD8, 0x4FDB, 0x4FD1, 0x4FDA, 0x4FD0, 0x4FE4, 
    0x4FE5, 0x501A, 0x5028, 0x5014, 0x502A, 0x5025, 0x5005, 0x4F1C, 0x4FF6, 
    0x5021, 0x5029, 0x502C, 0x4FFE, 0x4FEF, 0x5011, 0x5006, 0x5043, 0x5047, 
    0x6703, 0x5055, 0x5050, 0x5048, 0x505A, 0x5056, 0x506C, 0x5078, 0x5080, 
    0x509A, 0x5085, 0x50B4, 0x50B2},
    {0x50C9, 0x50CA, 0x50B3, 0x50C2, 0x50D6, 0x50DE, 0x50E5, 0x50ED, 0x50E3, 
    0x50EE, 0x50F9, 0x50F5, 0x5109, 0x5101, 0x5102, 0x5116, 0x5115, 0x5114, 
    0x511A, 0x5121, 0x513A, 0x5137, 0x513C, 0x513B, 0x513F, 0x5140, 0x5152, 
    0x514C, 0x5154, 0x5162, 0x7AF8, 0x5169, 0x516A, 0x516E, 0x5180, 0x5182, 
    0x56D8, 0x518C, 0x5189, 0x518F, 0x5191, 0x5193, 0x5195, 0x5196, 0x51A4, 
    0x51A6, 0x51A2, 0x51A9, 0x51AA, 0x51AB, 0x51B3, 0x51B1, 0x51B2, 0x51B0, 
    0x51B5, 0x51BD, 0x51C5, 0x51C9, 0x51DB, 0x51E0, 0x8655, 0x51E9, 0x51ED, 
    0x51F0, 0x51F5, 0x51FE, 0x5204, 0x520B, 0x5214, 0x520E, 0x5227, 0x522A, 
    0x522E, 0x5233, 0x5239, 0x524F, 0x5244, 0x524B, 0x524C, 0x525E, 0x5254, 
    0x526A, 0x5274, 0x5269, 0x5273, 0x527F, 0x527D, 0x528D, 0x5294, 0x5292, 
    0x5271, 0x5288, 0x5291, 0x8FA8},
    {0x8FA7, 0x52AC, 0x52AD, 0x52BC, 0x52B5, 0x52C1, 0x52CD, 0x52D7, 0x52DE, 
    0x52E3, 0x52E6, 0x98ED, 0x52E0, 0x52F3, 0x52F5, 0x52F8, 0x52F9, 0x5306, 
    0x5308, 0x7538, 0x530D, 0x5310, 0x530F, 0x5315, 0x531A, 0x5323, 0x532F, 
    0x5331, 0x5333, 0x5338, 0x5340, 0x5346, 0x5345, 0x4E17, 0x5349, 0x534D, 
    0x51D6, 0x535E, 0x5369, 0x536E, 0x5918, 0x537B, 0x5377, 0x5382, 0x5396, 
    0x53A0, 0x53A6, 0x53A5, 0x53AE, 0x53B0, 0x53B6, 0x53C3, 0x7C12, 0x96D9, 
    0x53DF, 0x66FC, 0x71EE, 0x53EE, 0x53E8, 0x53ED, 0x53FA, 0x5401, 0x543D, 
    0x5440, 0x542C, 0x542D, 0x543C, 0x542E, 0x5436, 0x5429, 0x541D, 0x544E, 
    0x548F, 0x5475, 0x548E, 0x545F, 0x5471, 0x5477, 0x5470, 0x5492, 0x547B, 
    0x5480, 0x5476, 0x5484, 0x5490, 0x5486, 0x54C7, 0x54A2, 0x54B8, 0x54A5, 
    0x54AC, 0x54C4, 0x54C8, 0x54A8},
    {0x54AB, 0x54C2, 0x54A4, 0x54BE, 0x54BC, 0x54D8, 0x54E5, 0x54E6, 0x550F, 
    0x5514, 0x54FD, 0x54EE, 0x54ED, 0x54FA, 0x54E2, 0x5539, 0x5540, 0x5563, 
    0x554C, 0x552E, 0x555C, 0x5545, 0x5556, 0x5557, 0x5538, 0x5533, 0x555D, 
    0x5599, 0x5580, 0x54AF, 0x558A, 0x559F, 0x557B, 0x557E, 0x5598, 0x559E, 
    0x55AE, 0x557C, 0x5583, 0x55A9, 0x5587, 0x55A8, 0x55DA, 0x55C5, 0x55DF, 
    0x55C4, 0x55DC, 0x55E4, 0x55D4, 0x5614, 0x55F7, 0x5616, 0x55FE, 0x55FD, 
    0x561B, 0x55F9, 0x564E, 0x5650, 0x71DF, 0x5634, 0x5636, 0x5632, 0x5638, 
    0x566B, 0x5664, 0x562F, 0x566C, 0x566A, 0x5686, 0x5680, 0x568A, 0x56A0, 
    0x5694, 0x568F, 0x56A5, 0x56AE, 0x56B6, 0x56B4, 0x56C2, 0x56BC, 0x56C1, 
    0x56C3, 0x56C0, 0x56C8, 0x56CE, 0x56D1, 0x56D3, 0x56D7, 0x56EE, 0x56F9, 
    0x5700, 0x56FF, 0x5704, 0x5709},
    {0x5708, 0x570B, 0x570D, 0x5713, 0x5718, 0x5716, 0x55C7, 0x571C, 0x5726, 
    0x5737, 0x5738, 0x574E, 0x573B, 0x5740, 0x574F, 0x5769, 0x57C0, 0x5788, 
    0x5761, 0x577F, 0x5789, 0x5793, 0x57A0, 0x57B3, 0x57A4, 0x57AA, 0x57B0, 
    0x57C3, 0x57C6, 0x57D4, 0x57D2, 0x57D3, 0x580A, 0x57D6, 0x57E3, 0x580B, 
    0x5819, 0x581D, 0x5872, 0x5821, 0x5862, 0x584B, 0x5870, 0x6BC0, 0x5852, 
    0x583D, 0x5879, 0x5885, 0x58B9, 0x589F, 0x58AB, 0x58BA, 0x58DE, 0x58BB, 
    0x58B8, 0x58AE, 0x58C5, 0x58D3, 0x58D1, 0x58D7, 0x58D9, 0x58D8, 0x58E5, 
    0x58DC, 0x58E4, 0x58DF, 0x58EF, 0x58FA, 0x58F9, 0x58FB, 0x58FC, 0x58FD, 
    0x5902, 0x590A, 0x5910, 0x591B, 0x68A6, 0x5925, 0x592C, 0x592D, 0x5932, 
    0x5938, 0x593E, 0x7AD2, 0x5955, 0x5950, 0x594E, 0x595A, 0x5958, 0x5962, 
    0x5960, 0x5967, 0x596C, 0x5969},
    {0x5978, 0x5981, 0x599D, 0x4F5E, 0x4FAB, 0x59A3, 0x59B2, 0x59C6, 0x59E8, 
    0x59DC, 0x598D, 0x59D9, 0x59DA, 0x5A25, 0x5A1F, 0x5A11, 0x5A1C, 0x5A09, 
    0x5A1A, 0x5A40, 0x5A6C, 0x5A49, 0x5A35, 0x5A36, 0x5A62, 0x5A6A, 0x5A9A, 
    0x5ABC, 0x5ABE, 0x5ACB, 0x5AC2, 0x5ABD, 0x5AE3, 0x5AD7, 0x5AE6, 0x5AE9, 
    0x5AD6, 0x5AFA, 0x5AFB, 0x5B0C, 0x5B0B, 0x5B16, 0x5B32, 0x5AD0, 0x5B2A, 
    0x5B36, 0x5B3E, 0x5B43, 0x5B45, 0x5B40, 0x5B51, 0x5B55, 0x5B5A, 0x5B5B, 
    0x5B65, 0x5B69, 0x5B70, 0x5B73, 0x5B75, 0x5B78, 0x6588, 0x5B7A, 0x5B80, 
    0x5B83, 0x5BA6, 0x5BB8, 0x5BC3, 0x5BC7, 0x5BC9, 0x5BD4, 0x5BD0, 0x5BE4, 
    0x5BE6, 0x5BE2, 0x5BDE, 0x5BE5, 0x5BEB, 0x5BF0, 0x5BF6, 0x5BF3, 0x5C05, 
    0x5C07, 0x5C08, 0x5C0D, 0x5C13, 0x5C20, 0x5C22, 0x5C28, 0x5C38, 0x5C39, 
    0x5C41, 0x5C46, 0x5C4E, 0x5C53},
    {0x5C50, 0x5C4F, 0x5B71, 0x5C6C, 0x5C6E, 0x4E62, 0x5C76, 0x5C79, 0x5C8C, 
    0x5C91, 0x5C94, 0x599B, 0x5CAB, 0x5CBB, 0x5CB6, 0x5CBC, 0x5CB7, 0x5CC5, 
    0x5CBE, 0x5CC7, 0x5CD9, 0x5CE9, 0x5CFD, 0x5CFA, 0x5CED, 0x5D8C, 0x5CEA, 
    0x5D0B, 0x5D15, 0x5D17, 0x5D5C, 0x5D1F, 0x5D1B, 0x5D11, 0x5D14, 0x5D22, 
    0x5D1A, 0x5D19, 0x5D18, 0x5D4C, 0x5D52, 0x5D4E, 0x5D4B, 0x5D6C, 0x5D73, 
    0x5D76, 0x5D87, 0x5D84, 0x5D82, 0x5DA2, 0x5D9D, 0x5DAC, 0x5DAE, 0x5DBD, 
    0x5D90, 0x5DB7, 0x5DBC, 0x5DC9, 0x5DCD, 0x5DD3, 0x5DD2, 0x5DD6, 0x5DDB, 
    0x5DEB, 0x5DF2, 0x5DF5, 0x5E0B, 0x5E1A, 0x5E19, 0x5E11, 0x5E1B, 0x5E36, 
    0x5E37, 0x5E44, 0x5E43, 0x5E40, 0x5E4E, 0x5E57, 0x5E54, 0x5E5F, 0x5E62, 
    0x5E64, 0x5E47, 0x5E75, 0x5E76, 0x5E7A, 0x9EBC, 0x5E7F, 0x5EA0, 0x5EC1, 
    0x5EC2, 0x5EC8, 0x5ED0, 0x5ECF},
    {0x5ED6, 0x5EE3, 0x5EDD, 0x5EDA, 0x5EDB, 0x5EE2, 0x5EE1, 0x5EE8, 0x5EE9, 
    0x5EEC, 0x5EF1, 0x5EF3, 0x5EF0, 0x5EF4, 0x5EF8, 0x5EFE, 0x5F03, 0x5F09, 
    0x5F5D, 0x5F5C, 0x5F0B, 0x5F11, 0x5F16, 0x5F29, 0x5F2D, 0x5F38, 0x5F41, 
    0x5F48, 0x5F4C, 0x5F4E, 0x5F2F, 0x5F51, 0x5F56, 0x5F57, 0x5F59, 0x5F61, 
    0x5F6D, 0x5F73, 0x5F77, 0x5F83, 0x5F82, 0x5F7F, 0x5F8A, 0x5F88, 0x5F91, 
    0x5F87, 0x5F9E, 0x5F99, 0x5F98, 0x5FA0, 0x5FA8, 0x5FAD, 0x5FBC, 0x5FD6, 
    0x5FFB, 0x5FE4, 0x5FF8, 0x5FF1, 0x5FDD, 0x60B3, 0x5FFF, 0x6021, 0x6060, 
    0x6019, 0x6010, 0x6029, 0x600E, 0x6031, 0x601B, 0x6015, 0x602B, 0x6026, 
    0x600F, 0x603A, 0x605A, 0x6041, 0x606A, 0x6077, 0x605F, 0x604A, 0x6046, 
    0x604D, 0x6063, 0x6043, 0x6064, 0x6042, 0x606C, 0x606B, 0x6059, 0x6081, 
    0x608D, 0x60E7, 0x6083, 0x609A},
    {0x6084, 0x609B, 0x6096, 0x6097, 0x6092, 0x60A7, 0x608B, 0x60E1, 0x60B8, 
    0x60E0, 0x60D3, 0x60B4, 0x5FF0, 0x60BD, 0x60C6, 0x60B5, 0x60D8, 0x614D, 
    0x6115, 0x6106, 0x60F6, 0x60F7, 0x6100, 0x60F4, 0x60FA, 0x6103, 0x6121, 
    0x60FB, 0x60F1, 0x610D, 0x610E, 0x6147, 0x613E, 0x6128, 0x6127, 0x614A, 
    0x613F, 0x613C, 0x612C, 0x6134, 0x613D, 0x6142, 0x6144, 0x6173, 0x6177, 
    0x6158, 0x6159, 0x615A, 0x616B, 0x6174, 0x616F, 0x6165, 0x6171, 0x615F, 
    0x615D, 0x6153, 0x6175, 0x6199, 0x6196, 0x6187, 0x61AC, 0x6194, 0x619A, 
    0x618A, 0x6191, 0x61AB, 0x61AE, 0x61CC, 0x61CA, 0x61C9, 0x61F7, 0x61C8, 
    0x61C3, 0x61C6, 0x61BA, 0x61CB, 0x7F79, 0x61CD, 0x61E6, 0x61E3, 0x61F6, 
    0x61FA, 0x61F4, 0x61FF, 0x61FD, 0x61FC, 0x61FE, 0x6200, 0x6208, 0x6209, 
    0x620D, 0x620C, 0x6214, 0x621B},
    {0x621E, 0x6221, 0x622A, 0x622E, 0x6230, 0x6232, 0x6233, 0x6241, 0x624E, 
    0x625E, 0x6263, 0x625B, 0x6260, 0x6268, 0x627C, 0x6282, 0x6289, 0x627E, 
    0x6292, 0x6293, 0x6296, 0x62D4, 0x6283, 0x6294, 0x62D7, 0x62D1, 0x62BB, 
    0x62CF, 0x62FF, 0x62C6, 0x64D4, 0x62C8, 0x62DC, 0x62CC, 0x62CA, 0x62C2, 
    0x62C7, 0x629B, 0x62C9, 0x630C, 0x62EE, 0x62F1, 0x6327, 0x6302, 0x6308, 
    0x62EF, 0x62F5, 0x6350, 0x633E, 0x634D, 0x641C, 0x634F, 0x6396, 0x638E, 
    0x6380, 0x63AB, 0x6376, 0x63A3, 0x638F, 0x6389, 0x639F, 0x63B5, 0x636B, 
    0x6369, 0x63BE, 0x63E9, 0x63C0, 0x63C6, 0x63E3, 0x63C9, 0x63D2, 0x63F6, 
    0x63C4, 0x6416, 0x6434, 0x6406, 0x6413, 0x6426, 0x6436, 0x651D, 0x6417, 
    0x6428, 0x640F, 0x6467, 0x646F, 0x6476, 0x644E, 0x652A, 0x6495, 0x6493, 
    0x64A5, 0x64A9, 0x6488, 0x64BC},
    {0x64DA, 0x64D2, 0x64C5, 0x64C7, 0x64BB, 0x64D8, 0x64C2, 0x64F1, 0x64E7, 
    0x8209, 0x64E0, 0x64E1, 0x62AC, 0x64E3, 0x64EF, 0x652C, 0x64F6, 0x64F4, 
    0x64F2, 0x64FA, 0x6500, 0x64FD, 0x6518, 0x651C, 0x6505, 0x6524, 0x6523, 
    0x652B, 0x6534, 0x6535, 0x6537, 0x6536, 0x6538, 0x754B, 0x6548, 0x6556, 
    0x6555, 0x654D, 0x6558, 0x655E, 0x655D, 0x6572, 0x6578, 0x6582, 0x6583, 
    0x8B8A, 0x659B, 0x659F, 0x65AB, 0x65B7, 0x65C3, 0x65C6, 0x65C1, 0x65C4, 
    0x65CC, 0x65D2, 0x65DB, 0x65D9, 0x65E0, 0x65E1, 0x65F1, 0x6772, 0x660A, 
    0x6603, 0x65FB, 0x6773, 0x6635, 0x6636, 0x6634, 0x661C, 0x664F, 0x6644, 
    0x6649, 0x6641, 0x665E, 0x665D, 0x6664, 0x6667, 0x6668, 0x665F, 0x6662, 
    0x6670, 0x6683, 0x6688, 0x668E, 0x6689, 0x6684, 0x6698, 0x669D, 0x66C1, 
    0x66B9, 0x66C9, 0x66BE, 0x66BC},
    {0x66C4, 0x66B8, 0x66D6, 0x66DA, 0x66E0, 0x663F, 0x66E6, 0x66E9, 0x66F0, 
    0x66F5, 0x66F7, 0x670F, 0x6716, 0x671E, 0x6726, 0x6727, 0x9738, 0x672E, 
    0x673F, 0x6736, 0x6741, 0x6738, 0x6737, 0x6746, 0x675E, 0x6760, 0x6759, 
    0x6763, 0x6764, 0x6789, 0x6770, 0x67A9, 0x677C, 0x676A, 0x678C, 0x678B, 
    0x67A6, 0x67A1, 0x6785, 0x67B7, 0x67EF, 0x67B4, 0x67EC, 0x67B3, 0x67E9, 
    0x67B8, 0x67E4, 0x67DE, 0x67DD, 0x67E2, 0x67EE, 0x67B9, 0x67CE, 0x67C6, 
    0x67E7, 0x6A9C, 0x681E, 0x6846, 0x6829, 0x6840, 0x684D, 0x6832, 0x684E, 
    0x68B3, 0x682B, 0x6859, 0x6863, 0x6877, 0x687F, 0x689F, 0x688F, 0x68AD, 
    0x6894, 0x689D, 0x689B, 0x6883, 0x6AAE, 0x68B9, 0x6874, 0x68B5, 0x68A0, 
    0x68BA, 0x690F, 0x688D, 0x687E, 0x6901, 0x68CA, 0x6908, 0x68D8, 0x6922, 
    0x6926, 0x68E1, 0x690C, 0x68CD},
    {0x68D4, 0x68E7, 0x68D5, 0x6936, 0x6912, 0x6904, 0x68D7, 0x68E3, 0x6925, 
    0x68F9, 0x68E0, 0x68EF, 0x6928, 0x692A, 0x691A, 0x6923, 0x6921, 0x68C6, 
    0x6979, 0x6977, 0x695C, 0x6978, 0x696B, 0x6954, 0x697E, 0x696E, 0x6939, 
    0x6974, 0x693D, 0x6959, 0x6930, 0x6961, 0x695E, 0x695D, 0x6981, 0x696A, 
    0x69B2, 0x69AE, 0x69D0, 0x69BF, 0x69C1, 0x69D3, 0x69BE, 0x69CE, 0x5BE8, 
    0x69CA, 0x69DD, 0x69BB, 0x69C3, 0x69A7, 0x6A2E, 0x6991, 0x69A0, 0x699C, 
    0x6995, 0x69B4, 0x69DE, 0x69E8, 0x6A02, 0x6A1B, 0x69FF, 0x6B0A, 0x69F9, 
    0x69F2, 0x69E7, 0x6A05, 0x69B1, 0x6A1E, 0x69ED, 0x6A14, 0x69EB, 0x6A0A, 
    0x6A12, 0x6AC1, 0x6A23, 0x6A13, 0x6A44, 0x6A0C, 0x6A72, 0x6A36, 0x6A78, 
    0x6A47, 0x6A62, 0x6A59, 0x6A66, 0x6A48, 0x6A38, 0x6A22, 0x6A90, 0x6A8D, 
    0x6AA0, 0x6A84, 0x6AA2, 0x6AA3},
    {0x6A97, 0x8617, 0x6ABB, 0x6AC3, 0x6AC2, 0x6AB8, 0x6AB3, 0x6AAC, 0x6ADE, 
    0x6AD1, 0x6ADF, 0x6AAA, 0x6ADA, 0x6AEA, 0x6AFB, 0x6B05, 0x8616, 0x6AFA, 
    0x6B12, 0x6B16, 0x9B31, 0x6B1F, 0x6B38, 0x6B37, 0x76DC, 0x6B39, 0x98EE, 
    0x6B47, 0x6B43, 0x6B49, 0x6B50, 0x6B59, 0x6B54, 0x6B5B, 0x6B5F, 0x6B61, 
    0x6B78, 0x6B79, 0x6B7F, 0x6B80, 0x6B84, 0x6B83, 0x6B8D, 0x6B98, 0x6B95, 
    0x6B9E, 0x6BA4, 0x6BAA, 0x6BAB, 0x6BAF, 0x6BB2, 0x6BB1, 0x6BB3, 0x6BB7, 
    0x6BBC, 0x6BC6, 0x6BCB, 0x6BD3, 0x6BDF, 0x6BEC, 0x6BEB, 0x6BF3, 0x6BEF, 
    0x9EBE, 0x6C08, 0x6C13, 0x6C14, 0x6C1B, 0x6C24, 0x6C23, 0x6C5E, 0x6C55, 
    0x6C62, 0x6C6A, 0x6C82, 0x6C8D, 0x6C9A, 0x6C81, 0x6C9B, 0x6C7E, 0x6C68, 
    0x6C73, 0x6C92, 0x6C90, 0x6CC4, 0x6CF1, 0x6CD3, 0x6CBD, 0x6CD7, 0x6CC5, 
    0x6CDD, 0x6CAE, 0x6CB1, 0x6CBE},
    {0x6CBA, 0x6CDB, 0x6CEF, 0x6CD9, 0x6CEA, 0x6D1F, 0x884D, 0x6D36, 0x6D2B, 
    0x6D3D, 0x6D38, 0x6D19, 0x6D35, 0x6D33, 0x6D12, 0x6D0C, 0x6D63, 0x6D93, 
    0x6D64, 0x6D5A, 0x6D79, 0x6D59, 0x6D8E, 0x6D95, 0x6FE4, 0x6D85, 0x6DF9, 
    0x6E15, 0x6E0A, 0x6DB5, 0x6DC7, 0x6DE6, 0x6DB8, 0x6DC6, 0x6DEC, 0x6DDE, 
    0x6DCC, 0x6DE8, 0x6DD2, 0x6DC5, 0x6DFA, 0x6DD9, 0x6DE4, 0x6DD5, 0x6DEA, 
    0x6DEE, 0x6E2D, 0x6E6E, 0x6E2E, 0x6E19, 0x6E72, 0x6E5F, 0x6E3E, 0x6E23, 
    0x6E6B, 0x6E2B, 0x6E76, 0x6E4D, 0x6E1F, 0x6E43, 0x6E3A, 0x6E4E, 0x6E24, 
    0x6EFF, 0x6E1D, 0x6E38, 0x6E82, 0x6EAA, 0x6E98, 0x6EC9, 0x6EB7, 0x6ED3, 
    0x6EBD, 0x6EAF, 0x6EC4, 0x6EB2, 0x6ED4, 0x6ED5, 0x6E8F, 0x6EA5, 0x6EC2, 
    0x6E9F, 0x6F41, 0x6F11, 0x704C, 0x6EEC, 0x6EF8, 0x6EFE, 0x6F3F, 0x6EF2, 
    0x6F31, 0x6EEF, 0x6F32, 0x6ECC},
    {0x6F3E, 0x6F13, 0x6EF7, 0x6F86, 0x6F7A, 0x6F78, 0x6F81, 0x6F80, 0x6F6F, 
    0x6F5B, 0x6FF3, 0x6F6D, 0x6F82, 0x6F7C, 0x6F58, 0x6F8E, 0x6F91, 0x6FC2, 
    0x6F66, 0x6FB3, 0x6FA3, 0x6FA1, 0x6FA4, 0x6FB9, 0x6FC6, 0x6FAA, 0x6FDF, 
    0x6FD5, 0x6FEC, 0x6FD4, 0x6FD8, 0x6FF1, 0x6FEE, 0x6FDB, 0x7009, 0x700B, 
    0x6FFA, 0x7011, 0x7001, 0x700F, 0x6FFE, 0x701B, 0x701A, 0x6F74, 0x701D, 
    0x7018, 0x701F, 0x7030, 0x703E, 0x7032, 0x7051, 0x7063, 0x7099, 0x7092, 
    0x70AF, 0x70F1, 0x70AC, 0x70B8, 0x70B3, 0x70AE, 0x70DF, 0x70CB, 0x70DD, 
    0x70D9, 0x7109, 0x70FD, 0x711C, 0x7119, 0x7165, 0x7155, 0x7188, 0x7166, 
    0x7162, 0x714C, 0x7156, 0x716C, 0x718F, 0x71FB, 0x7184, 0x7195, 0x71A8, 
    0x71AC, 0x71D7, 0x71B9, 0x71BE, 0x71D2, 0x71C9, 0x71D4, 0x71CE, 0x71E0, 
    0x71EC, 0x71E7, 0x71F5, 0x71FC},
    {0x71F9, 0x71FF, 0x720D, 0x7210, 0x721B, 0x7228, 0x722D, 0x722C, 0x7230, 
    0x7232, 0x723B, 0x723C, 0x723F, 0x7240, 0x7246, 0x724B, 0x7258, 0x7274, 
    0x727E, 0x7282, 0x7281, 0x7287, 0x7292, 0x7296, 0x72A2, 0x72A7, 0x72B9, 
    0x72B2, 0x72C3, 0x72C6, 0x72C4, 0x72CE, 0x72D2, 0x72E2, 0x72E0, 0x72E1, 
    0x72F9, 0x72F7, 0x500F, 0x7317, 0x730A, 0x731C, 0x7316, 0x731D, 0x7334, 
    0x732F, 0x7329, 0x7325, 0x733E, 0x734E, 0x734F, 0x9ED8, 0x7357, 0x736A, 
    0x7368, 0x7370, 0x7378, 0x7375, 0x737B, 0x737A, 0x73C8, 0x73B3, 0x73CE, 
    0x73BB, 0x73C0, 0x73E5, 0x73EE, 0x73DE, 0x74A2, 0x7405, 0x746F, 0x7425, 
    0x73F8, 0x7432, 0x743A, 0x7455, 0x743F, 0x745F, 0x7459, 0x7441, 0x745C, 
    0x7469, 0x7470, 0x7463, 0x746A, 0x7476, 0x747E, 0x748B, 0x749E, 0x74A7, 
    0x74CA, 0x74CF, 0x74D4, 0x73F1},
    {0x74E0, 0x74E3, 0x74E7, 0x74E9, 0x74EE, 0x74F2, 0x74F0, 0x74F1, 0x74F8, 
    0x74F7, 0x7504, 0x7503, 0x7505, 0x750C, 0x750E, 0x750D, 0x7515, 0x7513, 
    0x751E, 0x7526, 0x752C, 0x753C, 0x7544, 0x754D, 0x754A, 0x7549, 0x755B, 
    0x7546, 0x755A, 0x7569, 0x7564, 0x7567, 0x756B, 0x756D, 0x7578, 0x7576, 
    0x7586, 0x7587, 0x7574, 0x758A, 0x7589, 0x7582, 0x7594, 0x759A, 0x759D, 
    0x75A5, 0x75A3, 0x75C2, 0x75B3, 0x75C3, 0x75B5, 0x75BD, 0x75B8, 0x75BC, 
    0x75B1, 0x75CD, 0x75CA, 0x75D2, 0x75D9, 0x75E3, 0x75DE, 0x75FE, 0x75FF, 
    0x75FC, 0x7601, 0x75F0, 0x75FA, 0x75F2, 0x75F3, 0x760B, 0x760D, 0x7609, 
    0x761F, 0x7627, 0x7620, 0x7621, 0x7622, 0x7624, 0x7634, 0x7630, 0x763B, 
    0x7647, 0x7648, 0x7646, 0x765C, 0x7658, 0x7661, 0x7662, 0x7668, 0x7669, 
    0x766A, 0x7667, 0x766C, 0x7670},
    {0x7672, 0x7676, 0x7678, 0x767C, 0x7680, 0x7683, 0x7688, 0x768B, 0x768E, 
    0x7696, 0x7693, 0x7699, 0x769A, 0x76B0, 0x76B4, 0x76B8, 0x76B9, 0x76BA, 
    0x76C2, 0x76CD, 0x76D6, 0x76D2, 0x76DE, 0x76E1, 0x76E5, 0x76E7, 0x76EA, 
    0x862F, 0x76FB, 0x7708, 0x7707, 0x7704, 0x7729, 0x7724, 0x771E, 0x7725, 
    0x7726, 0x771B, 0x7737, 0x7738, 0x7747, 0x775A, 0x7768, 0x776B, 0x775B, 
    0x7765, 0x777F, 0x777E, 0x7779, 0x778E, 0x778B, 0x7791, 0x77A0, 0x779E, 
    0x77B0, 0x77B6, 0x77B9, 0x77BF, 0x77BC, 0x77BD, 0x77BB, 0x77C7, 0x77CD, 
    0x77D7, 0x77DA, 0x77DC, 0x77E3, 0x77EE, 0x77FC, 0x780C, 0x7812, 0x7926, 
    0x7820, 0x792A, 0x7845, 0x788E, 0x7874, 0x7886, 0x787C, 0x789A, 0x788C, 
    0x78A3, 0x78B5, 0x78AA, 0x78AF, 0x78D1, 0x78C6, 0x78CB, 0x78D4, 0x78BE, 
    0x78BC, 0x78C5, 0x78CA, 0x78EC},
    {0x78E7, 0x78DA, 0x78FD, 0x78F4, 0x7907, 0x7912, 0x7911, 0x7919, 0x792C, 
    0x792B, 0x7940, 0x7960, 0x7957, 0x795F, 0x795A, 0x7955, 0x7953, 0x797A, 
    0x797F, 0x798A, 0x799D, 0x79A7, 0x9F4B, 0x79AA, 0x79AE, 0x79B3, 0x79B9, 
    0x79BA, 0x79C9, 0x79D5, 0x79E7, 0x79EC, 0x79E1, 0x79E3, 0x7A08, 0x7A0D, 
    0x7A18, 0x7A19, 0x7A20, 0x7A1F, 0x7980, 0x7A31, 0x7A3B, 0x7A3E, 0x7A37, 
    0x7A43, 0x7A57, 0x7A49, 0x7A61, 0x7A62, 0x7A69, 0x9F9D, 0x7A70, 0x7A79, 
    0x7A7D, 0x7A88, 0x7A97, 0x7A95, 0x7A98, 0x7A96, 0x7AA9, 0x7AC8, 0x7AB0, 
    0x7AB6, 0x7AC5, 0x7AC4, 0x7ABF, 0x9083, 0x7AC7, 0x7ACA, 0x7ACD, 0x7ACF, 
    0x7AD5, 0x7AD3, 0x7AD9, 0x7ADA, 0x7ADD, 0x7AE1, 0x7AE2, 0x7AE6, 0x7AED, 
    0x7AF0, 0x7B02, 0x7B0F, 0x7B0A, 0x7B06, 0x7B33, 0x7B18, 0x7B19, 0x7B1E, 
    0x7B35, 0x7B28, 0x7B36, 0x7B50},
    {0x7B7A, 0x7B04, 0x7B4D, 0x7B0B, 0x7B4C, 0x7B45, 0x7B75, 0x7B65, 0x7B74, 
    0x7B67, 0x7B70, 0x7B71, 0x7B6C, 0x7B6E, 0x7B9D, 0x7B98, 0x7B9F, 0x7B8D, 
    0x7B9C, 0x7B9A, 0x7B8B, 0x7B92, 0x7B8F, 0x7B5D, 0x7B99, 0x7BCB, 0x7BC1, 
    0x7BCC, 0x7BCF, 0x7BB4, 0x7BC6, 0x7BDD, 0x7BE9, 0x7C11, 0x7C14, 0x7BE6, 
    0x7BE5, 0x7C60, 0x7C00, 0x7C07, 0x7C13, 0x7BF3, 0x7BF7, 0x7C17, 0x7C0D, 
    0x7BF6, 0x7C23, 0x7C27, 0x7C2A, 0x7C1F, 0x7C37, 0x7C2B, 0x7C3D, 0x7C4C, 
    0x7C43, 0x7C54, 0x7C4F, 0x7C40, 0x7C50, 0x7C58, 0x7C5F, 0x7C64, 0x7C56, 
    0x7C65, 0x7C6C, 0x7C75, 0x7C83, 0x7C90, 0x7CA4, 0x7CAD, 0x7CA2, 0x7CAB, 
    0x7CA1, 0x7CA8, 0x7CB3, 0x7CB2, 0x7CB1, 0x7CAE, 0x7CB9, 0x7CBD, 0x7CC0, 
    0x7CC5, 0x7CC2, 0x7CD8, 0x7CD2, 0x7CDC, 0x7CE2, 0x9B3B, 0x7CEF, 0x7CF2, 
    0x7CF4, 0x7CF6, 0x7CFA, 0x7D06},
    {0x7D02, 0x7D1C, 0x7D15, 0x7D0A, 0x7D45, 0x7D4B, 0x7D2E, 0x7D32, 0x7D3F, 
    0x7D35, 0x7D46, 0x7D73, 0x7D56, 0x7D4E, 0x7D72, 0x7D68, 0x7D6E, 0x7D4F, 
    0x7D63, 0x7D93, 0x7D89, 0x7D5B, 0x7D8F, 0x7D7D, 0x7D9B, 0x7DBA, 0x7DAE, 
    0x7DA3, 0x7DB5, 0x7DC7, 0x7DBD, 0x7DAB, 0x7E3D, 0x7DA2, 0x7DAF, 0x7DDC, 
    0x7DB8, 0x7D9F, 0x7DB0, 0x7DD8, 0x7DDD, 0x7DE4, 0x7DDE, 0x7DFB, 0x7DF2, 
    0x7DE1, 0x7E05, 0x7E0A, 0x7E23, 0x7E21, 0x7E12, 0x7E31, 0x7E1F, 0x7E09, 
    0x7E0B, 0x7E22, 0x7E46, 0x7E66, 0x7E3B, 0x7E35, 0x7E39, 0x7E43, 0x7E37, 
    0x7E32, 0x7E3A, 0x7E67, 0x7E5D, 0x7E56, 0x7E5E, 0x7E59, 0x7E5A, 0x7E79, 
    0x7E6A, 0x7E69, 0x7E7C, 0x7E7B, 0x7E83, 0x7DD5, 0x7E7D, 0x8FAE, 0x7E7F, 
    0x7E88, 0x7E89, 0x7E8C, 0x7E92, 0x7E90, 0x7E93, 0x7E94, 0x7E96, 0x7E8E, 
    0x7E9B, 0x7E9C, 0x7F38, 0x7F3A},
    {0x7F45, 0x7F4C, 0x7F4D, 0x7F4E, 0x7F50, 0x7F51, 0x7F55, 0x7F54, 0x7F58, 
    0x7F5F, 0x7F60, 0x7F68, 0x7F69, 0x7F67, 0x7F78, 0x7F82, 0x7F86, 0x7F83, 
    0x7F88, 0x7F87, 0x7F8C, 0x7F94, 0x7F9E, 0x7F9D, 0x7F9A, 0x7FA3, 0x7FAF, 
    0x7FB2, 0x7FB9, 0x7FAE, 0x7FB6, 0x7FB8, 0x8B71, 0x7FC5, 0x7FC6, 0x7FCA, 
    0x7FD5, 0x7FD4, 0x7FE1, 0x7FE6, 0x7FE9, 0x7FF3, 0x7FF9, 0x98DC, 0x8006, 
    0x8004, 0x800B, 0x8012, 0x8018, 0x8019, 0x801C, 0x8021, 0x8028, 0x803F, 
    0x803B, 0x804A, 0x8046, 0x8052, 0x8058, 0x805A, 0x805F, 0x8062, 0x8068, 
    0x8073, 0x8072, 0x8070, 0x8076, 0x8079, 0x807D, 0x807F, 0x8084, 0x8086, 
    0x8085, 0x809B, 0x8093, 0x809A, 0x80AD, 0x5190, 0x80AC, 0x80DB, 0x80E5, 
    0x80D9, 0x80DD, 0x80C4, 0x80DA, 0x80D6, 0x8109, 0x80EF, 0x80F1, 0x811B, 
    0x8129, 0x8123, 0x812F, 0x814B},
    {0x968B, 0x8146, 0x813E, 0x8153, 0x8151, 0x80FC, 0x8171, 0x816E, 0x8165, 
    0x8166, 0x8174, 0x8183, 0x8188, 0x818A, 0x8180, 0x8182, 0x81A0, 0x8195, 
    0x81A4, 0x81A3, 0x815F, 0x8193, 0x81A9, 0x81B0, 0x81B5, 0x81BE, 0x81B8, 
    0x81BD, 0x81C0, 0x81C2, 0x81BA, 0x81C9, 0x81CD, 0x81D1, 0x81D9, 0x81D8, 
    0x81C8, 0x81DA, 0x81DF, 0x81E0, 0x81E7, 0x81FA, 0x81FB, 0x81FE, 0x8201, 
    0x8202, 0x8205, 0x8207, 0x820A, 0x820D, 0x8210, 0x8216, 0x8229, 0x822B, 
    0x8238, 0x8233, 0x8240, 0x8259, 0x8258, 0x825D, 0x825A, 0x825F, 0x8264, 
    0x8262, 0x8268, 0x826A, 0x826B, 0x822E, 0x8271, 0x8277, 0x8278, 0x827E, 
    0x828D, 0x8292, 0x82AB, 0x829F, 0x82BB, 0x82AC, 0x82E1, 0x82E3, 0x82DF, 
    0x82D2, 0x82F4, 0x82F3, 0x82FA, 0x8393, 0x8303, 0x82FB, 0x82F9, 0x82DE, 
    0x8306, 0x82DC, 0x8309, 0x82D9},
    {0x8335, 0x8334, 0x8316, 0x8332, 0x8331, 0x8340, 0x8339, 0x8350, 0x8345, 
    0x832F, 0x832B, 0x8317, 0x8318, 0x8385, 0x839A, 0x83AA, 0x839F, 0x83A2, 
    0x8396, 0x8323, 0x838E, 0x8387, 0x838A, 0x837C, 0x83B5, 0x8373, 0x8375, 
    0x83A0, 0x8389, 0x83A8, 0x83F4, 0x8413, 0x83EB, 0x83CE, 0x83FD, 0x8403, 
    0x83D8, 0x840B, 0x83C1, 0x83F7, 0x8407, 0x83E0, 0x83F2, 0x840D, 0x8422, 
    0x8420, 0x83BD, 0x8438, 0x8506, 0x83FB, 0x846D, 0x842A, 0x843C, 0x855A, 
    0x8484, 0x8477, 0x846B, 0x84AD, 0x846E, 0x8482, 0x8469, 0x8446, 0x842C, 
    0x846F, 0x8479, 0x8435, 0x84CA, 0x8462, 0x84B9, 0x84BF, 0x849F, 0x84D9, 
    0x84CD, 0x84BB, 0x84DA, 0x84D0, 0x84C1, 0x84C6, 0x84D6, 0x84A1, 0x8521, 
    0x84FF, 0x84F4, 0x8517, 0x8518, 0x852C, 0x851F, 0x8515, 0x8514, 0x84FC, 
    0x8540, 0x8563, 0x8558, 0x8548},
    {0x8541, 0x8602, 0x854B, 0x8555, 0x8580, 0x85A4, 0x8588, 0x8591, 0x858A, 
    0x85A8, 0x856D, 0x8594, 0x859B, 0x85EA, 0x8587, 0x859C, 0x8577, 0x857E, 
    0x8590, 0x85C9, 0x85BA, 0x85CF, 0x85B9, 0x85D0, 0x85D5, 0x85DD, 0x85E5, 
    0x85DC, 0x85F9, 0x860A, 0x8613, 0x860B, 0x85FE, 0x85FA, 0x8606, 0x8622, 
    0x861A, 0x8630, 0x863F, 0x864D, 0x4E55, 0x8654, 0x865F, 0x8667, 0x8671, 
    0x8693, 0x86A3, 0x86A9, 0x86AA, 0x868B, 0x868C, 0x86B6, 0x86AF, 0x86C4, 
    0x86C6, 0x86B0, 0x86C9, 0x8823, 0x86AB, 0x86D4, 0x86DE, 0x86E9, 0x86EC, 
    0x86DF, 0x86DB, 0x86EF, 0x8712, 0x8706, 0x8708, 0x8700, 0x8703, 0x86FB, 
    0x8711, 0x8709, 0x870D, 0x86F9, 0x870A, 0x8734, 0x873F, 0x8737, 0x873B, 
    0x8725, 0x8729, 0x871A, 0x8760, 0x875F, 0x8778, 0x874C, 0x874E, 0x8774, 
    0x8757, 0x8768, 0x876E, 0x8759},
    {0x8753, 0x8763, 0x876A, 0x8805, 0x87A2, 0x879F, 0x8782, 0x87AF, 0x87CB, 
    0x87BD, 0x87C0, 0x87D0, 0x96D6, 0x87AB, 0x87C4, 0x87B3, 0x87C7, 0x87C6, 
    0x87BB, 0x87EF, 0x87F2, 0x87E0, 0x880F, 0x880D, 0x87FE, 0x87F6, 0x87F7, 
    0x880E, 0x87D2, 0x8811, 0x8816, 0x8815, 0x8822, 0x8821, 0x8831, 0x8836, 
    0x8839, 0x8827, 0x883B, 0x8844, 0x8842, 0x8852, 0x8859, 0x885E, 0x8862, 
    0x886B, 0x8881, 0x887E, 0x889E, 0x8875, 0x887D, 0x88B5, 0x8872, 0x8882, 
    0x8897, 0x8892, 0x88AE, 0x8899, 0x88A2, 0x888D, 0x88A4, 0x88B0, 0x88BF, 
    0x88B1, 0x88C3, 0x88C4, 0x88D4, 0x88D8, 0x88D9, 0x88DD, 0x88F9, 0x8902, 
    0x88FC, 0x88F4, 0x88E8, 0x88F2, 0x8904, 0x890C, 0x890A, 0x8913, 0x8943, 
    0x891E, 0x8925, 0x892A, 0x892B, 0x8941, 0x8944, 0x893B, 0x8936, 0x8938, 
    0x894C, 0x891D, 0x8960, 0x895E},
    {0x8966, 0x8964, 0x896D, 0x896A, 0x896F, 0x8974, 0x8977, 0x897E, 0x8983, 
    0x8988, 0x898A, 0x8993, 0x8998, 0x89A1, 0x89A9, 0x89A6, 0x89AC, 0x89AF, 
    0x89B2, 0x89BA, 0x89BD, 0x89BF, 0x89C0, 0x89DA, 0x89DC, 0x89DD, 0x89E7, 
    0x89F4, 0x89F8, 0x8A03, 0x8A16, 0x8A10, 0x8A0C, 0x8A1B, 0x8A1D, 0x8A25, 
    0x8A36, 0x8A41, 0x8A5B, 0x8A52, 0x8A46, 0x8A48, 0x8A7C, 0x8A6D, 0x8A6C, 
    0x8A62, 0x8A85, 0x8A82, 0x8A84, 0x8AA8, 0x8AA1, 0x8A91, 0x8AA5, 0x8AA6, 
    0x8A9A, 0x8AA3, 0x8AC4, 0x8ACD, 0x8AC2, 0x8ADA, 0x8AEB, 0x8AF3, 0x8AE7, 
    0x8AE4, 0x8AF1, 0x8B14, 0x8AE0, 0x8AE2, 0x8AF7, 0x8ADE, 0x8ADB, 0x8B0C, 
    0x8B07, 0x8B1A, 0x8AE1, 0x8B16, 0x8B10, 0x8B17, 0x8B20, 0x8B33, 0x97AB, 
    0x8B26, 0x8B2B, 0x8B3E, 0x8B28, 0x8B41, 0x8B4C, 0x8B4F, 0x8B4E, 0x8B49, 
    0x8B56, 0x8B5B, 0x8B5A, 0x8B6B},
    {0x8B5F, 0x8B6C, 0x8B6F, 0x8B74, 0x8B7D, 0x8B80, 0x8B8C, 0x8B8E, 0x8B92, 
    0x8B93, 0x8B96, 0x8B99, 0x8B9A, 0x8C3A, 0x8C41, 0x8C3F, 0x8C48, 0x8C4C, 
    0x8C4E, 0x8C50, 0x8C55, 0x8C62, 0x8C6C, 0x8C78, 0x8C7A, 0x8C82, 0x8C89, 
    0x8C85, 0x8C8A, 0x8C8D, 0x8C8E, 0x8C94, 0x8C7C, 0x8C98, 0x621D, 0x8CAD, 
    0x8CAA, 0x8CBD, 0x8CB2, 0x8CB3, 0x8CAE, 0x8CB6, 0x8CC8, 0x8CC1, 0x8CE4, 
    0x8CE3, 0x8CDA, 0x8CFD, 0x8CFA, 0x8CFB, 0x8D04, 0x8D05, 0x8D0A, 0x8D07, 
    0x8D0F, 0x8D0D, 0x8D10, 0x9F4E, 0x8D13, 0x8CCD, 0x8D14, 0x8D16, 0x8D67, 
    0x8D6D, 0x8D71, 0x8D73, 0x8D81, 0x8D99, 0x8DC2, 0x8DBE, 0x8DBA, 0x8DCF, 
    0x8DDA, 0x8DD6, 0x8DCC, 0x8DDB, 0x8DCB, 0x8DEA, 0x8DEB, 0x8DDF, 0x8DE3, 
    0x8DFC, 0x8E08, 0x8E09, 0x8DFF, 0x8E1D, 0x8E1E, 0x8E10, 0x8E1F, 0x8E42, 
    0x8E35, 0x8E30, 0x8E34, 0x8E4A},
    {0x8E47, 0x8E49, 0x8E4C, 0x8E50, 0x8E48, 0x8E59, 0x8E64, 0x8E60, 0x8E2A, 
    0x8E63, 0x8E55, 0x8E76, 0x8E72, 0x8E7C, 0x8E81, 0x8E87, 0x8E85, 0x8E84, 
    0x8E8B, 0x8E8A, 0x8E93, 0x8E91, 0x8E94, 0x8E99, 0x8EAA, 0x8EA1, 0x8EAC, 
    0x8EB0, 0x8EC6, 0x8EB1, 0x8EBE, 0x8EC5, 0x8EC8, 0x8ECB, 0x8EDB, 0x8EE3, 
    0x8EFC, 0x8EFB, 0x8EEB, 0x8EFE, 0x8F0A, 0x8F05, 0x8F15, 0x8F12, 0x8F19, 
    0x8F13, 0x8F1C, 0x8F1F, 0x8F1B, 0x8F0C, 0x8F26, 0x8F33, 0x8F3B, 0x8F39, 
    0x8F45, 0x8F42, 0x8F3E, 0x8F4C, 0x8F49, 0x8F46, 0x8F4E, 0x8F57, 0x8F5C, 
    0x8F62, 0x8F63, 0x8F64, 0x8F9C, 0x8F9F, 0x8FA3, 0x8FAD, 0x8FAF, 0x8FB7, 
    0x8FDA, 0x8FE5, 0x8FE2, 0x8FEA, 0x8FEF, 0x9087, 0x8FF4, 0x9005, 0x8FF9, 
    0x8FFA, 0x9011, 0x9015, 0x9021, 0x900D, 0x901E, 0x9016, 0x900B, 0x9027, 
    0x9036, 0x9035, 0x9039, 0x8FF8},
    {0x904F, 0x9050, 0x9051, 0x9052, 0x900E, 0x9049, 0x903E, 0x9056, 0x9058, 
    0x905E, 0x9068, 0x906F, 0x9076, 0x96A8, 0x9072, 0x9082, 0x907D, 0x9081, 
    0x9080, 0x908A, 0x9089, 0x908F, 0x90A8, 0x90AF, 0x90B1, 0x90B5, 0x90E2, 
    0x90E4, 0x6248, 0x90DB, 0x9102, 0x9112, 0x9119, 0x9132, 0x9130, 0x914A, 
    0x9156, 0x9158, 0x9163, 0x9165, 0x9169, 0x9173, 0x9172, 0x918B, 0x9189, 
    0x9182, 0x91A2, 0x91AB, 0x91AF, 0x91AA, 0x91B5, 0x91B4, 0x91BA, 0x91C0, 
    0x91C1, 0x91C9, 0x91CB, 0x91D0, 0x91D6, 0x91DF, 0x91E1, 0x91DB, 0x91FC, 
    0x91F5, 0x91F6, 0x921E, 0x91FF, 0x9214, 0x922C, 0x9215, 0x9211, 0x925E, 
    0x9257, 0x9245, 0x9249, 0x9264, 0x9248, 0x9295, 0x923F, 0x924B, 0x9250, 
    0x929C, 0x9296, 0x9293, 0x929B, 0x925A, 0x92CF, 0x92B9, 0x92B7, 0x92E9, 
    0x930F, 0x92FA, 0x9344, 0x932E},
    {0x9319, 0x9322, 0x931A, 0x9323, 0x933A, 0x9335, 0x933B, 0x935C, 0x9360, 
    0x937C, 0x936E, 0x9356, 0x93B0, 0x93AC, 0x93AD, 0x9394, 0x93B9, 0x93D6, 
    0x93D7, 0x93E8, 0x93E5, 0x93D8, 0x93C3, 0x93DD, 0x93D0, 0x93C8, 0x93E4, 
    0x941A, 0x9414, 0x9413, 0x9403, 0x9407, 0x9410, 0x9436, 0x942B, 0x9435, 
    0x9421, 0x943A, 0x9441, 0x9452, 0x9444, 0x945B, 0x9460, 0x9462, 0x945E, 
    0x946A, 0x9229, 0x9470, 0x9475, 0x9477, 0x947D, 0x945A, 0x947C, 0x947E, 
    0x9481, 0x947F, 0x9582, 0x9587, 0x958A, 0x9594, 0x9596, 0x9598, 0x9599, 
    0x95A0, 0x95A8, 0x95A7, 0x95AD, 0x95BC, 0x95BB, 0x95B9, 0x95BE, 0x95CA, 
    0x6FF6, 0x95C3, 0x95CD, 0x95CC, 0x95D5, 0x95D4, 0x95D6, 0x95DC, 0x95E1, 
    0x95E5, 0x95E2, 0x9621, 0x9628, 0x962E, 0x962F, 0x9642, 0x964C, 0x964F, 
    0x964B, 0x9677, 0x965C, 0x965E},
    {0x965D, 0x965F, 0x9666, 0x9672, 0x966C, 0x968D, 0x9698, 0x9695, 0x9697, 
    0x96AA, 0x96A7, 0x96B1, 0x96B2, 0x96B0, 0x96B4, 0x96B6, 0x96B8, 0x96B9, 
    0x96CE, 0x96CB, 0x96C9, 0x96CD, 0x894D, 0x96DC, 0x970D, 0x96D5, 0x96F9, 
    0x9704, 0x9706, 0x9708, 0x9713, 0x970E, 0x9711, 0x970F, 0x9716, 0x9719, 
    0x9724, 0x972A, 0x9730, 0x9739, 0x973D, 0x973E, 0x9744, 0x9746, 0x9748, 
    0x9742, 0x9749, 0x975C, 0x9760, 0x9764, 0x9766, 0x9768, 0x52D2, 0x976B, 
    0x9771, 0x9779, 0x9785, 0x977C, 0x9781, 0x977A, 0x9786, 0x978B, 0x978F, 
    0x9790, 0x979C, 0x97A8, 0x97A6, 0x97A3, 0x97B3, 0x97B4, 0x97C3, 0x97C6, 
    0x97C8, 0x97CB, 0x97DC, 0x97ED, 0x9F4F, 0x97F2, 0x7ADF, 0x97F6, 0x97F5, 
    0x980F, 0x980C, 0x9838, 0x9824, 0x9821, 0x9837, 0x983D, 0x9846, 0x984F, 
    0x984B, 0x986B, 0x986F, 0x9870},
    {0x9871, 0x9874, 0x9873, 0x98AA, 0x98AF, 0x98B1, 0x98B6, 0x98C4, 0x98C3, 
    0x98C6, 0x98E9, 0x98EB, 0x9903, 0x9909, 0x9912, 0x9914, 0x9918, 0x9921, 
    0x991D, 0x991E, 0x9924, 0x9920, 0x992C, 0x992E, 0x993D, 0x993E, 0x9942, 
    0x9949, 0x9945, 0x9950, 0x994B, 0x9951, 0x9952, 0x994C, 0x9955, 0x9997, 
    0x9998, 0x99A5, 0x99AD, 0x99AE, 0x99BC, 0x99DF, 0x99DB, 0x99DD, 0x99D8, 
    0x99D1, 0x99ED, 0x99EE, 0x99F1, 0x99F2, 0x99FB, 0x99F8, 0x9A01, 0x9A0F, 
    0x9A05, 0x99E2, 0x9A19, 0x9A2B, 0x9A37, 0x9A45, 0x9A42, 0x9A40, 0x9A43, 
    0x9A3E, 0x9A55, 0x9A4D, 0x9A5B, 0x9A57, 0x9A5F, 0x9A62, 0x9A65, 0x9A64, 
    0x9A69, 0x9A6B, 0x9A6A, 0x9AAD, 0x9AB0, 0x9ABC, 0x9AC0, 0x9ACF, 0x9AD1, 
    0x9AD3, 0x9AD4, 0x9ADE, 0x9ADF, 0x9AE2, 0x9AE3, 0x9AE6, 0x9AEF, 0x9AEB, 
    0x9AEE, 0x9AF4, 0x9AF1, 0x9AF7},
    {0x9AFB, 0x9B06, 0x9B18, 0x9B1A, 0x9B1F, 0x9B22, 0x9B23, 0x9B25, 0x9B27, 
    0x9B28, 0x9B29, 0x9B2A, 0x9B2E, 0x9B2F, 0x9B32, 0x9B44, 0x9B43, 0x9B4F, 
    0x9B4D, 0x9B4E, 0x9B51, 0x9B58, 0x9B74, 0x9B93, 0x9B83, 0x9B91, 0x9B96, 
    0x9B97, 0x9B9F, 0x9BA0, 0x9BA8, 0x9BB4, 0x9BC0, 0x9BCA, 0x9BB9, 0x9BC6, 
    0x9BCF, 0x9BD1, 0x9BD2, 0x9BE3, 0x9BE2, 0x9BE4, 0x9BD4, 0x9BE1, 0x9C3A, 
    0x9BF2, 0x9BF1, 0x9BF0, 0x9C15, 0x9C14, 0x9C09, 0x9C13, 0x9C0C, 0x9C06, 
    0x9C08, 0x9C12, 0x9C0A, 0x9C04, 0x9C2E, 0x9C1B, 0x9C25, 0x9C24, 0x9C21, 
    0x9C30, 0x9C47, 0x9C32, 0x9C46, 0x9C3E, 0x9C5A, 0x9C60, 0x9C67, 0x9C76, 
    0x9C78, 0x9CE7, 0x9CEC, 0x9CF0, 0x9D09, 0x9D08, 0x9CEB, 0x9D03, 0x9D06, 
    0x9D2A, 0x9D26, 0x9DAF, 0x9D23, 0x9D1F, 0x9D44, 0x9D15, 0x9D12, 0x9D41, 
    0x9D3F, 0x9D3E, 0x9D46, 0x9D48},
    {0x9D5D, 0x9D5E, 0x9D64, 0x9D51, 0x9D50, 0x9D59, 0x9D72, 0x9D89, 0x9D87, 
    0x9DAB, 0x9D6F, 0x9D7A, 0x9D9A, 0x9DA4, 0x9DA9, 0x9DB2, 0x9DC4, 0x9DC1, 
    0x9DBB, 0x9DB8, 0x9DBA, 0x9DC6, 0x9DCF, 0x9DC2, 0x9DD9, 0x9DD3, 0x9DF8, 
    0x9DE6, 0x9DED, 0x9DEF, 0x9DFD, 0x9E1A, 0x9E1B, 0x9E1E, 0x9E75, 0x9E79, 
    0x9E7D, 0x9E81, 0x9E88, 0x9E8B, 0x9E8C, 0x9E92, 0x9E95, 0x9E91, 0x9E9D, 
    0x9EA5, 0x9EA9, 0x9EB8, 0x9EAA, 0x9EAD, 0x9761, 0x9ECC, 0x9ECE, 0x9ECF, 
    0x9ED0, 0x9ED4, 0x9EDC, 0x9EDE, 0x9EDD, 0x9EE0, 0x9EE5, 0x9EE8, 0x9EEF, 
    0x9EF4, 0x9EF6, 0x9EF7, 0x9EF9, 0x9EFB, 0x9EFC, 0x9EFD, 0x9F07, 0x9F08, 
    0x76B7, 0x9F15, 0x9F21, 0x9F2C, 0x9F3E, 0x9F4A, 0x9F52, 0x9F54, 0x9F63, 
    0x9F5F, 0x9F60, 0x9F61, 0x9F66, 0x9F67, 0x9F6C, 0x9F6A, 0x9F77, 0x9F72, 
    0x9F76, 0x9F95, 0x9F9C, 0x9FA0},
    {0x582F, 0x69C7, 0x9059, 0x7464, 0x51DC, 0x7199,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
};

/*
 * Mapping from Unicode back to JIS X 0208.
 * 
 * This inverse is done the same way the SBCS ones are done: I
 * provide a list of JIS X 0208 positions, sorted into ascending
 * order of their Unicode values. Then we can binary-search through
 * this list, referring to the above table for each comparison, to
 * find the coordinates for a given code point.
 * 
 * Generated by running the following sh+Perl over JIS0208.TXT:

cat JIS0208.TXT | \
perl -ne '$a{$3}=[hex$1,hex$2] if /^[^#]\S+\s+0x(\S\S)(\S\S)\s+(0x\S+)\s/;' \
      -e 'END {$o="    ";for $k (sort keys %a) { ($r,$c) = @{$a{$k}}; ' \
      -e '$o .= $C; $C = ", "; (print "$o\n"), $o="    " if length $o > 70;' \
      -e '$o .= sprintf "{%d,%d}", $r-33,$c-33; } print "$o\n"; }'

 */

static const struct { unsigned char r, c; } jisx0208_backward[] = {
    {0,31}, {0,80}, {0,81}, {0,87}, {0,14}, {1,43}, {0,74}, {0,61}, {0,12}, 
    {1,88}, {0,62}, {0,63}, {5,0}, {5,1}, {5,2}, {5,3}, {5,4}, {5,5}, {5,6}, 
    {5,7}, {5,8}, {5,9}, {5,10}, {5,11}, {5,12}, {5,13}, {5,14}, {5,15}, 
    {5,16}, {5,17}, {5,18}, {5,19}, {5,20}, {5,21}, {5,22}, {5,23}, {5,32}, 
    {5,33}, {5,34}, {5,35}, {5,36}, {5,37}, {5,38}, {5,39}, {5,40}, {5,41}, 
    {5,42}, {5,43}, {5,44}, {5,45}, {5,46}, {5,47}, {5,48}, {5,49}, {5,50}, 
    {5,51}, {5,52}, {5,53}, {5,54}, {5,55}, {6,6}, {6,0}, {6,1}, {6,2}, 
    {6,3}, {6,4}, {6,5}, {6,7}, {6,8}, {6,9}, {6,10}, {6,11}, {6,12}, {6,13}, 
    {6,14}, {6,15}, {6,16}, {6,17}, {6,18}, {6,19}, {6,20}, {6,21}, {6,22}, 
    {6,23}, {6,24}, {6,25}, {6,26}, {6,27}, {6,28}, {6,29}, {6,30}, {6,31}, 
    {6,32}, {6,48}, {6,49}, {6,50}, {6,51}, {6,52}, {6,53}, {6,55}, {6,56}, 
    {6,57}, {6,58}, {6,59}, {6,60}, {6,61}, {6,62}, {6,63}, {6,64}, {6,65}, 
    {6,66}, {6,67}, {6,68}, {6,69}, {6,70}, {6,71}, {6,72}, {6,73}, {6,74}, 
    {6,75}, {6,76}, {6,77}, {6,78}, {6,79}, {6,80}, {6,54}, {0,29}, {0,28}, 
    {0,33}, {0,37}, {0,38}, {0,39}, {0,40}, {1,86}, {1,87}, {0,36}, {0,35}, 
    {1,82}, {0,75}, {0,76}, {1,7}, {0,77}, {1,81}, {1,10}, {1,11}, {1,9}, 
    {1,12}, {1,44}, {1,45}, {1,46}, {1,62}, {1,47}, {1,63}, {1,25}, {1,26}, 
    {0,60}, {1,68}, {1,70}, {0,70}, {1,59}, {1,41}, {1,42}, {1,32}, {1,31}, 
    {1,72}, {1,73}, {0,71}, {1,71}, {1,69}, {1,65}, {0,65}, {1,64}, {0,68}, 
    {0,69}, {1,66}, {1,67}, {1,29}, {1,30}, {1,27}, {1,28}, {1,60}, {1,61}, 
    {7,0}, {7,11}, {7,1}, {7,12}, {7,2}, {7,13}, {7,3}, {7,14}, {7,5}, 
    {7,16}, {7,4}, {7,15}, {7,6}, {7,27}, {7,22}, {7,17}, {7,8}, {7,29}, 
    {7,24}, {7,19}, {7,7}, {7,23}, {7,28}, {7,18}, {7,9}, {7,25}, {7,30}, 
    {7,20}, {7,10}, {7,26}, {7,31}, {7,21}, {1,2}, {1,1}, {1,4}, {1,3}, 
    {1,6}, {1,5}, {1,0}, {0,93}, {0,90}, {0,92}, {0,91}, {1,93}, {0,89}, 
    {0,88}, {0,73}, {0,72}, {1,85}, {1,84}, {1,83}, {0,0}, {0,1}, {0,2}, 
    {0,22}, {0,24}, {0,25}, {0,26}, {0,49}, {0,50}, {0,51}, {0,52}, {0,53}, 
    {0,54}, {0,55}, {0,56}, {0,57}, {0,58}, {1,8}, {1,13}, {0,43}, {0,44}, 
    {0,32}, {3,0}, {3,1}, {3,2}, {3,3}, {3,4}, {3,5}, {3,6}, {3,7}, {3,8}, 
    {3,9}, {3,10}, {3,11}, {3,12}, {3,13}, {3,14}, {3,15}, {3,16}, {3,17}, 
    {3,18}, {3,19}, {3,20}, {3,21}, {3,22}, {3,23}, {3,24}, {3,25}, {3,26}, 
    {3,27}, {3,28}, {3,29}, {3,30}, {3,31}, {3,32}, {3,33}, {3,34}, {3,35}, 
    {3,36}, {3,37}, {3,38}, {3,39}, {3,40}, {3,41}, {3,42}, {3,43}, {3,44}, 
    {3,45}, {3,46}, {3,47}, {3,48}, {3,49}, {3,50}, {3,51}, {3,52}, {3,53}, 
    {3,54}, {3,55}, {3,56}, {3,57}, {3,58}, {3,59}, {3,60}, {3,61}, {3,62}, 
    {3,63}, {3,64}, {3,65}, {3,66}, {3,67}, {3,68}, {3,69}, {3,70}, {3,71}, 
    {3,72}, {3,73}, {3,74}, {3,75}, {3,76}, {3,77}, {3,78}, {3,79}, {3,80}, 
    {3,81}, {3,82}, {0,10}, {0,11}, {0,20}, {0,21}, {4,0}, {4,1}, {4,2}, 
    {4,3}, {4,4}, {4,5}, {4,6}, {4,7}, {4,8}, {4,9}, {4,10}, {4,11}, {4,12}, 
    {4,13}, {4,14}, {4,15}, {4,16}, {4,17}, {4,18}, {4,19}, {4,20}, {4,21}, 
    {4,22}, {4,23}, {4,24}, {4,25}, {4,26}, {4,27}, {4,28}, {4,29}, {4,30}, 
    {4,31}, {4,32}, {4,33}, {4,34}, {4,35}, {4,36}, {4,37}, {4,38}, {4,39}, 
    {4,40}, {4,41}, {4,42}, {4,43}, {4,44}, {4,45}, {4,46}, {4,47}, {4,48}, 
    {4,49}, {4,50}, {4,51}, {4,52}, {4,53}, {4,54}, {4,55}, {4,56}, {4,57}, 
    {4,58}, {4,59}, {4,60}, {4,61}, {4,62}, {4,63}, {4,64}, {4,65}, {4,66}, 
    {4,67}, {4,68}, {4,69}, {4,70}, {4,71}, {4,72}, {4,73}, {4,74}, {4,75}, 
    {4,76}, {4,77}, {4,78}, {4,79}, {4,80}, {4,81}, {4,82}, {4,83}, {4,84}, 
    {4,85}, {0,5}, {0,27}, {0,18}, {0,19}, {15,75}, {34,89}, {27,22}, {42,91}, 
    {29,69}, {26,15}, {29,68}, {17,27}, {40,51}, {44,30}, {47,1}, {16,14}, 
    {18,77}, {47,2}, {31,3}, {49,33}, {20,53}, {41,25}, {29,70}, {45,29}, 
    {41,33}, {47,3}, {34,69}, {47,4}, {21,89}, {47,5}, {19,60}, {34,15}, 
    {27,70}, {47,6}, {47,7}, {47,8}, {38,20}, {20,54}, {38,22}, {37,66}, 
    {23,34}, {42,18}, {72,40}, {47,9}, {29,71}, {47,10}, {17,20}, {21,68}, 
    {23,79}, {43,72}, {53,5}, {44,79}, {37,92}, {19,4}, {20,20}, {47,11}, 
    {47,12}, {45,26}, {44,28}, {32,71}, {47,14}, {26,85}, {37,82}, {47,17}, 
    {16,29}, {23,62}, {23,61}, {15,69}, {46,42}, {46,41}, {25,18}, {15,0}, 
    {47,18}, {47,19}, {47,20}, {42,19}, {47,21}, {23,81}, {15,70}, {42,81}, 
    {20,91}, {20,92}, {20,93}, {35,65}, {45,27}, {47,22}, {47,23}, {47,24}, 
    {30,44}, {28,25}, {30,45}, {47,29}, {47,27}, {47,28}, {20,55}, {25,2}, 
    {17,79}, {47,26}, {47,25}, {41,8}, {26,37}, {26,36}, {33,29}, {47,30}, 
    {40,52}, {31,70}, {0,23}, {47,31}, {47,33}, {33,68}, {45,64}, {15,41}, 
    {47,32}, {17,29}, {21,35}, {34,70}, {22,78}, {47,34}, {38,3}, {19,74}, 
    {47,35}, {15,42}, {23,63}, {19,75}, {40,89}, {39,17}, {20,56}, {17,80}, 
    {47,70}, {36,32}, {38,75}, {47,37}, {39,27}, {45,65}, {30,12}, {26,38}, 
    {26,86}, {17,31}, {35,48}, {34,1}, {47,41}, {15,43}, {35,66}, {28,26}, 
    {25,19}, {44,3}, {33,45}, {17,30}, {47,40}, {44,29}, {47,36}, {47,38}, 
    {25,77}, {47,39}, {52,3}, {47,47}, {47,50}, {47,48}, {17,33}, {41,26}, 
    {47,42}, {47,46}, {23,82}, {26,39}, {19,5}, {47,51}, {47,43}, {45,66}, 
    {26,87}, {47,44}, {47,49}, {47,52}, {47,45}, {21,0}, {15,44}, {21,1}, 
    {17,32}, {52,4}, {42,88}, {40,77}, {23,83}, {30,14}, {45,22}, {41,55}, 
    {22,23}, {33,4}, {17,67}, {28,50}, {47,56}, {47,61}, {47,59}, {47,54}, 
    {33,14}, {47,57}, {47,60}, {47,58}, {41,60}, {47,55}, {30,13}, {42,82}, 
    {47,62}, {47,63}, {28,3}, {47,76}, {38,47}, {40,21}, {47,71}, {41,79}, 
    {17,21}, {47,75}, {47,69}, {47,78}, {32,49}, {23,35}, {38,59}, {63,38}, 
    {47,77}, {36,60}, {47,66}, {23,85}, {23,84}, {47,64}, {27,57}, {47,72}, 
    {41,78}, {34,44}, {47,68}, {22,80}, {47,65}, {47,73}, {47,67}, {45,48}, 
    {47,74}, {46,32}, {21,69}, {22,79}, {47,79}, {47,80}, {47,84}, {15,45}, 
    {41,47}, {47,83}, {47,82}, {47,86}, {47,85}, {35,67}, {22,81}, {47,87}, 
    {27,36}, {33,5}, {35,68}, {21,85}, {47,88}, {20,21}, {47,89}, {47,91}, 
    {42,20}, {22,69}, {26,16}, {39,86}, {47,90}, {25,36}, {44,34}, {47,93}, 
    {48,2}, {47,92}, {25,35}, {28,92}, {22,24}, {48,3}, {21,46}, {48,0}, 
    {48,1}, {37,14}, {32,91}, {21,2}, {42,44}, {48,4}, {45,28}, {48,5}, 
    {48,8}, {48,6}, {32,45}, {48,7}, {48,9}, {48,11}, {48,10}, {41,39}, 
    {20,22}, {48,13}, {48,14}, {17,14}, {48,12}, {27,83}, {48,17}, {48,16}, 
    {48,15}, {47,53}, {48,18}, {28,93}, {48,19}, {44,4}, {43,56}, {48,21}, 
    {48,20}, {48,23}, {48,22}, {48,24}, {48,25}, {15,83}, {23,20}, {22,26}, 
    {28,27}, {34,90}, {21,3}, {31,71}, {23,86}, {24,77}, {48,27}, {43,39}, 
    {36,37}, {26,88}, {48,26}, {48,28}, {36,61}, {18,84}, {48,29}, {37,93}, 
    {32,19}, {48,31}, {48,32}, {39,11}, {23,87}, {46,26}, {48,33}, {21,5}, 
    {41,27}, {33,21}, {21,80}, {36,20}, {22,82}, {48,34}, {48,35}, {37,65}, 
    {16,62}, {48,38}, {25,92}, {48,37}, {25,37}, {48,39}, {69,77}, {48,40}, 
    {42,32}, {48,41}, {48,42}, {48,43}, {29,72}, {27,43}, {19,6}, {48,46}, 
    {48,44}, {43,28}, {48,45}, {40,57}, {48,47}, {48,48}, {48,49}, {36,62}, 
    {48,53}, {48,51}, {48,52}, {48,50}, {25,66}, {48,54}, {43,73}, {45,67}, 
    {48,55}, {31,7}, {48,56}, {28,57}, {48,57}, {34,91}, {45,30}, {36,63}, 
    {49,36}, {48,58}, {83,4}, {21,36}, {48,59}, {42,61}, {28,71}, {33,91}, 
    {48,61}, {37,67}, {48,62}, {48,63}, {18,13}, {48,64}, {21,6}, {37,43}, 
    {16,89}, {28,47}, {39,0}, {48,65}, {36,64}, {30,46}, {48,66}, {41,11}, 
    {31,57}, {19,1}, {19,8}, {48,67}, {48,69}, {22,25}, {48,68}, {45,82}, 
    {28,72}, {39,28}, {41,43}, {48,70}, {44,87}, {48,71}, {48,72}, {36,93}, 
    {48,73}, {31,8}, {25,93}, {22,83}, {48,74}, {26,40}, {24,78}, {35,69}, 
    {48,76}, {33,6}, {25,78}, {48,77}, {48,78}, {32,15}, {48,75}, {48,80}, 
    {42,21}, {24,67}, {48,79}, {22,84}, {25,61}, {38,76}, {48,83}, {48,81}, 
    {40,90}, {29,73}, {48,90}, {18,67}, {48,84}, {48,82}, {32,46}, {48,86}, 
    {48,85}, {18,35}, {22,63}, {48,91}, {45,12}, {48,87}, {48,92}, {48,89}, 
    {48,88}, {45,46}, {23,88}, {17,34}, {45,83}, {28,84}, {36,55}, {24,68}, 
    {49,1}, {49,2}, {45,68}, {46,10}, {49,4}, {23,89}, {49,3}, {18,14}, 
    {49,5}, {42,53}, {35,27}, {44,5}, {41,56}, {49,6}, {79,52}, {37,15}, 
    {49,7}, {19,9}, {43,18}, {29,0}, {49,8}, {41,70}, {49,12}, {31,9}, 
    {49,9}, {21,47}, {49,10}, {19,10}, {22,13}, {49,13}, {49,14}, {49,15}, 
    {49,16}, {27,58}, {23,90}, {43,61}, {43,71}, {37,86}, {41,80}, {49,17}, 
    {49,18}, {49,20}, {49,22}, {49,21}, {49,23}, {17,28}, {42,43}, {25,91}, 
    {49,24}, {32,56}, {29,1}, {21,8}, {49,25}, {39,58}, {49,26}, {49,27}, 
    {49,28}, {49,29}, {40,3}, {21,71}, {15,68}, {37,30}, {49,30}, {28,28}, 
    {31,72}, {49,32}, {49,31}, {29,2}, {23,64}, {49,34}, {39,29}, {49,35}, 
    {39,59}, {33,19}, {33,77}, {21,7}, {37,77}, {34,16}, {38,77}, {42,45}, 
    {49,37}, {31,73}, {22,20}, {49,38}, {49,39}, {16,11}, {15,84}, {19,76}, 
    {33,7}, {20,48}, {44,80}, {49,42}, {17,22}, {49,41}, {21,9}, {49,43}, 
    {43,80}, {49,44}, {45,49}, {23,91}, {23,21}, {49,45}, {49,47}, {49,46}, 
    {30,62}, {16,24}, {16,61}, {49,48}, {49,49}, {23,22}, {49,50}, {20,77}, 
    {26,17}, {49,51}, {42,83}, {25,20}, {20,57}, {44,6}, {32,47}, {39,30}, 
    {27,92}, {28,38}, {27,71}, {27,84}, {28,85}, {39,31}, {49,54}, {16,34}, 
    {32,48}, {23,92}, {23,36}, {21,70}, {49,58}, {34,0}, {33,93}, {21,10}, 
    {29,3}, {49,59}, {49,57}, {17,35}, {33,69}, {27,23}, {26,42}, {16,5}, 
    {18,79}, {24,69}, {26,41}, {49,60}, {49,61}, {20,40}, {18,37}, {24,70}, 
    {20,39}, {35,62}, {16,4}, {37,16}, {43,29}, {24,0}, {44,88}, {36,38}, 
    {23,93}, {22,14}, {49,70}, {21,66}, {42,41}, {39,60}, {49,69}, {19,61}, 
    {49,64}, {49,65}, {49,67}, {49,68}, {20,58}, {30,64}, {41,12}, {49,66}, 
    {49,62}, {23,66}, {49,63}, {46,3}, {41,81}, {35,71}, {23,65}, {24,79}, 
    {49,71}, {37,60}, {49,75}, {27,93}, {27,85}, {49,78}, {49,76}, {43,2}, 
    {49,73}, {49,82}, {49,77}, {49,80}, {23,37}, {43,30}, {49,81}, {49,83}, 
    {49,85}, {25,79}, {46,33}, {49,74}, {49,72}, {49,84}, {49,79}, {49,87}, 
    {50,2}, {49,89}, {49,93}, {50,0}, {49,90}, {50,29}, {25,72}, {18,16}, 
    {49,88}, {50,4}, {15,85}, {50,3}, {15,4}, {40,41}, {50,1}, {49,91}, 
    {49,86}, {49,92}, {25,39}, {50,5}, {15,86}, {50,14}, {50,6}, {50,7}, 
    {29,4}, {42,72}, {50,12}, {50,11}, {36,14}, {50,13}, {50,10}, {16,19}, 
    {25,21}, {30,15}, {50,8}, {36,65}, {50,9}, {15,1}, {50,19}, {44,2}, 
    {29,6}, {50,25}, {50,24}, {50,15}, {33,34}, {50,16}, {33,78}, {50,21}, 
    {29,5}, {50,18}, {43,67}, {22,27}, {50,22}, {50,23}, {50,20}, {50,26}, 
    {50,17}, {50,32}, {50,37}, {50,33}, {50,28}, {50,38}, {32,16}, {50,40}, 
    {24,1}, {50,30}, {34,92}, {50,34}, {50,27}, {19,12}, {19,77}, {18,68}, 
    {50,35}, {50,31}, {22,85}, {50,41}, {50,39}, {32,50}, {20,41}, {21,11}, 
    {50,36}, {21,83}, {16,35}, {50,45}, {50,43}, {51,6}, {50,48}, {50,42}, 
    {50,46}, {50,44}, {26,43}, {50,47}, {50,50}, {50,55}, {50,53}, {50,52}, 
    {34,17}, {17,36}, {50,49}, {50,51}, {29,7}, {16,18}, {50,54}, {17,61}, 
    {50,65}, {29,91}, {50,61}, {50,59}, {50,60}, {50,62}, {16,28}, {32,24}, 
    {50,56}, {50,57}, {18,89}, {50,64}, {19,78}, {50,67}, {50,63}, {50,66}, 
    {41,13}, {37,52}, {39,23}, {50,69}, {50,68}, {18,36}, {50,70}, {50,73}, 
    {50,72}, {50,71}, {38,24}, {50,74}, {50,75}, {50,77}, {50,76}, {50,79}, 
    {50,82}, {50,80}, {50,78}, {50,81}, {50,83}, {50,84}, {50,85}, {50,86}, 
    {50,87}, {48,36}, {27,91}, {26,44}, {17,82}, {15,87}, {34,35}, {50,88}, 
    {25,3}, {15,46}, {30,61}, {50,89}, {23,38}, {24,80}, {50,91}, {50,90}, 
    {41,63}, {50,92}, {51,0}, {50,93}, {51,1}, {51,2}, {22,86}, {16,63}, 
    {51,3}, {51,5}, {51,4}, {51,7}, {36,57}, {51,8}, {15,20}, {25,62}, 
    {22,28}, {34,46}, {51,9}, {51,10}, {51,12}, {51,13}, {25,67}, {21,48}, 
    {42,22}, {51,11}, {51,14}, {25,32}, {24,2}, {51,18}, {25,4}, {34,18}, 
    {51,15}, {35,57}, {51,19}, {30,65}, {51,17}, {51,20}, {22,30}, {51,21}, 
    {51,22}, {24,3}, {18,31}, {51,24}, {51,25}, {51,26}, {51,23}, {51,16}, 
    {51,27}, {51,28}, {42,67}, {29,74}, {51,30}, {51,31}, {51,29}, {51,33}, 
    {38,23}, {15,71}, {40,53}, {51,34}, {29,92}, {27,24}, {38,60}, {19,79}, 
    {25,74}, {42,56}, {37,17}, {22,87}, {33,46}, {51,32}, {51,35}, {33,35}, 
    {51,36}, {51,37}, {51,39}, {35,72}, {19,13}, {83,0}, {16,64}, {41,82}, 
    {29,75}, {36,39}, {25,69}, {51,45}, {41,28}, {45,60}, {17,83}, {51,41}, 
    {32,25}, {51,44}, {36,66}, {36,40}, {36,67}, {39,24}, {35,44}, {25,40}, 
    {51,40}, {16,85}, {36,21}, {51,42}, {51,38}, {30,47}, {51,46}, {28,45}, 
    {21,12}, {51,47}, {41,71}, {32,92}, {35,37}, {51,49}, {42,46}, {51,50}, 
    {51,55}, {41,14}, {51,54}, {51,48}, {51,51}, {51,53}, {25,5}, {41,40}, 
    {51,56}, {34,36}, {17,84}, {29,76}, {51,58}, {51,57}, {24,71}, {51,59}, 
    {51,61}, {51,60}, {51,63}, {51,52}, {51,65}, {51,64}, {51,62}, {26,45}, 
    {30,48}, {32,51}, {51,66}, {31,27}, {15,76}, {38,67}, {35,58}, {51,68}, 
    {51,67}, {51,69}, {51,70}, {51,71}, {51,72}, {41,48}, {51,73}, {17,37}, 
    {51,74}, {44,27}, {18,15}, {49,40}, {28,39}, {33,30}, {51,75}, {43,74}, 
    {43,19}, {51,77}, {33,70}, {36,22}, {33,31}, {40,54}, {51,78}, {51,79}, 
    {16,90}, {27,25}, {51,80}, {15,47}, {51,81}, {51,82}, {16,65}, {19,80}, 
    {37,63}, {41,83}, {51,86}, {32,52}, {51,85}, {22,31}, {42,58}, {51,84}, 
    {36,68}, {51,88}, {51,87}, {51,90}, {51,89}, {16,91}, {51,91}, {29,8}, 
    {51,93}, {34,4}, {51,92}, {41,18}, {28,86}, {36,58}, {52,0}, {24,4}, 
    {52,1}, {38,0}, {39,61}, {43,48}, {38,4}, {52,10}, {20,23}, {44,36}, 
    {43,14}, {53,11}, {52,2}, {52,5}, {33,36}, {42,23}, {36,41}, {52,6}, 
    {42,68}, {25,41}, {29,9}, {52,7}, {26,47}, {26,46}, {15,24}, {23,39}, 
    {31,10}, {15,48}, {52,11}, {52,12}, {52,9}, {16,23}, {19,14}, {52,8}, 
    {43,36}, {40,16}, {15,7}, {15,88}, {26,48}, {15,49}, {15,2}, {52,17}, 
    {52,15}, {43,27}, {52,18}, {52,16}, {52,14}, {30,16}, {52,13}, {41,57}, 
    {23,67}, {52,22}, {52,23}, {29,10}, {52,19}, {46,11}, {38,43}, {52,21}, 
    {25,6}, {52,24}, {40,55}, {52,25}, {52,20}, {43,26}, {38,61}, {52,26}, 
    {40,17}, {52,27}, {52,31}, {52,28}, {17,38}, {52,30}, {27,26}, {52,29}, 
    {22,88}, {52,43}, {52,36}, {52,33}, {34,67}, {52,32}, {52,34}, {52,35}, 
    {52,37}, {52,38}, {19,81}, {52,40}, {52,39}, {52,41}, {29,77}, {52,44}, 
    {35,59}, {16,36}, {52,42}, {52,45}, {52,46}, {52,49}, {52,47}, {52,48}, 
    {26,49}, {52,50}, {24,5}, {52,51}, {26,89}, {33,23}, {52,52}, {52,53}, 
    {26,57}, {24,6}, {43,49}, {20,7}, {23,40}, {52,54}, {18,55}, {52,55}, 
    {33,24}, {52,56}, {53,2}, {52,57}, {52,58}, {52,59}, {52,61}, {52,62}, 
    {52,63}, {33,79}, {16,6}, {27,72}, {15,33}, {32,54}, {19,15}, {27,20}, 
    {24,7}, {36,69}, {28,0}, {19,16}, {34,71}, {35,73}, {15,23}, {20,24}, 
    {41,84}, {27,33}, {20,49}, {31,74}, {27,27}, {44,7}, {52,64}, {20,59}, 
    {25,42}, {18,17}, {16,66}, {29,11}, {17,39}, {52,65}, {44,37}, {28,40}, 
    {27,67}, {52,66}, {19,82}, {37,49}, {43,8}, {52,67}, {52,68}, {40,56}, 
    {52,70}, {19,7}, {21,86}, {52,69}, {19,17}, {30,17}, {52,74}, {26,0}, 
    {17,40}, {52,73}, {52,71}, {52,75}, {52,72}, {38,10}, {59,44}, {30,18}, 
    {52,76}, {45,31}, {52,77}, {52,79}, {34,93}, {52,78}, {31,2}, {26,90}, 
    {33,47}, {27,86}, {40,84}, {31,75}, {27,44}, {52,80}, {29,12}, {52,81}, 
    {52,82}, {15,50}, {33,25}, {30,49}, {52,83}, {37,18}, {29,13}, {29,14}, 
    {52,84}, {31,76}, {29,15}, {52,85}, {52,86}, {43,63}, {52,87}, {21,37}, 
    {28,1}, {52,88}, {52,89}, {27,59}, {30,11}, {37,83}, {30,51}, {39,87}, 
    {38,1}, {21,40}, {52,90}, {20,78}, {52,91}, {21,93}, {37,46}, {17,15}, 
    {26,50}, {52,92}, {53,1}, {53,0}, {21,92}, {52,93}, {36,23}, {33,15}, 
    {36,42}, {27,39}, {32,55}, {44,89}, {53,3}, {53,4}, {37,53}, {26,18}, 
    {53,6}, {53,7}, {53,8}, {19,83}, {53,9}, {53,10}, {17,11}, {32,26}, 
    {19,67}, {53,12}, {43,7}, {33,49}, {18,56}, {53,14}, {53,16}, {19,62}, 
    {53,13}, {53,15}, {53,18}, {53,17}, {53,19}, {53,20}, {37,28}, {21,13}, 
    {17,68}, {53,21}, {53,26}, {53,24}, {41,86}, {41,85}, {36,70}, {53,23}, 
    {28,51}, {53,22}, {30,81}, {53,27}, {25,73}, {53,33}, {53,34}, {53,28}, 
    {18,18}, {53,29}, {53,38}, {53,37}, {53,36}, {53,32}, {53,31}, {53,35}, 
    {41,87}, {53,42}, {53,39}, {53,41}, {44,81}, {53,40}, {53,30}, {30,82}, 
    {53,43}, {25,22}, {53,44}, {53,45}, {53,48}, {53,47}, {53,46}, {36,71}, 
    {53,25}, {53,54}, {53,50}, {53,49}, {53,51}, {53,52}, {53,55}, {45,69}, 
    {53,56}, {53,53}, {53,57}, {19,63}, {53,58}, {53,60}, {53,59}, {53,61}, 
    {53,62}, {31,77}, {28,2}, {28,67}, {32,66}, {24,8}, {25,23}, {24,9}, 
    {20,79}, {53,63}, {25,24}, {23,41}, {53,64}, {43,5}, {38,34}, {53,65}, 
    {24,10}, {19,11}, {34,6}, {21,49}, {26,51}, {40,58}, {39,32}, {53,66}, 
    {19,84}, {53,69}, {35,0}, {53,68}, {53,67}, {53,70}, {35,74}, {30,66}, 
    {26,52}, {31,41}, {33,50}, {20,1}, {35,1}, {53,71}, {53,72}, {29,78}, 
    {42,24}, {53,75}, {53,74}, {53,73}, {40,92}, {53,82}, {42,57}, {53,76}, 
    {53,78}, {42,74}, {53,77}, {53,79}, {39,7}, {53,80}, {41,29}, {53,81}, 
    {19,18}, {41,30}, {38,14}, {53,83}, {53,84}, {24,11}, {19,19}, {53,85}, 
    {23,23}, {44,35}, {44,8}, {19,85}, {53,87}, {35,2}, {24,12}, {29,16}, 
    {39,62}, {29,17}, {28,87}, {35,75}, {41,88}, {36,24}, {24,13}, {40,59}, 
    {53,88}, {36,56}, {25,33}, {23,42}, {35,76}, {15,34}, {28,77}, {24,14}, 
    {44,38}, {53,89}, {53,90}, {38,48}, {53,91}, {45,86}, {46,12}, {53,93}, 
    {53,92}, {18,38}, {54,0}, {54,3}, {54,4}, {54,2}, {40,31}, {29,18}, 
    {54,6}, {54,5}, {54,1}, {54,7}, {54,8}, {54,9}, {54,12}, {54,10}, {54,11}, 
    {54,13}, {16,67}, {35,77}, {54,14}, {22,89}, {17,85}, {38,21}, {54,15}, 
    {37,90}, {41,58}, {54,16}, {46,13}, {54,17}, {41,31}, {54,20}, {47,0}, 
    {47,16}, {27,15}, {37,84}, {54,21}, {20,60}, {35,3}, {15,89}, {54,22}, 
    {41,5}, {24,15}, {34,47}, {35,78}, {43,78}, {23,24}, {23,43}, {54,23}, 
    {54,24}, {54,30}, {27,68}, {35,4}, {21,14}, {54,25}, {40,10}, {34,37}, 
    {54,26}, {54,27}, {21,15}, {54,28}, {54,29}, {54,31}, {36,85}, {54,32}, 
    {54,33}, {54,34}, {54,19}, {54,18}, {54,35}, {22,32}, {40,6}, {25,43}, 
    {40,22}, {35,5}, {40,42}, {54,36}, {29,19}, {16,37}, {54,37}, {54,38}, 
    {43,81}, {39,63}, {54,41}, {16,92}, {31,11}, {54,40}, {54,39}, {22,33}, 
    {33,51}, {54,45}, {54,43}, {54,42}, {45,6}, {23,68}, {28,88}, {54,44}, 
    {36,43}, {28,29}, {37,31}, {54,48}, {54,47}, {54,46}, {54,49}, {23,69}, 
    {54,50}, {40,91}, {28,58}, {54,51}, {39,88}, {37,32}, {35,6}, {36,15}, 
    {54,52}, {20,10}, {30,19}, {40,11}, {19,86}, {38,5}, {54,53}, {26,53}, 
    {42,25}, {42,26}, {16,93}, {54,58}, {34,72}, {54,55}, {17,86}, {55,12}, 
    {54,57}, {38,15}, {54,56}, {54,54}, {24,89}, {54,60}, {54,66}, {54,72}, 
    {54,64}, {36,59}, {54,69}, {40,60}, {54,63}, {54,68}, {45,70}, {26,54}, 
    {33,52}, {54,61}, {20,61}, {54,71}, {31,12}, {16,68}, {54,65}, {17,87}, 
    {54,70}, {21,16}, {54,67}, {54,73}, {54,75}, {54,85}, {54,83}, {54,80}, 
    {54,79}, {45,87}, {54,81}, {21,17}, {24,16}, {28,89}, {54,88}, {54,74}, 
    {54,78}, {54,62}, {17,89}, {54,82}, {54,84}, {34,48}, {25,7}, {17,23}, 
    {54,76}, {54,87}, {54,86}, {21,18}, {33,8}, {18,69}, {22,34}, {54,77}, 
    {54,89}, {54,92}, {55,0}, {27,28}, {55,6}, {35,79}, {54,90}, {55,4}, 
    {17,88}, {55,2}, {55,3}, {54,93}, {55,1}, {23,70}, {44,9}, {19,20}, 
    {16,56}, {55,5}, {38,25}, {15,12}, {39,64}, {54,59}, {55,11}, {55,15}, 
    {43,68}, {55,8}, {36,72}, {55,13}, {29,79}, {55,14}, {37,54}, {46,38}, 
    {55,10}, {55,16}, {24,90}, {31,42}, {15,51}, {55,9}, {55,7}, {32,57}, 
    {54,91}, {26,19}, {33,37}, {55,28}, {32,58}, {55,23}, {55,20}, {55,21}, 
    {27,69}, {55,24}, {55,27}, {55,22}, {28,4}, {55,25}, {55,19}, {43,91}, 
    {43,90}, {55,29}, {55,30}, {15,52}, {55,18}, {21,81}, {15,5}, {19,21}, 
    {55,26}, {55,34}, {55,33}, {55,38}, {55,39}, {55,37}, {55,40}, {55,32}, 
    {55,36}, {55,41}, {55,42}, {55,31}, {26,91}, {55,35}, {33,53}, {24,17}, 
    {55,17}, {30,20}, {55,55}, {41,72}, {55,45}, {55,46}, {55,47}, {55,54}, 
    {55,53}, {42,92}, {19,22}, {55,51}, {22,36}, {18,19}, {55,48}, {45,23}, 
    {55,50}, {15,53}, {55,52}, {55,43}, {55,49}, {55,56}, {22,35}, {55,44}, 
    {44,60}, {44,10}, {55,59}, {55,63}, {32,93}, {45,88}, {55,64}, {55,61}, 
    {55,58}, {55,57}, {55,62}, {41,15}, {37,19}, {22,37}, {55,65}, {55,60}, 
    {55,66}, {22,90}, {17,16}, {55,74}, {19,23}, {55,72}, {55,73}, {25,8}, 
    {55,71}, {55,69}, {55,68}, {55,75}, {55,67}, {55,77}, {17,90}, {55,79}, 
    {55,78}, {35,7}, {55,82}, {55,80}, {55,70}, {22,91}, {55,81}, {55,85}, 
    {55,84}, {55,86}, {55,83}, {55,87}, {55,88}, {55,89}, {41,73}, {55,91}, 
    {55,90}, {28,30}, {31,13}, {17,69}, {17,91}, {55,92}, {15,30}, {31,43}, 
    {55,93}, {75,34}, {56,0}, {22,64}, {56,1}, {31,78}, {56,2}, {56,3}, 
    {20,25}, {56,4}, {56,5}, {56,6}, {33,54}, {23,44}, {43,64}, {42,27}, 
    {28,73}, {56,7}, {31,79}, {77,28}, {39,65}, {27,73}, {25,44}, {56,8}, 
    {33,38}, {41,6}, {33,80}, {56,11}, {56,9}, {56,12}, {56,10}, {56,13}, 
    {41,16}, {15,22}, {40,61}, {39,66}, {56,14}, {56,17}, {29,20}, {20,26}, 
    {56,15}, {56,22}, {29,21}, {56,16}, {38,35}, {44,61}, {56,18}, {56,19}, 
    {56,23}, {36,73}, {56,20}, {24,18}, {31,61}, {56,37}, {39,19}, {33,81}, 
    {39,67}, {57,12}, {41,89}, {35,80}, {42,84}, {56,26}, {17,0}, {34,73}, 
    {56,35}, {34,19}, {56,29}, {56,36}, {56,31}, {56,38}, {56,34}, {56,33}, 
    {38,78}, {56,27}, {17,92}, {56,25}, {20,80}, {33,82}, {56,21}, {56,24}, 
    {24,19}, {31,58}, {29,22}, {56,32}, {38,49}, {20,81}, {18,39}, {18,70}, 
    {30,0}, {56,40}, {56,45}, {56,41}, {22,92}, {56,46}, {26,1}, {24,72}, 
    {28,5}, {56,28}, {26,92}, {56,43}, {26,55}, {56,44}, {15,35}, {56,39}, 
    {35,8}, {20,82}, {21,19}, {56,42}, {15,6}, {25,34}, {30,21}, {35,81}, 
    {39,51}, {56,48}, {32,61}, {33,9}, {26,10}, {56,49}, {56,51}, {56,47}, 
    {41,64}, {35,28}, {32,59}, {41,90}, {27,45}, {56,63}, {56,62}, {30,87}, 
    {22,93}, {56,56}, {29,24}, {37,71}, {38,16}, {56,54}, {32,60}, {27,87}, 
    {56,59}, {29,23}, {56,53}, {56,58}, {38,50}, {56,52}, {22,0}, {18,60}, 
    {56,60}, {45,10}, {25,45}, {34,20}, {56,57}, {31,59}, {24,20}, {30,67}, 
    {16,69}, {32,27}, {56,55}, {20,36}, {22,38}, {35,46}, {56,61}, {32,62}, 
    {56,64}, {56,66}, {33,22}, {56,72}, {56,67}, {56,69}, {40,32}, {35,82}, 
    {56,70}, {44,11}, {44,39}, {19,24}, {15,13}, {56,68}, {56,65}, {19,87}, 
    {16,70}, {56,71}, {44,40}, {56,75}, {33,26}, {56,82}, {56,76}, {56,73}, 
    {56,80}, {56,50}, {56,77}, {56,81}, {39,33}, {36,74}, {56,74}, {56,78}, 
    {22,39}, {25,80}, {31,60}, {56,86}, {36,5}, {56,83}, {42,63}, {56,84}, 
    {56,85}, {43,45}, {31,1}, {22,65}, {56,92}, {26,20}, {56,89}, {56,88}, 
    {38,17}, {37,20}, {36,16}, {56,90}, {56,91}, {40,78}, {38,36}, {26,2}, 
    {31,80}, {42,47}, {18,40}, {57,4}, {56,93}, {44,41}, {57,6}, {57,2}, 
    {57,3}, {32,63}, {57,1}, {56,30}, {57,5}, {57,0}, {57,10}, {57,11}, 
    {36,6}, {57,13}, {26,3}, {57,8}, {20,27}, {57,14}, {57,7}, {57,18}, 
    {57,17}, {57,16}, {57,19}, {57,21}, {29,80}, {57,20}, {57,24}, {57,22}, 
    {57,23}, {56,79}, {57,26}, {57,25}, {56,87}, {57,27}, {57,15}, {26,56}, 
    {57,28}, {57,29}, {57,31}, {57,30}, {57,32}, {17,93}, {24,21}, {41,91}, 
    {31,14}, {23,45}, {57,34}, {57,37}, {40,49}, {20,62}, {57,36}, {57,35}, 
    {38,51}, {57,38}, {21,20}, {57,40}, {57,39}, {19,25}, {26,21}, {37,55}, 
    {22,40}, {30,83}, {57,41}, {31,15}, {36,7}, {40,62}, {57,42}, {57,43}, 
    {57,44}, {41,23}, {52,60}, {31,37}, {40,43}, {25,55}, {39,68}, {39,34}, 
    {36,44}, {45,32}, {57,46}, {27,47}, {57,47}, {15,21}, {21,51}, {31,44}, 
    {40,63}, {57,48}, {26,33}, {34,38}, {26,58}, {30,22}, {57,49}, {41,92}, 
    {16,86}, {26,59}, {57,52}, {57,50}, {57,53}, {45,24}, {57,51}, {31,90}, 
    {57,54}, {33,17}, {57,55}, {19,89}, {57,57}, {57,56}, {57,58}, {57,59}, 
    {19,90}, {37,91}, {34,21}, {20,75}, {26,60}, {32,64}, {28,59}, {15,15}, 
    {57,60}, {17,1}, {57,64}, {24,22}, {57,63}, {25,10}, {29,25}, {57,62}, 
    {29,26}, {43,31}, {25,9}, {15,54}, {31,45}, {57,69}, {31,16}, {16,38}, 
    {28,52}, {42,69}, {25,81}, {29,27}, {31,6}, {57,68}, {57,66}, {57,67}, 
    {34,74}, {58,5}, {57,73}, {26,93}, {24,23}, {57,71}, {57,72}, {30,23}, 
    {57,70}, {26,14}, {57,75}, {57,74}, {57,79}, {57,80}, {57,76}, {18,1}, 
    {57,77}, {57,78}, {39,52}, {40,64}, {22,41}, {57,81}, {31,17}, {29,28}, 
    {34,49}, {21,38}, {57,82}, {57,86}, {17,42}, {57,83}, {57,85}, {57,84}, 
    {28,74}, {34,39}, {15,36}, {57,87}, {57,88}, {35,9}, {45,80}, {26,34}, 
    {41,74}, {42,28}, {58,1}, {57,90}, {57,93}, {57,92}, {57,89}, {58,0}, 
    {37,61}, {57,91}, {58,2}, {28,75}, {58,3}, {44,42}, {38,87}, {58,4}, 
    {58,6}, {58,7}, {58,8}, {21,41}, {16,39}, {24,24}, {58,9}, {58,10}, 
    {28,80}, {32,65}, {49,55}, {32,29}, {32,28}, {33,55}, {25,38}, {47,81}, 
    {22,77}, {44,12}, {41,93}, {40,93}, {58,11}, {25,82}, {35,30}, {58,12}, 
    {46,14}, {42,29}, {35,10}, {58,13}, {19,91}, {58,14}, {58,15}, {43,57}, 
    {43,3}, {42,85}, {42,59}, {26,4}, {58,17}, {27,74}, {42,48}, {58,19}, 
    {58,22}, {58,21}, {19,88}, {20,63}, {58,18}, {58,20}, {58,23}, {30,88}, 
    {44,90}, {15,40}, {25,63}, {33,27}, {27,60}, {29,82}, {58,26}, {36,45}, 
    {58,24}, {33,10}, {58,25}, {29,81}, {43,60}, {58,27}, {58,28}, {44,71}, 
    {58,33}, {24,25}, {38,52}, {58,30}, {36,75}, {57,61}, {57,65}, {20,46}, 
    {38,38}, {58,32}, {29,29}, {39,35}, {58,38}, {39,89}, {58,29}, {58,35}, 
    {58,34}, {31,46}, {42,76}, {45,50}, {42,70}, {17,43}, {26,61}, {46,39}, 
    {58,37}, {30,84}, {58,36}, {58,31}, {23,46}, {58,43}, {58,41}, {17,44}, 
    {58,39}, {58,45}, {58,51}, {33,39}, {41,32}, {58,53}, {40,1}, {58,52}, 
    {38,79}, {42,30}, {19,26}, {31,86}, {28,31}, {35,50}, {44,13}, {58,48}, 
    {58,47}, {58,49}, {58,46}, {58,54}, {58,44}, {58,42}, {58,50}, {58,40}, 
    {34,75}, {43,87}, {27,37}, {25,83}, {25,25}, {42,78}, {18,32}, {35,45}, 
    {37,41}, {16,40}, {31,81}, {31,19}, {22,9}, {58,56}, {24,26}, {18,91}, 
    {58,58}, {18,83}, {58,64}, {58,61}, {31,82}, {18,42}, {25,11}, {18,41}, 
    {25,46}, {58,59}, {22,68}, {22,42}, {36,76}, {58,57}, {15,37}, {58,60}, 
    {58,62}, {21,44}, {22,11}, {19,27}, {20,42}, {58,65}, {25,88}, {42,80}, 
    {26,22}, {58,66}, {40,15}, {58,78}, {17,18}, {58,67}, {58,84}, {58,68}, 
    {45,33}, {58,75}, {38,62}, {58,83}, {58,70}, {15,19}, {58,72}, {24,27}, 
    {58,74}, {58,73}, {58,69}, {58,80}, {29,30}, {51,76}, {23,71}, {44,91}, 
    {58,71}, {35,83}, {18,2}, {25,12}, {58,63}, {58,79}, {18,64}, {58,77}, 
    {58,81}, {36,77}, {19,93}, {59,17}, {43,40}, {58,86}, {19,92}, {58,93}, 
    {42,31}, {59,0}, {59,2}, {59,6}, {58,88}, {34,9}, {36,78}, {59,10}, 
    {58,91}, {59,7}, {59,1}, {30,24}, {59,11}, {31,18}, {59,9}, {19,28}, 
    {46,47}, {58,85}, {59,5}, {15,55}, {58,87}, {43,25}, {58,92}, {30,1}, 
    {35,38}, {58,82}, {59,4}, {30,89}, {59,14}, {18,80}, {23,0}, {59,16}, 
    {58,89}, {59,15}, {59,8}, {58,90}, {59,12}, {59,13}, {59,30}, {37,45}, 
    {59,3}, {59,26}, {59,28}, {35,55}, {44,43}, {40,85}, {59,23}, {33,41}, 
    {59,29}, {32,30}, {59,20}, {59,33}, {59,32}, {37,78}, {59,31}, {37,73}, 
    {59,35}, {59,22}, {21,39}, {59,25}, {28,60}, {38,63}, {59,27}, {21,42}, 
    {59,19}, {59,21}, {59,18}, {46,15}, {18,57}, {59,24}, {59,34}, {18,20}, 
    {25,70}, {16,60}, {59,51}, {46,16}, {59,54}, {30,25}, {59,53}, {59,52}, 
    {59,49}, {59,37}, {59,66}, {59,36}, {59,55}, {59,47}, {59,42}, {59,39}, 
    {59,40}, {59,48}, {83,1}, {59,45}, {24,28}, {35,39}, {32,67}, {59,43}, 
    {59,38}, {59,41}, {44,44}, {42,73}, {59,46}, {59,56}, {59,64}, {59,57}, 
    {59,70}, {59,68}, {59,63}, {59,62}, {35,47}, {32,68}, {59,60}, {59,58}, 
    {59,65}, {59,71}, {39,84}, {59,77}, {59,72}, {59,75}, {59,69}, {34,83}, 
    {40,23}, {59,59}, {59,67}, {29,31}, {43,46}, {59,87}, {59,74}, {23,1}, 
    {17,2}, {18,62}, {59,50}, {29,32}, {59,79}, {59,86}, {27,88}, {18,81}, 
    {34,13}, {59,76}, {59,81}, {59,85}, {21,21}, {20,43}, {59,83}, {20,0}, 
    {37,42}, {59,82}, {59,84}, {59,78}, {59,80}, {18,63}, {34,40}, {59,91}, 
    {59,89}, {23,72}, {59,88}, {60,0}, {58,55}, {59,90}, {59,92}, {59,93}, 
    {60,11}, {60,7}, {58,76}, {60,6}, {60,5}, {60,2}, {59,73}, {60,4}, 
    {60,3}, {60,9}, {46,5}, {60,12}, {21,90}, {60,8}, {60,10}, {39,6}, 
    {60,13}, {60,17}, {60,14}, {44,82}, {60,15}, {59,61}, {60,18}, {60,19}, 
    {16,20}, {60,21}, {22,70}, {27,0}, {21,52}, {17,3}, {44,62}, {60,23}, 
    {60,22}, {60,25}, {20,28}, {21,53}, {19,29}, {60,28}, {60,27}, {60,29}, 
    {17,45}, {34,22}, {60,30}, {19,30}, {60,32}, {60,31}, {60,33}, {60,34}, 
    {60,35}, {26,62}, {31,20}, {25,0}, {40,79}, {41,65}, {46,35}, {26,84}, 
    {25,47}, {45,81}, {60,36}, {60,37}, {26,63}, {60,38}, {60,39}, {60,41}, 
    {60,40}, {42,55}, {28,61}, {27,75}, {26,35}, {60,42}, {60,44}, {30,2}, 
    {60,43}, {60,45}, {60,46}, {60,47}, {60,48}, {60,49}, {60,51}, {60,50}, 
    {60,52}, {17,4}, {34,41}, {60,53}, {26,5}, {18,43}, {60,54}, {36,33}, 
    {51,43}, {20,2}, {60,55}, {60,56}, {41,75}, {42,71}, {37,38}, {60,57}, 
    {39,69}, {39,90}, {43,50}, {60,58}, {60,60}, {60,59}, {60,62}, {60,61}, 
    {60,64}, {26,64}, {43,16}, {60,65}, {60,66}, {20,3}, {60,67}, {60,69}, 
    {60,68}, {30,68}, {40,24}, {16,41}, {39,36}, {35,84}, {28,32}, {20,64}, 
    {39,37}, {27,13}, {60,71}, {19,31}, {16,87}, {37,81}, {60,70}, {24,29}, 
    {34,50}, {60,72}, {60,80}, {60,73}, {33,32}, {20,65}, {60,81}, {22,71}, 
    {20,4}, {60,79}, {60,77}, {60,74}, {44,63}, {35,31}, {37,56}, {60,75}, 
    {60,83}, {60,82}, {22,2}, {17,12}, {25,26}, {60,76}, {60,78}, {42,54}, 
    {33,83}, {42,86}, {60,91}, {60,92}, {17,46}, {41,7}, {43,92}, {61,0}, 
    {27,2}, {29,33}, {60,87}, {60,93}, {16,71}, {21,22}, {60,84}, {60,89}, 
    {31,83}, {38,80}, {39,70}, {60,86}, {42,0}, {60,88}, {61,3}, {61,1}, 
    {60,90}, {42,1}, {38,39}, {20,66}, {36,4}, {34,76}, {61,4}, {61,2}, 
    {33,56}, {60,85}, {16,42}, {44,45}, {61,15}, {61,14}, {31,85}, {61,11}, 
    {44,75}, {37,21}, {61,5}, {35,36}, {16,43}, {24,30}, {61,8}, {28,6}, 
    {61,13}, {61,12}, {61,7}, {61,10}, {18,71}, {61,9}, {38,40}, {45,13}, 
    {29,83}, {31,84}, {61,21}, {61,19}, {40,44}, {61,16}, {61,18}, {16,25}, 
    {24,31}, {46,17}, {18,28}, {40,65}, {44,64}, {18,3}, {30,26}, {61,20}, 
    {61,25}, {29,34}, {44,15}, {61,22}, {61,17}, {61,23}, {45,61}, {36,82}, 
    {37,33}, {18,21}, {16,52}, {61,29}, {61,32}, {45,34}, {44,67}, {61,39}, 
    {61,33}, {61,30}, {45,51}, {61,36}, {28,41}, {61,38}, {61,43}, {36,80}, 
    {61,41}, {61,35}, {34,23}, {61,42}, {61,31}, {61,37}, {61,44}, {15,91}, 
    {61,34}, {61,45}, {30,27}, {28,62}, {41,4}, {25,13}, {61,26}, {61,40}, 
    {36,25}, {31,21}, {18,72}, {25,48}, {29,35}, {61,28}, {28,33}, {22,43}, 
    {61,27}, {61,49}, {28,76}, {23,25}, {61,64}, {61,58}, {20,83}, {36,46}, 
    {61,53}, {61,62}, {15,14}, {16,17}, {17,24}, {61,55}, {33,11}, {61,46}, 
    {61,48}, {24,32}, {61,65}, {61,60}, {61,52}, {61,59}, {43,10}, {61,57}, 
    {61,61}, {23,47}, {29,36}, {34,24}, {61,51}, {44,14}, {61,54}, {61,47}, 
    {36,81}, {61,50}, {61,56}, {46,48}, {27,29}, {42,93}, {61,66}, {39,13}, 
    {61,78}, {23,26}, {28,63}, {61,68}, {45,14}, {24,33}, {61,81}, {15,77}, 
    {61,79}, {61,67}, {61,73}, {61,75}, {44,46}, {61,70}, {36,13}, {61,72}, 
    {61,80}, {61,74}, {43,38}, {61,69}, {27,1}, {61,93}, {18,73}, {61,71}, 
    {61,76}, {61,77}, {33,75}, {33,57}, {61,85}, {61,91}, {61,89}, {36,8}, 
    {62,2}, {61,86}, {61,87}, {61,63}, {20,88}, {40,25}, {27,30}, {24,86}, 
    {46,18}, {61,83}, {62,1}, {16,72}, {32,69}, {38,88}, {19,32}, {45,89}, 
    {43,0}, {35,49}, {61,90}, {61,92}, {32,17}, {62,0}, {61,88}, {61,82}, 
    {19,34}, {22,72}, {62,14}, {62,9}, {31,87}, {18,66}, {28,64}, {62,18}, 
    {62,11}, {35,11}, {62,8}, {35,56}, {62,43}, {62,5}, {62,4}, {62,13}, 
    {62,7}, {62,6}, {62,12}, {31,0}, {62,3}, {62,15}, {62,16}, {19,33}, 
    {62,21}, {62,20}, {62,22}, {62,25}, {36,34}, {62,19}, {62,23}, {22,66}, 
    {33,88}, {62,17}, {38,26}, {62,24}, {62,29}, {62,27}, {62,30}, {62,33}, 
    {62,26}, {24,73}, {38,7}, {61,24}, {44,83}, {62,28}, {62,32}, {33,84}, 
    {62,31}, {62,10}, {78,72}, {62,36}, {62,40}, {62,38}, {62,34}, {62,35}, 
    {62,39}, {62,37}, {40,45}, {62,45}, {62,42}, {62,41}, {62,44}, {37,51}, 
    {62,46}, {34,84}, {33,76}, {31,4}, {62,47}, {62,49}, {62,48}, {61,84}, 
    {62,50}, {37,70}, {62,51}, {17,47}, {36,83}, {18,4}, {20,67}, {27,61}, 
    {25,49}, {46,6}, {30,69}, {16,73}, {62,53}, {62,52}, {62,56}, {34,25}, 
    {62,59}, {62,54}, {62,58}, {62,57}, {36,31}, {15,56}, {45,84}, {62,61}, 
    {16,7}, {62,63}, {62,62}, {62,60}, {62,55}, {42,2}, {62,65}, {62,64}, 
    {16,74}, {62,67}, {41,17}, {62,66}, {43,20}, {29,38}, {32,18}, {29,37}, 
    {45,90}, {62,73}, {31,88}, {62,69}, {62,74}, {16,75}, {62,72}, {38,64}, 
    {62,68}, {62,71}, {29,39}, {39,48}, {62,75}, {27,48}, {31,89}, {62,78}, 
    {62,70}, {22,6}, {62,76}, {44,47}, {62,79}, {83,5}, {28,46}, {62,80}, 
    {62,81}, {38,13}, {62,83}, {62,84}, {38,18}, {36,84}, {62,86}, {62,88}, 
    {45,52}, {62,85}, {62,87}, {16,76}, {62,82}, {50,58}, {62,89}, {32,70}, 
    {26,23}, {62,91}, {62,90}, {30,3}, {49,56}, {62,92}, {63,0}, {62,77}, 
    {62,93}, {63,1}, {38,89}, {63,2}, {63,3}, {63,4}, {63,5}, {35,61}, 
    {63,7}, {63,6}, {63,8}, {63,9}, {27,62}, {40,66}, {43,75}, {63,10}, 
    {63,11}, {32,53}, {27,3}, {63,12}, {63,13}, {63,14}, {41,49}, {39,38}, 
    {63,15}, {38,54}, {35,12}, {63,16}, {17,70}, {20,76}, {43,37}, {43,21}, 
    {17,19}, {46,19}, {42,49}, {41,9}, {31,22}, {63,17}, {37,34}, {23,2}, 
    {63,18}, {25,51}, {63,20}, {63,19}, {63,21}, {63,22}, {63,23}, {20,29}, 
    {63,24}, {63,25}, {23,3}, {39,39}, {63,27}, {29,84}, {63,26}, {21,23}, 
    {63,28}, {63,30}, {63,29}, {63,31}, {23,48}, {63,32}, {21,72}, {32,31}, 
    {24,92}, {63,34}, {63,35}, {63,33}, {27,76}, {37,39}, {21,24}, {63,37}, 
    {34,11}, {63,36}, {46,20}, {38,65}, {63,40}, {63,42}, {63,39}, {43,51}, 
    {63,41}, {63,43}, {45,35}, {63,47}, {63,46}, {34,85}, {38,12}, {23,4}, 
    {63,45}, {63,44}, {44,16}, {44,17}, {63,48}, {16,77}, {24,85}, {26,65}, 
    {63,49}, {63,50}, {63,52}, {28,34}, {63,54}, {63,53}, {63,55}, {18,44}, 
    {63,57}, {63,56}, {63,59}, {63,58}, {23,27}, {45,7}, {21,43}, {17,5}, 
    {21,73}, {19,64}, {45,71}, {63,61}, {63,63}, {63,64}, {17,48}, {63,60}, 
    {26,24}, {35,32}, {63,62}, {63,67}, {27,77}, {63,65}, {22,29}, {39,40}, 
    {63,66}, {63,93}, {63,72}, {23,28}, {20,68}, {63,69}, {44,92}, {45,15}, 
    {33,85}, {63,71}, {63,73}, {45,53}, {21,54}, {39,91}, {38,41}, {63,74}, 
    {63,76}, {63,79}, {63,75}, {63,78}, {23,73}, {16,44}, {63,80}, {30,79}, 
    {63,77}, {45,59}, {63,83}, {83,3}, {63,81}, {63,84}, {63,70}, {63,82}, 
    {25,27}, {63,85}, {63,86}, {44,93}, {63,87}, {63,88}, {63,68}, {63,89}, 
    {19,35}, {27,4}, {63,90}, {63,91}, {63,92}, {16,26}, {64,0}, {40,26}, 
    {64,1}, {19,3}, {64,2}, {64,3}, {64,4}, {64,6}, {64,7}, {64,5}, {40,50}, 
    {64,9}, {64,8}, {64,11}, {64,10}, {64,12}, {64,13}, {64,15}, {64,14}, 
    {24,88}, {64,17}, {64,16}, {19,36}, {30,50}, {36,27}, {64,18}, {31,23}, 
    {26,25}, {16,88}, {64,19}, {44,48}, {41,66}, {64,20}, {36,35}, {44,18}, 
    {24,34}, {30,28}, {34,42}, {49,19}, {35,13}, {17,71}, {64,21}, {64,22}, 
    {64,27}, {64,25}, {64,24}, {57,33}, {18,5}, {64,23}, {15,57}, {39,9}, 
    {39,41}, {45,16}, {64,28}, {64,26}, {34,59}, {31,5}, {39,10}, {40,12}, 
    {64,30}, {45,11}, {22,44}, {64,31}, {64,29}, {39,53}, {64,32}, {64,33}, 
    {15,58}, {29,85}, {64,38}, {64,35}, {37,76}, {64,34}, {20,5}, {64,41}, 
    {64,36}, {64,37}, {64,40}, {64,39}, {40,4}, {32,33}, {32,32}, {20,30}, 
    {64,42}, {64,43}, {64,44}, {64,46}, {64,45}, {16,53}, {64,54}, {39,71}, 
    {64,48}, {64,50}, {64,52}, {30,29}, {64,53}, {64,51}, {27,31}, {64,47}, 
    {64,49}, {40,33}, {29,40}, {64,56}, {64,55}, {64,57}, {27,5}, {25,14}, 
    {36,86}, {64,58}, {35,42}, {64,60}, {45,0}, {64,59}, {32,72}, {64,65}, 
    {64,67}, {64,68}, {34,51}, {64,66}, {64,63}, {64,61}, {64,62}, {64,64}, 
    {64,71}, {64,69}, {64,70}, {64,72}, {64,74}, {64,75}, {64,76}, {64,77}, 
    {64,73}, {64,79}, {64,78}, {64,80}, {45,36}, {64,83}, {64,81}, {64,82}, 
    {19,65}, {43,93}, {41,41}, {64,85}, {64,84}, {64,86}, {64,87}, {64,91}, 
    {64,88}, {64,89}, {64,90}, {64,92}, {64,93}, {65,0}, {65,1}, {65,2}, 
    {39,14}, {36,47}, {65,3}, {38,81}, {40,19}, {65,4}, {65,5}, {36,9}, 
    {18,6}, {24,35}, {65,6}, {65,7}, {65,8}, {26,8}, {65,10}, {65,9}, {65,11}, 
    {65,12}, {39,72}, {65,13}, {65,14}, {82,72}, {65,15}, {65,16}, {65,17}, 
    {26,13}, {65,18}, {38,53}, {42,62}, {16,45}, {16,54}, {65,19}, {65,21}, 
    {65,20}, {36,79}, {31,24}, {60,24}, {65,22}, {43,32}, {65,23}, {19,37}, 
    {39,54}, {65,24}, {65,25}, {65,26}, {43,59}, {43,52}, {35,29}, {32,73}, 
    {65,28}, {28,65}, {29,41}, {65,31}, {65,30}, {65,29}, {39,92}, {19,38}, 
    {23,8}, {65,37}, {65,34}, {30,30}, {43,17}, {65,33}, {65,35}, {65,36}, 
    {65,32}, {65,38}, {65,39}, {35,14}, {19,66}, {34,68}, {65,40}, {65,41}, 
    {65,44}, {30,70}, {37,35}, {65,45}, {42,50}, {65,42}, {65,43}, {65,48}, 
    {65,47}, {65,46}, {65,50}, {65,49}, {65,51}, {65,53}, {65,52}, {41,44}, 
    {28,53}, {45,37}, {65,54}, {37,22}, {65,55}, {65,56}, {65,60}, {65,58}, 
    {65,59}, {65,57}, {65,61}, {65,62}, {65,63}, {65,64}, {43,22}, {65,65}, 
    {43,79}, {65,66}, {34,45}, {38,73}, {21,74}, {34,26}, {65,67}, {21,25}, 
    {31,47}, {65,68}, {25,28}, {65,69}, {65,70}, {23,5}, {25,52}, {65,72}, 
    {36,53}, {25,53}, {20,45}, {42,3}, {38,42}, {36,54}, {24,59}, {65,74}, 
    {29,42}, {45,17}, {24,36}, {23,6}, {39,2}, {65,76}, {65,78}, {23,74}, 
    {65,77}, {35,85}, {65,80}, {18,22}, {65,75}, {39,73}, {16,15}, {25,75}, 
    {46,49}, {65,79}, {65,81}, {41,42}, {31,56}, {65,83}, {65,84}, {65,82}, 
    {18,45}, {65,90}, {65,89}, {27,6}, {65,91}, {65,86}, {65,92}, {65,87}, 
    {39,55}, {65,85}, {65,88}, {66,1}, {66,0}, {42,64}, {65,93}, {15,74}, 
    {66,3}, {66,2}, {29,43}, {66,4}, {32,34}, {66,6}, {66,5}, {66,7}, {65,71}, 
    {65,73}, {66,9}, {66,8}, {27,7}, {45,72}, {27,49}, {66,10}, {22,22}, 
    {20,31}, {20,6}, {26,66}, {44,19}, {66,16}, {66,15}, {32,35}, {66,12}, 
    {66,14}, {28,42}, {30,31}, {66,13}, {66,11}, {38,9}, {29,44}, {40,27}, 
    {25,54}, {36,87}, {66,17}, {66,18}, {66,40}, {21,55}, {46,28}, {32,20}, 
    {66,19}, {17,49}, {35,86}, {41,0}, {66,20}, {20,89}, {66,21}, {66,23}, 
    {66,24}, {38,8}, {66,25}, {66,26}, {66,27}, {21,56}, {17,50}, {37,36}, 
    {28,7}, {26,67}, {66,28}, {28,8}, {17,41}, {40,34}, {66,29}, {39,74}, 
    {32,36}, {66,32}, {66,33}, {38,72}, {30,32}, {66,30}, {34,64}, {66,31}, 
    {29,45}, {15,59}, {20,8}, {66,34}, {35,87}, {66,35}, {31,38}, {43,12}, 
    {40,2}, {66,36}, {66,37}, {34,52}, {45,38}, {66,39}, {66,38}, {27,78}, 
    {66,41}, {15,79}, {66,44}, {66,42}, {17,51}, {22,45}, {66,43}, {24,37}, 
    {24,81}, {41,69}, {66,45}, {42,51}, {66,47}, {31,48}, {16,46}, {17,25}, 
    {15,11}, {66,46}, {66,48}, {66,49}, {29,86}, {66,50}, {18,46}, {66,52}, 
    {22,73}, {20,69}, {66,53}, {21,84}, {66,54}, {31,91}, {37,44}, {31,63}, 
    {25,84}, {66,55}, {34,65}, {32,74}, {66,57}, {66,59}, {66,56}, {66,58}, 
    {22,1}, {66,60}, {22,5}, {20,70}, {44,49}, {66,62}, {66,63}, {16,13}, 
    {66,66}, {18,85}, {66,65}, {66,64}, {66,68}, {66,61}, {66,69}, {45,8}, 
    {66,70}, {66,71}, {51,83}, {66,73}, {66,72}, {66,74}, {66,75}, {45,20}, 
    {66,76}, {79,78}, {29,46}, {66,77}, {66,78}, {28,54}, {37,23}, {66,79}, 
    {34,7}, {66,80}, {34,27}, {66,81}, {21,4}, {48,30}, {34,60}, {27,18}, 
    {19,39}, {66,82}, {67,1}, {66,85}, {20,71}, {66,84}, {67,3}, {66,83}, 
    {29,47}, {66,87}, {66,88}, {36,10}, {66,89}, {18,61}, {30,57}, {40,67}, 
    {66,91}, {33,71}, {66,86}, {66,90}, {66,92}, {25,90}, {67,5}, {40,13}, 
    {39,5}, {36,88}, {21,57}, {67,4}, {67,2}, {39,20}, {66,93}, {34,61}, 
    {36,90}, {36,89}, {25,85}, {67,23}, {67,7}, {67,9}, {67,12}, {67,13}, 
    {67,10}, {67,11}, {67,8}, {67,6}, {67,0}, {41,46}, {17,52}, {67,20}, 
    {67,17}, {67,22}, {67,21}, {38,82}, {43,6}, {26,26}, {67,15}, {67,24}, 
    {67,19}, {67,18}, {67,14}, {67,16}, {19,40}, {34,28}, {31,92}, {39,1}, 
    {67,29}, {39,3}, {31,64}, {67,26}, {39,46}, {67,30}, {41,50}, {34,58}, 
    {67,25}, {67,27}, {67,28}, {67,31}, {27,35}, {37,37}, {67,36}, {67,35}, 
    {67,32}, {46,21}, {67,41}, {67,45}, {67,42}, {67,38}, {67,39}, {67,44}, 
    {67,33}, {49,52}, {67,40}, {67,34}, {67,43}, {67,49}, {19,41}, {67,46}, 
    {67,47}, {67,48}, {67,51}, {67,50}, {39,85}, {67,52}, {45,91}, {41,76}, 
    {67,57}, {67,54}, {67,53}, {31,49}, {67,56}, {67,58}, {67,55}, {67,62}, 
    {67,59}, {67,60}, {67,37}, {67,61}, {67,63}, {67,64}, {41,37}, {67,65}, 
    {43,65}, {21,45}, {22,8}, {67,66}, {41,19}, {30,71}, {43,15}, {67,67}, 
    {45,18}, {38,83}, {32,37}, {38,19}, {28,44}, {15,31}, {67,72}, {67,70}, 
    {67,68}, {19,0}, {29,48}, {67,73}, {67,71}, {67,69}, {67,77}, {67,76}, 
    {67,75}, {67,74}, {67,78}, {67,79}, {31,25}, {67,80}, {67,82}, {67,81}, 
    {23,49}, {32,23}, {67,84}, {36,91}, {67,83}, {67,85}, {41,20}, {32,75}, 
    {24,38}, {67,86}, {45,39}, {67,88}, {67,89}, {67,90}, {67,91}, {26,68}, 
    {67,92}, {22,46}, {20,73}, {20,9}, {68,0}, {43,82}, {24,39}, {67,93}, 
    {68,3}, {43,69}, {38,27}, {40,18}, {28,66}, {68,2}, {27,50}, {24,40}, 
    {26,69}, {20,72}, {41,21}, {68,1}, {32,38}, {42,33}, {25,86}, {26,70}, 
    {35,60}, {68,6}, {45,62}, {25,56}, {68,7}, {30,33}, {68,9}, {29,49}, 
    {25,15}, {68,8}, {28,9}, {23,29}, {32,39}, {68,4}, {68,10}, {68,5}, 
    {22,47}, {68,13}, {68,17}, {22,74}, {68,12}, {68,21}, {24,41}, {44,76}, 
    {15,27}, {68,18}, {20,74}, {68,15}, {68,16}, {36,92}, {68,14}, {68,11}, 
    {18,7}, {31,67}, {23,7}, {68,23}, {68,20}, {68,22}, {68,19}, {22,48}, 
    {33,18}, {68,24}, {32,77}, {68,37}, {68,33}, {68,27}, {68,31}, {27,89}, 
    {15,60}, {68,26}, {68,34}, {68,38}, {24,42}, {43,53}, {35,53}, {68,28}, 
    {68,36}, {68,25}, {34,29}, {68,30}, {15,28}, {43,41}, {68,29}, {21,58}, 
    {39,75}, {32,76}, {45,47}, {28,78}, {68,77}, {68,39}, {31,93}, {68,35}, 
    {68,40}, {68,42}, {35,88}, {68,45}, {68,41}, {41,51}, {19,42}, {43,42}, 
    {15,61}, {68,44}, {45,92}, {68,43}, {16,78}, {37,75}, {68,46}, {68,53}, 
    {68,47}, {68,54}, {68,50}, {38,90}, {27,41}, {68,52}, {68,49}, {68,55}, 
    {68,48}, {28,35}, {42,4}, {28,43}, {68,51}, {68,63}, {68,59}, {68,62}, 
    {68,60}, {68,64}, {68,58}, {68,32}, {31,50}, {39,42}, {68,61}, {68,56}, 
    {32,0}, {22,49}, {28,10}, {30,4}, {32,21}, {68,67}, {68,69}, {68,70}, 
    {68,66}, {68,68}, {68,57}, {68,65}, {68,73}, {68,72}, {42,89}, {22,10}, 
    {68,71}, {68,75}, {68,74}, {68,78}, {68,80}, {26,27}, {68,76}, {68,81}, 
    {68,82}, {68,83}, {68,89}, {36,26}, {68,85}, {68,84}, {68,86}, {68,87}, 
    {68,88}, {68,90}, {68,91}, {19,43}, {68,92}, {68,93}, {69,0}, {69,1}, 
    {69,2}, {69,3}, {69,4}, {69,5}, {69,7}, {69,6}, {69,8}, {69,9}, {69,10}, 
    {69,13}, {69,11}, {69,12}, {25,64}, {22,50}, {34,53}, {39,18}, {28,79}, 
    {38,44}, {39,76}, {69,14}, {55,76}, {69,15}, {69,17}, {44,68}, {69,16}, 
    {69,19}, {69,18}, {44,50}, {69,20}, {39,93}, {69,21}, {69,24}, {69,23}, 
    {69,22}, {69,25}, {22,17}, {32,1}, {20,32}, {69,29}, {69,26}, {69,27}, 
    {69,30}, {69,31}, {69,28}, {16,8}, {17,6}, {69,33}, {69,34}, {69,35}, 
    {44,65}, {28,11}, {69,37}, {69,36}, {30,72}, {69,38}, {69,39}, {69,40}, 
    {19,68}, {19,44}, {69,41}, {69,42}, {42,60}, {44,66}, {44,51}, {46,22}, 
    {24,44}, {69,45}, {27,51}, {69,44}, {69,46}, {27,8}, {33,48}, {69,47}, 
    {24,43}, {43,54}, {69,48}, {69,49}, {69,50}, {69,51}, {69,52}, {27,9}, 
    {43,76}, {69,54}, {34,30}, {69,53}, {69,56}, {69,55}, {69,57}, {31,26}, 
    {69,58}, {69,59}, {41,24}, {69,60}, {32,78}, {69,61}, {69,62}, {45,93}, 
    {69,65}, {69,64}, {69,63}, {35,15}, {69,66}, {30,5}, {69,67}, {69,68}, 
    {46,23}, {69,69}, {69,70}, {69,72}, {69,71}, {39,4}, {37,88}, {46,29}, 
    {39,8}, {69,74}, {29,50}, {40,9}, {69,75}, {69,73}, {19,45}, {23,51}, 
    {26,71}, {39,77}, {23,9}, {42,34}, {69,78}, {69,76}, {24,45}, {24,46}, 
    {15,72}, {25,71}, {38,56}, {15,62}, {69,83}, {34,31}, {38,55}, {33,58}, 
    {69,85}, {69,81}, {69,84}, {69,79}, {69,82}, {42,5}, {23,52}, {15,92}, 
    {69,80}, {69,87}, {69,88}, {37,24}, {21,26}, {70,5}, {38,28}, {26,72}, 
    {21,27}, {31,39}, {46,37}, {43,13}, {69,86}, {31,51}, {20,50}, {69,89}, 
    {69,91}, {69,90}, {69,92}, {34,5}, {38,29}, {35,16}, {70,2}, {70,1}, 
    {69,93}, {30,52}, {40,68}, {70,4}, {70,3}, {24,47}, {46,50}, {70,20}, 
    {70,8}, {70,9}, {27,79}, {70,7}, {24,87}, {70,6}, {70,10}, {35,17}, 
    {41,1}, {32,2}, {33,59}, {70,14}, {70,15}, {70,11}, {70,12}, {70,13}, 
    {24,48}, {70,21}, {70,17}, {40,69}, {42,75}, {40,7}, {70,16}, {70,19}, 
    {70,18}, {42,35}, {70,22}, {70,23}, {32,22}, {70,24}, {70,26}, {70,30}, 
    {70,27}, {70,25}, {38,30}, {70,28}, {70,29}, {17,17}, {70,36}, {70,31}, 
    {70,32}, {70,33}, {33,0}, {70,35}, {70,34}, {70,37}, {70,38}, {70,39}, 
    {30,34}, {17,72}, {70,40}, {45,54}, {27,10}, {28,12}, {26,73}, {34,54}, 
    {70,41}, {70,42}, {16,16}, {70,43}, {70,44}, {70,45}, {70,46}, {70,47}, 
    {21,28}, {57,9}, {70,48}, {31,68}, {70,49}, {27,42}, {70,50}, {47,15}, 
    {70,51}, {41,61}, {19,59}, {32,3}, {28,55}, {40,80}, {28,13}, {70,52}, 
    {24,49}, {70,53}, {39,43}, {70,67}, {70,55}, {33,40}, {38,84}, {23,30}, 
    {70,54}, {32,4}, {70,56}, {35,89}, {70,58}, {70,57}, {70,60}, {70,59}, 
    {70,61}, {70,63}, {70,62}, {19,46}, {70,64}, {70,65}, {70,66}, {25,16}, 
    {45,40}, {70,68}, {30,6}, {16,79}, {70,69}, {70,70}, {70,71}, {15,81}, 
    {70,72}, {70,73}, {40,70}, {27,38}, {70,75}, {18,8}, {15,17}, {70,74}, 
    {70,77}, {38,45}, {30,35}, {17,53}, {42,6}, {22,60}, {21,59}, {70,76}, 
    {17,73}, {19,2}, {16,80}, {70,81}, {45,73}, {33,60}, {40,35}, {70,93}, 
    {17,54}, {70,91}, {70,89}, {70,80}, {70,78}, {70,79}, {27,66}, {21,75}, 
    {34,86}, {37,48}, {16,48}, {70,83}, {70,82}, {70,88}, {70,84}, {70,87}, 
    {43,47}, {70,86}, {17,55}, {18,92}, {70,90}, {70,92}, {22,51}, {71,2}, 
    {71,11}, {71,12}, {15,10}, {71,19}, {15,80}, {71,10}, {71,9}, {71,4}, 
    {71,3}, {71,1}, {71,0}, {34,66}, {33,90}, {71,6}, {71,5}, {71,8}, {32,79}, 
    {22,52}, {16,32}, {71,7}, {24,50}, {32,80}, {71,25}, {71,26}, {17,56}, 
    {17,13}, {71,23}, {71,13}, {71,21}, {71,28}, {71,22}, {71,20}, {70,85}, 
    {71,18}, {71,14}, {19,47}, {71,16}, {71,27}, {71,17}, {71,29}, {71,15}, 
    {38,91}, {44,72}, {71,24}, {71,46}, {71,38}, {30,90}, {20,37}, {21,60}, 
    {71,33}, {17,58}, {29,51}, {71,36}, {25,57}, {36,48}, {71,41}, {41,77}, 
    {71,32}, {17,57}, {23,53}, {40,8}, {71,42}, {71,30}, {71,39}, {71,49}, 
    {71,34}, {71,35}, {37,25}, {71,40}, {71,37}, {42,7}, {71,43}, {15,63}, 
    {71,31}, {71,45}, {71,44}, {38,74}, {71,51}, {71,62}, {18,93}, {71,65}, 
    {71,47}, {71,52}, {44,77}, {71,61}, {44,52}, {45,9}, {34,87}, {18,74}, 
    {40,81}, {71,67}, {37,0}, {15,16}, {71,60}, {71,56}, {32,81}, {71,50}, 
    {71,58}, {71,63}, {38,11}, {15,9}, {71,55}, {71,64}, {40,87}, {71,59}, 
    {71,54}, {29,52}, {28,14}, {27,11}, {43,55}, {40,38}, {71,70}, {71,79}, 
    {71,57}, {18,86}, {29,87}, {71,68}, {71,73}, {32,82}, {71,69}, {71,76}, 
    {34,62}, {71,77}, {44,53}, {71,66}, {18,23}, {71,72}, {71,75}, {43,11}, 
    {71,78}, {71,71}, {71,74}, {42,8}, {46,0}, {71,82}, {71,89}, {71,81}, 
    {27,34}, {71,48}, {41,45}, {43,1}, {71,88}, {71,87}, {71,83}, {71,84}, 
    {16,21}, {71,86}, {71,80}, {35,52}, {71,85}, {15,93}, {33,1}, {41,34}, 
    {71,90}, {72,0}, {39,56}, {71,93}, {29,53}, {27,40}, {72,2}, {21,29}, 
    {72,3}, {40,88}, {71,92}, {71,53}, {71,91}, {46,46}, {37,1}, {40,82}, 
    {72,10}, {72,16}, {72,17}, {72,4}, {38,85}, {72,14}, {72,6}, {72,8}, 
    {72,18}, {72,7}, {72,11}, {16,81}, {37,68}, {72,12}, {72,15}, {72,5}, 
    {32,5}, {72,9}, {26,6}, {30,36}, {22,15}, {43,83}, {43,88}, {28,81}, 
    {72,22}, {72,20}, {46,45}, {72,19}, {44,84}, {72,21}, {72,23}, {72,24}, 
    {72,27}, {72,25}, {37,2}, {72,26}, {39,44}, {72,13}, {28,82}, {72,28}, 
    {72,33}, {32,83}, {72,32}, {72,1}, {72,34}, {32,40}, {72,29}, {72,31}, 
    {72,30}, {60,16}, {60,1}, {72,36}, {72,35}, {44,85}, {65,27}, {72,37}, 
    {72,38}, {72,39}, {23,54}, {20,51}, {72,41}, {48,60}, {20,84}, {45,25}, 
    {21,82}, {72,42}, {72,43}, {34,77}, {72,44}, {37,89}, {15,25}, {17,66}, 
    {72,49}, {72,50}, {72,45}, {26,28}, {72,46}, {38,33}, {72,47}, {72,48}, 
    {72,58}, {72,52}, {72,55}, {72,51}, {72,53}, {72,54}, {27,55}, {72,56}, 
    {34,32}, {22,53}, {18,33}, {72,59}, {18,30}, {72,64}, {72,60}, {72,63}, 
    {39,25}, {72,61}, {72,62}, {40,39}, {39,57}, {72,65}, {33,92}, {72,75}, 
    {72,71}, {17,74}, {72,69}, {42,9}, {72,70}, {72,67}, {72,68}, {72,73}, 
    {72,76}, {72,74}, {72,72}, {72,66}, {34,55}, {72,83}, {43,9}, {72,81}, 
    {72,82}, {72,77}, {72,79}, {72,80}, {72,78}, {31,69}, {46,24}, {72,87}, 
    {72,88}, {73,0}, {30,9}, {72,90}, {72,93}, {72,85}, {72,84}, {73,1}, 
    {17,59}, {72,91}, {73,2}, {72,92}, {72,89}, {35,18}, {72,86}, {38,71}, 
    {73,6}, {44,26}, {73,5}, {73,4}, {73,13}, {73,7}, {73,15}, {44,69}, 
    {73,18}, {73,9}, {73,10}, {73,14}, {73,17}, {73,16}, {73,8}, {73,11}, 
    {73,28}, {73,21}, {73,19}, {73,20}, {73,25}, {73,26}, {18,9}, {20,33}, 
    {73,24}, {73,3}, {73,23}, {73,27}, {73,22}, {73,29}, {73,31}, {73,30}, 
    {73,33}, {73,32}, {72,57}, {73,37}, {73,34}, {73,35}, {73,36}, {73,38}, 
    {22,75}, {73,40}, {73,39}, {28,15}, {24,51}, {61,6}, {73,41}, {28,48}, 
    {18,24}, {73,42}, {16,49}, {29,54}, {73,43}, {24,52}, {73,44}, {15,64}, 
    {40,28}, {73,45}, {30,73}, {73,52}, {73,49}, {34,78}, {73,50}, {73,47}, 
    {21,61}, {73,46}, {73,53}, {22,21}, {33,61}, {73,59}, {73,55}, {33,20}, 
    {73,54}, {73,57}, {73,48}, {73,58}, {73,60}, {39,78}, {73,56}, {73,61}, 
    {73,63}, {23,50}, {73,51}, {15,32}, {73,62}, {25,58}, {45,85}, {73,64}, 
    {73,65}, {32,84}, {45,1}, {73,66}, {44,20}, {73,67}, {73,68}, {41,67}, 
    {73,69}, {25,31}, {45,2}, {73,74}, {73,75}, {29,55}, {73,73}, {44,70}, 
    {73,70}, {73,72}, {31,28}, {30,93}, {73,71}, {73,76}, {41,2}, {73,78}, 
    {73,77}, {18,75}, {42,10}, {73,79}, {73,91}, {73,81}, {73,82}, {73,83}, 
    {73,84}, {73,88}, {73,89}, {73,87}, {73,85}, {73,80}, {73,86}, {73,90}, 
    {79,22}, {17,7}, {73,93}, {21,62}, {73,92}, {74,1}, {74,0}, {74,3}, 
    {74,2}, {74,4}, {28,16}, {74,5}, {74,6}, {74,7}, {31,29}, {44,54}, 
    {74,8}, {41,3}, {38,37}, {74,9}, {74,10}, {23,10}, {20,11}, {74,11}, 
    {26,74}, {38,32}, {74,12}, {18,47}, {74,13}, {74,15}, {44,86}, {74,14}, 
    {30,37}, {74,16}, {74,17}, {74,18}, {19,48}, {74,19}, {74,20}, {74,21}, 
    {74,22}, {18,48}, {74,23}, {74,24}, {74,25}, {17,81}, {30,7}, {74,26}, 
    {74,27}, {74,28}, {23,31}, {35,90}, {74,29}, {22,54}, {30,53}, {74,32}, 
    {37,3}, {74,31}, {22,16}, {74,30}, {33,86}, {20,12}, {74,33}, {74,34}, 
    {29,56}, {22,76}, {74,35}, {42,11}, {31,62}, {20,85}, {43,84}, {32,41}, 
    {74,36}, {30,38}, {34,79}, {29,57}, {74,37}, {74,40}, {74,41}, {25,29}, 
    {33,33}, {74,39}, {29,58}, {40,29}, {74,38}, {26,75}, {16,50}, {74,45}, 
    {22,55}, {26,77}, {26,76}, {46,44}, {74,44}, {74,43}, {32,6}, {20,44}, 
    {46,34}, {18,25}, {29,59}, {74,42}, {74,47}, {74,48}, {74,46}, {23,55}, 
    {44,31}, {26,78}, {38,6}, {74,51}, {31,31}, {34,33}, {44,21}, {74,54}, 
    {23,75}, {31,30}, {74,50}, {74,55}, {23,76}, {74,52}, {74,53}, {74,49}, 
    {31,65}, {37,40}, {34,14}, {17,60}, {39,79}, {20,34}, {35,19}, {74,58}, 
    {74,56}, {34,43}, {31,32}, {19,49}, {74,57}, {30,58}, {45,41}, {46,31}, 
    {74,59}, {74,70}, {35,20}, {74,69}, {74,66}, {74,74}, {74,67}, {74,63}, 
    {35,91}, {74,62}, {74,60}, {44,0}, {26,79}, {74,64}, {74,61}, {74,68}, 
    {28,83}, {23,32}, {33,89}, {42,36}, {16,57}, {15,65}, {37,4}, {74,72}, 
    {74,71}, {37,69}, {74,76}, {74,65}, {74,75}, {74,77}, {23,11}, {74,73}, 
    {24,53}, {27,52}, {74,78}, {44,55}, {74,81}, {74,84}, {74,82}, {40,20}, 
    {74,79}, {21,63}, {74,83}, {74,85}, {74,89}, {74,86}, {74,88}, {74,87}, 
    {74,90}, {27,16}, {74,92}, {74,91}, {40,71}, {75,0}, {22,56}, {74,93}, 
    {75,1}, {75,2}, {20,35}, {69,32}, {29,88}, {75,3}, {23,77}, {75,4}, 
    {75,5}, {26,29}, {57,45}, {75,6}, {75,7}, {28,17}, {75,8}, {75,9}, 
    {75,10}, {75,11}, {75,12}, {34,10}, {75,13}, {75,15}, {75,14}, {37,5}, 
    {75,16}, {42,12}, {75,17}, {75,18}, {75,19}, {75,20}, {37,57}, {29,60}, 
    {75,21}, {24,74}, {47,13}, {75,22}, {75,23}, {40,30}, {75,24}, {75,32}, 
    {75,25}, {75,27}, {75,26}, {75,28}, {42,37}, {75,29}, {75,30}, {75,31}, 
    {75,33}, {18,12}, {35,70}, {40,72}, {25,65}, {24,54}, {40,46}, {17,62}, 
    {39,45}, {75,36}, {19,50}, {31,52}, {75,35}, {75,40}, {34,88}, {43,66}, 
    {75,38}, {75,39}, {20,13}, {75,41}, {38,66}, {33,62}, {39,80}, {36,28}, 
    {75,37}, {42,38}, {17,75}, {75,43}, {46,7}, {35,33}, {46,36}, {26,80}, 
    {75,42}, {33,16}, {75,59}, {32,7}, {37,87}, {40,47}, {75,46}, {26,30}, 
    {26,81}, {29,61}, {38,68}, {23,12}, {75,45}, {75,44}, {40,73}, {27,32}, 
    {36,49}, {75,48}, {75,49}, {24,55}, {75,47}, {75,50}, {75,51}, {75,53}, 
    {33,2}, {75,52}, {19,69}, {75,55}, {75,54}, {75,56}, {75,58}, {75,60}, 
    {75,61}, {31,53}, {27,46}, {75,62}, {18,49}, {75,63}, {32,85}, {75,64}, 
    {75,65}, {40,74}, {20,14}, {75,66}, {35,21}, {16,58}, {75,67}, {27,80}, 
    {30,85}, {33,12}, {75,70}, {75,69}, {75,68}, {75,76}, {75,74}, {75,71}, 
    {75,73}, {75,72}, {75,75}, {20,86}, {75,79}, {31,54}, {75,80}, {23,56}, 
    {75,77}, {75,78}, {46,8}, {35,22}, {32,8}, {75,81}, {75,84}, {75,82}, 
    {75,83}, {44,56}, {37,6}, {75,87}, {75,85}, {75,86}, {75,88}, {76,8}, 
    {75,91}, {75,92}, {75,90}, {75,89}, {35,92}, {76,0}, {76,4}, {76,1}, 
    {75,93}, {76,2}, {76,3}, {76,10}, {76,5}, {31,55}, {76,7}, {76,9}, 
    {76,6}, {76,12}, {28,18}, {76,11}, {76,13}, {76,14}, {76,17}, {76,16}, 
    {76,15}, {76,19}, {76,18}, {43,85}, {76,21}, {76,20}, {76,22}, {76,23}, 
    {76,25}, {76,24}, {30,39}, {76,26}, {21,76}, {76,27}, {76,29}, {76,30}, 
    {76,31}, {76,28}, {76,32}, {27,53}, {76,33}, {20,15}, {22,18}, {23,13}, 
    {76,34}, {37,79}, {36,29}, {76,35}, {76,38}, {27,19}, {76,37}, {76,36}, 
    {22,57}, {76,39}, {18,50}, {76,41}, {25,59}, {76,40}, {76,49}, {76,43}, 
    {76,45}, {41,68}, {76,42}, {76,44}, {76,48}, {76,46}, {20,16}, {76,47}, 
    {76,50}, {38,57}, {45,55}, {28,19}, {76,51}, {44,1}, {76,53}, {76,52}, 
    {76,56}, {44,32}, {76,55}, {18,76}, {76,54}, {76,59}, {76,58}, {76,57}, 
    {36,17}, {76,60}, {76,61}, {76,62}, {24,75}, {22,4}, {76,63}, {76,64}, 
    {76,65}, {30,40}, {76,66}, {27,12}, {76,67}, {76,68}, {49,0}, {48,93}, 
    {76,69}, {68,79}, {76,70}, {34,3}, {30,10}, {38,31}, {76,71}, {41,52}, 
    {35,51}, {24,93}, {34,8}, {16,9}, {42,87}, {30,54}, {22,61}, {21,64}, 
    {41,53}, {76,72}, {76,74}, {76,73}, {17,63}, {37,85}, {76,75}, {38,86}, 
    {36,18}, {76,76}, {28,49}, {76,78}, {43,33}, {76,93}, {76,80}, {76,81}, 
    {35,40}, {33,63}, {32,86}, {37,7}, {76,79}, {20,52}, {76,88}, {76,85}, 
    {77,4}, {37,8}, {34,63}, {76,82}, {35,93}, {36,50}, {76,83}, {76,87}, 
    {30,63}, {38,70}, {35,43}, {31,33}, {76,86}, {33,13}, {33,3}, {76,84}, 
    {15,8}, {46,1}, {76,89}, {33,64}, {28,20}, {30,41}, {76,91}, {76,90}, 
    {15,78}, {76,92}, {40,14}, {77,6}, {37,58}, {30,74}, {34,56}, {21,87}, 
    {77,5}, {44,22}, {16,30}, {41,54}, {17,64}, {77,0}, {77,1}, {77,2}, 
    {77,3}, {37,26}, {34,2}, {15,66}, {77,7}, {77,8}, {83,2}, {33,28}, 
    {77,9}, {16,82}, {32,43}, {23,14}, {44,57}, {77,10}, {36,11}, {32,87}, 
    {27,54}, {77,11}, {77,14}, {28,68}, {77,12}, {32,10}, {32,9}, {15,67}, 
    {45,42}, {77,16}, {39,81}, {77,18}, {77,17}, {77,15}, {66,67}, {19,51}, 
    {76,77}, {77,20}, {77,19}, {77,21}, {44,23}, {37,64}, {42,13}, {77,22}, 
    {27,56}, {77,23}, {77,24}, {77,25}, {36,0}, {15,73}, {24,56}, {46,25}, 
    {77,29}, {22,19}, {77,26}, {77,27}, {40,83}, {18,51}, {44,24}, {21,30}, 
    {36,51}, {77,30}, {77,31}, {77,32}, {36,1}, {77,34}, {77,33}, {37,50}, 
    {77,35}, {28,21}, {27,63}, {38,58}, {34,80}, {27,81}, {30,75}, {77,36}, 
    {77,37}, {30,60}, {77,38}, {77,39}, {77,40}, {44,78}, {28,22}, {77,42}, 
    {77,41}, {24,57}, {24,82}, {26,31}, {77,45}, {28,69}, {77,44}, {77,43}, 
    {33,72}, {23,78}, {31,34}, {39,15}, {28,24}, {77,46}, {29,62}, {77,49}, 
    {77,47}, {77,48}, {77,51}, {77,50}, {29,89}, {77,52}, {77,53}, {77,54}, 
    {39,47}, {25,50}, {27,64}, {77,55}, {77,56}, {45,3}, {28,36}, {43,77}, 
    {45,43}, {77,57}, {21,65}, {77,58}, {36,2}, {77,61}, {18,87}, {30,42}, 
    {77,59}, {77,60}, {35,63}, {42,52}, {21,91}, {77,63}, {77,64}, {77,62}, 
    {77,66}, {37,62}, {18,34}, {77,70}, {77,67}, {77,69}, {77,65}, {78,46}, 
    {77,68}, {45,74}, {23,57}, {77,78}, {36,19}, {77,73}, {77,76}, {77,74}, 
    {77,79}, {77,80}, {77,72}, {77,85}, {16,83}, {77,71}, {39,12}, {77,75}, 
    {29,63}, {24,58}, {42,39}, {21,67}, {28,37}, {37,27}, {32,12}, {77,83}, 
    {77,77}, {77,82}, {43,34}, {35,23}, {77,84}, {77,81}, {32,11}, {77,88}, 
    {77,87}, {77,86}, {42,14}, {28,90}, {77,89}, {41,62}, {16,51}, {40,37}, 
    {34,81}, {20,87}, {77,91}, {24,60}, {26,11}, {77,90}, {30,76}, {30,77}, 
    {78,0}, {78,2}, {29,90}, {78,1}, {78,3}, {21,50}, {40,36}, {27,65}, 
    {46,2}, {77,93}, {25,87}, {46,30}, {78,5}, {78,4}, {78,6}, {77,92}, 
    {37,72}, {36,52}, {35,54}, {78,11}, {34,34}, {78,7}, {78,8}, {22,12}, 
    {78,10}, {23,15}, {78,9}, {29,64}, {18,88}, {78,15}, {25,30}, {32,88}, 
    {35,41}, {18,26}, {78,13}, {78,14}, {35,34}, {78,12}, {78,16}, {78,22}, 
    {78,25}, {78,24}, {36,12}, {78,17}, {78,18}, {78,21}, {78,23}, {21,31}, 
    {78,26}, {78,20}, {78,19}, {78,30}, {78,31}, {78,32}, {78,29}, {78,28}, 
    {29,65}, {37,9}, {78,27}, {78,36}, {78,34}, {78,35}, {78,33}, {33,87}, 
    {78,37}, {78,38}, {78,40}, {19,52}, {78,39}, {43,89}, {78,51}, {78,41}, 
    {78,44}, {78,42}, {78,43}, {78,45}, {78,47}, {78,48}, {78,49}, {78,52}, 
    {78,50}, {78,53}, {78,55}, {78,54}, {35,24}, {43,70}, {78,56}, {32,13}, 
    {78,57}, {41,35}, {78,58}, {18,10}, {16,27}, {19,54}, {19,53}, {78,59}, 
    {78,60}, {78,61}, {78,62}, {78,63}, {19,55}, {18,52}, {24,61}, {39,21}, 
    {78,65}, {78,64}, {78,66}, {16,59}, {78,69}, {78,68}, {78,67}, {78,70}, 
    {78,73}, {15,38}, {78,71}, {78,75}, {78,74}, {78,77}, {78,76}, {78,78}, 
    {37,13}, {78,79}, {78,80}, {78,82}, {78,81}, {40,75}, {78,83}, {78,84}, 
    {25,68}, {78,85}, {78,86}, {42,40}, {32,42}, {15,3}, {33,42}, {78,87}, 
    {40,76}, {78,90}, {78,88}, {24,62}, {78,89}, {23,33}, {41,36}, {78,92}, 
    {79,0}, {78,93}, {79,1}, {16,0}, {30,55}, {28,91}, {19,56}, {79,2}, 
    {38,69}, {79,4}, {16,1}, {79,3}, {35,35}, {45,44}, {37,10}, {78,91}, 
    {45,5}, {23,16}, {44,58}, {21,88}, {45,19}, {22,7}, {33,65}, {70,0}, 
    {79,5}, {18,11}, {30,78}, {18,53}, {79,7}, {79,8}, {79,6}, {22,67}, 
    {25,60}, {29,66}, {16,2}, {45,56}, {79,10}, {77,13}, {79,9}, {79,13}, 
    {79,11}, {79,12}, {79,14}, {79,15}, {45,75}, {79,16}, {79,17}, {31,40}, 
    {39,26}, {30,92}, {19,70}, {44,25}, {17,76}, {28,23}, {23,58}, {79,20}, 
    {79,19}, {26,82}, {79,21}, {79,18}, {26,7}, {79,25}, {73,12}, {49,53}, 
    {30,86}, {79,23}, {45,4}, {37,80}, {16,10}, {31,66}, {27,21}, {41,22}, 
    {16,31}, {45,76}, {44,74}, {79,26}, {36,36}, {27,90}, {79,27}, {79,28}, 
    {30,43}, {79,29}, {45,77}, {79,24}, {79,31}, {79,33}, {79,32}, {79,30}, 
    {79,34}, {79,35}, {32,89}, {17,65}, {79,36}, {43,23}, {79,37}, {79,38}, 
    {46,9}, {58,16}, {79,39}, {79,40}, {79,41}, {79,45}, {79,42}, {79,43}, 
    {79,44}, {79,46}, {31,35}, {43,86}, {31,36}, {79,47}, {39,82}, {79,48}, 
    {82,50}, {43,43}, {79,49}, {79,50}, {79,51}, {18,54}, {79,53}, {30,56}, 
    {79,54}, {22,3}, {79,55}, {79,59}, {79,57}, {79,58}, {18,82}, {79,56}, 
    {79,60}, {79,61}, {15,39}, {79,62}, {79,63}, {29,67}, {79,64}, {20,38}, 
    {79,67}, {79,66}, {79,65}, {74,80}, {41,59}, {79,68}, {79,69}, {79,70}, 
    {79,71}, {79,72}, {79,73}, {19,57}, {79,74}, {79,75}, {38,2}, {79,77}, 
    {17,26}, {79,80}, {79,79}, {16,3}, {21,32}, {41,38}, {35,25}, {25,1}, 
    {24,63}, {28,70}, {30,59}, {79,82}, {79,81}, {44,33}, {19,71}, {39,49}, 
    {37,59}, {30,91}, {45,45}, {22,58}, {79,85}, {79,84}, {42,42}, {37,11}, 
    {16,47}, {79,86}, {79,83}, {40,48}, {44,73}, {79,87}, {79,88}, {79,90}, 
    {33,73}, {18,58}, {18,59}, {79,89}, {19,72}, {23,17}, {19,73}, {36,30}, 
    {45,63}, {23,59}, {79,91}, {79,92}, {79,93}, {80,0}, {80,2}, {80,1}, 
    {40,86}, {80,3}, {80,4}, {80,5}, {80,6}, {80,8}, {80,7}, {80,9}, {39,83}, 
    {69,43}, {30,8}, {20,17}, {80,10}, {80,11}, {49,11}, {60,26}, {39,50}, 
    {15,90}, {15,26}, {26,83}, {42,15}, {29,93}, {80,12}, {43,62}, {80,13}, 
    {44,59}, {16,33}, {26,32}, {80,14}, {17,77}, {80,15}, {80,16}, {80,18}, 
    {80,19}, {80,21}, {80,17}, {80,20}, {19,58}, {80,22}, {80,23}, {80,24}, 
    {80,25}, {80,26}, {80,28}, {80,27}, {80,30}, {80,33}, {80,29}, {80,31}, 
    {80,32}, {80,34}, {21,33}, {27,82}, {80,35}, {80,36}, {24,64}, {80,37}, 
    {18,29}, {38,46}, {80,38}, {80,39}, {34,57}, {37,74}, {80,40}, {38,92}, 
    {33,43}, {16,55}, {21,77}, {21,78}, {34,82}, {80,45}, {21,79}, {17,78}, 
    {80,44}, {80,42}, {80,43}, {80,41}, {80,55}, {80,46}, {80,47}, {80,48}, 
    {80,49}, {80,51}, {80,50}, {28,56}, {80,52}, {80,54}, {20,18}, {80,53}, 
    {32,90}, {23,18}, {80,56}, {33,44}, {80,57}, {37,12}, {80,58}, {80,63}, 
    {80,61}, {80,60}, {80,62}, {80,59}, {80,65}, {80,64}, {80,67}, {21,34}, 
    {80,66}, {80,68}, {80,69}, {80,71}, {80,70}, {80,72}, {80,74}, {80,73}, 
    {24,91}, {80,75}, {80,76}, {18,27}, {80,77}, {80,78}, {30,80}, {80,79}, 
    {80,80}, {80,81}, {80,82}, {24,65}, {80,83}, {80,84}, {80,85}, {80,86}, 
    {80,87}, {39,16}, {80,89}, {40,5}, {80,90}, {80,88}, {80,92}, {80,91}, 
    {80,93}, {81,0}, {81,1}, {81,2}, {81,3}, {81,4}, {81,5}, {81,6}, {81,7}, 
    {81,8}, {81,9}, {81,10}, {81,11}, {81,12}, {81,13}, {60,20}, {81,14}, 
    {67,87}, {20,19}, {18,0}, {25,17}, {81,16}, {81,15}, {43,4}, {81,18}, 
    {81,19}, {81,17}, {81,20}, {42,65}, {81,21}, {20,90}, {46,4}, {81,22}, 
    {81,24}, {15,29}, {81,25}, {41,10}, {81,23}, {81,26}, {81,27}, {81,28}, 
    {81,29}, {81,30}, {42,77}, {26,12}, {25,89}, {32,14}, {81,31}, {81,34}, 
    {81,32}, {81,35}, {23,80}, {81,33}, {81,36}, {81,37}, {81,38}, {81,42}, 
    {26,9}, {33,67}, {81,43}, {81,40}, {81,39}, {81,41}, {22,62}, {81,47}, 
    {81,46}, {81,45}, {15,18}, {81,57}, {81,53}, {81,54}, {81,50}, {81,56}, 
    {81,52}, {18,65}, {46,43}, {81,55}, {81,51}, {81,49}, {81,48}, {81,59}, 
    {81,62}, {81,61}, {81,60}, {40,40}, {81,58}, {15,82}, {81,63}, {81,65}, 
    {18,78}, {81,44}, {16,22}, {81,67}, {81,66}, {81,64}, {34,12}, {42,79}, 
    {45,57}, {81,68}, {81,69}, {81,70}, {81,71}, {81,72}, {35,26}, {81,73}, 
    {39,22}, {81,78}, {81,74}, {81,75}, {42,16}, {43,35}, {37,47}, {81,79}, 
    {81,80}, {37,29}, {81,77}, {81,76}, {17,9}, {81,88}, {81,87}, {16,84}, 
    {81,85}, {81,84}, {81,82}, {18,90}, {81,81}, {27,17}, {17,8}, {24,66}, 
    {81,91}, {81,90}, {81,89}, {81,86}, {81,92}, {81,93}, {82,4}, {82,3}, 
    {82,5}, {16,12}, {82,0}, {82,1}, {24,83}, {43,24}, {82,2}, {42,17}, 
    {82,10}, {82,6}, {82,11}, {82,8}, {82,7}, {22,59}, {82,12}, {82,13}, 
    {82,14}, {82,9}, {81,83}, {82,15}, {35,64}, {82,19}, {82,20}, {82,18}, 
    {82,17}, {82,23}, {82,16}, {82,21}, {82,22}, {82,25}, {82,24}, {82,27}, 
    {82,28}, {82,29}, {46,40}, {82,26}, {33,74}, {25,76}, {82,30}, {82,31}, 
    {82,32}, {82,33}, {82,34}, {23,19}, {82,35}, {82,36}, {27,14}, {82,37}, 
    {82,38}, {82,39}, {82,40}, {82,43}, {82,41}, {46,27}, {82,42}, {45,78}, 
    {82,44}, {45,58}, {82,45}, {38,93}, {82,46}, {82,48}, {82,49}, {82,47}, 
    {24,76}, {43,44}, {42,66}, {53,86}, {60,63}, {42,90}, {17,10}, {82,51}, 
    {20,47}, {82,52}, {82,53}, {82,54}, {24,84}, {82,55}, {63,51}, {43,58}, 
    {33,66}, {82,56}, {82,58}, {82,57}, {82,59}, {82,60}, {82,61}, {82,62}, 
    {82,63}, {82,64}, {82,65}, {82,66}, {82,67}, {82,68}, {82,69}, {82,70}, 
    {82,71}, {36,3}, {23,60}, {82,73}, {32,44}, {82,74}, {82,75}, {40,0}, 
    {82,76}, {82,77}, {66,22}, {75,57}, {79,76}, {82,78}, {82,79}, {82,81}, 
    {82,82}, {82,83}, {45,79}, {82,80}, {82,84}, {82,85}, {82,87}, {82,86}, 
    {82,89}, {82,90}, {82,88}, {45,21}, {82,91}, {82,92}, {66,51}, {82,93}, 
    {0,9}, {0,83}, {0,79}, {0,82}, {0,84}, {0,41}, {0,42}, {0,85}, {0,59}, 
    {0,3}, {0,4}, {0,30}, {2,15}, {2,16}, {2,17}, {2,18}, {2,19}, {2,20}, 
    {2,21}, {2,22}, {2,23}, {2,24}, {0,6}, {0,7}, {0,66}, {0,64}, {0,67}, 
    {0,8}, {0,86}, {2,32}, {2,33}, {2,34}, {2,35}, {2,36}, {2,37}, {2,38}, 
    {2,39}, {2,40}, {2,41}, {2,42}, {2,43}, {2,44}, {2,45}, {2,46}, {2,47}, 
    {2,48}, {2,49}, {2,50}, {2,51}, {2,52}, {2,53}, {2,54}, {2,55}, {2,56}, 
    {2,57}, {0,45}, {0,46}, {0,15}, {0,17}, {0,13}, {2,64}, {2,65}, {2,66}, 
    {2,67}, {2,68}, {2,69}, {2,70}, {2,71}, {2,72}, {2,73}, {2,74}, {2,75}, 
    {2,76}, {2,77}, {2,78}, {2,79}, {2,80}, {2,81}, {2,82}, {2,83}, {2,84}, 
    {2,85}, {2,86}, {2,87}, {2,88}, {2,89}, {0,47}, {0,34}, {0,48}, {0,16}, 
    {0,78}
};

/* This returns ERROR if the code point doesn't exist. */
long int jisx0208_to_unicode(int r, int c)
{
    assert(r >= 0 && r < 94);
    assert(c >= 0 && c < 94);
    return jisx0208_forward[r][c];
}

/* This one returns true on success, false if the code point doesn't exist. */
bool unicode_to_jisx0208(long int unicode, int *r, int *c)
{
    int rr, cc;
    long int uu;
    int i, j, k;

    i = -1;
    j = lenof(jisx0208_backward);
    while (j - i > 1) {
	k = (i + j) / 2;
	rr = jisx0208_backward[k].r;
	cc = jisx0208_backward[k].c;
	uu = jisx0208_forward[rr][cc];
	if (unicode > uu)
	    i = k;
	else if (unicode < uu)
	    j = k;
	else {
	    *r = rr;
	    *c = cc;
	    return true;
	}
    }
    return false;
}

#ifdef TESTMODE

#include <stdio.h>

int main(void)
{
    int r, c, rr, cc, ret;
    long int u, uu;

    for (r = 0; r < 94; r++) {
	for (c = 0; c < 94; c++) {
	    u = jisx0208_to_unicode(r, c);
	    if (u != ERROR) {
		ret = unicode_to_jisx0208(u, &rr, &cc);
		if (!ret)
		    printf("(%d,%d) -> U-%08lx but didn't convert back\n",
			   r, c, u);
		else if (rr != r || cc != c)
		    printf("(%d,%d) -> U-%08lx -> (%d,%d)\n",
			   r, c, u, rr, cc);
	    }
	}
    }

    for (u = 0; u < 0x10000L; u++) {
	ret = unicode_to_jisx0208(u, &r, &c);
	if (ret) {
	    uu = jisx0208_to_unicode(r, c);
	    if (uu == ERROR)
		printf("U-%08lx -> (%d,%d) but didn't convert back\n",
		       u, r, c);
	    else if (uu != u)
		printf("U-%08lx -> (%d,%d) -> U-%08lx\n", u, r, c, uu);
	}
    }

    return 0;
}

#endif
