/*
 * GB2312 implementation for libcharset. (This is the character set
 * itself, not any particular multibyte encoding of it. Multibyte
 * encodings of this character set are handled separately.)
 */

#include <assert.h>

#include "charset.h"
#include "internal.h"

/*
 * These tables are generated from the GB2312 <-> Unicode character
 * mapping found at
 * 
 * http://www.unicode.org/Public/MAPPINGS/OBSOLETE/EASTASIA/GB/GB2312.TXT
 */

/*
 * Mapping from GB2312 to Unicode. For these purposes GB2312 is
 * considered to be a 94x94 square array, with coordinates running
 * from (0,0) to (93,93).
 * 
 * Generated by running the following sh+Perl over GB2312.TXT:

cat GB2312.TXT | \
perl -ne '$a{hex$1,hex$2}=$3 if /^0x(\S\S)(\S\S)\s+(0x\S+)\s/;' \
      -e 'END {for $r (0..93) { $o="    {"; for $c (0..93) {' \
      -e '$k=$a{$r+33,$c+33}; $k=" ERROR" unless defined $k;' \
      -e '$o .= ", " if $c > 0; (print "$o\n"), $o="    " if length $o > 70;' \
      -e '$o .= $k; } print "$o},\n"; }}'

 */

static const unsigned short gb2312_forward[94][94] = {
    {0x3000, 0x3001, 0x3002, 0x30FB, 0x02C9, 0x02C7, 0x00A8, 0x3003, 0x3005, 
    0x2015, 0xFF5E, 0x2016, 0x2026, 0x2018, 0x2019, 0x201C, 0x201D, 0x3014, 
    0x3015, 0x3008, 0x3009, 0x300A, 0x300B, 0x300C, 0x300D, 0x300E, 0x300F, 
    0x3016, 0x3017, 0x3010, 0x3011, 0x00B1, 0x00D7, 0x00F7, 0x2236, 0x2227, 
    0x2228, 0x2211, 0x220F, 0x222A, 0x2229, 0x2208, 0x2237, 0x221A, 0x22A5, 
    0x2225, 0x2220, 0x2312, 0x2299, 0x222B, 0x222E, 0x2261, 0x224C, 0x2248, 
    0x223D, 0x221D, 0x2260, 0x226E, 0x226F, 0x2264, 0x2265, 0x221E, 0x2235, 
    0x2234, 0x2642, 0x2640, 0x00B0, 0x2032, 0x2033, 0x2103, 0xFF04, 0x00A4, 
    0xFFE0, 0xFFE1, 0x2030, 0x00A7, 0x2116, 0x2606, 0x2605, 0x25CB, 0x25CF, 
    0x25CE, 0x25C7, 0x25C6, 0x25A1, 0x25A0, 0x25B3, 0x25B2, 0x203B, 0x2192, 
    0x2190, 0x2191, 0x2193, 0x3013},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 0x2488, 0x2489, 
    0x248A, 0x248B, 0x248C, 0x248D, 0x248E, 0x248F, 0x2490, 0x2491, 0x2492, 
    0x2493, 0x2494, 0x2495, 0x2496, 0x2497, 0x2498, 0x2499, 0x249A, 0x249B, 
    0x2474, 0x2475, 0x2476, 0x2477, 0x2478, 0x2479, 0x247A, 0x247B, 0x247C, 
    0x247D, 0x247E, 0x247F, 0x2480, 0x2481, 0x2482, 0x2483, 0x2484, 0x2485, 
    0x2486, 0x2487, 0x2460, 0x2461, 0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 
    0x2467, 0x2468, 0x2469,  ERROR,  ERROR, 0x3220, 0x3221, 0x3222, 0x3223, 
    0x3224, 0x3225, 0x3226, 0x3227, 0x3228, 0x3229,  ERROR,  ERROR, 0x2160, 
    0x2161, 0x2162, 0x2163, 0x2164, 0x2165, 0x2166, 0x2167, 0x2168, 0x2169, 
    0x216A, 0x216B,  ERROR,  ERROR},
    {0xFF01, 0xFF02, 0xFF03, 0xFFE5, 0xFF05, 0xFF06, 0xFF07, 0xFF08, 0xFF09, 
    0xFF0A, 0xFF0B, 0xFF0C, 0xFF0D, 0xFF0E, 0xFF0F, 0xFF10, 0xFF11, 0xFF12, 
    0xFF13, 0xFF14, 0xFF15, 0xFF16, 0xFF17, 0xFF18, 0xFF19, 0xFF1A, 0xFF1B, 
    0xFF1C, 0xFF1D, 0xFF1E, 0xFF1F, 0xFF20, 0xFF21, 0xFF22, 0xFF23, 0xFF24, 
    0xFF25, 0xFF26, 0xFF27, 0xFF28, 0xFF29, 0xFF2A, 0xFF2B, 0xFF2C, 0xFF2D, 
    0xFF2E, 0xFF2F, 0xFF30, 0xFF31, 0xFF32, 0xFF33, 0xFF34, 0xFF35, 0xFF36, 
    0xFF37, 0xFF38, 0xFF39, 0xFF3A, 0xFF3B, 0xFF3C, 0xFF3D, 0xFF3E, 0xFF3F, 
    0xFF40, 0xFF41, 0xFF42, 0xFF43, 0xFF44, 0xFF45, 0xFF46, 0xFF47, 0xFF48, 
    0xFF49, 0xFF4A, 0xFF4B, 0xFF4C, 0xFF4D, 0xFF4E, 0xFF4F, 0xFF50, 0xFF51, 
    0xFF52, 0xFF53, 0xFF54, 0xFF55, 0xFF56, 0xFF57, 0xFF58, 0xFF59, 0xFF5A, 
    0xFF5B, 0xFF5C, 0xFF5D, 0xFFE3},
    {0x3041, 0x3042, 0x3043, 0x3044, 0x3045, 0x3046, 0x3047, 0x3048, 0x3049, 
    0x304A, 0x304B, 0x304C, 0x304D, 0x304E, 0x304F, 0x3050, 0x3051, 0x3052, 
    0x3053, 0x3054, 0x3055, 0x3056, 0x3057, 0x3058, 0x3059, 0x305A, 0x305B, 
    0x305C, 0x305D, 0x305E, 0x305F, 0x3060, 0x3061, 0x3062, 0x3063, 0x3064, 
    0x3065, 0x3066, 0x3067, 0x3068, 0x3069, 0x306A, 0x306B, 0x306C, 0x306D, 
    0x306E, 0x306F, 0x3070, 0x3071, 0x3072, 0x3073, 0x3074, 0x3075, 0x3076, 
    0x3077, 0x3078, 0x3079, 0x307A, 0x307B, 0x307C, 0x307D, 0x307E, 0x307F, 
    0x3080, 0x3081, 0x3082, 0x3083, 0x3084, 0x3085, 0x3086, 0x3087, 0x3088, 
    0x3089, 0x308A, 0x308B, 0x308C, 0x308D, 0x308E, 0x308F, 0x3090, 0x3091, 
    0x3092, 0x3093,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    {0x30A1, 0x30A2, 0x30A3, 0x30A4, 0x30A5, 0x30A6, 0x30A7, 0x30A8, 0x30A9, 
    0x30AA, 0x30AB, 0x30AC, 0x30AD, 0x30AE, 0x30AF, 0x30B0, 0x30B1, 0x30B2, 
    0x30B3, 0x30B4, 0x30B5, 0x30B6, 0x30B7, 0x30B8, 0x30B9, 0x30BA, 0x30BB, 
    0x30BC, 0x30BD, 0x30BE, 0x30BF, 0x30C0, 0x30C1, 0x30C2, 0x30C3, 0x30C4, 
    0x30C5, 0x30C6, 0x30C7, 0x30C8, 0x30C9, 0x30CA, 0x30CB, 0x30CC, 0x30CD, 
    0x30CE, 0x30CF, 0x30D0, 0x30D1, 0x30D2, 0x30D3, 0x30D4, 0x30D5, 0x30D6, 
    0x30D7, 0x30D8, 0x30D9, 0x30DA, 0x30DB, 0x30DC, 0x30DD, 0x30DE, 0x30DF, 
    0x30E0, 0x30E1, 0x30E2, 0x30E3, 0x30E4, 0x30E5, 0x30E6, 0x30E7, 0x30E8, 
    0x30E9, 0x30EA, 0x30EB, 0x30EC, 0x30ED, 0x30EE, 0x30EF, 0x30F0, 0x30F1, 
    0x30F2, 0x30F3, 0x30F4, 0x30F5, 0x30F6,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    {0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 0x0399, 
    0x039A, 0x039B, 0x039C, 0x039D, 0x039E, 0x039F, 0x03A0, 0x03A1, 0x03A3, 
    0x03A4, 0x03A5, 0x03A6, 0x03A7, 0x03A8, 0x03A9,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 
    0x03B5, 0x03B6, 0x03B7, 0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD, 
    0x03BE, 0x03BF, 0x03C0, 0x03C1, 0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7, 
    0x03C8, 0x03C9,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    {0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0401, 0x0416, 0x0417, 
    0x0418, 0x0419, 0x041A, 0x041B, 0x041C, 0x041D, 0x041E, 0x041F, 0x0420, 
    0x0421, 0x0422, 0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 
    0x042A, 0x042B, 0x042C, 0x042D, 0x042E, 0x042F,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR, 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 
    0x0451, 0x0436, 0x0437, 0x0438, 0x0439, 0x043A, 0x043B, 0x043C, 0x043D, 
    0x043E, 0x043F, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445, 0x0446, 
    0x0447, 0x0448, 0x0449, 0x044A, 0x044B, 0x044C, 0x044D, 0x044E, 0x044F, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    {0x0101, 0x00E1, 0x01CE, 0x00E0, 0x0113, 0x00E9, 0x011B, 0x00E8, 0x012B, 
    0x00ED, 0x01D0, 0x00EC, 0x014D, 0x00F3, 0x01D2, 0x00F2, 0x016B, 0x00FA, 
    0x01D4, 0x00F9, 0x01D6, 0x01D8, 0x01DA, 0x01DC, 0x00FC, 0x00EA,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
    0x3105, 0x3106, 0x3107, 0x3108, 0x3109, 0x310A, 0x310B, 0x310C, 0x310D, 
    0x310E, 0x310F, 0x3110, 0x3111, 0x3112, 0x3113, 0x3114, 0x3115, 0x3116, 
    0x3117, 0x3118, 0x3119, 0x311A, 0x311B, 0x311C, 0x311D, 0x311E, 0x311F, 
    0x3120, 0x3121, 0x3122, 0x3123, 0x3124, 0x3125, 0x3126, 0x3127, 0x3128, 
    0x3129,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR, 0x2500, 0x2501, 0x2502, 0x2503, 0x2504, 0x2505, 
    0x2506, 0x2507, 0x2508, 0x2509, 0x250A, 0x250B, 0x250C, 0x250D, 0x250E, 
    0x250F, 0x2510, 0x2511, 0x2512, 0x2513, 0x2514, 0x2515, 0x2516, 0x2517, 
    0x2518, 0x2519, 0x251A, 0x251B, 0x251C, 0x251D, 0x251E, 0x251F, 0x2520, 
    0x2521, 0x2522, 0x2523, 0x2524, 0x2525, 0x2526, 0x2527, 0x2528, 0x2529, 
    0x252A, 0x252B, 0x252C, 0x252D, 0x252E, 0x252F, 0x2530, 0x2531, 0x2532, 
    0x2533, 0x2534, 0x2535, 0x2536, 0x2537, 0x2538, 0x2539, 0x253A, 0x253B, 
    0x253C, 0x253D, 0x253E, 0x253F, 0x2540, 0x2541, 0x2542, 0x2543, 0x2544, 
    0x2545, 0x2546, 0x2547, 0x2548, 0x2549, 0x254A, 0x254B,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    {0x554A, 0x963F, 0x57C3, 0x6328, 0x54CE, 0x5509, 0x54C0, 0x7691, 0x764C, 
    0x853C, 0x77EE, 0x827E, 0x788D, 0x7231, 0x9698, 0x978D, 0x6C28, 0x5B89, 
    0x4FFA, 0x6309, 0x6697, 0x5CB8, 0x80FA, 0x6848, 0x80AE, 0x6602, 0x76CE, 
    0x51F9, 0x6556, 0x71AC, 0x7FF1, 0x8884, 0x50B2, 0x5965, 0x61CA, 0x6FB3, 
    0x82AD, 0x634C, 0x6252, 0x53ED, 0x5427, 0x7B06, 0x516B, 0x75A4, 0x5DF4, 
    0x62D4, 0x8DCB, 0x9776, 0x628A, 0x8019, 0x575D, 0x9738, 0x7F62, 0x7238, 
    0x767D, 0x67CF, 0x767E, 0x6446, 0x4F70, 0x8D25, 0x62DC, 0x7A17, 0x6591, 
    0x73ED, 0x642C, 0x6273, 0x822C, 0x9881, 0x677F, 0x7248, 0x626E, 0x62CC, 
    0x4F34, 0x74E3, 0x534A, 0x529E, 0x7ECA, 0x90A6, 0x5E2E, 0x6886, 0x699C, 
    0x8180, 0x7ED1, 0x68D2, 0x78C5, 0x868C, 0x9551, 0x508D, 0x8C24, 0x82DE, 
    0x80DE, 0x5305, 0x8912, 0x5265},
    {0x8584, 0x96F9, 0x4FDD, 0x5821, 0x9971, 0x5B9D, 0x62B1, 0x62A5, 0x66B4, 
    0x8C79, 0x9C8D, 0x7206, 0x676F, 0x7891, 0x60B2, 0x5351, 0x5317, 0x8F88, 
    0x80CC, 0x8D1D, 0x94A1, 0x500D, 0x72C8, 0x5907, 0x60EB, 0x7119, 0x88AB, 
    0x5954, 0x82EF, 0x672C, 0x7B28, 0x5D29, 0x7EF7, 0x752D, 0x6CF5, 0x8E66, 
    0x8FF8, 0x903C, 0x9F3B, 0x6BD4, 0x9119, 0x7B14, 0x5F7C, 0x78A7, 0x84D6, 
    0x853D, 0x6BD5, 0x6BD9, 0x6BD6, 0x5E01, 0x5E87, 0x75F9, 0x95ED, 0x655D, 
    0x5F0A, 0x5FC5, 0x8F9F, 0x58C1, 0x81C2, 0x907F, 0x965B, 0x97AD, 0x8FB9, 
    0x7F16, 0x8D2C, 0x6241, 0x4FBF, 0x53D8, 0x535E, 0x8FA8, 0x8FA9, 0x8FAB, 
    0x904D, 0x6807, 0x5F6A, 0x8198, 0x8868, 0x9CD6, 0x618B, 0x522B, 0x762A, 
    0x5F6C, 0x658C, 0x6FD2, 0x6EE8, 0x5BBE, 0x6448, 0x5175, 0x51B0, 0x67C4, 
    0x4E19, 0x79C9, 0x997C, 0x70B3},
    {0x75C5, 0x5E76, 0x73BB, 0x83E0, 0x64AD, 0x62E8, 0x94B5, 0x6CE2, 0x535A, 
    0x52C3, 0x640F, 0x94C2, 0x7B94, 0x4F2F, 0x5E1B, 0x8236, 0x8116, 0x818A, 
    0x6E24, 0x6CCA, 0x9A73, 0x6355, 0x535C, 0x54FA, 0x8865, 0x57E0, 0x4E0D, 
    0x5E03, 0x6B65, 0x7C3F, 0x90E8, 0x6016, 0x64E6, 0x731C, 0x88C1, 0x6750, 
    0x624D, 0x8D22, 0x776C, 0x8E29, 0x91C7, 0x5F69, 0x83DC, 0x8521, 0x9910, 
    0x53C2, 0x8695, 0x6B8B, 0x60ED, 0x60E8, 0x707F, 0x82CD, 0x8231, 0x4ED3, 
    0x6CA7, 0x85CF, 0x64CD, 0x7CD9, 0x69FD, 0x66F9, 0x8349, 0x5395, 0x7B56, 
    0x4FA7, 0x518C, 0x6D4B, 0x5C42, 0x8E6D, 0x63D2, 0x53C9, 0x832C, 0x8336, 
    0x67E5, 0x78B4, 0x643D, 0x5BDF, 0x5C94, 0x5DEE, 0x8BE7, 0x62C6, 0x67F4, 
    0x8C7A, 0x6400, 0x63BA, 0x8749, 0x998B, 0x8C17, 0x7F20, 0x94F2, 0x4EA7, 
    0x9610, 0x98A4, 0x660C, 0x7316},
    {0x573A, 0x5C1D, 0x5E38, 0x957F, 0x507F, 0x80A0, 0x5382, 0x655E, 0x7545, 
    0x5531, 0x5021, 0x8D85, 0x6284, 0x949E, 0x671D, 0x5632, 0x6F6E, 0x5DE2, 
    0x5435, 0x7092, 0x8F66, 0x626F, 0x64A4, 0x63A3, 0x5F7B, 0x6F88, 0x90F4, 
    0x81E3, 0x8FB0, 0x5C18, 0x6668, 0x5FF1, 0x6C89, 0x9648, 0x8D81, 0x886C, 
    0x6491, 0x79F0, 0x57CE, 0x6A59, 0x6210, 0x5448, 0x4E58, 0x7A0B, 0x60E9, 
    0x6F84, 0x8BDA, 0x627F, 0x901E, 0x9A8B, 0x79E4, 0x5403, 0x75F4, 0x6301, 
    0x5319, 0x6C60, 0x8FDF, 0x5F1B, 0x9A70, 0x803B, 0x9F7F, 0x4F88, 0x5C3A, 
    0x8D64, 0x7FC5, 0x65A5, 0x70BD, 0x5145, 0x51B2, 0x866B, 0x5D07, 0x5BA0, 
    0x62BD, 0x916C, 0x7574, 0x8E0C, 0x7A20, 0x6101, 0x7B79, 0x4EC7, 0x7EF8, 
    0x7785, 0x4E11, 0x81ED, 0x521D, 0x51FA, 0x6A71, 0x53A8, 0x8E87, 0x9504, 
    0x96CF, 0x6EC1, 0x9664, 0x695A},
    {0x7840, 0x50A8, 0x77D7, 0x6410, 0x89E6, 0x5904, 0x63E3, 0x5DDD, 0x7A7F, 
    0x693D, 0x4F20, 0x8239, 0x5598, 0x4E32, 0x75AE, 0x7A97, 0x5E62, 0x5E8A, 
    0x95EF, 0x521B, 0x5439, 0x708A, 0x6376, 0x9524, 0x5782, 0x6625, 0x693F, 
    0x9187, 0x5507, 0x6DF3, 0x7EAF, 0x8822, 0x6233, 0x7EF0, 0x75B5, 0x8328, 
    0x78C1, 0x96CC, 0x8F9E, 0x6148, 0x74F7, 0x8BCD, 0x6B64, 0x523A, 0x8D50, 
    0x6B21, 0x806A, 0x8471, 0x56F1, 0x5306, 0x4ECE, 0x4E1B, 0x51D1, 0x7C97, 
    0x918B, 0x7C07, 0x4FC3, 0x8E7F, 0x7BE1, 0x7A9C, 0x6467, 0x5D14, 0x50AC, 
    0x8106, 0x7601, 0x7CB9, 0x6DEC, 0x7FE0, 0x6751, 0x5B58, 0x5BF8, 0x78CB, 
    0x64AE, 0x6413, 0x63AA, 0x632B, 0x9519, 0x642D, 0x8FBE, 0x7B54, 0x7629, 
    0x6253, 0x5927, 0x5446, 0x6B79, 0x50A3, 0x6234, 0x5E26, 0x6B86, 0x4EE3, 
    0x8D37, 0x888B, 0x5F85, 0x902E},
    {0x6020, 0x803D, 0x62C5, 0x4E39, 0x5355, 0x90F8, 0x63B8, 0x80C6, 0x65E6, 
    0x6C2E, 0x4F46, 0x60EE, 0x6DE1, 0x8BDE, 0x5F39, 0x86CB, 0x5F53, 0x6321, 
    0x515A, 0x8361, 0x6863, 0x5200, 0x6363, 0x8E48, 0x5012, 0x5C9B, 0x7977, 
    0x5BFC, 0x5230, 0x7A3B, 0x60BC, 0x9053, 0x76D7, 0x5FB7, 0x5F97, 0x7684, 
    0x8E6C, 0x706F, 0x767B, 0x7B49, 0x77AA, 0x51F3, 0x9093, 0x5824, 0x4F4E, 
    0x6EF4, 0x8FEA, 0x654C, 0x7B1B, 0x72C4, 0x6DA4, 0x7FDF, 0x5AE1, 0x62B5, 
    0x5E95, 0x5730, 0x8482, 0x7B2C, 0x5E1D, 0x5F1F, 0x9012, 0x7F14, 0x98A0, 
    0x6382, 0x6EC7, 0x7898, 0x70B9, 0x5178, 0x975B, 0x57AB, 0x7535, 0x4F43, 
    0x7538, 0x5E97, 0x60E6, 0x5960, 0x6DC0, 0x6BBF, 0x7889, 0x53FC, 0x96D5, 
    0x51CB, 0x5201, 0x6389, 0x540A, 0x9493, 0x8C03, 0x8DCC, 0x7239, 0x789F, 
    0x8776, 0x8FED, 0x8C0D, 0x53E0},
    {0x4E01, 0x76EF, 0x53EE, 0x9489, 0x9876, 0x9F0E, 0x952D, 0x5B9A, 0x8BA2, 
    0x4E22, 0x4E1C, 0x51AC, 0x8463, 0x61C2, 0x52A8, 0x680B, 0x4F97, 0x606B, 
    0x51BB, 0x6D1E, 0x515C, 0x6296, 0x6597, 0x9661, 0x8C46, 0x9017, 0x75D8, 
    0x90FD, 0x7763, 0x6BD2, 0x728A, 0x72EC, 0x8BFB, 0x5835, 0x7779, 0x8D4C, 
    0x675C, 0x9540, 0x809A, 0x5EA6, 0x6E21, 0x5992, 0x7AEF, 0x77ED, 0x953B, 
    0x6BB5, 0x65AD, 0x7F0E, 0x5806, 0x5151, 0x961F, 0x5BF9, 0x58A9, 0x5428, 
    0x8E72, 0x6566, 0x987F, 0x56E4, 0x949D, 0x76FE, 0x9041, 0x6387, 0x54C6, 
    0x591A, 0x593A, 0x579B, 0x8EB2, 0x6735, 0x8DFA, 0x8235, 0x5241, 0x60F0, 
    0x5815, 0x86FE, 0x5CE8, 0x9E45, 0x4FC4, 0x989D, 0x8BB9, 0x5A25, 0x6076, 
    0x5384, 0x627C, 0x904F, 0x9102, 0x997F, 0x6069, 0x800C, 0x513F, 0x8033, 
    0x5C14, 0x9975, 0x6D31, 0x4E8C},
    {0x8D30, 0x53D1, 0x7F5A, 0x7B4F, 0x4F10, 0x4E4F, 0x9600, 0x6CD5, 0x73D0, 
    0x85E9, 0x5E06, 0x756A, 0x7FFB, 0x6A0A, 0x77FE, 0x9492, 0x7E41, 0x51E1, 
    0x70E6, 0x53CD, 0x8FD4, 0x8303, 0x8D29, 0x72AF, 0x996D, 0x6CDB, 0x574A, 
    0x82B3, 0x65B9, 0x80AA, 0x623F, 0x9632, 0x59A8, 0x4EFF, 0x8BBF, 0x7EBA, 
    0x653E, 0x83F2, 0x975E, 0x5561, 0x98DE, 0x80A5, 0x532A, 0x8BFD, 0x5420, 
    0x80BA, 0x5E9F, 0x6CB8, 0x8D39, 0x82AC, 0x915A, 0x5429, 0x6C1B, 0x5206, 
    0x7EB7, 0x575F, 0x711A, 0x6C7E, 0x7C89, 0x594B, 0x4EFD, 0x5FFF, 0x6124, 
    0x7CAA, 0x4E30, 0x5C01, 0x67AB, 0x8702, 0x5CF0, 0x950B, 0x98CE, 0x75AF, 
    0x70FD, 0x9022, 0x51AF, 0x7F1D, 0x8BBD, 0x5949, 0x51E4, 0x4F5B, 0x5426, 
    0x592B, 0x6577, 0x80A4, 0x5B75, 0x6276, 0x62C2, 0x8F90, 0x5E45, 0x6C1F, 
    0x7B26, 0x4F0F, 0x4FD8, 0x670D},
    {0x6D6E, 0x6DAA, 0x798F, 0x88B1, 0x5F17, 0x752B, 0x629A, 0x8F85, 0x4FEF, 
    0x91DC, 0x65A7, 0x812F, 0x8151, 0x5E9C, 0x8150, 0x8D74, 0x526F, 0x8986, 
    0x8D4B, 0x590D, 0x5085, 0x4ED8, 0x961C, 0x7236, 0x8179, 0x8D1F, 0x5BCC, 
    0x8BA3, 0x9644, 0x5987, 0x7F1A, 0x5490, 0x5676, 0x560E, 0x8BE5, 0x6539, 
    0x6982, 0x9499, 0x76D6, 0x6E89, 0x5E72, 0x7518, 0x6746, 0x67D1, 0x7AFF, 
    0x809D, 0x8D76, 0x611F, 0x79C6, 0x6562, 0x8D63, 0x5188, 0x521A, 0x94A2, 
    0x7F38, 0x809B, 0x7EB2, 0x5C97, 0x6E2F, 0x6760, 0x7BD9, 0x768B, 0x9AD8, 
    0x818F, 0x7F94, 0x7CD5, 0x641E, 0x9550, 0x7A3F, 0x544A, 0x54E5, 0x6B4C, 
    0x6401, 0x6208, 0x9E3D, 0x80F3, 0x7599, 0x5272, 0x9769, 0x845B, 0x683C, 
    0x86E4, 0x9601, 0x9694, 0x94EC, 0x4E2A, 0x5404, 0x7ED9, 0x6839, 0x8DDF, 
    0x8015, 0x66F4, 0x5E9A, 0x7FB9},
    {0x57C2, 0x803F, 0x6897, 0x5DE5, 0x653B, 0x529F, 0x606D, 0x9F9A, 0x4F9B, 
    0x8EAC, 0x516C, 0x5BAB, 0x5F13, 0x5DE9, 0x6C5E, 0x62F1, 0x8D21, 0x5171, 
    0x94A9, 0x52FE, 0x6C9F, 0x82DF, 0x72D7, 0x57A2, 0x6784, 0x8D2D, 0x591F, 
    0x8F9C, 0x83C7, 0x5495, 0x7B8D, 0x4F30, 0x6CBD, 0x5B64, 0x59D1, 0x9F13, 
    0x53E4, 0x86CA, 0x9AA8, 0x8C37, 0x80A1, 0x6545, 0x987E, 0x56FA, 0x96C7, 
    0x522E, 0x74DC, 0x5250, 0x5BE1, 0x6302, 0x8902, 0x4E56, 0x62D0, 0x602A, 
    0x68FA, 0x5173, 0x5B98, 0x51A0, 0x89C2, 0x7BA1, 0x9986, 0x7F50, 0x60EF, 
    0x704C, 0x8D2F, 0x5149, 0x5E7F, 0x901B, 0x7470, 0x89C4, 0x572D, 0x7845, 
    0x5F52, 0x9F9F, 0x95FA, 0x8F68, 0x9B3C, 0x8BE1, 0x7678, 0x6842, 0x67DC, 
    0x8DEA, 0x8D35, 0x523D, 0x8F8A, 0x6EDA, 0x68CD, 0x9505, 0x90ED, 0x56FD, 
    0x679C, 0x88F9, 0x8FC7, 0x54C8},
    {0x9AB8, 0x5B69, 0x6D77, 0x6C26, 0x4EA5, 0x5BB3, 0x9A87, 0x9163, 0x61A8, 
    0x90AF, 0x97E9, 0x542B, 0x6DB5, 0x5BD2, 0x51FD, 0x558A, 0x7F55, 0x7FF0, 
    0x64BC, 0x634D, 0x65F1, 0x61BE, 0x608D, 0x710A, 0x6C57, 0x6C49, 0x592F, 
    0x676D, 0x822A, 0x58D5, 0x568E, 0x8C6A, 0x6BEB, 0x90DD, 0x597D, 0x8017, 
    0x53F7, 0x6D69, 0x5475, 0x559D, 0x8377, 0x83CF, 0x6838, 0x79BE, 0x548C, 
    0x4F55, 0x5408, 0x76D2, 0x8C89, 0x9602, 0x6CB3, 0x6DB8, 0x8D6B, 0x8910, 
    0x9E64, 0x8D3A, 0x563F, 0x9ED1, 0x75D5, 0x5F88, 0x72E0, 0x6068, 0x54FC, 
    0x4EA8, 0x6A2A, 0x8861, 0x6052, 0x8F70, 0x54C4, 0x70D8, 0x8679, 0x9E3F, 
    0x6D2A, 0x5B8F, 0x5F18, 0x7EA2, 0x5589, 0x4FAF, 0x7334, 0x543C, 0x539A, 
    0x5019, 0x540E, 0x547C, 0x4E4E, 0x5FFD, 0x745A, 0x58F6, 0x846B, 0x80E1, 
    0x8774, 0x72D0, 0x7CCA, 0x6E56},
    {0x5F27, 0x864E, 0x552C, 0x62A4, 0x4E92, 0x6CAA, 0x6237, 0x82B1, 0x54D7, 
    0x534E, 0x733E, 0x6ED1, 0x753B, 0x5212, 0x5316, 0x8BDD, 0x69D0, 0x5F8A, 
    0x6000, 0x6DEE, 0x574F, 0x6B22, 0x73AF, 0x6853, 0x8FD8, 0x7F13, 0x6362, 
    0x60A3, 0x5524, 0x75EA, 0x8C62, 0x7115, 0x6DA3, 0x5BA6, 0x5E7B, 0x8352, 
    0x614C, 0x9EC4, 0x78FA, 0x8757, 0x7C27, 0x7687, 0x51F0, 0x60F6, 0x714C, 
    0x6643, 0x5E4C, 0x604D, 0x8C0E, 0x7070, 0x6325, 0x8F89, 0x5FBD, 0x6062, 
    0x86D4, 0x56DE, 0x6BC1, 0x6094, 0x6167, 0x5349, 0x60E0, 0x6666, 0x8D3F, 
    0x79FD, 0x4F1A, 0x70E9, 0x6C47, 0x8BB3, 0x8BF2, 0x7ED8, 0x8364, 0x660F, 
    0x5A5A, 0x9B42, 0x6D51, 0x6DF7, 0x8C41, 0x6D3B, 0x4F19, 0x706B, 0x83B7, 
    0x6216, 0x60D1, 0x970D, 0x8D27, 0x7978, 0x51FB, 0x573E, 0x57FA, 0x673A, 
    0x7578, 0x7A3D, 0x79EF, 0x7B95},
    {0x808C, 0x9965, 0x8FF9, 0x6FC0, 0x8BA5, 0x9E21, 0x59EC, 0x7EE9, 0x7F09, 
    0x5409, 0x6781, 0x68D8, 0x8F91, 0x7C4D, 0x96C6, 0x53CA, 0x6025, 0x75BE, 
    0x6C72, 0x5373, 0x5AC9, 0x7EA7, 0x6324, 0x51E0, 0x810A, 0x5DF1, 0x84DF, 
    0x6280, 0x5180, 0x5B63, 0x4F0E, 0x796D, 0x5242, 0x60B8, 0x6D4E, 0x5BC4, 
    0x5BC2, 0x8BA1, 0x8BB0, 0x65E2, 0x5FCC, 0x9645, 0x5993, 0x7EE7, 0x7EAA, 
    0x5609, 0x67B7, 0x5939, 0x4F73, 0x5BB6, 0x52A0, 0x835A, 0x988A, 0x8D3E, 
    0x7532, 0x94BE, 0x5047, 0x7A3C, 0x4EF7, 0x67B6, 0x9A7E, 0x5AC1, 0x6B7C, 
    0x76D1, 0x575A, 0x5C16, 0x7B3A, 0x95F4, 0x714E, 0x517C, 0x80A9, 0x8270, 
    0x5978, 0x7F04, 0x8327, 0x68C0, 0x67EC, 0x78B1, 0x7877, 0x62E3, 0x6361, 
    0x7B80, 0x4FED, 0x526A, 0x51CF, 0x8350, 0x69DB, 0x9274, 0x8DF5, 0x8D31, 
    0x89C1, 0x952E, 0x7BAD, 0x4EF6},
    {0x5065, 0x8230, 0x5251, 0x996F, 0x6E10, 0x6E85, 0x6DA7, 0x5EFA, 0x50F5, 
    0x59DC, 0x5C06, 0x6D46, 0x6C5F, 0x7586, 0x848B, 0x6868, 0x5956, 0x8BB2, 
    0x5320, 0x9171, 0x964D, 0x8549, 0x6912, 0x7901, 0x7126, 0x80F6, 0x4EA4, 
    0x90CA, 0x6D47, 0x9A84, 0x5A07, 0x56BC, 0x6405, 0x94F0, 0x77EB, 0x4FA5, 
    0x811A, 0x72E1, 0x89D2, 0x997A, 0x7F34, 0x7EDE, 0x527F, 0x6559, 0x9175, 
    0x8F7F, 0x8F83, 0x53EB, 0x7A96, 0x63ED, 0x63A5, 0x7686, 0x79F8, 0x8857, 
    0x9636, 0x622A, 0x52AB, 0x8282, 0x6854, 0x6770, 0x6377, 0x776B, 0x7AED, 
    0x6D01, 0x7ED3, 0x89E3, 0x59D0, 0x6212, 0x85C9, 0x82A5, 0x754C, 0x501F, 
    0x4ECB, 0x75A5, 0x8BEB, 0x5C4A, 0x5DFE, 0x7B4B, 0x65A4, 0x91D1, 0x4ECA, 
    0x6D25, 0x895F, 0x7D27, 0x9526, 0x4EC5, 0x8C28, 0x8FDB, 0x9773, 0x664B, 
    0x7981, 0x8FD1, 0x70EC, 0x6D78},
    {0x5C3D, 0x52B2, 0x8346, 0x5162, 0x830E, 0x775B, 0x6676, 0x9CB8, 0x4EAC, 
    0x60CA, 0x7CBE, 0x7CB3, 0x7ECF, 0x4E95, 0x8B66, 0x666F, 0x9888, 0x9759, 
    0x5883, 0x656C, 0x955C, 0x5F84, 0x75C9, 0x9756, 0x7ADF, 0x7ADE, 0x51C0, 
    0x70AF, 0x7A98, 0x63EA, 0x7A76, 0x7EA0, 0x7396, 0x97ED, 0x4E45, 0x7078, 
    0x4E5D, 0x9152, 0x53A9, 0x6551, 0x65E7, 0x81FC, 0x8205, 0x548E, 0x5C31, 
    0x759A, 0x97A0, 0x62D8, 0x72D9, 0x75BD, 0x5C45, 0x9A79, 0x83CA, 0x5C40, 
    0x5480, 0x77E9, 0x4E3E, 0x6CAE, 0x805A, 0x62D2, 0x636E, 0x5DE8, 0x5177, 
    0x8DDD, 0x8E1E, 0x952F, 0x4FF1, 0x53E5, 0x60E7, 0x70AC, 0x5267, 0x6350, 
    0x9E43, 0x5A1F, 0x5026, 0x7737, 0x5377, 0x7EE2, 0x6485, 0x652B, 0x6289, 
    0x6398, 0x5014, 0x7235, 0x89C9, 0x51B3, 0x8BC0, 0x7EDD, 0x5747, 0x83CC, 
    0x94A7, 0x519B, 0x541B, 0x5CFB},
    {0x4FCA, 0x7AE3, 0x6D5A, 0x90E1, 0x9A8F, 0x5580, 0x5496, 0x5361, 0x54AF, 
    0x5F00, 0x63E9, 0x6977, 0x51EF, 0x6168, 0x520A, 0x582A, 0x52D8, 0x574E, 
    0x780D, 0x770B, 0x5EB7, 0x6177, 0x7CE0, 0x625B, 0x6297, 0x4EA2, 0x7095, 
    0x8003, 0x62F7, 0x70E4, 0x9760, 0x5777, 0x82DB, 0x67EF, 0x68F5, 0x78D5, 
    0x9897, 0x79D1, 0x58F3, 0x54B3, 0x53EF, 0x6E34, 0x514B, 0x523B, 0x5BA2, 
    0x8BFE, 0x80AF, 0x5543, 0x57A6, 0x6073, 0x5751, 0x542D, 0x7A7A, 0x6050, 
    0x5B54, 0x63A7, 0x62A0, 0x53E3, 0x6263, 0x5BC7, 0x67AF, 0x54ED, 0x7A9F, 
    0x82E6, 0x9177, 0x5E93, 0x88E4, 0x5938, 0x57AE, 0x630E, 0x8DE8, 0x80EF, 
    0x5757, 0x7B77, 0x4FA9, 0x5FEB, 0x5BBD, 0x6B3E, 0x5321, 0x7B50, 0x72C2, 
    0x6846, 0x77FF, 0x7736, 0x65F7, 0x51B5, 0x4E8F, 0x76D4, 0x5CBF, 0x7AA5, 
    0x8475, 0x594E, 0x9B41, 0x5080},
    {0x9988, 0x6127, 0x6E83, 0x5764, 0x6606, 0x6346, 0x56F0, 0x62EC, 0x6269, 
    0x5ED3, 0x9614, 0x5783, 0x62C9, 0x5587, 0x8721, 0x814A, 0x8FA3, 0x5566, 
    0x83B1, 0x6765, 0x8D56, 0x84DD, 0x5A6A, 0x680F, 0x62E6, 0x7BEE, 0x9611, 
    0x5170, 0x6F9C, 0x8C30, 0x63FD, 0x89C8, 0x61D2, 0x7F06, 0x70C2, 0x6EE5, 
    0x7405, 0x6994, 0x72FC, 0x5ECA, 0x90CE, 0x6717, 0x6D6A, 0x635E, 0x52B3, 
    0x7262, 0x8001, 0x4F6C, 0x59E5, 0x916A, 0x70D9, 0x6D9D, 0x52D2, 0x4E50, 
    0x96F7, 0x956D, 0x857E, 0x78CA, 0x7D2F, 0x5121, 0x5792, 0x64C2, 0x808B, 
    0x7C7B, 0x6CEA, 0x68F1, 0x695E, 0x51B7, 0x5398, 0x68A8, 0x7281, 0x9ECE, 
    0x7BF1, 0x72F8, 0x79BB, 0x6F13, 0x7406, 0x674E, 0x91CC, 0x9CA4, 0x793C, 
    0x8389, 0x8354, 0x540F, 0x6817, 0x4E3D, 0x5389, 0x52B1, 0x783E, 0x5386, 
    0x5229, 0x5088, 0x4F8B, 0x4FD0},
    {0x75E2, 0x7ACB, 0x7C92, 0x6CA5, 0x96B6, 0x529B, 0x7483, 0x54E9, 0x4FE9, 
    0x8054, 0x83B2, 0x8FDE, 0x9570, 0x5EC9, 0x601C, 0x6D9F, 0x5E18, 0x655B, 
    0x8138, 0x94FE, 0x604B, 0x70BC, 0x7EC3, 0x7CAE, 0x51C9, 0x6881, 0x7CB1, 
    0x826F, 0x4E24, 0x8F86, 0x91CF, 0x667E, 0x4EAE, 0x8C05, 0x64A9, 0x804A, 
    0x50DA, 0x7597, 0x71CE, 0x5BE5, 0x8FBD, 0x6F66, 0x4E86, 0x6482, 0x9563, 
    0x5ED6, 0x6599, 0x5217, 0x88C2, 0x70C8, 0x52A3, 0x730E, 0x7433, 0x6797, 
    0x78F7, 0x9716, 0x4E34, 0x90BB, 0x9CDE, 0x6DCB, 0x51DB, 0x8D41, 0x541D, 
    0x62CE, 0x73B2, 0x83F1, 0x96F6, 0x9F84, 0x94C3, 0x4F36, 0x7F9A, 0x51CC, 
    0x7075, 0x9675, 0x5CAD, 0x9886, 0x53E6, 0x4EE4, 0x6E9C, 0x7409, 0x69B4, 
    0x786B, 0x998F, 0x7559, 0x5218, 0x7624, 0x6D41, 0x67F3, 0x516D, 0x9F99, 
    0x804B, 0x5499, 0x7B3C, 0x7ABF},
    {0x9686, 0x5784, 0x62E2, 0x9647, 0x697C, 0x5A04, 0x6402, 0x7BD3, 0x6F0F, 
    0x964B, 0x82A6, 0x5362, 0x9885, 0x5E90, 0x7089, 0x63B3, 0x5364, 0x864F, 
    0x9C81, 0x9E93, 0x788C, 0x9732, 0x8DEF, 0x8D42, 0x9E7F, 0x6F5E, 0x7984, 
    0x5F55, 0x9646, 0x622E, 0x9A74, 0x5415, 0x94DD, 0x4FA3, 0x65C5, 0x5C65, 
    0x5C61, 0x7F15, 0x8651, 0x6C2F, 0x5F8B, 0x7387, 0x6EE4, 0x7EFF, 0x5CE6, 
    0x631B, 0x5B6A, 0x6EE6, 0x5375, 0x4E71, 0x63A0, 0x7565, 0x62A1, 0x8F6E, 
    0x4F26, 0x4ED1, 0x6CA6, 0x7EB6, 0x8BBA, 0x841D, 0x87BA, 0x7F57, 0x903B, 
    0x9523, 0x7BA9, 0x9AA1, 0x88F8, 0x843D, 0x6D1B, 0x9A86, 0x7EDC, 0x5988, 
    0x9EBB, 0x739B, 0x7801, 0x8682, 0x9A6C, 0x9A82, 0x561B, 0x5417, 0x57CB, 
    0x4E70, 0x9EA6, 0x5356, 0x8FC8, 0x8109, 0x7792, 0x9992, 0x86EE, 0x6EE1, 
    0x8513, 0x66FC, 0x6162, 0x6F2B},
    {0x8C29, 0x8292, 0x832B, 0x76F2, 0x6C13, 0x5FD9, 0x83BD, 0x732B, 0x8305, 
    0x951A, 0x6BDB, 0x77DB, 0x94C6, 0x536F, 0x8302, 0x5192, 0x5E3D, 0x8C8C, 
    0x8D38, 0x4E48, 0x73AB, 0x679A, 0x6885, 0x9176, 0x9709, 0x7164, 0x6CA1, 
    0x7709, 0x5A92, 0x9541, 0x6BCF, 0x7F8E, 0x6627, 0x5BD0, 0x59B9, 0x5A9A, 
    0x95E8, 0x95F7, 0x4EEC, 0x840C, 0x8499, 0x6AAC, 0x76DF, 0x9530, 0x731B, 
    0x68A6, 0x5B5F, 0x772F, 0x919A, 0x9761, 0x7CDC, 0x8FF7, 0x8C1C, 0x5F25, 
    0x7C73, 0x79D8, 0x89C5, 0x6CCC, 0x871C, 0x5BC6, 0x5E42, 0x68C9, 0x7720, 
    0x7EF5, 0x5195, 0x514D, 0x52C9, 0x5A29, 0x7F05, 0x9762, 0x82D7, 0x63CF, 
    0x7784, 0x85D0, 0x79D2, 0x6E3A, 0x5E99, 0x5999, 0x8511, 0x706D, 0x6C11, 
    0x62BF, 0x76BF, 0x654F, 0x60AF, 0x95FD, 0x660E, 0x879F, 0x9E23, 0x94ED, 
    0x540D, 0x547D, 0x8C2C, 0x6478},
    {0x6479, 0x8611, 0x6A21, 0x819C, 0x78E8, 0x6469, 0x9B54, 0x62B9, 0x672B, 
    0x83AB, 0x58A8, 0x9ED8, 0x6CAB, 0x6F20, 0x5BDE, 0x964C, 0x8C0B, 0x725F, 
    0x67D0, 0x62C7, 0x7261, 0x4EA9, 0x59C6, 0x6BCD, 0x5893, 0x66AE, 0x5E55, 
    0x52DF, 0x6155, 0x6728, 0x76EE, 0x7766, 0x7267, 0x7A46, 0x62FF, 0x54EA, 
    0x5450, 0x94A0, 0x90A3, 0x5A1C, 0x7EB3, 0x6C16, 0x4E43, 0x5976, 0x8010, 
    0x5948, 0x5357, 0x7537, 0x96BE, 0x56CA, 0x6320, 0x8111, 0x607C, 0x95F9, 
    0x6DD6, 0x5462, 0x9981, 0x5185, 0x5AE9, 0x80FD, 0x59AE, 0x9713, 0x502A, 
    0x6CE5, 0x5C3C, 0x62DF, 0x4F60, 0x533F, 0x817B, 0x9006, 0x6EBA, 0x852B, 
    0x62C8, 0x5E74, 0x78BE, 0x64B5, 0x637B, 0x5FF5, 0x5A18, 0x917F, 0x9E1F, 
    0x5C3F, 0x634F, 0x8042, 0x5B7D, 0x556E, 0x954A, 0x954D, 0x6D85, 0x60A8, 
    0x67E0, 0x72DE, 0x51DD, 0x5B81},
    {0x62E7, 0x6CDE, 0x725B, 0x626D, 0x94AE, 0x7EBD, 0x8113, 0x6D53, 0x519C, 
    0x5F04, 0x5974, 0x52AA, 0x6012, 0x5973, 0x6696, 0x8650, 0x759F, 0x632A, 
    0x61E6, 0x7CEF, 0x8BFA, 0x54E6, 0x6B27, 0x9E25, 0x6BB4, 0x85D5, 0x5455, 
    0x5076, 0x6CA4, 0x556A, 0x8DB4, 0x722C, 0x5E15, 0x6015, 0x7436, 0x62CD, 
    0x6392, 0x724C, 0x5F98, 0x6E43, 0x6D3E, 0x6500, 0x6F58, 0x76D8, 0x78D0, 
    0x76FC, 0x7554, 0x5224, 0x53DB, 0x4E53, 0x5E9E, 0x65C1, 0x802A, 0x80D6, 
    0x629B, 0x5486, 0x5228, 0x70AE, 0x888D, 0x8DD1, 0x6CE1, 0x5478, 0x80DA, 
    0x57F9, 0x88F4, 0x8D54, 0x966A, 0x914D, 0x4F69, 0x6C9B, 0x55B7, 0x76C6, 
    0x7830, 0x62A8, 0x70F9, 0x6F8E, 0x5F6D, 0x84EC, 0x68DA, 0x787C, 0x7BF7, 
    0x81A8, 0x670B, 0x9E4F, 0x6367, 0x78B0, 0x576F, 0x7812, 0x9739, 0x6279, 
    0x62AB, 0x5288, 0x7435, 0x6BD7},
    {0x5564, 0x813E, 0x75B2, 0x76AE, 0x5339, 0x75DE, 0x50FB, 0x5C41, 0x8B6C, 
    0x7BC7, 0x504F, 0x7247, 0x9A97, 0x98D8, 0x6F02, 0x74E2, 0x7968, 0x6487, 
    0x77A5, 0x62FC, 0x9891, 0x8D2B, 0x54C1, 0x8058, 0x4E52, 0x576A, 0x82F9, 
    0x840D, 0x5E73, 0x51ED, 0x74F6, 0x8BC4, 0x5C4F, 0x5761, 0x6CFC, 0x9887, 
    0x5A46, 0x7834, 0x9B44, 0x8FEB, 0x7C95, 0x5256, 0x6251, 0x94FA, 0x4EC6, 
    0x8386, 0x8461, 0x83E9, 0x84B2, 0x57D4, 0x6734, 0x5703, 0x666E, 0x6D66, 
    0x8C31, 0x66DD, 0x7011, 0x671F, 0x6B3A, 0x6816, 0x621A, 0x59BB, 0x4E03, 
    0x51C4, 0x6F06, 0x67D2, 0x6C8F, 0x5176, 0x68CB, 0x5947, 0x6B67, 0x7566, 
    0x5D0E, 0x8110, 0x9F50, 0x65D7, 0x7948, 0x7941, 0x9A91, 0x8D77, 0x5C82, 
    0x4E5E, 0x4F01, 0x542F, 0x5951, 0x780C, 0x5668, 0x6C14, 0x8FC4, 0x5F03, 
    0x6C7D, 0x6CE3, 0x8BAB, 0x6390},
    {0x6070, 0x6D3D, 0x7275, 0x6266, 0x948E, 0x94C5, 0x5343, 0x8FC1, 0x7B7E, 
    0x4EDF, 0x8C26, 0x4E7E, 0x9ED4, 0x94B1, 0x94B3, 0x524D, 0x6F5C, 0x9063, 
    0x6D45, 0x8C34, 0x5811, 0x5D4C, 0x6B20, 0x6B49, 0x67AA, 0x545B, 0x8154, 
    0x7F8C, 0x5899, 0x8537, 0x5F3A, 0x62A2, 0x6A47, 0x9539, 0x6572, 0x6084, 
    0x6865, 0x77A7, 0x4E54, 0x4FA8, 0x5DE7, 0x9798, 0x64AC, 0x7FD8, 0x5CED, 
    0x4FCF, 0x7A8D, 0x5207, 0x8304, 0x4E14, 0x602F, 0x7A83, 0x94A6, 0x4FB5, 
    0x4EB2, 0x79E6, 0x7434, 0x52E4, 0x82B9, 0x64D2, 0x79BD, 0x5BDD, 0x6C81, 
    0x9752, 0x8F7B, 0x6C22, 0x503E, 0x537F, 0x6E05, 0x64CE, 0x6674, 0x6C30, 
    0x60C5, 0x9877, 0x8BF7, 0x5E86, 0x743C, 0x7A77, 0x79CB, 0x4E18, 0x90B1, 
    0x7403, 0x6C42, 0x56DA, 0x914B, 0x6CC5, 0x8D8B, 0x533A, 0x86C6, 0x66F2, 
    0x8EAF, 0x5C48, 0x9A71, 0x6E20},
    {0x53D6, 0x5A36, 0x9F8B, 0x8DA3, 0x53BB, 0x5708, 0x98A7, 0x6743, 0x919B, 
    0x6CC9, 0x5168, 0x75CA, 0x62F3, 0x72AC, 0x5238, 0x529D, 0x7F3A, 0x7094, 
    0x7638, 0x5374, 0x9E4A, 0x69B7, 0x786E, 0x96C0, 0x88D9, 0x7FA4, 0x7136, 
    0x71C3, 0x5189, 0x67D3, 0x74E4, 0x58E4, 0x6518, 0x56B7, 0x8BA9, 0x9976, 
    0x6270, 0x7ED5, 0x60F9, 0x70ED, 0x58EC, 0x4EC1, 0x4EBA, 0x5FCD, 0x97E7, 
    0x4EFB, 0x8BA4, 0x5203, 0x598A, 0x7EAB, 0x6254, 0x4ECD, 0x65E5, 0x620E, 
    0x8338, 0x84C9, 0x8363, 0x878D, 0x7194, 0x6EB6, 0x5BB9, 0x7ED2, 0x5197, 
    0x63C9, 0x67D4, 0x8089, 0x8339, 0x8815, 0x5112, 0x5B7A, 0x5982, 0x8FB1, 
    0x4E73, 0x6C5D, 0x5165, 0x8925, 0x8F6F, 0x962E, 0x854A, 0x745E, 0x9510, 
    0x95F0, 0x6DA6, 0x82E5, 0x5F31, 0x6492, 0x6D12, 0x8428, 0x816E, 0x9CC3, 
    0x585E, 0x8D5B, 0x4E09, 0x53C1},
    {0x4F1E, 0x6563, 0x6851, 0x55D3, 0x4E27, 0x6414, 0x9A9A, 0x626B, 0x5AC2, 
    0x745F, 0x8272, 0x6DA9, 0x68EE, 0x50E7, 0x838E, 0x7802, 0x6740, 0x5239, 
    0x6C99, 0x7EB1, 0x50BB, 0x5565, 0x715E, 0x7B5B, 0x6652, 0x73CA, 0x82EB, 
    0x6749, 0x5C71, 0x5220, 0x717D, 0x886B, 0x95EA, 0x9655, 0x64C5, 0x8D61, 
    0x81B3, 0x5584, 0x6C55, 0x6247, 0x7F2E, 0x5892, 0x4F24, 0x5546, 0x8D4F, 
    0x664C, 0x4E0A, 0x5C1A, 0x88F3, 0x68A2, 0x634E, 0x7A0D, 0x70E7, 0x828D, 
    0x52FA, 0x97F6, 0x5C11, 0x54E8, 0x90B5, 0x7ECD, 0x5962, 0x8D4A, 0x86C7, 
    0x820C, 0x820D, 0x8D66, 0x6444, 0x5C04, 0x6151, 0x6D89, 0x793E, 0x8BBE, 
    0x7837, 0x7533, 0x547B, 0x4F38, 0x8EAB, 0x6DF1, 0x5A20, 0x7EC5, 0x795E, 
    0x6C88, 0x5BA1, 0x5A76, 0x751A, 0x80BE, 0x614E, 0x6E17, 0x58F0, 0x751F, 
    0x7525, 0x7272, 0x5347, 0x7EF3},
    {0x7701, 0x76DB, 0x5269, 0x80DC, 0x5723, 0x5E08, 0x5931, 0x72EE, 0x65BD, 
    0x6E7F, 0x8BD7, 0x5C38, 0x8671, 0x5341, 0x77F3, 0x62FE, 0x65F6, 0x4EC0, 
    0x98DF, 0x8680, 0x5B9E, 0x8BC6, 0x53F2, 0x77E2, 0x4F7F, 0x5C4E, 0x9A76, 
    0x59CB, 0x5F0F, 0x793A, 0x58EB, 0x4E16, 0x67FF, 0x4E8B, 0x62ED, 0x8A93, 
    0x901D, 0x52BF, 0x662F, 0x55DC, 0x566C, 0x9002, 0x4ED5, 0x4F8D, 0x91CA, 
    0x9970, 0x6C0F, 0x5E02, 0x6043, 0x5BA4, 0x89C6, 0x8BD5, 0x6536, 0x624B, 
    0x9996, 0x5B88, 0x5BFF, 0x6388, 0x552E, 0x53D7, 0x7626, 0x517D, 0x852C, 
    0x67A2, 0x68B3, 0x6B8A, 0x6292, 0x8F93, 0x53D4, 0x8212, 0x6DD1, 0x758F, 
    0x4E66, 0x8D4E, 0x5B70, 0x719F, 0x85AF, 0x6691, 0x66D9, 0x7F72, 0x8700, 
    0x9ECD, 0x9F20, 0x5C5E, 0x672F, 0x8FF0, 0x6811, 0x675F, 0x620D, 0x7AD6, 
    0x5885, 0x5EB6, 0x6570, 0x6F31},
    {0x6055, 0x5237, 0x800D, 0x6454, 0x8870, 0x7529, 0x5E05, 0x6813, 0x62F4, 
    0x971C, 0x53CC, 0x723D, 0x8C01, 0x6C34, 0x7761, 0x7A0E, 0x542E, 0x77AC, 
    0x987A, 0x821C, 0x8BF4, 0x7855, 0x6714, 0x70C1, 0x65AF, 0x6495, 0x5636, 
    0x601D, 0x79C1, 0x53F8, 0x4E1D, 0x6B7B, 0x8086, 0x5BFA, 0x55E3, 0x56DB, 
    0x4F3A, 0x4F3C, 0x9972, 0x5DF3, 0x677E, 0x8038, 0x6002, 0x9882, 0x9001, 
    0x5B8B, 0x8BBC, 0x8BF5, 0x641C, 0x8258, 0x64DE, 0x55FD, 0x82CF, 0x9165, 
    0x4FD7, 0x7D20, 0x901F, 0x7C9F, 0x50F3, 0x5851, 0x6EAF, 0x5BBF, 0x8BC9, 
    0x8083, 0x9178, 0x849C, 0x7B97, 0x867D, 0x968B, 0x968F, 0x7EE5, 0x9AD3, 
    0x788E, 0x5C81, 0x7A57, 0x9042, 0x96A7, 0x795F, 0x5B59, 0x635F, 0x7B0B, 
    0x84D1, 0x68AD, 0x5506, 0x7F29, 0x7410, 0x7D22, 0x9501, 0x6240, 0x584C, 
    0x4ED6, 0x5B83, 0x5979, 0x5854},
    {0x736D, 0x631E, 0x8E4B, 0x8E0F, 0x80CE, 0x82D4, 0x62AC, 0x53F0, 0x6CF0, 
    0x915E, 0x592A, 0x6001, 0x6C70, 0x574D, 0x644A, 0x8D2A, 0x762B, 0x6EE9, 
    0x575B, 0x6A80, 0x75F0, 0x6F6D, 0x8C2D, 0x8C08, 0x5766, 0x6BEF, 0x8892, 
    0x78B3, 0x63A2, 0x53F9, 0x70AD, 0x6C64, 0x5858, 0x642A, 0x5802, 0x68E0, 
    0x819B, 0x5510, 0x7CD6, 0x5018, 0x8EBA, 0x6DCC, 0x8D9F, 0x70EB, 0x638F, 
    0x6D9B, 0x6ED4, 0x7EE6, 0x8404, 0x6843, 0x9003, 0x6DD8, 0x9676, 0x8BA8, 
    0x5957, 0x7279, 0x85E4, 0x817E, 0x75BC, 0x8A8A, 0x68AF, 0x5254, 0x8E22, 
    0x9511, 0x63D0, 0x9898, 0x8E44, 0x557C, 0x4F53, 0x66FF, 0x568F, 0x60D5, 
    0x6D95, 0x5243, 0x5C49, 0x5929, 0x6DFB, 0x586B, 0x7530, 0x751C, 0x606C, 
    0x8214, 0x8146, 0x6311, 0x6761, 0x8FE2, 0x773A, 0x8DF3, 0x8D34, 0x94C1, 
    0x5E16, 0x5385, 0x542C, 0x70C3},
    {0x6C40, 0x5EF7, 0x505C, 0x4EAD, 0x5EAD, 0x633A, 0x8247, 0x901A, 0x6850, 
    0x916E, 0x77B3, 0x540C, 0x94DC, 0x5F64, 0x7AE5, 0x6876, 0x6345, 0x7B52, 
    0x7EDF, 0x75DB, 0x5077, 0x6295, 0x5934, 0x900F, 0x51F8, 0x79C3, 0x7A81, 
    0x56FE, 0x5F92, 0x9014, 0x6D82, 0x5C60, 0x571F, 0x5410, 0x5154, 0x6E4D, 
    0x56E2, 0x63A8, 0x9893, 0x817F, 0x8715, 0x892A, 0x9000, 0x541E, 0x5C6F, 
    0x81C0, 0x62D6, 0x6258, 0x8131, 0x9E35, 0x9640, 0x9A6E, 0x9A7C, 0x692D, 
    0x59A5, 0x62D3, 0x553E, 0x6316, 0x54C7, 0x86D9, 0x6D3C, 0x5A03, 0x74E6, 
    0x889C, 0x6B6A, 0x5916, 0x8C4C, 0x5F2F, 0x6E7E, 0x73A9, 0x987D, 0x4E38, 
    0x70F7, 0x5B8C, 0x7897, 0x633D, 0x665A, 0x7696, 0x60CB, 0x5B9B, 0x5A49, 
    0x4E07, 0x8155, 0x6C6A, 0x738B, 0x4EA1, 0x6789, 0x7F51, 0x5F80, 0x65FA, 
    0x671B, 0x5FD8, 0x5984, 0x5A01},
    {0x5DCD, 0x5FAE, 0x5371, 0x97E6, 0x8FDD, 0x6845, 0x56F4, 0x552F, 0x60DF, 
    0x4E3A, 0x6F4D, 0x7EF4, 0x82C7, 0x840E, 0x59D4, 0x4F1F, 0x4F2A, 0x5C3E, 
    0x7EAC, 0x672A, 0x851A, 0x5473, 0x754F, 0x80C3, 0x5582, 0x9B4F, 0x4F4D, 
    0x6E2D, 0x8C13, 0x5C09, 0x6170, 0x536B, 0x761F, 0x6E29, 0x868A, 0x6587, 
    0x95FB, 0x7EB9, 0x543B, 0x7A33, 0x7D0A, 0x95EE, 0x55E1, 0x7FC1, 0x74EE, 
    0x631D, 0x8717, 0x6DA1, 0x7A9D, 0x6211, 0x65A1, 0x5367, 0x63E1, 0x6C83, 
    0x5DEB, 0x545C, 0x94A8, 0x4E4C, 0x6C61, 0x8BEC, 0x5C4B, 0x65E0, 0x829C, 
    0x68A7, 0x543E, 0x5434, 0x6BCB, 0x6B66, 0x4E94, 0x6342, 0x5348, 0x821E, 
    0x4F0D, 0x4FAE, 0x575E, 0x620A, 0x96FE, 0x6664, 0x7269, 0x52FF, 0x52A1, 
    0x609F, 0x8BEF, 0x6614, 0x7199, 0x6790, 0x897F, 0x7852, 0x77FD, 0x6670, 
    0x563B, 0x5438, 0x9521, 0x727A},
    {0x7A00, 0x606F, 0x5E0C, 0x6089, 0x819D, 0x5915, 0x60DC, 0x7184, 0x70EF, 
    0x6EAA, 0x6C50, 0x7280, 0x6A84, 0x88AD, 0x5E2D, 0x4E60, 0x5AB3, 0x559C, 
    0x94E3, 0x6D17, 0x7CFB, 0x9699, 0x620F, 0x7EC6, 0x778E, 0x867E, 0x5323, 
    0x971E, 0x8F96, 0x6687, 0x5CE1, 0x4FA0, 0x72ED, 0x4E0B, 0x53A6, 0x590F, 
    0x5413, 0x6380, 0x9528, 0x5148, 0x4ED9, 0x9C9C, 0x7EA4, 0x54B8, 0x8D24, 
    0x8854, 0x8237, 0x95F2, 0x6D8E, 0x5F26, 0x5ACC, 0x663E, 0x9669, 0x73B0, 
    0x732E, 0x53BF, 0x817A, 0x9985, 0x7FA1, 0x5BAA, 0x9677, 0x9650, 0x7EBF, 
    0x76F8, 0x53A2, 0x9576, 0x9999, 0x7BB1, 0x8944, 0x6E58, 0x4E61, 0x7FD4, 
    0x7965, 0x8BE6, 0x60F3, 0x54CD, 0x4EAB, 0x9879, 0x5DF7, 0x6A61, 0x50CF, 
    0x5411, 0x8C61, 0x8427, 0x785D, 0x9704, 0x524A, 0x54EE, 0x56A3, 0x9500, 
    0x6D88, 0x5BB5, 0x6DC6, 0x6653},
    {0x5C0F, 0x5B5D, 0x6821, 0x8096, 0x5578, 0x7B11, 0x6548, 0x6954, 0x4E9B, 
    0x6B47, 0x874E, 0x978B, 0x534F, 0x631F, 0x643A, 0x90AA, 0x659C, 0x80C1, 
    0x8C10, 0x5199, 0x68B0, 0x5378, 0x87F9, 0x61C8, 0x6CC4, 0x6CFB, 0x8C22, 
    0x5C51, 0x85AA, 0x82AF, 0x950C, 0x6B23, 0x8F9B, 0x65B0, 0x5FFB, 0x5FC3, 
    0x4FE1, 0x8845, 0x661F, 0x8165, 0x7329, 0x60FA, 0x5174, 0x5211, 0x578B, 
    0x5F62, 0x90A2, 0x884C, 0x9192, 0x5E78, 0x674F, 0x6027, 0x59D3, 0x5144, 
    0x51F6, 0x80F8, 0x5308, 0x6C79, 0x96C4, 0x718A, 0x4F11, 0x4FEE, 0x7F9E, 
    0x673D, 0x55C5, 0x9508, 0x79C0, 0x8896, 0x7EE3, 0x589F, 0x620C, 0x9700, 
    0x865A, 0x5618, 0x987B, 0x5F90, 0x8BB8, 0x84C4, 0x9157, 0x53D9, 0x65ED, 
    0x5E8F, 0x755C, 0x6064, 0x7D6E, 0x5A7F, 0x7EEA, 0x7EED, 0x8F69, 0x55A7, 
    0x5BA3, 0x60AC, 0x65CB, 0x7384},
    {0x9009, 0x7663, 0x7729, 0x7EDA, 0x9774, 0x859B, 0x5B66, 0x7A74, 0x96EA, 
    0x8840, 0x52CB, 0x718F, 0x5FAA, 0x65EC, 0x8BE2, 0x5BFB, 0x9A6F, 0x5DE1, 
    0x6B89, 0x6C5B, 0x8BAD, 0x8BAF, 0x900A, 0x8FC5, 0x538B, 0x62BC, 0x9E26, 
    0x9E2D, 0x5440, 0x4E2B, 0x82BD, 0x7259, 0x869C, 0x5D16, 0x8859, 0x6DAF, 
    0x96C5, 0x54D1, 0x4E9A, 0x8BB6, 0x7109, 0x54BD, 0x9609, 0x70DF, 0x6DF9, 
    0x76D0, 0x4E25, 0x7814, 0x8712, 0x5CA9, 0x5EF6, 0x8A00, 0x989C, 0x960E, 
    0x708E, 0x6CBF, 0x5944, 0x63A9, 0x773C, 0x884D, 0x6F14, 0x8273, 0x5830, 
    0x71D5, 0x538C, 0x781A, 0x96C1, 0x5501, 0x5F66, 0x7130, 0x5BB4, 0x8C1A, 
    0x9A8C, 0x6B83, 0x592E, 0x9E2F, 0x79E7, 0x6768, 0x626C, 0x4F6F, 0x75A1, 
    0x7F8A, 0x6D0B, 0x9633, 0x6C27, 0x4EF0, 0x75D2, 0x517B, 0x6837, 0x6F3E, 
    0x9080, 0x8170, 0x5996, 0x7476},
    {0x6447, 0x5C27, 0x9065, 0x7A91, 0x8C23, 0x59DA, 0x54AC, 0x8200, 0x836F, 
    0x8981, 0x8000, 0x6930, 0x564E, 0x8036, 0x7237, 0x91CE, 0x51B6, 0x4E5F, 
    0x9875, 0x6396, 0x4E1A, 0x53F6, 0x66F3, 0x814B, 0x591C, 0x6DB2, 0x4E00, 
    0x58F9, 0x533B, 0x63D6, 0x94F1, 0x4F9D, 0x4F0A, 0x8863, 0x9890, 0x5937, 
    0x9057, 0x79FB, 0x4EEA, 0x80F0, 0x7591, 0x6C82, 0x5B9C, 0x59E8, 0x5F5D, 
    0x6905, 0x8681, 0x501A, 0x5DF2, 0x4E59, 0x77E3, 0x4EE5, 0x827A, 0x6291, 
    0x6613, 0x9091, 0x5C79, 0x4EBF, 0x5F79, 0x81C6, 0x9038, 0x8084, 0x75AB, 
    0x4EA6, 0x88D4, 0x610F, 0x6BC5, 0x5FC6, 0x4E49, 0x76CA, 0x6EA2, 0x8BE3, 
    0x8BAE, 0x8C0A, 0x8BD1, 0x5F02, 0x7FFC, 0x7FCC, 0x7ECE, 0x8335, 0x836B, 
    0x56E0, 0x6BB7, 0x97F3, 0x9634, 0x59FB, 0x541F, 0x94F6, 0x6DEB, 0x5BC5, 
    0x996E, 0x5C39, 0x5F15, 0x9690},
    {0x5370, 0x82F1, 0x6A31, 0x5A74, 0x9E70, 0x5E94, 0x7F28, 0x83B9, 0x8424, 
    0x8425, 0x8367, 0x8747, 0x8FCE, 0x8D62, 0x76C8, 0x5F71, 0x9896, 0x786C, 
    0x6620, 0x54DF, 0x62E5, 0x4F63, 0x81C3, 0x75C8, 0x5EB8, 0x96CD, 0x8E0A, 
    0x86F9, 0x548F, 0x6CF3, 0x6D8C, 0x6C38, 0x607F, 0x52C7, 0x7528, 0x5E7D, 
    0x4F18, 0x60A0, 0x5FE7, 0x5C24, 0x7531, 0x90AE, 0x94C0, 0x72B9, 0x6CB9, 
    0x6E38, 0x9149, 0x6709, 0x53CB, 0x53F3, 0x4F51, 0x91C9, 0x8BF1, 0x53C8, 
    0x5E7C, 0x8FC2, 0x6DE4, 0x4E8E, 0x76C2, 0x6986, 0x865E, 0x611A, 0x8206, 
    0x4F59, 0x4FDE, 0x903E, 0x9C7C, 0x6109, 0x6E1D, 0x6E14, 0x9685, 0x4E88, 
    0x5A31, 0x96E8, 0x4E0E, 0x5C7F, 0x79B9, 0x5B87, 0x8BED, 0x7FBD, 0x7389, 
    0x57DF, 0x828B, 0x90C1, 0x5401, 0x9047, 0x55BB, 0x5CEA, 0x5FA1, 0x6108, 
    0x6B32, 0x72F1, 0x80B2, 0x8A89},
    {0x6D74, 0x5BD3, 0x88D5, 0x9884, 0x8C6B, 0x9A6D, 0x9E33, 0x6E0A, 0x51A4, 
    0x5143, 0x57A3, 0x8881, 0x539F, 0x63F4, 0x8F95, 0x56ED, 0x5458, 0x5706, 
    0x733F, 0x6E90, 0x7F18, 0x8FDC, 0x82D1, 0x613F, 0x6028, 0x9662, 0x66F0, 
    0x7EA6, 0x8D8A, 0x8DC3, 0x94A5, 0x5CB3, 0x7CA4, 0x6708, 0x60A6, 0x9605, 
    0x8018, 0x4E91, 0x90E7, 0x5300, 0x9668, 0x5141, 0x8FD0, 0x8574, 0x915D, 
    0x6655, 0x97F5, 0x5B55, 0x531D, 0x7838, 0x6742, 0x683D, 0x54C9, 0x707E, 
    0x5BB0, 0x8F7D, 0x518D, 0x5728, 0x54B1, 0x6512, 0x6682, 0x8D5E, 0x8D43, 
    0x810F, 0x846C, 0x906D, 0x7CDF, 0x51FF, 0x85FB, 0x67A3, 0x65E9, 0x6FA1, 
    0x86A4, 0x8E81, 0x566A, 0x9020, 0x7682, 0x7076, 0x71E5, 0x8D23, 0x62E9, 
    0x5219, 0x6CFD, 0x8D3C, 0x600E, 0x589E, 0x618E, 0x66FE, 0x8D60, 0x624E, 
    0x55B3, 0x6E23, 0x672D, 0x8F67},
    {0x94E1, 0x95F8, 0x7728, 0x6805, 0x69A8, 0x548B, 0x4E4D, 0x70B8, 0x8BC8, 
    0x6458, 0x658B, 0x5B85, 0x7A84, 0x503A, 0x5BE8, 0x77BB, 0x6BE1, 0x8A79, 
    0x7C98, 0x6CBE, 0x76CF, 0x65A9, 0x8F97, 0x5D2D, 0x5C55, 0x8638, 0x6808, 
    0x5360, 0x6218, 0x7AD9, 0x6E5B, 0x7EFD, 0x6A1F, 0x7AE0, 0x5F70, 0x6F33, 
    0x5F20, 0x638C, 0x6DA8, 0x6756, 0x4E08, 0x5E10, 0x8D26, 0x4ED7, 0x80C0, 
    0x7634, 0x969C, 0x62DB, 0x662D, 0x627E, 0x6CBC, 0x8D75, 0x7167, 0x7F69, 
    0x5146, 0x8087, 0x53EC, 0x906E, 0x6298, 0x54F2, 0x86F0, 0x8F99, 0x8005, 
    0x9517, 0x8517, 0x8FD9, 0x6D59, 0x73CD, 0x659F, 0x771F, 0x7504, 0x7827, 
    0x81FB, 0x8D1E, 0x9488, 0x4FA6, 0x6795, 0x75B9, 0x8BCA, 0x9707, 0x632F, 
    0x9547, 0x9635, 0x84B8, 0x6323, 0x7741, 0x5F81, 0x72F0, 0x4E89, 0x6014, 
    0x6574, 0x62EF, 0x6B63, 0x653F},
    {0x5E27, 0x75C7, 0x90D1, 0x8BC1, 0x829D, 0x679D, 0x652F, 0x5431, 0x8718, 
    0x77E5, 0x80A2, 0x8102, 0x6C41, 0x4E4B, 0x7EC7, 0x804C, 0x76F4, 0x690D, 
    0x6B96, 0x6267, 0x503C, 0x4F84, 0x5740, 0x6307, 0x6B62, 0x8DBE, 0x53EA, 
    0x65E8, 0x7EB8, 0x5FD7, 0x631A, 0x63B7, 0x81F3, 0x81F4, 0x7F6E, 0x5E1C, 
    0x5CD9, 0x5236, 0x667A, 0x79E9, 0x7A1A, 0x8D28, 0x7099, 0x75D4, 0x6EDE, 
    0x6CBB, 0x7A92, 0x4E2D, 0x76C5, 0x5FE0, 0x949F, 0x8877, 0x7EC8, 0x79CD, 
    0x80BF, 0x91CD, 0x4EF2, 0x4F17, 0x821F, 0x5468, 0x5DDE, 0x6D32, 0x8BCC, 
    0x7CA5, 0x8F74, 0x8098, 0x5E1A, 0x5492, 0x76B1, 0x5B99, 0x663C, 0x9AA4, 
    0x73E0, 0x682A, 0x86DB, 0x6731, 0x732A, 0x8BF8, 0x8BDB, 0x9010, 0x7AF9, 
    0x70DB, 0x716E, 0x62C4, 0x77A9, 0x5631, 0x4E3B, 0x8457, 0x67F1, 0x52A9, 
    0x86C0, 0x8D2E, 0x94F8, 0x7B51},
    {0x4F4F, 0x6CE8, 0x795D, 0x9A7B, 0x6293, 0x722A, 0x62FD, 0x4E13, 0x7816, 
    0x8F6C, 0x64B0, 0x8D5A, 0x7BC6, 0x6869, 0x5E84, 0x88C5, 0x5986, 0x649E, 
    0x58EE, 0x72B6, 0x690E, 0x9525, 0x8FFD, 0x8D58, 0x5760, 0x7F00, 0x8C06, 
    0x51C6, 0x6349, 0x62D9, 0x5353, 0x684C, 0x7422, 0x8301, 0x914C, 0x5544, 
    0x7740, 0x707C, 0x6D4A, 0x5179, 0x54A8, 0x8D44, 0x59FF, 0x6ECB, 0x6DC4, 
    0x5B5C, 0x7D2B, 0x4ED4, 0x7C7D, 0x6ED3, 0x5B50, 0x81EA, 0x6E0D, 0x5B57, 
    0x9B03, 0x68D5, 0x8E2A, 0x5B97, 0x7EFC, 0x603B, 0x7EB5, 0x90B9, 0x8D70, 
    0x594F, 0x63CD, 0x79DF, 0x8DB3, 0x5352, 0x65CF, 0x7956, 0x8BC5, 0x963B, 
    0x7EC4, 0x94BB, 0x7E82, 0x5634, 0x9189, 0x6700, 0x7F6A, 0x5C0A, 0x9075, 
    0x6628, 0x5DE6, 0x4F50, 0x67DE, 0x505A, 0x4F5C, 0x5750, 0x5EA7,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    {0x4E8D, 0x4E0C, 0x5140, 0x4E10, 0x5EFF, 0x5345, 0x4E15, 0x4E98, 0x4E1E, 
    0x9B32, 0x5B6C, 0x5669, 0x4E28, 0x79BA, 0x4E3F, 0x5315, 0x4E47, 0x592D, 
    0x723B, 0x536E, 0x6C10, 0x56DF, 0x80E4, 0x9997, 0x6BD3, 0x777E, 0x9F17, 
    0x4E36, 0x4E9F, 0x9F10, 0x4E5C, 0x4E69, 0x4E93, 0x8288, 0x5B5B, 0x556C, 
    0x560F, 0x4EC4, 0x538D, 0x539D, 0x53A3, 0x53A5, 0x53AE, 0x9765, 0x8D5D, 
    0x531A, 0x53F5, 0x5326, 0x532E, 0x533E, 0x8D5C, 0x5366, 0x5363, 0x5202, 
    0x5208, 0x520E, 0x522D, 0x5233, 0x523F, 0x5240, 0x524C, 0x525E, 0x5261, 
    0x525C, 0x84AF, 0x527D, 0x5282, 0x5281, 0x5290, 0x5293, 0x5182, 0x7F54, 
    0x4EBB, 0x4EC3, 0x4EC9, 0x4EC2, 0x4EE8, 0x4EE1, 0x4EEB, 0x4EDE, 0x4F1B, 
    0x4EF3, 0x4F22, 0x4F64, 0x4EF5, 0x4F25, 0x4F27, 0x4F09, 0x4F2B, 0x4F5E, 
    0x4F67, 0x6538, 0x4F5A, 0x4F5D},
    {0x4F5F, 0x4F57, 0x4F32, 0x4F3D, 0x4F76, 0x4F74, 0x4F91, 0x4F89, 0x4F83, 
    0x4F8F, 0x4F7E, 0x4F7B, 0x4FAA, 0x4F7C, 0x4FAC, 0x4F94, 0x4FE6, 0x4FE8, 
    0x4FEA, 0x4FC5, 0x4FDA, 0x4FE3, 0x4FDC, 0x4FD1, 0x4FDF, 0x4FF8, 0x5029, 
    0x504C, 0x4FF3, 0x502C, 0x500F, 0x502E, 0x502D, 0x4FFE, 0x501C, 0x500C, 
    0x5025, 0x5028, 0x507E, 0x5043, 0x5055, 0x5048, 0x504E, 0x506C, 0x507B, 
    0x50A5, 0x50A7, 0x50A9, 0x50BA, 0x50D6, 0x5106, 0x50ED, 0x50EC, 0x50E6, 
    0x50EE, 0x5107, 0x510B, 0x4EDD, 0x6C3D, 0x4F58, 0x4F65, 0x4FCE, 0x9FA0, 
    0x6C46, 0x7C74, 0x516E, 0x5DFD, 0x9EC9, 0x9998, 0x5181, 0x5914, 0x52F9, 
    0x530D, 0x8A07, 0x5310, 0x51EB, 0x5919, 0x5155, 0x4EA0, 0x5156, 0x4EB3, 
    0x886E, 0x88A4, 0x4EB5, 0x8114, 0x88D2, 0x7980, 0x5B34, 0x8803, 0x7FB8, 
    0x51AB, 0x51B1, 0x51BD, 0x51BC},
    {0x51C7, 0x5196, 0x51A2, 0x51A5, 0x8BA0, 0x8BA6, 0x8BA7, 0x8BAA, 0x8BB4, 
    0x8BB5, 0x8BB7, 0x8BC2, 0x8BC3, 0x8BCB, 0x8BCF, 0x8BCE, 0x8BD2, 0x8BD3, 
    0x8BD4, 0x8BD6, 0x8BD8, 0x8BD9, 0x8BDC, 0x8BDF, 0x8BE0, 0x8BE4, 0x8BE8, 
    0x8BE9, 0x8BEE, 0x8BF0, 0x8BF3, 0x8BF6, 0x8BF9, 0x8BFC, 0x8BFF, 0x8C00, 
    0x8C02, 0x8C04, 0x8C07, 0x8C0C, 0x8C0F, 0x8C11, 0x8C12, 0x8C14, 0x8C15, 
    0x8C16, 0x8C19, 0x8C1B, 0x8C18, 0x8C1D, 0x8C1F, 0x8C20, 0x8C21, 0x8C25, 
    0x8C27, 0x8C2A, 0x8C2B, 0x8C2E, 0x8C2F, 0x8C32, 0x8C33, 0x8C35, 0x8C36, 
    0x5369, 0x537A, 0x961D, 0x9622, 0x9621, 0x9631, 0x962A, 0x963D, 0x963C, 
    0x9642, 0x9649, 0x9654, 0x965F, 0x9667, 0x966C, 0x9672, 0x9674, 0x9688, 
    0x968D, 0x9697, 0x96B0, 0x9097, 0x909B, 0x909D, 0x9099, 0x90AC, 0x90A1, 
    0x90B4, 0x90B3, 0x90B6, 0x90BA},
    {0x90B8, 0x90B0, 0x90CF, 0x90C5, 0x90BE, 0x90D0, 0x90C4, 0x90C7, 0x90D3, 
    0x90E6, 0x90E2, 0x90DC, 0x90D7, 0x90DB, 0x90EB, 0x90EF, 0x90FE, 0x9104, 
    0x9122, 0x911E, 0x9123, 0x9131, 0x912F, 0x9139, 0x9143, 0x9146, 0x520D, 
    0x5942, 0x52A2, 0x52AC, 0x52AD, 0x52BE, 0x54FF, 0x52D0, 0x52D6, 0x52F0, 
    0x53DF, 0x71EE, 0x77CD, 0x5EF4, 0x51F5, 0x51FC, 0x9B2F, 0x53B6, 0x5F01, 
    0x755A, 0x5DEF, 0x574C, 0x57A9, 0x57A1, 0x587E, 0x58BC, 0x58C5, 0x58D1, 
    0x5729, 0x572C, 0x572A, 0x5733, 0x5739, 0x572E, 0x572F, 0x575C, 0x573B, 
    0x5742, 0x5769, 0x5785, 0x576B, 0x5786, 0x577C, 0x577B, 0x5768, 0x576D, 
    0x5776, 0x5773, 0x57AD, 0x57A4, 0x578C, 0x57B2, 0x57CF, 0x57A7, 0x57B4, 
    0x5793, 0x57A0, 0x57D5, 0x57D8, 0x57DA, 0x57D9, 0x57D2, 0x57B8, 0x57F4, 
    0x57EF, 0x57F8, 0x57E4, 0x57DD},
    {0x580B, 0x580D, 0x57FD, 0x57ED, 0x5800, 0x581E, 0x5819, 0x5844, 0x5820, 
    0x5865, 0x586C, 0x5881, 0x5889, 0x589A, 0x5880, 0x99A8, 0x9F19, 0x61FF, 
    0x8279, 0x827D, 0x827F, 0x828F, 0x828A, 0x82A8, 0x8284, 0x828E, 0x8291, 
    0x8297, 0x8299, 0x82AB, 0x82B8, 0x82BE, 0x82B0, 0x82C8, 0x82CA, 0x82E3, 
    0x8298, 0x82B7, 0x82AE, 0x82CB, 0x82CC, 0x82C1, 0x82A9, 0x82B4, 0x82A1, 
    0x82AA, 0x829F, 0x82C4, 0x82CE, 0x82A4, 0x82E1, 0x8309, 0x82F7, 0x82E4, 
    0x830F, 0x8307, 0x82DC, 0x82F4, 0x82D2, 0x82D8, 0x830C, 0x82FB, 0x82D3, 
    0x8311, 0x831A, 0x8306, 0x8314, 0x8315, 0x82E0, 0x82D5, 0x831C, 0x8351, 
    0x835B, 0x835C, 0x8308, 0x8392, 0x833C, 0x8334, 0x8331, 0x839B, 0x835E, 
    0x832F, 0x834F, 0x8347, 0x8343, 0x835F, 0x8340, 0x8317, 0x8360, 0x832D, 
    0x833A, 0x8333, 0x8366, 0x8365},
    {0x8368, 0x831B, 0x8369, 0x836C, 0x836A, 0x836D, 0x836E, 0x83B0, 0x8378, 
    0x83B3, 0x83B4, 0x83A0, 0x83AA, 0x8393, 0x839C, 0x8385, 0x837C, 0x83B6, 
    0x83A9, 0x837D, 0x83B8, 0x837B, 0x8398, 0x839E, 0x83A8, 0x83BA, 0x83BC, 
    0x83C1, 0x8401, 0x83E5, 0x83D8, 0x5807, 0x8418, 0x840B, 0x83DD, 0x83FD, 
    0x83D6, 0x841C, 0x8438, 0x8411, 0x8406, 0x83D4, 0x83DF, 0x840F, 0x8403, 
    0x83F8, 0x83F9, 0x83EA, 0x83C5, 0x83C0, 0x8426, 0x83F0, 0x83E1, 0x845C, 
    0x8451, 0x845A, 0x8459, 0x8473, 0x8487, 0x8488, 0x847A, 0x8489, 0x8478, 
    0x843C, 0x8446, 0x8469, 0x8476, 0x848C, 0x848E, 0x8431, 0x846D, 0x84C1, 
    0x84CD, 0x84D0, 0x84E6, 0x84BD, 0x84D3, 0x84CA, 0x84BF, 0x84BA, 0x84E0, 
    0x84A1, 0x84B9, 0x84B4, 0x8497, 0x84E5, 0x84E3, 0x850C, 0x750D, 0x8538, 
    0x84F0, 0x8539, 0x851F, 0x853A},
    {0x8556, 0x853B, 0x84FF, 0x84FC, 0x8559, 0x8548, 0x8568, 0x8564, 0x855E, 
    0x857A, 0x77A2, 0x8543, 0x8572, 0x857B, 0x85A4, 0x85A8, 0x8587, 0x858F, 
    0x8579, 0x85AE, 0x859C, 0x8585, 0x85B9, 0x85B7, 0x85B0, 0x85D3, 0x85C1, 
    0x85DC, 0x85FF, 0x8627, 0x8605, 0x8629, 0x8616, 0x863C, 0x5EFE, 0x5F08, 
    0x593C, 0x5941, 0x8037, 0x5955, 0x595A, 0x5958, 0x530F, 0x5C22, 0x5C25, 
    0x5C2C, 0x5C34, 0x624C, 0x626A, 0x629F, 0x62BB, 0x62CA, 0x62DA, 0x62D7, 
    0x62EE, 0x6322, 0x62F6, 0x6339, 0x634B, 0x6343, 0x63AD, 0x63F6, 0x6371, 
    0x637A, 0x638E, 0x63B4, 0x636D, 0x63AC, 0x638A, 0x6369, 0x63AE, 0x63BC, 
    0x63F2, 0x63F8, 0x63E0, 0x63FF, 0x63C4, 0x63DE, 0x63CE, 0x6452, 0x63C6, 
    0x63BE, 0x6445, 0x6441, 0x640B, 0x641B, 0x6420, 0x640C, 0x6426, 0x6421, 
    0x645E, 0x6484, 0x646D, 0x6496},
    {0x647A, 0x64B7, 0x64B8, 0x6499, 0x64BA, 0x64C0, 0x64D0, 0x64D7, 0x64E4, 
    0x64E2, 0x6509, 0x6525, 0x652E, 0x5F0B, 0x5FD2, 0x7519, 0x5F11, 0x535F, 
    0x53F1, 0x53FD, 0x53E9, 0x53E8, 0x53FB, 0x5412, 0x5416, 0x5406, 0x544B, 
    0x5452, 0x5453, 0x5454, 0x5456, 0x5443, 0x5421, 0x5457, 0x5459, 0x5423, 
    0x5432, 0x5482, 0x5494, 0x5477, 0x5471, 0x5464, 0x549A, 0x549B, 0x5484, 
    0x5476, 0x5466, 0x549D, 0x54D0, 0x54AD, 0x54C2, 0x54B4, 0x54D2, 0x54A7, 
    0x54A6, 0x54D3, 0x54D4, 0x5472, 0x54A3, 0x54D5, 0x54BB, 0x54BF, 0x54CC, 
    0x54D9, 0x54DA, 0x54DC, 0x54A9, 0x54AA, 0x54A4, 0x54DD, 0x54CF, 0x54DE, 
    0x551B, 0x54E7, 0x5520, 0x54FD, 0x5514, 0x54F3, 0x5522, 0x5523, 0x550F, 
    0x5511, 0x5527, 0x552A, 0x5567, 0x558F, 0x55B5, 0x5549, 0x556D, 0x5541, 
    0x5555, 0x553F, 0x5550, 0x553C},
    {0x5537, 0x5556, 0x5575, 0x5576, 0x5577, 0x5533, 0x5530, 0x555C, 0x558B, 
    0x55D2, 0x5583, 0x55B1, 0x55B9, 0x5588, 0x5581, 0x559F, 0x557E, 0x55D6, 
    0x5591, 0x557B, 0x55DF, 0x55BD, 0x55BE, 0x5594, 0x5599, 0x55EA, 0x55F7, 
    0x55C9, 0x561F, 0x55D1, 0x55EB, 0x55EC, 0x55D4, 0x55E6, 0x55DD, 0x55C4, 
    0x55EF, 0x55E5, 0x55F2, 0x55F3, 0x55CC, 0x55CD, 0x55E8, 0x55F5, 0x55E4, 
    0x8F94, 0x561E, 0x5608, 0x560C, 0x5601, 0x5624, 0x5623, 0x55FE, 0x5600, 
    0x5627, 0x562D, 0x5658, 0x5639, 0x5657, 0x562C, 0x564D, 0x5662, 0x5659, 
    0x565C, 0x564C, 0x5654, 0x5686, 0x5664, 0x5671, 0x566B, 0x567B, 0x567C, 
    0x5685, 0x5693, 0x56AF, 0x56D4, 0x56D7, 0x56DD, 0x56E1, 0x56F5, 0x56EB, 
    0x56F9, 0x56FF, 0x5704, 0x570A, 0x5709, 0x571C, 0x5E0F, 0x5E19, 0x5E14, 
    0x5E11, 0x5E31, 0x5E3B, 0x5E3C},
    {0x5E37, 0x5E44, 0x5E54, 0x5E5B, 0x5E5E, 0x5E61, 0x5C8C, 0x5C7A, 0x5C8D, 
    0x5C90, 0x5C96, 0x5C88, 0x5C98, 0x5C99, 0x5C91, 0x5C9A, 0x5C9C, 0x5CB5, 
    0x5CA2, 0x5CBD, 0x5CAC, 0x5CAB, 0x5CB1, 0x5CA3, 0x5CC1, 0x5CB7, 0x5CC4, 
    0x5CD2, 0x5CE4, 0x5CCB, 0x5CE5, 0x5D02, 0x5D03, 0x5D27, 0x5D26, 0x5D2E, 
    0x5D24, 0x5D1E, 0x5D06, 0x5D1B, 0x5D58, 0x5D3E, 0x5D34, 0x5D3D, 0x5D6C, 
    0x5D5B, 0x5D6F, 0x5D5D, 0x5D6B, 0x5D4B, 0x5D4A, 0x5D69, 0x5D74, 0x5D82, 
    0x5D99, 0x5D9D, 0x8C73, 0x5DB7, 0x5DC5, 0x5F73, 0x5F77, 0x5F82, 0x5F87, 
    0x5F89, 0x5F8C, 0x5F95, 0x5F99, 0x5F9C, 0x5FA8, 0x5FAD, 0x5FB5, 0x5FBC, 
    0x8862, 0x5F61, 0x72AD, 0x72B0, 0x72B4, 0x72B7, 0x72B8, 0x72C3, 0x72C1, 
    0x72CE, 0x72CD, 0x72D2, 0x72E8, 0x72EF, 0x72E9, 0x72F2, 0x72F4, 0x72F7, 
    0x7301, 0x72F3, 0x7303, 0x72FA},
    {0x72FB, 0x7317, 0x7313, 0x7321, 0x730A, 0x731E, 0x731D, 0x7315, 0x7322, 
    0x7339, 0x7325, 0x732C, 0x7338, 0x7331, 0x7350, 0x734D, 0x7357, 0x7360, 
    0x736C, 0x736F, 0x737E, 0x821B, 0x5925, 0x98E7, 0x5924, 0x5902, 0x9963, 
    0x9967, 0x9968, 0x9969, 0x996A, 0x996B, 0x996C, 0x9974, 0x9977, 0x997D, 
    0x9980, 0x9984, 0x9987, 0x998A, 0x998D, 0x9990, 0x9991, 0x9993, 0x9994, 
    0x9995, 0x5E80, 0x5E91, 0x5E8B, 0x5E96, 0x5EA5, 0x5EA0, 0x5EB9, 0x5EB5, 
    0x5EBE, 0x5EB3, 0x8D53, 0x5ED2, 0x5ED1, 0x5EDB, 0x5EE8, 0x5EEA, 0x81BA, 
    0x5FC4, 0x5FC9, 0x5FD6, 0x5FCF, 0x6003, 0x5FEE, 0x6004, 0x5FE1, 0x5FE4, 
    0x5FFE, 0x6005, 0x6006, 0x5FEA, 0x5FED, 0x5FF8, 0x6019, 0x6035, 0x6026, 
    0x601B, 0x600F, 0x600D, 0x6029, 0x602B, 0x600A, 0x603F, 0x6021, 0x6078, 
    0x6079, 0x607B, 0x607A, 0x6042},
    {0x606A, 0x607D, 0x6096, 0x609A, 0x60AD, 0x609D, 0x6083, 0x6092, 0x608C, 
    0x609B, 0x60EC, 0x60BB, 0x60B1, 0x60DD, 0x60D8, 0x60C6, 0x60DA, 0x60B4, 
    0x6120, 0x6126, 0x6115, 0x6123, 0x60F4, 0x6100, 0x610E, 0x612B, 0x614A, 
    0x6175, 0x61AC, 0x6194, 0x61A7, 0x61B7, 0x61D4, 0x61F5, 0x5FDD, 0x96B3, 
    0x95E9, 0x95EB, 0x95F1, 0x95F3, 0x95F5, 0x95F6, 0x95FC, 0x95FE, 0x9603, 
    0x9604, 0x9606, 0x9608, 0x960A, 0x960B, 0x960C, 0x960D, 0x960F, 0x9612, 
    0x9615, 0x9616, 0x9617, 0x9619, 0x961A, 0x4E2C, 0x723F, 0x6215, 0x6C35, 
    0x6C54, 0x6C5C, 0x6C4A, 0x6CA3, 0x6C85, 0x6C90, 0x6C94, 0x6C8C, 0x6C68, 
    0x6C69, 0x6C74, 0x6C76, 0x6C86, 0x6CA9, 0x6CD0, 0x6CD4, 0x6CAD, 0x6CF7, 
    0x6CF8, 0x6CF1, 0x6CD7, 0x6CB2, 0x6CE0, 0x6CD6, 0x6CFA, 0x6CEB, 0x6CEE, 
    0x6CB1, 0x6CD3, 0x6CEF, 0x6CFE},
    {0x6D39, 0x6D27, 0x6D0C, 0x6D43, 0x6D48, 0x6D07, 0x6D04, 0x6D19, 0x6D0E, 
    0x6D2B, 0x6D4D, 0x6D2E, 0x6D35, 0x6D1A, 0x6D4F, 0x6D52, 0x6D54, 0x6D33, 
    0x6D91, 0x6D6F, 0x6D9E, 0x6DA0, 0x6D5E, 0x6D93, 0x6D94, 0x6D5C, 0x6D60, 
    0x6D7C, 0x6D63, 0x6E1A, 0x6DC7, 0x6DC5, 0x6DDE, 0x6E0E, 0x6DBF, 0x6DE0, 
    0x6E11, 0x6DE6, 0x6DDD, 0x6DD9, 0x6E16, 0x6DAB, 0x6E0C, 0x6DAE, 0x6E2B, 
    0x6E6E, 0x6E4E, 0x6E6B, 0x6EB2, 0x6E5F, 0x6E86, 0x6E53, 0x6E54, 0x6E32, 
    0x6E25, 0x6E44, 0x6EDF, 0x6EB1, 0x6E98, 0x6EE0, 0x6F2D, 0x6EE2, 0x6EA5, 
    0x6EA7, 0x6EBD, 0x6EBB, 0x6EB7, 0x6ED7, 0x6EB4, 0x6ECF, 0x6E8F, 0x6EC2, 
    0x6E9F, 0x6F62, 0x6F46, 0x6F47, 0x6F24, 0x6F15, 0x6EF9, 0x6F2F, 0x6F36, 
    0x6F4B, 0x6F74, 0x6F2A, 0x6F09, 0x6F29, 0x6F89, 0x6F8D, 0x6F8C, 0x6F78, 
    0x6F72, 0x6F7C, 0x6F7A, 0x6FD1},
    {0x6FC9, 0x6FA7, 0x6FB9, 0x6FB6, 0x6FC2, 0x6FE1, 0x6FEE, 0x6FDE, 0x6FE0, 
    0x6FEF, 0x701A, 0x7023, 0x701B, 0x7039, 0x7035, 0x704F, 0x705E, 0x5B80, 
    0x5B84, 0x5B95, 0x5B93, 0x5BA5, 0x5BB8, 0x752F, 0x9A9E, 0x6434, 0x5BE4, 
    0x5BEE, 0x8930, 0x5BF0, 0x8E47, 0x8B07, 0x8FB6, 0x8FD3, 0x8FD5, 0x8FE5, 
    0x8FEE, 0x8FE4, 0x8FE9, 0x8FE6, 0x8FF3, 0x8FE8, 0x9005, 0x9004, 0x900B, 
    0x9026, 0x9011, 0x900D, 0x9016, 0x9021, 0x9035, 0x9036, 0x902D, 0x902F, 
    0x9044, 0x9051, 0x9052, 0x9050, 0x9068, 0x9058, 0x9062, 0x905B, 0x66B9, 
    0x9074, 0x907D, 0x9082, 0x9088, 0x9083, 0x908B, 0x5F50, 0x5F57, 0x5F56, 
    0x5F58, 0x5C3B, 0x54AB, 0x5C50, 0x5C59, 0x5B71, 0x5C63, 0x5C66, 0x7FBC, 
    0x5F2A, 0x5F29, 0x5F2D, 0x8274, 0x5F3C, 0x9B3B, 0x5C6E, 0x5981, 0x5983, 
    0x598D, 0x59A9, 0x59AA, 0x59A3},
    {0x5997, 0x59CA, 0x59AB, 0x599E, 0x59A4, 0x59D2, 0x59B2, 0x59AF, 0x59D7, 
    0x59BE, 0x5A05, 0x5A06, 0x59DD, 0x5A08, 0x59E3, 0x59D8, 0x59F9, 0x5A0C, 
    0x5A09, 0x5A32, 0x5A34, 0x5A11, 0x5A23, 0x5A13, 0x5A40, 0x5A67, 0x5A4A, 
    0x5A55, 0x5A3C, 0x5A62, 0x5A75, 0x80EC, 0x5AAA, 0x5A9B, 0x5A77, 0x5A7A, 
    0x5ABE, 0x5AEB, 0x5AB2, 0x5AD2, 0x5AD4, 0x5AB8, 0x5AE0, 0x5AE3, 0x5AF1, 
    0x5AD6, 0x5AE6, 0x5AD8, 0x5ADC, 0x5B09, 0x5B17, 0x5B16, 0x5B32, 0x5B37, 
    0x5B40, 0x5C15, 0x5C1C, 0x5B5A, 0x5B65, 0x5B73, 0x5B51, 0x5B53, 0x5B62, 
    0x9A75, 0x9A77, 0x9A78, 0x9A7A, 0x9A7F, 0x9A7D, 0x9A80, 0x9A81, 0x9A85, 
    0x9A88, 0x9A8A, 0x9A90, 0x9A92, 0x9A93, 0x9A96, 0x9A98, 0x9A9B, 0x9A9C, 
    0x9A9D, 0x9A9F, 0x9AA0, 0x9AA2, 0x9AA3, 0x9AA5, 0x9AA7, 0x7E9F, 0x7EA1, 
    0x7EA3, 0x7EA5, 0x7EA8, 0x7EA9},
    {0x7EAD, 0x7EB0, 0x7EBE, 0x7EC0, 0x7EC1, 0x7EC2, 0x7EC9, 0x7ECB, 0x7ECC, 
    0x7ED0, 0x7ED4, 0x7ED7, 0x7EDB, 0x7EE0, 0x7EE1, 0x7EE8, 0x7EEB, 0x7EEE, 
    0x7EEF, 0x7EF1, 0x7EF2, 0x7F0D, 0x7EF6, 0x7EFA, 0x7EFB, 0x7EFE, 0x7F01, 
    0x7F02, 0x7F03, 0x7F07, 0x7F08, 0x7F0B, 0x7F0C, 0x7F0F, 0x7F11, 0x7F12, 
    0x7F17, 0x7F19, 0x7F1C, 0x7F1B, 0x7F1F, 0x7F21, 0x7F22, 0x7F23, 0x7F24, 
    0x7F25, 0x7F26, 0x7F27, 0x7F2A, 0x7F2B, 0x7F2C, 0x7F2D, 0x7F2F, 0x7F30, 
    0x7F31, 0x7F32, 0x7F33, 0x7F35, 0x5E7A, 0x757F, 0x5DDB, 0x753E, 0x9095, 
    0x738E, 0x7391, 0x73AE, 0x73A2, 0x739F, 0x73CF, 0x73C2, 0x73D1, 0x73B7, 
    0x73B3, 0x73C0, 0x73C9, 0x73C8, 0x73E5, 0x73D9, 0x987C, 0x740A, 0x73E9, 
    0x73E7, 0x73DE, 0x73BA, 0x73F2, 0x740F, 0x742A, 0x745B, 0x7426, 0x7425, 
    0x7428, 0x7430, 0x742E, 0x742C},
    {0x741B, 0x741A, 0x7441, 0x745C, 0x7457, 0x7455, 0x7459, 0x7477, 0x746D, 
    0x747E, 0x749C, 0x748E, 0x7480, 0x7481, 0x7487, 0x748B, 0x749E, 0x74A8, 
    0x74A9, 0x7490, 0x74A7, 0x74D2, 0x74BA, 0x97EA, 0x97EB, 0x97EC, 0x674C, 
    0x6753, 0x675E, 0x6748, 0x6769, 0x67A5, 0x6787, 0x676A, 0x6773, 0x6798, 
    0x67A7, 0x6775, 0x67A8, 0x679E, 0x67AD, 0x678B, 0x6777, 0x677C, 0x67F0, 
    0x6809, 0x67D8, 0x680A, 0x67E9, 0x67B0, 0x680C, 0x67D9, 0x67B5, 0x67DA, 
    0x67B3, 0x67DD, 0x6800, 0x67C3, 0x67B8, 0x67E2, 0x680E, 0x67C1, 0x67FD, 
    0x6832, 0x6833, 0x6860, 0x6861, 0x684E, 0x6862, 0x6844, 0x6864, 0x6883, 
    0x681D, 0x6855, 0x6866, 0x6841, 0x6867, 0x6840, 0x683E, 0x684A, 0x6849, 
    0x6829, 0x68B5, 0x688F, 0x6874, 0x6877, 0x6893, 0x686B, 0x68C2, 0x696E, 
    0x68FC, 0x691F, 0x6920, 0x68F9},
    {0x6924, 0x68F0, 0x690B, 0x6901, 0x6957, 0x68E3, 0x6910, 0x6971, 0x6939, 
    0x6960, 0x6942, 0x695D, 0x6984, 0x696B, 0x6980, 0x6998, 0x6978, 0x6934, 
    0x69CC, 0x6987, 0x6988, 0x69CE, 0x6989, 0x6966, 0x6963, 0x6979, 0x699B, 
    0x69A7, 0x69BB, 0x69AB, 0x69AD, 0x69D4, 0x69B1, 0x69C1, 0x69CA, 0x69DF, 
    0x6995, 0x69E0, 0x698D, 0x69FF, 0x6A2F, 0x69ED, 0x6A17, 0x6A18, 0x6A65, 
    0x69F2, 0x6A44, 0x6A3E, 0x6AA0, 0x6A50, 0x6A5B, 0x6A35, 0x6A8E, 0x6A79, 
    0x6A3D, 0x6A28, 0x6A58, 0x6A7C, 0x6A91, 0x6A90, 0x6AA9, 0x6A97, 0x6AAB, 
    0x7337, 0x7352, 0x6B81, 0x6B82, 0x6B87, 0x6B84, 0x6B92, 0x6B93, 0x6B8D, 
    0x6B9A, 0x6B9B, 0x6BA1, 0x6BAA, 0x8F6B, 0x8F6D, 0x8F71, 0x8F72, 0x8F73, 
    0x8F75, 0x8F76, 0x8F78, 0x8F77, 0x8F79, 0x8F7A, 0x8F7C, 0x8F7E, 0x8F81, 
    0x8F82, 0x8F84, 0x8F87, 0x8F8B},
    {0x8F8D, 0x8F8E, 0x8F8F, 0x8F98, 0x8F9A, 0x8ECE, 0x620B, 0x6217, 0x621B, 
    0x621F, 0x6222, 0x6221, 0x6225, 0x6224, 0x622C, 0x81E7, 0x74EF, 0x74F4, 
    0x74FF, 0x750F, 0x7511, 0x7513, 0x6534, 0x65EE, 0x65EF, 0x65F0, 0x660A, 
    0x6619, 0x6772, 0x6603, 0x6615, 0x6600, 0x7085, 0x66F7, 0x661D, 0x6634, 
    0x6631, 0x6636, 0x6635, 0x8006, 0x665F, 0x6654, 0x6641, 0x664F, 0x6656, 
    0x6661, 0x6657, 0x6677, 0x6684, 0x668C, 0x66A7, 0x669D, 0x66BE, 0x66DB, 
    0x66DC, 0x66E6, 0x66E9, 0x8D32, 0x8D33, 0x8D36, 0x8D3B, 0x8D3D, 0x8D40, 
    0x8D45, 0x8D46, 0x8D48, 0x8D49, 0x8D47, 0x8D4D, 0x8D55, 0x8D59, 0x89C7, 
    0x89CA, 0x89CB, 0x89CC, 0x89CE, 0x89CF, 0x89D0, 0x89D1, 0x726E, 0x729F, 
    0x725D, 0x7266, 0x726F, 0x727E, 0x727F, 0x7284, 0x728B, 0x728D, 0x728F, 
    0x7292, 0x6308, 0x6332, 0x63B0},
    {0x643F, 0x64D8, 0x8004, 0x6BEA, 0x6BF3, 0x6BFD, 0x6BF5, 0x6BF9, 0x6C05, 
    0x6C07, 0x6C06, 0x6C0D, 0x6C15, 0x6C18, 0x6C19, 0x6C1A, 0x6C21, 0x6C29, 
    0x6C24, 0x6C2A, 0x6C32, 0x6535, 0x6555, 0x656B, 0x724D, 0x7252, 0x7256, 
    0x7230, 0x8662, 0x5216, 0x809F, 0x809C, 0x8093, 0x80BC, 0x670A, 0x80BD, 
    0x80B1, 0x80AB, 0x80AD, 0x80B4, 0x80B7, 0x80E7, 0x80E8, 0x80E9, 0x80EA, 
    0x80DB, 0x80C2, 0x80C4, 0x80D9, 0x80CD, 0x80D7, 0x6710, 0x80DD, 0x80EB, 
    0x80F1, 0x80F4, 0x80ED, 0x810D, 0x810E, 0x80F2, 0x80FC, 0x6715, 0x8112, 
    0x8C5A, 0x8136, 0x811E, 0x812C, 0x8118, 0x8132, 0x8148, 0x814C, 0x8153, 
    0x8174, 0x8159, 0x815A, 0x8171, 0x8160, 0x8169, 0x817C, 0x817D, 0x816D, 
    0x8167, 0x584D, 0x5AB5, 0x8188, 0x8182, 0x8191, 0x6ED5, 0x81A3, 0x81AA, 
    0x81CC, 0x6726, 0x81CA, 0x81BB},
    {0x81C1, 0x81A6, 0x6B24, 0x6B37, 0x6B39, 0x6B43, 0x6B46, 0x6B59, 0x98D1, 
    0x98D2, 0x98D3, 0x98D5, 0x98D9, 0x98DA, 0x6BB3, 0x5F40, 0x6BC2, 0x89F3, 
    0x6590, 0x9F51, 0x6593, 0x65BC, 0x65C6, 0x65C4, 0x65C3, 0x65CC, 0x65CE, 
    0x65D2, 0x65D6, 0x7080, 0x709C, 0x7096, 0x709D, 0x70BB, 0x70C0, 0x70B7, 
    0x70AB, 0x70B1, 0x70E8, 0x70CA, 0x7110, 0x7113, 0x7116, 0x712F, 0x7131, 
    0x7173, 0x715C, 0x7168, 0x7145, 0x7172, 0x714A, 0x7178, 0x717A, 0x7198, 
    0x71B3, 0x71B5, 0x71A8, 0x71A0, 0x71E0, 0x71D4, 0x71E7, 0x71F9, 0x721D, 
    0x7228, 0x706C, 0x7118, 0x7166, 0x71B9, 0x623E, 0x623D, 0x6243, 0x6248, 
    0x6249, 0x793B, 0x7940, 0x7946, 0x7949, 0x795B, 0x795C, 0x7953, 0x795A, 
    0x7962, 0x7957, 0x7960, 0x796F, 0x7967, 0x797A, 0x7985, 0x798A, 0x799A, 
    0x79A7, 0x79B3, 0x5FD1, 0x5FD0},
    {0x603C, 0x605D, 0x605A, 0x6067, 0x6041, 0x6059, 0x6063, 0x60AB, 0x6106, 
    0x610D, 0x615D, 0x61A9, 0x619D, 0x61CB, 0x61D1, 0x6206, 0x8080, 0x807F, 
    0x6C93, 0x6CF6, 0x6DFC, 0x77F6, 0x77F8, 0x7800, 0x7809, 0x7817, 0x7818, 
    0x7811, 0x65AB, 0x782D, 0x781C, 0x781D, 0x7839, 0x783A, 0x783B, 0x781F, 
    0x783C, 0x7825, 0x782C, 0x7823, 0x7829, 0x784E, 0x786D, 0x7856, 0x7857, 
    0x7826, 0x7850, 0x7847, 0x784C, 0x786A, 0x789B, 0x7893, 0x789A, 0x7887, 
    0x789C, 0x78A1, 0x78A3, 0x78B2, 0x78B9, 0x78A5, 0x78D4, 0x78D9, 0x78C9, 
    0x78EC, 0x78F2, 0x7905, 0x78F4, 0x7913, 0x7924, 0x791E, 0x7934, 0x9F9B, 
    0x9EF9, 0x9EFB, 0x9EFC, 0x76F1, 0x7704, 0x770D, 0x76F9, 0x7707, 0x7708, 
    0x771A, 0x7722, 0x7719, 0x772D, 0x7726, 0x7735, 0x7738, 0x7750, 0x7751, 
    0x7747, 0x7743, 0x775A, 0x7768},
    {0x7762, 0x7765, 0x777F, 0x778D, 0x777D, 0x7780, 0x778C, 0x7791, 0x779F, 
    0x77A0, 0x77B0, 0x77B5, 0x77BD, 0x753A, 0x7540, 0x754E, 0x754B, 0x7548, 
    0x755B, 0x7572, 0x7579, 0x7583, 0x7F58, 0x7F61, 0x7F5F, 0x8A48, 0x7F68, 
    0x7F74, 0x7F71, 0x7F79, 0x7F81, 0x7F7E, 0x76CD, 0x76E5, 0x8832, 0x9485, 
    0x9486, 0x9487, 0x948B, 0x948A, 0x948C, 0x948D, 0x948F, 0x9490, 0x9494, 
    0x9497, 0x9495, 0x949A, 0x949B, 0x949C, 0x94A3, 0x94A4, 0x94AB, 0x94AA, 
    0x94AD, 0x94AC, 0x94AF, 0x94B0, 0x94B2, 0x94B4, 0x94B6, 0x94B7, 0x94B8, 
    0x94B9, 0x94BA, 0x94BC, 0x94BD, 0x94BF, 0x94C4, 0x94C8, 0x94C9, 0x94CA, 
    0x94CB, 0x94CC, 0x94CD, 0x94CE, 0x94D0, 0x94D1, 0x94D2, 0x94D5, 0x94D6, 
    0x94D7, 0x94D9, 0x94D8, 0x94DB, 0x94DE, 0x94DF, 0x94E0, 0x94E2, 0x94E4, 
    0x94E5, 0x94E7, 0x94E8, 0x94EA},
    {0x94E9, 0x94EB, 0x94EE, 0x94EF, 0x94F3, 0x94F4, 0x94F5, 0x94F7, 0x94F9, 
    0x94FC, 0x94FD, 0x94FF, 0x9503, 0x9502, 0x9506, 0x9507, 0x9509, 0x950A, 
    0x950D, 0x950E, 0x950F, 0x9512, 0x9513, 0x9514, 0x9515, 0x9516, 0x9518, 
    0x951B, 0x951D, 0x951E, 0x951F, 0x9522, 0x952A, 0x952B, 0x9529, 0x952C, 
    0x9531, 0x9532, 0x9534, 0x9536, 0x9537, 0x9538, 0x953C, 0x953E, 0x953F, 
    0x9542, 0x9535, 0x9544, 0x9545, 0x9546, 0x9549, 0x954C, 0x954E, 0x954F, 
    0x9552, 0x9553, 0x9554, 0x9556, 0x9557, 0x9558, 0x9559, 0x955B, 0x955E, 
    0x955F, 0x955D, 0x9561, 0x9562, 0x9564, 0x9565, 0x9566, 0x9567, 0x9568, 
    0x9569, 0x956A, 0x956B, 0x956C, 0x956F, 0x9571, 0x9572, 0x9573, 0x953A, 
    0x77E7, 0x77EC, 0x96C9, 0x79D5, 0x79ED, 0x79E3, 0x79EB, 0x7A06, 0x5D47, 
    0x7A03, 0x7A02, 0x7A1E, 0x7A14},
    {0x7A39, 0x7A37, 0x7A51, 0x9ECF, 0x99A5, 0x7A70, 0x7688, 0x768E, 0x7693, 
    0x7699, 0x76A4, 0x74DE, 0x74E0, 0x752C, 0x9E20, 0x9E22, 0x9E28, 0x9E29, 
    0x9E2A, 0x9E2B, 0x9E2C, 0x9E32, 0x9E31, 0x9E36, 0x9E38, 0x9E37, 0x9E39, 
    0x9E3A, 0x9E3E, 0x9E41, 0x9E42, 0x9E44, 0x9E46, 0x9E47, 0x9E48, 0x9E49, 
    0x9E4B, 0x9E4C, 0x9E4E, 0x9E51, 0x9E55, 0x9E57, 0x9E5A, 0x9E5B, 0x9E5C, 
    0x9E5E, 0x9E63, 0x9E66, 0x9E67, 0x9E68, 0x9E69, 0x9E6A, 0x9E6B, 0x9E6C, 
    0x9E71, 0x9E6D, 0x9E73, 0x7592, 0x7594, 0x7596, 0x75A0, 0x759D, 0x75AC, 
    0x75A3, 0x75B3, 0x75B4, 0x75B8, 0x75C4, 0x75B1, 0x75B0, 0x75C3, 0x75C2, 
    0x75D6, 0x75CD, 0x75E3, 0x75E8, 0x75E6, 0x75E4, 0x75EB, 0x75E7, 0x7603, 
    0x75F1, 0x75FC, 0x75FF, 0x7610, 0x7600, 0x7605, 0x760C, 0x7617, 0x760A, 
    0x7625, 0x7618, 0x7615, 0x7619},
    {0x761B, 0x763C, 0x7622, 0x7620, 0x7640, 0x762D, 0x7630, 0x763F, 0x7635, 
    0x7643, 0x763E, 0x7633, 0x764D, 0x765E, 0x7654, 0x765C, 0x7656, 0x766B, 
    0x766F, 0x7FCA, 0x7AE6, 0x7A78, 0x7A79, 0x7A80, 0x7A86, 0x7A88, 0x7A95, 
    0x7AA6, 0x7AA0, 0x7AAC, 0x7AA8, 0x7AAD, 0x7AB3, 0x8864, 0x8869, 0x8872, 
    0x887D, 0x887F, 0x8882, 0x88A2, 0x88C6, 0x88B7, 0x88BC, 0x88C9, 0x88E2, 
    0x88CE, 0x88E3, 0x88E5, 0x88F1, 0x891A, 0x88FC, 0x88E8, 0x88FE, 0x88F0, 
    0x8921, 0x8919, 0x8913, 0x891B, 0x890A, 0x8934, 0x892B, 0x8936, 0x8941, 
    0x8966, 0x897B, 0x758B, 0x80E5, 0x76B2, 0x76B4, 0x77DC, 0x8012, 0x8014, 
    0x8016, 0x801C, 0x8020, 0x8022, 0x8025, 0x8026, 0x8027, 0x8029, 0x8028, 
    0x8031, 0x800B, 0x8035, 0x8043, 0x8046, 0x804D, 0x8052, 0x8069, 0x8071, 
    0x8983, 0x9878, 0x9880, 0x9883},
    {0x9889, 0x988C, 0x988D, 0x988F, 0x9894, 0x989A, 0x989B, 0x989E, 0x989F, 
    0x98A1, 0x98A2, 0x98A5, 0x98A6, 0x864D, 0x8654, 0x866C, 0x866E, 0x867F, 
    0x867A, 0x867C, 0x867B, 0x86A8, 0x868D, 0x868B, 0x86AC, 0x869D, 0x86A7, 
    0x86A3, 0x86AA, 0x8693, 0x86A9, 0x86B6, 0x86C4, 0x86B5, 0x86CE, 0x86B0, 
    0x86BA, 0x86B1, 0x86AF, 0x86C9, 0x86CF, 0x86B4, 0x86E9, 0x86F1, 0x86F2, 
    0x86ED, 0x86F3, 0x86D0, 0x8713, 0x86DE, 0x86F4, 0x86DF, 0x86D8, 0x86D1, 
    0x8703, 0x8707, 0x86F8, 0x8708, 0x870A, 0x870D, 0x8709, 0x8723, 0x873B, 
    0x871E, 0x8725, 0x872E, 0x871A, 0x873E, 0x8748, 0x8734, 0x8731, 0x8729, 
    0x8737, 0x873F, 0x8782, 0x8722, 0x877D, 0x877E, 0x877B, 0x8760, 0x8770, 
    0x874C, 0x876E, 0x878B, 0x8753, 0x8763, 0x877C, 0x8764, 0x8759, 0x8765, 
    0x8793, 0x87AF, 0x87A8, 0x87D2},
    {0x87C6, 0x8788, 0x8785, 0x87AD, 0x8797, 0x8783, 0x87AB, 0x87E5, 0x87AC, 
    0x87B5, 0x87B3, 0x87CB, 0x87D3, 0x87BD, 0x87D1, 0x87C0, 0x87CA, 0x87DB, 
    0x87EA, 0x87E0, 0x87EE, 0x8816, 0x8813, 0x87FE, 0x880A, 0x881B, 0x8821, 
    0x8839, 0x883C, 0x7F36, 0x7F42, 0x7F44, 0x7F45, 0x8210, 0x7AFA, 0x7AFD, 
    0x7B08, 0x7B03, 0x7B04, 0x7B15, 0x7B0A, 0x7B2B, 0x7B0F, 0x7B47, 0x7B38, 
    0x7B2A, 0x7B19, 0x7B2E, 0x7B31, 0x7B20, 0x7B25, 0x7B24, 0x7B33, 0x7B3E, 
    0x7B1E, 0x7B58, 0x7B5A, 0x7B45, 0x7B75, 0x7B4C, 0x7B5D, 0x7B60, 0x7B6E, 
    0x7B7B, 0x7B62, 0x7B72, 0x7B71, 0x7B90, 0x7BA6, 0x7BA7, 0x7BB8, 0x7BAC, 
    0x7B9D, 0x7BA8, 0x7B85, 0x7BAA, 0x7B9C, 0x7BA2, 0x7BAB, 0x7BB4, 0x7BD1, 
    0x7BC1, 0x7BCC, 0x7BDD, 0x7BDA, 0x7BE5, 0x7BE6, 0x7BEA, 0x7C0C, 0x7BFE, 
    0x7BFC, 0x7C0F, 0x7C16, 0x7C0B},
    {0x7C1F, 0x7C2A, 0x7C26, 0x7C38, 0x7C41, 0x7C40, 0x81FE, 0x8201, 0x8202, 
    0x8204, 0x81EC, 0x8844, 0x8221, 0x8222, 0x8223, 0x822D, 0x822F, 0x8228, 
    0x822B, 0x8238, 0x823B, 0x8233, 0x8234, 0x823E, 0x8244, 0x8249, 0x824B, 
    0x824F, 0x825A, 0x825F, 0x8268, 0x887E, 0x8885, 0x8888, 0x88D8, 0x88DF, 
    0x895E, 0x7F9D, 0x7F9F, 0x7FA7, 0x7FAF, 0x7FB0, 0x7FB2, 0x7C7C, 0x6549, 
    0x7C91, 0x7C9D, 0x7C9C, 0x7C9E, 0x7CA2, 0x7CB2, 0x7CBC, 0x7CBD, 0x7CC1, 
    0x7CC7, 0x7CCC, 0x7CCD, 0x7CC8, 0x7CC5, 0x7CD7, 0x7CE8, 0x826E, 0x66A8, 
    0x7FBF, 0x7FCE, 0x7FD5, 0x7FE5, 0x7FE1, 0x7FE6, 0x7FE9, 0x7FEE, 0x7FF3, 
    0x7CF8, 0x7D77, 0x7DA6, 0x7DAE, 0x7E47, 0x7E9B, 0x9EB8, 0x9EB4, 0x8D73, 
    0x8D84, 0x8D94, 0x8D91, 0x8DB1, 0x8D67, 0x8D6D, 0x8C47, 0x8C49, 0x914A, 
    0x9150, 0x914E, 0x914F, 0x9164},
    {0x9162, 0x9161, 0x9170, 0x9169, 0x916F, 0x917D, 0x917E, 0x9172, 0x9174, 
    0x9179, 0x918C, 0x9185, 0x9190, 0x918D, 0x9191, 0x91A2, 0x91A3, 0x91AA, 
    0x91AD, 0x91AE, 0x91AF, 0x91B5, 0x91B4, 0x91BA, 0x8C55, 0x9E7E, 0x8DB8, 
    0x8DEB, 0x8E05, 0x8E59, 0x8E69, 0x8DB5, 0x8DBF, 0x8DBC, 0x8DBA, 0x8DC4, 
    0x8DD6, 0x8DD7, 0x8DDA, 0x8DDE, 0x8DCE, 0x8DCF, 0x8DDB, 0x8DC6, 0x8DEC, 
    0x8DF7, 0x8DF8, 0x8DE3, 0x8DF9, 0x8DFB, 0x8DE4, 0x8E09, 0x8DFD, 0x8E14, 
    0x8E1D, 0x8E1F, 0x8E2C, 0x8E2E, 0x8E23, 0x8E2F, 0x8E3A, 0x8E40, 0x8E39, 
    0x8E35, 0x8E3D, 0x8E31, 0x8E49, 0x8E41, 0x8E42, 0x8E51, 0x8E52, 0x8E4A, 
    0x8E70, 0x8E76, 0x8E7C, 0x8E6F, 0x8E74, 0x8E85, 0x8E8F, 0x8E94, 0x8E90, 
    0x8E9C, 0x8E9E, 0x8C78, 0x8C82, 0x8C8A, 0x8C85, 0x8C98, 0x8C94, 0x659B, 
    0x89D6, 0x89DE, 0x89DA, 0x89DC},
    {0x89E5, 0x89EB, 0x89EF, 0x8A3E, 0x8B26, 0x9753, 0x96E9, 0x96F3, 0x96EF, 
    0x9706, 0x9701, 0x9708, 0x970F, 0x970E, 0x972A, 0x972D, 0x9730, 0x973E, 
    0x9F80, 0x9F83, 0x9F85, 0x9F86, 0x9F87, 0x9F88, 0x9F89, 0x9F8A, 0x9F8C, 
    0x9EFE, 0x9F0B, 0x9F0D, 0x96B9, 0x96BC, 0x96BD, 0x96CE, 0x96D2, 0x77BF, 
    0x96E0, 0x928E, 0x92AE, 0x92C8, 0x933E, 0x936A, 0x93CA, 0x938F, 0x943E, 
    0x946B, 0x9C7F, 0x9C82, 0x9C85, 0x9C86, 0x9C87, 0x9C88, 0x7A23, 0x9C8B, 
    0x9C8E, 0x9C90, 0x9C91, 0x9C92, 0x9C94, 0x9C95, 0x9C9A, 0x9C9B, 0x9C9E, 
    0x9C9F, 0x9CA0, 0x9CA1, 0x9CA2, 0x9CA3, 0x9CA5, 0x9CA6, 0x9CA7, 0x9CA8, 
    0x9CA9, 0x9CAB, 0x9CAD, 0x9CAE, 0x9CB0, 0x9CB1, 0x9CB2, 0x9CB3, 0x9CB4, 
    0x9CB5, 0x9CB6, 0x9CB7, 0x9CBA, 0x9CBB, 0x9CBC, 0x9CBD, 0x9CC4, 0x9CC5, 
    0x9CC6, 0x9CC7, 0x9CCA, 0x9CCB},
    {0x9CCC, 0x9CCD, 0x9CCE, 0x9CCF, 0x9CD0, 0x9CD3, 0x9CD4, 0x9CD5, 0x9CD7, 
    0x9CD8, 0x9CD9, 0x9CDC, 0x9CDD, 0x9CDF, 0x9CE2, 0x977C, 0x9785, 0x9791, 
    0x9792, 0x9794, 0x97AF, 0x97AB, 0x97A3, 0x97B2, 0x97B4, 0x9AB1, 0x9AB0, 
    0x9AB7, 0x9E58, 0x9AB6, 0x9ABA, 0x9ABC, 0x9AC1, 0x9AC0, 0x9AC5, 0x9AC2, 
    0x9ACB, 0x9ACC, 0x9AD1, 0x9B45, 0x9B43, 0x9B47, 0x9B49, 0x9B48, 0x9B4D, 
    0x9B51, 0x98E8, 0x990D, 0x992E, 0x9955, 0x9954, 0x9ADF, 0x9AE1, 0x9AE6, 
    0x9AEF, 0x9AEB, 0x9AFB, 0x9AED, 0x9AF9, 0x9B08, 0x9B0F, 0x9B13, 0x9B1F, 
    0x9B23, 0x9EBD, 0x9EBE, 0x7E3B, 0x9E82, 0x9E87, 0x9E88, 0x9E8B, 0x9E92, 
    0x93D6, 0x9E9D, 0x9E9F, 0x9EDB, 0x9EDC, 0x9EDD, 0x9EE0, 0x9EDF, 0x9EE2, 
    0x9EE9, 0x9EE7, 0x9EE5, 0x9EEA, 0x9EEF, 0x9F22, 0x9F2C, 0x9F2F, 0x9F39, 
    0x9F37, 0x9F3D, 0x9F3E, 0x9F44},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
};

/*
 * Mapping from Unicode back to GB2312.
 * 
 * This inverse is done the same way the SBCS ones are done: I
 * provide a list of GB2312 positions, sorted into ascending
 * order of their Unicode values. Then we can binary-search through
 * this list, referring to the above table for each comparison, to
 * find the coordinates for a given code point.
 * 
 * Generated by running the following sh+Perl over GB2312.TXT:

cat GB2312.TXT | \
perl -ne '$a{$3}=[hex$1,hex$2] if /^0x(\S\S)(\S\S)\s+(0x\S+)\s/;' \
      -e 'END {$o="    ";for $k (sort keys %a) { ($r,$c) = @{$a{$k}}; ' \
      -e '$o .= $C; $C = ", "; (print "$o\n"), $o="    " if length $o > 70;' \
      -e '$o .= sprintf "{%d,%d}", $r-33,$c-33; } print "$o\n"; }'

 */

static const struct { unsigned char r, c; } gb2312_backward[] = {
    {0,71}, {0,75}, {0,6}, {0,66}, {0,31}, {0,32}, {7,3}, {7,1}, {7,7}, 
    {7,5}, {7,25}, {7,11}, {7,9}, {7,15}, {7,13}, {0,33}, {7,19}, {7,17}, 
    {7,24}, {7,0}, {7,4}, {7,6}, {7,8}, {7,12}, {7,16}, {7,2}, {7,10}, 
    {7,14}, {7,18}, {7,20}, {7,21}, {7,22}, {7,23}, {0,5}, {0,4}, {5,0}, 
    {5,1}, {5,2}, {5,3}, {5,4}, {5,5}, {5,6}, {5,7}, {5,8}, {5,9}, {5,10}, 
    {5,11}, {5,12}, {5,13}, {5,14}, {5,15}, {5,16}, {5,17}, {5,18}, {5,19}, 
    {5,20}, {5,21}, {5,22}, {5,23}, {5,32}, {5,33}, {5,34}, {5,35}, {5,36}, 
    {5,37}, {5,38}, {5,39}, {5,40}, {5,41}, {5,42}, {5,43}, {5,44}, {5,45}, 
    {5,46}, {5,47}, {5,48}, {5,49}, {5,50}, {5,51}, {5,52}, {5,53}, {5,54}, 
    {5,55}, {6,6}, {6,0}, {6,1}, {6,2}, {6,3}, {6,4}, {6,5}, {6,7}, {6,8}, 
    {6,9}, {6,10}, {6,11}, {6,12}, {6,13}, {6,14}, {6,15}, {6,16}, {6,17}, 
    {6,18}, {6,19}, {6,20}, {6,21}, {6,22}, {6,23}, {6,24}, {6,25}, {6,26}, 
    {6,27}, {6,28}, {6,29}, {6,30}, {6,31}, {6,32}, {6,48}, {6,49}, {6,50}, 
    {6,51}, {6,52}, {6,53}, {6,55}, {6,56}, {6,57}, {6,58}, {6,59}, {6,60}, 
    {6,61}, {6,62}, {6,63}, {6,64}, {6,65}, {6,66}, {6,67}, {6,68}, {6,69}, 
    {6,70}, {6,71}, {6,72}, {6,73}, {6,74}, {6,75}, {6,76}, {6,77}, {6,78}, 
    {6,79}, {6,80}, {6,54}, {0,9}, {0,11}, {0,13}, {0,14}, {0,15}, {0,16}, 
    {0,12}, {0,74}, {0,67}, {0,68}, {0,88}, {0,69}, {0,76}, {1,80}, {1,81}, 
    {1,82}, {1,83}, {1,84}, {1,85}, {1,86}, {1,87}, {1,88}, {1,89}, {1,90}, 
    {1,91}, {0,90}, {0,91}, {0,89}, {0,92}, {0,41}, {0,38}, {0,37}, {0,43}, 
    {0,55}, {0,61}, {0,46}, {0,45}, {0,35}, {0,36}, {0,40}, {0,39}, {0,49}, 
    {0,50}, {0,63}, {0,62}, {0,34}, {0,42}, {0,54}, {0,53}, {0,52}, {0,56}, 
    {0,51}, {0,59}, {0,60}, {0,57}, {0,58}, {0,48}, {0,44}, {0,47}, {1,56}, 
    {1,57}, {1,58}, {1,59}, {1,60}, {1,61}, {1,62}, {1,63}, {1,64}, {1,65}, 
    {1,36}, {1,37}, {1,38}, {1,39}, {1,40}, {1,41}, {1,42}, {1,43}, {1,44}, 
    {1,45}, {1,46}, {1,47}, {1,48}, {1,49}, {1,50}, {1,51}, {1,52}, {1,53}, 
    {1,54}, {1,55}, {1,16}, {1,17}, {1,18}, {1,19}, {1,20}, {1,21}, {1,22}, 
    {1,23}, {1,24}, {1,25}, {1,26}, {1,27}, {1,28}, {1,29}, {1,30}, {1,31}, 
    {1,32}, {1,33}, {1,34}, {1,35}, {8,3}, {8,4}, {8,5}, {8,6}, {8,7}, 
    {8,8}, {8,9}, {8,10}, {8,11}, {8,12}, {8,13}, {8,14}, {8,15}, {8,16}, 
    {8,17}, {8,18}, {8,19}, {8,20}, {8,21}, {8,22}, {8,23}, {8,24}, {8,25}, 
    {8,26}, {8,27}, {8,28}, {8,29}, {8,30}, {8,31}, {8,32}, {8,33}, {8,34}, 
    {8,35}, {8,36}, {8,37}, {8,38}, {8,39}, {8,40}, {8,41}, {8,42}, {8,43}, 
    {8,44}, {8,45}, {8,46}, {8,47}, {8,48}, {8,49}, {8,50}, {8,51}, {8,52}, 
    {8,53}, {8,54}, {8,55}, {8,56}, {8,57}, {8,58}, {8,59}, {8,60}, {8,61}, 
    {8,62}, {8,63}, {8,64}, {8,65}, {8,66}, {8,67}, {8,68}, {8,69}, {8,70}, 
    {8,71}, {8,72}, {8,73}, {8,74}, {8,75}, {8,76}, {8,77}, {8,78}, {0,85}, 
    {0,84}, {0,87}, {0,86}, {0,83}, {0,82}, {0,79}, {0,81}, {0,80}, {0,78}, 
    {0,77}, {0,65}, {0,64}, {0,0}, {0,1}, {0,2}, {0,7}, {0,8}, {0,19}, 
    {0,20}, {0,21}, {0,22}, {0,23}, {0,24}, {0,25}, {0,26}, {0,29}, {0,30}, 
    {0,93}, {0,17}, {0,18}, {0,27}, {0,28}, {3,0}, {3,1}, {3,2}, {3,3}, 
    {3,4}, {3,5}, {3,6}, {3,7}, {3,8}, {3,9}, {3,10}, {3,11}, {3,12}, {3,13}, 
    {3,14}, {3,15}, {3,16}, {3,17}, {3,18}, {3,19}, {3,20}, {3,21}, {3,22}, 
    {3,23}, {3,24}, {3,25}, {3,26}, {3,27}, {3,28}, {3,29}, {3,30}, {3,31}, 
    {3,32}, {3,33}, {3,34}, {3,35}, {3,36}, {3,37}, {3,38}, {3,39}, {3,40}, 
    {3,41}, {3,42}, {3,43}, {3,44}, {3,45}, {3,46}, {3,47}, {3,48}, {3,49}, 
    {3,50}, {3,51}, {3,52}, {3,53}, {3,54}, {3,55}, {3,56}, {3,57}, {3,58}, 
    {3,59}, {3,60}, {3,61}, {3,62}, {3,63}, {3,64}, {3,65}, {3,66}, {3,67}, 
    {3,68}, {3,69}, {3,70}, {3,71}, {3,72}, {3,73}, {3,74}, {3,75}, {3,76}, 
    {3,77}, {3,78}, {3,79}, {3,80}, {3,81}, {3,82}, {4,0}, {4,1}, {4,2}, 
    {4,3}, {4,4}, {4,5}, {4,6}, {4,7}, {4,8}, {4,9}, {4,10}, {4,11}, {4,12}, 
    {4,13}, {4,14}, {4,15}, {4,16}, {4,17}, {4,18}, {4,19}, {4,20}, {4,21}, 
    {4,22}, {4,23}, {4,24}, {4,25}, {4,26}, {4,27}, {4,28}, {4,29}, {4,30}, 
    {4,31}, {4,32}, {4,33}, {4,34}, {4,35}, {4,36}, {4,37}, {4,38}, {4,39}, 
    {4,40}, {4,41}, {4,42}, {4,43}, {4,44}, {4,45}, {4,46}, {4,47}, {4,48}, 
    {4,49}, {4,50}, {4,51}, {4,52}, {4,53}, {4,54}, {4,55}, {4,56}, {4,57}, 
    {4,58}, {4,59}, {4,60}, {4,61}, {4,62}, {4,63}, {4,64}, {4,65}, {4,66}, 
    {4,67}, {4,68}, {4,69}, {4,70}, {4,71}, {4,72}, {4,73}, {4,74}, {4,75}, 
    {4,76}, {4,77}, {4,78}, {4,79}, {4,80}, {4,81}, {4,82}, {4,83}, {4,84}, 
    {4,85}, {0,3}, {7,36}, {7,37}, {7,38}, {7,39}, {7,40}, {7,41}, {7,42}, 
    {7,43}, {7,44}, {7,45}, {7,46}, {7,47}, {7,48}, {7,49}, {7,50}, {7,51}, 
    {7,52}, {7,53}, {7,54}, {7,55}, {7,56}, {7,57}, {7,58}, {7,59}, {7,60}, 
    {7,61}, {7,62}, {7,63}, {7,64}, {7,65}, {7,66}, {7,67}, {7,68}, {7,69}, 
    {7,70}, {7,71}, {7,72}, {1,68}, {1,69}, {1,70}, {1,71}, {1,72}, {1,73}, 
    {1,74}, {1,75}, {1,76}, {1,77}, {49,26}, {21,0}, {37,62}, {44,81}, 
    {52,40}, {39,92}, {40,46}, {46,33}, {55,1}, {17,26}, {50,74}, {55,3}, 
    {18,82}, {54,7}, {38,49}, {55,6}, {41,31}, {38,79}, {16,90}, {49,20}, 
    {19,51}, {21,10}, {42,30}, {55,8}, {21,9}, {32,28}, {48,46}, {40,4}, 
    {55,12}, {23,85}, {48,29}, {66,59}, {53,47}, {22,64}, {19,13}, {32,56}, 
    {55,27}, {44,71}, {20,3}, {45,9}, {53,86}, {31,85}, {29,56}, {55,14}, 
    {35,42}, {29,34}, {55,16}, {34,19}, {49,68}, {53,13}, {45,57}, {52,6}, 
    {25,84}, {22,5}, {31,53}, {37,24}, {36,49}, {38,38}, {24,51}, {18,42}, 
    {49,49}, {55,30}, {29,36}, {37,81}, {49,17}, {46,15}, {46,70}, {41,72}, 
    {55,31}, {33,81}, {33,49}, {39,72}, {38,11}, {32,42}, {50,71}, {52,88}, 
    {41,33}, {21,93}, {55,0}, {50,57}, {30,86}, {51,37}, {26,4}, {55,32}, 
    {45,68}, {29,13}, {55,7}, {48,38}, {47,8}, {55,28}, {56,78}, {44,85}, 
    {30,25}, {28,26}, {25,4}, {49,63}, {17,89}, {25,63}, {35,21}, {46,76}, 
    {29,8}, {44,3}, {32,32}, {38,54}, {56,80}, {56,83}, {39,42}, {55,72}, 
    {49,57}, {41,17}, {39,41}, {55,75}, {55,73}, {55,37}, {28,85}, {37,44}, 
    {18,79}, {55,74}, {28,80}, {28,72}, {39,51}, {19,50}, {33,55}, {17,53}, 
    {54,47}, {41,42}, {42,90}, {52,43}, {23,21}, {46,40}, {56,57}, {55,79}, 
    {38,9}, {55,77}, {19,89}, {32,77}, {49,51}, {55,76}, {49,38}, {55,78}, 
    {34,38}, {48,85}, {53,56}, {55,81}, {55,84}, {27,93}, {27,58}, {39,45}, 
    {22,60}, {22,33}, {37,82}, {55,87}, {49,32}, {45,72}, {27,30}, {22,91}, 
    {22,4}, {47,60}, {53,57}, {50,36}, {26,78}, {26,64}, {55,80}, {40,0}, 
    {45,15}, {19,10}, {55,82}, {40,42}, {55,85}, {33,54}, {55,86}, {45,16}, 
    {55,88}, {17,13}, {24,31}, {56,2}, {15,72}, {32,69}, {40,75}, {42,36}, 
    {42,37}, {56,3}, {20,71}, {20,10}, {45,26}, {20,44}, {54,0}, {54,83}, 
    {50,50}, {43,68}, {25,45}, {56,1}, {56,59}, {50,63}, {55,92}, {22,79}, 
    {54,86}, {55,93}, {55,89}, {56,0}, {35,66}, {50,21}, {55,83}, {56,60}, 
    {55,90}, {36,68}, {31,47}, {48,79}, {15,58}, {27,48}, {56,5}, {56,4}, 
    {56,11}, {56,13}, {56,10}, {41,24}, {56,8}, {53,21}, {18,61}, {56,7}, 
    {31,92}, {41,43}, {56,9}, {56,6}, {56,15}, {21,16}, {24,8}, {49,31}, 
    {46,31}, {33,33}, {28,35}, {52,75}, {17,63}, {38,39}, {30,74}, {56,12}, 
    {56,14}, {45,73}, {25,77}, {38,53}, {16,66}, {19,56}, {21,76}, {56,19}, 
    {30,0}, {56,61}, {38,45}, {31,93}, {56,23}, {42,54}, {22,92}, {56,20}, 
    {56,22}, {16,2}, {50,64}, {56,24}, {47,36}, {56,21}, {56,16}, {56,17}, 
    {32,8}, {56,18}, {27,82}, {47,61}, {23,8}, {29,66}, {56,28}, {56,25}, 
    {15,18}, {56,33}, {56,35}, {16,21}, {56,30}, {20,24}, {29,82}, {43,39}, 
    {25,81}, {49,47}, {56,34}, {28,71}, {18,10}, {56,36}, {29,74}, {56,37}, 
    {56,26}, {35,62}, {56,29}, {56,32}, {56,31}, {52,13}, {53,20}, {38,66}, 
    {56,39}, {27,56}, {56,41}, {56,27}, {56,42}, {37,10}, {56,40}, {54,85}, 
    {44,2}, {28,0}, {56,43}, {36,27}, {44,20}, {56,44}, {56,38}, {18,4}, 
    {30,93}, {23,20}, {31,91}, {15,87}, {19,85}, {56,45}, {56,46}, {19,1}, 
    {56,47}, {19,62}, {15,32}, {56,48}, {40,20}, {46,80}, {56,49}, {32,36}, 
    {56,53}, {40,13}, {56,52}, {56,51}, {56,54}, {42,58}, {28,8}, {37,6}, 
    {56,50}, {56,55}, {56,56}, {39,68}, {31,59}, {21,88}, {55,2}, {51,41}, 
    {51,9}, {47,53}, {18,67}, {52,54}, {46,39}, {24,65}, {30,42}, {34,65}, 
    {21,49}, {44,34}, {56,77}, {56,79}, {20,18}, {21,20}, {29,3}, {39,74}, 
    {39,10}, {15,42}, {24,10}, {32,88}, {56,65}, {31,27}, {24,17}, {24,55}, 
    {47,42}, {16,87}, {37,67}, {29,62}, {20,67}, {54,39}, {48,87}, {27,69}, 
    {41,61}, {27,28}, {56,69}, {55,70}, {35,57}, {23,51}, {39,28}, {17,64}, 
    {51,56}, {34,15}, {34,64}, {57,1}, {39,62}, {47,19}, {29,91}, {36,8}, 
    {24,57}, {57,2}, {51,8}, {57,3}, {56,90}, {21,11}, {22,74}, {16,88}, 
    {56,91}, {18,68}, {29,85}, {30,85}, {49,16}, {31,67}, {21,18}, {56,93}, 
    {56,92}, {29,26}, {37,63}, {54,27}, {57,0}, {32,24}, {20,81}, {32,71}, 
    {27,84}, {19,52}, {32,60}, {35,92}, {27,23}, {22,17}, {22,78}, {56,75}, 
    {37,29}, {30,12}, {26,42}, {20,41}, {58,40}, {47,54}, {44,24}, {15,27}, 
    {18,85}, {26,86}, {58,41}, {25,14}, {51,67}, {20,21}, {20,82}, {55,53}, 
    {39,47}, {22,53}, {38,47}, {55,54}, {30,14}, {58,26}, {55,55}, {47,43}, 
    {26,13}, {74,29}, {32,47}, {32,84}, {51,81}, {23,52}, {19,19}, {18,84}, 
    {40,29}, {36,47}, {36,56}, {31,90}, {16,79}, {55,56}, {24,45}, {20,28}, 
    {55,57}, {53,37}, {42,1}, {39,14}, {40,17}, {19,43}, {30,43}, {24,83}, 
    {55,58}, {55,59}, {21,70}, {27,32}, {43,73}, {46,86}, {55,60}, {38,15}, 
    {24,47}, {28,2}, {43,61}, {37,41}, {55,63}, {55,61}, {55,62}, {15,93}, 
    {29,70}, {41,2}, {27,83}, {23,16}, {23,77}, {55,65}, {28,42}, {55,67}, 
    {55,66}, {36,91}, {55,68}, {55,69}, {32,5}, {39,15}, {15,75}, {24,5}, 
    {27,50}, {45,80}, {58,28}, {32,50}, {21,14}, {53,89}, {36,11}, {28,56}, 
    {58,29}, {58,30}, {31,87}, {29,1}, {31,44}, {58,31}, {41,37}, {17,9}, 
    {50,33}, {34,66}, {48,10}, {58,33}, {31,52}, {58,34}, {30,16}, {35,27}, 
    {38,57}, {58,35}, {56,71}, {40,54}, {24,19}, {45,79}, {51,39}, {15,91}, 
    {19,49}, {47,56}, {56,72}, {61,42}, {56,74}, {55,15}, {26,14}, {16,16}, 
    {18,54}, {55,45}, {51,48}, {28,18}, {30,78}, {46,26}, {55,47}, {22,42}, 
    {55,48}, {37,4}, {38,87}, {49,28}, {55,49}, {35,67}, {41,13}, {38,6}, 
    {55,5}, {40,92}, {45,70}, {26,59}, {15,74}, {26,9}, {47,12}, {16,15}, 
    {54,67}, {54,30}, {20,4}, {33,83}, {35,46}, {17,8}, {17,22}, {16,68}, 
    {62,17}, {52,27}, {30,7}, {33,11}, {55,52}, {33,16}, {55,51}, {45,51}, 
    {57,63}, {45,31}, {55,19}, {34,13}, {50,0}, {45,2}, {27,19}, {39,19}, 
    {33,48}, {29,76}, {47,21}, {57,64}, {38,67}, {18,6}, {21,81}, {43,91}, 
    {31,89}, {31,86}, {48,24}, {48,64}, {55,38}, {17,61}, {31,68}, {25,80}, 
    {55,39}, {51,12}, {46,64}, {55,40}, {55,41}, {46,34}, {18,87}, {29,38}, 
    {55,42}, {58,43}, {39,4}, {46,55}, {39,93}, {17,45}, {50,53}, {17,69}, 
    {27,15}, {50,48}, {42,10}, {22,19}, {22,1}, {41,68}, {39,0}, {41,59}, 
    {16,67}, {47,79}, {36,48}, {58,36}, {20,93}, {30,57}, {24,36}, {29,67}, 
    {32,76}, {62,21}, {62,20}, {53,26}, {28,47}, {52,56}, {15,39}, {21,2}, 
    {30,40}, {43,7}, {62,18}, {41,22}, {50,49}, {55,46}, {49,21}, {25,36}, 
    {42,29}, {43,29}, {62,22}, {20,79}, {62,19}, {50,84}, {18,51}, {23,86}, 
    {62,25}, {25,46}, {27,9}, {20,84}, {44,11}, {34,90}, {25,82}, {31,83}, 
    {44,33}, {46,81}, {62,23}, {46,36}, {33,31}, {62,24}, {33,79}, {29,92}, 
    {32,62}, {44,43}, {49,86}, {22,44}, {62,32}, {62,35}, {22,80}, {15,40}, 
    {21,53}, {22,51}, {25,11}, {43,92}, {30,51}, {42,16}, {37,83}, {53,7}, 
    {62,36}, {45,65}, {18,18}, {45,91}, {19,20}, {45,38}, {25,79}, {45,64}, 
    {48,28}, {62,31}, {19,83}, {18,41}, {23,69}, {62,26}, {35,36}, {62,27}, 
    {62,28}, {62,29}, {36,26}, {62,30}, {62,33}, {51,16}, {62,34}, {38,25}, 
    {45,55}, {35,55}, {62,41}, {62,46}, {53,59}, {62,40}, {62,57}, {45,21}, 
    {25,38}, {62,45}, {62,39}, {36,61}, {40,74}, {25,83}, {34,91}, {29,54}, 
    {62,37}, {62,44}, {36,55}, {52,5}, {25,44}, {29,43}, {50,28}, {23,31}, 
    {53,67}, {62,38}, {24,29}, {30,6}, {32,91}, {62,42}, {62,43}, {62,47}, 
    {62,58}, {62,68}, {62,54}, {62,53}, {54,40}, {62,66}, {62,67}, {68,74}, 
    {49,6}, {62,49}, {30,8}, {51,58}, {30,39}, {62,51}, {46,43}, {62,60}, 
    {48,41}, {62,61}, {15,6}, {37,22}, {62,50}, {25,68}, {21,62}, {44,58}, 
    {24,93}, {51,52}, {62,62}, {46,75}, {15,4}, {62,70}, {62,48}, {48,37}, 
    {62,52}, {62,55}, {62,56}, {62,59}, {26,8}, {62,63}, {62,64}, {62,65}, 
    {62,69}, {62,71}, {50,19}, {23,70}, {36,21}, {62,73}, {40,57}, {32,7}, 
    {35,35}, {30,61}, {46,87}, {52,59}, {62,77}, {17,23}, {25,62}, {62,75}, 
    {58,32}, {48,67}, {42,83}, {19,28}, {15,5}, {62,80}, {43,37}, {62,81}, 
    {62,76}, {62,72}, {62,74}, {62,78}, {62,79}, {26,28}, {62,82}, {62,83}, 
    {26,2}, {41,58}, {45,7}, {63,6}, {18,9}, {63,5}, {63,0}, {62,93}, {44,56}, 
    {62,91}, {62,89}, {30,47}, {54,35}, {40,43}, {62,87}, {15,0}, {62,92}, 
    {62,90}, {63,1}, {63,7}, {22,39}, {37,0}, {40,21}, {31,17}, {62,84}, 
    {36,29}, {55,35}, {62,88}, {35,85}, {63,2}, {63,3}, {63,4}, {47,4}, 
    {63,19}, {43,67}, {63,16}, {30,5}, {63,14}, {45,24}, {63,10}, {40,37}, 
    {31,13}, {63,13}, {25,76}, {25,15}, {63,8}, {62,85}, {63,18}, {63,23}, 
    {19,12}, {63,24}, {46,17}, {25,39}, {63,15}, {47,89}, {63,11}, {51,90}, 
    {62,86}, {36,70}, {63,12}, {50,86}, {63,21}, {63,22}, {63,35}, {47,64}, 
    {63,27}, {63,40}, {63,41}, {63,29}, {63,9}, {40,3}, {63,32}, {63,17}, 
    {41,39}, {63,34}, {63,20}, {45,42}, {42,34}, {63,44}, {63,37}, {63,33}, 
    {63,42}, {63,25}, {63,30}, {63,31}, {63,36}, {63,38}, {63,39}, {63,43}, 
    {63,26}, {42,51}, {63,52}, {63,53}, {63,49}, {63,47}, {27,45}, {63,48}, 
    {23,33}, {55,36}, {47,73}, {33,78}, {63,46}, {63,28}, {63,51}, {63,50}, 
    {63,54}, {63,59}, {63,55}, {53,85}, {18,15}, {54,75}, {42,26}, {63,57}, 
    {45,90}, {25,56}, {63,64}, {63,60}, {49,12}, {63,65}, {63,58}, {63,56}, 
    {63,62}, {63,63}, {63,61}, {63,67}, {37,86}, {55,11}, {51,74}, {63,69}, 
    {41,40}, {63,68}, {23,32}, {63,70}, {63,71}, {63,72}, {63,66}, {25,30}, 
    {43,70}, {63,73}, {46,88}, {63,74}, {39,33}, {28,31}, {35,49}, {63,75}, 
    {63,76}, {38,83}, {42,35}, {63,77}, {26,55}, {55,21}, {49,81}, {63,78}, 
    {44,36}, {21,57}, {63,80}, {51,15}, {31,6}, {19,48}, {45,6}, {63,79}, 
    {63,81}, {24,43}, {24,89}, {44,27}, {63,82}, {37,51}, {63,83}, {51,17}, 
    {39,5}, {63,85}, {63,84}, {63,86}, {44,32}, {41,4}, {51,57}, {58,54}, 
    {58,56}, {58,55}, {24,70}, {58,59}, {58,60}, {20,55}, {58,57}, {58,58}, 
    {18,0}, {58,62}, {26,87}, {53,22}, {58,63}, {29,88}, {22,26}, {58,47}, 
    {43,13}, {30,17}, {26,20}, {54,87}, {30,50}, {30,72}, {27,64}, {43,18}, 
    {58,61}, {15,50}, {45,74}, {22,55}, {54,24}, {37,33}, {31,3}, {43,24}, 
    {58,70}, {58,64}, {37,25}, {58,66}, {58,71}, {36,86}, {58,73}, {58,72}, 
    {30,31}, {58,69}, {58,68}, {19,24}, {31,11}, {33,1}, {58,65}, {58,67}, 
    {47,44}, {58,76}, {31,60}, {58,81}, {21,65}, {58,82}, {58,49}, {24,23}, 
    {51,10}, {58,75}, {30,48}, {58,79}, {58,48}, {20,69}, {58,74}, {30,68}, 
    {58,77}, {58,80}, {58,88}, {24,0}, {15,2}, {33,80}, {18,38}, {58,78}, 
    {58,87}, {37,49}, {58,83}, {58,84}, {58,86}, {58,85}, {58,93}, {50,81}, 
    {17,25}, {58,92}, {59,3}, {58,90}, {58,89}, {58,91}, {36,63}, {26,88}, 
    {59,2}, {59,4}, {43,34}, {21,48}, {60,31}, {59,0}, {59,1}, {38,20}, 
    {21,72}, {59,6}, {59,5}, {59,8}, {16,3}, {20,43}, {30,15}, {48,62}, 
    {21,33}, {59,7}, {42,89}, {74,82}, {42,59}, {42,93}, {43,32}, {39,90}, 
    {59,9}, {43,77}, {59,10}, {58,50}, {59,14}, {59,11}, {29,18}, {41,90}, 
    {59,12}, {40,41}, {35,24}, {38,28}, {59,13}, {51,85}, {47,69}, {35,10}, 
    {21,52}, {58,51}, {16,57}, {58,52}, {58,53}, {25,29}, {39,31}, {41,30}, 
    {39,40}, {54,18}, {40,88}, {30,38}, {25,87}, {49,27}, {65,25}, {19,5}, 
    {16,23}, {23,19}, {46,35}, {56,70}, {46,5}, {44,65}, {56,76}, {21,63}, 
    {49,24}, {24,26}, {65,24}, {65,22}, {19,82}, {43,75}, {43,10}, {22,81}, 
    {55,17}, {48,74}, {25,26}, {41,6}, {44,22}, {49,35}, {30,67}, {27,47}, 
    {21,64}, {61,36}, {61,37}, {58,27}, {48,56}, {37,69}, {35,45}, {22,77}, 
    {22,59}, {30,91}, {54,63}, {37,84}, {16,27}, {61,39}, {28,16}, {43,54}, 
    {61,41}, {61,40}, {20,75}, {40,60}, {15,33}, {36,13}, {36,10}, {35,43}, 
    {27,72}, {42,92}, {25,34}, {68,88}, {39,70}, {68,89}, {44,92}, {54,16}, 
    {23,29}, {33,71}, {39,48}, {68,90}, {21,41}, {27,42}, {48,92}, {69,0}, 
    {34,77}, {69,3}, {68,93}, {69,4}, {44,54}, {22,32}, {68,91}, {68,92}, 
    {69,2}, {35,60}, {69,7}, {69,6}, {34,34}, {37,61}, {69,9}, {35,22}, 
    {69,1}, {41,27}, {28,66}, {24,34}, {69,5}, {47,52}, {45,14}, {69,8}, 
    {69,15}, {49,5}, {28,9}, {69,12}, {69,14}, {31,48}, {49,43}, {27,6}, 
    {69,16}, {49,85}, {54,42}, {44,93}, {44,61}, {33,5}, {69,10}, {69,11}, 
    {28,30}, {69,13}, {69,18}, {69,17}, {69,21}, {69,23}, {35,78}, {35,39}, 
    {29,73}, {40,78}, {69,22}, {21,79}, {34,67}, {50,72}, {69,19}, {69,20}, 
    {39,1}, {69,28}, {69,24}, {37,36}, {44,80}, {69,26}, {69,27}, {26,72}, 
    {69,29}, {69,25}, {31,22}, {50,3}, {69,30}, {40,83}, {69,34}, {69,35}, 
    {47,85}, {34,28}, {34,35}, {69,33}, {69,32}, {69,38}, {46,16}, {74,83}, 
    {69,41}, {69,36}, {27,61}, {40,8}, {27,20}, {46,50}, {69,39}, {69,40}, 
    {69,45}, {69,47}, {69,48}, {69,42}, {20,52}, {69,43}, {69,46}, {35,58}, 
    {69,37}, {69,44}, {69,49}, {69,51}, {69,50}, {69,52}, {56,87}, {69,53}, 
    {69,54}, {54,50}, {69,60}, {69,61}, {30,54}, {51,47}, {54,53}, {19,69}, 
    {42,78}, {69,57}, {55,34}, {54,45}, {47,1}, {34,46}, {69,62}, {27,29}, 
    {24,33}, {69,58}, {48,6}, {25,1}, {33,46}, {55,10}, {41,74}, {68,77}, 
    {69,59}, {22,84}, {39,69}, {35,84}, {68,17}, {35,93}, {42,91}, {68,18}, 
    {52,11}, {50,77}, {41,55}, {15,17}, {42,45}, {44,73}, {25,73}, {68,20}, 
    {68,19}, {54,57}, {24,56}, {53,69}, {21,7}, {44,79}, {49,42}, {16,5}, 
    {41,20}, {18,71}, {40,82}, {30,44}, {47,90}, {41,49}, {68,21}, {26,33}, 
    {46,59}, {24,11}, {51,54}, {25,5}, {48,70}, {46,91}, {27,49}, {68,22}, 
    {39,60}, {30,76}, {16,85}, {42,61}, {27,36}, {27,35}, {49,89}, {34,59}, 
    {30,59}, {23,26}, {34,33}, {25,13}, {51,1}, {38,61}, {35,14}, {17,75}, 
    {24,48}, {68,26}, {32,39}, {52,14}, {68,27}, {68,29}, {19,70}, {21,51}, 
    {42,33}, {48,15}, {20,27}, {41,56}, {22,65}, {40,67}, {28,10}, {45,29}, 
    {54,79}, {47,0}, {40,56}, {21,90}, {69,55}, {27,65}, {18,29}, {40,47}, 
    {69,56}, {18,1}, {61,43}, {50,39}, {61,44}, {49,1}, {61,45}, {29,44}, 
    {61,46}, {41,11}, {49,91}, {18,62}, {68,73}, {35,64}, {29,0}, {45,17}, 
    {35,81}, {29,53}, {37,7}, {17,66}, {29,50}, {38,91}, {43,74}, {28,75}, 
    {45,60}, {41,25}, {37,32}, {68,75}, {47,27}, {52,24}, {68,76}, {41,83}, 
    {44,31}, {33,36}, {68,78}, {33,35}, {68,79}, {68,87}, {44,44}, {40,28}, 
    {49,56}, {64,7}, {50,75}, {42,73}, {37,80}, {64,11}, {64,6}, {64,8}, 
    {64,9}, {64,14}, {17,76}, {64,10}, {23,57}, {64,12}, {64,13}, {64,15}, 
    {20,25}, {64,16}, {64,18}, {64,23}, {48,49}, {64,21}, {64,20}, {32,74}, 
    {64,22}, {51,31}, {64,17}, {64,25}, {15,21}, {64,19}, {30,88}, {64,24}, 
    {64,26}, {64,29}, {64,27}, {53,36}, {46,30}, {64,28}, {64,30}, {33,44}, 
    {21,74}, {50,87}, {38,44}, {22,68}, {29,93}, {64,31}, {64,32}, {64,38}, 
    {18,70}, {37,72}, {19,61}, {48,33}, {64,39}, {64,37}, {64,36}, {64,34}, 
    {64,33}, {16,31}, {52,23}, {64,35}, {64,42}, {64,43}, {64,41}, {78,89}, 
    {64,50}, {64,49}, {38,21}, {64,40}, {64,45}, {64,47}, {64,51}, {64,48}, 
    {64,44}, {64,46}, {64,52}, {64,53}, {64,54}, {64,55}, {64,57}, {64,58}, 
    {45,0}, {70,60}, {19,7}, {53,60}, {48,17}, {18,17}, {24,3}, {54,82}, 
    {38,40}, {29,61}, {24,13}, {45,54}, {17,77}, {58,46}, {27,25}, {49,48}, 
    {42,39}, {15,44}, {46,78}, {56,66}, {28,76}, {16,49}, {41,47}, {17,27}, 
    {42,6}, {22,10}, {41,5}, {46,2}, {63,87}, {52,41}, {63,90}, {63,89}, 
    {36,32}, {43,90}, {32,16}, {63,88}, {53,66}, {17,14}, {53,35}, {20,58}, 
    {19,87}, {53,0}, {46,14}, {15,78}, {63,91}, {64,0}, {18,2}, {63,92}, 
    {63,93}, {34,16}, {34,60}, {64,1}, {22,88}, {26,46}, {64,2}, {35,26}, 
    {64,3}, {64,4}, {64,5}, {19,16}, {23,40}, {37,28}, {35,73}, {17,1}, 
    {47,49}, {70,58}, {26,34}, {50,54}, {50,35}, {24,66}, {65,46}, {54,14}, 
    {38,75}, {16,50}, {19,17}, {65,48}, {47,81}, {33,13}, {65,47}, {30,65}, 
    {50,5}, {20,54}, {65,49}, {20,73}, {34,76}, {23,92}, {23,13}, {36,50}, 
    {22,46}, {65,51}, {65,50}, {21,39}, {54,88}, {44,4}, {65,55}, {65,53}, 
    {41,91}, {30,20}, {50,24}, {65,52}, {65,54}, {32,13}, {31,39}, {65,58}, 
    {65,57}, {31,9}, {32,45}, {65,59}, {65,60}, {65,61}, {58,39}, {48,50}, 
    {44,1}, {28,7}, {61,34}, {55,4}, {30,9}, {58,44}, {49,75}, {37,89}, 
    {36,9}, {61,35}, {16,54}, {62,13}, {41,28}, {62,16}, {24,12}, {49,92}, 
    {23,4}, {25,74}, {18,57}, {20,59}, {52,36}, {34,53}, {46,49}, {26,0}, 
    {68,82}, {68,81}, {68,83}, {44,67}, {39,84}, {20,14}, {38,30}, {68,85}, 
    {75,15}, {68,69}, {24,72}, {20,16}, {33,27}, {68,71}, {68,70}, {68,72}, 
    {49,44}, {64,73}, {47,45}, {44,13}, {48,68}, {17,41}, {16,74}, {16,81}, 
    {36,76}, {52,34}, {50,15}, {64,59}, {64,60}, {49,58}, {18,24}, {16,42}, 
    {44,88}, {52,86}, {64,61}, {29,21}, {19,92}, {64,62}, {25,59}, {64,63}, 
    {26,17}, {33,40}, {64,64}, {47,75}, {44,28}, {64,65}, {20,34}, {36,38}, 
    {64,66}, {64,67}, {50,88}, {64,68}, {48,12}, {64,69}, {45,1}, {64,70}, 
    {20,33}, {64,71}, {26,52}, {47,35}, {65,63}, {16,55}, {49,67}, {65,64}, 
    {27,40}, {39,43}, {65,66}, {75,93}, {75,92}, {62,14}, {65,65}, {53,29}, 
    {44,91}, {34,5}, {66,34}, {53,49}, {65,70}, {65,71}, {50,38}, {65,75}, 
    {30,75}, {65,76}, {65,68}, {18,31}, {35,77}, {65,77}, {47,34}, {25,85}, 
    {65,72}, {22,61}, {26,18}, {43,11}, {42,42}, {65,67}, {65,69}, {65,73}, 
    {65,74}, {65,86}, {65,83}, {51,84}, {65,82}, {36,12}, {52,89}, {36,33}, 
    {17,31}, {65,78}, {65,81}, {32,14}, {42,27}, {20,0}, {65,88}, {27,16}, 
    {65,80}, {47,51}, {51,24}, {65,84}, {24,53}, {65,85}, {38,50}, {65,79}, 
    {54,59}, {76,0}, {65,87}, {76,4}, {65,93}, {41,48}, {32,20}, {26,47}, 
    {30,53}, {25,66}, {42,0}, {76,5}, {76,2}, {76,1}, {26,53}, {76,6}, 
    {47,83}, {76,3}, {25,61}, {21,86}, {66,0}, {21,17}, {43,80}, {24,6}, 
    {46,1}, {38,0}, {30,49}, {21,80}, {65,89}, {65,90}, {65,92}, {65,91}, 
    {35,52}, {66,1}, {50,32}, {66,6}, {38,35}, {46,3}, {66,8}, {25,22}, 
    {66,7}, {26,57}, {66,2}, {66,3}, {66,9}, {66,5}, {45,81}, {50,37}, 
    {26,27}, {51,34}, {35,89}, {76,7}, {47,91}, {66,4}, {34,84}, {66,12}, 
    {16,14}, {66,17}, {27,33}, {66,11}, {20,30}, {38,72}, {66,15}, {29,9}, 
    {44,78}, {26,82}, {43,71}, {66,14}, {66,16}, {46,6}, {66,13}, {45,8}, 
    {26,60}, {20,74}, {29,68}, {17,49}, {18,44}, {16,24}, {66,10}, {17,48}, 
    {20,11}, {24,62}, {21,71}, {46,74}, {66,22}, {26,43}, {39,38}, {47,41}, 
    {66,23}, {18,77}, {76,8}, {50,89}, {50,67}, {76,9}, {66,24}, {49,65}, 
    {66,20}, {50,61}, {23,47}, {66,18}, {66,21}, {22,62}, {66,19}, {31,1}, 
    {66,25}, {51,23}, {19,39}, {66,26}, {26,36}, {40,86}, {40,68}, {35,28}, 
    {76,10}, {33,92}, {26,58}, {30,13}, {45,30}, {66,27}, {30,21}, {16,78}, 
    {51,86}, {66,29}, {76,12}, {66,30}, {25,8}, {76,11}, {66,28}, {66,31}, 
    {25,21}, {21,13}, {47,23}, {15,34}, {76,13}, {76,14}, {31,32}, {66,32}, 
    {36,18}, {66,33}, {59,17}, {76,15}, {23,73}, {45,75}, {73,6}, {47,70}, 
    {41,88}, {39,53}, {46,22}, {18,40}, {45,49}, {28,67}, {66,61}, {26,81}, 
    {73,7}, {52,28}, {37,60}, {73,8}, {73,9}, {73,11}, {73,10}, {73,13}, 
    {73,12}, {28,55}, {73,14}, {33,29}, {19,32}, {19,86}, {26,6}, {75,69}, 
    {75,68}, {22,30}, {42,88}, {16,65}, {75,70}, {40,39}, {75,71}, {75,72}, 
    {41,53}, {61,47}, {17,36}, {51,89}, {37,42}, {15,38}, {19,81}, {39,50}, 
    {44,47}, {30,23}, {30,58}, {38,3}, {53,19}, {31,8}, {61,48}, {40,7}, 
    {48,78}, {36,3}, {15,70}, {18,21}, {39,36}, {15,65}, {22,85}, {36,89}, 
    {21,82}, {52,49}, {18,47}, {27,27}, {18,12}, {29,80}, {15,48}, {49,53}, 
    {41,66}, {54,4}, {44,21}, {21,21}, {30,24}, {52,58}, {23,6}, {36,54}, 
    {61,49}, {30,56}, {33,52}, {38,31}, {26,3}, {16,7}, {36,73}, {36,90}, 
    {43,6}, {16,6}, {20,53}, {35,7}, {61,50}, {48,25}, {18,72}, {34,81}, 
    {22,86}, {53,83}, {20,2}, {17,79}, {35,19}, {35,72}, {31,12}, {61,51}, 
    {15,71}, {36,35}, {32,63}, {24,52}, {29,59}, {44,55}, {15,45}, {44,46}, 
    {61,53}, {29,47}, {54,29}, {61,52}, {52,47}, {15,60}, {35,65}, {33,2}, 
    {27,79}, {50,20}, {31,24}, {36,0}, {17,5}, {51,80}, {31,7}, {41,34}, 
    {61,54}, {52,91}, {24,15}, {39,12}, {42,8}, {61,56}, {30,28}, {37,19}, 
    {54,6}, {41,15}, {35,34}, {18,53}, {24,49}, {53,23}, {73,91}, {15,19}, 
    {30,69}, {43,83}, {44,57}, {53,30}, {33,45}, {45,45}, {43,1}, {47,13}, 
    {35,50}, {20,17}, {61,55}, {52,84}, {27,22}, {26,50}, {15,3}, {36,17}, 
    {19,75}, {52,80}, {73,92}, {61,57}, {44,5}, {44,75}, {45,69}, {61,59}, 
    {44,16}, {31,5}, {54,28}, {61,58}, {15,37}, {25,19}, {40,50}, {35,82}, 
    {29,71}, {17,21}, {31,43}, {42,79}, {27,80}, {26,26}, {20,22}, {36,84}, 
    {61,69}, {61,66}, {29,60}, {61,62}, {19,22}, {28,60}, {61,63}, {35,76}, 
    {46,37}, {20,63}, {21,61}, {41,57}, {20,83}, {61,68}, {52,37}, {61,64}, 
    {43,44}, {37,93}, {36,36}, {49,19}, {29,81}, {33,50}, {43,28}, {18,23}, 
    {28,50}, {30,55}, {44,37}, {48,57}, {19,74}, {61,67}, {61,60}, {61,70}, 
    {73,93}, {33,15}, {61,65}, {53,31}, {20,6}, {17,83}, {61,71}, {61,81}, 
    {61,76}, {61,80}, {39,63}, {54,64}, {61,78}, {34,71}, {43,64}, {17,68}, 
    {49,29}, {61,77}, {61,74}, {45,52}, {19,6}, {30,10}, {29,29}, {28,49}, 
    {61,72}, {51,13}, {61,61}, {61,73}, {31,30}, {61,75}, {17,82}, {23,72}, 
    {33,6}, {28,32}, {61,84}, {61,87}, {17,10}, {19,3}, {19,73}, {40,5}, 
    {61,85}, {42,48}, {23,66}, {61,86}, {61,89}, {61,88}, {43,33}, {15,64}, 
    {19,77}, {68,25}, {47,14}, {17,74}, {74,0}, {61,83}, {40,66}, {61,82}, 
    {15,57}, {49,0}, {16,86}, {43,14}, {61,79}, {42,3}, {52,9}, {61,90}, 
    {19,60}, {35,5}, {61,92}, {34,93}, {35,0}, {62,0}, {32,43}, {61,91}, 
    {29,78}, {37,17}, {18,36}, {39,85}, {42,25}, {61,93}, {62,3}, {54,17}, 
    {18,22}, {32,34}, {38,42}, {17,4}, {19,72}, {54,10}, {35,75}, {62,1}, 
    {62,2}, {62,4}, {25,18}, {62,5}, {31,61}, {40,34}, {17,56}, {38,69}, 
    {62,6}, {38,59}, {62,7}, {74,1}, {42,50}, {62,9}, {62,8}, {17,32}, 
    {36,41}, {62,10}, {51,59}, {39,32}, {62,11}, {29,79}, {62,12}, {53,6}, 
    {73,22}, {74,21}, {41,52}, {55,91}, {23,35}, {24,4}, {22,36}, {52,93}, 
    {24,41}, {47,6}, {83,44}, {20,47}, {34,83}, {29,39}, {74,22}, {15,28}, 
    {28,43}, {32,17}, {16,53}, {18,7}, {23,49}, {40,1}, {21,55}, {74,23}, 
    {29,19}, {41,92}, {38,34}, {52,90}, {22,82}, {45,35}, {52,10}, {16,82}, 
    {75,18}, {15,62}, {75,20}, {21,22}, {32,46}, {84,89}, {47,16}, {52,68}, 
    {45,50}, {28,78}, {18,65}, {23,10}, {52,21}, {76,28}, {21,46}, {42,24}, 
    {47,33}, {22,28}, {75,21}, {41,8}, {36,51}, {75,24}, {75,23}, {33,34}, 
    {75,22}, {47,92}, {75,25}, {75,26}, {54,68}, {75,27}, {75,28}, {37,75}, 
    {45,61}, {27,39}, {39,52}, {20,8}, {29,40}, {53,27}, {51,70}, {48,13}, 
    {47,80}, {73,23}, {73,24}, {73,25}, {25,20}, {41,16}, {30,84}, {44,89}, 
    {73,31}, {15,25}, {73,29}, {31,4}, {73,26}, {17,92}, {34,86}, {26,71}, 
    {49,54}, {45,83}, {73,30}, {73,27}, {73,34}, {47,38}, {50,18}, {19,25}, 
    {34,32}, {54,81}, {52,48}, {41,38}, {73,36}, {73,35}, {73,38}, {73,37}, 
    {53,70}, {46,51}, {73,42}, {26,45}, {28,89}, {40,45}, {73,43}, {40,24}, 
    {46,93}, {73,41}, {51,45}, {73,44}, {73,46}, {44,76}, {73,40}, {73,45}, 
    {45,77}, {26,61}, {18,30}, {37,52}, {29,15}, {45,89}, {38,70}, {29,6}, 
    {73,47}, {53,38}, {32,31}, {51,60}, {73,48}, {46,29}, {73,49}, {41,77}, 
    {36,14}, {15,20}, {73,51}, {73,50}, {83,62}, {35,25}, {16,8}, {68,62}, 
    {73,52}, {41,78}, {73,53}, {73,54}, {37,55}, {73,55}, {73,56}, {51,26}, 
    {38,89}, {49,22}, {23,91}, {73,33}, {17,59}, {33,91}, {51,87}, {43,69}, 
    {54,77}, {51,33}, {50,47}, {74,34}, {36,82}, {22,93}, {74,51}, {42,22}, 
    {74,61}, {31,41}, {44,90}, {18,14}, {37,57}, {74,91}, {35,29}, {45,19}, 
    {35,8}, {16,29}, {51,92}, {41,84}, {53,75}, {37,50}, {21,67}, {26,89}, 
    {47,63}, {40,16}, {51,50}, {39,7}, {23,42}, {71,29}, {40,27}, {71,26}, 
    {31,77}, {47,50}, {17,35}, {19,68}, {71,27}, {52,39}, {21,36}, {71,28}, 
    {41,87}, {23,59}, {43,84}, {31,19}, {48,77}, {71,30}, {71,33}, {25,27}, 
    {16,12}, {28,59}, {73,28}, {71,34}, {71,37}, {71,42}, {71,43}, {42,40}, 
    {15,68}, {27,10}, {24,24}, {71,32}, {44,86}, {71,41}, {45,85}, {52,76}, 
    {32,53}, {71,35}, {34,21}, {24,90}, {53,5}, {71,39}, {41,63}, {51,69}, 
    {71,31}, {71,36}, {71,38}, {38,24}, {22,66}, {71,40}, {30,60}, {71,49}, 
    {71,54}, {71,52}, {27,59}, {27,46}, {71,58}, {71,61}, {71,57}, {16,89}, 
    {15,55}, {35,18}, {23,43}, {37,65}, {39,29}, {39,64}, {71,46}, {71,51}, 
    {71,53}, {24,80}, {71,55}, {54,84}, {35,90}, {71,59}, {17,72}, {71,48}, 
    {27,76}, {30,33}, {71,44}, {53,88}, {32,87}, {17,80}, {71,62}, {41,32}, 
    {71,56}, {52,3}, {16,73}, {52,26}, {71,45}, {71,47}, {21,15}, {71,50}, 
    {71,60}, {31,23}, {41,86}, {42,7}, {37,59}, {31,84}, {71,72}, {47,2}, 
    {71,81}, {53,73}, {71,63}, {71,64}, {48,88}, {25,42}, {23,88}, {23,80}, 
    {51,51}, {71,78}, {71,77}, {71,75}, {24,79}, {43,49}, {71,69}, {45,5}, 
    {30,81}, {15,23}, {71,80}, {71,79}, {54,31}, {71,67}, {44,8}, {40,2}, 
    {26,23}, {28,58}, {71,73}, {71,65}, {71,66}, {71,68}, {20,20}, {71,70}, 
    {38,36}, {71,74}, {71,76}, {28,15}, {54,13}, {71,87}, {71,84}, {44,15}, 
    {71,85}, {32,25}, {71,71}, {34,22}, {15,79}, {71,83}, {71,86}, {24,2}, 
    {40,49}, {34,45}, {45,63}, {31,69}, {42,82}, {43,60}, {47,20}, {41,64}, 
    {71,82}, {27,75}, {71,88}, {34,61}, {37,68}, {24,86}, {15,83}, {54,55}, 
    {27,11}, {36,78}, {43,35}, {72,5}, {40,12}, {72,1}, {31,65}, {30,34}, 
    {71,93}, {24,54}, {71,90}, {72,3}, {49,45}, {72,2}, {53,17}, {54,20}, 
    {72,6}, {28,22}, {71,91}, {71,92}, {72,0}, {44,53}, {49,11}, {72,17}, 
    {72,8}, {19,9}, {19,26}, {72,10}, {47,7}, {72,4}, {18,93}, {72,11}, 
    {31,66}, {72,9}, {72,24}, {72,23}, {72,13}, {71,89}, {72,7}, {30,11}, 
    {72,16}, {72,25}, {33,4}, {72,14}, {23,36}, {72,12}, {50,59}, {72,19}, 
    {72,20}, {72,22}, {72,38}, {31,37}, {72,36}, {72,15}, {72,26}, {15,80}, 
    {72,27}, {52,4}, {72,29}, {72,30}, {72,32}, {32,80}, {39,21}, {72,28}, 
    {72,33}, {72,34}, {72,18}, {72,21}, {26,16}, {72,31}, {27,86}, {72,35}, 
    {72,37}, {72,41}, {72,45}, {17,58}, {72,39}, {22,13}, {72,42}, {72,43}, 
    {52,32}, {35,2}, {72,55}, {25,64}, {72,40}, {50,2}, {72,51}, {72,54}, 
    {72,47}, {72,46}, {38,32}, {72,49}, {72,56}, {18,39}, {72,50}, {46,79}, 
    {72,44}, {18,86}, {72,53}, {72,57}, {43,19}, {46,12}, {72,52}, {72,59}, 
    {72,58}, {72,61}, {72,48}, {72,60}, {72,62}, {34,41}, {38,22}, {19,45}, 
    {26,21}, {47,31}, {75,2}, {36,22}, {50,90}, {75,3}, {75,4}, {37,58}, 
    {30,77}, {75,5}, {75,6}, {47,9}, {38,23}, {23,71}, {75,7}, {53,24}, 
    {52,92}, {19,42}, {17,28}, {45,67}, {37,70}, {44,64}, {19,84}, {42,31}, 
    {27,62}, {72,65}, {72,66}, {48,73}, {72,68}, {19,88}, {72,67}, {48,18}, 
    {41,65}, {17,47}, {72,71}, {72,69}, {72,70}, {53,18}, {72,72}, {72,73}, 
    {72,74}, {72,75}, {75,14}, {36,24}, {21,45}, {49,82}, {20,77}, {26,56}, 
    {75,16}, {49,66}, {45,66}, {35,23}, {34,30}, {21,29}, {55,24}, {16,39}, 
    {16,46}, {16,48}, {36,93}, {16,47}, {34,10}, {52,16}, {74,3}, {25,32}, 
    {43,25}, {74,4}, {74,6}, {74,7}, {74,5}, {74,8}, {74,10}, {74,9}, {74,11}, 
    {41,46}, {55,20}, {34,80}, {34,4}, {37,87}, {74,12}, {35,41}, {74,13}, 
    {74,14}, {74,15}, {22,52}, {22,89}, {74,16}, {38,65}, {74,18}, {25,3}, 
    {48,84}, {15,16}, {74,17}, {74,19}, {20,9}, {33,39}, {38,71}, {74,20}, 
    {42,13}, {66,62}, {50,31}, {56,58}, {44,0}, {53,12}, {38,82}, {56,63}, 
    {26,66}, {25,25}, {66,65}, {46,10}, {66,63}, {40,38}, {25,24}, {48,19}, 
    {66,64}, {39,73}, {24,14}, {28,12}, {18,55}, {45,58}, {43,31}, {66,71}, 
    {66,72}, {44,83}, {43,12}, {27,18}, {66,73}, {66,74}, {47,57}, {37,90}, 
    {22,57}, {38,62}, {49,41}, {45,53}, {66,67}, {66,75}, {40,81}, {18,32}, 
    {66,70}, {37,66}, {66,68}, {76,18}, {66,69}, {40,18}, {36,69}, {24,20}, 
    {34,26}, {66,66}, {36,28}, {32,3}, {33,56}, {17,54}, {66,76}, {26,5}, 
    {35,12}, {66,79}, {29,57}, {66,90}, {66,84}, {25,50}, {22,47}, {50,44}, 
    {53,45}, {52,50}, {24,32}, {52,19}, {48,55}, {47,24}, {38,85}, {39,9}, 
    {17,19}, {34,57}, {66,77}, {66,91}, {66,78}, {22,7}, {66,86}, {66,83}, 
    {22,25}, {36,1}, {66,85}, {36,60}, {17,7}, {37,91}, {35,63}, {54,1}, 
    {31,64}, {66,88}, {66,89}, {66,92}, {43,8}, {66,82}, {50,29}, {16,34}, 
    {76,19}, {66,80}, {66,81}, {66,87}, {47,25}, {37,34}, {51,82}, {66,93}, 
    {28,63}, {67,6}, {67,5}, {48,82}, {67,2}, {67,8}, {39,86}, {46,19}, 
    {67,7}, {67,13}, {33,68}, {21,19}, {28,81}, {67,1}, {25,72}, {67,9}, 
    {67,11}, {21,92}, {53,61}, {67,17}, {67,12}, {67,0}, {26,77}, {44,60}, 
    {38,1}, {36,40}, {32,86}, {67,3}, {38,18}, {28,11}, {28,28}, {67,4}, 
    {54,38}, {17,65}, {67,10}, {27,34}, {67,14}, {26,74}, {67,15}, {36,7}, 
    {67,16}, {52,66}, {30,2}, {67,25}, {67,22}, {67,26}, {67,28}, {37,53}, 
    {25,37}, {31,42}, {23,0}, {67,19}, {51,0}, {25,2}, {28,93}, {67,27}, 
    {44,30}, {35,88}, {46,90}, {40,69}, {50,30}, {46,48}, {67,18}, {67,23}, 
    {67,24}, {43,72}, {43,45}, {31,51}, {67,20}, {32,15}, {67,21}, {45,47}, 
    {26,32}, {20,50}, {39,82}, {28,6}, {52,38}, {40,11}, {23,1}, {67,41}, 
    {67,43}, {48,35}, {49,25}, {25,12}, {25,51}, {67,34}, {20,76}, {54,44}, 
    {67,31}, {46,92}, {67,30}, {32,59}, {43,41}, {41,70}, {35,54}, {43,51}, 
    {67,39}, {67,38}, {67,32}, {67,35}, {20,12}, {50,56}, {67,37}, {49,88}, 
    {19,66}, {26,19}, {40,77}, {19,29}, {26,75}, {48,44}, {43,76}, {76,20}, 
    {38,68}, {51,7}, {67,42}, {54,52}, {67,33}, {28,4}, {67,36}, {50,69}, 
    {67,40}, {40,87}, {67,29}, {50,68}, {38,93}, {21,40}, {51,91}, {17,18}, 
    {67,54}, {45,33}, {67,44}, {45,27}, {23,58}, {67,53}, {30,41}, {50,45}, 
    {34,75}, {36,39}, {67,55}, {44,35}, {67,46}, {67,51}, {67,52}, {25,93}, 
    {46,69}, {52,30}, {67,49}, {67,47}, {67,45}, {44,68}, {41,9}, {31,2}, 
    {28,5}, {67,50}, {23,39}, {67,70}, {51,19}, {67,58}, {32,78}, {67,72}, 
    {49,70}, {67,62}, {67,63}, {46,9}, {42,60}, {67,57}, {67,48}, {67,68}, 
    {39,59}, {67,66}, {35,70}, {67,65}, {67,64}, {18,91}, {67,71}, {20,64}, 
    {54,43}, {67,69}, {26,11}, {54,49}, {43,46}, {74,87}, {67,67}, {24,85}, 
    {53,44}, {67,56}, {67,59}, {33,89}, {67,61}, {33,42}, {31,35}, {33,47}, 
    {16,84}, {43,17}, {20,45}, {67,78}, {37,14}, {37,64}, {67,84}, {33,8}, 
    {31,75}, {48,60}, {67,77}, {35,13}, {67,76}, {67,85}, {67,83}, {33,93}, 
    {67,60}, {67,79}, {41,93}, {52,35}, {67,80}, {48,89}, {67,74}, {67,75}, 
    {67,81}, {45,10}, {36,42}, {38,16}, {33,25}, {67,73}, {32,41}, {43,21}, 
    {18,16}, {67,90}, {67,82}, {67,89}, {67,92}, {67,91}, {18,45}, {18,25}, 
    {67,86}, {67,88}, {67,87}, {36,75}, {31,28}, {51,71}, {68,1}, {15,35}, 
    {68,3}, {68,2}, {27,3}, {68,4}, {68,0}, {67,93}, {16,83}, {68,7}, {68,8}, 
    {68,5}, {68,6}, {68,9}, {37,56}, {68,10}, {68,12}, {68,11}, {68,14}, 
    {68,13}, {24,63}, {68,15}, {68,16}, {26,79}, {75,64}, {34,79}, {20,37}, 
    {26,49}, {32,72}, {51,77}, {29,35}, {54,37}, {51,53}, {17,50}, {75,29}, 
    {73,32}, {33,14}, {19,21}, {48,54}, {18,19}, {39,17}, {30,26}, {75,31}, 
    {53,42}, {75,30}, {75,32}, {75,36}, {29,69}, {43,30}, {36,57}, {29,27}, 
    {75,37}, {16,93}, {75,35}, {52,7}, {20,66}, {75,33}, {32,21}, {18,66}, 
    {75,34}, {42,23}, {31,34}, {43,93}, {32,49}, {75,39}, {25,69}, {31,50}, 
    {53,81}, {48,43}, {30,29}, {22,18}, {40,52}, {75,38}, {26,65}, {43,43}, 
    {28,92}, {39,39}, {46,8}, {44,72}, {36,74}, {22,72}, {48,40}, {25,23}, 
    {75,40}, {75,41}, {26,31}, {75,42}, {75,65}, {16,25}, {22,56}, {28,24}, 
    {75,43}, {48,69}, {75,44}, {39,26}, {75,48}, {75,50}, {26,44}, {27,68}, 
    {75,46}, {40,22}, {34,25}, {75,66}, {52,52}, {75,47}, {53,82}, {75,49}, 
    {75,45}, {75,51}, {75,52}, {40,30}, {46,7}, {47,59}, {48,11}, {39,58}, 
    {75,53}, {45,84}, {41,75}, {75,57}, {75,56}, {15,29}, {75,54}, {75,55}, 
    {75,67}, {39,27}, {32,38}, {75,59}, {48,63}, {75,58}, {51,78}, {75,60}, 
    {58,37}, {75,61}, {16,11}, {75,62}, {75,63}, {54,5}, {36,31}, {74,27}, 
    {15,13}, {29,83}, {23,23}, {49,14}, {15,53}, {20,88}, {55,18}, {42,11}, 
    {66,60}, {37,11}, {15,69}, {36,37}, {74,24}, {74,25}, {74,26}, {48,31}, 
    {36,2}, {73,81}, {35,17}, {35,20}, {31,45}, {73,82}, {35,32}, {45,78}, 
    {73,79}, {73,83}, {40,91}, {38,2}, {43,55}, {45,93}, {73,84}, {73,85}, 
    {46,11}, {31,70}, {73,86}, {21,30}, {73,87}, {73,88}, {73,89}, {73,90}, 
    {73,80}, {39,13}, {64,74}, {22,23}, {64,75}, {64,76}, {54,19}, {64,77}, 
    {64,78}, {50,43}, {64,80}, {30,80}, {64,79}, {20,49}, {16,22}, {64,82}, 
    {64,81}, {25,91}, {64,83}, {24,22}, {29,48}, {35,91}, {25,60}, {28,37}, 
    {64,84}, {64,86}, {21,31}, {46,32}, {41,7}, {64,85}, {52,87}, {50,91}, 
    {64,87}, {64,91}, {64,88}, {64,89}, {31,73}, {64,93}, {65,0}, {31,38}, 
    {64,90}, {64,92}, {65,4}, {32,51}, {65,2}, {65,7}, {17,93}, {65,1}, 
    {34,44}, {17,33}, {65,6}, {65,5}, {65,3}, {65,8}, {65,10}, {47,40}, 
    {53,76}, {34,7}, {65,11}, {46,54}, {65,13}, {25,78}, {72,63}, {65,12}, 
    {65,9}, {26,10}, {51,18}, {65,15}, {65,14}, {72,64}, {65,16}, {65,17}, 
    {65,18}, {43,0}, {65,19}, {65,20}, {47,93}, {33,41}, {50,80}, {44,84}, 
    {70,63}, {70,64}, {29,32}, {33,73}, {70,67}, {70,66}, {44,69}, {34,20}, 
    {70,65}, {26,22}, {46,53}, {32,64}, {70,72}, {70,71}, {70,83}, {17,2}, 
    {70,73}, {70,69}, {70,75}, {70,74}, {40,25}, {52,67}, {70,68}, {22,8}, 
    {70,70}, {70,77}, {70,82}, {53,72}, {70,76}, {70,81}, {70,80}, {15,63}, 
    {70,84}, {38,81}, {31,36}, {31,76}, {32,79}, {70,79}, {70,85}, {42,85}, 
    {71,1}, {71,0}, {54,32}, {70,89}, {70,88}, {70,90}, {70,86}, {70,93}, 
    {70,92}, {70,91}, {32,52}, {38,56}, {36,92}, {36,34}, {38,76}, {71,2}, 
    {71,5}, {71,4}, {71,6}, {25,86}, {70,87}, {71,3}, {39,79}, {40,9}, 
    {71,8}, {24,68}, {48,93}, {71,7}, {71,9}, {71,12}, {71,13}, {32,6}, 
    {71,14}, {71,15}, {71,11}, {71,19}, {71,10}, {71,16}, {71,20}, {71,17}, 
    {71,18}, {71,22}, {71,21}, {24,46}, {79,11}, {79,12}, {37,15}, {15,73}, 
    {39,30}, {44,62}, {45,44}, {73,16}, {73,17}, {37,30}, {19,40}, {73,18}, 
    {52,70}, {60,88}, {73,19}, {73,20}, {73,21}, {23,41}, {62,15}, {40,84}, 
    {43,79}, {40,89}, {40,90}, {50,34}, {42,5}, {23,5}, {79,13}, {16,33}, 
    {68,23}, {43,78}, {50,40}, {27,54}, {40,73}, {20,70}, {35,47}, {20,72}, 
    {77,13}, {26,12}, {70,61}, {77,14}, {18,8}, {77,17}, {77,16}, {28,70}, 
    {77,15}, {45,22}, {36,46}, {32,83}, {58,45}, {77,18}, {47,82}, {33,51}, 
    {37,71}, {22,11}, {77,19}, {18,74}, {26,90}, {77,20}, {70,59}, {77,21}, 
    {28,13}, {80,65}, {41,71}, {49,40}, {79,57}, {79,58}, {79,59}, {32,37}, 
    {23,76}, {29,45}, {79,61}, {36,16}, {79,60}, {48,80}, {79,63}, {15,43}, 
    {28,73}, {49,62}, {79,62}, {19,14}, {22,71}, {79,69}, {79,68}, {37,2}, 
    {79,64}, {79,65}, {19,34}, {79,66}, {52,77}, {43,58}, {29,49}, {27,17}, 
    {79,71}, {79,70}, {79,67}, {17,0}, {53,1}, {50,23}, {29,22}, {39,11}, 
    {79,73}, {48,86}, {53,43}, {25,58}, {79,72}, {21,26}, {44,19}, {37,5}, 
    {32,0}, {79,74}, {79,77}, {79,76}, {79,79}, {79,75}, {26,29}, {79,78}, 
    {43,20}, {79,81}, {18,52}, {16,51}, {79,82}, {79,83}, {79,85}, {19,64}, 
    {79,80}, {79,86}, {79,89}, {79,87}, {79,84}, {79,92}, {79,88}, {79,91}, 
    {79,93}, {80,0}, {45,32}, {80,3}, {80,2}, {32,85}, {79,90}, {41,60}, 
    {19,80}, {16,80}, {43,16}, {80,5}, {80,6}, {80,11}, {52,45}, {80,8}, 
    {39,18}, {80,1}, {80,10}, {80,7}, {80,4}, {80,9}, {15,8}, {80,12}, 
    {80,14}, {80,16}, {80,15}, {80,13}, {48,1}, {80,17}, {80,18}, {24,78}, 
    {20,38}, {15,54}, {15,56}, {51,76}, {20,35}, {28,51}, {26,41}, {79,6}, 
    {23,61}, {79,7}, {15,7}, {79,8}, {44,77}, {79,9}, {79,10}, {37,3}, 
    {53,68}, {80,67}, {80,68}, {34,82}, {50,58}, {53,48}, {36,71}, {50,14}, 
    {49,69}, {77,32}, {15,26}, {52,20}, {48,45}, {27,63}, {25,47}, {30,87}, 
    {23,38}, {20,32}, {36,43}, {41,1}, {34,42}, {77,33}, {35,30}, {21,1}, 
    {76,75}, {34,3}, {53,16}, {46,63}, {76,78}, {36,45}, {21,59}, {41,0}, 
    {76,76}, {76,79}, {76,80}, {34,27}, {30,19}, {76,77}, {76,83}, {76,81}, 
    {52,69}, {34,62}, {76,82}, {76,85}, {52,2}, {48,2}, {76,84}, {34,47}, 
    {76,86}, {30,83}, {29,75}, {76,87}, {43,86}, {48,58}, {54,36}, {52,85}, 
    {76,91}, {76,90}, {76,88}, {76,89}, {76,92}, {29,5}, {42,14}, {77,0}, 
    {21,28}, {77,1}, {35,31}, {76,93}, {28,61}, {17,38}, {21,34}, {77,4}, 
    {55,25}, {77,2}, {77,5}, {34,72}, {18,81}, {77,6}, {77,3}, {46,24}, 
    {77,7}, {33,86}, {77,8}, {77,9}, {61,10}, {37,18}, {38,37}, {53,84}, 
    {20,40}, {42,17}, {77,10}, {44,10}, {77,11}, {52,15}, {77,12}, {85,35}, 
    {58,38}, {19,2}, {34,11}, {80,69}, {41,23}, {49,50}, {53,9}, {78,81}, 
    {29,55}, {28,34}, {78,82}, {21,43}, {15,10}, {41,14}, {76,21}, {76,22}, 
    {45,88}, {22,14}, {30,82}, {76,23}, {33,74}, {40,15}, {76,24}, {37,85}, 
    {30,18}, {76,27}, {36,87}, {48,47}, {54,8}, {76,25}, {76,26}, {48,65}, 
    {76,30}, {76,31}, {76,35}, {76,39}, {76,37}, {76,45}, {52,71}, {76,40}, 
    {76,38}, {76,29}, {36,72}, {37,37}, {40,72}, {51,49}, {76,32}, {76,33}, 
    {76,34}, {76,36}, {31,88}, {19,0}, {24,71}, {76,47}, {76,48}, {76,41}, 
    {76,46}, {45,87}, {42,21}, {76,43}, {76,44}, {46,84}, {76,49}, {32,81}, 
    {50,17}, {76,42}, {39,22}, {27,78}, {36,79}, {76,53}, {20,78}, {33,20}, 
    {15,12}, {42,72}, {16,13}, {76,51}, {44,74}, {20,65}, {76,52}, {76,50}, 
    {76,54}, {20,89}, {76,55}, {76,56}, {76,59}, {16,43}, {36,85}, {27,77}, 
    {76,57}, {43,27}, {17,73}, {76,58}, {35,74}, {19,36}, {15,84}, {76,62}, 
    {31,57}, {19,71}, {36,44}, {76,60}, {30,35}, {76,61}, {35,4}, {76,63}, 
    {76,64}, {76,66}, {32,54}, {26,38}, {28,23}, {76,65}, {76,67}, {76,69}, 
    {76,68}, {76,70}, {41,29}, {75,73}, {31,80}, {40,70}, {75,74}, {37,77}, 
    {75,75}, {37,76}, {75,76}, {75,79}, {54,69}, {75,82}, {75,80}, {75,77}, 
    {75,78}, {54,2}, {40,80}, {42,77}, {75,83}, {75,81}, {46,72}, {75,85}, 
    {37,16}, {27,31}, {75,84}, {20,26}, {26,85}, {75,86}, {56,86}, {28,90}, 
    {33,26}, {75,87}, {75,88}, {23,2}, {75,89}, {75,90}, {75,91}, {50,76}, 
    {55,13}, {31,74}, {38,60}, {25,43}, {47,66}, {42,28}, {44,25}, {23,48}, 
    {16,91}, {38,78}, {53,53}, {30,37}, {34,74}, {78,84}, {34,55}, {54,65}, 
    {78,86}, {18,50}, {38,55}, {48,76}, {53,39}, {78,87}, {78,85}, {26,92}, 
    {18,37}, {28,52}, {49,37}, {26,63}, {46,0}, {78,91}, {78,90}, {78,88}, 
    {18,43}, {40,51}, {42,15}, {78,93}, {15,61}, {53,40}, {78,92}, {18,76}, 
    {85,52}, {45,39}, {79,1}, {79,0}, {20,29}, {27,57}, {26,91}, {23,68}, 
    {35,33}, {79,2}, {42,74}, {79,5}, {48,7}, {29,30}, {38,77}, {80,21}, 
    {80,22}, {30,52}, {19,8}, {80,23}, {44,26}, {38,51}, {52,12}, {80,24}, 
    {80,25}, {38,46}, {49,3}, {53,46}, {80,26}, {28,48}, {19,15}, {29,28}, 
    {19,59}, {45,48}, {30,62}, {80,28}, {30,89}, {80,27}, {80,30}, {80,29}, 
    {80,31}, {80,32}, {32,93}, {32,1}, {41,89}, {52,29}, {29,25}, {29,24}, 
    {52,33}, {30,1}, {44,14}, {80,20}, {28,62}, {21,42}, {53,80}, {82,34}, 
    {82,35}, {23,44}, {82,37}, {82,38}, {15,41}, {82,36}, {82,40}, {42,80}, 
    {82,42}, {47,5}, {16,41}, {82,39}, {82,46}, {20,48}, {82,54}, {82,49}, 
    {82,51}, {82,50}, {22,90}, {16,30}, {82,45}, {82,41}, {20,57}, {82,47}, 
    {82,48}, {82,52}, {82,44}, {27,66}, {32,92}, {82,53}, {82,57}, {82,43}, 
    {20,39}, {28,77}, {82,59}, {22,3}, {30,79}, {53,93}, {44,17}, {19,79}, 
    {17,62}, {82,55}, {82,56}, {40,23}, {82,60}, {82,61}, {82,64}, {82,62}, 
    {82,66}, {82,65}, {82,58}, {30,73}, {18,78}, {82,63}, {38,8}, {27,81}, 
    {82,74}, {24,30}, {82,67}, {17,12}, {26,93}, {42,66}, {82,76}, {82,72}, 
    {24,59}, {82,77}, {82,68}, {82,69}, {82,73}, {33,64}, {82,75}, {82,78}, 
    {82,71}, {27,92}, {46,67}, {82,79}, {82,70}, {82,81}, {54,12}, {37,9}, 
    {82,82}, {82,80}, {33,7}, {23,60}, {82,84}, {82,83}, {19,58}, {82,85}, 
    {82,86}, {82,87}, {31,25}, {31,72}, {36,80}, {82,90}, {82,89}, {19,55}, 
    {82,93}, {82,88}, {82,91}, {82,92}, {83,0}, {83,2}, {26,40}, {83,1}, 
    {83,3}, {17,29}, {83,5}, {83,4}, {27,13}, {34,54}, {56,64}, {31,63}, 
    {83,43}, {54,48}, {22,58}, {83,45}, {32,2}, {37,40}, {19,53}, {52,18}, 
    {83,47}, {83,46}, {83,48}, {42,57}, {83,49}, {51,32}, {53,63}, {22,63}, 
    {32,23}, {32,26}, {83,50}, {29,11}, {19,65}, {83,51}, {83,52}, {29,10}, 
    {83,53}, {83,58}, {83,54}, {83,57}, {25,92}, {83,55}, {83,56}, {23,65}, 
    {43,38}, {83,59}, {17,57}, {34,50}, {51,66}, {30,22}, {83,60}, {36,19}, 
    {83,72}, {46,20}, {45,40}, {42,55}, {42,86}, {28,83}, {54,46}, {31,58}, 
    {47,84}, {83,73}, {83,74}, {83,75}, {86,66}, {22,16}, {83,76}, {54,74}, 
    {83,77}, {69,88}, {29,31}, {69,89}, {25,75}, {69,90}, {46,42}, {69,91}, 
    {51,27}, {27,21}, {69,92}, {69,93}, {27,44}, {39,49}, {45,18}, {70,0}, 
    {19,30}, {70,1}, {40,19}, {23,56}, {35,40}, {54,60}, {33,57}, {22,54}, 
    {53,28}, {45,37}, {22,35}, {36,5}, {70,2}, {46,62}, {70,3}, {70,4}, 
    {70,5}, {32,22}, {54,72}, {40,79}, {46,23}, {53,14}, {53,52}, {70,6}, 
    {15,76}, {70,7}, {70,8}, {40,59}, {49,78}, {29,12}, {70,9}, {15,82}, 
    {39,61}, {28,64}, {70,10}, {39,37}, {70,11}, {26,69}, {23,87}, {48,3}, 
    {70,12}, {33,70}, {29,87}, {28,41}, {44,18}, {70,13}, {70,14}, {29,77}, 
    {47,68}, {42,70}, {43,47}, {27,43}, {70,15}, {27,7}, {47,86}, {70,16}, 
    {47,87}, {70,17}, {70,18}, {19,33}, {70,19}, {70,20}, {40,93}, {45,11}, 
    {34,63}, {70,22}, {16,32}, {18,80}, {70,23}, {70,24}, {54,58}, {52,31}, 
    {70,25}, {33,43}, {54,25}, {70,26}, {70,27}, {70,28}, {27,73}, {34,68}, 
    {31,33}, {70,29}, {70,30}, {27,8}, {70,31}, {70,32}, {70,21}, {21,47}, 
    {70,33}, {70,34}, {70,35}, {26,25}, {20,61}, {33,37}, {16,63}, {70,36}, 
    {51,20}, {70,37}, {23,30}, {70,39}, {70,38}, {22,75}, {70,40}, {17,87}, 
    {70,41}, {70,42}, {70,43}, {70,44}, {70,45}, {70,46}, {70,47}, {50,6}, 
    {42,84}, {70,48}, {70,49}, {70,50}, {70,51}, {40,40}, {70,52}, {70,53}, 
    {70,54}, {70,55}, {70,56}, {28,40}, {70,57}, {82,29}, {23,54}, {39,16}, 
    {82,30}, {82,31}, {82,32}, {24,61}, {44,87}, {55,71}, {25,16}, {33,61}, 
    {77,22}, {22,2}, {77,24}, {77,23}, {15,52}, {77,26}, {52,53}, {54,78}, 
    {53,34}, {77,28}, {41,79}, {77,27}, {77,29}, {77,31}, {77,30}, {48,81}, 
    {38,27}, {34,31}, {23,64}, {32,70}, {83,37}, {47,62}, {83,38}, {46,58}, 
    {39,25}, {83,39}, {83,40}, {83,41}, {83,42}, {56,89}, {23,93}, {68,80}, 
    {50,79}, {83,63}, {45,43}, {18,64}, {80,19}, {49,77}, {83,64}, {46,71}, 
    {83,65}, {38,43}, {20,51}, {19,67}, {83,67}, {83,66}, {83,68}, {83,69}, 
    {83,70}, {25,17}, {15,30}, {83,71}, {22,12}, {49,76}, {49,10}, {31,46}, 
    {30,27}, {74,2}, {52,62}, {73,39}, {80,82}, {21,87}, {42,2}, {35,44}, 
    {80,70}, {80,71}, {23,90}, {80,72}, {25,35}, {51,36}, {15,49}, {80,73}, 
    {80,74}, {80,75}, {80,76}, {80,77}, {80,78}, {80,80}, {80,79}, {36,52}, 
    {80,81}, {21,89}, {80,83}, {49,13}, {61,38}, {42,41}, {18,59}, {20,1}, 
    {24,1}, {35,83}, {80,84}, {80,85}, {32,35}, {32,90}, {53,15}, {80,86}, 
    {80,87}, {32,9}, {37,23}, {29,58}, {80,88}, {19,46}, {80,89}, {76,17}, 
    {76,16}, {42,63}, {49,61}, {42,32}, {52,55}, {39,65}, {31,62}, {27,0}, 
    {74,32}, {47,3}, {53,65}, {21,38}, {23,55}, {74,31}, {23,45}, {74,30}, 
    {18,5}, {24,40}, {53,10}, {22,83}, {22,41}, {27,70}, {22,29}, {74,37}, 
    {74,38}, {15,24}, {30,46}, {74,36}, {50,92}, {74,39}, {74,40}, {22,45}, 
    {74,33}, {74,35}, {40,85}, {53,54}, {52,44}, {47,17}, {74,46}, {45,23}, 
    {74,47}, {20,7}, {16,18}, {74,49}, {43,4}, {36,53}, {74,50}, {74,48}, 
    {36,62}, {74,45}, {41,3}, {74,52}, {15,90}, {25,89}, {55,22}, {80,66}, 
    {74,41}, {74,42}, {74,43}, {74,44}, {74,53}, {69,31}, {74,56}, {30,71}, 
    {49,39}, {74,54}, {74,59}, {23,75}, {74,55}, {28,25}, {47,55}, {15,22}, 
    {74,60}, {35,59}, {53,11}, {19,63}, {33,85}, {27,24}, {74,57}, {74,58}, 
    {51,63}, {37,73}, {35,51}, {74,62}, {36,6}, {56,84}, {17,16}, {74,67}, 
    {28,36}, {74,65}, {74,66}, {23,11}, {44,48}, {74,68}, {74,64}, {32,18}, 
    {37,1}, {43,82}, {74,69}, {31,15}, {49,23}, {74,70}, {23,14}, {23,12}, 
    {74,71}, {38,26}, {44,82}, {74,73}, {74,74}, {74,76}, {47,39}, {74,81}, 
    {74,77}, {74,80}, {39,88}, {48,91}, {74,75}, {74,72}, {23,24}, {46,56}, 
    {35,68}, {74,78}, {74,79}, {43,57}, {44,39}, {15,81}, {74,85}, {74,84}, 
    {17,17}, {23,63}, {74,86}, {16,75}, {43,36}, {35,3}, {46,4}, {74,88}, 
    {75,1}, {36,81}, {74,89}, {40,36}, {65,62}, {74,93}, {44,45}, {75,0}, 
    {16,58}, {50,22}, {49,59}, {74,92}, {74,90}, {18,27}, {73,15}, {54,51}, 
    {83,10}, {18,83}, {53,32}, {53,33}, {52,72}, {29,41}, {83,6}, {49,7}, 
    {83,7}, {83,8}, {83,9}, {29,42}, {50,62}, {40,63}, {40,64}, {82,33}, 
    {41,69}, {43,81}, {65,21}, {42,19}, {45,71}, {53,58}, {83,12}, {83,13}, 
    {83,14}, {83,17}, {25,28}, {83,18}, {15,66}, {83,15}, {83,16}, {28,1}, 
    {17,52}, {83,21}, {83,22}, {21,69}, {17,15}, {46,46}, {83,19}, {19,11}, 
    {83,20}, {83,23}, {83,24}, {44,6}, {83,25}, {83,26}, {83,27}, {42,49}, 
    {83,28}, {83,29}, {83,30}, {83,61}, {32,27}, {27,71}, {40,10}, {48,61}, 
    {68,84}, {59,18}, {49,52}, {59,19}, {15,11}, {59,20}, {28,57}, {59,24}, 
    {55,33}, {59,22}, {50,82}, {40,53}, {59,25}, {59,21}, {59,26}, {34,1}, 
    {59,27}, {59,36}, {59,28}, {45,62}, {53,4}, {59,46}, {59,44}, {59,49}, 
    {28,69}, {33,10}, {59,23}, {59,42}, {59,45}, {59,29}, {22,49}, {15,36}, 
    {59,38}, {47,29}, {59,32}, {26,7}, {22,27}, {59,43}, {59,37}, {59,30}, 
    {38,58}, {48,30}, {59,31}, {59,41}, {59,47}, {45,12}, {59,33}, {59,34}, 
    {59,39}, {59,40}, {17,51}, {59,48}, {42,52}, {51,22}, {59,58}, {59,62}, 
    {43,5}, {59,69}, {34,70}, {59,59}, {30,32}, {59,56}, {15,89}, {24,21}, 
    {59,68}, {59,50}, {59,35}, {59,53}, {39,83}, {30,63}, {40,26}, {16,28}, 
    {50,1}, {59,57}, {59,52}, {37,26}, {59,61}, {54,33}, {34,14}, {22,21}, 
    {38,48}, {34,8}, {59,65}, {59,55}, {59,74}, {59,51}, {59,60}, {29,4}, 
    {59,54}, {59,63}, {59,66}, {59,67}, {59,87}, {59,64}, {60,1}, {59,70}, 
    {27,74}, {19,35}, {34,2}, {17,70}, {59,89}, {59,81}, {59,78}, {59,91}, 
    {59,77}, {49,79}, {17,71}, {39,54}, {39,66}, {59,90}, {59,76}, {59,86}, 
    {59,84}, {29,2}, {59,83}, {17,60}, {59,82}, {27,85}, {59,71}, {26,35}, 
    {31,82}, {27,51}, {59,72}, {59,73}, {59,80}, {59,85}, {59,88}, {20,19}, 
    {39,56}, {26,70}, {59,93}, {59,92}, {50,10}, {60,0}, {60,2}, {60,4}, 
    {49,80}, {60,3}, {60,5}, {60,6}, {49,8}, {25,40}, {60,8}, {60,21}, 
    {60,16}, {60,19}, {60,15}, {37,45}, {31,81}, {40,14}, {59,75}, {60,13}, 
    {60,22}, {59,79}, {60,14}, {60,23}, {60,11}, {60,24}, {60,18}, {60,12}, 
    {35,9}, {60,7}, {31,18}, {32,10}, {60,9}, {60,10}, {60,17}, {26,80}, 
    {60,20}, {50,7}, {60,25}, {60,26}, {34,6}, {60,49}, {60,27}, {60,48}, 
    {24,28}, {29,52}, {29,89}, {25,41}, {60,41}, {60,36}, {60,30}, {17,42}, 
    {60,34}, {60,42}, {17,3}, {60,52}, {60,29}, {37,47}, {60,47}, {60,51}, 
    {32,65}, {22,37}, {60,45}, {60,46}, {60,35}, {60,28}, {60,44}, {43,48}, 
    {60,40}, {60,33}, {34,39}, {37,27}, {45,13}, {60,43}, {60,39}, {60,32}, 
    {60,37}, {33,59}, {50,8}, {50,9}, {60,50}, {46,83}, {39,87}, {60,69}, 
    {60,38}, {60,63}, {33,67}, {60,64}, {60,54}, {53,87}, {60,56}, {60,55}, 
    {23,79}, {60,53}, {37,46}, {21,12}, {60,65}, {25,88}, {51,64}, {60,70}, 
    {19,47}, {60,57}, {30,90}, {60,66}, {60,62}, {60,60}, {20,56}, {60,58}, 
    {60,59}, {60,61}, {28,14}, {60,67}, {60,68}, {60,84}, {34,40}, {42,65}, 
    {60,81}, {55,64}, {37,48}, {60,83}, {52,83}, {60,82}, {60,79}, {60,75}, 
    {60,78}, {60,71}, {47,77}, {39,55}, {60,77}, {60,72}, {60,73}, {42,81}, 
    {60,76}, {16,44}, {31,21}, {27,26}, {60,80}, {60,86}, {60,85}, {60,74}, 
    {36,77}, {60,90}, {61,3}, {61,2}, {60,87}, {34,78}, {33,90}, {52,64}, 
    {45,20}, {60,92}, {17,43}, {35,71}, {41,62}, {38,29}, {60,89}, {60,91}, 
    {60,93}, {61,1}, {15,9}, {16,45}, {61,11}, {61,5}, {28,21}, {39,78}, 
    {61,0}, {61,4}, {61,8}, {61,7}, {61,6}, {61,12}, {51,43}, {61,18}, 
    {61,9}, {61,13}, {31,56}, {16,0}, {61,21}, {61,16}, {61,17}, {48,5}, 
    {61,20}, {61,14}, {61,15}, {47,28}, {61,19}, {41,76}, {61,24}, {61,23}, 
    {61,22}, {61,26}, {28,68}, {17,55}, {34,73}, {61,25}, {36,25}, {61,27}, 
    {43,56}, {22,9}, {51,68}, {61,28}, {61,30}, {35,1}, {61,32}, {61,29}, 
    {61,31}, {52,25}, {61,33}, {81,13}, {26,1}, {33,17}, {36,15}, {33,38}, 
    {81,14}, {47,72}, {50,60}, {74,28}, {18,69}, {81,15}, {81,16}, {41,12}, 
    {25,70}, {81,18}, {81,20}, {81,19}, {42,67}, {46,25}, {81,17}, {41,19}, 
    {49,46}, {33,75}, {45,34}, {81,23}, {15,85}, {81,22}, {81,29}, {17,46}, 
    {48,32}, {81,25}, {81,27}, {51,72}, {81,26}, {81,21}, {81,30}, {81,28}, 
    {81,24}, {81,38}, {81,35}, {81,37}, {81,41}, {81,33}, {81,31}, {81,36}, 
    {53,90}, {81,32}, {38,88}, {40,62}, {81,39}, {24,37}, {20,15}, {81,34}, 
    {81,40}, {81,47}, {81,53}, {26,54}, {81,52}, {44,59}, {53,74}, {81,49}, 
    {81,51}, {23,81}, {81,42}, {81,45}, {33,88}, {52,60}, {81,43}, {81,44}, 
    {81,46}, {81,50}, {81,56}, {50,27}, {21,73}, {41,80}, {22,67}, {81,54}, 
    {81,55}, {81,57}, {81,60}, {81,58}, {81,59}, {48,48}, {81,48}, {44,40}, 
    {45,46}, {53,8}, {81,66}, {34,58}, {81,63}, {31,14}, {81,75}, {81,61}, 
    {81,64}, {81,71}, {81,65}, {81,70}, {81,69}, {81,72}, {81,62}, {81,67}, 
    {81,73}, {50,11}, {81,68}, {17,84}, {81,81}, {47,10}, {81,84}, {26,39}, 
    {81,88}, {81,79}, {81,85}, {81,87}, {81,89}, {81,82}, {81,80}, {25,90}, 
    {20,90}, {81,78}, {81,86}, {81,76}, {81,77}, {81,74}, {82,5}, {82,2}, 
    {82,1}, {81,83}, {39,57}, {81,90}, {82,4}, {34,87}, {81,92}, {82,6}, 
    {82,8}, {82,3}, {81,91}, {82,10}, {82,9}, {33,60}, {82,13}, {82,15}, 
    {82,0}, {82,16}, {82,11}, {82,14}, {81,93}, {82,12}, {82,17}, {82,19}, 
    {82,7}, {82,18}, {82,20}, {47,22}, {82,23}, {56,88}, {82,24}, {82,22}, 
    {39,67}, {82,21}, {82,25}, {82,26}, {19,31}, {77,34}, {82,27}, {82,28}, 
    {48,9}, {83,11}, {47,37}, {47,47}, {48,59}, {46,45}, {28,53}, {48,34}, 
    {25,65}, {64,72}, {49,33}, {80,33}, {17,24}, {16,76}, {80,34}, {40,31}, 
    {18,35}, {56,81}, {42,4}, {80,35}, {53,51}, {80,36}, {83,31}, {80,37}, 
    {51,11}, {80,38}, {15,31}, {83,32}, {83,33}, {19,91}, {36,58}, {43,26}, 
    {47,67}, {44,63}, {80,39}, {56,82}, {16,26}, {46,13}, {23,3}, {80,41}, 
    {80,42}, {17,34}, {32,48}, {54,15}, {80,40}, {80,43}, {80,45}, {56,85}, 
    {49,64}, {51,2}, {83,34}, {39,24}, {83,35}, {80,44}, {80,46}, {30,66}, 
    {80,47}, {80,51}, {80,53}, {80,48}, {40,48}, {36,64}, {33,66}, {24,91}, 
    {80,50}, {80,52}, {24,50}, {80,58}, {25,53}, {15,92}, {80,56}, {80,55}, 
    {80,49}, {80,57}, {80,54}, {39,75}, {44,41}, {80,60}, {68,28}, {80,59}, 
    {80,61}, {80,62}, {46,68}, {83,36}, {28,82}, {80,63}, {80,64}, {45,86}, 
    {49,9}, {80,90}, {23,17}, {27,90}, {24,58}, {24,69}, {34,56}, {41,50}, 
    {73,71}, {31,31}, {29,84}, {73,72}, {73,73}, {73,74}, {73,75}, {73,76}, 
    {73,77}, {73,78}, {28,38}, {84,90}, {84,92}, {84,93}, {84,91}, {28,65}, 
    {85,0}, {19,4}, {85,1}, {85,2}, {75,17}, {48,51}, {56,73}, {85,3}, 
    {77,25}, {52,17}, {50,93}, {43,59}, {41,35}, {68,31}, {85,4}, {29,14}, 
    {37,8}, {57,4}, {27,37}, {21,8}, {23,27}, {39,46}, {27,4}, {57,5}, 
    {57,6}, {43,53}, {39,34}, {57,7}, {37,92}, {48,20}, {49,72}, {48,21}, 
    {27,38}, {28,17}, {26,67}, {57,8}, {57,9}, {48,39}, {57,10}, {47,76}, 
    {21,78}, {33,58}, {42,46}, {22,76}, {40,71}, {22,34}, {29,86}, {53,3}, 
    {57,11}, {57,12}, {37,31}, {54,70}, {41,21}, {52,8}, {42,62}, {52,78}, 
    {57,13}, {53,62}, {19,41}, {57,15}, {57,14}, {49,74}, {57,16}, {57,17}, 
    {57,18}, {41,51}, {57,19}, {41,10}, {57,20}, {57,21}, {18,46}, {53,78}, 
    {57,22}, {26,15}, {20,13}, {57,23}, {57,24}, {24,77}, {48,14}, {49,71}, 
    {57,25}, {23,34}, {46,73}, {17,78}, {57,26}, {57,27}, {28,74}, {45,59}, 
    {50,78}, {57,28}, {45,82}, {57,29}, {50,52}, {26,68}, {57,30}, {42,20}, 
    {42,47}, {57,31}, {38,74}, {53,77}, {57,32}, {36,20}, {21,32}, {57,33}, 
    {22,43}, {30,45}, {57,34}, {57,35}, {42,12}, {57,36}, {20,86}, {57,37}, 
    {32,33}, {54,26}, {57,38}, {43,23}, {49,73}, {35,16}, {57,39}, {20,92}, 
    {26,48}, {57,40}, {47,18}, {57,41}, {57,42}, {45,28}, {57,43}, {57,44}, 
    {57,45}, {17,86}, {57,48}, {57,46}, {48,71}, {57,47}, {34,52}, {57,49}, 
    {57,50}, {57,51}, {57,52}, {47,26}, {49,4}, {15,88}, {57,53}, {38,10}, 
    {57,54}, {28,86}, {34,0}, {57,55}, {57,56}, {34,92}, {43,22}, {57,57}, 
    {57,58}, {31,29}, {37,54}, {57,59}, {57,60}, {38,19}, {57,61}, {57,62}, 
    {24,39}, {26,76}, {21,24}, {83,87}, {83,88}, {44,66}, {84,24}, {74,63}, 
    {46,82}, {26,30}, {25,31}, {51,4}, {64,56}, {84,83}, {16,9}, {17,81}, 
    {84,84}, {84,86}, {25,48}, {84,85}, {34,17}, {84,88}, {84,87}, {16,19}, 
    {52,73}, {23,25}, {24,16}, {17,37}, {51,79}, {46,44}, {15,59}, {52,42}, 
    {26,84}, {53,41}, {22,22}, {43,15}, {37,21}, {16,64}, {24,25}, {53,91}, 
    {24,64}, {22,0}, {27,89}, {73,57}, {73,58}, {43,88}, {24,82}, {73,59}, 
    {19,90}, {34,18}, {22,48}, {25,55}, {73,60}, {51,83}, {73,61}, {27,53}, 
    {26,62}, {73,62}, {32,61}, {33,23}, {51,62}, {54,41}, {73,63}, {73,64}, 
    {73,67}, {73,65}, {73,66}, {40,61}, {23,18}, {21,35}, {73,68}, {41,73}, 
    {40,44}, {19,44}, {65,56}, {36,65}, {73,69}, {31,20}, {54,23}, {73,70}, 
    {54,11}, {39,91}, {55,50}, {55,44}, {51,61}, {51,88}, {40,35}, {50,13}, 
    {23,50}, {18,63}, {40,65}, {83,85}, {25,52}, {83,86}, {54,62}, {83,80}, 
    {23,15}, {52,51}, {23,46}, {37,79}, {18,34}, {83,81}, {18,11}, {51,28}, 
    {38,86}, {83,83}, {83,82}, {43,42}, {39,3}, {83,84}, {54,66}, {36,30}, 
    {84,31}, {84,26}, {84,34}, {84,33}, {53,25}, {84,32}, {51,29}, {84,35}, 
    {84,43}, {15,46}, {20,87}, {84,40}, {84,41}, {36,59}, {84,36}, {84,37}, 
    {84,38}, {84,42}, {29,63}, {84,39}, {23,89}, {84,47}, {84,50}, {30,70}, 
    {24,81}, {84,27}, {84,44}, {33,22}, {43,87}, {27,88}, {84,45}, {84,46}, 
    {84,48}, {21,68}, {84,49}, {84,52}, {84,28}, {84,51}, {50,26}, {18,75}, 
    {43,3}, {84,53}, {84,54}, {29,64}, {84,55}, {43,62}, {84,58}, {17,39}, 
    {54,56}, {84,56}, {84,57}, {84,59}, {84,65}, {84,63}, {84,62}, {84,60}, 
    {84,64}, {84,61}, {84,67}, {84,68}, {43,66}, {68,30}, {20,23}, {84,66}, 
    {84,71}, {43,2}, {84,69}, {84,70}, {84,29}, {16,35}, {84,30}, {20,36}, 
    {17,67}, {84,75}, {84,72}, {21,54}, {84,76}, {84,73}, {84,74}, {19,57}, 
    {51,73}, {84,77}, {18,88}, {84,78}, {84,80}, {84,79}, {84,81}, {84,82}, 
    {40,76}, {24,9}, {38,90}, {21,66}, {43,40}, {73,5}, {18,20}, {51,93}, 
    {24,75}, {47,88}, {72,76}, {54,9}, {72,77}, {33,53}, {39,76}, {25,67}, 
    {72,78}, {72,79}, {72,80}, {53,64}, {72,81}, {72,82}, {72,84}, {72,83}, 
    {72,85}, {72,86}, {38,64}, {72,87}, {51,55}, {72,88}, {28,45}, {72,89}, 
    {72,90}, {28,46}, {72,91}, {23,7}, {32,29}, {72,92}, {16,17}, {26,51}, 
    {24,84}, {72,93}, {73,0}, {73,1}, {73,2}, {22,87}, {27,12}, {41,67}, 
    {63,45}, {51,14}, {46,28}, {52,22}, {73,3}, {52,61}, {73,4}, {47,32}, 
    {24,27}, {19,38}, {16,56}, {31,16}, {16,69}, {16,70}, {16,71}, {18,28}, 
    {39,71}, {68,32}, {16,62}, {32,40}, {19,78}, {38,7}, {50,55}, {37,88}, 
    {48,23}, {24,92}, {33,84}, {50,12}, {51,42}, {28,91}, {68,33}, {22,20}, 
    {68,34}, {26,24}, {52,65}, {28,87}, {51,21}, {45,4}, {32,11}, {18,56}, 
    {43,85}, {68,37}, {68,35}, {68,39}, {68,41}, {68,38}, {20,46}, {37,39}, 
    {20,91}, {68,36}, {41,85}, {68,40}, {34,51}, {16,36}, {27,2}, {54,22}, 
    {44,42}, {42,44}, {41,41}, {43,50}, {68,43}, {68,42}, {35,69}, {48,0}, 
    {48,22}, {68,44}, {68,47}, {44,23}, {53,79}, {68,46}, {20,60}, {44,29}, 
    {68,48}, {21,25}, {44,7}, {24,67}, {41,36}, {18,48}, {42,56}, {51,75}, 
    {68,49}, {22,73}, {68,45}, {68,52}, {19,93}, {68,53}, {68,50}, {68,51}, 
    {49,60}, {33,62}, {16,37}, {50,65}, {21,60}, {42,75}, {68,54}, {50,85}, 
    {16,72}, {21,83}, {68,57}, {68,55}, {68,56}, {20,31}, {49,36}, {68,59}, 
    {68,61}, {68,60}, {38,17}, {49,2}, {68,58}, {51,65}, {52,57}, {68,63}, 
    {54,80}, {68,64}, {16,59}, {48,90}, {68,65}, {68,67}, {68,66}, {68,68}, 
    {49,55}, {20,42}, {70,62}, {57,84}, {57,87}, {57,85}, {57,86}, {57,89}, 
    {47,46}, {35,38}, {15,77}, {47,15}, {57,88}, {50,41}, {25,9}, {58,1}, 
    {38,80}, {57,91}, {57,90}, {40,58}, {57,92}, {58,0}, {54,61}, {57,93}, 
    {32,57}, {58,4}, {50,83}, {58,6}, {58,3}, {58,7}, {28,27}, {31,40}, 
    {58,2}, {58,5}, {53,2}, {58,8}, {58,12}, {58,13}, {58,11}, {25,33}, 
    {30,3}, {58,10}, {58,9}, {51,38}, {17,30}, {58,14}, {24,88}, {58,15}, 
    {18,26}, {20,5}, {21,27}, {58,16}, {21,84}, {58,17}, {16,40}, {58,19}, 
    {58,18}, {58,20}, {58,22}, {58,21}, {58,23}, {58,24}, {58,25}, {50,46}, 
    {83,89}, {38,84}, {54,34}, {36,67}, {83,91}, {83,92}, {83,90}, {29,37}, 
    {47,78}, {22,50}, {51,44}, {43,9}, {84,1}, {84,0}, {25,7}, {83,93}, 
    {42,53}, {84,3}, {31,49}, {18,73}, {44,9}, {84,4}, {84,2}, {28,19}, 
    {84,7}, {84,8}, {28,44}, {34,23}, {30,64}, {42,64}, {84,9}, {84,5}, 
    {84,6}, {35,79}, {84,11}, {19,27}, {54,76}, {19,54}, {84,10}, {84,13}, 
    {84,12}, {84,14}, {47,48}, {34,48}, {39,8}, {84,15}, {84,16}, {84,17}, 
    {84,18}, {84,19}, {84,20}, {84,22}, {84,21}, {84,23}, {17,40}, {50,51}, 
    {41,44}, {31,78}, {53,55}, {49,15}, {32,30}, {28,79}, {23,9}, {27,87}, 
    {85,37}, {85,38}, {85,39}, {85,40}, {85,41}, {85,43}, {85,42}, {86,72}, 
    {85,44}, {85,45}, {77,35}, {77,36}, {77,37}, {52,74}, {21,3}, {77,39}, 
    {77,38}, {77,40}, {77,41}, {38,4}, {77,42}, {77,43}, {22,15}, {20,85}, 
    {77,44}, {77,46}, {77,45}, {23,37}, {77,47}, {77,48}, {77,49}, {21,58}, 
    {18,13}, {53,50}, {35,37}, {16,20}, {23,53}, {77,50}, {77,51}, {51,30}, 
    {38,52}, {29,90}, {45,56}, {24,18}, {77,53}, {77,52}, {77,55}, {77,54}, 
    {36,4}, {77,56}, {77,57}, {38,13}, {77,58}, {38,14}, {77,59}, {17,6}, 
    {77,60}, {77,61}, {77,62}, {77,63}, {77,64}, {54,73}, {77,65}, {77,66}, 
    {27,55}, {77,67}, {50,42}, {43,89}, {17,11}, {32,68}, {77,68}, {38,5}, 
    {34,12}, {77,69}, {77,70}, {77,71}, {77,72}, {77,73}, {77,74}, {77,75}, 
    {77,76}, {77,77}, {77,78}, {77,79}, {77,80}, {77,81}, {77,83}, {77,82}, 
    {77,84}, {44,12}, {33,32}, {77,85}, {77,86}, {77,87}, {52,0}, {77,88}, 
    {46,18}, {77,89}, {77,90}, {77,91}, {77,92}, {78,0}, {77,93}, {78,1}, 
    {23,84}, {34,89}, {78,2}, {78,3}, {28,33}, {49,30}, {17,88}, {78,4}, 
    {78,5}, {78,6}, {49,87}, {78,7}, {53,92}, {78,8}, {37,43}, {78,9}, 
    {78,10}, {32,19}, {78,11}, {46,89}, {42,87}, {78,13}, {78,12}, {18,89}, 
    {24,87}, {78,14}, {78,15}, {47,65}, {78,16}, {78,17}, {22,69}, {47,30}, 
    {78,18}, {78,19}, {78,20}, {39,80}, {43,63}, {78,21}, {78,22}, {78,23}, 
    {78,24}, {78,25}, {52,63}, {78,26}, {19,76}, {34,9}, {78,27}, {78,28}, 
    {78,29}, {78,30}, {45,92}, {78,31}, {33,63}, {19,23}, {54,21}, {28,84}, 
    {46,38}, {78,34}, {78,32}, {78,33}, {78,35}, {21,6}, {27,91}, {29,65}, 
    {34,43}, {78,36}, {78,37}, {78,38}, {78,46}, {78,39}, {78,40}, {78,41}, 
    {38,33}, {78,80}, {21,44}, {78,42}, {78,43}, {78,44}, {21,37}, {34,29}, 
    {78,45}, {78,47}, {78,48}, {78,49}, {52,81}, {78,50}, {35,86}, {78,51}, 
    {35,87}, {78,52}, {78,53}, {23,67}, {15,86}, {78,54}, {78,55}, {78,56}, 
    {78,57}, {78,58}, {78,59}, {78,60}, {78,61}, {29,20}, {78,64}, {78,62}, 
    {78,63}, {78,65}, {78,66}, {32,44}, {78,67}, {78,68}, {78,69}, {78,70}, 
    {78,71}, {78,72}, {78,73}, {78,74}, {78,75}, {31,55}, {78,76}, {32,12}, 
    {78,77}, {78,78}, {78,79}, {46,65}, {18,3}, {34,36}, {66,36}, {40,32}, 
    {66,37}, {16,52}, {45,41}, {19,18}, {39,81}, {66,38}, {46,47}, {66,39}, 
    {27,67}, {66,40}, {66,41}, {34,37}, {52,1}, {35,53}, {24,74}, {45,36}, 
    {66,42}, {34,85}, {66,43}, {22,6}, {23,82}, {25,49}, {66,44}, {66,45}, 
    {51,35}, {66,46}, {66,47}, {48,42}, {66,48}, {66,49}, {66,50}, {66,51}, 
    {48,53}, {66,52}, {17,90}, {31,26}, {66,53}, {31,10}, {66,54}, {66,55}, 
    {66,56}, {66,57}, {66,58}, {23,22}, {57,65}, {21,50}, {57,67}, {57,66}, 
    {57,69}, {39,77}, {57,68}, {22,31}, {48,83}, {49,84}, {52,82}, {28,54}, 
    {54,71}, {57,71}, {57,70}, {15,1}, {44,50}, {57,72}, {23,28}, {27,41}, 
    {33,28}, {33,3}, {18,33}, {57,73}, {33,9}, {35,15}, {28,20}, {46,61}, 
    {57,74}, {40,33}, {16,60}, {57,75}, {21,23}, {51,25}, {18,92}, {57,76}, 
    {51,40}, {46,52}, {36,66}, {57,77}, {57,78}, {57,79}, {32,73}, {43,52}, 
    {46,60}, {50,70}, {33,0}, {57,80}, {42,68}, {57,81}, {42,69}, {49,93}, 
    {23,83}, {57,82}, {15,14}, {46,21}, {52,46}, {42,76}, {57,83}, {66,35}, 
    {32,4}, {85,30}, {85,31}, {85,32}, {35,48}, {39,23}, {48,66}, {47,58}, 
    {48,36}, {27,14}, {24,44}, {78,83}, {19,37}, {50,25}, {85,33}, {18,90}, 
    {85,34}, {20,80}, {85,36}, {50,73}, {85,6}, {48,8}, {85,8}, {85,7}, 
    {32,66}, {31,54}, {16,1}, {45,76}, {47,71}, {85,10}, {46,85}, {85,9}, 
    {52,79}, {85,11}, {34,24}, {26,83}, {85,13}, {85,12}, {35,61}, {32,55}, 
    {42,9}, {46,27}, {85,14}, {85,15}, {85,16}, {33,21}, {15,51}, {36,88}, 
    {85,17}, {38,63}, {85,5}, {29,23}, {29,17}, {20,68}, {22,38}, {30,30}, 
    {34,49}, {34,69}, {55,43}, {23,78}, {28,88}, {48,4}, {15,47}, {86,15}, 
    {86,16}, {47,11}, {15,15}, {86,17}, {86,18}, {86,19}, {38,41}, {29,46}, 
    {86,22}, {86,21}, {16,61}, {86,20}, {86,23}, {86,24}, {45,3}, {39,44}, 
    {25,10}, {71,23}, {71,24}, {71,25}, {29,33}, {49,83}, {51,46}, {40,55}, 
    {49,18}, {21,4}, {38,73}, {80,91}, {46,77}, {42,18}, {47,74}, {70,78}, 
    {44,70}, {24,42}, {21,56}, {80,92}, {15,67}, {42,43}, {80,93}, {51,3}, 
    {33,12}, {32,75}, {37,35}, {29,16}, {81,0}, {27,52}, {81,1}, {81,2}, 
    {81,3}, {49,34}, {37,20}, {44,38}, {81,4}, {50,16}, {30,36}, {43,65}, 
    {81,5}, {81,6}, {48,52}, {21,77}, {81,7}, {81,8}, {20,62}, {81,9}, 
    {81,10}, {17,91}, {81,11}, {81,12}, {39,6}, {22,70}, {75,8}, {75,9}, 
    {75,10}, {75,11}, {37,13}, {75,12}, {75,13}, {22,40}, {41,18}, {65,23}, 
    {86,46}, {86,47}, {17,44}, {86,48}, {86,50}, {86,49}, {65,26}, {27,1}, 
    {65,27}, {65,28}, {65,29}, {65,30}, {65,31}, {65,32}, {22,24}, {49,90}, 
    {28,3}, {41,45}, {16,4}, {42,38}, {65,33}, {21,91}, {39,35}, {65,34}, 
    {28,39}, {16,92}, {65,35}, {21,85}, {65,36}, {35,56}, {65,37}, {46,57}, 
    {24,60}, {65,38}, {31,0}, {65,39}, {17,85}, {65,40}, {32,82}, {65,41}, 
    {65,42}, {33,87}, {65,43}, {65,44}, {65,45}, {41,54}, {55,23}, {56,68}, 
    {46,66}, {79,4}, {59,15}, {33,76}, {51,5}, {44,51}, {48,16}, {18,58}, 
    {38,92}, {17,20}, {33,30}, {69,63}, {41,26}, {69,64}, {69,65}, {29,51}, 
    {69,66}, {54,3}, {44,52}, {69,68}, {27,60}, {69,67}, {69,69}, {69,70}, 
    {33,77}, {28,29}, {69,71}, {33,69}, {25,6}, {69,72}, {69,73}, {18,49}, 
    {48,72}, {30,4}, {69,74}, {37,78}, {69,75}, {69,76}, {69,77}, {37,12}, 
    {69,78}, {40,6}, {69,79}, {69,80}, {69,81}, {68,24}, {69,82}, {69,83}, 
    {33,65}, {69,84}, {69,85}, {53,71}, {69,86}, {69,87}, {24,38}, {86,26}, 
    {86,25}, {86,29}, {86,27}, {25,0}, {86,30}, {86,31}, {86,33}, {86,32}, 
    {86,35}, {86,34}, {86,36}, {86,37}, {86,38}, {42,71}, {23,62}, {86,51}, 
    {86,52}, {86,53}, {86,55}, {86,57}, {86,54}, {86,58}, {86,56}, {54,54}, 
    {86,59}, {86,60}, {86,61}, {86,62}, {86,63}, {58,42}, {55,9}, {68,86}, 
    {24,76}, {30,92}, {26,73}, {86,40}, {37,38}, {86,39}, {86,41}, {86,43}, 
    {86,42}, {86,44}, {45,25}, {86,45}, {35,6}, {50,66}, {85,46}, {33,18}, 
    {85,47}, {85,48}, {85,49}, {85,50}, {85,51}, {85,53}, {16,10}, {85,54}, 
    {85,55}, {85,56}, {85,57}, {85,58}, {85,59}, {85,60}, {85,61}, {46,41}, 
    {85,62}, {85,63}, {85,64}, {85,65}, {85,66}, {85,67}, {31,79}, {85,68}, 
    {85,69}, {85,70}, {85,71}, {85,72}, {85,73}, {85,74}, {85,75}, {85,76}, 
    {85,77}, {85,78}, {85,79}, {85,80}, {85,81}, {85,82}, {85,83}, {29,7}, 
    {85,84}, {85,85}, {85,86}, {85,87}, {39,89}, {85,88}, {85,89}, {85,90}, 
    {85,91}, {85,92}, {85,93}, {86,0}, {86,1}, {86,2}, {86,3}, {86,4}, 
    {86,5}, {86,6}, {86,7}, {16,77}, {86,8}, {86,9}, {86,10}, {86,11}, 
    {86,12}, {32,58}, {86,13}, {86,14}, {35,80}, {79,14}, {27,5}, {79,15}, 
    {34,88}, {36,23}, {48,26}, {79,16}, {79,17}, {79,18}, {79,19}, {79,20}, 
    {48,27}, {48,75}, {79,22}, {79,21}, {51,6}, {44,49}, {79,23}, {79,25}, 
    {79,24}, {79,26}, {79,27}, {23,74}, {79,28}, {25,71}, {79,29}, {79,30}, 
    {29,72}, {79,31}, {21,75}, {79,32}, {79,33}, {79,34}, {79,35}, {39,20}, 
    {79,36}, {79,37}, {79,38}, {36,83}, {79,39}, {79,40}, {79,41}, {86,28}, 
    {79,42}, {79,43}, {79,44}, {79,45}, {79,46}, {25,54}, {79,47}, {79,48}, 
    {79,49}, {79,50}, {79,51}, {79,52}, {79,53}, {79,55}, {50,4}, {79,54}, 
    {79,56}, {84,25}, {33,24}, {86,67}, {86,68}, {86,69}, {86,70}, {86,71}, 
    {33,19}, {86,73}, {86,74}, {33,82}, {83,79}, {83,78}, {33,72}, {86,64}, 
    {86,65}, {26,37}, {56,67}, {41,81}, {31,71}, {79,3}, {25,57}, {38,12}, 
    {35,11}, {86,75}, {86,76}, {86,77}, {86,79}, {86,78}, {86,80}, {86,83}, 
    {86,82}, {86,81}, {86,84}, {86,85}, {76,72}, {76,73}, {76,74}, {85,27}, 
    {85,28}, {85,29}, {21,5}, {55,29}, {24,35}, {55,26}, {59,16}, {41,82}, 
    {86,86}, {86,87}, {86,88}, {86,90}, {86,89}, {16,38}, {86,91}, {86,92}, 
    {86,93}, {37,74}, {75,19}, {18,60}, {85,18}, {85,19}, {32,67}, {85,20}, 
    {85,21}, {85,22}, {85,23}, {85,24}, {85,25}, {39,2}, {85,26}, {32,89}, 
    {24,7}, {76,71}, {24,73}, {56,62}, {2,0}, {2,1}, {2,2}, {0,70}, {2,4}, 
    {2,5}, {2,6}, {2,7}, {2,8}, {2,9}, {2,10}, {2,11}, {2,12}, {2,13}, 
    {2,14}, {2,15}, {2,16}, {2,17}, {2,18}, {2,19}, {2,20}, {2,21}, {2,22}, 
    {2,23}, {2,24}, {2,25}, {2,26}, {2,27}, {2,28}, {2,29}, {2,30}, {2,31}, 
    {2,32}, {2,33}, {2,34}, {2,35}, {2,36}, {2,37}, {2,38}, {2,39}, {2,40}, 
    {2,41}, {2,42}, {2,43}, {2,44}, {2,45}, {2,46}, {2,47}, {2,48}, {2,49}, 
    {2,50}, {2,51}, {2,52}, {2,53}, {2,54}, {2,55}, {2,56}, {2,57}, {2,58}, 
    {2,59}, {2,60}, {2,61}, {2,62}, {2,63}, {2,64}, {2,65}, {2,66}, {2,67}, 
    {2,68}, {2,69}, {2,70}, {2,71}, {2,72}, {2,73}, {2,74}, {2,75}, {2,76}, 
    {2,77}, {2,78}, {2,79}, {2,80}, {2,81}, {2,82}, {2,83}, {2,84}, {2,85}, 
    {2,86}, {2,87}, {2,88}, {2,89}, {2,90}, {2,91}, {2,92}, {0,10}, {0,72}, 
    {0,73}, {2,93}, {2,3}
};

/* This returns ERROR if the code point doesn't exist. */
long int gb2312_to_unicode(int r, int c)
{
    assert(r >= 0 && r < 94);
    assert(c >= 0 && c < 94);
    return gb2312_forward[r][c];
}

/* This one returns true on success, false if the code point doesn't exist. */
bool unicode_to_gb2312(long int unicode, int *r, int *c)
{
    int rr, cc;
    long int uu;
    int i, j, k;

    i = -1;
    j = lenof(gb2312_backward);
    while (j - i > 1) {
	k = (i + j) / 2;
	rr = gb2312_backward[k].r;
	cc = gb2312_backward[k].c;
	uu = gb2312_forward[rr][cc];
	if (unicode > uu)
	    i = k;
	else if (unicode < uu)
	    j = k;
	else {
	    *r = rr;
	    *c = cc;
	    return true;
	}
    }
    return false;
}

#ifdef TESTMODE

#include <stdio.h>

int main(void)
{
    int r, c, rr, cc, ret;
    long int u, uu;

    for (r = 0; r < 94; r++) {
	for (c = 0; c < 94; c++) {
	    u = gb2312_to_unicode(r, c);
	    if (u != ERROR) {
		ret = unicode_to_gb2312(u, &rr, &cc);
		if (!ret)
		    printf("(%d,%d) -> U-%08lx but didn't convert back\n",
			   r, c, u);
		else if (rr != r || cc != c)
		    printf("(%d,%d) -> U-%08lx -> (%d,%d)\n",
			   r, c, u, rr, cc);
	    }
	}
    }

    for (u = 0; u < 0x10000L; u++) {
	ret = unicode_to_gb2312(u, &r, &c);
	if (ret) {
	    uu = gb2312_to_unicode(r, c);
	    if (uu == ERROR)
		printf("U-%08lx -> (%d,%d) but didn't convert back\n",
		       u, r, c);
	    else if (uu != u)
		printf("U-%08lx -> (%d,%d) -> U-%08lx\n", u, r, c, uu);
	}
    }

    return 0;
}

#endif
