glyphComponents = {
#---lowercase--latin-1-----------------------
    'agrave': ('a', 'gravecomb'),
    'aacute': ('a', 'acutecomb'),
    'acircumflex': ('a', 'uni0302'),
    'atilde': ('a', 'tildecomb'),
    'adieresis': ('a', 'uni0308'),
    'aring': ('a', 'uni030A'),
    'ccedilla': ('c', 'uni0327'),
    'egrave': ('e', 'gravecomb'),
    'eacute': ('e', 'acutecomb'),
    'ecircumflex': ('e', 'uni0302'),
    'edieresis': ('e', 'uni0308'),
    'igrave': ('i.dotless', 'gravecomb'),
    'iacute': ('i.dotless', 'acutecomb'),
    'icircumflex': ('i.dotless', 'uni0302'),
    'idieresis': ('i.dotless', 'uni0308'),
    'ntilde': ('n', 'tildecomb'),
    'ograve': ('o', 'gravecomb'),
    'oacute': ('o', 'acutecomb'),
    'ocircumflex': ('o', 'uni0302'),
    'otilde': ('o', 'tildecomb'),
    'odieresis': ('o', 'uni0308'),
    'ugrave': ('u', 'gravecomb'),
    'uacute': ('u', 'acutecomb'),
    'ucircumflex': ('u', 'uni0302'),
    'udieresis': ('u', 'uni0308'),
    'yacute': ('y', 'acutecomb'),
    'ydieresis': ('y', 'uni0308'),
#------latin-ext-A--------------------------------    
    'amacron': ('a', 'uni0304'),
    'abreve': ('a', 'uni0306'),
    'aogonek': ('a', 'uni0328'),
    'cacute': ('c', 'acutecomb'),
    'ccircumflex': ('c', 'uni0302'),
    'cdotaccent': ('c', 'uni0307'),
    'ccaron': ('c', 'uni030C'),
    'dcaron': ('d', 'uni030C.alt'),
    'emacron': ('e', 'uni0304'),
    'ebreve': ('e', 'uni0306'),
    'edotaccent': ('e', 'uni0307'),
    'eogonek': ('e', 'uni0328'),
    'ecaron': ('e', 'uni030C'),
    'gcircumflex': ('g', 'uni0302'),
    'gbreve': ('g', 'uni0306'),
    'gdotaccent': ('g', 'uni0307'),
    'uni0123': ('g', 'uni0312'),
    'hcircumflex': ('h', 'uni0302.flat'),
    'itilde': ('i.dotless', 'tildecomb'),
    'imacron': ('i.dotless', 'uni0304'),
    'ibreve': ('i.dotless', 'uni0306'),
    'iogonek': ('i', 'uni0328'),
    'jcircumflex': ('j.dotless', 'uni0302'),
    'uni0137': ('k', 'uni0326'),
    'lacute': ('l', 'acutecomb.flat'),
    'uni013C': ('l', 'uni0326'),
    'lcaron': ('l', 'uni030C.alt'),
    'nacute': ('n', 'acutecomb'),
    'uni0146': ('n', 'uni0326'),
    'ncaron': ('n', 'uni030C'),
    'napostrophe': ('n', 'uni030C.alt'),
    'omacron': ('o', 'uni0304'),
    'obreve': ('o', 'uni0306'),
    'ohungarumlaut': ('o', 'uni030B'),
    'racute': ('r', 'acutecomb'),
    'uni0157': ('r', 'uni0326'),
    'rcaron': ('r', 'uni030C'),
    'sacute': ('s', 'acutecomb'),
    'scircumflex': ('s', 'uni0302'),
    'scedilla': ('s', 'uni0327'),
    'scaron': ('s', 'uni030C'),
    'uni0163': ('t', 'uni0327'),
    'tcaron': ('t', 'uni030C.alt'),
    'utilde': ('u', 'tildecomb'),
    'umacron': ('u', 'uni0304'),
    'ubreve': ('u', 'uni0306'),
    'uring': ('u', 'uni030A'),
    'uhungarumlaut': ('u', 'uni030B'),
    'uogonek': ('u', 'uni0328'),
    'wcircumflex': ('w', 'uni0302'),
    'ycircumflex': ('y', 'uni0302'),
    'zacute': ('z', 'acutecomb'),
    'zdotaccent': ('z', 'uni0307'),
    'zcaron': ('z', 'uni030C'),
#-------latin-ext-B----------------------------------------    
    'uni01CE': ('a', 'uni030C'),

    'uni01D0': ('i', 'uni030C'),
    'uni01D2': ('o', 'uni030C'),
    'uni01D4': ('u', 'uni030C'),
    'uni01D6': ('u', 'uni0308', 'uni0304.stack'),
    'uni01D8': ('u', 'uni0308', 'acutecomb.stack'),
    'uni01DA': ('u', 'uni0308', 'uni030C.stack'),
    'uni01DC': ('u', 'uni0308', 'gravecomb.stack'),
    'uni01DF': ('a', 'uni0308', 'uni0304.stack'),

    'uni01E1': ('a', 'uni0307.stack', 'uni0304.stack'),
    'uni01E3': ('ae', 'uni0304'),
    'gcaron': ('g', 'uni030C'),
    'uni01E9': ('k', 'uni030C.flat'),
    'uni01EB': ('o', 'uni0328'),
    'uni01ED': ('o', 'uni0328', 'uni0304'),
    'uni01EF': ('uni0292', 'uni030C'),

    'uni01F0': ('j.dotless', 'uni030C'),
    'uni01F5': ('g', 'acutecomb'),
    'uni01F9': ('n', 'gravecomb'),
    'aringacute': ('a', 'uni030A.stack', 'acutecomb.flat'),
    'aeacute': ('ae', 'acutecomb'),
    'oslashacute': ('oslash', 'acutecomb'),

    'uni0201': ('a', 'uni030F'),
    'uni0203': ('a', 'uni0311'),
    'uni0205': ('e', 'uni030F'),
    'uni0207': ('e', 'uni0311'),
    'uni0209': ('i', 'uni030F'),
    'uni020B': ('i', 'uni0311'),
    'uni020D': ('o', 'uni030F'),
    'uni020F': ('o', 'uni0311'),

    'uni0211': ('r', 'uni030F'),
    'uni0213': ('r', 'uni0311'),
    'uni0215': ('u', 'uni030F'),
    'uni0217': ('u', 'uni0311'),
    'uni0219': ('s', 'uni0326'),
    'uni021B': ('t', 'uni0326'),
    'uni021F': ('h', 'uni030C.flat'),

    'uni0227': ('a', 'uni0307'),
    'uni0229': ('e', 'uni0327'),
    'uni022B': ('o', 'uni0308', 'uni0304.stack'),
    'uni022D': ('o', 'tildecomb.stack', 'uni0304.stack'),
    'uni022F': ('o', 'uni0307'),

    'uni0231': ('o', 'uni0307.stack', 'uni0304.stack'),
    'uni0233': ('y', 'uni0304'),
#---------latin-ext-D-------------------------------------------    
    'uni1E01': ('a', 'uni0325'),
    'uni1E03': ('b', 'uni0307'),
    'uni1E05': ('b', 'dotbelowcomb'),
    'uni1E07': ('b', 'uni0331'),
    'uni1E09': ('c', 'uni0327', 'acutecomb'),
    'uni1E0B': ('d', 'uni0307'),
    'uni1E0D': ('d', 'dotbelowcomb'),
    'uni1E0F': ('d', 'uni0331'),

    'uni1E11': ('d', 'uni0327'),
    'uni1E13': ('d', 'uni032D'),
    'uni1E15': ('e', 'uni0304.stack', 'gravecomb.stack'),
    'uni1E17': ('e', 'uni0304.stack', 'acutecomb.stack'),
    'uni1E19': ('e', 'uni032D'),
    'uni1E1B': ('e', 'uni0330'),
    'uni1E1D': ('e', 'uni0327', 'uni0306'),
    'uni1E1F': ('f', 'uni0307'),
    
    'uni1E21': ('g', 'uni0304'),
    'uni1E23': ('h', 'uni0307'),
    'uni1E25': ('h', 'dotbelowcomb'),
    'uni1E27': ('h', 'uni0308'),
    'uni1E29': ('h', 'uni0327'),
    'uni1E2B': ('h', 'uni032E'),
    'uni1E2D': ('i', 'uni0330'),
    'uni1E2F': ('i.dotless', 'uni0308', 'acutecomb.stack'),

    'uni1E31': ('k', 'acutecomb'),
    'uni1E33': ('k', 'dotbelowcomb'),
    'uni1E35': ('k', 'uni0331'),
    'uni1E37': ('l', 'dotbelowcomb'),
    'uni1E39': ('l', 'dotbelowcomb', 'uni0304'),
    'uni1E3B': ('l', 'uni0331'),
    'uni1E3D': ('l', 'uni032D'),
    'uni1E3F': ('m', 'acutecomb'),

    'uni1E41': ('m', 'uni0307'),
    'uni1E43': ('m', 'dotbelowcomb'),
    'uni1E45': ('n', 'uni0307'),
    'uni1E47': ('n', 'dotbelowcomb'),
    'uni1E49': ('n', 'uni0331'),
    'uni1E4B': ('n', 'uni032D'),
    'uni1E4D': ('o', 'tildecomb.stack', 'acutecomb.stack'),
    'uni1E4F': ('o', 'tildecomb.stack', 'uni0308'),

    'uni1E51': ('o', 'uni0304.stack', 'gravecomb.stack'),
    'uni1E53': ('o', 'uni0304.stack', 'acutecomb.stack'),
    'uni1E55': ('p', 'acutecomb'),
    'uni1E57': ('p', 'uni0307'),
    'uni1E59': ('r', 'uni0307'),
    'uni1E5B': ('r', 'dotbelowcomb'),
    'uni1E5D': ('r', 'dotbelowcomb', 'uni0304'),
    'uni1E5F': ('r', 'uni0331'),

    'uni1E61': ('s', 'uni0307'),
    'uni1E63': ('s', 'dotbelowcomb'),
    'uni1E65': ('s', 'acutecomb.flat', 'uni0307.stack'),
    'uni1E67': ('s', 'uni030C.stack', 'uni0307.stack'),
    'uni1E69': ('s', 'dotbelowcomb', 'uni0307'),
    'uni1E6B': ('t', 'uni0307'),
    'uni1E6D': ('t', 'dotbelowcomb'),
    'uni1E6F': ('t', 'uni0331'),

    'uni1E71': ('t', 'uni032D'),
    'uni1E73': ('u', 'uni0324'),
    'uni1E75': ('u', 'uni0330'),
    'uni1E77': ('u', 'uni032D'),
    'uni1E79': ('u', 'tildecomb.stack', 'acutecomb.stack'),
    'uni1E7B': ('u', 'uni0304.stack', 'uni0308'),
    'uni1E7D': ('v', 'tildecomb'),
    'uni1E7F': ('v', 'dotbelowcomb'),

    'wgrave': ('w', 'gravecomb'),
    'wacute': ('w', 'acutecomb'),
    'wdieresis': ('w', 'uni0308'),
    'uni1E87': ('w', 'uni0307'),
    'uni1E89': ('w', 'dotbelowcomb'),
    'uni1E8B': ('x', 'uni0307'),
    'uni1E8D': ('x', 'uni0308'),
    'uni1E8F': ('y', 'uni0307'),

    'uni1E91': ('z', 'uni0302'),
    'uni1E93': ('z', 'dotbelowcomb'),
    'uni1E95': ('z', 'uni0331'),
    'uni1E96': ('h', 'uni0331'),
    'uni1E97': ('t', 'uni0308'),
    'uni1E98': ('w', 'uni030A'),
    'uni1E99': ('y', 'uni030A'),
    'uni1E9A': ('a', 'uni02BE'),
    'uni1E9B': ('longs', 'uni0307'),

    'uni1EA1': ('a', 'dotbelowcomb'),
    'uni1EA3': ('a', 'hookabovecomb'),
    'uni1EA5': ('a', 'uni0302.stack', 'acutecomb.stack'),
    'uni1EA7': ('a', 'uni0302.stack', 'gravecomb.stack'),
    'uni1EA9': ('a', 'uni0302.stack', 'hookabovecomb.stack'),
    'uni1EAB': ('a', 'uni0302.stack', 'tildecomb.stack'),
    'uni1EAD': ('a', 'dotbelowcomb', 'uni0302'),
    'uni1EAF': ('a', 'uni0306.stack', 'acutecomb.stack'),

    'uni1EB1': ('a', 'uni0306.stack', 'gravecomb.stack'),    
    'uni1EB3': ('a', 'uni0306.stack', 'hookabovecomb.stack'),
    'uni1EB5': ('a', 'uni0306.stack', 'tildecomb.stack'),
    'uni1EB7': ('a', 'dotbelowcomb', 'uni0306'), 
    'uni1EB9': ('e', 'dotbelowcomb'),
    'uni1EBB': ('e', 'hookabovecomb'),
    'uni1EBD': ('e', 'tildecomb'),
    'uni1EBF': ('e', 'uni0302.stack', 'acutecomb.stack'),

    'uni1EC1': ('e', 'uni0302.stack', 'gravecomb.stack'),
    'uni1EC3': ('e', 'uni0302.stack', 'hookabovecomb.stack'),
    'uni1EC5': ('e', 'uni0302.stack', 'tildecomb.stack'),
    'uni1EC7': ('e', 'dotbelowcomb', 'uni0302'),
    'uni1EC9': ('i.dotless', 'hookabovecomb'),
    'uni1ECB': ('i', 'dotbelowcomb'),
    'uni1ECD': ('o', 'dotbelowcomb'),
    'uni1ECF': ('o', 'hookabovecomb'),

    'uni1ED1': ('o', 'uni0302.stack', 'acutecomb.stack'),
    'uni1ED3': ('o', 'uni0302.stack', 'gravecomb.stack'),
    'uni1ED5': ('o', 'uni0302.stack', 'hookabovecomb.stack'),
    'uni1ED7': ('o', 'uni0302.stack', 'tildecomb.stack'),
    'uni1ED9': ('o', 'dotbelowcomb', 'uni0302'),
    'uni1EDB': ('ohorn', 'acutecomb'),
    'uni1EDD': ('ohorn', 'gravecomb'),
    'uni1EDF': ('ohorn', 'hookabovecomb'),

    'uni1EE1': ('ohorn', 'tildecomb'),
    'uni1EE3': ('ohorn', 'dotbelowcomb'),
    'uni1EE5': ('u', 'dotbelowcomb'),
    'uni1EE7': ('u', 'hookabovecomb'),
    'uni1EE9': ('uhorn', 'acutecomb'),
    'uni1EEB': ('uhorn', 'gravecomb'),
    'uni1EED': ('uhorn', 'hookabovecomb'),
    'uni1EEF': ('uhorn', 'tildecomb'),

    'uni1EF1': ('uhorn', 'dotbelowcomb'),
    'ygrave': ('y', 'gravecomb'),
    'uni1EF5': ('y', 'dotbelowcomb'),
    'uni1EF7': ('y', 'hookabovecomb'),
    'uni1EF9': ('y', 'tildecomb'),
#-----------greek-----------------------------------
    'iotadieresistonos': ('iota', 'uni0308.grkstack', 'acutecomb.grk'),
    'alphatonos': ('alpha', 'acutecomb.grk'),
    'epsilontonos': ('epsilon', 'acutecomb.grk'),
    'etatonos': ('eta', 'acutecomb.grk'),
    'iotatonos': ('iota', 'acutecomb.grk'),
    'upsilondieresistonos': ('upsilon', 'uni0308.grkstack', 'acutecomb.grk'),
    'omicrontonos': ('omicron', 'acutecomb.grk'),
    'upsilontonos': ('upsilon', 'acutecomb.grk'),
    'omegatonos': ('omega', 'acutecomb.grk'),
    'iotadieresis': ('iota', 'uni0308'),
    'upsilondieresis': ('upsilon', 'uni0308'),
    'uni1F00': ('alpha', 'uni0313'),
    'uni1F01': ('alpha', 'uni0314'),
    'uni1F02': ('alpha', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1F03': ('alpha', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1F04': ('alpha', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1F05': ('alpha', 'uni0314.grk', 'acutecomb.grkstack'),
    'uni1F06': ('alpha', 'uni0313.grkstack', 'uni0342'),
    'uni1F07': ('alpha', 'uni0314.grkstack', 'uni0342'),
    'uni1F10': ('epsilon', 'uni0313'),
    'uni1F11': ('epsilon', 'uni0314'),
    'uni1F12': ('epsilon', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1F13': ('epsilon', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1F14': ('epsilon', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1F15': ('epsilon', 'uni0314.grk', 'acutecomb.grkstack'),
#    'uni1F16': ('epsilon', 'uni0313.grkstack', 'uni0342'),
#    'uni1F17': ('epsilon', 'uni0314.grkstack', 'uni0342'),
    'uni1F20': ('eta', 'uni0313'),
    'uni1F21': ('eta', 'uni0314'),
    'uni1F22': ('eta', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1F23': ('eta', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1F24': ('eta', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1F25': ('eta', 'uni0314.grk', 'acutecomb.grkstack'),
    'uni1F26': ('eta', 'uni0313.grkstack', 'uni0342'),
    'uni1F27': ('eta', 'uni0314.grkstack', 'uni0342'),
    'uni1F30': ('iota', 'uni0313'),
    'uni1F31': ('iota', 'uni0314'),
    'uni1F32': ('iota', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1F33': ('iota', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1F34': ('iota', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1F35': ('iota', 'uni0314.grk', 'acutecomb.grkstack'),
    'uni1F36': ('iota', 'uni0313.grkstack', 'uni0342'),
    'uni1F37': ('iota', 'uni0314.grkstack', 'uni0342'),
    'uni1F40': ('omicron', 'uni0313'),
    'uni1F41': ('omicron', 'uni0314'),
    'uni1F42': ('omicron', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1F43': ('omicron', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1F44': ('omicron', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1F45': ('omicron', 'uni0314.grk', 'acutecomb.grkstack'),
#    'uni1F46': ('omicron', 'uni0313.grkstack', 'uni0342'),
#    'uni1F47': ('omicron', 'uni0314.grkstack', 'uni0342'),
    'uni1F50': ('upsilon', 'uni0313'),
    'uni1F51': ('upsilon', 'uni0314'),
    'uni1F52': ('upsilon', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1F53': ('upsilon', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1F54': ('upsilon', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1F55': ('upsilon', 'uni0314.grk', 'acutecomb.grkstack'),
    'uni1F56': ('upsilon', 'uni0313.grkstack', 'uni0342'),
    'uni1F57': ('upsilon', 'uni0314.grkstack', 'uni0342'),
    'uni1F60': ('omega', 'uni0313'),
    'uni1F61': ('omega', 'uni0314'),
    'uni1F62': ('omega', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1F63': ('omega', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1F64': ('omega', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1F65': ('omega', 'uni0314.grk', 'acutecomb.grkstack'),
    'uni1F66': ('omega', 'uni0313.grkstack', 'uni0342'),
    'uni1F67': ('omega', 'uni0314.grkstack', 'uni0342'),
    'uni1F70': ('alpha', 'gravecomb.grk'),
    'uni1F71': ('alpha', 'acutecomb.grk'),
    'uni1F72': ('epsilon', 'gravecomb.grk'),
    'uni1F73': ('epsilon', 'acutecomb.grk'),
    'uni1F74': ('eta', 'gravecomb.grk'),
    'uni1F75': ('eta', 'acutecomb.grk'),
    'uni1F76': ('iota', 'gravecomb.grk'),
    'uni1F77': ('iota', 'acutecomb.grk'),
    'uni1F78': ('omicron', 'gravecomb.grk'),
    'uni1F79': ('omicron', 'acutecomb.grk'),
    'uni1F7A': ('upsilon', 'gravecomb.grk'),
    'uni1F7B': ('upsilon', 'acutecomb.grk'),
    'uni1F7C': ('omega', 'gravecomb.grk'),
    'uni1F7D': ('omega', 'acutecomb.grk'),
    'uni1F80': ('alpha', 'uni0345', 'uni0313'),
    'uni1F81': ('alpha', 'uni0345', 'uni0314'),
    'uni1F82': ('alpha', 'uni0345', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1F83': ('alpha', 'uni0345', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1F84': ('alpha', 'uni0345', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1F85': ('alpha', 'uni0345', 'uni0314.grk', 'acutecomb.grkstack'),
    'uni1F86': ('alpha', 'uni0345', 'uni0313.grkstack', 'uni0342'),
    'uni1F87': ('alpha', 'uni0345', 'uni0314.grkstack', 'uni0342'),
    'uni1F90': ('eta', 'uni0345', 'uni0313'),
    'uni1F91': ('eta', 'uni0345', 'uni0314'),
    'uni1F92': ('eta', 'uni0345', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1F93': ('eta', 'uni0345', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1F94': ('eta', 'uni0345', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1F95': ('eta', 'uni0345', 'uni0314.grk', 'acutecomb.grkstack'),
    'uni1F96': ('eta', 'uni0345', 'uni0313.grkstack', 'uni0342'),
    'uni1F97': ('eta', 'uni0345', 'uni0314.grkstack', 'uni0342'),
    'uni1FA0': ('omega', 'uni0345', 'uni0313'),
    'uni1FA1': ('omega', 'uni0345', 'uni0314'),
    'uni1FA2': ('omega', 'uni0345', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1FA3': ('omega', 'uni0345', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1FA4': ('omega', 'uni0345', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1FA5': ('omega', 'uni0345', 'uni0314.grk', 'acutecomb.grkstack'),
    'uni1FA6': ('omega', 'uni0345', 'uni0313.grkstack', 'uni0342'),
    'uni1FA7': ('omega', 'uni0345', 'uni0314.grkstack', 'uni0342'),
    'uni1FB0': ('alpha', 'uni0306'),
    'uni1FB1': ('alpha', 'uni0304'),
    'uni1FB2': ('alpha', 'uni0345', 'gravecomb.grk'),
    'uni1FB3': ('alpha', 'uni0345'),
    'uni1FB4': ('alpha', 'uni0345', 'acutecomb.grk'),
    'uni1FB6': ('alpha', 'uni0342'),
    'uni1FB7': ('alpha', 'uni0345', 'uni0342'),
    'uni1FC2': ('eta', 'uni0345', 'gravecomb.grk'),
    'uni1FC3': ('eta', 'uni0345'),
    'uni1FC4': ('eta', 'uni0345', 'acutecomb.grk'),
    'uni1FC6': ('eta', 'uni0342'),
    'uni1FC7': ('eta', 'uni0345', 'uni0342'),
    'uni1FD0': ('iota', 'uni0306'),
    'uni1FD1': ('iota', 'uni0304'),
    'uni1FD2': ('iota', 'uni0308.grkstack', 'gravecomb.grk'),
    'uni1FD3': ('iota', 'uni0308.grkstack', 'acutecomb.grk'),
    'uni1FD6': ('iota', 'uni0342'),
    'uni1FD7': ('iota', 'uni0308', 'uni0342'),
    'uni1FE0': ('upsilon', 'uni0306'),
    'uni1FE1': ('upsilon', 'uni0304'),
    'uni1FE2': ('upsilon', 'uni0308.grkstack', 'gravecomb.grk'),
    'uni1FE3': ('upsilon', 'uni0308.grkstack', 'acutecomb.grk'),
    'uni1FE4': ('rho', 'uni0313'),
    'uni1FE5': ('rho', 'uni0314'),
    'uni1FE6': ('upsilon', 'uni0342'),
    'uni1FE7': ('upsilon', 'uni0308', 'uni0342'),
    'uni1FF2': ('omega', 'uni0345', 'gravecomb.grk'),
    'uni1FF3': ('omega', 'uni0345'),
    'uni1FF4': ('omega', 'uni0345', 'acutecomb.grk'),
    'uni1FF6': ('omega', 'uni0342'),
    'uni1FF7': ('omega', 'uni0345', 'uni0342'),
#---uppercase-----Latin-1--------------------------------
    'Agrave': ('A', 'gravecomb.cap'),
    'Aacute': ('A', 'acutecomb.cap'),
    'Acircumflex': ('A', 'uni0302.cap'),
    'Atilde': ('A', 'tildecomb.cap'),
    'Adieresis': ('A', 'uni0308.cap'),
    'Aring': ('A', 'uni030A.cap'),
    'Ccedilla': ('C', 'uni0327.cap'),
    'Egrave': ('E', 'gravecomb.cap'),
    'Eacute': ('E', 'acutecomb.cap'),
    'Ecircumflex': ('E', 'uni0302.cap'),
    'Edieresis': ('E', 'uni0308.cap'),
    'Igrave': ('I', 'gravecomb.cap'),
    'Iacute': ('I', 'acutecomb.cap'),
    'Icircumflex': ('I', 'uni0302.cap'),
    'Idieresis': ('I', 'uni0308.cap'),
    'Ntilde': ('N', 'tildecomb.cap'),
    'Ograve': ('O', 'gravecomb.cap'),
    'Oacute': ('O', 'acutecomb.cap'),
    'Ocircumflex': ('O', 'uni0302.cap'),
    'Otilde': ('O', 'tildecomb.cap'),
    'Odieresis': ('O', 'uni0308.cap'),
    'Ugrave': ('U', 'gravecomb.cap'),
    'Uacute': ('U', 'acutecomb.cap'),
    'Ucircumflex': ('U', 'uni0302.cap'),
    'Udieresis': ('U', 'uni0308.cap'),
    'Yacute': ('Y', 'acutecomb.cap'),
#-------Latin-Ext-A-------------------------
    'Amacron': ('A', 'uni0304.cap'),
    'Abreve': ('A', 'uni0306.cap'),
    'Aogonek': ('A', 'uni0328.cap'),
    'Cacute': ('C', 'acutecomb.cap'),
    'Ccircumflex': ('C', 'uni0302.cap'),
    'Cdotaccent': ('C', 'uni0307.cap'),
    'Ccaron': ('C', 'uni030C.cap'),
    'Dcaron': ('D', 'uni030C.cap'),
    'Emacron': ('E', 'uni0304.cap'),
    'Ebreve': ('E', 'uni0306.cap'),
    'Edotaccent': ('E', 'uni0307.cap'),
    'Eogonek': ('E', 'uni0328.cap'),
    'Ecaron': ('E', 'uni030C.cap'),
    'Gcircumflex': ('G', 'uni0302.cap'),
    'Gbreve': ('G', 'uni0306.cap'),
    'Gdotaccent': ('G', 'uni0307.cap'),
    'uni0122': ('G', 'uni0326'),
    'Hcircumflex': ('H', 'uni0302.cap'),
    'Itilde': ('I', 'tildecomb.cap'),
    'Imacron': ('I', 'uni0304.cap'),
    'Ibreve': ('I', 'uni0306.cap'),
    'Iogonek': ('I', 'uni0328.cap'),
    'Idotaccent': ('I', 'uni0307.cap'),
    'Jcircumflex': ('J', 'uni0302.cap'),
    'uni0136': ('K', 'uni0326'),
    'Lacute': ('L', 'acutecomb.cap'),
    'uni013B': ('L', 'uni0326'),
    'Lcaron': ('L', 'uni030C.altcap'),
    'Nacute': ('N', 'acutecomb.cap'),
    'uni0145': ('N', 'uni0326'),
    'Ncaron': ('N', 'uni030C.cap'),
    'Omacron': ('O', 'uni0304.cap'),
    'Obreve': ('O', 'uni0306.cap'),
    'Ohungarumlaut': ('O', 'uni030B.cap'),
    'Racute': ('R', 'acutecomb.cap'),
    'uni0156': ('R', 'uni0326'),
    'Rcaron': ('R', 'uni030C.cap'),
    'Sacute': ('S', 'acutecomb.cap'),
    'Scircumflex': ('S', 'uni0302.cap'),
    'Scedilla': ('S', 'uni0327.cap'),
    'Scaron': ('S', 'uni030C.cap'),
    'uni0162': ('T', 'uni0327.cap'),
    'Tcaron': ('T', 'uni030C.cap'),
    'Utilde': ('U', 'tildecomb.cap'),
    'Umacron': ('U', 'uni0304.cap'),
    'Ubreve': ('U', 'uni0306.cap'),
    'Uring': ('U', 'uni030A.cap'),
    'Uhungarumlaut': ('U', 'uni030B.cap'),
    'Uogonek': ('U', 'uni0328.cap'),
    'Wcircumflex': ('W', 'uni0302.cap'),
    'Ycircumflex': ('Y', 'uni0302.cap'),
    'Ydieresis': ('Y', 'uni0308.cap'),
    'Zacute': ('Z', 'acutecomb.cap'),
    'Zdotaccent': ('Z', 'uni0307.cap'),
    'Zcaron': ('Z', 'uni030C.cap'),
#----------Latin-Ext-B-----------------------------
    'uni01CD': ('A', 'uni030C.cap'),
    'uni01CF': ('I', 'uni030C.cap'),
    'uni01D1': ('O', 'uni030C.cap'),
    'uni01D3': ('U', 'uni030C.cap'),
    'uni01D5': ('U', 'uni0308.cap', 'uni0304.cap'),
    'uni01D7': ('U', 'uni0308.cap', 'acutecomb.flat'),
    'uni01D9': ('U', 'uni0308.cap', 'uni030C.cap'),
    'uni01DB': ('U', 'uni0308.cap', 'gravecomb.flat'),
    'uni01DE': ('A', 'uni0308.cap', 'uni0304.cap'),
    'uni01E0': ('A', 'uni0307.cap', 'uni0304.cap'),
    'uni01E2': ('AE', 'uni0304.cap'),
    'Gcaron': ('G', 'uni030C.cap'),
    'uni01E8': ('K', 'uni030C.cap'),
    'uni01EA': ('O', 'uni0328.cap'),
    'uni01EC': ('O', 'uni0328', 'uni0304.cap'),
    'uni01EE': ('uni01B7', 'uni030C.cap'),
    'uni01F4': ('G', 'acutecomb.cap'),
    'uni01F8': ('N', 'gravecomb.cap'),
    'Aringacute': ('A', 'uni030A.cap', 'acutecomb.flat'),
    'AEacute': ('AE', 'acutecomb.cap'),
    'Oslashacute': ('Oslash', 'acutecomb.cap'),
    'uni0200': ('A', 'uni030F.cap'),
    'uni0202': ('A', 'uni0311.cap'),
    'uni0204': ('E', 'uni030F.cap'),
    'uni0206': ('E', 'uni0311.cap'),
    'uni0208': ('I', 'uni030F.cap'),
    'uni020A': ('I', 'uni0311.cap'),
    'uni020C': ('O', 'uni030F.cap'),
    'uni020E': ('O', 'uni0311.cap'),
    'uni0210': ('R', 'uni030F.cap'),
    'uni0212': ('R', 'uni0311.cap'),
    'uni0214': ('U', 'uni030F.cap'),
    'uni0216': ('U', 'uni0311.cap'),
    'uni0218': ('S', 'uni0326'),
    'uni021A': ('T', 'uni0326'),
    'uni021E': ('H', 'uni030C.cap'),
    'uni0226': ('A', 'uni0307.cap'),
    'uni0228': ('E', 'uni0327.cap'),
    'uni022A': ('O', 'uni0308.cap', 'uni0304.cap'),
    'uni022C': ('O', 'tildecomb.cap', 'uni0304.cap'),
    'uni022E': ('O', 'uni0307.cap'),
    'uni0230': ('O', 'uni0307.cap', 'uni0304.cap'),
    'uni0232': ('Y', 'uni0304.cap'),
#-----Latin-Ext-D-------------------------------------------
    'uni1E00': ('A', 'uni0325.cap'),
    'uni1E02': ('B', 'uni0307.cap'),
    'uni1E04': ('B', 'dotbelowcomb.cap'),
    'uni1E06': ('B', 'uni0331.cap'),
    'uni1E08': ('C', 'uni0327.cap', 'acutecomb.cap'),
    'uni1E0A': ('D', 'uni0307.cap'),
    'uni1E0C': ('D', 'dotbelowcomb.cap'),
    'uni1E0E': ('D', 'uni0331.cap'),

    'uni1E10': ('D', 'uni0327.cap'),
    'uni1E12': ('D', 'uni032D.cap'),
    'uni1E14': ('E', 'uni0304.cap', 'gravecomb.flat'),
    'uni1E16': ('E', 'uni0304.cap', 'acutecomb.flat'),
    'uni1E18': ('E', 'uni032D.cap'),
    'uni1E1A': ('E', 'uni0330.cap'),
    'uni1E1C': ('E', 'uni0327.cap', 'uni0306.cap'),
    'uni1E1E': ('F', 'uni0307.cap'),
    
    'uni1E20': ('G', 'uni0304.cap'),
    'uni1E22': ('H', 'uni0307.cap'),
    'uni1E24': ('H', 'dotbelowcomb.cap'),
    'uni1E26': ('H', 'uni0308.cap'),
    'uni1E28': ('H', 'uni0327.cap'),
    'uni1E2A': ('H', 'uni032E.cap'),
    'uni1E2C': ('I', 'uni0330.cap'),
    'uni1E2E': ('I', 'uni0308.cap', 'acutecomb.cap'),

    'uni1E30': ('K', 'acutecomb.cap'),
    'uni1E32': ('K', 'dotbelowcomb.cap'),
    'uni1E34': ('K', 'uni0331.cap'),
    'uni1E36': ('L', 'dotbelowcomb.cap'),
    'uni1E38': ('L', 'dotbelowcomb.cap', 'uni0304.cap'),
    'uni1E3A': ('L', 'uni0331.cap'),
    'uni1E3C': ('L', 'uni032D.cap'),
    'uni1E3E': ('M', 'acutecomb.cap'),

    'uni1E40': ('M', 'uni0307.cap'),
    'uni1E42': ('M', 'dotbelowcomb.cap'),
    'uni1E44': ('N', 'uni0307.cap'),
    'uni1E46': ('N', 'dotbelowcomb.cap'),
    'uni1E48': ('N', 'uni0331.cap'),
    'uni1E4A': ('N', 'uni032D.cap'),
    'uni1E4C': ('O', 'tildecomb.cap', 'acutecomb.flat'),
    'uni1E4E': ('O', 'tildecomb.cap', 'uni0308.cap'),

    'uni1E50': ('O', 'uni0304.cap', 'gravecomb.flat'),
    'uni1E52': ('O', 'uni0304.cap', 'acutecomb.flat'),
    'uni1E54': ('P', 'acutecomb.cap'),
    'uni1E56': ('P', 'uni0307.cap'),
    'uni1E58': ('R', 'uni0307.cap'),
    'uni1E5A': ('R', 'dotbelowcomb.cap'),
    'uni1E5C': ('R', 'dotbelowcomb.cap', 'uni0304.cap'),
    'uni1E5E': ('R', 'uni0331.cap'),

    'uni1E60': ('S', 'uni0307.cap'),
    'uni1E62': ('S', 'dotbelowcomb.cap'),
    'uni1E64': ('S', 'acutecomb.flat', 'uni0307.cap'),
    'uni1E66': ('S', 'uni030C.cap', 'uni0307.cap'),
    'uni1E68': ('S', 'dotbelowcomb.cap', 'uni0307.cap'),
    'uni1E6A': ('T', 'uni0307.cap'),
    'uni1E6C': ('T', 'dotbelowcomb.cap'),
    'uni1E6E': ('T', 'uni0331.cap'),

    'uni1E70': ('T', 'uni032D.cap'),
    'uni1E72': ('U', 'uni0324.cap'),
    'uni1E74': ('U', 'uni0330.cap'),
    'uni1E76': ('U', 'uni032D.cap'),
    'uni1E78': ('U', 'tildecomb.cap', 'acutecomb.flat'),
    'uni1E7A': ('U', 'uni0304.cap', 'uni0308.cap'),
    'uni1E7C': ('V', 'tildecomb.cap'),
    'uni1E7E': ('V', 'dotbelowcomb.cap'),

    'Wgrave': ('W', 'gravecomb.cap'),
    'Wacute': ('W', 'acutecomb.cap'),
    'Wdieresis': ('W', 'uni0308.cap'),
    'uni1E86': ('W', 'uni0307.cap'),
    'uni1E88': ('W', 'dotbelowcomb.cap'),
    'uni1E8A': ('X', 'uni0307.cap'),
    'uni1E8C': ('X', 'uni0308.cap'),
    'uni1E8E': ('Y', 'uni0307.cap'),

    'uni1E90': ('Z', 'uni0302.cap'),
    'uni1E92': ('Z', 'dotbelowcomb.cap'),
    'uni1E94': ('Z', 'uni0331.cap'),

    'uni1EA0': ('A', 'dotbelowcomb.cap'),
    'uni1EA2': ('A', 'hookabovecomb.cap'),
    'uni1EA4': ('A', 'uni0302.cap', 'acutecomb.capstack'),
    'uni1EA6': ('A', 'uni0302.cap', 'gravecomb.capstack'),
    'uni1EA8': ('A', 'uni0302.cap', 'hookabovecomb.cap'),
    'uni1EAA': ('A', 'uni0302.cap', 'tildecomb.cap'),
    'uni1EAC': ('A', 'dotbelowcomb.cap', 'uni0302.cap'),
    'uni1EAE': ('A', 'uni0306.cap', 'acutecomb.capstack'),

    'uni1EB0': ('A', 'uni0306.cap', 'gravecomb.capstack'),    
    'uni1EB2': ('A', 'uni0306.cap', 'hookabovecomb.cap'),
    'uni1EB4': ('A', 'uni0306.cap', 'tildecomb.cap'),
    'uni1EB6': ('A', 'dotbelowcomb.cap', 'uni0306.cap'), 
    'uni1EB8': ('E', 'dotbelowcomb.cap'),
    'uni1EBA': ('E', 'hookabovecomb.cap'),
    'uni1EBC': ('E', 'tildecomb.cap'),
    'uni1EBE': ('E', 'uni0302.cap', 'acutecomb.capstack'),

    'uni1EC0': ('E', 'uni0302.cap', 'gravecomb.capstack'),
    'uni1EC2': ('E', 'uni0302.cap', 'hookabovecomb.cap'),
    'uni1EC4': ('E', 'uni0302.cap', 'tildecomb.cap'),
    'uni1EC6': ('E', 'dotbelowcomb.cap', 'uni0302.cap'),
    'uni1EC8': ('I', 'hookabovecomb.cap'),
    'uni1ECA': ('I', 'dotbelowcomb.cap'),
    'uni1ECC': ('O', 'dotbelowcomb.cap'),
    'uni1ECE': ('O', 'hookabovecomb.cap'),

    'uni1ED0': ('O', 'uni0302.cap', 'acutecomb.capstack'),
    'uni1ED2': ('O', 'uni0302.cap', 'gravecomb.capstack'),
    'uni1ED4': ('O', 'uni0302.cap', 'hookabovecomb.cap'),
    'uni1ED6': ('O', 'uni0302.cap', 'tildecomb.cap'),
    'uni1ED8': ('O', 'dotbelowcomb.cap', 'uni0302.cap'),
    'uni1EDA': ('Ohorn', 'acutecomb.cap'),
    'uni1EDC': ('Ohorn', 'gravecomb.cap'),
    'uni1EDE': ('Ohorn', 'hookabovecomb.cap'),

    'uni1EE0': ('Ohorn', 'tildecomb.cap'),
    'uni1EE2': ('Ohorn', 'dotbelowcomb.cap'),
    'uni1EE4': ('U', 'dotbelowcomb.cap'),
    'uni1EE6': ('U', 'hookabovecomb.cap'),
    'uni1EE8': ('Uhorn', 'acutecomb.cap'),
    'uni1EEA': ('Uhorn', 'gravecomb.cap'),
    'uni1EEC': ('Uhorn', 'hookabovecomb.cap'),
    'uni1EEE': ('Uhorn', 'tildecomb.cap'),

    'uni1EF0': ('Uhorn', 'dotbelowcomb.cap'),
    'Ygrave': ('Y', 'gravecomb.cap'),
    'uni1EF4': ('Y', 'dotbelowcomb.cap'),
    'uni1EF6': ('Y', 'hookabovecomb.cap'),
    'uni1EF8': ('Y', 'tildecomb.cap'),

#---uppercase------greek-----------------------------------
    'Alphatonos': ('Alpha', 'acutecomb.grk'),
    'Epsilontonos': ('Epsilon', 'acutecomb.grk'),
    'Etatonos': ('Eta', 'acutecomb.grk'),
    'Iotatonos': ('Iota', 'acutecomb.grk'),
    'Omicrontonos': ('Omicron', 'acutecomb.grk'),
    'Upsilontonos': ('Upsilon', 'acutecomb.grk'),
    'Omegatonos': ('uni03A9', 'acutecomb.grk'),
    'Iotadieresis': ('Iota', 'uni0308.cap'),
    'Upsilondieresis': ('Upsilon', 'uni0308.cap'),
    'uni03D3': ('Upsilon', 'acutecomb.grk'),
    'uni03D4': ('Upsilon', 'uni0308.cap'),
    'uni1F08': ('Alpha', 'uni0313'),
    'uni1F09': ('Alpha', 'uni0314'),
    'uni1F0A': ('Alpha', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1F0B': ('Alpha', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1F0C': ('Alpha', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1F0D': ('Alpha', 'uni0314.grk', 'acutecomb.grkstack'),
    'uni1F0E': ('Alpha', 'uni0313.grkstack', 'uni0342'),
    'uni1F0F': ('Alpha', 'uni0314.grkstack', 'uni0342'),
    'uni1F18': ('Epsilon', 'uni0313'),
    'uni1F19': ('Epsilon', 'uni0314'),
    'uni1F1A': ('Epsilon', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1F1B': ('Epsilon', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1F1C': ('Epsilon', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1F1D': ('Epsilon', 'uni0314.grk', 'acutecomb.grkstack'),
#    'uni1F1E': ('Epsilon', 'uni0313.grkstack', 'uni0342'),
#    'uni1F1F': ('Epsilon', 'uni0314.grkstack', 'uni0342'),
    'uni1F28': ('Eta', 'uni0313'),
    'uni1F29': ('Eta', 'uni0314'),
    'uni1F2A': ('Eta', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1F2B': ('Eta', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1F2C': ('Eta', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1F2D': ('Eta', 'uni0314.grk', 'acutecomb.grkstack'),
    'uni1F2E': ('Eta', 'uni0313.grkstack', 'uni0342'),
    'uni1F2F': ('Eta', 'uni0314.grkstack', 'uni0342'),
    'uni1F38': ('Iota', 'uni0313'),
    'uni1F39': ('Iota', 'uni0314'),
    'uni1F3A': ('Iota', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1F3B': ('Iota', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1F3C': ('Iota', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1F3D': ('Iota', 'uni0314.grk', 'acutecomb.grkstack'),
    'uni1F3E': ('Iota', 'uni0313.grkstack', 'uni0342'),
    'uni1F3F': ('Iota', 'uni0314.grkstack', 'uni0342'),
    'uni1F48': ('Omicron', 'uni0313'),
    'uni1F49': ('Omicron', 'uni0314'),
    'uni1F4A': ('Omicron', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1F4B': ('Omicron', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1F4C': ('Omicron', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1F4D': ('Omicron', 'uni0314.grk', 'acutecomb.grkstack'),
#    'uni1F4E': ('Omicron', 'uni0313.grkstack', 'uni0342'),
#    'uni1F4F': ('Omicron', 'uni0314.grkstack', 'uni0342'),
#    'uni1F58': ('Upsilon', 'uni0313'),
    'uni1F59': ('Upsilon', 'uni0314'),
#    'uni1F5A': ('Upsilon', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1F5B': ('Upsilon', 'uni0314.grk', 'gravecomb.grkstack'),
#    'uni1F5C': ('Upsilon', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1F5D': ('Upsilon', 'uni0314.grk', 'acutecomb.grkstack'),
#    'uni1F5E': ('Upsilon', 'uni0313.grkstack', 'uni0342'),
    'uni1F5F': ('Upsilon', 'uni0314.grkstack', 'uni0342'),
    'uni1F68': ('uni03A9', 'uni0313'),
    'uni1F69': ('uni03A9', 'uni0314'),
    'uni1F6A': ('uni03A9', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1F6B': ('uni03A9', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1F6C': ('uni03A9', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1F6D': ('uni03A9', 'uni0314.grk', 'acutecomb.grkstack'),
    'uni1F6E': ('uni03A9', 'uni0313.grkstack', 'uni0342'),
    'uni1F6F': ('uni03A9', 'uni0314.grkstack', 'uni0342'),
    'uni1F88': ('Alpha', 'uni0345.cap', 'uni0313'),
    'uni1F89': ('Alpha', 'uni0345.cap', 'uni0314'),
    'uni1F8A': ('Alpha', 'uni0345.cap', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1F8B': ('Alpha', 'uni0345.cap', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1F8C': ('Alpha', 'uni0345.cap', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1F8D': ('Alpha', 'uni0345.cap', 'uni0314.grk', 'acutecomb.grkstack'),
    'uni1F8E': ('Alpha', 'uni0345.cap', 'uni0313.grkstack', 'uni0342'),
    'uni1F8F': ('Alpha', 'uni0345.cap', 'uni0314.grkstack', 'uni0342'),
    'uni1F98': ('Eta', 'uni0345.cap', 'uni0313'),
    'uni1F99': ('Eta', 'uni0345.cap', 'uni0314'),
    'uni1F9A': ('Eta', 'uni0345.cap', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1F9B': ('Eta', 'uni0345.cap', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1F9C': ('Eta', 'uni0345.cap', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1F9D': ('Eta', 'uni0345.cap', 'uni0314.grk', 'acutecomb.grkstack'),
    'uni1F9E': ('Eta', 'uni0345.cap', 'uni0313.grkstack', 'uni0342'),
    'uni1F9F': ('Eta', 'uni0345.cap', 'uni0314.grkstack', 'uni0342'),
    'uni1FA8': ('uni03A9', 'uni0345.cap', 'uni0313'),
    'uni1FA9': ('uni03A9', 'uni0345.cap', 'uni0314'),
    'uni1FAA': ('uni03A9', 'uni0345.cap', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1FAB': ('uni03A9', 'uni0345.cap', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1FAC': ('uni03A9', 'uni0345.cap', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1FAD': ('uni03A9', 'uni0345.cap', 'uni0314.grk', 'acutecomb.grkstack'),
    'uni1FAE': ('uni03A9', 'uni0345.cap', 'uni0313.grkstack', 'uni0342'),
    'uni1FAF': ('uni03A9', 'uni0345.cap', 'uni0314.grkstack', 'uni0342'),
    'uni1FB8': ('Alpha', 'uni0306.cap'),
    'uni1FB9': ('Alpha', 'uni0304.cap'),
    'uni1FBA': ('Alpha', 'gravecomb.grk'),
    'uni1FBB': ('Alpha', 'acutecomb.grk'),
    'uni1FBC': ('Alpha', 'uni0345.cap'),
    'uni1FC8': ('Epsilon', 'gravecomb.grk'),
    'uni1FC9': ('Epsilon', 'acutecomb.grk'),
    'uni1FCA': ('Eta', 'gravecomb.grk'),
    'uni1FCB': ('Eta', 'acutecomb.grk'),
    'uni1FCC': ('Eta', 'uni0345.cap'),
    'uni1FD8': ('Iota', 'uni0306.cap'),
    'uni1FD9': ('Iota', 'uni0304.cap'),
    'uni1FDA': ('Iota', 'gravecomb.grk'),
    'uni1FDB': ('Iota', 'acutecomb.grk'),
    'uni1FE8': ('Upsilon', 'uni0306.cap'),
    'uni1FE9': ('Upsilon', 'uni0304.cap'),
    'uni1FEA': ('Upsilon', 'gravecomb.grk'),
    'uni1FEB': ('Upsilon', 'acutecomb.grk'),
    'uni1FEC': ('Rho', 'uni0314'),
    'uni1FF8': ('Omicron', 'gravecomb.grk'),
    'uni1FF9': ('Omicron', 'acutecomb.grk'),
    'uni1FFA': ('uni03A9', 'gravecomb.grk'),
    'uni1FFB': ('uni03A9', 'acutecomb.grk'),
    'uni1FFC': ('uni03A9', 'uni0345.cap'),
#---greek spacing modifiers and combining marks----------------------
    'uni0344': ('uni0308.grkstack', 'acutecomb.grk'),
    'dieresistonos': ('space.stack', 'uni0308.grkstack', 'acutecomb.grk'),
    'uni1FBF': ('space.stack', 'uni0313'),
    'uni1FC0': ('space.stack', 'uni0342'),
    'uni1FC1': ('space.stack', 'uni0308', 'uni0342'),
    'uni1FCD': ('space.stack', 'uni0313.grk', 'gravecomb.grkstack'),
    'uni1FCE': ('space.stack', 'uni0313.grk', 'acutecomb.grkstack'),
    'uni1FCF': ('space.stack', 'uni0313.grkstack', 'uni0342'),
    'uni1FDD': ('space.stack', 'uni0314.grk', 'gravecomb.grkstack'),
    'uni1FDE': ('space.stack', 'uni0314.grk', 'acutecomb.grkstack'),
    'uni1FDF': ('space.stack', 'uni0314.grkstack', 'uni0342'),
    'uni1FED': ('space.stack', 'uni0308.grkstack', 'gravecomb.grk'),
    'uni1FEE': ('space.stack', 'uni0308.grkstack', 'acutecomb.grk'),
    'uni1FEF': ('space.stack', 'gravecomb.grk'),
    'uni1FFD': ('space.stack', 'acutecomb.grk'),
    'uni1FFE': ('space.stack', 'uni0314'),

#---alternate glyphs-----------------------------------------------------
    'hcircumflex.01': ('h.01', 'uni0302.flat'),
    'uni01E9.01': 	 ('k.01', 'uni030C.flat'),
    'uni021F.01': 	 ('h.01', 'uni030C.flat'),
    'uni1E23.01': 	 ('h.01', 'uni0307'),
    'uni1E27.01': 	 ('h.01', 'uni0308'),
    'uni1E31.01': 	 ('k.01', 'acutecomb.flat'),
    }
