/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.thredds.server;

import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Formatter;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.ThreddsMetadata;
import thredds.catalog.crawl.CatalogCrawler;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.ui.StopButton;
import ucar.nc2.util.CancelTask;

public class TestMotherlodeModels
implements CatalogCrawler.Listener {
    private String catUrl;
    private int type;
    private boolean skipDatasetScan;
    private InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory(true);
    private ThreddsDataFactory tdataFactory = new ThreddsDataFactory();
    private StopButton stopButton;
    private JLabel label;
    private PrintStream out;
    private int countDatasets;
    private int countNoAccess;
    private int countNoOpen;
    private boolean verbose = true;
    public static JPanel main;

    TestMotherlodeModels(String name, String catURL, int type, boolean skipDatasetScan) throws IOException {
        this.catUrl = catURL;
        this.type = type;
        this.skipDatasetScan = skipDatasetScan;
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createLineBorder(Color.black));
        p.add(new JLabel(name + ":"));
        this.label = new JLabel();
        p.add(this.label);
        this.stopButton = new StopButton("stopit goddammit!");
        p.add(this.stopButton);
        main.add(p);
        this.out = System.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract() throws IOException {
        this.out.println("Read " + this.catUrl);
        InvCatalogImpl cat = this.catFactory.readXML(this.catUrl);
        StringBuilder buff = new StringBuilder();
        boolean isValid = cat.check(buff, false);
        if (!isValid) {
            System.out.println("***Catalog invalid= " + this.catUrl + " validation output=\n" + buff);
            this.out.println("***Catalog invalid= " + this.catUrl + " validation output=\n" + buff);
            return;
        }
        this.out.println("catalog <" + cat.getName() + "> is valid");
        this.out.println(" validation output=\n" + buff);
        this.countDatasets = 0;
        this.countNoAccess = 0;
        this.countNoOpen = 0;
        int countCatRefs = 0;
        CatalogCrawler crawler = new CatalogCrawler(this.type, this.skipDatasetScan, this);
        long start = System.currentTimeMillis();
        try {
            countCatRefs = crawler.crawl(cat, (CancelTask)this.stopButton, this.verbose ? this.out : null);
        }
        finally {
            int took = (int)(System.currentTimeMillis() - start) / 1000;
            this.out.println("***Done " + this.catUrl + " took = " + took + " secs\n" + "   datasets=" + this.countDatasets + " no access=" + this.countNoAccess + " open failed=" + this.countNoOpen + " total catalogs=" + countCatRefs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDataset(InvDataset ds) {
        ++this.countDatasets;
        ThreddsMetadata.GeospatialCoverage gc = ds.getGeospatialCoverage();
        NetcdfDataset ncd = null;
        try {
            Formatter log = new Formatter();
            ncd = this.tdataFactory.openDataset(ds, false, null, log);
            if (ncd == null) {
                this.out.println("**** failed= " + ds.getName() + " err=" + log);
            } else if (this.verbose) {
                this.out.println("   " + ds.getName() + " ok");
            }
        }
        catch (IOException e) {
            this.out.println("**** failed= " + ds.getName() + " err= " + e.getMessage());
        }
        finally {
            if (ncd != null) {
                try {
                    ncd.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public boolean getCatalogRef(InvCatalogRef dd) {
        return true;
    }

    public static void main(String[] args) throws IOException {
        String server = "http://motherlode.ucar.edu:9080/thredds";
        if (args.length > 0) {
            server = args[0];
        }
        String catalog = "/idd/models.xml";
        String problemCat = "/catalog/fmrc/NCEP/RUC2/CONUS_20km/hybrid/catalog.xml";
        String models = "/idd/models.xml";
        String chizModels = "/idd/rtmodel.xml";
        String gribtonc = "/idd/allModels.TDS-nc.xml";
        JFrame frame = new JFrame("TestTDS");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        main = new JPanel();
        main.setLayout(new BoxLayout(main, 1));
        TestMotherlodeModels all_models = new TestMotherlodeModels("models", server + catalog, 3, false);
        frame.getContentPane().add(main);
        frame.pack();
        frame.setLocation(40, 300);
        frame.setVisible(true);
        all_models.extract();
    }
}

