/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.metadata;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.core.metadata.TableMetaDataProvider;
import org.springframework.jdbc.core.metadata.TableParameterMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericTableMetaDataProvider
implements TableMetaDataProvider {
    protected static final Log logger = LogFactory.getLog(TableMetaDataProvider.class);
    private boolean tableColumnMetaDataUsed = false;
    private String databaseVersion;
    private String userName;
    private boolean storesUpperCaseIdentifiers = true;
    private boolean storesLowerCaseIdentifiers = false;
    private boolean getGeneratedKeysSupported = true;
    private boolean generatedKeysColumnNameArraySupported = true;
    private List productsNotSupportingGeneratedKeysColumnNameArray = Arrays.asList("Apache Derby");
    private List<TableParameterMetaData> insertParameterMetaData = new ArrayList<TableParameterMetaData>();

    protected GenericTableMetaDataProvider(DatabaseMetaData databaseMetaData) throws SQLException {
        this.userName = databaseMetaData.getUserName();
    }

    public boolean isStoresUpperCaseIdentifiers() {
        return this.storesUpperCaseIdentifiers;
    }

    public void setStoresUpperCaseIdentifiers(boolean storesUpperCaseIdentifiers) {
        this.storesUpperCaseIdentifiers = storesUpperCaseIdentifiers;
    }

    public boolean isStoresLowerCaseIdentifiers() {
        return this.storesLowerCaseIdentifiers;
    }

    public void setStoresLowerCaseIdentifiers(boolean storesLowerCaseIdentifiers) {
        this.storesLowerCaseIdentifiers = storesLowerCaseIdentifiers;
    }

    @Override
    public boolean isTableColumnMetaDataUsed() {
        return this.tableColumnMetaDataUsed;
    }

    @Override
    public List<TableParameterMetaData> getTableParameterMetaData() {
        return this.insertParameterMetaData;
    }

    @Override
    public boolean isGetGeneratedKeysSupported() {
        return this.getGeneratedKeysSupported;
    }

    @Override
    public boolean isGetGeneratedKeysSimulated() {
        return false;
    }

    @Override
    public String getSimpleQueryForGetGeneratedKey(String tableName, String keyColumnName) {
        return null;
    }

    public void setGetGeneratedKeysSupported(boolean getGeneratedKeysSupported) {
        this.getGeneratedKeysSupported = getGeneratedKeysSupported;
    }

    @Override
    public boolean isGeneratedKeysColumnNameArraySupported() {
        return this.generatedKeysColumnNameArraySupported;
    }

    public void setGeneratedKeysColumnNameArraySupported(boolean generatedKeysColumnNameArraySupported) {
        this.generatedKeysColumnNameArraySupported = generatedKeysColumnNameArraySupported;
    }

    @Override
    public void initializeWithMetaData(DatabaseMetaData databaseMetaData) throws SQLException {
        try {
            if (databaseMetaData.supportsGetGeneratedKeys()) {
                logger.debug("GetGeneratedKeys is supported");
                this.setGetGeneratedKeysSupported(true);
            } else {
                logger.debug("GetGeneratedKeys is not supported");
                this.setGetGeneratedKeysSupported(false);
            }
        }
        catch (SQLException se) {
            logger.warn("Error retrieving 'DatabaseMetaData.getGeneratedKeys' - " + se.getMessage());
        }
        try {
            String databaseProductName = databaseMetaData.getDatabaseProductName();
            if (this.productsNotSupportingGeneratedKeysColumnNameArray.contains(databaseProductName)) {
                logger.debug("GeneratedKeysColumnNameArray is not supported for " + databaseProductName);
                this.setGeneratedKeysColumnNameArraySupported(false);
            } else {
                logger.debug("GeneratedKeysColumnNameArray is supported for " + databaseProductName);
                this.setGeneratedKeysColumnNameArraySupported(true);
            }
        }
        catch (SQLException se) {
            logger.warn("Error retrieving 'DatabaseMetaData.getDatabaseProductName' - " + se.getMessage());
        }
        try {
            this.databaseVersion = databaseMetaData.getDatabaseProductVersion();
        }
        catch (SQLException se) {
            logger.warn("Error retrieving 'DatabaseMetaData.getDatabaseProductVersion' - " + se.getMessage());
        }
        try {
            this.setStoresUpperCaseIdentifiers(databaseMetaData.storesUpperCaseIdentifiers());
        }
        catch (SQLException se) {
            logger.warn("Error retrieving 'DatabaseMetaData.storesUpperCaseIdentifiers' - " + se.getMessage());
        }
        try {
            this.setStoresLowerCaseIdentifiers(databaseMetaData.storesLowerCaseIdentifiers());
        }
        catch (SQLException se) {
            logger.warn("Error retrieving 'DatabaseMetaData.storesLowerCaseIdentifiers' - " + se.getMessage());
        }
    }

    @Override
    public void initializeWithTableColumnMetaData(DatabaseMetaData databaseMetaData, String catalogName, String schemaName, String tableName) throws SQLException {
        this.tableColumnMetaDataUsed = true;
        this.locateTableAndProcessMetaData(databaseMetaData, catalogName, schemaName, tableName);
    }

    @Override
    public String tableNameToUse(String tableName) {
        if (tableName == null) {
            return null;
        }
        if (this.isStoresUpperCaseIdentifiers()) {
            return tableName.toUpperCase();
        }
        if (this.isStoresLowerCaseIdentifiers()) {
            return tableName.toLowerCase();
        }
        return tableName;
    }

    @Override
    public String catalogNameToUse(String catalogName) {
        if (catalogName == null) {
            return null;
        }
        if (this.isStoresUpperCaseIdentifiers()) {
            return catalogName.toUpperCase();
        }
        if (this.isStoresLowerCaseIdentifiers()) {
            return catalogName.toLowerCase();
        }
        return catalogName;
    }

    @Override
    public String schemaNameToUse(String schemaName) {
        if (schemaName == null) {
            return null;
        }
        if (this.isStoresUpperCaseIdentifiers()) {
            return schemaName.toUpperCase();
        }
        if (this.isStoresLowerCaseIdentifiers()) {
            return schemaName.toLowerCase();
        }
        return schemaName;
    }

    @Override
    public String metaDataCatalogNameToUse(String catalogName) {
        return this.catalogNameToUse(catalogName);
    }

    @Override
    public String metaDataSchemaNameToUse(String schemaName) {
        if (schemaName == null) {
            return this.schemaNameToUse(this.userName);
        }
        return this.schemaNameToUse(schemaName);
    }

    protected String getDatabaseVersion() {
        return this.databaseVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locateTableAndProcessMetaData(DatabaseMetaData databaseMetaData, String catalogName, String schemaName, String tableName) {
        TableMetaData tmd;
        HashMap<String, TableMetaData> tableMeta = new HashMap<String, TableMetaData>();
        ResultSet tables = null;
        try {
            tables = databaseMetaData.getTables(this.catalogNameToUse(catalogName), this.schemaNameToUse(schemaName), this.tableNameToUse(tableName), null);
            while (tables != null && tables.next()) {
                tmd = new TableMetaData();
                tmd.setCatalogName(tables.getString("TABLE_CAT"));
                tmd.setSchemaName(tables.getString("TABLE_SCHEM"));
                tmd.setTableName(tables.getString("TABLE_NAME"));
                tmd.setType(tables.getString("TABLE_TYPE"));
                if (tmd.getSchemaName() == null) {
                    tableMeta.put(this.userName.toUpperCase(), tmd);
                    continue;
                }
                tableMeta.put(tmd.getSchemaName().toUpperCase(), tmd);
            }
        }
        catch (SQLException se) {
            logger.warn("Error while accessing table meta data results" + se.getMessage());
        }
        finally {
            if (tables != null) {
                try {
                    tables.close();
                }
                catch (SQLException e) {
                    logger.warn("Error while closing table meta data reults" + e.getMessage());
                }
            }
        }
        if (tableMeta.size() < 1) {
            logger.warn("Unable to locate table meta data for '" + tableName + "' -- column names must be provided");
        } else {
            tmd = null;
            if (schemaName == null) {
                tmd = (TableMetaData)tableMeta.get(this.userName.toUpperCase());
                if (tmd == null) {
                    tmd = (TableMetaData)tableMeta.get("PUBLIC");
                    if (tmd == null) {
                        tmd = (TableMetaData)tableMeta.get("DBO");
                    }
                    if (tmd == null) {
                        throw new DataAccessResourceFailureException("Unable to locate table meta data for '" + tableName + "' in the default schema");
                    }
                }
            } else {
                tmd = (TableMetaData)tableMeta.get(schemaName.toUpperCase());
                if (tmd == null) {
                    throw new DataAccessResourceFailureException("Unable to locate table meta data for '" + tableName + "' in the '" + schemaName + "' schema");
                }
            }
            this.processTableColumns(databaseMetaData, tmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTableColumns(DatabaseMetaData databaseMetaData, TableMetaData tmd) {
        ResultSet tableColumns = null;
        String metaDataCatalogName = this.metaDataCatalogNameToUse(tmd.getCatalogName());
        String metaDataSchemaName = this.metaDataSchemaNameToUse(tmd.getSchemaName());
        String metaDataTableName = this.tableNameToUse(tmd.getTableName());
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieving metadata for " + metaDataCatalogName + "/" + metaDataSchemaName + "/" + metaDataTableName);
        }
        try {
            tableColumns = databaseMetaData.getColumns(metaDataCatalogName, metaDataSchemaName, metaDataTableName, null);
            while (tableColumns.next()) {
                TableParameterMetaData meta = new TableParameterMetaData(tableColumns.getString("COLUMN_NAME"), tableColumns.getInt("DATA_TYPE"), tableColumns.getBoolean("NULLABLE"));
                this.insertParameterMetaData.add(meta);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Retrieved metadata: " + meta.getParameterName() + " " + meta.getSqlType() + " " + meta.isNullable());
            }
        }
        catch (SQLException se) {
            logger.warn("Error while retreiving metadata for procedure columns: " + se.getMessage());
        }
        finally {
            try {
                if (tableColumns != null) {
                    tableColumns.close();
                }
            }
            catch (SQLException se) {
                logger.warn("Problem closing resultset for procedure column metadata " + se.getMessage());
            }
        }
    }

    private class TableMetaData {
        private String catalogName;
        private String schemaName;
        private String tableName;
        private String type;

        private TableMetaData() {
        }

        public String getCatalogName() {
            return this.catalogName;
        }

        public void setCatalogName(String catalogName) {
            this.catalogName = catalogName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

