/*
 * SPDX-FileCopyrightText: (C) 2010 Novell, Inc. (www.novell.com)
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#ifndef EWS_ERRORS_H
#define EWS_ERRORS_H

#include <common/e-soap-response.h>

G_BEGIN_DECLS

GQuark ews_connection_error_quark (void);
#define EWS_CONNECTION_ERROR (ews_connection_error_quark ())

enum {
	EWS_CONNECTION_ERROR_NONE,
	EWS_CONNECTION_ERROR_ACCESSDENIED,
	EWS_CONNECTION_ERROR_ACCOUNTDISABLED,
	EWS_CONNECTION_ERROR_ADDDELEGATESFAILED,
	EWS_CONNECTION_ERROR_ADDRESSSPACENOTFOUND,
	EWS_CONNECTION_ERROR_ADOPERATION,
	EWS_CONNECTION_ERROR_ADSESSIONFILTER,
	EWS_CONNECTION_ERROR_ADUNAVAILABLE,
	EWS_CONNECTION_ERROR_AFFECTEDTASKOCCURRENCESREQUIRED,
	EWS_CONNECTION_ERROR_ATTACHMENTSIZELIMITEXCEEDED,
	EWS_CONNECTION_ERROR_AUTODISCOVERFAILED,
	EWS_CONNECTION_ERROR_AVAILABILITYCONFIGNOTFOUND,
	EWS_CONNECTION_ERROR_BATCHPROCESSINGSTOPPED,
	EWS_CONNECTION_ERROR_CALENDARCANNOTMOVEORCOPYOCCURRENCE,
	EWS_CONNECTION_ERROR_CALENDARCANNOTUPDATEDELETEDITEM,
	EWS_CONNECTION_ERROR_CALENDARCANNOTUSEIDFOROCCURRENCEID,
	EWS_CONNECTION_ERROR_CALENDARCANNOTUSEIDFORRECURRINGMASTERID,
	EWS_CONNECTION_ERROR_CALENDARDURATIONISTOOLONG,
	EWS_CONNECTION_ERROR_CALENDARENDDATEISEARLIERTHANSTARTDATE,
	EWS_CONNECTION_ERROR_CALENDARFOLDERISINVALIDFORCALENDARVIEW,
	EWS_CONNECTION_ERROR_CALENDARINVALIDDAYFORTIMECHANGEPATTERN,
	EWS_CONNECTION_ERROR_CALENDARINVALIDDAYFORWEEKLYRECURRENCE,
	EWS_CONNECTION_ERROR_CALENDARINVALIDPROPERTYSTATE,
	EWS_CONNECTION_ERROR_CALENDARINVALIDPROPERTYVALUE,
	EWS_CONNECTION_ERROR_CALENDARINVALIDRECURRENCE,
	EWS_CONNECTION_ERROR_CALENDARINVALIDTIMEZONE,
	EWS_CONNECTION_ERROR_CALENDARISDELEGATEDFORACCEPT,
	EWS_CONNECTION_ERROR_CALENDARISDELEGATEDFORDECLINE,
	EWS_CONNECTION_ERROR_CALENDARISDELEGATEDFORREMOVE,
	EWS_CONNECTION_ERROR_CALENDARISDELEGATEDFORTENTATIVE,
	EWS_CONNECTION_ERROR_CALENDARISNOTORGANIZER,
	EWS_CONNECTION_ERROR_CALENDARISORGANIZERFORACCEPT,
	EWS_CONNECTION_ERROR_CALENDARISORGANIZERFORDECLINE,
	EWS_CONNECTION_ERROR_CALENDARISORGANIZERFORREMOVE,
	EWS_CONNECTION_ERROR_CALENDARISORGANIZERFORTENTATIVE,
	EWS_CONNECTION_ERROR_CALENDARMEETINGREQUESTISOUTOFDATE,
	EWS_CONNECTION_ERROR_CALENDAROCCURRENCEINDEXISOUTOFRECURRENCERANGE,
	EWS_CONNECTION_ERROR_CALENDAROCCURRENCEISDELETEDFROMRECURRENCE,
	EWS_CONNECTION_ERROR_CALENDAROUTOFRANGE,
	EWS_CONNECTION_ERROR_CALENDARVIEWRANGETOOBIG,
	EWS_CONNECTION_ERROR_CANNOTCREATECALENDARITEMINNONCALENDARFOLDER,
	EWS_CONNECTION_ERROR_CANNOTCREATECONTACTINNONCONTACTFOLDER,
	EWS_CONNECTION_ERROR_CANNOTCREATEPOSTITEMINNONMAILFOLDER,
	EWS_CONNECTION_ERROR_CANNOTCREATETASKINNONTASKFOLDER,
	EWS_CONNECTION_ERROR_CANNOTDELETEOBJECT,
	EWS_CONNECTION_ERROR_CANNOTDELETETASKOCCURRENCE,
	EWS_CONNECTION_ERROR_CANNOTOPENFILEATTACHMENT,
	EWS_CONNECTION_ERROR_CANNOTSETCALENDARPERMISSIONONNONCALENDARFOLDER,
	EWS_CONNECTION_ERROR_CANNOTSETNONCALENDARPERMISSIONONCALENDARFOLDER,
	EWS_CONNECTION_ERROR_CANNOTSETPERMISSIONUNKNOWNENTRIES,
	EWS_CONNECTION_ERROR_CANNOTUSEFOLDERIDFORITEMID,
	EWS_CONNECTION_ERROR_CANNOTUSEITEMIDFORFOLDERID,
	EWS_CONNECTION_ERROR_CHANGEKEYREQUIRED,
	EWS_CONNECTION_ERROR_CHANGEKEYREQUIREDFORWRITEOPERATIONS,
	EWS_CONNECTION_ERROR_CONNECTIONFAILED,
	EWS_CONNECTION_ERROR_CONTENTCONVERSIONFAILED,
	EWS_CONNECTION_ERROR_CORRUPTDATA,
	EWS_CONNECTION_ERROR_CREATEITEMACCESSDENIED,
	EWS_CONNECTION_ERROR_CREATEMANAGEDFOLDERPARTIALCOMPLETION,
	EWS_CONNECTION_ERROR_CREATESUBFOLDERACCESSDENIED,
	EWS_CONNECTION_ERROR_CROSSMAILBOXMOVECOPY,
	EWS_CONNECTION_ERROR_DATASIZELIMITEXCEEDED,
	EWS_CONNECTION_ERROR_DATASOURCEOPERATION,
	EWS_CONNECTION_ERROR_DELEGATEALREADYEXISTS,
	EWS_CONNECTION_ERROR_DELEGATECANNOTADDOWNER,
	EWS_CONNECTION_ERROR_DELEGATEMISSINGCONFIGURATION,
	EWS_CONNECTION_ERROR_DELEGATENOUSER,
	EWS_CONNECTION_ERROR_DELEGATEVALIDATIONFAILED,
	EWS_CONNECTION_ERROR_DELETEDISTINGUISHEDFOLDER,
	EWS_CONNECTION_ERROR_DISTINGUISHEDUSERNOTSUPPORTED,
	EWS_CONNECTION_ERROR_DUPLICATEINPUTFOLDERNAMES,
	EWS_CONNECTION_ERROR_DUPLICATEUSERIDSSPECIFIED,
	EWS_CONNECTION_ERROR_EMAILADDRESSMISMATCH,
	EWS_CONNECTION_ERROR_EVENTNOTFOUND,
	EWS_CONNECTION_ERROR_EXPIREDSUBSCRIPTION,
	EWS_CONNECTION_ERROR_FOLDERCORRUPT,
	EWS_CONNECTION_ERROR_FOLDEREXISTS,
	EWS_CONNECTION_ERROR_FOLDERNOTFOUND,
	EWS_CONNECTION_ERROR_FOLDERPROPERTREQUESTFAILED,
	EWS_CONNECTION_ERROR_FOLDERSAVE,
	EWS_CONNECTION_ERROR_FOLDERSAVEFAILED,
	EWS_CONNECTION_ERROR_FOLDERSAVEPROPERTYERROR,
	EWS_CONNECTION_ERROR_FREEBUSYGENERATIONFAILED,
	EWS_CONNECTION_ERROR_IMPERSONATEUSERDENIED,
	EWS_CONNECTION_ERROR_IMPERSONATIONDENIED,
	EWS_CONNECTION_ERROR_IMPERSONATIONFAILED,
	EWS_CONNECTION_ERROR_INCORRECTSCHEMAVERSION,
	EWS_CONNECTION_ERROR_INCORRECTUPDATEPROPERTYCOUNT,
	EWS_CONNECTION_ERROR_INDIVIDUALMAILBOXLIMITREACHED,
	EWS_CONNECTION_ERROR_INSUFFICIENTRESOURCES,
	EWS_CONNECTION_ERROR_INTERNALSERVERERROR,
	EWS_CONNECTION_ERROR_INTERNALSERVERTRANSIENTERROR,
	EWS_CONNECTION_ERROR_INVALIDACCESSLEVEL,
	EWS_CONNECTION_ERROR_INVALIDATTACHMENTID,
	EWS_CONNECTION_ERROR_INVALIDATTACHMENTSUBFILTER,
	EWS_CONNECTION_ERROR_INVALIDATTACHMENTSUBFILTERTEXTFILTER,
	EWS_CONNECTION_ERROR_INVALIDAUTHORIZATIONCONTEXT,
	EWS_CONNECTION_ERROR_INVALIDCHANGEKEY,
	EWS_CONNECTION_ERROR_INVALIDCLIENTSECURITYCONTEXT,
	EWS_CONNECTION_ERROR_INVALIDCOMPLETEDATE,
	EWS_CONNECTION_ERROR_INVALIDCROSSFORESTCREDENTIALS,
	EWS_CONNECTION_ERROR_INVALIDDELEGATEPERMISSION,
	EWS_CONNECTION_ERROR_INVALIDDELEGATEUSERID,
	EWS_CONNECTION_ERROR_INVALIDEXCHANGEIMPERSONATIONHEADERDATA,
	EWS_CONNECTION_ERROR_INVALIDEXCLUDESRESTRICTION,
	EWS_CONNECTION_ERROR_INVALIDEXTENDEDPROPERTY,
	EWS_CONNECTION_ERROR_INVALIDEXTENDEDPROPERTYVALUE,
	EWS_CONNECTION_ERROR_INVALIDFOLDERID,
	EWS_CONNECTION_ERROR_INVALIDFOLDERTYPEFOROPERATION,
	EWS_CONNECTION_ERROR_INVALIDFRACTIONALPAGINGPARAMETERS,
	EWS_CONNECTION_ERROR_INVALIDFREEBUSYVIEWTYPE,
	EWS_CONNECTION_ERROR_INVALIDID,
	EWS_CONNECTION_ERROR_INVALIDIDEMPTY,
	EWS_CONNECTION_ERROR_INVALIDIDMALFORMED,
	EWS_CONNECTION_ERROR_INVALIDIDMALFORMEDEWSLEGACYIDFORMAT,
	EWS_CONNECTION_ERROR_INVALIDIDMONIKERTOOLONG,
	EWS_CONNECTION_ERROR_INVALIDIDNOTANITEMATTACHMENTID,
	EWS_CONNECTION_ERROR_INVALIDIDRETURNEDBYRESOLVENAMES,
	EWS_CONNECTION_ERROR_INVALIDIDSTOREOBJECTIDTOOLONG,
	EWS_CONNECTION_ERROR_INVALIDIDTOOMANYATTACHMENTLEVELS,
	EWS_CONNECTION_ERROR_INVALIDINDEXEDPAGINGPARAMETERS,
	EWS_CONNECTION_ERROR_INVALIDITEMFOROPERATIONACCEPTITEM,
	EWS_CONNECTION_ERROR_INVALIDITEMFOROPERATIONCANCELITEM,
	EWS_CONNECTION_ERROR_INVALIDITEMFOROPERATIONCREATEITEMATTACHMENT,
	EWS_CONNECTION_ERROR_INVALIDITEMFOROPERATIONCREATEITEM,
	EWS_CONNECTION_ERROR_INVALIDITEMFOROPERATIONDECLINEITEM,
	EWS_CONNECTION_ERROR_INVALIDITEMFOROPERATIONEXPANDDL,
	EWS_CONNECTION_ERROR_INVALIDITEMFOROPERATIONREMOVEITEM,
	EWS_CONNECTION_ERROR_INVALIDITEMFOROPERATIONSENDITEM,
	EWS_CONNECTION_ERROR_INVALIDITEMFOROPERATIONTENTATIVE,
	EWS_CONNECTION_ERROR_INVALIDMANAGEDFOLDERPROPERTY,
	EWS_CONNECTION_ERROR_INVALIDMANAGEDFOLDERQUOTA,
	EWS_CONNECTION_ERROR_INVALIDMANAGEDFOLDERSIZE,
	EWS_CONNECTION_ERROR_INVALIDMERGEDFREEBUSYINTERVAL,
	EWS_CONNECTION_ERROR_INVALIDNAMEFORNAMERESOLUTION,
	EWS_CONNECTION_ERROR_INVALIDNETWORKSERVICECONTEXT,
	EWS_CONNECTION_ERROR_INVALIDOPERATION,
	EWS_CONNECTION_ERROR_INVALIDPAGINGMAXROWS,
	EWS_CONNECTION_ERROR_INVALIDPARENTFOLDER,
	EWS_CONNECTION_ERROR_INVALIDPERCENTCOMPLETEVALUE,
	EWS_CONNECTION_ERROR_INVALIDPERMISSIONSETTINGS,
	EWS_CONNECTION_ERROR_INVALIDPROPERTYAPPEND,
	EWS_CONNECTION_ERROR_INVALIDPROPERTYDELETE,
	EWS_CONNECTION_ERROR_INVALIDPROPERTYFOREXISTS,
	EWS_CONNECTION_ERROR_INVALIDPROPERTYFOROPERATION,
	EWS_CONNECTION_ERROR_INVALIDPROPERTYREQUEST,
	EWS_CONNECTION_ERROR_INVALIDPROPERTYSET,
	EWS_CONNECTION_ERROR_INVALIDPROPERTYUPDATESENTMESSAGE,
	EWS_CONNECTION_ERROR_INVALIDPULLSUBSCRIPTIONID,
	EWS_CONNECTION_ERROR_INVALIDPUSHSUBSCRIPTIONURL,
	EWS_CONNECTION_ERROR_INVALIDRECIPIENTS,
	EWS_CONNECTION_ERROR_INVALIDRECIPIENTSUBFILTER,
	EWS_CONNECTION_ERROR_INVALIDRECIPIENTSUBFILTERCOMPARISON,
	EWS_CONNECTION_ERROR_INVALIDRECIPIENTSUBFILTERORDER,
	EWS_CONNECTION_ERROR_INVALIDRECIPIENTSUBFILTERTEXTFILTER,
	EWS_CONNECTION_ERROR_INVALIDREFERENCEITEM,
	EWS_CONNECTION_ERROR_INVALIDREQUEST,
	EWS_CONNECTION_ERROR_INVALIDROUTINGTYPE,
	EWS_CONNECTION_ERROR_INVALIDSCHEDULEDOOFDURATION,
	EWS_CONNECTION_ERROR_INVALIDSECURITYDESCRIPTOR,
	EWS_CONNECTION_ERROR_INVALIDSENDITEMSAVESETTINGS,
	EWS_CONNECTION_ERROR_INVALIDSERIALIZEDACCESSTOKEN,
	EWS_CONNECTION_ERROR_INVALIDSID,
	EWS_CONNECTION_ERROR_INVALIDSERVERVERSION,
	EWS_CONNECTION_ERROR_INVALIDSMTPADDRESS,
	EWS_CONNECTION_ERROR_INVALIDSUBSCRIPTION,
	EWS_CONNECTION_ERROR_INVALIDSUBSCRIPTIONREQUEST,
	EWS_CONNECTION_ERROR_INVALIDSYNCSTATEDATA,
	EWS_CONNECTION_ERROR_INVALIDTIMEINTERVAL,
	EWS_CONNECTION_ERROR_INVALIDUSERINFO,
	EWS_CONNECTION_ERROR_INVALIDUSEROOFSETTINGS,
	EWS_CONNECTION_ERROR_INVALIDUSERPRINCIPALNAME,
	EWS_CONNECTION_ERROR_INVALIDUSERSID,
	EWS_CONNECTION_ERROR_INVALIDVALUEFORPROPERTY,
	EWS_CONNECTION_ERROR_INVALIDWATERMARK,
	EWS_CONNECTION_ERROR_IRRESOLVABLECONFLICT,
	EWS_CONNECTION_ERROR_ITEMCORRUPT,
	EWS_CONNECTION_ERROR_ITEMNOTFOUND,
	EWS_CONNECTION_ERROR_ITEMPROPERTYREQUESTFAILED,
	EWS_CONNECTION_ERROR_ITEMSAVE,
	EWS_CONNECTION_ERROR_ITEMSAVEPROPERTYERROR,
	EWS_CONNECTION_ERROR_LOGONASNETWORKSERVICEFAILED,
	EWS_CONNECTION_ERROR_MAILBOXCONFIGURATION,
	EWS_CONNECTION_ERROR_MAILBOXDATAARRAYEMPTY,
	EWS_CONNECTION_ERROR_MAILBOXDATAARRAYTOOBIG,
	EWS_CONNECTION_ERROR_MAILBOXLOGONFAILED,
	EWS_CONNECTION_ERROR_MAILBOXMOVEINPROGRESS,
	EWS_CONNECTION_ERROR_MAILBOXSTOREUNAVAILABLE,
	EWS_CONNECTION_ERROR_MAILRECIPIENTNOTFOUND,
	EWS_CONNECTION_ERROR_MANAGEDFOLDERALREADYEXISTS,
	EWS_CONNECTION_ERROR_MANAGEDFOLDERNOTFOUND,
	EWS_CONNECTION_ERROR_MANAGEDFOLDERSROOTFAILURE,
	EWS_CONNECTION_ERROR_MEETINGSUGGESTIONGENERATIONFAILED,
	EWS_CONNECTION_ERROR_MESSAGEDISPOSITIONREQUIRED,
	EWS_CONNECTION_ERROR_MESSAGESIZEEXCEEDED,
	EWS_CONNECTION_ERROR_MIMECONTENTCONVERSIONFAILED,
	EWS_CONNECTION_ERROR_MIMECONTENTINVALID,
	EWS_CONNECTION_ERROR_MIMECONTENTINVALIDBASE64STRING,
	EWS_CONNECTION_ERROR_MISSINGARGUMENT,
	EWS_CONNECTION_ERROR_MISSINGEMAILADDRESS,
	EWS_CONNECTION_ERROR_MISSINGEMAILADDRESSFORMANAGEDFOLDER,
	EWS_CONNECTION_ERROR_MISSINGINFORMATIONEMAILADDRESS,
	EWS_CONNECTION_ERROR_MISSINGINFORMATIONREFERENCEITEMID,
	EWS_CONNECTION_ERROR_MISSINGITEMFORCREATEITEMATTACHMENT,
	EWS_CONNECTION_ERROR_MISSINGMANAGEDFOLDERID,
	EWS_CONNECTION_ERROR_MISSINGRECIPIENTS,
	EWS_CONNECTION_ERROR_MISSINGUSERIDINFORMATION,
	EWS_CONNECTION_ERROR_MORETHANONEACCESSMODESPECIFIED,
	EWS_CONNECTION_ERROR_MOVECOPYFAILED,
	EWS_CONNECTION_ERROR_MOVEDISTINGUISHEDFOLDER,
	EWS_CONNECTION_ERROR_NAMERESOLUTIONMULTIPLERESULTS,
	EWS_CONNECTION_ERROR_NAMERESOLUTIONNOMAILBOX,
	EWS_CONNECTION_ERROR_NAMERESOLUTIONNORESULTS,
	EWS_CONNECTION_ERROR_NOCALENDAR,
	EWS_CONNECTION_ERROR_NODESTINATIONCASDUETOKERBEROSREQUIREMENTS,
	EWS_CONNECTION_ERROR_NODESTINATIONCASDUETOSSLREQUIREMENTS,
	EWS_CONNECTION_ERROR_NODESTINATIONCASDUETOVERSIONMISMATCH,
	EWS_CONNECTION_ERROR_NOFOLDERCLASSOVERRIDE,
	EWS_CONNECTION_ERROR_NOFREEBUSYACCESS,
	EWS_CONNECTION_ERROR_NONEXISTENTMAILBOX,
	EWS_CONNECTION_ERROR_NONPRIMARYSMTPADDRESS,
	EWS_CONNECTION_ERROR_NOPROPERTYTAGFORCUSTOMPROPERTIES,
	EWS_CONNECTION_ERROR_NORESPONDINGCASINDESTINATIONSITE,
	EWS_CONNECTION_ERROR_NOTDELEGATE,
	EWS_CONNECTION_ERROR_NOTENOUGHMEMORY,
	EWS_CONNECTION_ERROR_OBJECTTYPECHANGED,
	EWS_CONNECTION_ERROR_OCCURRENCECROSSINGBOUNDARY,
	EWS_CONNECTION_ERROR_OCCURRENCETIMESPANTOOBIG,
	EWS_CONNECTION_ERROR_OPERATIONNOTALLOWEDWITHPUBLICFOLDERROOT,
	EWS_CONNECTION_ERROR_PARENTFOLDERNOTFOUND,
	EWS_CONNECTION_ERROR_PASSWORDCHANGEREQUIRED,
	EWS_CONNECTION_ERROR_PASSWORDEXPIRED,
	EWS_CONNECTION_ERROR_PROPERTYUPDATE,
	EWS_CONNECTION_ERROR_PROXIEDSUBSCRIPTIONCALLFAILURE,
	EWS_CONNECTION_ERROR_PROXYGROUPSIDLIMITEXCEEDED,
	EWS_CONNECTION_ERROR_PROXYREQUESTNOTALLOWED,
	EWS_CONNECTION_ERROR_PROXYREQUESTPROCESSINGFAILED,
	EWS_CONNECTION_ERROR_PUBLICFOLDERREQUESTPROCESSINGFAILED,
	EWS_CONNECTION_ERROR_PUBLICFOLDERSERVERNOTFOUND,
	EWS_CONNECTION_ERROR_QUERYFILTERTOOLONG,
	EWS_CONNECTION_ERROR_QUOTAEXCEEDED,
	EWS_CONNECTION_ERROR_READEVENTSFAILED,
	EWS_CONNECTION_ERROR_READRECEIPTNOTPENDING,
	EWS_CONNECTION_ERROR_RECURRENCEENDDATETOOBIG,
	EWS_CONNECTION_ERROR_RECURRENCEHASNOOCCURRENCE,
	EWS_CONNECTION_ERROR_REMOVEDELEGATESFAILED,
	EWS_CONNECTION_ERROR_REQUESTSTREAMTOOBIG,
	EWS_CONNECTION_ERROR_REQUIREDPROPERTYMISSING,
	EWS_CONNECTION_ERROR_RESOLVENAMESINVALIDFOLDERTYPE,
	EWS_CONNECTION_ERROR_RESOLVENAMESONLYONECONTACTSFOLDERALLOWED,
	EWS_CONNECTION_ERROR_RESPONSESCHEMAVALIDATION,
	EWS_CONNECTION_ERROR_RESTRICTIONTOOLONG,
	EWS_CONNECTION_ERROR_RESTRICTIONTOOCOMPLEX,
	EWS_CONNECTION_ERROR_RESULTSETTOOBIG,
	EWS_CONNECTION_ERROR_SAVEDITEMFOLDERNOTFOUND,
	EWS_CONNECTION_ERROR_SCHEMAVALIDATION,
	EWS_CONNECTION_ERROR_SEARCHFOLDERNOTINITIALIZED,
	EWS_CONNECTION_ERROR_SENDASDENIED,
	EWS_CONNECTION_ERROR_SENDMEETINGCANCELLATIONSREQUIRED,
	EWS_CONNECTION_ERROR_SENDMEETINGINVITATIONSORCANCELLATIONSREQUIRED,
	EWS_CONNECTION_ERROR_SENDMEETINGINVITATIONSREQUIRED,
	EWS_CONNECTION_ERROR_SENTMEETINGREQUESTUPDATE,
	EWS_CONNECTION_ERROR_SENTTASKREQUESTUPDATE,
	EWS_CONNECTION_ERROR_SERVERBUSY,
	EWS_CONNECTION_ERROR_SERVICEDISCOVERYFAILED,
	EWS_CONNECTION_ERROR_STALEOBJECT,
	EWS_CONNECTION_ERROR_SUBSCRIPTIONACCESSDENIED,
	EWS_CONNECTION_ERROR_SUBSCRIPTIONDELEGATEACCESSNOTSUPPORTED,
	EWS_CONNECTION_ERROR_SUBSCRIPTIONNOTFOUND,
	EWS_CONNECTION_ERROR_SYNCFOLDERNOTFOUND,
	EWS_CONNECTION_ERROR_TIMEINTERVALTOOBIG,
	EWS_CONNECTION_ERROR_TIMEOUTEXPIRED,
	EWS_CONNECTION_ERROR_TIMEZONE,
	EWS_CONNECTION_ERROR_TOFOLDERNOTFOUND,
	EWS_CONNECTION_ERROR_TOKENSERIALIZATIONDENIED,
	EWS_CONNECTION_ERROR_UNSUPPORTEDCULTURE,
	EWS_CONNECTION_ERROR_UNSUPPORTEDMAPIPROPERTYTYPE,
	EWS_CONNECTION_ERROR_UNSUPPORTEDMIMECONVERSION,
	EWS_CONNECTION_ERROR_UNSUPPORTEDPATHFORQUERY,
	EWS_CONNECTION_ERROR_UNSUPPORTEDPATHFORSORTGROUP,
	EWS_CONNECTION_ERROR_UNSUPPORTEDQUERYFILTER,
	EWS_CONNECTION_ERROR_UNSUPPORTEDRECURRENCE,
	EWS_CONNECTION_ERROR_UNSUPPORTEDTYPEFORCONVERSION,
	EWS_CONNECTION_ERROR_UPDATEDELEGATESFAILED,
	EWS_CONNECTION_ERROR_UPDATEPROPERTYMISMATCH,
	EWS_CONNECTION_ERROR_VIRUSDETECTED,
	EWS_CONNECTION_ERROR_VIRUSMESSAGEDELETED,
	EWS_CONNECTION_ERROR_WIN32INTEROPERROR,
	/* Below this point are no longer direct translations of EWS errors */
	EWS_CONNECTION_ERROR_NORESPONSE,
	EWS_CONNECTION_ERROR_AUTHENTICATION_FAILED,
	EWS_CONNECTION_ERROR_UNAVAILABLE,
	EWS_CONNECTION_ERROR_UNKNOWN
};

struct EwsErrorMap {
	const gchar *error_id;
	gint error_code;
};

gint		ews_get_error_code		(const gchar *str);
gboolean	ews_get_response_status		(ESoapParameter *param,
						 GError **error);

G_END_DECLS

#endif /* EWS_ERRORS_H */
