/*
 * Minimal do-nothing recipe to test the ESOREX framework
 *
 * Compile with
 *
 *     gcc -Wall trecipe.c -lcplcore -lcplui -fPIC -shared -o libtrecipe.so
 *
 * Taken and heavily shortened from IIINSTRUMENT pipeline
 * Copyright (C) 2002-2019 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
   
#include <cpl.h>

#define CONTEXT "foo.bar"
#define PACKAGE_NAME "foo"

static int recipe(cpl_frameset *frameset, const cpl_parameterlist *parlist) {
  return CPL_ERROR_NONE;
}

static cpl_error_code recipe_fill_parameterlist(cpl_parameterlist *self) {
  cpl_errorstate prestate = cpl_errorstate_get();
  cpl_parameter *par;

  /* --stropt */
  par = cpl_parameter_new_value(CONTEXT".str_option",
                                CPL_TYPE_STRING, "the string option",
                                CONTEXT, "NONE");
  cpl_parameter_set_alias(par, CPL_PARAMETER_MODE_CLI, "stropt");
  cpl_parameter_disable(par, CPL_PARAMETER_MODE_ENV);
  cpl_parameterlist_append(self, par);

  /* --fileopt */
  par = cpl_parameter_new_value(CONTEXT".file_option",
                                CPL_TYPE_STRING, "the file option",
                                CONTEXT, "NONE");
  cpl_parameter_set_alias(par, CPL_PARAMETER_MODE_CLI, "fileopt");
  cpl_parameter_disable(par, CPL_PARAMETER_MODE_ENV);
  cpl_parameterlist_append(self, par);
  /* --boolopt */
  par = cpl_parameter_new_value(CONTEXT".bool_option",
                                CPL_TYPE_BOOL, "a flag",
                                CONTEXT, TRUE);
  cpl_parameter_set_alias(par, CPL_PARAMETER_MODE_CLI, "boolopt");
  cpl_parameter_disable(par, CPL_PARAMETER_MODE_ENV);
  cpl_parameterlist_append(self, par);

  if (!cpl_errorstate_is_equal(prestate)) {
      return cpl_error_set_message(cpl_func, cpl_error_get_code(),
                                   "rrrecipe_fill_parameterlist failed!");
  }
  return CPL_ERROR_NONE;
}

cpl_recipe_define(recipe, 1000, "F. B.", "foobar@d.o", "2025",
		  "Test recipe.", "Foo\n");
