#if TTBL
/*
 *    tbl.c
 *
 *    "TBL" ASN.1 module encode/decode/print/free C src.
 *
 *    This file was generated by snacc on Mon Jun  2 11:23:56 1997
 *
 *    UBC snacc written by Mike Sample
 *
 *    NOTE: This is a machine generated file - editing not recommended
 */



#include "asn-incl.h"
#include "tbl.h"


AsnLen
BEncTBLRangeContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLRange *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    itemLen = BEncAsnIntContent (b, (&v->to));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, CNTX, PRIM, 1);

    totalLen += itemLen;

    itemLen = BEncAsnIntContent (b, (&v->from));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, CNTX, PRIM, 0);

    totalLen += itemLen;

    return totalLen;

}  /* BEncTBLRangeContent */

void
BDecTBLRangeContent PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
TBLRange *v _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;


    tagId1 = BDecTag (b, &totalElmtsLen1, env);

    if (((tagId1 == MAKE_TAG_ID (CNTX, PRIM, 0))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecAsnIntContent (b, tagId1, elmtLen1, (&v->from), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }
    else
        longjmp (env, -100);


    if (((tagId1 == MAKE_TAG_ID (CNTX, PRIM, 1))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecAsnIntContent (b, tagId1, elmtLen1, (&v->to), &totalElmtsLen1, env);
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1, env);
        else if (totalElmtsLen1 != elmtLen0)
            longjmp (env, -101);
    }
    else
        longjmp (env, -102);


    if (!seqDone)
        longjmp (env, -103);

    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecTBLRangeContent */

void
PrintTBLRange PARAMS ((f, v, indent),
FILE* f _AND_
TBLRange *v _AND_
unsigned short indent)
{
    if (v == NULL)
        return;

    fprintf (f,"{ -- SEQUENCE --\n");

    Indent (f, indent + stdIndentG);
    fprintf (f,"from ");
    PrintAsnInt (f, (&v->from), indent + stdIndentG);
    fprintf (f, ",\n");
    Indent (f, indent + stdIndentG);
    fprintf (f,"to ");
    PrintAsnInt (f, (&v->to), indent + stdIndentG);
    fprintf (f,"\n");
    Indent (f, indent);
    fprintf (f,"}");
}  /* PrintTBLRange */

void
FreeTBLRange PARAMS ((v),
TBLRange *v)
{

    if (v == NULL)
        return;
    FreeAsnInt ((&v->from));

    FreeAsnInt ((&v->to));

}  /* FreeTBLRange */




AsnLen
BEncTBLNamedNumberContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLNamedNumber *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    itemLen = BEncAsnIntContent (b, (&v->value));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, CNTX, PRIM, 1);

    totalLen += itemLen;

    itemLen = BEncPrintableStringContent (b, (&v->name));
    itemLen += BEncDefLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, PRIM, 0);

    totalLen += itemLen;

    return totalLen;

}  /* BEncTBLNamedNumberContent */

void
BDecTBLNamedNumberContent PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
TBLNamedNumber *v _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;


    tagId1 = BDecTag (b, &totalElmtsLen1, env);

    if (((tagId1 == MAKE_TAG_ID (CNTX, PRIM, 0)) ||
(tagId1 == MAKE_TAG_ID (CNTX, CONS, 0))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecPrintableStringContent (b, tagId1, elmtLen1, (&v->name), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }
    else
        longjmp (env, -104);


    if (((tagId1 == MAKE_TAG_ID (CNTX, PRIM, 1))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecAsnIntContent (b, tagId1, elmtLen1, (&v->value), &totalElmtsLen1, env);
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1, env);
        else if (totalElmtsLen1 != elmtLen0)
            longjmp (env, -105);
    }
    else
        longjmp (env, -106);


    if (!seqDone)
        longjmp (env, -107);

    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecTBLNamedNumberContent */

void
PrintTBLNamedNumber PARAMS ((f, v, indent),
FILE* f _AND_
TBLNamedNumber *v _AND_
unsigned short indent)
{
    if (v == NULL)
        return;

    fprintf (f,"{ -- SEQUENCE --\n");

    Indent (f, indent + stdIndentG);
    fprintf (f,"name ");
    PrintPrintableString (f, (&v->name), indent + stdIndentG);
    fprintf (f, ",\n");
    Indent (f, indent + stdIndentG);
    fprintf (f,"value ");
    PrintAsnInt (f, (&v->value), indent + stdIndentG);
    fprintf (f,"\n");
    Indent (f, indent);
    fprintf (f,"}");
}  /* PrintTBLNamedNumber */

void
FreeTBLNamedNumber PARAMS ((v),
TBLNamedNumber *v)
{

    if (v == NULL)
        return;
    FreePrintableString ((&v->name));

    FreeAsnInt ((&v->value));

}  /* FreeTBLNamedNumber */




AsnLen
BEncTBLNamedNumberListContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLNamedNumberList *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

        listLen = 0;
    FOR_EACH_LIST_ELMT_RVS (component, v)
    {
    BEncEocIfNec (b);
    itemLen = BEncTBLNamedNumberContent (b, component);
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, UNIV, CONS, 16);

        listLen += itemLen;
    }
    return listLen;

}  /* BEncTBLNamedNumberListContent */

void
BDecTBLNamedNumberListContent PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
TBLNamedNumberList *v _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;


    for (totalElmtsLen1 = 0; (totalElmtsLen1 < elmtLen0) || (elmtLen0 == INDEFINITE_LEN);)
    {
        TBLNamedNumber **tmpVar;
    tagId1 = BDecTag (b, &totalElmtsLen1, env);

    if ((tagId1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
    {
        BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1, env)
        break; /* got EOC so can exit this SET OF/SEQ OF's for loop*/
    }
    if ((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
    {
        elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    tmpVar = (TBLNamedNumber**) AsnListAppend (v);
    (*tmpVar) = (TBLNamedNumber*) Asn1Alloc (sizeof (TBLNamedNumber));
    CheckAsn1Alloc ((*tmpVar), env);
    BDecTBLNamedNumberContent (b, tagId1, elmtLen1, (*tmpVar), &totalElmtsLen1, env);
    }  /* end of tag check if */
    else  /* wrong tag */
    {
         Asn1Error ("Unexpected Tag\n");
         longjmp (env, -108);
    }
    } /* end of for */

    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecTBLNamedNumberListContent */

void
PrintTBLNamedNumberList PARAMS ((f, v, indent),
FILE* f _AND_
TBLNamedNumberList *v _AND_
unsigned short indent)
{
    TBLNamedNumber *tmp;
    if (v == NULL)
        return;
    fprintf (f,"{ -- SEQUENCE OF -- \n");
    FOR_EACH_LIST_ELMT (tmp, v)
    {
        Indent (f, indent+ stdIndentG);
        PrintTBLNamedNumber (f, tmp, indent + stdIndentG);
        if (tmp != (TBLNamedNumber*)LAST_LIST_ELMT (v))
            fprintf (f,",\n");
    }
    fprintf (f,"\n");
    Indent (f, indent);
    fprintf (f,"}");
}  /* PrintTBLNamedNumberList */

void
FreeTBLNamedNumberList PARAMS ((v),
TBLNamedNumberList *v)
{

    AsnListNode *l;
    AsnListNode *tmp;
    if (v == NULL)
        return;
    for (l = FIRST_LIST_NODE (v); l != NULL; )
    {
        FreeTBLNamedNumber ((l->data));
        tmp = l->next;
        Asn1Free (l->data);
        Asn1Free (l);
        l = tmp;
    }
}  /* FreeTBLNamedNumberList */




AsnLen
BEncTBLTypeRefContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLTypeRef *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    itemLen = BEncAsnBoolContent (b, (&v->implicit));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 1);

    totalLen += itemLen;

    itemLen = BEncTBLTypeDefIdContent (b, (&v->typeDef));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 2);

    totalLen += itemLen;

    return totalLen;

}  /* BEncTBLTypeRefContent */

void
BDecTBLTypeRefContent PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
TBLTypeRef *v _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;


    tagId1 = BDecTag (b, &totalElmtsLen1, env);

    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, INTEGER_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecTBLTypeDefIdContent (b, tagId1, elmtLen1, (&v->typeDef), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }
    else
        longjmp (env, -109);


    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, BOOLEAN_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecAsnBoolContent (b, tagId1, elmtLen1, (&v->implicit), &totalElmtsLen1, env);
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1, env);
        else if (totalElmtsLen1 != elmtLen0)
            longjmp (env, -110);
    }
    else
        longjmp (env, -111);


    if (!seqDone)
        longjmp (env, -112);

    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecTBLTypeRefContent */

void
PrintTBLTypeRef PARAMS ((f, v, indent),
FILE* f _AND_
TBLTypeRef *v _AND_
unsigned short indent)
{
    if (v == NULL)
        return;

    fprintf (f,"{ -- SEQUENCE --\n");

    Indent (f, indent + stdIndentG);
    fprintf (f,"typeDef ");
    PrintTBLTypeDefId (f, (&v->typeDef), indent + stdIndentG);
    fprintf (f, ",\n");
    Indent (f, indent + stdIndentG);
    fprintf (f,"implicit ");
    PrintAsnBool (f, (&v->implicit), indent + stdIndentG);
    fprintf (f,"\n");
    Indent (f, indent);
    fprintf (f,"}");
}  /* PrintTBLTypeRef */

void
FreeTBLTypeRef PARAMS ((v),
TBLTypeRef *v)
{

    if (v == NULL)
        return;
    FreeTBLTypeDefId ((&v->typeDef));

    FreeAsnBool ((&v->implicit));

}  /* FreeTBLTypeRef */




AsnLen
BEncTBLTagContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLTag *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    itemLen = BEncAsnIntContent (b, (&v->code));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 2);

    totalLen += itemLen;

    itemLen = BEncTBLTagClassContent (b, (&v->tclass));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 10);

    totalLen += itemLen;

    return totalLen;

}  /* BEncTBLTagContent */

void
BDecTBLTagContent PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
TBLTag *v _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;


    tagId1 = BDecTag (b, &totalElmtsLen1, env);

    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, ENUM_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecTBLTagClassContent (b, tagId1, elmtLen1, (&v->tclass), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }
    else
        longjmp (env, -113);


    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, INTEGER_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecAsnIntContent (b, tagId1, elmtLen1, (&v->code), &totalElmtsLen1, env);
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1, env);
        else if (totalElmtsLen1 != elmtLen0)
            longjmp (env, -114);
    }
    else
        longjmp (env, -115);


    if (!seqDone)
        longjmp (env, -116);

    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecTBLTagContent */

void
PrintTBLTag PARAMS ((f, v, indent),
FILE* f _AND_
TBLTag *v _AND_
unsigned short indent)
{
    if (v == NULL)
        return;

    fprintf (f,"{ -- SEQUENCE --\n");

    Indent (f, indent + stdIndentG);
    fprintf (f,"tclass ");
    PrintTBLTagClass (f, (&v->tclass), indent + stdIndentG);
    fprintf (f, ",\n");
    Indent (f, indent + stdIndentG);
    fprintf (f,"code ");
    PrintAsnInt (f, (&v->code), indent + stdIndentG);
    fprintf (f,"\n");
    Indent (f, indent);
    fprintf (f,"}");
}  /* PrintTBLTag */

void
FreeTBLTag PARAMS ((v),
TBLTag *v)
{

    if (v == NULL)
        return;
    FreeTBLTagClass ((&v->tclass));

    FreeAsnInt ((&v->code));

}  /* FreeTBLTag */




AsnLen
BEncTBLTypeSeqOfContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLTypeSeqOf *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

        listLen = 0;
    FOR_EACH_LIST_ELMT_RVS (component, v)
    {
    BEncEocIfNec (b);
    itemLen = BEncTBLTagContent (b, component);
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, UNIV, CONS, 16);

        listLen += itemLen;
    }
    return listLen;

}  /* BEncTBLTypeSeqOfContent */

void
BDecTBLTypeSeqOfContent PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
TBLTypeSeqOf *v _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;


    for (totalElmtsLen1 = 0; (totalElmtsLen1 < elmtLen0) || (elmtLen0 == INDEFINITE_LEN);)
    {
        TBLTag **tmpVar;
    tagId1 = BDecTag (b, &totalElmtsLen1, env);

    if ((tagId1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
    {
        BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1, env)
        break; /* got EOC so can exit this SET OF/SEQ OF's for loop*/
    }
    if ((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
    {
        elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    tmpVar = (TBLTag**) AsnListAppend (v);
    (*tmpVar) = (TBLTag*) Asn1Alloc (sizeof (TBLTag));
    CheckAsn1Alloc ((*tmpVar), env);
    BDecTBLTagContent (b, tagId1, elmtLen1, (*tmpVar), &totalElmtsLen1, env);
    }  /* end of tag check if */
    else  /* wrong tag */
    {
         Asn1Error ("Unexpected Tag\n");
         longjmp (env, -117);
    }
    } /* end of for */

    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecTBLTypeSeqOfContent */

void
PrintTBLTypeSeqOf PARAMS ((f, v, indent),
FILE* f _AND_
TBLTypeSeqOf *v _AND_
unsigned short indent)
{
    TBLTag *tmp;
    if (v == NULL)
        return;
    fprintf (f,"{ -- SEQUENCE OF -- \n");
    FOR_EACH_LIST_ELMT (tmp, v)
    {
        Indent (f, indent+ stdIndentG);
        PrintTBLTag (f, tmp, indent + stdIndentG);
        if (tmp != (TBLTag*)LAST_LIST_ELMT (v))
            fprintf (f,",\n");
    }
    fprintf (f,"\n");
    Indent (f, indent);
    fprintf (f,"}");
}  /* PrintTBLTypeSeqOf */

void
FreeTBLTypeSeqOf PARAMS ((v),
TBLTypeSeqOf *v)
{

    AsnListNode *l;
    AsnListNode *tmp;
    if (v == NULL)
        return;
    for (l = FIRST_LIST_NODE (v); l != NULL; )
    {
        FreeTBLTag ((l->data));
        tmp = l->next;
        Asn1Free (l->data);
        Asn1Free (l);
        l = tmp;
    }
}  /* FreeTBLTypeSeqOf */




AsnLen
BEncTBLTypeContentSeqOfContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLTypeContentSeqOf *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

        listLen = 0;
    FOR_EACH_LIST_ELMT_RVS (component, v)
    {
    BEncEocIfNec (b);
    itemLen = BEncTBLTypeContent (b, component);
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, UNIV, CONS, 16);

        listLen += itemLen;
    }
    return listLen;

}  /* BEncTBLTypeContentSeqOfContent */

void
BDecTBLTypeContentSeqOfContent PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
TBLTypeContentSeqOf *v _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;


    for (totalElmtsLen1 = 0; (totalElmtsLen1 < elmtLen0) || (elmtLen0 == INDEFINITE_LEN);)
    {
        TBLType **tmpVar;
    tagId1 = BDecTag (b, &totalElmtsLen1, env);

    if ((tagId1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
    {
        BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1, env)
        break; /* got EOC so can exit this SET OF/SEQ OF's for loop*/
    }
    if ((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
    {
        elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    tmpVar = (TBLType**) AsnListAppend (v);
    (*tmpVar) = (TBLType*) Asn1Alloc (sizeof (TBLType));
    CheckAsn1Alloc ((*tmpVar), env);
    BDecTBLTypeContent (b, tagId1, elmtLen1, (*tmpVar), &totalElmtsLen1, env);
    }  /* end of tag check if */
    else  /* wrong tag */
    {
         Asn1Error ("Unexpected Tag\n");
         longjmp (env, -118);
    }
    } /* end of for */

    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecTBLTypeContentSeqOfContent */

void
PrintTBLTypeContentSeqOf PARAMS ((f, v, indent),
FILE* f _AND_
TBLTypeContentSeqOf *v _AND_
unsigned short indent)
{
    TBLType *tmp;
    if (v == NULL)
        return;
    fprintf (f,"{ -- SEQUENCE OF -- \n");
    FOR_EACH_LIST_ELMT (tmp, v)
    {
        Indent (f, indent+ stdIndentG);
        PrintTBLType (f, tmp, indent + stdIndentG);
        if (tmp != (TBLType*)LAST_LIST_ELMT (v))
            fprintf (f,",\n");
    }
    fprintf (f,"\n");
    Indent (f, indent);
    fprintf (f,"}");
}  /* PrintTBLTypeContentSeqOf */

void
FreeTBLTypeContentSeqOf PARAMS ((v),
TBLTypeContentSeqOf *v)
{

    AsnListNode *l;
    AsnListNode *tmp;
    if (v == NULL)
        return;
    for (l = FIRST_LIST_NODE (v); l != NULL; )
    {
        FreeTBLType ((l->data));
        tmp = l->next;
        Asn1Free (l->data);
        Asn1Free (l);
        l = tmp;
    }
}  /* FreeTBLTypeContentSeqOf */




AsnLen
BEncTBLTypeContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLType *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    if (NOT_NULL ((v->values)))
    {
    BEncEocIfNec (b);
    itemLen = BEncTBLNamedNumberListContent (b, (v->values));
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, CONS, 6);

    totalLen += itemLen;
    }

    if (NOT_NULL ((v->constraint)))
    {
    BEncEocIfNec (b);
    itemLen = BEncTBLRangeContent (b, (v->constraint));
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, CONS, 5);

    totalLen += itemLen;
    }

    if (ASNOCTS_PRESENT ((&v->fieldName)))
    {
    itemLen = BEncPrintableStringContent (b, (&v->fieldName));
    itemLen += BEncDefLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, PRIM, 4);

    totalLen += itemLen;
    }

    BEncEocIfNec (b);
    itemLen = BEncTBLTypeContentContent (b, (v->content));
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, CONS, 3);

    totalLen += itemLen;

    if (NOT_NULL ((v->tagList)))
    {
    BEncEocIfNec (b);
    itemLen = BEncTBLTypeSeqOfContent (b, (v->tagList));
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, CONS, 2);

    totalLen += itemLen;
    }

    itemLen = BEncAsnBoolContent (b, (&v->optional));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, CNTX, PRIM, 1);

    totalLen += itemLen;

    itemLen = BEncTBLTypeIdContent (b, (&v->typeId));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, CNTX, PRIM, 0);

    totalLen += itemLen;

    return totalLen;

}  /* BEncTBLTypeContent */

void
BDecTBLTypeContent PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
TBLType *v _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;
    AsnLen totalElmtsLen2 = 0;
    AsnLen elmtLen2;
    AsnTag tagId2;
    AsnLen totalElmtsLen3 = 0;
    AsnLen elmtLen3;
    AsnTag tagId3;


    tagId1 = BDecTag (b, &totalElmtsLen1, env);

    if (((tagId1 == MAKE_TAG_ID (CNTX, PRIM, 0))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecTBLTypeIdContent (b, tagId1, elmtLen1, (&v->typeId), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }
    else
        longjmp (env, -119);


    if (((tagId1 == MAKE_TAG_ID (CNTX, PRIM, 1))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecAsnBoolContent (b, tagId1, elmtLen1, (&v->optional), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }
    else
        longjmp (env, -120);


    if (((tagId1 == MAKE_TAG_ID (CNTX, CONS, 2))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    (v->tagList) = AsnListNew (sizeof (char*));
    CheckAsn1Alloc ((v->tagList), env);
    BDecTBLTypeSeqOfContent (b, tagId1, elmtLen1, (v->tagList), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }


    if (((tagId1 == MAKE_TAG_ID (CNTX, CONS, 3))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    (v->content) = (TBLTypeContent*) Asn1Alloc (sizeof (TBLTypeContent));
    CheckAsn1Alloc ((v->content), env);
    tagId2 = BDecTag (b, &totalElmtsLen1, env);
    elmtLen2 = BDecLen (b, &totalElmtsLen1, env);
    BDecTBLTypeContentContent (b, tagId2, elmtLen2, (v->content), &totalElmtsLen1, env);
    if (elmtLen1 == INDEFINITE_LEN)
        BDecEoc(b, &totalElmtsLen1, env);
    if (elmtLen1 == INDEFINITE_LEN)
        BDecEoc (b, &totalElmtsLen1, env);
    if ((elmtLen0 != INDEFINITE_LEN) && (totalElmtsLen1 == elmtLen0))
        seqDone = TRUE;
    else
    {
        tagId1 = BDecTag (b, &totalElmtsLen1, env);

         if ((elmtLen0 == INDEFINITE_LEN) && (tagId1 == EOC_TAG_ID))
        {
            BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1, env)
            seqDone = TRUE;
        }
    }
    }
    else
        longjmp (env, -121);


    if ((!seqDone) && ((tagId1 == MAKE_TAG_ID (CNTX, PRIM, 4)) ||
(tagId1 == MAKE_TAG_ID (CNTX, CONS, 4))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecPrintableStringContent (b, tagId1, elmtLen1, (&v->fieldName), &totalElmtsLen1, env);
    if ((elmtLen0 != INDEFINITE_LEN) && (totalElmtsLen1 == elmtLen0))
        seqDone = TRUE;
    else
    {
        tagId1 = BDecTag (b, &totalElmtsLen1, env);

         if ((elmtLen0 == INDEFINITE_LEN) && (tagId1 == EOC_TAG_ID))
        {
            BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1, env)
            seqDone = TRUE;
        }
    }
    }


    if ((!seqDone) && ((tagId1 == MAKE_TAG_ID (CNTX, CONS, 5))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    (v->constraint) = (TBLRange*) Asn1Alloc (sizeof (TBLRange));
    CheckAsn1Alloc ((v->constraint), env);
    BDecTBLRangeContent (b, tagId1, elmtLen1, (v->constraint), &totalElmtsLen1, env);
    if ((elmtLen0 != INDEFINITE_LEN) && (totalElmtsLen1 == elmtLen0))
        seqDone = TRUE;
    else
    {
        tagId1 = BDecTag (b, &totalElmtsLen1, env);

         if ((elmtLen0 == INDEFINITE_LEN) && (tagId1 == EOC_TAG_ID))
        {
            BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1, env)
            seqDone = TRUE;
        }
    }
    }


    if ((!seqDone) && ((tagId1 == MAKE_TAG_ID (CNTX, CONS, 6))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    (v->values) = AsnListNew (sizeof (char*));
    CheckAsn1Alloc ((v->values), env);
    BDecTBLNamedNumberListContent (b, tagId1, elmtLen1, (v->values), &totalElmtsLen1, env);
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1, env);
        else if (totalElmtsLen1 != elmtLen0)
            longjmp (env, -122);
    }


    if (!seqDone)
        longjmp (env, -123);

    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecTBLTypeContent */

void
PrintTBLType PARAMS ((f, v, indent),
FILE* f _AND_
TBLType *v _AND_
unsigned short indent)
{
    if (v == NULL)
        return;

    fprintf (f,"{ -- SEQUENCE --\n");

    Indent (f, indent + stdIndentG);
    fprintf (f,"typeId ");
    PrintTBLTypeId (f, (&v->typeId), indent + stdIndentG);
    fprintf (f, ",\n");
    Indent (f, indent + stdIndentG);
    fprintf (f,"optional ");
    PrintAsnBool (f, (&v->optional), indent + stdIndentG);
    fprintf (f, ",\n");
    if (NOT_NULL ((v->tagList)))
    {
    Indent (f, indent + stdIndentG);
    fprintf (f,"tagList ");
    PrintTBLTypeSeqOf (f, (v->tagList), indent + stdIndentG);
    fprintf (f, ",\n");
    }
    Indent (f, indent + stdIndentG);
    fprintf (f,"content ");
    PrintTBLTypeContent (f, (v->content), indent + stdIndentG);
    if (ASNOCTS_PRESENT ((&v->fieldName)))
    {
    fprintf (f,",\n");
    Indent (f, indent + stdIndentG);
    fprintf (f,"fieldName ");
    PrintPrintableString (f, (&v->fieldName), indent + stdIndentG);
    }
    if (NOT_NULL ((v->constraint)))
    {
    fprintf (f,",\n");
    Indent (f, indent + stdIndentG);
    fprintf (f,"constraint ");
    PrintTBLRange (f, (v->constraint), indent + stdIndentG);
    }
    if (NOT_NULL ((v->values)))
    {
    fprintf (f,",\n");
    Indent (f, indent + stdIndentG);
    fprintf (f,"values ");
    PrintTBLNamedNumberList (f, (v->values), indent + stdIndentG);
    }
    fprintf (f,"\n");
    Indent (f, indent);
    fprintf (f,"}");
}  /* PrintTBLType */

void
FreeTBLType PARAMS ((v),
TBLType *v)
{

    if (v == NULL)
        return;
    FreeTBLTypeId ((&v->typeId));

    FreeAsnBool ((&v->optional));

    if (NOT_NULL ((v->tagList)))
    {
    FreeTBLTypeSeqOf ((v->tagList));
    Asn1Free ((v->tagList));
    }

    FreeTBLTypeContent ((v->content));
    Asn1Free ((v->content));

    if (ASNOCTS_PRESENT ((&v->fieldName)))
    {
    FreePrintableString ((&v->fieldName));
    }

    if (NOT_NULL ((v->constraint)))
    {
    FreeTBLRange ((v->constraint));
    Asn1Free ((v->constraint));
    }

    if (NOT_NULL ((v->values)))
    {
    FreeTBLNamedNumberList ((v->values));
    Asn1Free ((v->values));
    }

}  /* FreeTBLType */




AsnLen
BEncTBLTypeContentContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLTypeContent *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    switch (v->choiceId)
    {
       case TBLTYPECONTENT_PRIMTYPE:
    itemLen = BEncAsnNullContent (b, (&v->a.primType));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, CNTX, PRIM, 0);

    totalLen += itemLen;

    break;

       case TBLTYPECONTENT_ELMTS:
    BEncEocIfNec (b);
    itemLen = BEncTBLTypeContentSeqOfContent (b, (v->a.elmts));
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, CONS, 1);

    totalLen += itemLen;

    break;

       case TBLTYPECONTENT_TYPEREF:
    BEncEocIfNec (b);
    itemLen = BEncTBLTypeRefContent (b, (v->a.typeRef));
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, CONS, 2);

    totalLen += itemLen;

    break;

    }
    return totalLen;

}  /* BEncTBLTypeContentContent */

void
BDecTBLTypeContentContent PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
TBLTypeContent *v _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;


    switch (tagId0)
    {
       case MAKE_TAG_ID (CNTX, PRIM, 0):
        (v->choiceId) = TBLTYPECONTENT_PRIMTYPE;
    BDecAsnNullContent (b, tagId0, elmtLen0, (&v->a.primType), &totalElmtsLen1, env);
    break;

       case MAKE_TAG_ID (CNTX, CONS, 1):
        (v->choiceId) = TBLTYPECONTENT_ELMTS;
    (v->a.elmts) = AsnListNew (sizeof (char*));
    CheckAsn1Alloc ((v->a.elmts), env);
    BDecTBLTypeContentSeqOfContent (b, tagId0, elmtLen0, (v->a.elmts), &totalElmtsLen1, env);
    break;

       case MAKE_TAG_ID (CNTX, CONS, 2):
        (v->choiceId) = TBLTYPECONTENT_TYPEREF;
    (v->a.typeRef) = (TBLTypeRef*) Asn1Alloc (sizeof (TBLTypeRef));
    CheckAsn1Alloc ((v->a.typeRef), env);
    BDecTBLTypeRefContent (b, tagId0, elmtLen0, (v->a.typeRef), &totalElmtsLen1, env);
    break;

    default:
        Asn1Error ("ERROR - unexpected tag in CHOICE\n");
        longjmp (env, -124);
        break;
    } /* end switch */
    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecTBLTypeContentContent */

void
PrintTBLTypeContent PARAMS ((f, v, indent),
FILE* f _AND_
TBLTypeContent *v _AND_
unsigned short indent)
{
    switch (v->choiceId)
    {
      case TBLTYPECONTENT_PRIMTYPE:
          fprintf (f,"primType ");
    PrintAsnNull (f, (&v->a.primType), indent + stdIndentG);
          break;

      case TBLTYPECONTENT_ELMTS:
          fprintf (f,"elmts ");
    PrintTBLTypeContentSeqOf (f, (v->a.elmts), indent + stdIndentG);
          break;

      case TBLTYPECONTENT_TYPEREF:
          fprintf (f,"typeRef ");
    PrintTBLTypeRef (f, (v->a.typeRef), indent + stdIndentG);
          break;

    }
}  /* PrintTBLTypeContent */

void
FreeTBLTypeContent PARAMS ((v),
TBLTypeContent *v)
{

    if (v == NULL)
        return;
    switch (v->choiceId)
    {
       case TBLTYPECONTENT_ELMTS:
    FreeTBLTypeContentSeqOf ((v->a.elmts));
    Asn1Free ((v->a.elmts));

    break;

       case TBLTYPECONTENT_TYPEREF:
    FreeTBLTypeRef ((v->a.typeRef));
    Asn1Free ((v->a.typeRef));

    break;

    }
}  /* FreeTBLTypeContent */




AsnLen
BEncTBLTypeDefContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLTypeDef *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    if (NOT_NULL ((v->isPdu)))
    {
    itemLen = BEncAsnNullContent (b, (v->isPdu));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 5);

    totalLen += itemLen;
    }

    BEncEocIfNec (b);
    itemLen = BEncTBLTypeContent (b, (v->type));
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, UNIV, CONS, 16);

    totalLen += itemLen;

    itemLen = BEncPrintableStringContent (b, (&v->typeName));
    itemLen += BEncDefLen (b, itemLen);
    itemLen += BEncTag1 (b, UNIV, PRIM, 19);

    totalLen += itemLen;

    itemLen = BEncTBLTypeDefIdContent (b, (&v->typeDefId));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 2);

    totalLen += itemLen;

    return totalLen;

}  /* BEncTBLTypeDefContent */

void
BDecTBLTypeDefContent PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
TBLTypeDef *v _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;


    tagId1 = BDecTag (b, &totalElmtsLen1, env);

    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, INTEGER_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecTBLTypeDefIdContent (b, tagId1, elmtLen1, (&v->typeDefId), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }
    else
        longjmp (env, -125);


    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, PRINTABLESTRING_TAG_CODE)) ||
(tagId1 == MAKE_TAG_ID (UNIV, CONS, PRINTABLESTRING_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecPrintableStringContent (b, tagId1, elmtLen1, (&v->typeName), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }
    else
        longjmp (env, -126);


    if (((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    (v->type) = (TBLType*) Asn1Alloc (sizeof (TBLType));
    CheckAsn1Alloc ((v->type), env);
    BDecTBLTypeContent (b, tagId1, elmtLen1, (v->type), &totalElmtsLen1, env);
    if ((elmtLen0 != INDEFINITE_LEN) && (totalElmtsLen1 == elmtLen0))
        seqDone = TRUE;
    else
    {
        tagId1 = BDecTag (b, &totalElmtsLen1, env);

         if ((elmtLen0 == INDEFINITE_LEN) && (tagId1 == EOC_TAG_ID))
        {
            BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1, env)
            seqDone = TRUE;
        }
    }
    }
    else
        longjmp (env, -127);


    if ((!seqDone) && ((tagId1 == MAKE_TAG_ID (UNIV, PRIM, NULLTYPE_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    (v->isPdu) = (AsnNull*) Asn1Alloc (sizeof (AsnNull));
    CheckAsn1Alloc ((v->isPdu), env);
    BDecAsnNullContent (b, tagId1, elmtLen1, (v->isPdu), &totalElmtsLen1, env);
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1, env);
        else if (totalElmtsLen1 != elmtLen0)
            longjmp (env, -128);
    }


    if (!seqDone)
        longjmp (env, -129);

    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecTBLTypeDefContent */

void
PrintTBLTypeDef PARAMS ((f, v, indent),
FILE* f _AND_
TBLTypeDef *v _AND_
unsigned short indent)
{
    if (v == NULL)
        return;

    fprintf (f,"{ -- SEQUENCE --\n");

    Indent (f, indent + stdIndentG);
    fprintf (f,"typeDefId ");
    PrintTBLTypeDefId (f, (&v->typeDefId), indent + stdIndentG);
    fprintf (f, ",\n");
    Indent (f, indent + stdIndentG);
    fprintf (f,"typeName ");
    PrintPrintableString (f, (&v->typeName), indent + stdIndentG);
    fprintf (f, ",\n");
    Indent (f, indent + stdIndentG);
    fprintf (f,"type ");
    PrintTBLType (f, (v->type), indent + stdIndentG);
    if (NOT_NULL ((v->isPdu)))
    {
    fprintf (f,",\n");
    Indent (f, indent + stdIndentG);
    fprintf (f,"isPdu ");
    PrintAsnNull (f, (v->isPdu), indent + stdIndentG);
    }
    fprintf (f,"\n");
    Indent (f, indent);
    fprintf (f,"}");
}  /* PrintTBLTypeDef */

void
FreeTBLTypeDef PARAMS ((v),
TBLTypeDef *v)
{

    if (v == NULL)
        return;
    FreeTBLTypeDefId ((&v->typeDefId));

    FreePrintableString ((&v->typeName));

    FreeTBLType ((v->type));
    Asn1Free ((v->type));

    if (NOT_NULL ((v->isPdu)))
    {
    FreeAsnNull ((v->isPdu));
    Asn1Free ((v->isPdu));
    }

}  /* FreeTBLTypeDef */




AsnLen
BEncTBLModuleSeqOfContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLModuleSeqOf *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

        listLen = 0;
    FOR_EACH_LIST_ELMT_RVS (component, v)
    {
    BEncEocIfNec (b);
    itemLen = BEncTBLTypeDefContent (b, component);
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, UNIV, CONS, 16);

        listLen += itemLen;
    }
    return listLen;

}  /* BEncTBLModuleSeqOfContent */

void
BDecTBLModuleSeqOfContent PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
TBLModuleSeqOf *v _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;


    for (totalElmtsLen1 = 0; (totalElmtsLen1 < elmtLen0) || (elmtLen0 == INDEFINITE_LEN);)
    {
        TBLTypeDef **tmpVar;
    tagId1 = BDecTag (b, &totalElmtsLen1, env);

    if ((tagId1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
    {
        BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1, env)
        break; /* got EOC so can exit this SET OF/SEQ OF's for loop*/
    }
    if ((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
    {
        elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    tmpVar = (TBLTypeDef**) AsnListAppend (v);
    (*tmpVar) = (TBLTypeDef*) Asn1Alloc (sizeof (TBLTypeDef));
    CheckAsn1Alloc ((*tmpVar), env);
    BDecTBLTypeDefContent (b, tagId1, elmtLen1, (*tmpVar), &totalElmtsLen1, env);
    }  /* end of tag check if */
    else  /* wrong tag */
    {
         Asn1Error ("Unexpected Tag\n");
         longjmp (env, -130);
    }
    } /* end of for */

    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecTBLModuleSeqOfContent */

void
PrintTBLModuleSeqOf PARAMS ((f, v, indent),
FILE* f _AND_
TBLModuleSeqOf *v _AND_
unsigned short indent)
{
    TBLTypeDef *tmp;
    if (v == NULL)
        return;
    fprintf (f,"{ -- SEQUENCE OF -- \n");
    FOR_EACH_LIST_ELMT (tmp, v)
    {
        Indent (f, indent+ stdIndentG);
        PrintTBLTypeDef (f, tmp, indent + stdIndentG);
        if (tmp != (TBLTypeDef*)LAST_LIST_ELMT (v))
            fprintf (f,",\n");
    }
    fprintf (f,"\n");
    Indent (f, indent);
    fprintf (f,"}");
}  /* PrintTBLModuleSeqOf */

void
FreeTBLModuleSeqOf PARAMS ((v),
TBLModuleSeqOf *v)
{

    AsnListNode *l;
    AsnListNode *tmp;
    if (v == NULL)
        return;
    for (l = FIRST_LIST_NODE (v); l != NULL; )
    {
        FreeTBLTypeDef ((l->data));
        tmp = l->next;
        Asn1Free (l->data);
        Asn1Free (l);
        l = tmp;
    }
}  /* FreeTBLModuleSeqOf */




AsnLen
BEncTBLModuleContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLModule *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    BEncEocIfNec (b);
    itemLen = BEncTBLModuleSeqOfContent (b, (v->typeDefs));
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, CONS, 3);

    totalLen += itemLen;

    itemLen = BEncAsnBoolContent (b, (&v->isUseful));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, CNTX, PRIM, 2);

    totalLen += itemLen;

    if (ASNOID_PRESENT ((&v->id)))
    {
    itemLen = BEncAsnOidContent (b, (&v->id));
    itemLen += BEncDefLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, PRIM, 1);

    totalLen += itemLen;
    }

    itemLen = BEncPrintableStringContent (b, (&v->name));
    itemLen += BEncDefLen (b, itemLen);
    itemLen += BEncTag1 (b, CNTX, PRIM, 0);

    totalLen += itemLen;

    return totalLen;

}  /* BEncTBLModuleContent */

void
BDecTBLModuleContent PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
TBLModule *v _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;


    tagId1 = BDecTag (b, &totalElmtsLen1, env);

    if (((tagId1 == MAKE_TAG_ID (CNTX, PRIM, 0)) ||
(tagId1 == MAKE_TAG_ID (CNTX, CONS, 0))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecPrintableStringContent (b, tagId1, elmtLen1, (&v->name), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }
    else
        longjmp (env, -131);


    if (((tagId1 == MAKE_TAG_ID (CNTX, PRIM, 1))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecAsnOidContent (b, tagId1, elmtLen1, (&v->id), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }


    if (((tagId1 == MAKE_TAG_ID (CNTX, PRIM, 2))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecAsnBoolContent (b, tagId1, elmtLen1, (&v->isUseful), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }
    else
        longjmp (env, -132);


    if (((tagId1 == MAKE_TAG_ID (CNTX, CONS, 3))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    (v->typeDefs) = AsnListNew (sizeof (char*));
    CheckAsn1Alloc ((v->typeDefs), env);
    BDecTBLModuleSeqOfContent (b, tagId1, elmtLen1, (v->typeDefs), &totalElmtsLen1, env);
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1, env);
        else if (totalElmtsLen1 != elmtLen0)
            longjmp (env, -133);
    }
    else
        longjmp (env, -134);


    if (!seqDone)
        longjmp (env, -135);

    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecTBLModuleContent */

void
PrintTBLModule PARAMS ((f, v, indent),
FILE* f _AND_
TBLModule *v _AND_
unsigned short indent)
{
    if (v == NULL)
        return;

    fprintf (f,"{ -- SEQUENCE --\n");

    Indent (f, indent + stdIndentG);
    fprintf (f,"name ");
    PrintPrintableString (f, (&v->name), indent + stdIndentG);
    fprintf (f, ",\n");
    if (ASNOID_PRESENT ((&v->id)))
    {
    Indent (f, indent + stdIndentG);
    fprintf (f,"id ");
    PrintAsnOid (f, (&v->id), indent + stdIndentG);
    fprintf (f, ",\n");
    }
    Indent (f, indent + stdIndentG);
    fprintf (f,"isUseful ");
    PrintAsnBool (f, (&v->isUseful), indent + stdIndentG);
    fprintf (f, ",\n");
    Indent (f, indent + stdIndentG);
    fprintf (f,"typeDefs ");
    PrintTBLModuleSeqOf (f, (v->typeDefs), indent + stdIndentG);
    fprintf (f,"\n");
    Indent (f, indent);
    fprintf (f,"}");
}  /* PrintTBLModule */

void
FreeTBLModule PARAMS ((v),
TBLModule *v)
{

    if (v == NULL)
        return;
    FreePrintableString ((&v->name));

    if (ASNOID_PRESENT ((&v->id)))
    {
    FreeAsnOid ((&v->id));
    }

    FreeAsnBool ((&v->isUseful));

    FreeTBLModuleSeqOf ((v->typeDefs));
    Asn1Free ((v->typeDefs));

}  /* FreeTBLModule */




AsnLen
BEncTBLSeqOfContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBLSeqOf *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

        listLen = 0;
    FOR_EACH_LIST_ELMT_RVS (component, v)
    {
    BEncEocIfNec (b);
    itemLen = BEncTBLModuleContent (b, component);
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, UNIV, CONS, 16);

        listLen += itemLen;
    }
    return listLen;

}  /* BEncTBLSeqOfContent */

void
BDecTBLSeqOfContent PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
TBLSeqOf *v _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;


    for (totalElmtsLen1 = 0; (totalElmtsLen1 < elmtLen0) || (elmtLen0 == INDEFINITE_LEN);)
    {
        TBLModule **tmpVar;
    tagId1 = BDecTag (b, &totalElmtsLen1, env);

    if ((tagId1 == EOC_TAG_ID) && (elmtLen0 == INDEFINITE_LEN))
    {
        BDEC_2ND_EOC_OCTET (b, &totalElmtsLen1, env)
        break; /* got EOC so can exit this SET OF/SEQ OF's for loop*/
    }
    if ((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
    {
        elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    tmpVar = (TBLModule**) AsnListAppend (v);
    (*tmpVar) = (TBLModule*) Asn1Alloc (sizeof (TBLModule));
    CheckAsn1Alloc ((*tmpVar), env);
    BDecTBLModuleContent (b, tagId1, elmtLen1, (*tmpVar), &totalElmtsLen1, env);
    }  /* end of tag check if */
    else  /* wrong tag */
    {
         Asn1Error ("Unexpected Tag\n");
         longjmp (env, -136);
    }
    } /* end of for */

    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecTBLSeqOfContent */

void
PrintTBLSeqOf PARAMS ((f, v, indent),
FILE* f _AND_
TBLSeqOf *v _AND_
unsigned short indent)
{
    TBLModule *tmp;
    if (v == NULL)
        return;
    fprintf (f,"{ -- SEQUENCE OF -- \n");
    FOR_EACH_LIST_ELMT (tmp, v)
    {
        Indent (f, indent+ stdIndentG);
        PrintTBLModule (f, tmp, indent + stdIndentG);
        if (tmp != (TBLModule*)LAST_LIST_ELMT (v))
            fprintf (f,",\n");
    }
    fprintf (f,"\n");
    Indent (f, indent);
    fprintf (f,"}");
}  /* PrintTBLSeqOf */

void
FreeTBLSeqOf PARAMS ((v),
TBLSeqOf *v)
{

    AsnListNode *l;
    AsnListNode *tmp;
    if (v == NULL)
        return;
    for (l = FIRST_LIST_NODE (v); l != NULL; )
    {
        FreeTBLModule ((l->data));
        tmp = l->next;
        Asn1Free (l->data);
        Asn1Free (l);
        l = tmp;
    }
}  /* FreeTBLSeqOf */




AsnLen BEncTBL PARAMS ((b, v),
BUF_TYPE b _AND_
TBL *v)
{
    AsnLen l;
    BEncEocIfNec (b);
    l = BEncTBLContent (b, v);
    l += BEncConsLen (b, l);
    l += BEncTag1 (b, UNIV, CONS, SEQ_TAG_CODE);
    return l;
} /* BEncTBL */

void BDecTBL PARAMS ((b, result, bytesDecoded, env),
BUF_TYPE b _AND_
TBL *result _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    AsnTag tag;
    AsnLen elmtLen1;

    if (((tag = BDecTag (b, bytesDecoded, env)) != 
MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE)))
    {
        Asn1Error ("BDecTBL: ERROR - wrong tag\n");
        longjmp (env, -137);
    }
    elmtLen1 = BDecLen (b, bytesDecoded, env);
    BDecTBLContent (b, tag, elmtLen1, result, bytesDecoded, env);
}  /* BDecTBL */

AsnLen
BEncTBLContent PARAMS ((b, v),
BUF_TYPE b _AND_
TBL *v)
{
    AsnLen totalLen = 0;
    AsnLen itemLen;
    AsnLen listLen;
    void *component;

    BEncEocIfNec (b);
    itemLen = BEncTBLSeqOfContent (b, (v->modules));
    itemLen += BEncConsLen (b, itemLen);
    itemLen += BEncTag1 (b, UNIV, CONS, 16);

    totalLen += itemLen;

    itemLen = BEncAsnIntContent (b, (&v->totalLenStrings));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 2);

    totalLen += itemLen;

    itemLen = BEncAsnIntContent (b, (&v->totalNumStrings));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 2);

    totalLen += itemLen;

    itemLen = BEncAsnIntContent (b, (&v->totalNumTags));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 2);

    totalLen += itemLen;

    itemLen = BEncAsnIntContent (b, (&v->totalNumTypes));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 2);

    totalLen += itemLen;

    itemLen = BEncAsnIntContent (b, (&v->totalNumTypeDefs));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 2);

    totalLen += itemLen;

    itemLen = BEncAsnIntContent (b, (&v->totalNumModules));
    BEncDefLenTo127 (b, itemLen);
    itemLen++;
    itemLen += BEncTag1 (b, UNIV, PRIM, 2);

    totalLen += itemLen;

    return totalLen;

}  /* BEncTBLContent */

void
BDecTBLContent PARAMS ((b, tagId0, elmtLen0, v, bytesDecoded, env),
BUF_TYPE b _AND_
AsnTag tagId0 _AND_
AsnLen elmtLen0 _AND_
TBL *v _AND_
AsnLen *bytesDecoded _AND_
ENV_TYPE env)
{
    int seqDone = FALSE;
    AsnLen totalElmtsLen1 = 0;
    AsnLen elmtLen1;
    AsnTag tagId1;
    int mandatoryElmtCount1 = 0;


    tagId1 = BDecTag (b, &totalElmtsLen1, env);

    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, INTEGER_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecAsnIntContent (b, tagId1, elmtLen1, (&v->totalNumModules), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }
    else
        longjmp (env, -138);


    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, INTEGER_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecAsnIntContent (b, tagId1, elmtLen1, (&v->totalNumTypeDefs), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }
    else
        longjmp (env, -139);


    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, INTEGER_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecAsnIntContent (b, tagId1, elmtLen1, (&v->totalNumTypes), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }
    else
        longjmp (env, -140);


    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, INTEGER_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecAsnIntContent (b, tagId1, elmtLen1, (&v->totalNumTags), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }
    else
        longjmp (env, -141);


    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, INTEGER_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecAsnIntContent (b, tagId1, elmtLen1, (&v->totalNumStrings), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }
    else
        longjmp (env, -142);


    if (((tagId1 == MAKE_TAG_ID (UNIV, PRIM, INTEGER_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    BDecAsnIntContent (b, tagId1, elmtLen1, (&v->totalLenStrings), &totalElmtsLen1, env);
    tagId1 = BDecTag (b, &totalElmtsLen1, env);
    }
    else
        longjmp (env, -143);


    if (((tagId1 == MAKE_TAG_ID (UNIV, CONS, SEQ_TAG_CODE))))
    {
    elmtLen1 = BDecLen (b, &totalElmtsLen1, env);
    (v->modules) = AsnListNew (sizeof (char*));
    CheckAsn1Alloc ((v->modules), env);
    BDecTBLSeqOfContent (b, tagId1, elmtLen1, (v->modules), &totalElmtsLen1, env);
        seqDone = TRUE;
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc (b, &totalElmtsLen1, env);
        else if (totalElmtsLen1 != elmtLen0)
            longjmp (env, -144);
    }
    else
        longjmp (env, -145);


    if (!seqDone)
        longjmp (env, -146);

    (*bytesDecoded) += totalElmtsLen1;
}  /* BDecTBLContent */

void
PrintTBL PARAMS ((f, v, indent),
FILE* f _AND_
TBL *v _AND_
unsigned short indent)
{
    if (v == NULL)
        return;

    fprintf (f,"{ -- SEQUENCE --\n");

    Indent (f, indent + stdIndentG);
    fprintf (f,"totalNumModules ");
    PrintAsnInt (f, (&v->totalNumModules), indent + stdIndentG);
    fprintf (f, ",\n");
    Indent (f, indent + stdIndentG);
    fprintf (f,"totalNumTypeDefs ");
    PrintAsnInt (f, (&v->totalNumTypeDefs), indent + stdIndentG);
    fprintf (f, ",\n");
    Indent (f, indent + stdIndentG);
    fprintf (f,"totalNumTypes ");
    PrintAsnInt (f, (&v->totalNumTypes), indent + stdIndentG);
    fprintf (f, ",\n");
    Indent (f, indent + stdIndentG);
    fprintf (f,"totalNumTags ");
    PrintAsnInt (f, (&v->totalNumTags), indent + stdIndentG);
    fprintf (f, ",\n");
    Indent (f, indent + stdIndentG);
    fprintf (f,"totalNumStrings ");
    PrintAsnInt (f, (&v->totalNumStrings), indent + stdIndentG);
    fprintf (f, ",\n");
    Indent (f, indent + stdIndentG);
    fprintf (f,"totalLenStrings ");
    PrintAsnInt (f, (&v->totalLenStrings), indent + stdIndentG);
    fprintf (f, ",\n");
    Indent (f, indent + stdIndentG);
    fprintf (f,"modules ");
    PrintTBLSeqOf (f, (v->modules), indent + stdIndentG);
    fprintf (f,"\n");
    Indent (f, indent);
    fprintf (f,"}");
}  /* PrintTBL */

void
FreeTBL PARAMS ((v),
TBL *v)
{

    if (v == NULL)
        return;
    FreeAsnInt ((&v->totalNumModules));

    FreeAsnInt ((&v->totalNumTypeDefs));

    FreeAsnInt ((&v->totalNumTypes));

    FreeAsnInt ((&v->totalNumTags));

    FreeAsnInt ((&v->totalNumStrings));

    FreeAsnInt ((&v->totalLenStrings));

    FreeTBLSeqOf ((v->modules));
    Asn1Free ((v->modules));

}  /* FreeTBL */




#endif /* TTBL */
