#!/bin/sh          

# Run each test in a separate directory, to allow "make check -j" to work properly.
currtestdirname=tmpdir_test_many_eigv_h2o

if test "$top_builddir" = ""; then
    top_builddir=..
fi
if test "$top_srcdir" = ""; then
    top_srcdir=..
fi

. "$top_srcdir"/test/functions

# Run each test in a separate directory, to allow "make check -j" to work properly.
currdir=`pwd` ; cd $top_builddir ; top_builddir_pwd=`pwd` ; cd $currdir
currdir=`pwd` ; cd $top_srcdir ; top_srcdir_pwd=`pwd` ; cd $currdir
rm -rf $currtestdirname ; mkdir $currtestdirname ; cd $currtestdirname
ln -s "$top_builddir_pwd"/source/ergo ./ergo
script=./ergo

check_eigenvectors="$top_srcdir_pwd"/test/check_eigenvectors.sh


if test `./ergo -e precision` = 'single'; then
    echo SKIPPED
    cd .. ; rm -r $currtestdirname
    exit 0
fi

if test `./ergo -e is_cht_used` = 'chunks_and_tasks_is_used'; then
    echo SKIPPED
    cd .. ; rm -r $currtestdirname
    exit 0
fi


errorfilename=ergoscf.out.error.eigenvectors


TOL=1e-5 # maximum norm of the difference between 
         #eigenvectors computed using the diagonalization and purification


###################### TEST 1 ##############################

OCC=3
UNOCC=1

echo Testing h2o HF/STO-3G, should thrown exceptions
rm -f ergoscf.out
$script <<EOINPUT
molecule_inline
O     0.0       0.0       0.0
H    -1.809     0.0       0.0
H     0.453549  1.751221  0.0
EOF
basis = "STO-3G"
use_simple_starting_guess=1              
scf.purification_with_acceleration = 0  
scf.output_homo_and_lumo_eigenvectors = 1 
scf.number_of_occupied_eigenvectors = $OCC
scf.number_of_unoccupied_eigenvectors = $UNOCC
scf.eigenvectors_method  = "square"
 run "HF"
EOINPUT
if 
grep -c -q "use projection method when requesting" ergoscf.out
then
echo OK
else
echo ERROR, Exception is expected 
mv ergoscf.out $errorfilename
echo output file saved as $errorfilename
exit 1
fi


rm -f ergoscf.out
$script <<EOINPUT
molecule_inline
O     0.0       0.0       0.0
H    -1.809     0.0       0.0
H     0.453549  1.751221  0.0
EOF
basis = "STO-3G"
use_simple_starting_guess=1              
scf.purification_with_acceleration = 1 
scf.output_homo_and_lumo_eigenvectors = 1 
scf.number_of_occupied_eigenvectors = $OCC
scf.number_of_unoccupied_eigenvectors = $UNOCC
scf.eigenvectors_method  = "projection"
 run "HF"
EOINPUT
if 
grep -c -q "cannot compute more than 2 eigenpairs using SP2ACC" ergoscf.out
then
echo OK
else
echo ERROR, Exception is expected 
mv ergoscf.out $errorfilename
echo output file saved as $errorfilename
exit 1
fi



###################### TEST 2 ##############################

OCC=3
UNOCC=4

echo Testing h2o HF/6-31Gss - diagonalization
rm -f ergoscf.out
$script <<EOINPUT
molecule_inline
O     0.0       0.0       0.0
H    -1.809     0.0       0.0
H     0.453549  1.751221  0.0
EOF
basis = "6-31Gss"
use_simple_starting_guess=1              
scf.output_homo_and_lumo_eigenvectors = 1 
scf.number_of_occupied_eigenvectors = $OCC
scf.number_of_unoccupied_eigenvectors = $UNOCC
scf.use_diagonalization = 1
 run "HF"
EOINPUT
if 
check_final_energy -76.0226431 1e-7 ; 
then
echo Energy OK
else
echo Energy ERROR
mv ergoscf.out $errorfilename
echo output file saved as $errorfilename
exit 1
fi


mv homo_coefficient_vec.txt  homo_coefficient_vec_diag.txt
mv lumo_coefficient_vec.txt  lumo_coefficient_vec_diag.txt
mv occupied_spectrum.txt occupied_spectrum_diag.txt
mv unoccupied_spectrum.txt unoccupied_spectrum_diag.txt

i=1
while [ "$i" -lt $OCC ]
do
        mv occ_${i}_coefficient_vec.txt occ_${i}_coefficient_vec_diag.txt
        i=`expr $i + 1 `
done

i=1
while [ "$i" -lt $UNOCC ]
do
        mv unocc_${i}_coefficient_vec.txt unocc_${i}_coefficient_vec_diag.txt
        i=`expr $i + 1 `
done



echo;

echo Testing h2o HF/6-31Gss - non-accelerated purification
rm -f ergoscf.out
$script <<EOINPUT
molecule_inline
O     0.0       0.0       0.0
H    -1.809     0.0       0.0
H     0.453549  1.751221  0.0
EOF
basis = "6-31Gss"
use_simple_starting_guess=1              
scf.purification_with_acceleration = 0  
scf.output_homo_and_lumo_eigenvectors = 1 
scf.number_of_occupied_eigenvectors = $OCC
scf.number_of_unoccupied_eigenvectors = $UNOCC
scf.eigenvectors_method  = "projection"
 run "HF"
EOINPUT
if 
check_final_energy -76.0226431 1e-7 ; 
then
echo Energy OK
else
echo Energy ERROR
mv ergoscf.out $errorfilename
echo output file saved as $errorfilename
exit 1
fi



echo "Comparing eigenvectors"
if
$check_eigenvectors $OCC $UNOCC $TOL
then
echo Eigenvectors OK
else
echo Eigenvectors ERROR
mv ergoscf.out $errorfilename
echo output file saved as $errorfilename
exit 1
fi



echo;

echo Testing h2o HF/6-31Gss - non-accelerated purification, use initial guess 
rm -f ergoscf.out
$script <<EOINPUT
molecule_inline
O     0.0       0.0       0.0
H    -1.809     0.0       0.0
H     0.453549  1.751221  0.0
EOF
basis = "6-31Gss"
use_simple_starting_guess=1              
scf.purification_with_acceleration = 0  
scf.output_homo_and_lumo_eigenvectors = 1 
scf.number_of_occupied_eigenvectors = $OCC
scf.number_of_unoccupied_eigenvectors = $UNOCC
scf.eigenvectors_method  = "projection"
scf.use_prev_vector_as_initial_guess = 1
 run "HF"
EOINPUT
if 
check_final_energy -76.0226431 1e-7 ; 
then
echo Energy OK
else
echo Energy ERROR
mv ergoscf.out $errorfilename
echo output file saved as $errorfilename
exit 1
fi



echo "Comparing eigenvectors"
if
$check_eigenvectors $OCC $UNOCC $TOL
then
echo Eigenvectors OK
else
echo Eigenvectors ERROR
mv ergoscf.out $errorfilename
echo output file saved as $errorfilename
exit 1
fi




echo;

echo Testing h2o HF/6-31Gss - non-accelerated purification, check input params 
rm -f ergoscf.out
$script <<EOINPUT
molecule_inline
O     0.0       0.0       0.0
H    -1.809     0.0       0.0
H     0.453549  1.751221  0.0
EOF
basis = "6-31Gss"
use_simple_starting_guess=1              
scf.purification_with_acceleration = 0  
scf.output_homo_and_lumo_eigenvectors = 1 
scf.number_of_occupied_eigenvectors = $OCC
scf.number_of_unoccupied_eigenvectors = $UNOCC
scf.eigenvectors_method  = "projection"
scf.jump_over_X_iter_proj_method = 5
scf.go_back_X_iter_proj_method = 15
run "HF"
EOINPUT
if 
check_final_energy -76.0226431 1e-7 ; 
then
echo Energy OK
else
echo Energy ERROR
mv ergoscf.out $errorfilename
echo output file saved as $errorfilename
exit 1
fi



echo "Comparing eigenvectors"
if
$check_eigenvectors $OCC $UNOCC $TOL
then
echo Eigenvectors OK
else
echo Eigenvectors ERROR
mv ergoscf.out $errorfilename
echo output file saved as $errorfilename
exit 1
fi



###################### TEST 3 ##############################

OCC=3
UNOCC=4

echo Testing h2o UHF/6-31Gss - diagonalization
rm -f ergoscf.out
$script <<EOINPUT
molecule_inline
O     0.0       0.0       0.0
H    -1.809     0.0       0.0
H     0.453549  1.751221  0.0
EOF
basis = "6-31Gss"
use_simple_starting_guess=1              
scf.output_homo_and_lumo_eigenvectors = 1 
scf.number_of_occupied_eigenvectors = $OCC
scf.number_of_unoccupied_eigenvectors = $UNOCC
scf.use_diagonalization = 1
scf.force_unrestricted = 1 
scf.starting_guess_disturbance = 0.1 
 run "HF"
EOINPUT
if 
check_final_energy -76.0226431 1e-7 ; 
then
echo Energy OK
else
echo Energy ERROR
mv ergoscf.out $errorfilename
echo output file saved as $errorfilename
exit 1
fi

ID="_alpha"
mv homo_coefficient_vec${ID}.txt  homo_coefficient_vec_diag${ID}.txt
mv lumo_coefficient_vec${ID}.txt  lumo_coefficient_vec_diag${ID}.txt
mv occupied_spectrum${ID}.txt occupied_spectrum_diag${ID}.txt
mv unoccupied_spectrum${ID}.txt unoccupied_spectrum_diag${ID}.txt

i=1
while [ "$i" -lt $OCC ]
do
        mv occ_${i}_coefficient_vec${ID}.txt occ_${i}_coefficient_vec_diag${ID}.txt
        i=`expr $i + 1 `
done

i=1
while [ "$i" -lt $UNOCC ]
do
        mv unocc_${i}_coefficient_vec${ID}.txt unocc_${i}_coefficient_vec_diag${ID}.txt
        i=`expr $i + 1 `
done

ID="_beta"
mv homo_coefficient_vec${ID}.txt  homo_coefficient_vec_diag${ID}.txt
mv lumo_coefficient_vec${ID}.txt  lumo_coefficient_vec_diag${ID}.txt
mv occupied_spectrum${ID}.txt occupied_spectrum_diag${ID}.txt
mv unoccupied_spectrum${ID}.txt unoccupied_spectrum_diag${ID}.txt

i=1
while [ "$i" -lt $OCC ]
do
        mv occ_${i}_coefficient_vec${ID}.txt occ_${i}_coefficient_vec_diag${ID}.txt
        i=`expr $i + 1 `
done

i=1
while [ "$i" -lt $UNOCC ]
do
        mv unocc_${i}_coefficient_vec${ID}.txt unocc_${i}_coefficient_vec_diag${ID}.txt
        i=`expr $i + 1 `
done



echo;

echo Testing h2o UHF/6-31Gss - non-accelerated purification
rm -f ergoscf.out
$script <<EOINPUT
molecule_inline
O     0.0       0.0       0.0
H    -1.809     0.0       0.0
H     0.453549  1.751221  0.0
EOF
basis = "6-31Gss"
use_simple_starting_guess=1              
scf.purification_with_acceleration = 0  
scf.output_homo_and_lumo_eigenvectors = 1 
scf.number_of_occupied_eigenvectors = $OCC
scf.number_of_unoccupied_eigenvectors = $UNOCC
scf.eigenvectors_method  = "projection"
scf.force_unrestricted = 1 
scf.starting_guess_disturbance = 0.1 
 run "HF"
EOINPUT
if 
check_final_energy -76.0226431 1e-7 ; 
then
echo Energy OK
else
echo Energy ERROR
mv ergoscf.out $errorfilename
echo output file saved as $errorfilename
exit 1
fi



echo "Comparing eigenvectors"
ID="_alpha"
if
$check_eigenvectors $OCC $UNOCC $TOL $ID
then
echo BETA eigenvectors OK
else
echo BETA eigenvectors ERROR
mv ergoscf.out $errorfilename
echo output file saved as $errorfilename
exit 1
fi
ID="_beta"
if
$check_eigenvectors $OCC $UNOCC $TOL $ID
then
echo ALPHA eigenvectors OK
else
echo ALPHA eigenvectors ERROR
mv ergoscf.out $errorfilename
echo output file saved as $errorfilename
exit 1
fi



####################### TEST 4 ############################

# remove all previously created eigenvector files
rm -f *txt 

OCC=3
UNOCC=1

echo Testing h2o HF/STO-3G
rm -f ergoscf.out
$script <<EOINPUT
molecule_inline
O     0.0       0.0       0.0
H    -1.809     0.0       0.0
H     0.453549  1.751221  0.0
EOF
basis = "STO-3G"
use_simple_starting_guess=1              
scf.purification_with_acceleration = 0  
scf.output_homo_and_lumo_eigenvectors = 0 
scf.number_of_occupied_eigenvectors = $OCC
scf.number_of_unoccupied_eigenvectors = $UNOCC
scf.eigenvectors_method  = "projection"
mat.write_to_file = 1
scf.min_number_of_iterations = 3
run "HF"
EOINPUT
if ! test -f "*coefficient_vec.txt"; then
echo OK
else
echo ERROR, eigenvector files shold not be created
mv ergoscf.out $errorfilename
echo output file saved as $errorfilename
exit 1
fi











cd ..
rm -r $currtestdirname

echo
echo Eigenvectors test completed successfully!
echo
