MACRO(CHECK_INCLUDE_FILE_DEFINE HEADER VAR)
CHECK_INCLUDE_FILE(${HEADER} HAVE_INCLUDE_FILE)
IF(HAVE_INCLUDE_FILE)
  ADD_DEFINE("${VAR} 1")
  SET(${VAR} 1 CACHE INTERNAL "")
ENDIF(HAVE_INCLUDE_FILE)
ENDMACRO(CHECK_INCLUDE_FILE_DEFINE ARG)

MACRO(CHECK_FUNCTION_DEFINE HEADERS FUNC PARAM VAR)
CHECK_C_SOURCE_COMPILES(
"
${HEADERS}
int main(){
${FUNC} ${PARAM};
}
" ${VAR})
IF(${VAR})
  ADD_DEFINE("${VAR} 1")
ENDIF(${VAR})
ENDMACRO(CHECK_FUNCTION_DEFINE HEADERS FUNC PARAM VAR)


IF(WIN32)
  CHECK_INCLUDE_FILE_DEFINE(windows.h HAVE_WINDOWS_H)
  IF(HAVE_WINDOWS_H)
    CHECK_FUNCTION_DEFINE("#include <windows.h>" Sleep "(0)" HAVE_SLEEP)
  ENDIF(HAVE_WINDOWS_H)
ELSE(WIN32)

  CHECK_INCLUDE_FILE_DEFINE(time.h HAVE_TIME_H)
  IF(HAVE_TIME_H)
    CHECK_FUNCTION_DEFINE("#include <time.h>" nanosleep "((struct timespec*)0, (struct timespec*)0)" HAVE_NANOSLEEP)
  ELSE(HAVE_TIME_H)

    CHECK_INCLUDE_FILE_DEFINE(unistd.h HAVE_UNISTD_H)
    IF(HAVE_UNISTD_H)
      CHECK_FUNCTION_DEFINE("#include <unistd.h>" usleep "(0)" HAVE_USLEEP)
    ENDIF(HAVE_UNISTD_H)
  ENDIF(HAVE_TIME_H)
ENDIF(WIN32)