/*
 * Decompiled with CFR 0.152.
 */
package dumphd.core;

import dumphd.bdplus.ConversionTable;
import dumphd.core.KeyData;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

public class DiscSet {
    public static final int HD_STANDARD_V = 1;
    public static final int HD_STANDARD_A = 2;
    public static final int HD_ADVANCED_V = 3;
    public static final int HD_ADVANCED_A = 4;
    public static final int BD_MV = 5;
    public static final int BDR_MV = 6;
    public static final int BDR_AV = 7;
    public static final String[] DISCTYPE_NAMES = new String[]{"None", "HD-DVD Standard Content Video", "HD-DVD Standard Content Audio", "HD-DVD Advanced Content Video", "HD-DVD Advanced Content Audio", "Blu-Ray BDMV", "Blu-Ray Recordable BDMV", "Blu-Ray Recordable BDAV"};
    public final int contentType;
    public final File srcDir;
    public File dstDir = null;
    public File aacsDir = null;
    public KeyData keyData = null;
    public boolean bdplus = false;
    public ConversionTable convTable = null;
    public final TreeMap<Integer, ArrayList<String>> streamSets = new TreeMap();
    public final ArrayList<String> fileSet = new ArrayList(4096);
    public boolean selected = false;

    public DiscSet(int contentType, File srcDir) {
        this.contentType = contentType;
        this.srcDir = srcDir;
    }

    public boolean isBluRay() {
        return this.contentType >= 5;
    }

    public boolean isRecordable() {
        return this.contentType >= 6;
    }

    public String toString() {
        Iterator<String> it;
        StringBuffer sb = new StringBuffer(2048);
        sb.append("DiscSet:\n");
        sb.append("Type                 : ");
        sb.append(DISCTYPE_NAMES[this.contentType]);
        sb.append("\nSource directory     : ");
        sb.append(this.srcDir.toString());
        sb.append("\nDestination directory: ");
        if (this.dstDir != null) {
            sb.append(this.dstDir.toString());
        } else {
            sb.append("NONE");
        }
        sb.append("\nAACS directory       : ");
        if (this.aacsDir != null) {
            sb.append(this.aacsDir.toString());
        } else {
            sb.append("NONE");
        }
        sb.append("\nKey data             : ");
        if (this.keyData != null) {
            sb.append(this.keyData.toString());
        } else {
            sb.append("NONE");
        }
        if (this.isBluRay()) {
            sb.append("\nBD+ protection       : ");
            if (this.bdplus) {
                sb.append("YES");
                sb.append("\nConversion Table     : ");
                if (this.convTable != null) {
                    sb.append("PRESENT");
                } else {
                    sb.append("MISSING");
                }
            } else {
                sb.append("NO");
            }
        }
        sb.append("\nStreamsets           :");
        Iterator<ArrayList<String>> setIt = this.streamSets.values().iterator();
        while (setIt.hasNext()) {
            it = setIt.next().iterator();
            while (it.hasNext()) {
                sb.append("\n");
                sb.append(it.next());
            }
        }
        sb.append("\nOther files          :");
        it = this.fileSet.iterator();
        while (it.hasNext()) {
            sb.append("\n");
            sb.append(it.next());
        }
        return sb.toString();
    }
}

