/*
 *   This file is part of Dianara
 *   Copyright 2012-2022  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef FILTERCHECKER_H
#define FILTERCHECKER_H

#include <QObject>
#include <QVariantList>

#include <QDebug>

#include "asactivity.h"


class FilterChecker : public QObject
{
    Q_OBJECT

public:
    explicit FilterChecker(QObject *parent = 0);
    ~FilterChecker();

    void setFilters(QVariantList newFiltersList);
    int validateActivity(ASActivity *activity);

    enum FilterTypes
    {
        FilterOut,
        Highlight,
        NoFiltering = 999
    };

signals:

public slots:


private:
    QList<QStringList> m_filteredContent;
    QList<QStringList> m_filteredAuthor;
    QList<QStringList> m_filteredGenerator;
    QList<QStringList> m_filteredDescription;
};

#endif // FILTERCHECKER_H
