/*
 * CRRCsim - the Charles River Radio Control Club Flight Simulator Project
 *
 * Copyright (C) 2007 Tom Willis (original author)
 * Copyright (C) 2007 Jan Reucker
 * Copyright (C) 2008 Jens Wilhelm Wulf
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */
  

/*
 *  puaGLPreview.h
 *
 *  pui widget to display an OpenGL preview.
 *  Copyright (C) 2007 twillis
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2
 *  as published by the Free Software Foundation. or
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __PUAGLPREVIEW_H
#define __PUAGLPREVIEW_H

// Include config file generated by configure
#ifdef HAVE_CONFIG_H
#  include <crrc_config.h>
#endif

#include <plib/pu.h>
#include <plib/ssg.h>


/** \brief An OpenGL preview widget for PUI.
 * 
 *  This widget is derived from a puFrame and contains a rotating OpenGL-based view.  It uses ssg to render the
 *  view, so the geometry needs to be in a form that ssg is able to grok.  Calling the draw() method regularly
 *  will result in some animation of the view.
 *
 *  TODO right now, this is setup to preview an object (ie, put the geometry at the origin, back the camera away
 *  TODO to see the whole object, and then spin the object around).  longer term, subclases should specify the
 *  TODO camera behavior (this is kinda setup, but not yet implemented).  then, for previews of environments, we
 *  TODO could park the camera and rotate it around.
 */
class puaGLPreview : public puFrame
{
  public:
    puaGLPreview(int minx, int miny, int maxx, int maxy);
    virtual ~puaGLPreview ();

    // over-rides of puFrame methods by the same name.
    //
    void setSize(int w, int h);
    void draw(int dx, int dy);

    // load the geometry at the given path using ssg with textures located along the indicated texture path.
    // returns false on success, true on error.
    //
    bool loadGeometry(const char * modelPath, const char * texturePath);

    // setup the camera and geometry positions/rotations/etc for each "frame".
    //
    virtual void setupCamera(int frame);
    virtual void setupGeometry(int frame);

  private:
    void updateViewParameters(void);

  protected:
    ssgContext    *context;    // drawing context
    ssgRoot       *scene;    // scene graph
    ssgEntity     *geometry;   // geometry to preview

    ssgTransform  *transInitial;  // initial transform to center bounding sphere
    ssgTransform  *transGeometry;  // geometry transform

    int           frame;    // simple "frame" counter
};

#endif // #ifndef __PUAGLPREVIEW_H_
