; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "CRRCSim"
!define PRODUCT_VERSION "0.9.13"
!define PRODUCT_PUBLISHER "CRRCSim DevTeam"
!define PRODUCT_WEB_SITE "http://sourceforge.net/projects/crrcsim/"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\crrcsim.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

;--------------------------------
;Language Selection Dialog Settings

  ;Remember the installer language
  !define MUI_LANGDLL_REGISTRY_ROOT "HKCU"
  !define MUI_LANGDLL_REGISTRY_KEY "Software\CRRCSim"
  !define MUI_LANGDLL_REGISTRY_VALUENAME "Installer Language"

SetCompressor lzma

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!define MUI_LICENSEPAGE_RADIOBUTTONS
!insertmacro MUI_PAGE_LICENSE "COPYING"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_SHOWREADME "Documentation\dlportio.txt"
!define MUI_FINISHPAGE_SHOWREADME_TEXT "Show information on parallel interface"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_UNPAGE_FINISH

; Language files
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "German"
!insertmacro MUI_LANGUAGE "French"
!insertmacro MUI_LANGUAGE "Italian"

; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "CRRCsim-Win32-${PRODUCT_VERSION}.exe"
InstallDir "$PROGRAMFILES\CRRCSim"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Section "Hauptgruppe" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "crrcsim.exe"
  CreateDirectory "$SMPROGRAMS\CRRCSim"
  CreateShortCut "$SMPROGRAMS\CRRCSim\CRRCSim.lnk" "$INSTDIR\crrcsim.exe"
  CreateShortCut "$DESKTOP\CRRCSim.lnk" "$INSTDIR\crrcsim.exe"
  File "packages\icons\crrcsim.ico"
  File "*.dll"
  File "Readme"
  Rename "Readme" "Readme.txt"
  File "COPYING"
  Rename "COPYING" "COPYING.txt"
  SetOutPath "$INSTDIR\locale"
  File /r "locale\crrcsim.mo"
  SetOutPath "$INSTDIR\models"
  File /r "models\*.xml"
  SetOutPath "$INSTDIR\sounds"
  File /r "sounds\*.wav"
  SetOutPath "$INSTDIR\textures"
  File "textures\*.rgb"
  File "textures\*.bw"
  File "textures\*.jpg"
  File "textures\*.txf"
 SetOutPath "$INSTDIR\objects"
  File "objects\*.*"
  SetOutPath "$INSTDIR\scenery"
  File "scenery\davis.xml"
  File "scenery\davis-orig.xml"
  File "scenery\cape_cod.xml"
  File "scenery\cape_cod-orig.xml"
  File "scenery\simple.xml"
  File "scenery\simple_woods.xml"
  SetOutPath "$INSTDIR\Documentation"
  File "Documentation\*.txt"
  File "Documentation\*.jpg"
  File "Documentation\*.html"
  Rename "Documentation\README" "Documentation\README.txt"
  SetOutPath "$INSTDIR\Documentation\file_format"
  File "Documentation\file_format\*.html"
  SetOutPath "$INSTDIR\Documentation\input_method\SERIAL2"
  File "Documentation\input_method\SERIAL2\README"
  SetOutPath "$INSTDIR\Documentation\input_method\PARALLEL_1_TO_3"
  File "Documentation\input_method\PARALLEL_1_TO_3\*.*"
  SetOutPath "$INSTDIR\Documentation\input_method\CT6A"
  File "Documentation\input_method\CT6A\*.*"
  SetOutPath "$INSTDIR\Documentation\input_method\MNAV"
  File "Documentation\input_method\MNAV\*.*"
  SetOutPath "$INSTDIR\Documentation\models"
  File "Documentation\models\*.txt"
  File "Documentation\models\*.html"
  File "Documentation\models\*.png"
  SetOutPath "$INSTDIR\Documentation\power_propulsion"
  File "Documentation\power_propulsion\*.html"
  File "Documentation\power_propulsion\*.png"
  SetOutPath "$INSTDIR\Documentation\thermals"
  File "Documentation\models\*.txt"
  File "Documentation\models\*.html"
  File "Documentation\models\*.png"
  SetOutPath "$INSTDIR\Documentation\howto_create_models"
  File "Documentation\howto_create_models\*.html"
SectionEnd

Section -AdditionalIcons
  SetOutPath $INSTDIR
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\CRRCSim\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\CRRCSim\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\crrcsim.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\crrcsim.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd


Section Uninstall
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\License.txt"
  Delete "$INSTDIR\Readme.txt"
  Delete "$INSTDIR\Copying.txt"
  Delete "$INSTDIR\History.txt"
  Delete "$INSTDIR\stdout.txt"
  Delete "$INSTDIR\stderr.txt"
  Delete "$INSTDIR\*.dll"
  Delete "$INSTDIR\crrcsim.ico"
  Delete "$INSTDIR\crrcsim.exe"


  Delete "$SMPROGRAMS\CRRCSim\Uninstall.lnk"
  Delete "$SMPROGRAMS\CRRCSim\Website.lnk"
  Delete "$DESKTOP\CRRCSim.lnk"
  Delete "$SMPROGRAMS\CRRCSim\CRRCSim.lnk"

  RMDir "$SMPROGRAMS\CRRCSim"
  RMDir /r "$INSTDIR\Documentation"
  RMDir /r "$INSTDIR\locale"
  RMDir /r "$INSTDIR\sounds"
  RMDir /r "$INSTDIR\models"
  RMDir /r "$INSTDIR\textures"
  RMDir /r "$INSTDIR\scenery"
  RMDir /r "$INSTDIR\objects"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  DeleteRegKey /ifempty HKCU "Software\CRRCSim"
  SetAutoClose true
SectionEnd

;--------------------------------
;Installer Functions

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

;--------------------------------
;Uninstaller Functions

Function un.onInit
  !insertmacro MUI_UNGETLANGUAGE
FunctionEnd
