/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.GlobalParam;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQPreparedExpression;
import net.sf.saxon.javax.xml.xquery.XQResultSequence;
import net.sf.saxon.javax.xml.xquery.XQSequenceType;
import net.sf.saxon.javax.xml.xquery.XQWarning;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xqj.SaxonXQConnection;
import net.sf.saxon.xqj.SaxonXQDataFactory;
import net.sf.saxon.xqj.SaxonXQDynamicContext;
import net.sf.saxon.xqj.SaxonXQForwardSequence;
import net.sf.saxon.xqj.SaxonXQSequence;
import net.sf.saxon.xqj.SaxonXQSequenceType;

public class SaxonXQPreparedExpression
extends SaxonXQDynamicContext
implements XQPreparedExpression {
    private XQueryExpression expression;
    private DynamicQueryContext context;
    private SaxonXQConnection connection;
    private boolean closed;
    private boolean scrollable;

    protected SaxonXQPreparedExpression(SaxonXQConnection saxonXQConnection, XQueryExpression xQueryExpression, DynamicQueryContext dynamicQueryContext) throws XQException {
        this.connection = saxonXQConnection;
        this.expression = xQueryExpression;
        this.context = dynamicQueryContext;
        this.scrollable = saxonXQConnection.getScrollability() == 2;
    }

    protected DynamicQueryContext getDynamicContext() {
        return this.context;
    }

    protected void checkNotClosed() throws XQException {
        if (this.isClosed()) {
            throw new XQException("Expression has been closed");
        }
    }

    protected SaxonXQDataFactory getDataFactory() throws XQException {
        if (this.connection.isClosed()) {
            this.close();
        }
        this.checkNotClosed();
        return this.connection;
    }

    public void cancel() throws XQException {
        this.checkNotClosed();
    }

    public void clearWarnings() {
    }

    public void close() {
        this.closed = true;
    }

    public XQResultSequence executeQuery() throws XQException {
        this.checkNotClosed();
        try {
            SequenceIterator sequenceIterator = this.expression.iterator(this.context);
            if (this.scrollable) {
                Value value = Value.asValue(SequenceExtent.makeSequenceExtent(sequenceIterator));
                return new SaxonXQSequence(value, this.connection.getConfiguration(), this.connection);
            }
            return new SaxonXQForwardSequence(sequenceIterator, this.connection);
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public QName[] getAllExternalVariables() throws XQException {
        QName[] qNameArray;
        this.checkNotClosed();
        IntHashMap intHashMap = this.expression.getExecutable().getCompiledGlobalVariables();
        IntHashSet intHashSet = new IntHashSet(intHashMap.size());
        Iterator iterator = intHashMap.valueIterator();
        while (iterator.hasNext()) {
            qNameArray = (QName[])iterator.next();
            if (!(qNameArray instanceof GlobalParam)) continue;
            intHashSet.add(qNameArray.getVariableFingerprint());
        }
        qNameArray = new QName[intHashSet.size()];
        int n = 0;
        NamePool namePool = this.connection.getConfiguration().getNamePool();
        IntIterator intIterator = intHashSet.iterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.next();
            qNameArray[n++] = new QName(namePool.getURI(n2), namePool.getLocalName(n2), namePool.getPrefix(n2));
        }
        return qNameArray;
    }

    public QName[] getUnboundExternalVariables() throws XQException {
        this.checkNotClosed();
        Set set = this.getDynamicContext().getParameters().keySet();
        IntHashSet intHashSet = new IntHashSet(set.size());
        QName[] qNameArray = this.getAllExternalVariables();
        for (int i = 0; i < qNameArray.length; ++i) {
            String string = "{" + qNameArray[i].getNamespaceURI() + "}" + qNameArray[i].getLocalPart();
            if (set.contains(string)) continue;
            intHashSet.add(i);
        }
        QName[] qNameArray2 = new QName[intHashSet.size()];
        int n = 0;
        IntIterator intIterator = intHashSet.iterator();
        while (intIterator.hasNext()) {
            int n2 = intIterator.next();
            qNameArray2[n++] = qNameArray[n2];
        }
        return qNameArray2;
    }

    public int getQueryTimeout() throws XQException {
        this.checkNotClosed();
        return 0;
    }

    public XQSequenceType getStaticResultType() throws XQException {
        this.checkNotClosed();
        Expression expression = this.expression.getExpression();
        ItemType itemType = expression.getItemType(this.connection.getConfiguration().getTypeHierarchy());
        int n = expression.getCardinality();
        SequenceType sequenceType = SequenceType.makeSequenceType(itemType, n);
        return new SaxonXQSequenceType(sequenceType, this.connection.getConfiguration());
    }

    public XQSequenceType getStaticVariableType(QName qName) throws XQException {
        this.checkNotClosed();
        NamePool namePool = this.connection.getConfiguration().getNamePool();
        int n = namePool.allocate(qName.getPrefix(), qName.getNamespaceURI(), qName.getLocalPart()) & 0xFFFFF;
        IntHashMap intHashMap = this.expression.getExecutable().getCompiledGlobalVariables();
        GlobalVariable globalVariable = (GlobalVariable)intHashMap.get(n);
        if (globalVariable == null) {
            throw new XQException("Variable " + qName + " is not declared");
        }
        return new SaxonXQSequenceType(globalVariable.getRequiredType(), this.connection.getConfiguration());
    }

    public XQWarning getWarnings() throws XQException {
        this.checkNotClosed();
        return null;
    }

    public boolean isClosed() {
        if (this.connection.isClosed()) {
            this.close();
        }
        return this.closed;
    }

    public void setQueryTimeout(int n) {
    }
}

