/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.javax.xml.xquery.XQCommonHandler;
import net.sf.saxon.javax.xml.xquery.XQConnection;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQItemType;
import net.sf.saxon.javax.xml.xquery.XQResultItem;
import net.sf.saxon.javax.xml.xquery.XQWarning;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pull.PullFromIterator;
import net.sf.saxon.pull.PullToStax;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.xqj.SaxonXQConnection;
import net.sf.saxon.xqj.SaxonXQItemType;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class SaxonXQItem
implements XQResultItem {
    private Item item;
    private Configuration config;
    private SaxonXQConnection connection;

    public SaxonXQItem(Item item, Configuration configuration) {
        this.item = item;
        this.config = configuration;
    }

    Configuration getConfiguration() {
        return this.config;
    }

    Item getItem() {
        return this.item;
    }

    void setConnection(SaxonXQConnection saxonXQConnection) {
        this.connection = saxonXQConnection;
    }

    public void clearWarnings() {
    }

    public XQConnection getConnection() throws XQException {
        return this.connection;
    }

    public XQWarning getWarnings() throws XQException {
        return null;
    }

    public void close() throws XQException {
        this.item = null;
    }

    public boolean isClosed() {
        return this.item == null;
    }

    public String getAtomicValue() throws XQException {
        if (this.item instanceof AtomicValue) {
            return this.item.getStringValue();
        }
        throw new XQException("Failed to getAtomicValue: item is a node, or is closed");
    }

    public boolean getBoolean() throws XQException {
        AtomicValue atomicValue;
        if (this.item instanceof AtomicValue && (atomicValue = ((AtomicValue)this.item).getPrimitiveValue()) instanceof BooleanValue) {
            return ((BooleanValue)atomicValue).getBooleanValue();
        }
        throw new XQException("Failed in getBoolean: item is not a boolean, or is closed");
    }

    public byte getByte() throws XQException {
        if (this.item instanceof AtomicValue) {
            AtomicValue atomicValue = ((AtomicValue)this.item).getPrimitiveValue();
            return (byte)SaxonXQItem.longValue(atomicValue, -128L, 127L);
        }
        throw new XQException("Failed in getByte: item is not an atomic value, or is closed");
    }

    private static long longValue(AtomicValue atomicValue, long l, long l2) throws XQException {
        if (atomicValue instanceof NumericValue) {
            if (atomicValue instanceof DoubleValue || atomicValue instanceof FloatValue) {
                throw new XQException("Value is a double or float");
            }
            if (!((NumericValue)atomicValue).isWholeNumber()) {
                throw new XQException("Value is not a whole number");
            }
            try {
                long l3 = ((NumericValue)atomicValue).longValue();
                if (l3 >= l && l3 <= l2) {
                    return l3;
                }
                throw new XQException("Value is out of range for requested type");
            }
            catch (XPathException xPathException) {
                throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
            }
        }
        throw new XQException("Value is not numeric");
    }

    public double getDouble() throws XQException {
        AtomicValue atomicValue;
        if (this.item instanceof AtomicValue && (atomicValue = ((AtomicValue)this.item).getPrimitiveValue()) instanceof DoubleValue) {
            return ((DoubleValue)atomicValue).getDoubleValue();
        }
        throw new XQException("Failed in getDouble: item is not a double, or is closed");
    }

    public float getFloat() throws XQException {
        AtomicValue atomicValue;
        if (this.item instanceof AtomicValue && (atomicValue = ((AtomicValue)this.item).getPrimitiveValue()) instanceof FloatValue) {
            return ((FloatValue)atomicValue).getFloatValue();
        }
        throw new XQException("Failed in getFloat: item is not a float, or is closed");
    }

    public int getInt() throws XQException {
        if (this.item instanceof AtomicValue) {
            AtomicValue atomicValue = ((AtomicValue)this.item).getPrimitiveValue();
            return (byte)SaxonXQItem.longValue(atomicValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        throw new XQException("Failed in getInt: item is not an atomic value, or is closed");
    }

    public XMLStreamReader getItemAsStream() throws XQException {
        return new PullToStax(new PullFromIterator(SingletonIterator.makeIterator(this.item)));
    }

    public String getItemAsString() throws XQException {
        return this.getItemAsString(new Properties());
    }

    public String getItemAsString(Properties properties) throws XQException {
        StringWriter stringWriter = new StringWriter();
        this.writeItem(stringWriter, properties);
        return stringWriter.toString();
    }

    public XQItemType getItemType() throws XQException {
        if (this.item instanceof AtomicValue) {
            return new SaxonXQItemType(((AtomicValue)this.item).getItemType(this.getConfiguration().getTypeHierarchy()), this.getConfiguration());
        }
        return new SaxonXQItemType((NodeInfo)this.item);
    }

    public long getLong() throws XQException {
        if (this.item instanceof AtomicValue) {
            AtomicValue atomicValue = ((AtomicValue)this.item).getPrimitiveValue();
            return (byte)SaxonXQItem.longValue(atomicValue, Long.MIN_VALUE, Long.MAX_VALUE);
        }
        throw new XQException("Failed in getLong: item is not an atomic value, or is closed");
    }

    public Node getNode() throws XQException {
        if (!(this.item instanceof NodeInfo)) {
            throw new XQException("Failed in getNode: item is an atomic value, or is closed");
        }
        return NodeOverNodeInfo.wrap((NodeInfo)((NodeInfo)this.item));
    }

    public URI getNodeUri() throws XQException {
        if (this.item instanceof NodeInfo) {
            try {
                return new URI(((NodeInfo)this.item).getSystemId());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new XQException("System ID of node is not a valid URI");
            }
        }
        throw new XQException("Item is not a node");
    }

    public Object getObject() throws XQException {
        return ((SaxonXQConnection)this.getConnection()).getCommonHandler().toObject(this);
    }

    public Object getObject(XQCommonHandler xQCommonHandler) throws XQException {
        return xQCommonHandler.toObject(this);
    }

    public short getShort() throws XQException {
        if (this.item instanceof AtomicValue) {
            AtomicValue atomicValue = ((AtomicValue)this.item).getPrimitiveValue();
            return (byte)SaxonXQItem.longValue(atomicValue, -32768L, 32767L);
        }
        throw new XQException("Failed in getShort: item is not an atomic value, or is closed");
    }

    public boolean instanceOf(XQItemType xQItemType) throws XQException {
        return ((SaxonXQItemType)xQItemType).getSaxonItemType().matchesItem(this.item, false, this.config);
    }

    public void writeItem(OutputStream outputStream, Properties properties) throws XQException {
        NodeInfo nodeInfo;
        if (this.item instanceof AtomicValue) {
            nodeInfo = new Orphan(this.getConfiguration());
            ((Orphan)nodeInfo).setNodeKind((short)3);
            ((Orphan)nodeInfo).setStringValue(this.item.getStringValue());
        } else {
            nodeInfo = (NodeInfo)this.item;
        }
        try {
            QueryResult.serialize(nodeInfo, new StreamResult(outputStream), properties, this.getConfiguration());
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public void writeItem(Writer writer, Properties properties) throws XQException {
        NodeInfo nodeInfo;
        if (this.item instanceof AtomicValue) {
            nodeInfo = new Orphan(this.getConfiguration());
            ((Orphan)nodeInfo).setNodeKind((short)3);
            ((Orphan)nodeInfo).setStringValue(this.item.getStringValue());
        } else {
            nodeInfo = (NodeInfo)this.item;
        }
        try {
            QueryResult.serialize(nodeInfo, new StreamResult(writer), properties, this.getConfiguration());
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }

    public void writeItemToSAX(ContentHandler contentHandler) throws XQException {
        ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy();
        contentHandlerProxy.setUnderlyingContentHandler(contentHandler);
        ContentHandlerProxy contentHandlerProxy2 = contentHandlerProxy;
        NamespaceReducer namespaceReducer = new NamespaceReducer();
        PipelineConfiguration pipelineConfiguration = this.config.makePipelineConfiguration();
        namespaceReducer.setPipelineConfiguration(pipelineConfiguration);
        namespaceReducer.setUnderlyingReceiver(contentHandlerProxy2);
        ComplexContentOutputter complexContentOutputter = new ComplexContentOutputter();
        complexContentOutputter.setReceiver(namespaceReducer);
        complexContentOutputter.setPipelineConfiguration(pipelineConfiguration);
        TreeReceiver treeReceiver = new TreeReceiver(complexContentOutputter);
        treeReceiver.setPipelineConfiguration(pipelineConfiguration);
        try {
            treeReceiver.open();
            treeReceiver.append(this.item, 0, 2);
            treeReceiver.close();
        }
        catch (XPathException xPathException) {
            throw new XQException(xPathException.getMessage(), (Throwable)xPathException, null, null);
        }
    }
}

