/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.math.BigInteger;
import net.sf.saxon.om.FastStringBuffer;

public class FloatingPointConverter {
    public static FloatingPointConverter THE_INSTANCE = new FloatingPointConverter();
    private static final char[] NEGATIVE_INFINITY = new char[]{'-', 'I', 'N', 'F'};
    private static final char[] POSITIVE_INFINITY = new char[]{'I', 'N', 'F'};
    private static final char[] NaN = new char[]{'N', 'a', 'N'};
    private static final char[] charForDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final long doubleSignMask = Long.MIN_VALUE;
    private static final long doubleExpMask = 0x7FF0000000000000L;
    private static final int doubleExpShift = 52;
    private static final int doubleExpBias = 1023;
    private static final long doubleFractMask = 0xFFFFFFFFFFFFFL;
    private static final int floatSignMask = Integer.MIN_VALUE;
    private static final int floatExpMask = 2139095040;
    private static final int floatExpShift = 23;
    private static final int floatExpBias = 127;
    private static final int floatFractMask = 0x7FFFFF;
    private static final BigInteger TEN = BigInteger.valueOf(10L);
    private static final BigInteger NINE = BigInteger.valueOf(9L);

    private FloatingPointConverter() {
    }

    public static FastStringBuffer appendInt(FastStringBuffer fastStringBuffer, int n) {
        if (n < 0) {
            if (n == Integer.MIN_VALUE) {
                fastStringBuffer.append("-2147483648");
                return fastStringBuffer;
            }
            fastStringBuffer.append('-');
            n = -n;
        }
        if (n < 10) {
            fastStringBuffer.append(charForDigit[n]);
            return fastStringBuffer;
        }
        if (n < 100) {
            fastStringBuffer.append(charForDigit[n / 10]);
            fastStringBuffer.append(charForDigit[n % 10]);
            return fastStringBuffer;
        }
        if (n < 1000) {
            fastStringBuffer.append(charForDigit[n / 100]);
            int n2 = n % 100;
            fastStringBuffer.append(charForDigit[n2 / 10]);
            fastStringBuffer.append(charForDigit[n2 % 10]);
            return fastStringBuffer;
        }
        if (n < 10000) {
            fastStringBuffer.append(charForDigit[n / 1000]);
            int n3 = n % 1000;
            fastStringBuffer.append(charForDigit[n3 / 100]);
            fastStringBuffer.append(charForDigit[(n3 %= 100) / 10]);
            fastStringBuffer.append(charForDigit[n3 % 10]);
            return fastStringBuffer;
        }
        if (n < 100000) {
            fastStringBuffer.append(charForDigit[n / 10000]);
            int n4 = n % 10000;
            fastStringBuffer.append(charForDigit[n4 / 1000]);
            fastStringBuffer.append(charForDigit[(n4 %= 1000) / 100]);
            fastStringBuffer.append(charForDigit[(n4 %= 100) / 10]);
            fastStringBuffer.append(charForDigit[n4 % 10]);
            return fastStringBuffer;
        }
        if (n < 1000000) {
            fastStringBuffer.append(charForDigit[n / 100000]);
            int n5 = n % 100000;
            fastStringBuffer.append(charForDigit[n5 / 10000]);
            fastStringBuffer.append(charForDigit[(n5 %= 10000) / 1000]);
            fastStringBuffer.append(charForDigit[(n5 %= 1000) / 100]);
            fastStringBuffer.append(charForDigit[(n5 %= 100) / 10]);
            fastStringBuffer.append(charForDigit[n5 % 10]);
            return fastStringBuffer;
        }
        if (n < 10000000) {
            fastStringBuffer.append(charForDigit[n / 1000000]);
            int n6 = n % 1000000;
            fastStringBuffer.append(charForDigit[n6 / 100000]);
            fastStringBuffer.append(charForDigit[(n6 %= 100000) / 10000]);
            fastStringBuffer.append(charForDigit[(n6 %= 10000) / 1000]);
            fastStringBuffer.append(charForDigit[(n6 %= 1000) / 100]);
            fastStringBuffer.append(charForDigit[(n6 %= 100) / 10]);
            fastStringBuffer.append(charForDigit[n6 % 10]);
            return fastStringBuffer;
        }
        if (n < 100000000) {
            fastStringBuffer.append(charForDigit[n / 10000000]);
            int n7 = n % 10000000;
            fastStringBuffer.append(charForDigit[n7 / 1000000]);
            fastStringBuffer.append(charForDigit[(n7 %= 1000000) / 100000]);
            fastStringBuffer.append(charForDigit[(n7 %= 100000) / 10000]);
            fastStringBuffer.append(charForDigit[(n7 %= 10000) / 1000]);
            fastStringBuffer.append(charForDigit[(n7 %= 1000) / 100]);
            fastStringBuffer.append(charForDigit[(n7 %= 100) / 10]);
            fastStringBuffer.append(charForDigit[n7 % 10]);
            return fastStringBuffer;
        }
        if (n < 1000000000) {
            fastStringBuffer.append(charForDigit[n / 100000000]);
            int n8 = n % 100000000;
            fastStringBuffer.append(charForDigit[n8 / 10000000]);
            fastStringBuffer.append(charForDigit[(n8 %= 10000000) / 1000000]);
            fastStringBuffer.append(charForDigit[(n8 %= 1000000) / 100000]);
            fastStringBuffer.append(charForDigit[(n8 %= 100000) / 10000]);
            fastStringBuffer.append(charForDigit[(n8 %= 10000) / 1000]);
            fastStringBuffer.append(charForDigit[(n8 %= 1000) / 100]);
            fastStringBuffer.append(charForDigit[(n8 %= 100) / 10]);
            fastStringBuffer.append(charForDigit[n8 % 10]);
            return fastStringBuffer;
        }
        fastStringBuffer.append(charForDigit[n / 1000000000]);
        int n9 = n % 1000000000;
        fastStringBuffer.append(charForDigit[n9 / 100000000]);
        fastStringBuffer.append(charForDigit[(n9 %= 100000000) / 10000000]);
        fastStringBuffer.append(charForDigit[(n9 %= 10000000) / 1000000]);
        fastStringBuffer.append(charForDigit[(n9 %= 1000000) / 100000]);
        fastStringBuffer.append(charForDigit[(n9 %= 100000) / 10000]);
        fastStringBuffer.append(charForDigit[(n9 %= 10000) / 1000]);
        fastStringBuffer.append(charForDigit[(n9 %= 1000) / 100]);
        fastStringBuffer.append(charForDigit[(n9 %= 100) / 10]);
        fastStringBuffer.append(charForDigit[n9 % 10]);
        return fastStringBuffer;
    }

    private static void fppfpp(FastStringBuffer fastStringBuffer, int n, long l, int n2) {
        boolean bl;
        int n3;
        int n4;
        long l2;
        long l3 = l << Math.max(n - n2, 0);
        long l4 = 1L << Math.max(0, -(n - n2));
        long l5 = l2 = 1L << Math.max(n - n2, 0);
        boolean bl2 = true;
        if (l == 1L << n2 - 1) {
            l5 <<= 1;
            l3 <<= 1;
            l4 <<= 1;
        }
        int n5 = 0;
        while (l3 < (l4 + 9L) / 10L) {
            --n5;
            l3 *= 10L;
            l2 *= 10L;
            l5 *= 10L;
        }
        while (2L * l3 + l5 >= 2L * l4) {
            l4 *= 10L;
            ++n5;
        }
        for (n4 = n5; n4 < 0; ++n4) {
            if (bl2) {
                fastStringBuffer.append("0.");
            }
            bl2 = false;
            fastStringBuffer.append('0');
        }
        while (true) {
            --n5;
            n3 = (int)(l3 * 10L / l4);
            l3 = l3 * 10L % l4;
            n4 = 2L * l3 < (l2 *= 10L) ? 1 : 0;
            boolean bl3 = bl = 2L * l3 > 2L * l4 - (l5 *= 10L);
            if (n4 != 0 || bl) break;
            if (n5 == -1) {
                if (bl2) {
                    fastStringBuffer.append('0');
                }
                fastStringBuffer.append('.');
            }
            fastStringBuffer.append(charForDigit[n3]);
            bl2 = false;
        }
        if (bl && (n4 == 0 || 2L * l3 > l4)) {
            ++n3;
        }
        if (n5 == -1) {
            if (bl2) {
                fastStringBuffer.append('0');
            }
            fastStringBuffer.append('.');
        }
        fastStringBuffer.append(charForDigit[n3]);
        for (int i = 0; i < n5; ++i) {
            fastStringBuffer.append('0');
        }
    }

    private static void fppfppBig(FastStringBuffer fastStringBuffer, int n, long l, int n2) {
        boolean bl;
        int n3;
        int n4;
        BigInteger bigInteger;
        BigInteger bigInteger2 = BigInteger.valueOf(l).shiftLeft(Math.max(n - n2, 0));
        BigInteger bigInteger3 = BigInteger.ONE.shiftLeft(Math.max(0, -(n - n2)));
        BigInteger bigInteger4 = bigInteger = BigInteger.ONE.shiftLeft(Math.max(n - n2, 0));
        boolean bl2 = true;
        if (l == 1L << n2 - 1) {
            bigInteger4 = bigInteger4.shiftLeft(1);
            bigInteger2 = bigInteger2.shiftLeft(1);
            bigInteger3 = bigInteger3.shiftLeft(1);
        }
        int n5 = 0;
        while (bigInteger2.compareTo(bigInteger3.add(NINE).divide(TEN)) < 0) {
            --n5;
            bigInteger2 = bigInteger2.multiply(TEN);
            bigInteger = bigInteger.multiply(TEN);
            bigInteger4 = bigInteger4.multiply(TEN);
        }
        while (bigInteger2.shiftLeft(1).add(bigInteger4).compareTo(bigInteger3.shiftLeft(1)) >= 0) {
            bigInteger3 = bigInteger3.multiply(TEN);
            ++n5;
        }
        for (n4 = n5; n4 < 0; ++n4) {
            if (bl2) {
                fastStringBuffer.append("0.");
            }
            bl2 = false;
            fastStringBuffer.append('0');
        }
        while (true) {
            --n5;
            BigInteger bigInteger5 = bigInteger2.multiply(TEN);
            n3 = bigInteger5.divide(bigInteger3).intValue();
            bigInteger2 = bigInteger5.mod(bigInteger3);
            bigInteger = bigInteger.multiply(TEN);
            bigInteger4 = bigInteger4.multiply(TEN);
            BigInteger bigInteger6 = bigInteger2.shiftLeft(1);
            n4 = bigInteger6.compareTo(bigInteger) < 0 ? 1 : 0;
            boolean bl3 = bl = bigInteger6.compareTo(bigInteger3.shiftLeft(1).subtract(bigInteger4)) > 0;
            if (n4 != 0 || bl) break;
            if (n5 == -1) {
                if (bl2) {
                    fastStringBuffer.append('0');
                }
                fastStringBuffer.append('.');
            }
            fastStringBuffer.append(charForDigit[n3]);
            bl2 = false;
        }
        if (bl && (n4 == 0 || bigInteger2.shiftLeft(1).compareTo(bigInteger3) > 0)) {
            ++n3;
        }
        if (n5 == -1) {
            if (bl2) {
                fastStringBuffer.append('0');
            }
            fastStringBuffer.append('.');
        }
        fastStringBuffer.append(charForDigit[n3]);
        for (int i = 0; i < n5; ++i) {
            fastStringBuffer.append('0');
        }
    }

    private static void fppfppExponential(FastStringBuffer fastStringBuffer, int n, long l, int n2) {
        boolean bl;
        boolean bl2;
        int n3;
        BigInteger bigInteger;
        BigInteger bigInteger2 = BigInteger.valueOf(l).shiftLeft(Math.max(n - n2, 0));
        BigInteger bigInteger3 = BigInteger.ONE.shiftLeft(Math.max(0, -(n - n2)));
        BigInteger bigInteger4 = bigInteger = BigInteger.ONE.shiftLeft(Math.max(n - n2, 0));
        boolean bl3 = true;
        boolean bl4 = false;
        if (l == 1L << n2 - 1) {
            bigInteger4 = bigInteger4.shiftLeft(1);
            bigInteger2 = bigInteger2.shiftLeft(1);
            bigInteger3 = bigInteger3.shiftLeft(1);
        }
        int n4 = 0;
        while (bigInteger2.compareTo(bigInteger3.add(NINE).divide(TEN)) < 0) {
            --n4;
            bigInteger2 = bigInteger2.multiply(TEN);
            bigInteger = bigInteger.multiply(TEN);
            bigInteger4 = bigInteger4.multiply(TEN);
        }
        while (bigInteger2.shiftLeft(1).add(bigInteger4).compareTo(bigInteger3.shiftLeft(1)) >= 0) {
            bigInteger3 = bigInteger3.multiply(TEN);
            ++n4;
        }
        int n5 = n4 - 1;
        while (true) {
            --n4;
            BigInteger bigInteger5 = bigInteger2.multiply(TEN);
            n3 = bigInteger5.divide(bigInteger3).intValue();
            bigInteger2 = bigInteger5.mod(bigInteger3);
            bigInteger = bigInteger.multiply(TEN);
            bigInteger4 = bigInteger4.multiply(TEN);
            BigInteger bigInteger6 = bigInteger2.shiftLeft(1);
            bl2 = bigInteger6.compareTo(bigInteger) < 0;
            boolean bl5 = bl = bigInteger6.compareTo(bigInteger3.shiftLeft(1).subtract(bigInteger4)) > 0;
            if (bl2 || bl) break;
            fastStringBuffer.append(charForDigit[n3]);
            if (bl3) {
                fastStringBuffer.append('.');
                bl4 = true;
            }
            bl3 = false;
        }
        if (bl && (!bl2 || bigInteger2.shiftLeft(1).compareTo(bigInteger3) > 0)) {
            ++n3;
        }
        fastStringBuffer.append(charForDigit[n3]);
        if (!bl4) {
            fastStringBuffer.append(".0");
        }
        fastStringBuffer.append('E');
        FloatingPointConverter.appendInt(fastStringBuffer, n5);
    }

    public static FastStringBuffer appendDouble(FastStringBuffer fastStringBuffer, double d) {
        double d2 = d;
        if (d2 == Double.NEGATIVE_INFINITY) {
            fastStringBuffer.append(NEGATIVE_INFINITY);
        } else if (d2 == Double.POSITIVE_INFINITY) {
            fastStringBuffer.append(POSITIVE_INFINITY);
        } else if (d2 != d2) {
            fastStringBuffer.append(NaN);
        } else if (d2 == 0.0) {
            if ((Double.doubleToLongBits(d2) & Long.MIN_VALUE) != 0L) {
                fastStringBuffer.append('-');
            }
            fastStringBuffer.append('0');
        } else if (d2 == Double.MAX_VALUE) {
            fastStringBuffer.append("1.7976931348623157E308");
        } else if (d2 == -1.7976931348623157E308) {
            fastStringBuffer.append("-1.7976931348623157E308");
        } else if (d2 == Double.MIN_VALUE) {
            fastStringBuffer.append("4.9E-324");
        } else if (d2 == -4.9E-324) {
            fastStringBuffer.append("-4.9E-324");
        } else {
            if (d2 < 0.0) {
                fastStringBuffer.append('-');
                d2 = -d2;
            }
            boolean bl = d2 >= 1000000.0 || d2 < 1.0E-6;
            long l = Double.doubleToLongBits(d2);
            long l2 = 0x10000000000000L | l & 0xFFFFFFFFFFFFFL;
            long l3 = (l & 0x7FF0000000000000L) >> 52;
            int n = (int)l3 - 1023;
            if (l3 == 0L) {
                fastStringBuffer.append(Double.toString(d));
                return fastStringBuffer;
            }
            if (bl) {
                FloatingPointConverter.fppfppExponential(fastStringBuffer, n, l2, 52);
            } else if (d2 <= 0.01) {
                FloatingPointConverter.fppfppBig(fastStringBuffer, n, l2, 52);
            } else {
                FloatingPointConverter.fppfpp(fastStringBuffer, n, l2, 52);
            }
        }
        return fastStringBuffer;
    }

    public static FastStringBuffer appendFloat(FastStringBuffer fastStringBuffer, float f) {
        float f2 = f;
        if (f2 == Float.NEGATIVE_INFINITY) {
            fastStringBuffer.append(NEGATIVE_INFINITY);
        } else if (f2 == Float.POSITIVE_INFINITY) {
            fastStringBuffer.append(POSITIVE_INFINITY);
        } else if (f2 != f2) {
            fastStringBuffer.append(NaN);
        } else if ((double)f2 == 0.0) {
            if ((Float.floatToIntBits(f2) & Integer.MIN_VALUE) != 0) {
                fastStringBuffer.append('-');
            }
            fastStringBuffer.append('0');
        } else if (f2 == Float.MAX_VALUE) {
            fastStringBuffer.append("3.4028235E38");
        } else if (f2 == -3.4028235E38f) {
            fastStringBuffer.append("-3.4028235E38");
        } else if (f2 == Float.MIN_VALUE) {
            fastStringBuffer.append("1.4E-45");
        } else if (f2 == -1.4E-45f) {
            fastStringBuffer.append("-1.4E-45");
        } else {
            if (f2 < 0.0f) {
                fastStringBuffer.append('-');
                f2 = -f2;
            }
            boolean bl = f2 >= 1000000.0f || f2 < 1.0E-6f;
            int n = Float.floatToIntBits(f2);
            int n2 = 0x800000 | n & 0x7FFFFF;
            int n3 = (n & 0x7F800000) >> 23;
            int n4 = n3 - 127;
            int n5 = 23;
            if (n3 == 0) {
                fastStringBuffer.append(Float.toString(f));
                return fastStringBuffer;
            }
            if (bl) {
                FloatingPointConverter.fppfppExponential(fastStringBuffer, n4, n2, n5);
            } else {
                FloatingPointConverter.fppfpp(fastStringBuffer, n4, n2, n5);
            }
        }
        return fastStringBuffer;
    }
}

