/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom4j;

import java.io.Serializable;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom4j.DocumentWrapper;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;

public class DOM4JObjectModel
implements ExternalObjectModel,
Serializable {
    public boolean isRecognizedNode(Object object) {
        return object instanceof Document || object instanceof Element || object instanceof Attribute || object instanceof Text || object instanceof CDATA || object instanceof Comment || object instanceof ProcessingInstruction || object instanceof Namespace;
    }

    public boolean isRecognizedNodeClass(Class clazz) {
        return Document.class.isAssignableFrom(clazz) || Element.class.isAssignableFrom(clazz) || Attribute.class.isAssignableFrom(clazz) || Text.class.isAssignableFrom(clazz) || CDATA.class.isAssignableFrom(clazz) || Comment.class.isAssignableFrom(clazz) || ProcessingInstruction.class.isAssignableFrom(clazz) || Namespace.class.isAssignableFrom(clazz);
    }

    public boolean isRecognizedNodeListClass(Class clazz) {
        return false;
    }

    public Receiver getDocumentBuilder(Result result) {
        return null;
    }

    public boolean sendSource(Source source, Receiver receiver, PipelineConfiguration pipelineConfiguration) throws XPathException {
        return false;
    }

    public NodeInfo unravel(Source source, Configuration configuration) {
        return null;
    }

    public Value convertObjectToXPathValue(Object object, Configuration configuration) throws XPathException {
        return null;
    }

    public Object convertXPathValueToObject(Value value, Class clazz, XPathContext xPathContext) {
        return null;
    }

    public DocumentInfo wrapDocument(Object object, String string, Configuration configuration) {
        Document document = this.getDocumentRoot(object);
        return new DocumentWrapper(document, string, configuration);
    }

    public NodeInfo wrapNode(DocumentInfo documentInfo, Object object) {
        return ((DocumentWrapper)documentInfo).wrap(object);
    }

    private Document getDocumentRoot(Object object) {
        while (!(object instanceof Document)) {
            if (object instanceof Element) {
                if (((Element)object).isRootElement()) {
                    return ((Element)object).getDocument();
                }
                object = ((Element)object).getParent();
                continue;
            }
            if (object instanceof Text) {
                object = ((Text)object).getParent();
                continue;
            }
            if (object instanceof Comment) {
                object = ((Comment)object).getParent();
                continue;
            }
            if (object instanceof ProcessingInstruction) {
                object = ((ProcessingInstruction)object).getParent();
                continue;
            }
            if (object instanceof Attribute) {
                object = ((Attribute)object).getParent();
                continue;
            }
            if (object instanceof Document) {
                return (Document)object;
            }
            if (object instanceof Namespace) {
                throw new UnsupportedOperationException("Cannot find parent of DOM4J namespace node");
            }
            throw new IllegalStateException("Unknown DOM4J node type " + object.getClass());
        }
        return (Document)object;
    }

    public Object convertToNodeList(SequenceExtent sequenceExtent) {
        return null;
    }
}

