#!/usr/bin/python
'''
Parses API for C++ from Scriptable API documentation.
'''

import re

readme_path = 'docs/scripting-api.rst'
output_path = 'src/gui/commandcompleterdocumentation.h'

header = '''// Generated by "utils/script_docs_to_cpp.py" from "%s".
template <typename AddDocumentationCallback>
void addDocumentation(AddDocumentationCallback addDocumentation)
{
'''

footer = '}'

# Regex for function/variable/type name in documentation
re_title = re.compile(r'''
  (?:
    ^\.\.\s*js:function::\s*
    (?P<function_api>
      # function return value
      .*?
      # function name
      (?P<function_name>\w+)
      # arguments
      \(.*
    )

    |

    ^\.\.\s*js:data::\s*
    # variable name
    (?P<variable_name>\w+)
    \s*
    # followed by opening parenthesis
    (?P<variable_api>\(.*)

    |

    ^\.\.\s*js:class::\s*
    # type name
    (?P<type_name>\w+)$
  )
  ''', re.VERBOSE)

def main():
    with open(output_path, mode='w', encoding='utf-8') as output_file:
        output_file.write((header % readme_path) + '\n')

        with open(readme_path, mode='r', encoding='utf-8') as readme_file:
            match = None
            for line in readme_file:
                line = line.strip().replace('``', '`')
                if line:
                    if match:
                        name = match.group('function_name') or match.group('variable_name') or match.group('type_name')
                        api = match.group('function_api') or match.group('variable_api') or name
                        description = line.strip()
                        output = '    addDocumentation("{}", "{}", "{}");\n'\
                            .format(name, api, description)
                        output_file.write(output)
                        match = None
                    else:
                        match = re.match(re_title, line)

        output_file.write(footer + '\n')

if __name__ == "__main__":
    main()
