#! /usr/bin/env python3
# -*- coding: utf-8 -*-

#	Copyright 2012-2013, Marten de Vries
#
#	This file is part of Code of Conduct Signing Assistant.
#
#	Code of Conduct Signing Assistant is free software: you can
#	redistribute it and/or modify it under the terms of the GNU General
#	Public License as published by the Free Software Foundation, either
#	version 3 of the License, or (at your option) any later version.
#
#	Code of Conduct Signing Assistant is distributed in the hope that it
#	will be useful, but WITHOUT ANY WARRANTY; without even the implied
#	warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#	See the GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with Code of Conduct Signing Assistant. If not, see
#	<http://www.gnu.org/licenses/>.

from distutils.core import setup
import os
import subprocess
import sys
import glob

data_files= [
	("/usr/share/applications", ["linux/codeOfConductSigningAssistant.desktop"]),
	("/usr/share/icons/hicolor/scalable/apps", ["codeOfConductSigningAssistant/codeOfConductSigningAssistant.svg"]),
	("/usr/share/pixmaps", ["linux/codeOfConductSigningAssistant.xpm"]),
	("/usr/share/menu", ["linux/code-of-conduct-signing-assistant"]),
]

for root, dirs, files in os.walk("translations"):
	relative = root[len("translations/"):]
	data_files.append((
		os.path.join("/usr/share/locale", relative),
		[os.path.join(root, file) for file in files],
	))

def main():
	setup(
		name="Code of Conduct Signing Assistant",
		version="0.1",
		description="Sign the Ubuntu Code of Conduct easily.",
		author="Marten de Vries",
		author_email="marten-de-vries@ubuntu.com",
		packages = ["codeOfConductSigningAssistant"],
		license="GPLv3+",
		package_data={"codeOfConductSigningAssistant": ["codeOfConductSigningAssistant.svg"]},
		data_files=data_files,
		scripts=['bin/code-of-conduct-signing-assistant'],
		long_description="""Code of Conduct Signing Assistant is an open source program that helps you sign the Ubuntu Code of Conduct easily!

No more worries about PGP keys or decrypting mail: just follow the steps
the Code of Conduct Signing Assistant guides you through and in the end
you have signed the Ubuntu Code of Conduct!"""
	)

if __name__ == "__main__":
	main()
