#!/bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULE=src/lib/perl5/COD/CIF/Data/Check.pm
#END DEPEND--------------------------------------------------------------------

IMPORT_MODULE=$(\
    echo ${INPUT_MODULE} | \
    perl -pe "s|^src/lib/perl5/||; s/[.]pm$//; s|/|::|g;" \
)

perl -M"${IMPORT_MODULE}" \
<<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2024-05-26 16:42:43 +0300 (Sun, 26 May 2024) $ 
#$Revision: 10064 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.11.0/tests/shtests/parse_datetime_002.sh $
#------------------------------------------------------------------------------
#*
#* Unit test for the COD::CIF::Data::Check::parse_datetime() subroutine.
#* Tests how various timestamp strings that do not correspond to the
#* required format are handled.
#**

use strict;
use warnings;

use COD::CIF::Data::Check;

my @datetime_values = (
    # Overall incorrect date format
    'This is a text string',
    # Month lies outside the [1, 12] range
    '2000-23-01',
    # Day lies outside the allowed range for the given month
    '2000-02-30',
    # Space in front of the date-only timestamp
    ' 2000-02-30',
    # Space at the end of the date-only timestamp
    '2000-02-30 ',
    # Space in front of the datetime timestamp
    ' 1985-04-12T23:20:50.52Z',
    # Space at the end of the datetime timestamp
    '1985-04-12T23:20:50.52Z ',
    # Incorrect datetime
    '1985-04-12T23:20:50.52J',
    # Space instead of the 'T' separator
    '1985-04-12 23:20:50.52Z',
);

for (@datetime_values) {
    eval {
        my $dt = COD::CIF::Data::Check::parse_datetime($_);
        print $dt->datetime . "\n";
    };
    if ($@) {
        print "Value '$_' could not be successfully parsed as a timestamp value.\n";
    }
}

END_SCRIPT
