/*
 * Simple resource management base classes
 * Header file
 *
 * $Id$
 */

#ifndef RESOURCE_H
#define RESOURCE_H

#include <exception.h>


/* EXCEPTIONS */

class resource_exception : public exception {
public:
  resource_exception(char *msg) : exception(msg) {}
  resource_exception(char *fmt, int i) : exception(fmt, i) {}
};


/* CLASSES */

// TODO:
// - resource dependencies
class resource {
  int ref;				// reference counter
protected:
  virtual void load()=0;
  virtual void unload()=0;
public:
  resource();
  virtual ~resource();

  // Dynamic loading stuff
  int is_loaded() { return ref>0; }
  void alloc();
  void dealloc();
};

template <class res_t>
class eresource : public resource {
  res_t res;
protected:
  virtual void load() {}
  virtual void unload() {}
public:
  eresource(res_t r) : res(r) {}
  ~eresource() {}

  operator res_t () { return res; }
};

class resourceman {
  int num_static_ids;
  resource **staticres;			// static resources [O[O]]
public:
  resourceman(int num_static_ids);
  ~resourceman();

  void init_resource(int id, resource *r);	// [O]
  resource *allocate(int id);		// [R]()
  void deallocate(int id);
};


#endif // RESOURCE_H
