#
# Copyright 2004 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# 
# Test "require" tag
#
# $Id: require.py 8878 2007-03-14 05:38:02Z andrewm $

import unittest
import albatross
import albatross_test

class RequireCase(albatross_test.AlbatrossTestCase):
    template_dir = "require"

    def check_require(self):
        self.test_str_html("<al-require>", "")
        self.test_str_raise("<al-require nosuchattribute=\"\">")

    def check_require_version(self):
        fmt = "<al-require version=\"%d\">"
        self.test_str_html(fmt % albatross.template_version, "")
        self.test_str_html(fmt % (albatross.template_version - 1), "")
        self.test_str_raise(fmt % (albatross.template_version + 1))

    def check_require_feature(self):
        self.test_str_html("<al-require feature=\"\">", "")
        self.test_str_raise("<al-require feature=\"nosuchfeature\">")

class RequireSuite(unittest.TestSuite):
    test_list = (
        "check_require",
        "check_require_version",
        "check_require_feature",
    )
    def __init__(self):
        unittest.TestSuite.__init__(self, map(RequireCase, self.test_list))

def suite():
    return RequireSuite()

if __name__ == '__main__':
    unittest.main(defaultTest='suite')
