#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <QtCore/QObject>
#include <QtCore/QString>
#include "voicedata.h"

VoiceData::VoiceData(QObject *parent) : QObject(parent) {

  int i1, i2;

  rate = 44100;
  rnd_scale = 1.0 / (double)RAND_MAX;
  harmonicSplit[0] = 0;
  harmonicSplit[1] = 64; 
  harmonicSplit[2] = 96;
  harmonicSplit[3] = 128; 
  harmonicSplit[4] = 136;
  harmonicSplit[5] = 200;
  harmonicSplit[6] = 232;
  harmonicSplit[7] = 264;
  harmonicSplit[8] = 272;
  numHarmonics = harmonicSplit[8];
  detune = 0;
  offsetDetune = 0;
  voiceRandom = 0;
  currentVoiceDetune = 0;
  panCenter = 0;
  panWidth = 0;
  panMode = 0;
  delta[0] = 1.5;
  delta[1] = 0.7;
  delta[2] = 1.0;
  delta[3] = 0.0;
  delta[4] = 0.0;
  delta[5] = 1.0;
  morphing = 0.5;
  linearLevel = 0.5;
  transitionWidth = 0.5;
  compression = 0.5;
  antialiasing = 4.0;
  masterVolume = 4e4;
  pitchBend = 0;
  noiseBandwidth = 0.25;
  noiseFreqDiffusion = 0;
  noiseSubHarmonicMode = false;
  osc3Mode = 0;
  osc3FreqDiffusion = 0;
  volumeTracking = 0.5;
  velocityDepth = 0.5;
  envelopes = (envelopeType *)malloc(numHarmonics * sizeof(envelopeType));
  for (i1 = 0; i1 < numHarmonics; i1++) {
    envelopes[i1].val = 0;
    envelopes[i1].state = 0;
    envelopes[i1].lfo = 0;
    envelopes[i1].lfo_state = 0;
    envelopes[i1].a = 0;
    envelopes[i1].y = 0;
    envelopes[i1].dy = 0;
    envelopes[i1].ddy = 0;
    envelopes[i1].freqSh = 0;
  }  
  scaleLin[0] = 1.0;
  scaleExp[0] = 2.0;
  minScale[0] = 0.01;
  maxScale[0] = 10.0;
  scaleLin[1] = 0.000001;
  scaleExp[1] = 3.0;
  minScale[1] = 0.01;
  maxScale[1] = 10.0;
  scaleLin[2] = 0.000001;
  scaleExp[2] = 3.0;
  minScale[2] = 0.01;
  maxScale[2] = 10.0;
  scaleLin[3] = 0.000001;
  scaleExp[3] = 3.0;
  minScale[3] = 0.01;
  maxScale[3] = 10.0;
  scaleLin[4] = 0.00001;
  scaleExp[4] = 3.0;
  minScale[4] = 0.01;
  maxScale[4] = 10.0;
  scaleLin[5] = 0.001;
  scaleExp[5] = 0.0;
  minScale[5] = 0.01;
  maxScale[5] = 10.0;
  scaleLin[6] = 0.000001;
  scaleExp[6] = 3.0;
  minScale[6] = 0.01;
  maxScale[6] = 10.0;
  scaleLin[7] = 0.0001;
  scaleExp[7] = 2.0;
  minScale[7] = 0.01;
  maxScale[7] = 10.0;
  scaleLin[8] = 0.000001;
  scaleExp[8] = 3.0;
  minScale[8] = 0.01;
  maxScale[8] = 10.0;
  scaleLin[9] = 0.000001;
  scaleExp[9] = 3.0;
  minScale[9] = 0.01;
  maxScale[9] = 10.0;
  for (i1 = 0; i1 < MAX_SCALES; i1++) {
    scale[i1] = 1.0;
  }
  for (i1 = 0; i1 < MAX_PARAMS; i1++) {
    harmonics[i1] = (double*)malloc(numHarmonics * sizeof(double));
    scaledHarmonics[i1] = (double*)malloc(numHarmonics * sizeof(double));
  }
  for (i1 = 0; i1 < MAX_PARAMS; i1++) {  
    for (i2 = 0; i2 < MAX_HARMONIC_GROUPS; i2++) {
      hmax[i2][i1] = 0;
    }  
    for (i2 = 0; i2 < numHarmonics; i2++) {
      setHarmonic(i1, i2, 0);
    }
  }   
  for (i1 = 0; i1 < 2; i1++) {  
    for (i2 = 0; i2 < FILTER_LEN; i2++) {
      setFilter(i1, i2, 0);
    }
    for (i2 = 0; i2 < MAX_SOURCES; i2++) {
      filterMixLfo[i2] = 0;
      filterMixRetrigger[i2] = 0;
      filterMixHold[i2] = 0;
    }
  }   
  synthesisFlag = true;
  lfo = 0;
  lfoState = 1;
  lfoFreq = 12;
  lfoDepth = 0;
  dlfo = 0;
  editStart = 0;
  editEnd = 0;
}

VoiceData::~VoiceData() {
  
  int i;

  for (i = 0; i < MAX_PARAMS; i++) {
    free(harmonics[i]);
  }    
}

double VoiceData::getPitchBend() {

  return(pitchBend);
}

void VoiceData::setPitchBend(double p_pitchBend) {

  pitchBend = p_pitchBend;
}

bool VoiceData::doSynthesis() {

  return(synthesisFlag);
}

double VoiceData::getMinScale(int p_index) {

  return(minScale[p_index]);
}

double VoiceData::getMaxScale(int p_index) {

  return(maxScale[p_index]);
}

envelopeType* VoiceData::getEnvelopes() {

  return(envelopes);
}

double* VoiceData::getHarmonics(int p_index) { 

  return(harmonics[p_index]);
}

double VoiceData::getHarmonic(int p_index, int p_num) {
 
  if ((p_num >= 0) && (p_num < numHarmonics)) {
    return(harmonics[p_index][p_num]);
  } else {
    return(0);
  }
}

double VoiceData::getScaledHarmonic(int p_index, int p_num) {
 
  if ((p_num >= 0) && (p_num < numHarmonics)) {
    return(scaledHarmonics[p_index][p_num]);
  } else {
    return(0);
  }
}

void VoiceData::setHarmonic(int p_index, int p_num, double p_value) {
 
  double val;
  int e, c, i1;
  
  if ((p_num >= 0) && (p_num < numHarmonics)) {
    val = (p_value < 0) ? 0 : p_value;
    if (val > 100) val = 100;
    harmonics[p_index][p_num] = val;
    e = calcEditGroup(p_num);
    hmax[e][p_index] = 0;
    for (i1 = harmonicSplit[e]; i1 < harmonicSplit[e+1]; i1++) {
      if (harmonics[p_index][i1] > 0) {
        hmax[e][p_index] = i1 - harmonicSplit[e] + 1;
      }  
    }
    c = MAX_SCENES * MAX_SOURCES;
    switch (p_index) {
      case 0:
        scaledHarmonics[p_index][p_num] = scale[c * p_index + e] * scaleLin[p_index] * pow(val, 2.5);
        break;
      case 1:
        scaledHarmonics[p_index][p_num] = (double)rate * scale[c * p_index + e] * scaleLin[p_index] * pow(val, scaleExp[p_index]);
        break;
      case 2:
        scaledHarmonics[p_index][p_num] = (double)STEP/((double)rate * (1e-5 + scale[c * p_index + e] * scaleLin[p_index] * pow(val, scaleExp[p_index])));
        break;
      case 3:
        scaledHarmonics[p_index][p_num] = exp(-0.693147 * (double)STEP/(1e-5 + (double)rate * scale[c * p_index + e] * scaleLin[p_index] * pow(val, scaleExp[p_index])));
        break;
      case 4:
        scaledHarmonics[p_index][p_num] = exp(-0.693147 * (double)STEP/(1e-5 + (double)rate * scale[c * p_index + e] * scaleLin[p_index] * pow(val, scaleExp[p_index])));
        break;
      case 5:
        scaledHarmonics[p_index][p_num] = scale[c * p_index + e] * 0.001 * pow(10, val / 50.0);
        break;
      case 6:
        scaledHarmonics[p_index][p_num] = exp(-0.693147 * (double)STEP/(1e-5 + (double)rate * scale[c * p_index + e] * scaleLin[p_index] * pow(val, scaleExp[p_index])));
        break;
      case 7:
        scaledHarmonics[p_index][p_num] = scale[c * p_index + e] * scaleLin[p_index] * pow(val, scaleExp[p_index]); // Env Amplitude
        break;
      case 8:
        scaledHarmonics[p_index][p_num] = scale[c * p_index + e] * scaleLin[p_index] * pow(val, scaleExp[p_index]); // Env Freq
        break;
      case 9:
        scaledHarmonics[p_index][p_num] = scale[c * p_index + e] * scaleLin[p_index] * pow(val, scaleExp[p_index]); // Env Random
        break;
    }    
  }
}

void VoiceData::setGroupScale(int p_group, int p_index, int value) {

  int i1;
  
  if (p_index) {
    scale[MAX_SCENES * MAX_SOURCES * p_index + p_group] = pow(10.0, (double)value / 1000.0);
  } else {
    scale[MAX_SCENES * MAX_SOURCES * p_index + p_group] = pow(10.0, (double)value / 1000.0) - 0.1;
  }
  for (i1 = 0; i1 < numHarmonics; i1++) {
    setHarmonic(p_index, i1, harmonics[p_index][i1]);
  }
}

double VoiceData::getLFO() {

  return(lfo);
}

void VoiceData::lfoStep() {

  switch (lfoState) {
  case 1:
    if (lfo < lfoDepth) {
      lfo += dlfo;
      if (lfo > lfoDepth) {
        lfo = lfoDepth;
      }
    } else {
      lfoState = 2;
    }
    break;
  case 2:
    if (lfo > -lfoDepth) {
      lfo -= dlfo;
      if (lfo < -lfoDepth) {
        lfo = -lfoDepth;
      }
    } else {
      lfoState = 1;
    }
    break;
  }    
}
   
void VoiceData::setLfoFreq(double value) {

  lfoFreq = value;
  dlfo = 2.0 * lfoDepth * lfoFreq * (double)STEP / rate;
}          

double VoiceData::getLfoFreq() {

  return(lfoFreq);
}          

void VoiceData::setLfoDepth(double value) {

  lfoDepth = value;
  dlfo = 2.0 * lfoDepth * lfoFreq * (double)STEP / rate;
}          

double VoiceData::getLfoDepth() {

  return(lfoDepth);
}          

void VoiceData::resetLFO() {

  lfo = 0;
  lfoState = 1;
}

double VoiceData::getMorphing() {

  return(morphing);          
} 

void VoiceData::setMorphing(double value) {

  morphing = value;
}

double VoiceData::getDelta(int index) {

  return(delta[index]);
}

void VoiceData::setDelta(int index, double value) {

  delta[index] = value;
}

double *VoiceData::getFilter(int p_index) {

  return(filter[p_index]);
}            

double VoiceData::getFilter(int p_index, int p_num) {

  return(filter[p_index][p_num]);
}

void VoiceData::setFilter(int p_index, int p_num, double p_value) {

  if (p_value > 100) p_value = 100;
  filter[p_index][p_num] = (p_value < 0) ? 0 : p_value;
}

double VoiceData::getFilterCutoff(int p_index) {

  return(filterCutoff[p_index]);
}

double VoiceData::getFilterSpacing(int p_index) {

  return(filterSpacing[p_index]);
}

double VoiceData::getFilterKeyTracking(int p_index) {

  return(filterKeyTracking[p_index]);
}

double VoiceData::getFilterDepth(int p_index) {

  return(filterDepth[p_index]);
}

void VoiceData::setFilterCutoff(int p_index, double p_value) {

  filterCutoff[p_index] = p_value;
}

void VoiceData::setFilterSpacing(int p_index, double p_value) {

  filterSpacing[p_index] = p_value;
}

void VoiceData::setFilterKeyTracking(int p_index, double p_value) {

  filterKeyTracking[p_index] = p_value;
}

void VoiceData::setFilterDepth(int p_index, double p_value) {

  filterDepth[p_index] = p_value;
}

void VoiceData::setFilterMixMorph(int spectrumIndex, double value) {

  filterMixMorph[spectrumIndex] = value;
}

void VoiceData::setFilterMixMode(int spectrumIndex, double value) {

  filterMixMode[spectrumIndex] = value;
}

void VoiceData::setFilterMixEnvAmount(int spectrumIndex, double value) {

  filterMixEnvAmount[spectrumIndex] = value;
}

void VoiceData::setFilterMixDelay(int spectrumIndex, double value) {

  filterMixDelay[spectrumIndex] = value;
}

void VoiceData::setFilterMixAttack(int spectrumIndex, double value) {

  filterMixAttack[spectrumIndex] = value;
}

void VoiceData::setFilterMixDecay(int spectrumIndex, double value) {

  filterMixDecay[spectrumIndex] = value;
}

void VoiceData::setFilterMixLfo(int spectrumIndex, bool on) {

  filterMixLfo[spectrumIndex] = on;
}

void VoiceData::setFilterMixRetrigger(int spectrumIndex, bool on) {

  filterMixRetrigger[spectrumIndex] = on;
}

void VoiceData::setFilterMixHold(int spectrumIndex, bool on) {

  filterMixHold[spectrumIndex] = on;
}

double VoiceData::getFilterMixMorph(int spectrumIndex) {

  return(filterMixMorph[spectrumIndex]);
}

double VoiceData::getFilterMixMode(int spectrumIndex) {

  return(filterMixMode[spectrumIndex]);
}

double VoiceData::getFilterMixEnvAmount(int spectrumIndex) {

  return(filterMixEnvAmount[spectrumIndex]);
}

double VoiceData::getFilterMixDelay(int spectrumIndex) {

  return(filterMixDelay[spectrumIndex]);
}

double VoiceData::getFilterMixAttack(int spectrumIndex) {

  return(filterMixAttack[spectrumIndex]);
}

double VoiceData::getFilterMixDecay(int spectrumIndex) {

  return(filterMixDecay[spectrumIndex]);
}

bool VoiceData::getFilterMixLfo(int spectrumIndex) {

  return(filterMixLfo[spectrumIndex]);
}

bool VoiceData::getFilterMixRetrigger(int spectrumIndex) {

  return(filterMixRetrigger[spectrumIndex]);
}

bool VoiceData::getFilterMixHold(int spectrumIndex) {

  return(filterMixHold[spectrumIndex]);
}

void VoiceData::setFilterModEnvelope(int filterIndex, modulationEnvelope p_Envelope) {

  filterModEnvelope[filterIndex] = p_Envelope;
}

void VoiceData::setFilterModLfo(int filterIndex, modulationLfo p_Lfo) {

  filterModLfo[filterIndex] = p_Lfo;
}

void VoiceData::setFilterModSpacingLfo(int filterIndex, modulationLfo p_Lfo) {

  filterModSpacingLfo[filterIndex] = p_Lfo;
}

modulationEnvelope VoiceData::getFilterModEnvelope(int filterIndex) {

  return(filterModEnvelope[filterIndex]);
}

modulationLfo VoiceData::getFilterModLfo(int filterIndex) {

  return(filterModLfo[filterIndex]);
}

modulationLfo VoiceData::getFilterModSpacingLfo(int filterIndex) {

  return(filterModSpacingLfo[filterIndex]);
}

void VoiceData::setEvenOdd(int index, double value) {

  evenOdd[index] = value;
}

double VoiceData::getEvenOdd(int index) {

  return(evenOdd[index]);
}

void VoiceData::setMasterVolume(double value) {

  masterVolume = value;
}
        
double VoiceData::getMasterVolume() {

  return(masterVolume);
}

void VoiceData::setNoiseBandwidth(double value) {

  noiseBandwidth = value;
}

double VoiceData::getNoiseBandwidth() {

  return(noiseBandwidth);       
}

void VoiceData::setCompressor(int index, double value) {

  switch (index) {
    case 0:
      linearLevel = 0.008 * pow(10, value / 500.0);
      break;
    case 1:
      transitionWidth = 0.03 * pow(10, value / 500.0);
      break;
    case 2:
      compression = 0.005 * pow(10, value / 500.0);
      break;    
    case 3:
      antialiasing = 1.0 + (1000.0 - value) / 66.6666667;
      break;    
  }
}

void VoiceData::getCompressorCoeff(double& x0, double& x1, double& a, double& b, double& c, double& d, double& aa) {

  x0 = (double)MAX_LEVEL * linearLevel;
  x1 = x0 + (double)MAX_LEVEL * transitionWidth;
  d = compression;
  c = x0*(1.0 - d) + (x0*x1)/(x0-x1) - x0*x0/(2.0 * (x0-x1));
  b = 1.0/(2.0 * (x0-x1));
  a = d - x1/(x0-x1);
  aa = antialiasing;
}

int VoiceData::calcEditGroup(int p_index) {

  int e, i1;
  
  e = 0;
  for (i1 = 0; i1 < MAX_SPLIT; i1++) {
    if (p_index >= harmonicSplit[i1]) {
      e = i1;
    }
  }
  return(e);
}

void VoiceData::setChannel(int value) {

  channel = value;
}

int VoiceData::getChannel() {

  return(channel);
}  

void VoiceData::setFileName(QString name) {

  fileName = name;
}  

QString VoiceData::getFileName() {
 
  return(fileName);
}

voiceType* VoiceData::getVoice() {

  return(voice);
}

void VoiceData::setVoice(voiceType* p_voice) {

  voice = p_voice;
}

void VoiceData::setRate(int p_rate) {

  rate = p_rate;
}

void VoiceData::setEditRange(int start, int end) {

  editStart = start;
  editEnd = end;
}

void VoiceData::getEditRange(int& start, int& end) {

  start = editStart;
  end = editEnd;
}

void VoiceData::setPan(int index, double value) {

  switch (index) {
    case 0:
      panCenter = (500.0 - value) / 500.0;
      break;
    case 1:
      panWidth = value / 1000.0;
      break;
    case 2:
      panMode = (int)value;
      break;    
  }
}
    
void VoiceData::getPan(double& p_panCenter, double& p_panWidth, int& p_panMode) {

  p_panCenter = panCenter;
  p_panWidth = panWidth;
  p_panMode = panMode;
}

int VoiceData::getMaxHarmonic(int p_index) {

  if (hmax[p_index][0] > (hmax[MAX_SOURCES + p_index][0])) {
    return(hmax[p_index][0]);
  } else {
    return(hmax[MAX_SOURCES + p_index][0]);
  }
}

int VoiceData::getHMax(int p_index, int p_num) {

  return(hmax[p_index][p_num]);
}

void VoiceData::setComment(QString qs) {

  comment = qs;
}

QString VoiceData::getComment() {

  return(comment);
}

void VoiceData::setNoiseSubHarmonicMode(bool on) {

  noiseSubHarmonicMode = on;
}

bool VoiceData::getNoiseSubHarmonicMode() {

  return(noiseSubHarmonicMode);
}

void VoiceData::setOsc3Mode(int value) {

  osc3Mode = value;
}

int VoiceData::getOsc3Mode() {

  return(osc3Mode);
}

void VoiceData::setOsc3FreqDiffusion(int value) {

   osc3FreqDiffusion = value;
}

int VoiceData::getOsc3FreqDiffusion() {

  return(osc3FreqDiffusion);
}

void VoiceData::setNoiseFreqDiffusion(int value) {

  noiseFreqDiffusion = value;
}

int VoiceData::getNoiseFreqDiffusion() {

  return(noiseFreqDiffusion);
}

void VoiceData::setDetune(double value) {

  detune = value;
}

double VoiceData::getDetune() {

  return(detune);
}

void VoiceData::setOffsetDetune(double value) {

  offsetDetune = value;
}

double VoiceData::getOffsetDetune() {

  return(offsetDetune);
}

void VoiceData::setVoiceRandom(double value) {

  voiceRandom = value;
}

double VoiceData::getVoiceRandom() {

  return(voiceRandom);
}

void VoiceData::newCurrentVoiceDetune() {

  double rscale;

  rscale = 0.5 / (double)RAND_MAX;
  currentVoiceDetune = rscale * offsetDetune * rand();
}

double VoiceData::getCurrentVoiceDetune() {

  return(currentVoiceDetune);
}

void VoiceData::setVolumeTracking(double value) {

  volumeTracking = value;
}

double VoiceData::getVolumeTracking() {

  return(volumeTracking);
}

void VoiceData::setVelocityDepth(double value) {

  velocityDepth = value;
}

double VoiceData::getVelocityDepth() {

  return(velocityDepth);
}
