#include <stdio.h>      
#include <stdlib.h>     
#include <unistd.h>
#include <QtWidgets/QApplication>
#include <QtWidgets/QMainWindow>
#include <QtWidgets/QMenuBar>   
#include <QtWidgets/QMenu>   
#include <QtWidgets/QInputDialog>   
#include <QtCore/QString>   
#include "model.h"
#include "gui.h"
#include "jackprocessor.h"

int main(int argc, char *argv[])  
{
  bool interpolate, ok, set_poly, set_interpolate;
  int poly, rate, bufsize, i, interpolate_int;    
  QFile f;
  QString qs;
  char buf[256];

  poly = 4;
  rate = 44100;
  bufsize = 1024;
  interpolate = false;
  set_poly = true;
  set_interpolate = true;
  QApplication *myApp = new QApplication(argc, argv);
  QMainWindow *top = new QMainWindow();
  top->setWindowTitle("Add64  v.3.9.3   (c)2011-2020 by Matthias Nagorni");
  f.setFileName("Add64-MIDIconfig");
  if (f.exists()) { 
    f.open(QIODevice::ReadOnly);
    f.readLine(buf, sizeof(buf));
    qs = QString(buf);
    poly = qs.toInt();
    f.readLine(buf, sizeof(buf));
    qs = QString(buf);
    interpolate_int = qs.toInt();
    set_interpolate = (interpolate_int < 0);
    interpolate = (interpolate_int > 0);
    f.close();
    set_poly = (poly == 0);
    if (poly < 1) poly = 1;
    if (poly > MAX_POLY) poly = MAX_POLY;
  }                                                                    
  if (set_poly) {
    i = QInputDialog::getInt(top, "Add64 Polyphony", "Polyphony: ", 4, 1, MAX_POLY, 1, &ok);
    if (ok && (i > 0) && (i <= MAX_POLY)) {
      poly = i;
    } 
  }   
  if (set_interpolate) {
    QStringList itemList = {"Sample @ full rate", "Sample @ rate/2 and interpolate"};
    qs = QInputDialog::getItem(top, "Quality Settings", "Use sampling @ full rate for highest quality", itemList, 0, false, &ok);
    interpolate = (qs == itemList.at(1));
  }  
  Model model(poly);
  model.setInterpolate(interpolate);
  model.setRate(rate);
  model.setBufSize(bufsize);
  model.setEditRange(0, poly - 1);
  Gui gui(&model, top);
  QMenu *fileMenu = top->menuBar()->addMenu("&File");
  fileMenu->addAction("&Load Sound (XML Format)", &gui, SLOT(loadXML()));
  fileMenu->addAction("&Save Sound (XML Format)", &gui, SLOT(saveXML()));
  fileMenu->addSeparator();
  fileMenu->addAction("Loa&d MIDI Map", &gui, SLOT(loadMidi()));
  fileMenu->addAction("Sav&e MIDI Map", &gui, SLOT(saveMidi()));
  fileMenu->addSeparator();
  fileMenu->addAction("&Quit", myApp, SLOT(quit()));
  QMenu *commentMenu = top->menuBar()->addMenu("&Comment");
  commentMenu->addAction("&New Comment", &gui, SLOT(addComment()));
  commentMenu->addAction("&Edit Comment", &gui, SLOT(editComment()));
  commentMenu->addAction("&Show Comment", &gui, SLOT(showComment()));
  QMenu *scalaMenu = top->menuBar()->addMenu("&Scala");
  scalaMenu->addAction("&Edit Scala Settings", &gui, SLOT(showScalaDialog()));
  QMenu *helpMenu = top->menuBar()->addMenu("&Help");
  helpMenu->addAction("&About Add64", &gui, SLOT(showAbout()));
  helpMenu->addAction("&About Qt", myApp, SLOT(aboutQt()));
  QObject::connect(myApp, SIGNAL(aboutToQuit()), &gui, SLOT(closeGui()));
  top->setCentralWidget(&gui);
  top->show();
  return myApp->exec(); 
}
