<xsl:transform version="1.0"
    xmlns:xsl  ="http://www.w3.org/1999/XSL/Transform"
    xmlns:h    ="http://www.w3.org/1999/xhtml"
    xmlns:s    ="http://www.w3.org/2000/01/rdf-schema#"
    xmlns:r    ="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
    xmlns:m="http://www.w3.org/1998/Math/MathML"
    >

<xsl:output method="text" />

<xsl:template match="/">
  <xsl:for-each select='document("spec_rules.html")//*[@class="prefixes"]/h:li'>
    <xsl:variable name="pfx" select="normalize-space(h:b)" />
    <xsl:variable name="uri" select="normalize-space(h:a/@href)" />
    <xsl:text>@prefix </xsl:text>
    <xsl:value-of select="$pfx" />
    <xsl:text>: &lt;</xsl:text>
    <xsl:value-of select="$uri" />
    <xsl:text>>.&#x0A;</xsl:text>
  </xsl:for-each>

  <xsl:text>&#x0A;</xsl:text>

  <xsl:apply-templates />
</xsl:template>

<xsl:template match='*[@class="rule"]'>
  <xsl:text>{</xsl:text>
  <xsl:value-of select="h:tr[1]//h:pre" />
  <xsl:text>} => {</xsl:text>
  <xsl:value-of select="h:tr[3]//h:pre" />
  <xsl:text>}.&#x0A;&#x0A;</xsl:text>
</xsl:template>

<!-- don't pass text thru -->
<xsl:template match="text()|@*">
</xsl:template>

</xsl:transform>
