#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Stellaris expansions (main expansions):
# - Utopia
# - Apocalypse
# - MegaCorp
# - Federations
# - Nemesis
# - Overlord
# - Galactic Paragons
# - The Machine Age
###

script_version=20241215.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='stellaris'
GAME_NAME='Stellaris'

EXPANSION_ID_UTOPIA='utopia'
EXPANSION_NAME_UTOPIA='Utopia'

EXPANSION_ID_APOCALYPSE='apocalypse'
EXPANSION_NAME_APOCALYPSE='Apocalypse'

EXPANSION_ID_MEGACORP='megacorp'
EXPANSION_NAME_MEGACORP='MegaCorp'

EXPANSION_ID_FEDERATIONS='federations'
EXPANSION_NAME_FEDERATIONS='Federations'

EXPANSION_ID_NEMESIS='nemesis'
EXPANSION_NAME_NEMESIS='Nemesis'

EXPANSION_ID_OVERLORD='overlord'
EXPANSION_NAME_OVERLORD='Overlord'

EXPANSION_ID_PARAGONS='galactic-paragons'
EXPANSION_NAME_PARAGONS='Galactic Paragons'

EXPANSION_ID_MACHINE='the-machine-age'
EXPANSION_NAME_MACHINE='The Machine Age'

# Archives

## Utopia

ARCHIVE_BASE_UTOPIA_58_NAME='stellaris_utopia_3_14_15926_78464.sh'
ARCHIVE_BASE_UTOPIA_58_MD5='62b9c4f468f049c1943cfcda6ff8c79e'
ARCHIVE_BASE_UTOPIA_58_SIZE='75007'
ARCHIVE_BASE_UTOPIA_58_VERSION='3.14.15926-gog78464'
ARCHIVE_BASE_UTOPIA_58_URL='https://www.gog.com/game/stellaris_utopia'

ARCHIVE_BASE_UTOPIA_57_NAME='stellaris_utopia_3_13_2_0_76713.sh'
ARCHIVE_BASE_UTOPIA_57_MD5='12459f9b139ca756b2c19a5755e41b67'
ARCHIVE_BASE_UTOPIA_57_SIZE='75007'
ARCHIVE_BASE_UTOPIA_57_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_UTOPIA_54_NAME='stellaris_utopia_3_12_5_74193.sh'
ARCHIVE_BASE_UTOPIA_54_MD5='94ce113fad5b52d0464bfa48905412cc'
ARCHIVE_BASE_UTOPIA_54_SIZE='75007'
ARCHIVE_BASE_UTOPIA_54_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_UTOPIA_50_NAME='stellaris_utopia_3_11_3_0_72561.sh'
ARCHIVE_BASE_UTOPIA_50_MD5='b459de0ff28f660f9f9f6a38b5963df8'
ARCHIVE_BASE_UTOPIA_50_SIZE='75007'
ARCHIVE_BASE_UTOPIA_50_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_UTOPIA_47_NAME='stellaris_utopia_3_10_4_70670.sh'
ARCHIVE_BASE_UTOPIA_47_MD5='34740602274bd7cb248a25dbcf68ae50'
ARCHIVE_BASE_UTOPIA_47_SIZE='75007'
ARCHIVE_BASE_UTOPIA_47_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_UTOPIA_41_NAME='stellaris_utopia_3_9_3_68314.sh'
ARCHIVE_BASE_UTOPIA_41_MD5='b720f9ac6deec5dda989e0b52c2cee80'
ARCHIVE_BASE_UTOPIA_41_SIZE='75324'
ARCHIVE_BASE_UTOPIA_41_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_UTOPIA_38_NAME='stellaris_utopia_3_8_4_1_65337.sh'
ARCHIVE_BASE_UTOPIA_38_MD5='f37db816affaea32fa037afcf05e6f5c'
ARCHIVE_BASE_UTOPIA_38_SIZE='76000'
ARCHIVE_BASE_UTOPIA_38_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_UTOPIA_34_NAME='stellaris_utopia_3_7_4_63489.sh'
ARCHIVE_BASE_UTOPIA_34_MD5='757c0a5000d03c0c977ea3feb4ac4bec'
ARCHIVE_BASE_UTOPIA_34_SIZE='76000'
ARCHIVE_BASE_UTOPIA_34_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_UTOPIA_31_NAME='stellaris_utopia_3_6_1_60754.sh'
ARCHIVE_BASE_UTOPIA_31_MD5='6942f80fac13261e2de34e350d96e6b8'
ARCHIVE_BASE_UTOPIA_31_SIZE='76000'
ARCHIVE_BASE_UTOPIA_31_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_UTOPIA_29_NAME='stellaris_utopia_3_5_3_59410.sh'
ARCHIVE_BASE_UTOPIA_29_MD5='b71a7c123fa029a65fdeee0f46112560'
ARCHIVE_BASE_UTOPIA_29_SIZE='76000'
ARCHIVE_BASE_UTOPIA_29_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_UTOPIA_27_NAME='stellaris_utopia_3_4_5_56913.sh'
ARCHIVE_BASE_UTOPIA_27_MD5='c78bbd8859e22b93534f8aeec16ef08f'
ARCHIVE_BASE_UTOPIA_27_SIZE='76000'
ARCHIVE_BASE_UTOPIA_27_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_UTOPIA_23_NAME='stellaris_utopia_3_3_4_54421.sh'
ARCHIVE_BASE_UTOPIA_23_MD5='9b4715a94ffdca001ff56e6e6d9a807d'
ARCHIVE_BASE_UTOPIA_23_SIZE='76000'
ARCHIVE_BASE_UTOPIA_23_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_UTOPIA_19_NAME='stellaris_utopia_3_2_1_1_51520.sh'
ARCHIVE_BASE_UTOPIA_19_MD5='bb6b18eabd4e45d846468e1c38d2e7ea'
ARCHIVE_BASE_UTOPIA_19_SIZE='76000'
ARCHIVE_BASE_UTOPIA_19_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_UTOPIA_18_NAME='stellaris_utopia_3_1_1_50008.sh'
ARCHIVE_BASE_UTOPIA_18_MD5='129501ad6bf862bc04aa775f6538e7fe'
ARCHIVE_BASE_UTOPIA_18_SIZE='76000'
ARCHIVE_BASE_UTOPIA_18_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_UTOPIA_17_NAME='stellaris_utopia_3_0_3_47193.sh'
ARCHIVE_BASE_UTOPIA_17_MD5='0987db58e4cb8629714bbe9b2d01906e'
ARCHIVE_BASE_UTOPIA_17_SIZE='76000'
ARCHIVE_BASE_UTOPIA_17_VERSION='3.0.3-gog47193'

## Apocalypse

ARCHIVE_BASE_APOCALYPSE_48_NAME='stellaris_apocalypse_3_14_15926_78464.sh'
ARCHIVE_BASE_APOCALYPSE_48_MD5='fe095847b18e9279daca3f2eb407cc2b'
ARCHIVE_BASE_APOCALYPSE_48_SIZE='37877'
ARCHIVE_BASE_APOCALYPSE_48_VERSION='3.14.15926-gog78464'
ARCHIVE_BASE_APOCALYPSE_48_URL='https://www.gog.com/game/stellaris_apocalypse'

ARCHIVE_BASE_APOCALYPSE_47_NAME='stellaris_apocalypse_3_13_2_0_76713.sh'
ARCHIVE_BASE_APOCALYPSE_47_MD5='ee89fa59d427166031964f106053fd39'
ARCHIVE_BASE_APOCALYPSE_47_SIZE='37877'
ARCHIVE_BASE_APOCALYPSE_47_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_APOCALYPSE_44_NAME='stellaris_apocalypse_3_12_5_74193.sh'
ARCHIVE_BASE_APOCALYPSE_44_MD5='72c6721003d27d922fd134210da8b82f'
ARCHIVE_BASE_APOCALYPSE_44_SIZE='37877'
ARCHIVE_BASE_APOCALYPSE_44_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_APOCALYPSE_40_NAME='stellaris_apocalypse_3_11_3_0_72561.sh'
ARCHIVE_BASE_APOCALYPSE_40_MD5='5865125d875c8ddc549b8f0f4fd79ebd'
ARCHIVE_BASE_APOCALYPSE_40_SIZE='37877'
ARCHIVE_BASE_APOCALYPSE_40_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_APOCALYPSE_37_NAME='stellaris_apocalypse_3_10_4_70670.sh'
ARCHIVE_BASE_APOCALYPSE_37_MD5='77856badbd6716a8d4b2b7c3d50dac7d'
ARCHIVE_BASE_APOCALYPSE_37_SIZE='37877'
ARCHIVE_BASE_APOCALYPSE_37_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_APOCALYPSE_31_NAME='stellaris_apocalypse_3_9_3_68314.sh'
ARCHIVE_BASE_APOCALYPSE_31_MD5='1e81c558321b0c494118f5eaa320a31a'
ARCHIVE_BASE_APOCALYPSE_31_SIZE='38196'
ARCHIVE_BASE_APOCALYPSE_31_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_APOCALYPSE_28_NAME='stellaris_apocalypse_3_8_4_1_65337.sh'
ARCHIVE_BASE_APOCALYPSE_28_MD5='a01fd114beedaae30f8036532aeaa3a5'
ARCHIVE_BASE_APOCALYPSE_28_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_28_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_APOCALYPSE_24_NAME='stellaris_apocalypse_3_7_4_63489.sh'
ARCHIVE_BASE_APOCALYPSE_24_MD5='635fad17d0a6dbcb51bc4bc134f7a2fc'
ARCHIVE_BASE_APOCALYPSE_24_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_24_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_APOCALYPSE_21_NAME='stellaris_apocalypse_3_6_1_60754.sh'
ARCHIVE_BASE_APOCALYPSE_21_MD5='ba7aa69bc21ddc041767975d6891c394'
ARCHIVE_BASE_APOCALYPSE_21_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_21_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_APOCALYPSE_19_NAME='stellaris_apocalypse_3_5_3_59410.sh'
ARCHIVE_BASE_APOCALYPSE_19_MD5='40e997269f2806e26c3cef5b604009e2'
ARCHIVE_BASE_APOCALYPSE_19_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_19_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_APOCALYPSE_17_NAME='stellaris_apocalypse_3_4_5_56913.sh'
ARCHIVE_BASE_APOCALYPSE_17_MD5='2294a815d331a90c2a226ea679d1b9c2'
ARCHIVE_BASE_APOCALYPSE_17_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_17_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_APOCALYPSE_13_NAME='stellaris_apocalypse_3_3_4_54421.sh'
ARCHIVE_BASE_APOCALYPSE_13_MD5='df86d7aa67f4be37822523fef72d15ee'
ARCHIVE_BASE_APOCALYPSE_13_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_13_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_APOCALYPSE_9_NAME='stellaris_apocalypse_3_2_1_1_51520.sh'
ARCHIVE_BASE_APOCALYPSE_9_MD5='0db5f6b23432efa4941f7e4e89ff9488'
ARCHIVE_BASE_APOCALYPSE_9_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_9_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_APOCALYPSE_8_NAME='stellaris_apocalypse_3_1_1_50008.sh'
ARCHIVE_BASE_APOCALYPSE_8_MD5='a4d25b308d2daf3c81fef2aef33727da'
ARCHIVE_BASE_APOCALYPSE_8_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_8_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_APOCALYPSE_7_NAME='stellaris_apocalypse_3_0_3_47193.sh'
ARCHIVE_BASE_APOCALYPSE_7_MD5='3cdf97dedf2514fbb1e9fd123cb253b7'
ARCHIVE_BASE_APOCALYPSE_7_SIZE='39000'
ARCHIVE_BASE_APOCALYPSE_7_VERSION='3.0.3-gog47193'

## MegaCorp

ARCHIVE_BASE_MEGACORP_45_NAME='stellaris_megacorp_3_14_15926_78464.sh'
ARCHIVE_BASE_MEGACORP_45_MD5='a16aec518e86ad716206899230871099'
ARCHIVE_BASE_MEGACORP_45_SIZE='90404'
ARCHIVE_BASE_MEGACORP_45_VERSION='3.14.15926-gog78464'
ARCHIVE_BASE_MEGACORP_45_URL='https://www.gog.com/game/stellaris_megacorp'

ARCHIVE_BASE_MEGACORP_44_NAME='stellaris_megacorp_3_13_2_0_76713.sh'
ARCHIVE_BASE_MEGACORP_44_MD5='e6b76bb98c26ec597e3a37b3aa915f46'
ARCHIVE_BASE_MEGACORP_44_SIZE='90404'
ARCHIVE_BASE_MEGACORP_44_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_MEGACORP_41_NAME='stellaris_megacorp_3_12_5_74193.sh'
ARCHIVE_BASE_MEGACORP_41_MD5='056684f8cabd2bff919a6f1e1b12837a'
ARCHIVE_BASE_MEGACORP_41_SIZE='130614'
ARCHIVE_BASE_MEGACORP_41_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_MEGACORP_37_NAME='stellaris_megacorp_3_11_3_0_72561.sh'
ARCHIVE_BASE_MEGACORP_37_MD5='9c9fda0324405590e48d4da9741dcdb0'
ARCHIVE_BASE_MEGACORP_37_SIZE='130614'
ARCHIVE_BASE_MEGACORP_37_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_MEGACORP_34_NAME='stellaris_megacorp_3_10_4_70670.sh'
ARCHIVE_BASE_MEGACORP_34_MD5='c155eb5f1b6f3283e068b17574107070'
ARCHIVE_BASE_MEGACORP_34_SIZE='130614'
ARCHIVE_BASE_MEGACORP_34_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_MEGACORP_28_NAME='stellaris_megacorp_3_9_3_68314.sh'
ARCHIVE_BASE_MEGACORP_28_MD5='b4bf123675295aa81910698500cdd33b'
ARCHIVE_BASE_MEGACORP_28_SIZE='130940'
ARCHIVE_BASE_MEGACORP_28_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_MEGACORP_25_NAME='stellaris_megacorp_3_8_4_1_65337.sh'
ARCHIVE_BASE_MEGACORP_25_MD5='3b00aacd428ef943bbbd7a4d0e6b50b2'
ARCHIVE_BASE_MEGACORP_25_SIZE='140000'
ARCHIVE_BASE_MEGACORP_25_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_MEGACORP_21_NAME='stellaris_megacorp_3_7_4_63489.sh'
ARCHIVE_BASE_MEGACORP_21_MD5='5b9573bb4261bd177dad3f4acc74a6a1'
ARCHIVE_BASE_MEGACORP_21_SIZE='140000'
ARCHIVE_BASE_MEGACORP_21_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_MEGACORP_18_NAME='stellaris_megacorp_3_6_1_60754.sh'
ARCHIVE_BASE_MEGACORP_18_MD5='af184beefdd7efc6f2d3973bf0d50c71'
ARCHIVE_BASE_MEGACORP_18_SIZE='140000'
ARCHIVE_BASE_MEGACORP_18_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_MEGACORP_16_NAME='stellaris_megacorp_3_5_3_59410.sh'
ARCHIVE_BASE_MEGACORP_16_MD5='2a95d9ff26ed58860be33c860c41fd63'
ARCHIVE_BASE_MEGACORP_16_SIZE='140000'
ARCHIVE_BASE_MEGACORP_16_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_MEGACORP_14_NAME='stellaris_megacorp_3_4_5_56913.sh'
ARCHIVE_BASE_MEGACORP_14_MD5='893df0403e44e6e36060756740230147'
ARCHIVE_BASE_MEGACORP_14_SIZE='140000'
ARCHIVE_BASE_MEGACORP_14_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_MEGACORP_10_NAME='stellaris_megacorp_3_3_4_54421.sh'
ARCHIVE_BASE_MEGACORP_10_MD5='44fb07a81f15d0954088f4bfd88fb933'
ARCHIVE_BASE_MEGACORP_10_SIZE='140000'
ARCHIVE_BASE_MEGACORP_10_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_MEGACORP_6_NAME='stellaris_megacorp_3_2_1_1_51520.sh'
ARCHIVE_BASE_MEGACORP_6_MD5='5965b8b2b51ae9e3dca5726c5d466792'
ARCHIVE_BASE_MEGACORP_6_SIZE='140000'
ARCHIVE_BASE_MEGACORP_6_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_MEGACORP_5_NAME='stellaris_megacorp_3_1_1_50008.sh'
ARCHIVE_BASE_MEGACORP_5_MD5='fa01a1fb786ae3625437bd23275ac401'
ARCHIVE_BASE_MEGACORP_5_SIZE='140000'
ARCHIVE_BASE_MEGACORP_5_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_MEGACORP_4_NAME='stellaris_megacorp_3_0_3_47193.sh'
ARCHIVE_BASE_MEGACORP_4_MD5='8992c77ac7de034c7d3deceb656fb3f6'
ARCHIVE_BASE_MEGACORP_4_SIZE='140000'
ARCHIVE_BASE_MEGACORP_4_VERSION='3.0.3-gog47193'

## Federations

ARCHIVE_BASE_FEDERATIONS_40_NAME='stellaris_federations_3_14_15926_78464.sh'
ARCHIVE_BASE_FEDERATIONS_40_MD5='11fb43cc5b19aebd6bbece34c75492c5'
ARCHIVE_BASE_FEDERATIONS_40_SIZE='14433'
ARCHIVE_BASE_FEDERATIONS_40_VERSION='3.14.15926-gog78464'
ARCHIVE_BASE_FEDERATIONS_40_URL='https://www.gog.com/game/stellaris_federations'

ARCHIVE_BASE_FEDERATIONS_39_NAME='stellaris_federations_3_13_2_0_76713.sh'
ARCHIVE_BASE_FEDERATIONS_39_MD5='48ff77ab8c028f6088a0c6743da2bbed'
ARCHIVE_BASE_FEDERATIONS_39_SIZE='14433'
ARCHIVE_BASE_FEDERATIONS_39_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_FEDERATIONS_36_NAME='stellaris_federations_3_12_5_74193.sh'
ARCHIVE_BASE_FEDERATIONS_36_MD5='77b14499ea1a8fe7d643e3881a473d0d'
ARCHIVE_BASE_FEDERATIONS_36_SIZE='14433'
ARCHIVE_BASE_FEDERATIONS_36_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_FEDERATIONS_32_NAME='stellaris_federations_3_11_3_0_72561.sh'
ARCHIVE_BASE_FEDERATIONS_32_MD5='de18cbab731d65f25fcc58ea98a16a12'
ARCHIVE_BASE_FEDERATIONS_32_SIZE='14433'
ARCHIVE_BASE_FEDERATIONS_32_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_FEDERATIONS_29_NAME='stellaris_federations_3_10_4_70670.sh'
ARCHIVE_BASE_FEDERATIONS_29_MD5='00836b70d3d84d95de238c607e25e309'
ARCHIVE_BASE_FEDERATIONS_29_SIZE='14433'
ARCHIVE_BASE_FEDERATIONS_29_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_FEDERATIONS_23_NAME='stellaris_federations_3_9_3_68314.sh'
ARCHIVE_BASE_FEDERATIONS_23_MD5='5c2ecccea91eeeea578cd2925a5621eb'
ARCHIVE_BASE_FEDERATIONS_23_SIZE='14752'
ARCHIVE_BASE_FEDERATIONS_23_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_FEDERATIONS_20_NAME='stellaris_federations_3_8_4_1_65337.sh'
ARCHIVE_BASE_FEDERATIONS_20_MD5='6fd1449caf09cfd06baff37237aff954'
ARCHIVE_BASE_FEDERATIONS_20_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_20_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_FEDERATIONS_16_NAME='stellaris_federations_3_7_4_63489.sh'
ARCHIVE_BASE_FEDERATIONS_16_MD5='df6d008a05e26559ba65d184e52d5926'
ARCHIVE_BASE_FEDERATIONS_16_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_16_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_FEDERATIONS_13_NAME='stellaris_federations_3_6_1_60754.sh'
ARCHIVE_BASE_FEDERATIONS_13_MD5='7f86c6a7c6d13946528a58c90c7eebc8'
ARCHIVE_BASE_FEDERATIONS_13_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_13_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_FEDERATIONS_11_NAME='stellaris_federations_3_5_3_59410.sh'
ARCHIVE_BASE_FEDERATIONS_11_MD5='02dee79bf1c26ba1b1cfca5103dccdca'
ARCHIVE_BASE_FEDERATIONS_11_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_11_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_FEDERATIONS_9_NAME='stellaris_federations_3_4_5_56913.sh'
ARCHIVE_BASE_FEDERATIONS_9_MD5='96170769d5fef74f2aedf9f3fd85f656'
ARCHIVE_BASE_FEDERATIONS_9_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_9_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_FEDERATIONS_5_NAME='stellaris_federations_3_3_4_54421.sh'
ARCHIVE_BASE_FEDERATIONS_5_MD5='d0dcbaef570563bb87dd16e600e162bd'
ARCHIVE_BASE_FEDERATIONS_5_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_5_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_FEDERATIONS_1_NAME='stellaris_federations_3_2_2_51685.sh'
ARCHIVE_BASE_FEDERATIONS_1_MD5='df17fc878abd4eb957e147feb5b7e39b'
ARCHIVE_BASE_FEDERATIONS_1_SIZE='15000'
ARCHIVE_BASE_FEDERATIONS_1_VERSION='3.2.2-gog51685'

## Nemesis

ARCHIVE_BASE_NEMESIS_27_NAME='stellaris_nemesis_3_14_15926_78464.sh'
ARCHIVE_BASE_NEMESIS_27_MD5='d950bf759ba6311143b1be3ec6811fd7'
ARCHIVE_BASE_NEMESIS_27_SIZE='38539'
ARCHIVE_BASE_NEMESIS_27_VERSION='3.14.15926-gog78464'
ARCHIVE_BASE_NEMESIS_27_URL='https://www.gog.com/game/stellaris_nemesis'

ARCHIVE_BASE_NEMESIS_26_NAME='stellaris_nemesis_3_13_2_0_76713.sh'
ARCHIVE_BASE_NEMESIS_26_MD5='3ab5141b829c7747c4622b92789fbe43'
ARCHIVE_BASE_NEMESIS_26_SIZE='38539'
ARCHIVE_BASE_NEMESIS_26_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_NEMESIS_23_NAME='stellaris_nemesis_3_12_5_74193.sh'
ARCHIVE_BASE_NEMESIS_23_MD5='30187118ff7f8fed4db3b453f2b1a467'
ARCHIVE_BASE_NEMESIS_23_SIZE='38539'
ARCHIVE_BASE_NEMESIS_23_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_NEMESIS_19_NAME='stellaris_nemesis_3_11_3_0_72561.sh'
ARCHIVE_BASE_NEMESIS_19_MD5='a6380543924bf1479101511337238f29'
ARCHIVE_BASE_NEMESIS_19_SIZE='38539'
ARCHIVE_BASE_NEMESIS_19_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_NEMESIS_16_NAME='stellaris_nemesis_3_10_4_70670.sh'
ARCHIVE_BASE_NEMESIS_16_MD5='749b70150b8b77b9f905d50b641594c7'
ARCHIVE_BASE_NEMESIS_16_SIZE='38539'
ARCHIVE_BASE_NEMESIS_16_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_NEMESIS_10_NAME='stellaris_nemesis_3_9_3_68314.sh'
ARCHIVE_BASE_NEMESIS_10_MD5='105f2c56365c3b2b3c329806e4b5272b'
ARCHIVE_BASE_NEMESIS_10_SIZE='38856'
ARCHIVE_BASE_NEMESIS_10_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_NEMESIS_7_NAME='stellaris_nemesis_3_8_4_1_65337.sh'
ARCHIVE_BASE_NEMESIS_7_MD5='ea624db6ea0f9f485cb194c1358dda62'
ARCHIVE_BASE_NEMESIS_7_SIZE='40000'
ARCHIVE_BASE_NEMESIS_7_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_NEMESIS_3_NAME='stellaris_nemesis_3_7_4_63489.sh'
ARCHIVE_BASE_NEMESIS_3_MD5='9fa7ca1ebe2ffb736787f18bf2611311'
ARCHIVE_BASE_NEMESIS_3_SIZE='40000'
ARCHIVE_BASE_NEMESIS_3_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_NEMESIS_0_NAME='stellaris_nemesis_3_6_1_60754.sh'
ARCHIVE_BASE_NEMESIS_0_MD5='ec08053da0ef60ea42a974b26892031a'
ARCHIVE_BASE_NEMESIS_0_SIZE='40000'
ARCHIVE_BASE_NEMESIS_0_VERSION='3.6.1-gog60754'

## Overlord

ARCHIVE_BASE_OVERLORD_22_NAME='stellaris_overlord_3_14_15926_78464.sh'
ARCHIVE_BASE_OVERLORD_22_MD5='cbc6247838f41c5d8f78c6fb6dba8ac4'
ARCHIVE_BASE_OVERLORD_22_SIZE='99860'
ARCHIVE_BASE_OVERLORD_22_VERSION='3.14.15926-gog78464'
ARCHIVE_BASE_OVERLORD_22_URL='https://www.gog.com/game/stellaris_overlord'

ARCHIVE_BASE_OVERLORD_21_NAME='stellaris_overlord_3_13_2_0_76713.sh'
ARCHIVE_BASE_OVERLORD_21_MD5='dbf1a321e0fe23a463030e436dafcda2'
ARCHIVE_BASE_OVERLORD_21_SIZE='99860'
ARCHIVE_BASE_OVERLORD_21_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_OVERLORD_18_NAME='stellaris_overlord_3_12_5_74193.sh'
ARCHIVE_BASE_OVERLORD_18_MD5='62f8f8bf6a5f9774bd1fb036d73e2843'
ARCHIVE_BASE_OVERLORD_18_SIZE='99860'
ARCHIVE_BASE_OVERLORD_18_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_OVERLORD_14_NAME='stellaris_overlord_3_11_3_0_72561.sh'
ARCHIVE_BASE_OVERLORD_14_MD5='dd8189cd8134fc866c374864d0700b83'
ARCHIVE_BASE_OVERLORD_14_SIZE='99860'
ARCHIVE_BASE_OVERLORD_14_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_OVERLORD_11_NAME='stellaris_overlord_3_10_4_70670.sh'
ARCHIVE_BASE_OVERLORD_11_MD5='a6bf968c0f6c7dc75998884b333025ec'
ARCHIVE_BASE_OVERLORD_11_SIZE='99860'
ARCHIVE_BASE_OVERLORD_11_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_OVERLORD_5_NAME='stellaris_overlord_3_9_3_68314.sh'
ARCHIVE_BASE_OVERLORD_5_MD5='580bcbdf375ead938c80956f27e1069d'
ARCHIVE_BASE_OVERLORD_5_SIZE='100180'
ARCHIVE_BASE_OVERLORD_5_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_OVERLORD_2_NAME='stellaris_overlord_3_8_4_1_65337.sh'
ARCHIVE_BASE_OVERLORD_2_MD5='e1c1700fa00f2c2d0c86ec4d7d1d63ea'
ARCHIVE_BASE_OVERLORD_2_SIZE='110000'
ARCHIVE_BASE_OVERLORD_2_VERSION='3.8.4.1-gog65337'

## Galactic Paragons

ARCHIVE_BASE_PARAGONS_22_NAME='stellaris_galactic_paragons_3_14_15926_78464.sh'
ARCHIVE_BASE_PARAGONS_22_MD5='fd01b388fa76e46e8739a70d26c682f0'
ARCHIVE_BASE_PARAGONS_22_SIZE='832'
ARCHIVE_BASE_PARAGONS_22_VERSION='3.14.15926-gog78464'
ARCHIVE_BASE_PARAGONS_22_URL='https://www.gog.com/game/stellaris_galactic_paragons'

ARCHIVE_BASE_PARAGONS_21_NAME='stellaris_galactic_paragons_3_13_2_0_76713.sh'
ARCHIVE_BASE_PARAGONS_21_MD5='ce85a2dffe8e2f5dc5fd691622d96518'
ARCHIVE_BASE_PARAGONS_21_SIZE='832'
ARCHIVE_BASE_PARAGONS_21_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_PARAGONS_18_NAME='stellaris_galactic_paragons_3_12_5_74193.sh'
ARCHIVE_BASE_PARAGONS_18_MD5='00b9ebf125e6812ccd02840db3f7bcd7'
ARCHIVE_BASE_PARAGONS_18_SIZE='832'
ARCHIVE_BASE_PARAGONS_18_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_PARAGONS_14_NAME='stellaris_galactic_paragons_3_11_3_0_72561.sh'
ARCHIVE_BASE_PARAGONS_14_MD5='ee6878f407ab24721974463a3c957d68'
ARCHIVE_BASE_PARAGONS_14_SIZE='832'
ARCHIVE_BASE_PARAGONS_14_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_PARAGONS_11_NAME='stellaris_galactic_paragons_3_10_4_70670.sh'
ARCHIVE_BASE_PARAGONS_11_MD5='e081e220e0a862bd8adc42860b9bd1f4'
ARCHIVE_BASE_PARAGONS_11_SIZE='832'
ARCHIVE_BASE_PARAGONS_11_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_PARAGONS_5_NAME='stellaris_galactic_paragons_3_9_3_68314.sh'
ARCHIVE_BASE_PARAGONS_5_MD5='4e1ad6ceb7a5e3bb6d55d1bc7547954e'
ARCHIVE_BASE_PARAGONS_5_SIZE='1152'
ARCHIVE_BASE_PARAGONS_5_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_PARAGONS_2_NAME='stellaris_galactic_paragons_3_8_4_1_65337.sh'
ARCHIVE_BASE_PARAGONS_2_MD5='e47a7ab7c264021f49b8419e1aedc580'
ARCHIVE_BASE_PARAGONS_2_SIZE='1200'
ARCHIVE_BASE_PARAGONS_2_VERSION='3.8.4.1-gog65337'

## The Machine Age

ARCHIVE_BASE_MACHINE_7_NAME='stellaris_the_machine_age_3_14_15926_78464.sh'
ARCHIVE_BASE_MACHINE_7_MD5='ab74106e42a9b5525ae852ca27b7020f'
ARCHIVE_BASE_MACHINE_7_SIZE='100390'
ARCHIVE_BASE_MACHINE_7_VERSION='3.14.15926-gog78464'
ARCHIVE_BASE_MACHINE_7_URL='https://www.gog.com/game/stellaris_the_machine_age'

ARCHIVE_BASE_MACHINE_6_NAME='stellaris_the_machine_age_3_13_2_0_76713.sh'
ARCHIVE_BASE_MACHINE_6_MD5='113ee29d7d37fc5de99f1716114a12f3'
ARCHIVE_BASE_MACHINE_6_SIZE='100390'
ARCHIVE_BASE_MACHINE_6_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_MACHINE_3_NAME='stellaris_the_machine_age_3_12_5_74193.sh'
ARCHIVE_BASE_MACHINE_3_MD5='06614dbbb8a94b20449f6a3a6f863347'
ARCHIVE_BASE_MACHINE_3_SIZE='118726'
ARCHIVE_BASE_MACHINE_3_VERSION='3.12.5-gog74193'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
dlc'

PKG_PARENT_ID="$GAME_ID"

PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_PARENT'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
