/*###############################################################################
# Linux Management Providers (LMP), Power Supply provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "OpenDRIM_RegisteredPowerSupplyProfileAccess.h"

const string InstanceID="OpenDRIM:PowerSupply:1.1.0";

int PowerSupply_OpenDRIM_RegisteredPowerSupplyProfile_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int PowerSupply_OpenDRIM_RegisteredPowerSupplyProfile_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int PowerSupply_OpenDRIM_RegisteredPowerSupplyProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RegisteredPowerSupplyProfile>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_RegisteredPowerSupplyProfile instance;
	instance.setInstanceID(InstanceID);
	
	if(discriminant=="ei")
		CF_assert(PowerSupply_OpenDRIM_RegisteredPowerSupplyProfile_populate(instance,errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int PowerSupply_OpenDRIM_RegisteredPowerSupplyProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RegisteredPowerSupplyProfile& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.InstanceID!=InstanceID)
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}

	CF_assert(PowerSupply_OpenDRIM_RegisteredPowerSupplyProfile_populate(instance,errorMessage));
	_L_;
	return OK;
}

int PowerSupply_OpenDRIM_RegisteredPowerSupplyProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredPowerSupplyProfile& newInstance, const OpenDRIM_RegisteredPowerSupplyProfile& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerSupply_OpenDRIM_RegisteredPowerSupplyProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredPowerSupplyProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerSupply_OpenDRIM_RegisteredPowerSupplyProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RegisteredPowerSupplyProfile& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerSupply_OpenDRIM_RegisteredPowerSupplyProfile_populate(OpenDRIM_RegisteredPowerSupplyProfile& instance, string& errorMessage) {
	_E_;
	vector<unsigned short> AdvertiseTypes;

	instance.setRegisteredName("Power Supply");
	instance.setRegisteredVersion("1.1.0");
	instance.setRegisteredOrganization(2);	// DMTF

	AdvertiseTypes.push_back(2);			// Not Advertised
	instance.setAdvertiseTypes(AdvertiseTypes);
	_L_;
	return OK;
}

