/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.wizard;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.SWTUtil;
import com.nvidia.common.wizards.PropertyDescriptor;
import com.nvidia.common.wizards.WizardContext;
import com.nvidia.cuda.ide.remote.internal.Activator;
import com.nvidia.cuda.ide.remote.internal.Messages;
import com.nvidia.cuda.ide.remote.internal.wizard.PropertyEditableObserver;
import com.nvidia.cuda.ide.util.IdeUtil;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public final class LocalPathField {
    private final WizardContext context;
    private final Text localPath;
    private PropertyDescriptor<String> property;
    private final boolean toggleVisibility;
    private final Collection<Control> uploadWidgets = new LinkedList<Control>();

    private static void bindEnablement(DataBindingContext bindingContext, Collection<Control> widgets, IObservableValue isPathEditable) {
        for (Control control : widgets) {
            if (control instanceof Composite) {
                LocalPathField.bindEnablement(bindingContext, Arrays.asList(((Composite)control).getChildren()), isPathEditable);
            }
            bindingContext.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)control), isPathEditable);
        }
    }

    public LocalPathField(Composite composite, WizardContext context, boolean toggleVisibility) {
        this.context = context;
        this.toggleVisibility = toggleVisibility;
        Label lblLocalExecutable = new Label(composite, 0);
        lblLocalExecutable.setText(Messages.RemoteDebug_firstWizardPage_localExeLabel);
        this.uploadWidgets.add((Control)lblLocalExecutable);
        this.localPath = new Text(composite, 2048);
        this.localPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.uploadWidgets.add((Control)this.localPath);
        this.uploadWidgets.add((Control)new Label(composite, 0));
        Composite composite_3 = new Composite(composite, 0);
        composite_3.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
        GridLayout gl_composite_3 = new GridLayout(2, false);
        gl_composite_3.marginWidth = 0;
        gl_composite_3.marginHeight = 0;
        composite_3.setLayout((Layout)gl_composite_3);
        this.uploadWidgets.add((Control)composite_3);
        Button btnWorkspace = new Button(composite_3, 0);
        btnWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalPathField.this.browseWorkspaceFiles();
            }
        });
        btnWorkspace.setText(Messages.RemoteDebug_firstWizardPage_buttonBrowseWorkspace);
        Button btnLocalFile = new Button(composite_3, 0);
        btnLocalFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalPathField.this.browseLocalFS();
            }
        });
        btnLocalFile.setText(Messages.RemoteDebug_firstWizardPage_buttonBrowseLocalFS);
    }

    public void bind(DataBindingContext bindingContext, PropertyDescriptor<String> property) {
        this.property = property;
        bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.localPath, (int)24), this.context.observeProperty(property));
        LocalPathField.bindEnablement(bindingContext, this.uploadWidgets, (IObservableValue)new PropertyEditableObserver(this.context, property));
    }

    protected void browseLocalFS() {
        String string;
        String path = (String)this.context.getProperty(this.property);
        if ((path = this.getWorkspaceResourcePath(path)) != null && !new File(path).isFile()) {
            path = null;
        }
        FileDialog dialog = new FileDialog(this.context.getShell(), 4096);
        dialog.setText(Messages.RemoteDebug_firstWizardPage_exeBrowseDialogPrompt);
        if (path != null) {
            Path p = new Path(path);
            dialog.setFileName(p.lastSegment());
            dialog.setFilterPath(p.removeLastSegments(1).toOSString());
        }
        if ((string = dialog.open()) != null) {
            this.context.setProperty(this.property, (Object)string);
        }
    }

    protected void browseWorkspaceFiles() {
        String path = (String)this.context.getProperty(this.property);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = IdeUtil.getWorkspaceFile((String)path);
        if (path != null && file == null) {
            Path workspacePath = new Path(path);
            file = root.getFileForLocation((IPath)workspacePath);
        }
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.context.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                Object[] elements = super.getChildren(element);
                ArrayList<IResource> resources = new ArrayList<IResource>(elements.length);
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object el = objectArray[n2];
                    if (el instanceof IResource && ((IResource)el).isAccessible() && !((IResource)el).isHidden()) {
                        resources.add((IResource)el);
                    }
                    ++n2;
                }
                return resources.toArray();
            }
        });
        dialog.setComparator((ViewerComparator)new ViewerSorter(){

            public int category(Object element) {
                if (element instanceof IFolder) {
                    return 0;
                }
                return 1;
            }
        });
        dialog.setTitle(Messages.RemoteDebug_firstWizardPage_exeBrowseDialogWindowTitle);
        dialog.setMessage(Messages.RemoteDebug_firstWizardPage_exeBrowseDialogPrompt);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (CoreUtil.isNullOrEmpty((Object[])selection) || selection.length > 1) {
                    return CoreUtil.errorStatus((String)Messages.RemoteDebug_firstWizardPage_error_oneExecutableMustBeSelected, (Object[])new Object[0]);
                }
                IResource resource = (IResource)selection[0];
                if (resource.getType() != 1) {
                    return CoreUtil.errorStatus((String)Messages.RemoteDebug_firstWizardPage_error_notFile, (Object[])new Object[]{resource.getName()});
                }
                if (!resource.getResourceAttributes().isExecutable()) {
                    return CoreUtil.errorStatus((String)Messages.RemoteDebug_firstWizardPage_error_notExecutable, (Object[])new Object[]{resource.getName()});
                }
                return CoreUtil.OK_STATUS;
            }
        });
        dialog.setInput((Object)root);
        if (file != null) {
            dialog.setInitialElementSelections(Arrays.asList(file));
        }
        if (dialog.open() == 0) {
            IFile newFile = (IFile)dialog.getFirstResult();
            this.context.setProperty(this.property, (Object)newFile.getFullPath().toOSString());
        }
    }

    private String getWorkspaceResourcePath(String path) {
        IFile file = IdeUtil.getWorkspaceFile((String)path);
        if (file != null) {
            URI uri = file.getLocationURI();
            try {
                if (EFS.getLocalFileSystem().equals(EFS.getStore((URI)uri).getFileSystem())) {
                    return uri.getPath();
                }
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
        }
        return path;
    }

    public void toggleState(boolean show) {
        for (Control widget : this.uploadWidgets) {
            if (this.toggleVisibility) {
                SWTUtil.setVisible((Control)widget, (boolean)show);
                continue;
            }
            SWTUtil.setEnabled((Control)widget, (boolean)show);
        }
        this.localPath.getParent().layout();
    }

    public IStatus validate() {
        String localPath = (String)this.context.getProperty(this.property);
        if (CoreUtil.isNullOrEmpty((String)localPath)) {
            return CoreUtil.errorStatus((String)Messages.RemoteDebug_firstWizardPage_error_noLocalExeName, (Object[])new Object[0]);
        }
        IFile file = IdeUtil.getWorkspaceFile((String)localPath);
        if (file == null && !new File(localPath).isFile()) {
            return CoreUtil.errorStatus((String)Messages.RemoteDebug_firstWizardPage_error_noLocalFile, (Object[])new Object[]{localPath});
        }
        return CoreUtil.OK_STATUS;
    }
}

