/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.dialogs.PathVariableDialog;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PathVariablesGroup {
    private static final int SIZING_SELECTION_PANE_WIDTH = 400;
    private Shell shell;
    private Label variableLabel;
    private TableViewer variableTable;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private FontMetrics fontMetrics;
    private boolean multiSelect;
    private int variableType;
    private Listener selectionListener;
    private SortedMap tempPathVariables;
    private Set removedVariableNames;
    private IPathVariableManager pathVariableManager;
    private boolean saveVariablesOnChange = false;
    private final Image FILE_IMG = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private final Image FOLDER_IMG = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private final Image BUILTIN_IMG = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private Image imageUnkown;
    private IResource currentResource = null;
    private static final String PARENT_VARIABLE_NAME = "PARENT";

    public PathVariablesGroup(boolean multiSelect, int variableType) {
        this.multiSelect = multiSelect;
        this.variableType = variableType;
        this.pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        this.removedVariableNames = new HashSet();
        this.tempPathVariables = new TreeMap();
        this.initTemporaryState();
    }

    public PathVariablesGroup(boolean multiSelect, int variableType, Listener selectionListener) {
        this(multiSelect, variableType);
        this.selectionListener = selectionListener;
    }

    private void addNewVariable() {
        PathVariableDialog dialog = new PathVariableDialog(this.shell, 1, this.variableType, this.pathVariableManager, this.tempPathVariables.keySet());
        dialog.setResource(this.currentResource);
        if (dialog.open() == 1) {
            return;
        }
        String newVariableName = dialog.getVariableName();
        Path newVariableValue = new Path(dialog.getVariableValue());
        this.tempPathVariables.put(newVariableName, newVariableValue);
        this.updateWidgetState();
        this.saveVariablesIfRequired();
    }

    public Control createContents(Composite parent) {
        Font font = parent.getFont();
        if (this.imageUnkown == null) {
            ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/obj16/warning.png");
            this.imageUnkown = descriptor.createImage();
        }
        this.initializeDialogUnits((Control)parent);
        this.shell = parent.getShell();
        Composite pageComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageComponent.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = 400;
        pageComponent.setLayoutData((Object)data);
        pageComponent.setFont(font);
        this.variableLabel = new Label(pageComponent, 16384);
        if (this.currentResource == null) {
            this.variableLabel.setText(IDEWorkbenchMessages.PathVariablesBlock_variablesLabel);
        } else {
            this.variableLabel.setText(NLS.bind((String)IDEWorkbenchMessages.PathVariablesBlock_variablesLabelForResource, (Object)this.currentResource.getName()));
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        this.variableLabel.setLayoutData((Object)data);
        this.variableLabel.setFont(font);
        int tableStyle = 67584;
        if (this.multiSelect) {
            tableStyle |= 2;
        }
        Composite tableComposite = new Composite(pageComponent, 0);
        data = new GridData(4, 4, true, true);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        tableComposite.setLayoutData((Object)data);
        this.variableTable = new TableViewer(tableComposite, tableStyle);
        this.variableTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathVariablesGroup.this.updateEnabledState();
                if (PathVariablesGroup.this.selectionListener != null) {
                    PathVariablesGroup.this.selectionListener.handleEvent(new Event());
                }
            }
        });
        this.variableTable.getTable().setFont(font);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.variableTable, (int)2);
        TableViewerColumn nameColumn = new TableViewerColumn(this.variableTable, 0);
        nameColumn.setLabelProvider((CellLabelProvider)new NameLabelProvider());
        nameColumn.getColumn().setText(IDEWorkbenchMessages.PathVariablesBlock_nameColumn);
        TableViewerColumn valueColumn = new TableViewerColumn(this.variableTable, 0);
        valueColumn.setLabelProvider((CellLabelProvider)new ValueLabelProvider());
        valueColumn.getColumn().setText(IDEWorkbenchMessages.PathVariablesBlock_valueColumn);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(150));
        tableLayout.setColumnData((Widget)valueColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(280));
        this.variableTable.getTable().setHeaderVisible(true);
        data = new GridData(1808);
        data.heightHint = this.variableTable.getTable().getItemHeight() * 7;
        this.variableTable.getTable().setLayoutData((Object)data);
        this.variableTable.getTable().setFont(font);
        this.variableTable.getTable().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                int itemsSelectedCount = PathVariablesGroup.this.variableTable.getTable().getSelectionCount();
                if (itemsSelectedCount == 1 && PathVariablesGroup.this.canChangeSelection()) {
                    PathVariablesGroup.this.editSelectedVariable();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.variableTable.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PathVariablesGroup.this.updateEnabledState();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PathVariablesGroup.this.updateEnabledState();
            }
        });
        this.variableTable.getTable().setToolTipText(null);
        this.variableTable.setContentProvider((IContentProvider)new ContentProvider());
        this.variableTable.setInput((Object)this);
        this.createButtonGroup(pageComponent);
        return pageComponent;
    }

    public void dispose() {
        if (this.imageUnkown != null) {
            this.imageUnkown.dispose();
            this.imageUnkown = null;
        }
    }

    private void editSelectedVariable() {
        TableItem item = this.variableTable.getTable().getItem(this.variableTable.getTable().getSelectionIndex());
        String variableName = (String)item.getData();
        IPath variableValue = (IPath)this.tempPathVariables.get(variableName);
        PathVariableDialog dialog = new PathVariableDialog(this.shell, 2, this.variableType, this.pathVariableManager, this.tempPathVariables.keySet());
        dialog.setVariableName(variableName);
        dialog.setVariableValue(variableValue.toOSString());
        dialog.setResource(this.currentResource);
        if (dialog.open() == 1) {
            return;
        }
        this.removedVariableNames.add(variableName);
        this.tempPathVariables.remove(variableName);
        String newVariableName = dialog.getVariableName();
        Path newVariableValue = new Path(dialog.getVariableValue());
        this.tempPathVariables.put(newVariableName, newVariableValue);
        this.updateWidgetState();
        this.saveVariablesIfRequired();
    }

    public boolean getEnabled() {
        if (this.variableTable != null && !this.variableTable.getTable().isDisposed()) {
            return this.variableTable.getTable().getEnabled();
        }
        return true;
    }

    public void setSaveVariablesOnChange(boolean value) {
        this.saveVariablesOnChange = value;
    }

    private void saveVariablesIfRequired() {
        if (this.saveVariablesOnChange) {
            this.performOk();
        }
    }

    public PathVariableElement[] getSelection() {
        if (this.variableTable == null) {
            return new PathVariableElement[0];
        }
        TableItem[] items = this.variableTable.getTable().getSelection();
        PathVariableElement[] selection = new PathVariableElement[items.length];
        int i = 0;
        while (i < items.length) {
            String name = (String)items[i].getData();
            selection[i] = new PathVariableElement();
            selection[i].name = name;
            selection[i].path = (IPath)this.tempPathVariables.get(name);
            ++i;
        }
        return selection;
    }

    private void createButtonGroup(Composite parent) {
        Font font = parent.getFont();
        Composite groupComponent = new Composite(parent, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupComponent.setLayout((Layout)groupLayout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        groupComponent.setFont(font);
        this.addButton = new Button(groupComponent, 8);
        this.addButton.setText(IDEWorkbenchMessages.PathVariablesBlock_addVariableButton);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathVariablesGroup.this.addNewVariable();
            }
        });
        this.addButton.setFont(font);
        this.setButtonLayoutData(this.addButton);
        this.editButton = new Button(groupComponent, 8);
        this.editButton.setText(IDEWorkbenchMessages.PathVariablesBlock_editVariableButton);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathVariablesGroup.this.editSelectedVariable();
            }
        });
        this.editButton.setFont(font);
        this.setButtonLayoutData(this.editButton);
        this.removeButton = new Button(groupComponent, 8);
        this.removeButton.setText(IDEWorkbenchMessages.PathVariablesBlock_removeVariableButton);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathVariablesGroup.this.removeSelectedVariables();
            }
        });
        this.removeButton.setFont(font);
        this.setButtonLayoutData(this.removeButton);
        this.updateEnabledState();
    }

    protected void initializeDialogUnits(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    private void initTemporaryState() {
        String[] varNames = this.pathVariableManager.getPathVariableNames();
        this.tempPathVariables.clear();
        int i = 0;
        while (i < varNames.length) {
            if (!varNames[i].equals(PARENT_VARIABLE_NAME)) {
                try {
                    boolean isFile;
                    IPath value;
                    URI uri = this.pathVariableManager.getURIValue(varNames[i]);
                    if (uri != null && (value = URIUtil.toPath((URI)uri)) != null && ((isFile = value.toFile().isFile()) && (this.variableType & 1) != 0 || !isFile && (this.variableType & 2) != 0)) {
                        this.tempPathVariables.put(varNames[i], value);
                    }
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        this.removedVariableNames.clear();
    }

    private void updateEnabledState() {
        int itemsSelectedCount = this.variableTable.getTable().getSelectionCount();
        this.editButton.setEnabled(itemsSelectedCount == 1 && this.canChangeSelection());
        this.removeButton.setEnabled(itemsSelectedCount > 0 && this.canChangeSelection());
    }

    private String removeParentVariable(String value) {
        return this.pathVariableManager.convertToUserEditableFormat(value, false);
    }

    public boolean performOk() {
        try {
            for (String removedVariableName : this.removedVariableNames) {
                if (this.tempPathVariables.containsKey(removedVariableName)) continue;
                this.pathVariableManager.setURIValue(removedVariableName, null);
            }
            for (Map.Entry entry : this.tempPathVariables.entrySet()) {
                String variableName = (String)entry.getKey();
                IPath variableValue = (IPath)entry.getValue();
                if (this.isBuiltInVariable(variableName)) continue;
                this.pathVariableManager.setURIValue(variableName, URIUtil.toURI((IPath)variableValue));
            }
            this.initTemporaryState();
            return true;
        }
        catch (CoreException ce) {
            ErrorDialog.openError((Shell)this.shell, null, null, (IStatus)ce.getStatus());
            return false;
        }
    }

    private void removeSelectedVariables() {
        int[] selectedIndices = this.variableTable.getTable().getSelectionIndices();
        int i = 0;
        while (i < selectedIndices.length) {
            TableItem selectedItem = this.variableTable.getTable().getItem(selectedIndices[i]);
            String varName = (String)selectedItem.getData();
            this.removedVariableNames.add(varName);
            this.tempPathVariables.remove(varName);
            ++i;
        }
        this.updateWidgetState();
        this.saveVariablesIfRequired();
    }

    private boolean canChangeSelection() {
        int[] selectedIndices = this.variableTable.getTable().getSelectionIndices();
        int i = 0;
        while (i < selectedIndices.length) {
            TableItem selectedItem = this.variableTable.getTable().getItem(selectedIndices[i]);
            String varName = (String)selectedItem.getData();
            if (this.isBuiltInVariable(varName)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isBuiltInVariable(String varName) {
        if (this.currentResource != null) {
            return !this.pathVariableManager.isUserDefined(varName);
        }
        return false;
    }

    private GridData setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fontMetrics, (int)61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        return data;
    }

    public void setEnabled(boolean enabled) {
        if (this.variableTable != null && !this.variableTable.getTable().isDisposed()) {
            this.variableLabel.setEnabled(enabled);
            this.variableTable.getTable().setEnabled(enabled);
            this.addButton.setEnabled(enabled);
            if (enabled) {
                this.updateEnabledState();
            } else {
                this.editButton.setEnabled(enabled);
                this.removeButton.setEnabled(enabled);
            }
        }
    }

    private void updateWidgetState() {
        this.variableTable.refresh();
        this.updateEnabledState();
    }

    public void setResource(IResource resource) {
        this.currentResource = resource;
        this.pathVariableManager = resource != null ? resource.getPathVariableManager() : ResourcesPlugin.getWorkspace().getPathVariableManager();
        this.removedVariableNames = new HashSet();
        this.tempPathVariables = new TreeMap();
        this.initTemporaryState();
    }

    public void reloadContent() {
        this.removedVariableNames = new HashSet();
        this.tempPathVariables = new TreeMap();
        this.initTemporaryState();
        if (this.variableTable != null) {
            this.updateWidgetState();
        }
    }

    private class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return PathVariablesGroup.this.tempPathVariables.keySet().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class NameLabelProvider
    extends CellLabelProvider {
        NameLabelProvider() {
        }

        public String getToolTipText(Object element) {
            return null;
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 5);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 0;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 15000;
        }

        public void update(ViewerCell cell) {
            String varName = (String)cell.getElement();
            cell.setText(varName);
            IPath value = (IPath)PathVariablesGroup.this.tempPathVariables.get(varName);
            URI resolvedURI = PathVariablesGroup.this.pathVariableManager.resolveURI(URIUtil.toURI((IPath)value));
            IPath resolvedValue = URIUtil.toPath((URI)resolvedURI);
            IFileInfo file = IDEResourceInfoUtils.getFileInfo(resolvedValue);
            if (!PathVariablesGroup.this.isBuiltInVariable(varName)) {
                cell.setImage(file.exists() ? (file.isDirectory() ? PathVariablesGroup.this.FOLDER_IMG : PathVariablesGroup.this.FILE_IMG) : PathVariablesGroup.this.imageUnkown);
            } else {
                cell.setImage(PathVariablesGroup.this.BUILTIN_IMG);
            }
        }
    }

    public static class PathVariableElement {
        public String name;
        public IPath path;
    }

    class ValueLabelProvider
    extends CellLabelProvider {
        ValueLabelProvider() {
        }

        public String getToolTipText(Object element) {
            IPath value = (IPath)PathVariablesGroup.this.tempPathVariables.get(element);
            URI resolvedURI = PathVariablesGroup.this.pathVariableManager.resolveURI(URIUtil.toURI((IPath)value));
            IPath resolvedValue = URIUtil.toPath((URI)resolvedURI);
            return TextProcessor.process((String)resolvedValue.toOSString());
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 5);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 0;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 15000;
        }

        public void update(ViewerCell cell) {
            IPath value = (IPath)PathVariablesGroup.this.tempPathVariables.get(cell.getElement());
            cell.setText(TextProcessor.process((String)PathVariablesGroup.this.removeParentVariable(value.toOSString())));
        }
    }
}

