/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.filters;

import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ICoordSorter;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.ICudaVisitor;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.Lane;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import com.nvidia.cuda.ide.debug.model.Warp;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.ICudaElementFilter;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;

public final class ActiveElementsOnly
implements ICudaElementFilter {
    private final boolean fillGaps = true;
    public static final String ID = ActiveElementsOnly.class.getName();

    @Override
    public void updateChildrenCount(boolean isLogical, ICudaRuntimeObject object, ICoordSorter sorter, final DataRequestMonitor<Integer> drm) {
        ICudaApplication app = (ICudaApplication)DMContexts.getAncestorOfType((IDMContext)object, ICudaApplication.class);
        object.accept(new GetActiveElementIndices(isLogical, sorter, new DataRequestMonitor<IDMContext[]>(app.getExecutor(), drm){

            protected void handleSuccess() {
                drm.setData((Object)((IDMContext[])this.getData()).length);
                drm.done();
            }
        }));
    }

    @Override
    public void updateHasChildren(boolean isLogical, ICudaRuntimeObject object, DataRequestMonitor<Boolean> drm) {
        drm.setData((Object)(!(object instanceof Lane) && !(object instanceof DeviceThread) ? 1 : 0));
        drm.done();
    }

    private void fillElements(DataRequestMonitor<IDMContext[]> rm, IDMContext[] elements, int offset, int length) {
        IDMContext[] res;
        if (length > 0) {
            if (elements.length > offset) {
                res = new IDMContext[Math.min(length, elements.length - offset)];
                System.arraycopy(elements, offset, res, 0, res.length);
            } else {
                res = new IDMContext[]{};
            }
        } else {
            res = elements;
        }
        rm.setData((Object)res);
        rm.done();
    }

    @Override
    public void updateChildren(boolean inLogicalMode, ICudaRuntimeObject object, final int offset, final int length, ICoordSorter sorter, final DataRequestMonitor<IDMContext[]> rm) {
        ICudaApplication app = (ICudaApplication)DMContexts.getAncestorOfType((IDMContext)object, ICudaApplication.class);
        object.accept(new GetActiveElementIndices(inLogicalMode, sorter, new DataRequestMonitor<IDMContext[]>(app.getExecutor(), rm){

            protected void handleSuccess() {
                IDMContext[] elements = (IDMContext[])this.getData();
                ActiveElementsOnly.this.fillElements((DataRequestMonitor<IDMContext[]>)rm, elements, offset, length);
            }
        }));
    }

    private final class GetActiveElementIndices
    implements ICudaVisitor {
        private final boolean logical;
        private final DataRequestMonitor<IDMContext[]> rm;
        private final ICoordSorter sorter;

        public GetActiveElementIndices(boolean logical, ICoordSorter sorter, DataRequestMonitor<IDMContext[]> rm) {
            this.logical = logical;
            this.sorter = sorter;
            this.rm = rm;
        }

        @Override
        public void visitApplication(ICudaApplication application) {
            if (this.logical) {
                application.getKernels((DataRequestMonitor<? super Kernel[]>)new DataRequestMonitor<Kernel[]>(application.getExecutor(), this.rm){

                    protected void handleSuccess() {
                        GetActiveElementIndices.this.rm.setData((Object)((IDMContext[])this.getData()));
                        GetActiveElementIndices.this.rm.done();
                    }
                });
            } else {
                application.getDevices(new DataRequestMonitor<Device[]>(application.getExecutor(), this.rm){

                    protected void handleSuccess() {
                        GetActiveElementIndices.this.rm.setData((Object)((IDMContext[])this.getData()));
                        GetActiveElementIndices.this.rm.done();
                    }
                });
            }
        }

        @Override
        public void visitBlock(Block block) {
            ((ICudaApplication)DMContexts.getAncestorOfType((IDMContext)block, ICudaApplication.class)).getActiveThreads(block, true, this.sorter, this.rm);
        }

        @Override
        public void visitDevice(Device device) {
            ((ICudaApplication)DMContexts.getAncestorOfType((IDMContext)device, ICudaApplication.class)).getActiveSMs(device, true, this.rm);
        }

        @Override
        public void visitKernel(Kernel kernel) {
            ((ICudaApplication)DMContexts.getAncestorOfType((IDMContext)kernel, ICudaApplication.class)).getActiveBlocks(kernel, true, this.sorter, this.rm);
        }

        @Override
        public void visitLane(Lane lane) {
            this.rm.setData((Object)new IDMContext[0]);
            this.rm.done();
        }

        @Override
        public void visitSM(StreamingMultiprocessor sm) {
            ((ICudaApplication)DMContexts.getAncestorOfType((IDMContext)sm, ICudaApplication.class)).getActiveWarps(sm, true, this.rm);
        }

        @Override
        public void visitThread(DeviceThread deviceThread) {
            this.rm.setData((Object)new IDMContext[0]);
            this.rm.done();
        }

        @Override
        public void visitWarp(Warp warp) {
            ((ICudaApplication)DMContexts.getAncestorOfType((IDMContext)warp, ICudaApplication.class)).getActiveLanes(warp, true, this.rm);
        }
    }
}

