/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model;

import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaDim;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.CudaObjectsFactory;
import com.nvidia.cuda.ide.debug.model.CudaRuntimeInformation;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.ElementType;
import com.nvidia.cuda.ide.debug.model.ICoordSorter;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.ICudaVisitor;
import com.nvidia.cuda.ide.debug.model.KernelCallSite;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfSession;

public final class Kernel
extends AbstractDMContext
implements Comparable<Kernel>,
ICudaRuntimeObject {
    private static final Pattern ARG_PATTERN = Pattern.compile("\\{name=\"(.*?)\",value=\"(.*?)\"\\}");
    private static final Pattern NAME_PATTERN = Pattern.compile("^(.*)\\(,args=\\[((?:\\{name=\"(.*?)\",value=\"(.*?)\"\\},?)*)\\]\\)$");
    private CudaDim blockDim;
    private KernelCallSite callsite;
    private final short deviceId;
    private CudaDim gridDim;
    private final long kernelId;
    private String kernelName;
    private final KernelState status;

    private static String fixArguments(String cudaGdbKernelName) {
        Matcher matcher = NAME_PATTERN.matcher(cudaGdbKernelName);
        if (matcher.matches()) {
            String args = matcher.group(2);
            StringBuilder cleanArguments = new StringBuilder();
            Matcher argsMatcher = ARG_PATTERN.matcher(args);
            while (argsMatcher.find()) {
                if (cleanArguments.length() > 0) {
                    cleanArguments.append(", ");
                }
                cleanArguments.append(argsMatcher.group(1)).append("=").append(argsMatcher.group(2));
            }
            return String.format("%s(%s)", matcher.group(1), cleanArguments.toString());
        }
        return cudaGdbKernelName;
    }

    public Kernel(IRunControl.IContainerDMContext container, ICudaApplication applicationState, long kernelId, short deviceId, KernelState status) {
        super(container.getSessionId(), new IDMContext[]{container, applicationState});
        this.kernelId = kernelId;
        this.deviceId = deviceId;
        this.status = status;
    }

    public synchronized void setAttributes(String kernelName, CudaDim gridDim, CudaDim blockDim) {
        this.kernelName = Kernel.fixArguments(kernelName);
        this.gridDim = gridDim;
        this.blockDim = blockDim;
    }

    @Override
    public void accept(ICudaVisitor visitor) {
        visitor.visitKernel(this);
    }

    @Override
    public int compareTo(Kernel o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.deviceId == o.deviceId) {
            return (int)Math.signum(this.kernelId - o.kernelId);
        }
        return (int)Math.signum(this.deviceId - o.deviceId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Kernel other = (Kernel)obj;
        if (this.deviceId != other.deviceId) {
            return false;
        }
        return this.kernelId == other.kernelId;
    }

    public void getActiveBlocksCount(final DataRequestMonitor<Integer> rm) {
        final DsfSession session = DsfSession.getSession((String)this.getSessionId());
        if (session != null) {
            session.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    Kernel.this.getApplication().getActiveBlocks(Kernel.this, false, ICoordSorter.HARDWARE, new DataRequestMonitor<IDMContext[]>((Executor)session.getExecutor(), (RequestMonitor)rm){

                        protected void handleSuccess() {
                            rm.setData((Object)((IDMContext[])this.getData()).length);
                            rm.done();
                        }
                    });
                }
            });
        } else {
            rm.setData((Object)0);
            rm.done();
        }
    }

    protected final ICudaApplication getApplication() {
        return (ICudaApplication)DMContexts.getAncestorOfType((IDMContext)this, ICudaApplication.class);
    }

    public Block getBlock(CudaCoord blockIdx) throws CudaException {
        return CudaObjectsFactory.getInstance().newBlock(this, blockIdx);
    }

    public synchronized CudaDim getBlockDim() {
        if (Activator.MODEL_TRACE && this.blockDim == null) {
            Activator.log("Uninitialized block size", new IllegalStateException());
        }
        return this.blockDim;
    }

    public KernelCallSite getCallSite() {
        return this.callsite;
    }

    public short getDeviceId() {
        return this.deviceId;
    }

    public synchronized CudaDim getGridDim() {
        if (Activator.MODEL_TRACE && this.gridDim == null) {
            Activator.log("Uninitialized grid size", new IllegalStateException());
        }
        return this.gridDim;
    }

    public long getId() {
        return this.kernelId;
    }

    public synchronized String getName() {
        if (Activator.MODEL_TRACE && this.kernelName == null) {
            Activator.log("Uninitialized kernel name", new IllegalStateException());
        }
        return this.kernelName;
    }

    public String getShortName() {
        String name = this.getName();
        if (name != null) {
            int indexOf = name.indexOf(40);
            if (indexOf > 0) {
                return name.substring(0, indexOf);
            }
            return name;
        }
        return null;
    }

    @Override
    public void getState(DataRequestMonitor<CudaRuntimeInformation> rm) {
        this.getApplication().getKernelState(this, rm);
    }

    @Override
    public ElementType getType() {
        return ElementType.kernel;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.deviceId;
        result = 31 * result + (int)this.kernelId;
        return result;
    }

    public void setCallSite(Kernel parent) {
        this.callsite = parent != null ? new KernelCallSite(this, parent) : null;
    }

    @Override
    public void toHardwareElement(final DataRequestMonitor<ICudaRuntimeObject> drm) {
        this.getApplication().getDevices(new DataRequestMonitor<Device[]>(ImmediateExecutor.getInstance(), drm){

            protected void handleSuccess() {
                Device[] deviceArray = (Device[])this.getData();
                int n = deviceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Device device = deviceArray[n2];
                    if (device.getId() == Kernel.this.getDeviceId()) {
                        drm.setData((Object)device);
                        break;
                    }
                    drm.done();
                    ++n2;
                }
            }
        });
    }

    @Override
    public void toLogicalElement(DataRequestMonitor<ICudaRuntimeObject> drm) {
        drm.setData((Object)this);
        drm.done();
    }

    public String toString() {
        return String.format("Kernel[%s]#%don%d", this.kernelName, this.kernelId, this.deviceId);
    }

    public boolean isAncestorOf(Kernel child) {
        if (child == null) {
            return false;
        }
        if (this.equals(child)) {
            return true;
        }
        KernelCallSite cs = child.getCallSite();
        if (cs == null) {
            return false;
        }
        return this.kernelId == cs.getParent().getId();
    }

    public KernelCallSite getCallSite(long parent) {
        KernelCallSite cs = this.getCallSite();
        if (cs == null) {
            return null;
        }
        if (cs.getParent().getId() == parent) {
            return cs;
        }
        return cs.getParent().getCallSite(parent);
    }

    public KernelState getStatus() {
        return this.status;
    }

    public static enum KernelState {
        Incoming,
        Running,
        Sleeping,
        Terminated;


        public static KernelState decode(String status) {
            if ("Active".equals(status)) {
                return Running;
            }
            if ("Sleeping".equals(status)) {
                return Sleeping;
            }
            if ("Undetermined".equals(status)) {
                return Terminated;
            }
            Activator.log(2, String.format("Unexpected kernel status: %s\n", status), null);
            return Running;
        }
    }
}

