/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.ui.console.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.cdt.debug.mi.internal.ui.MIUIPlugin;
import org.eclipse.cdt.debug.mi.ui.console.actions.MiConsoleMessages;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class MiConsoleSaveAction
extends Action {
    private IConsole fConsole;
    private String fileName;

    public MiConsoleSaveAction(IConsole console) {
        this.setToolTipText(MiConsoleMessages.saveActionTooltip);
        this.setImageDescriptor(MIUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.cdt.debug.mi.ui", (String)"icons/obj16/save_console.gif"));
        this.fConsole = console;
    }

    public void run() {
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        this.fileName = fileDialog.open();
        if (this.fileName == null) {
            return;
        }
        Runnable saveJob = new Runnable(){

            @Override
            public void run() {
                MiConsoleSaveAction.this.saveContent();
            }
        };
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)saveJob);
    }

    protected void saveContent() {
        boolean confirmed = true;
        try {
            File f = new File(this.fileName);
            if (f.exists()) {
                confirmed = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Confirm overwrite", (String)MiConsoleMessages.confirmOverWrite);
            }
            if (confirmed) {
                BufferedWriter out = new BufferedWriter(new FileWriter(this.fileName));
                out.write(this.fConsole.getDocument().get());
                out.close();
            }
        }
        catch (IOException iOException) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)MiConsoleMessages.infoIOError);
        }
    }
}

