/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResultTimeline;
import com.nvidia.viper.analysis.AnalysisTimeData;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.value.IValue;
import com.nvidia.viper.value.ValueNs;
import com.nvidia.viper.value.ValuePercent;
import org.eclipse.jface.action.Action;

public class AnalysisResultGPUCompute
extends AnalysisResultTimeline<AnalysisTimeData> {
    public AnalysisResultGPUCompute(AnalysisDescriptor desc) {
        super(desc);
    }

    @Override
    public String getDetails(ResultOutput otpt) {
        ValuePercent avgUtil = AnalysisTimeData.getAvgPercentValue(this.timelines.values());
        ValueNs avgTime = AnalysisTimeData.getAvgTimeValue(this.timelines.values());
        ValueNs avgTotalTime = AnalysisTimeData.getAvgTotalTimeValue(this.timelines.values());
        return String.valueOf(avgTime.toString()) + " / " + avgTotalTime.toString() + " = " + avgUtil.toString() + (this.getTimelineCount() > 1 ? " avg" : "");
    }

    @Override
    public IValue getValue(Timeline timeline) {
        Double p = ((AnalysisTimeData)this.getData(timeline)).getRatio();
        if (p == null) {
            return null;
        }
        return new ValuePercent(p * 100.0);
    }

    @Override
    public String getValueDescription(Timeline timeline) {
        return "The percentage of time when kernel execution is being performed by the GPU";
    }

    @Override
    public Action getMoreAction() {
        return new Action(){

            public void run() {
                ViperHelp.displayHelp(ViperHelp.OVERALL_PERF_OPT);
            }
        };
    }
}

