/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.wizard.samples;

import com.nvidia.cuda.ide.util.BasicUtil;

public final class PlatformSpecificValue<T> {
    private final String arch;
    private final String os;
    public final T payload;

    private static String adjustArch(String arch) {
        return "i686".equals(arch) ? "x86" : arch;
    }

    private static String adjustOS(String os) {
        return os;
    }

    public static <T> PlatformSpecificValue<T> fromString(String label, T payload) {
        String arch;
        String os;
        if (BasicUtil.isNullOrEmpty(label)) {
            return new PlatformSpecificValue<T>(null, null, payload);
        }
        String trimmed = label.trim();
        int colon = trimmed.indexOf(58);
        if (colon < 0) {
            os = trimmed;
            arch = null;
        } else {
            os = trimmed.substring(0, colon);
            arch = trimmed.substring(colon + 1);
        }
        return new PlatformSpecificValue<T>(BasicUtil.intern(os), BasicUtil.intern(arch), payload);
    }

    public PlatformSpecificValue(String os, String arch, T payload) {
        this.os = PlatformSpecificValue.adjustOS(BasicUtil.nullIfEmpty(os));
        this.arch = PlatformSpecificValue.adjustArch(BasicUtil.nullIfEmpty(arch));
        this.payload = payload;
    }

    public boolean compatible(String system, String cpu) {
        boolean supportedOS = true;
        if (this.os != null) {
            supportedOS = this.os.equals(system);
        }
        if (this.arch != null) {
            return supportedOS && this.arch.equals(cpu);
        }
        return supportedOS;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PlatformSpecificValue)) {
            return false;
        }
        PlatformSpecificValue other = (PlatformSpecificValue)obj;
        return BasicUtil.sameObject(this.arch, other.arch) && BasicUtil.sameObject(this.os, other.os) && BasicUtil.sameObject(this.payload, other.payload);
    }

    public int hashCode() {
        return BasicUtil.hash(this.payload, BasicUtil.hash(this.os, BasicUtil.hash(this.arch)));
    }
}

