/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.project;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.build.core.Architecture;
import com.nvidia.cuda.ide.build.project.CudaProjectConfigurationImpl;
import com.nvidia.cuda.ide.build.project.ICudaModule;
import com.nvidia.cuda.ide.build.project.ICudaProjectConfiguration;
import org.eclipse.cdt.core.settings.model.ICStorageElement;

public abstract class AbstractCudaModule
implements ICudaModule {
    private static final String ATTR_DEVICE_LINK = "devicelink";
    private static final String ATTR_VERSION_MAJOR = "major";
    private static final String ATTR_VERSION_MINOR = "minor";
    private static final String ELEMENT_PHYSICAL_ARCHITECTURES = "sass";
    private static final String ELEMENT_VIRTUAL_ARCHITECTURE = "ptx";
    protected final CudaProjectConfigurationImpl projectConfiguration;

    public AbstractCudaModule(CudaProjectConfigurationImpl projectConfiguration) {
        this.projectConfiguration = projectConfiguration;
    }

    private void addArchitecture(String elementName, Architecture architecture) {
        ICStorageElement arch = this.getElement(true).createChild(elementName);
        arch.setAttribute(ATTR_VERSION_MAJOR, String.valueOf(architecture.major));
        arch.setAttribute(ATTR_VERSION_MINOR, String.valueOf(architecture.minor));
    }

    @Override
    public void disableArchitecture(Architecture architecture, boolean isPhysical) {
        String elementName = isPhysical ? ELEMENT_PHYSICAL_ARCHITECTURES : ELEMENT_VIRTUAL_ARCHITECTURE;
        ICStorageElement element = this.getElement(true);
        ICStorageElement[] children = element.getChildrenByName(elementName);
        boolean changed = false;
        ICStorageElement[] iCStorageElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            if (String.valueOf(architecture.major).equals(child.getAttribute(ATTR_VERSION_MAJOR)) && String.valueOf(architecture.minor).equals(child.getAttribute(ATTR_VERSION_MINOR))) {
                changed = true;
                element.removeChild(child);
            }
            ++n2;
        }
        if (changed) {
            this.firePropertyChanged("architectures");
        }
    }

    @Override
    public void enableArchitecture(Architecture architecture, boolean isPhysical) {
        String elementName = isPhysical ? ELEMENT_PHYSICAL_ARCHITECTURES : ELEMENT_VIRTUAL_ARCHITECTURE;
        ICStorageElement[] children = this.getElement(true).getChildrenByName(elementName);
        boolean shouldAdd = true;
        ICStorageElement[] iCStorageElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            if (String.valueOf(architecture.major).equals(child.getAttribute(ATTR_VERSION_MAJOR)) && String.valueOf(architecture.minor).equals(child.getAttribute(ATTR_VERSION_MINOR))) {
                shouldAdd = false;
                break;
            }
            ++n2;
        }
        if (shouldAdd) {
            this.addArchitecture(elementName, architecture);
            this.firePropertyChanged("architectures");
        }
    }

    protected final void firePropertyChanged(String property) {
        this.projectConfiguration.fireModulePropertyChanged(this, property);
    }

    private int getArchitectures(ICStorageElement element, String childName, boolean deviceLinking) {
        ICStorageElement[] children = element.getChildrenByName(childName);
        int archs = 0;
        ICStorageElement[] iCStorageElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = iCStorageElementArray[n2];
            Architecture arch = Architecture.get(Integer.valueOf(child.getAttribute(ATTR_VERSION_MAJOR)), Integer.valueOf(child.getAttribute(ATTR_VERSION_MINOR)));
            if (!deviceLinking || arch.major >= 2) {
                archs |= arch.getBit();
            }
            ++n2;
        }
        return archs;
    }

    private int getArchitectures(String elementName) {
        boolean deviceLinking = this.isDeviceLinkingEnabled();
        ICStorageElement element = this.getElement(false);
        int archs = element != null ? this.getArchitectures(element, elementName, deviceLinking) : 0;
        return archs;
    }

    protected abstract ICStorageElement getElement(boolean var1);

    @Override
    public ICudaProjectConfiguration getParentConfiguration() {
        return this.projectConfiguration;
    }

    @Override
    public int getPhysicalArchitectures() {
        int arch = this.getArchitectures(ELEMENT_PHYSICAL_ARCHITECTURES);
        switch (this.getType()) {
            case cubin: {
                return CoreUtil.getLowestSetBit((int)arch);
            }
            case ptx: {
                return 0;
            }
        }
        return arch;
    }

    @Override
    public int getVirtualArchitectures() {
        int arch = this.getArchitectures(ELEMENT_VIRTUAL_ARCHITECTURE);
        switch (this.getType()) {
            case cubin: {
                return 0;
            }
            case ptx: {
                return CoreUtil.getLowestSetBit((int)arch);
            }
        }
        return arch;
    }

    @Override
    public boolean isDeviceLinkingEnabled() {
        ICStorageElement element = this.getElement(false);
        return this.getType() != ICudaModule.Type.ptx && element != null && Boolean.valueOf(element.getAttribute(ATTR_DEVICE_LINK)) != false;
    }

    private void saveArchitectures(String elementName, int archs) {
        ICStorageElement[] children;
        ICStorageElement element = this.getElement(true);
        Object[] objectArray = children = element.getChildrenByName(elementName);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ICStorageElement child = objectArray[n2];
            element.removeChild(child);
            ++n2;
        }
        objectArray = Architecture.decode(archs);
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            ICStorageElement architecture = objectArray[n2];
            this.addArchitecture(elementName, (Architecture)architecture);
            ++n2;
        }
        this.firePropertyChanged("architectures");
    }

    @Override
    public void setDeviceLinkerEnabled(boolean enable) {
        this.getElement(true).setAttribute(ATTR_DEVICE_LINK, String.valueOf(enable));
        this.firePropertyChanged("separeteCompile");
    }

    @Override
    public void setPhysicalArchitectures(int physicalArchitectures) {
        this.saveArchitectures(ELEMENT_PHYSICAL_ARCHITECTURES, physicalArchitectures);
    }

    @Override
    public void setVirtualArchitectures(int virtualArchitectures) {
        this.saveArchitectures(ELEMENT_VIRTUAL_ARCHITECTURE, virtualArchitectures);
    }
}

