/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.viewer.InfoWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AppInfoWindow
extends InfoWindow {
    private JTextArea texta;

    public AppInfoWindow(App app, JhoveBase jhoveBase) {
        super("Application Info", app, jhoveBase);
        this.setSaveActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppInfoWindow.this.saveInfo();
            }
        });
        this.texta = new JTextArea();
        this.texta.setColumns(72);
        JScrollPane jScrollPane = new JScrollPane(this.texta);
        this.texta.setFont(new Font("sansserif", 0, 10));
        this.texta.setLineWrap(true);
        this.texta.setWrapStyleWord(true);
        jScrollPane.setMinimumSize(new Dimension(240, 240));
        jScrollPane.setMaximumSize(new Dimension(500, 250));
        jScrollPane.setPreferredSize(new Dimension(500, 250));
        this.getContentPane().add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setMinimumSize(new Dimension(8, 8));
        this.getContentPane().add((Component)jPanel, "South");
        this.showApp(app, jhoveBase);
        this.pack();
        this.texta.setEditable(false);
        this.texta.select(0, 0);
        Rectangle rectangle = new Rectangle(0, 0, 1, 1);
        this.texta.scrollRectToVisible(rectangle);
    }

    private void showApp(App app, JhoveBase jhoveBase) {
        Object object;
        String string;
        String string2;
        Date date;
        String string3;
        String string4 = app.getName();
        if (string4 != null) {
            this.texta.append("Name: " + string4 + eol);
        }
        if ((string3 = app.getRelease()) != null) {
            this.texta.append("Release: " + string3);
        }
        if ((date = app.getDate()) != null) {
            this.texta.append("   " + this._dateFmt.format(date) + eol);
        }
        if ((string2 = jhoveBase.getConfigFile()) != null) {
            this.texta.append("Configuration: " + string2 + eol);
        }
        if ((string = jhoveBase.getSaxClass()) != null) {
            this.texta.append("SAX parser: " + string + eol);
        }
        Iterator iterator = jhoveBase.getModuleMap().keySet().iterator();
        while (iterator.hasNext()) {
            object = jhoveBase.getModuleMap();
            Module module = (Module)object.get((String)iterator.next());
            this.texta.append(" Module: " + module.getName() + " " + module.getRelease() + eol);
        }
        object = app.getRights();
        if (object != null) {
            this.texta.append(" Rights: " + (String)object + eol);
        }
    }

    private void saveInfo() {
        PrintWriter printWriter = this.doSaveDialog();
        if (printWriter == null) {
            return;
        }
        OutputHandler outputHandler = this.selectHandler();
        try {
            outputHandler.setWriter(printWriter);
            outputHandler.show(this._app);
            printWriter.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, exception.getMessage(), "Error writing file", 0);
        }
    }
}

