/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.DocNode;
import edu.harvard.hul.ois.jhove.module.pdf.PageObject;
import edu.harvard.hul.ois.jhove.module.pdf.PageTreeNode;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfStream;
import edu.harvard.hul.ois.jhove.module.pdf.XProfileBase;
import java.util.Vector;

public final class X2Profile
extends XProfileBase {
    public X2Profile(PdfModule pdfModule) {
        super(pdfModule, XProfileBase.PDFX2);
        this._profileText = "ISO PDF/X-2";
    }

    @Override
    public boolean satisfiesThisProfile() {
        try {
            PdfDictionary pdfDictionary = this._module.getCatalogDict();
            PdfArray pdfArray = (PdfArray)this._module.resolveIndirectObject(pdfDictionary.get("OutputIntents"));
            if (pdfArray == null) {
                return false;
            }
            if (!this.outputIntentsOK(pdfArray)) {
                return false;
            }
            if (!this.bboxOK(true)) {
                return false;
            }
            if (!this.checkPrefsAgainstBleedBox()) {
                return false;
            }
            if (!this.resourcesOK()) {
                return false;
            }
            if (!this.trailerDictOK()) {
                return false;
            }
            if (!this.infoDictOK("PDF/X-2:")) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean resourcesOK() {
        PageTreeNode pageTreeNode = this._module.getDocumentTree();
        try {
            DocNode docNode;
            pageTreeNode.startWalk();
            while ((docNode = pageTreeNode.nextDocNode()) != null) {
                PdfObject pdfObject;
                PdfObject pdfObject2;
                PdfDictionary pdfDictionary;
                Object object;
                Object object2;
                Object object3;
                PdfDictionary pdfDictionary2 = docNode.getResources();
                if (pdfDictionary2 != null) {
                    object3 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary2.get("ExtGState"));
                    if (!this.extGStateOK((PdfDictionary)object3)) {
                        return false;
                    }
                    object2 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary2.get("XObject"));
                    if (!this.xObjectsOK((PdfDictionary)object2)) {
                        return false;
                    }
                }
                if (!(docNode instanceof PageObject)) continue;
                object3 = ((PageObject)docNode).getContentStreams();
                if (object3 != null) {
                    object2 = object3.listIterator();
                    while (object2.hasNext()) {
                        object = (PdfStream)object2.next();
                        PdfDictionary pdfDictionary3 = ((PdfStream)object).getDict();
                        pdfDictionary = (PdfDictionary)pdfDictionary3.get("Resources");
                        if (pdfDictionary != null) {
                            pdfObject2 = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary.get("ExtGState"));
                            if (!this.extGStateOK((PdfDictionary)pdfObject2)) {
                                return false;
                            }
                            pdfObject = (PdfDictionary)this._module.resolveIndirectObject(pdfDictionary.get("XObject"));
                            if (!this.xObjectsOK((PdfDictionary)pdfObject)) {
                                return false;
                            }
                        }
                        if (this.filterOK(pdfObject2 = pdfDictionary3.get("Filter"), true, true)) continue;
                        return false;
                    }
                }
                if ((object2 = ((PageObject)docNode).getAnnotations()) == null) continue;
                object = ((PdfArray)object2).getContent();
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    Vector vector;
                    pdfDictionary = (PdfDictionary)this._module.resolveIndirectObject((PdfObject)((Vector)object).elementAt(i));
                    pdfObject2 = (PdfSimpleObject)pdfDictionary.get("Subtype");
                    if (!"TrapNet".equals(((PdfSimpleObject)pdfObject2).getStringValue()) || (pdfObject = (PdfArray)pdfDictionary.get("FontFauxing")) == null || (vector = ((PdfArray)pdfObject).getContent()).size() <= 0) continue;
                    return false;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean formObjectOK(PdfDictionary pdfDictionary) {
        if (pdfDictionary.get("OPI") != null) {
            return false;
        }
        if (pdfDictionary.get("Ref") != null) {
            if (pdfDictionary.get("Page") == null) {
                return false;
            }
            if (pdfDictionary.get("Metadata") == null) {
                return false;
            }
        }
        return true;
    }
}

