/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import java.util.Vector;

public class NameTreeNode {
    protected PdfModule _module;
    protected NameTreeNode _parent;
    protected PdfDictionary _dict;
    private Vector _kids;
    private Vector _names;
    private Vector _lowerLimit;
    private Vector _upperLimit;

    public NameTreeNode(PdfModule pdfModule, NameTreeNode nameTreeNode, PdfDictionary pdfDictionary) throws PdfException {
        this._module = pdfModule;
        this._parent = nameTreeNode;
        this._dict = pdfDictionary;
        try {
            PdfObject pdfObject;
            Object object;
            PdfArray pdfArray = (PdfArray)pdfModule.resolveIndirectObject(pdfDictionary.get("Limits"));
            if (pdfArray == null) {
                this._lowerLimit = null;
                this._upperLimit = null;
            } else {
                object = pdfArray.getContent();
                pdfObject = (PdfSimpleObject)((Vector)object).elementAt(0);
                this._lowerLimit = ((PdfSimpleObject)pdfObject).getRawBytes();
                pdfObject = (PdfSimpleObject)((Vector)object).elementAt(1);
                this._upperLimit = ((PdfSimpleObject)pdfObject).getRawBytes();
            }
            object = (PdfArray)pdfModule.resolveIndirectObject(pdfDictionary.get("Kids"));
            this._kids = object != null ? ((PdfArray)object).getContent() : null;
            pdfObject = (PdfArray)pdfModule.resolveIndirectObject(pdfDictionary.get("Names"));
            this._names = pdfObject != null ? ((PdfArray)pdfObject).getContent() : null;
        }
        catch (ClassCastException classCastException) {
            throw new PdfInvalidException("Invalid name tree");
        }
        catch (NullPointerException nullPointerException) {
            throw new PdfInvalidException("Invalid name tree");
        }
        catch (Exception exception) {
            throw new PdfMalformedException("Invalid name tree");
        }
    }

    public boolean inBounds(Vector vector) {
        if (this._lowerLimit == null) {
            return true;
        }
        return this.compareKey(vector, this._lowerLimit) >= 0 && this.compareKey(vector, this._upperLimit) <= 0;
    }

    public PdfObject get(Vector vector) throws PdfException {
        try {
            if (!this.inBounds(vector)) {
                return null;
            }
            if (this._names != null) {
                for (int i = 0; i < this._names.size(); i += 2) {
                    PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)this._names.elementAt(i);
                    int n = this.compareKey(vector, pdfSimpleObject.getRawBytes());
                    if (n == 0) {
                        return this._module.resolveIndirectObject((PdfObject)this._names.elementAt(i + 1));
                    }
                    if (n >= 0) continue;
                    return null;
                }
                return null;
            }
            if (this._kids != null) {
                for (int i = 0; i < this._kids.size(); ++i) {
                    PdfDictionary pdfDictionary = (PdfDictionary)this._module.resolveIndirectObject((PdfObject)this._kids.elementAt(i));
                    NameTreeNode nameTreeNode = new NameTreeNode(this._module, this, pdfDictionary);
                    if (!nameTreeNode.inBounds(vector)) continue;
                    return nameTreeNode.get(vector);
                }
                return null;
            }
            throw new PdfMalformedException("Invalid name tree");
        }
        catch (PdfException pdfException) {
            throw pdfException;
        }
        catch (Exception exception) {
            throw new PdfMalformedException("Invalid name tree");
        }
    }

    private int compareKey(Vector vector, Vector vector2) {
        int n;
        int n2 = vector.size();
        int n3 = n2 < (n = vector2.size()) ? n2 : n;
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5 = (Integer)vector.elementAt(i);
            if (n5 < (n4 = ((Integer)vector2.elementAt(i)).intValue())) {
                return -1;
            }
            if (n5 <= n4) continue;
            return 1;
        }
        if (n2 == n) {
            return 0;
        }
        if (n2 < n) {
            return -1;
        }
        return 1;
    }

    private void dumpKey(Vector vector, String string) {
        System.out.print(string);
        for (int i = 0; i < vector.size(); ++i) {
            System.out.print(vector.elementAt(i).toString() + " ");
        }
        System.out.println();
    }
}

