/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CodestreamHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ComposLayerHdrBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2HeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Strings;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ChannelDefBox
extends JP2Box {
    public ChannelDefBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!(this._parentBox instanceof JP2HeaderBox) && !(this._parentBox instanceof CodestreamHeaderBox)) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        int n = (int)this._boxHeader.getDataLength();
        int n2 = this._module.readUnsignedShort(this._dstrm);
        n -= 2;
        Property[] propertyArray = new Property[n2];
        for (int i = 0; i < n2; ++i) {
            Property[] propertyArray2 = new Property[3];
            int n3 = this._module.readUnsignedShort(this._dstrm);
            propertyArray2[0] = new Property("ChannelIndex", PropertyType.INTEGER, (Object)new Integer(n3));
            int n4 = this._module.readUnsignedShort(this._dstrm);
            propertyArray2[1] = this._module.addIntegerProperty("ChannelType", n4, JP2Strings.ctypStr, JP2Strings.ctypIdx);
            int n5 = this._module.readUnsignedShort(this._dstrm);
            n -= 6;
            propertyArray2[2] = new Property("ChannelAssociation", PropertyType.INTEGER, (Object)new Integer(n5));
            propertyArray[i] = new Property("Channel", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propertyArray2);
        }
        this._module.skipBytes(this._dstrm, n, this._module);
        Property property = new Property("ChannelDefinition", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)propertyArray);
        if (this._parentBox instanceof JP2HeaderBox) {
            this._module.addProperty(property);
        } else if (this._parentBox instanceof ComposLayerHdrBox) {
            ((ComposLayerHdrBox)this._parentBox).addChannelDef(property);
        }
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Channel Definition Box";
    }
}

