/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;

public class AssociationBox
extends JP2Box {
    public AssociationBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    @Override
    public boolean readBox() throws IOException {
        Property property;
        this.initBytesRead();
        this.hasBoxes = true;
        int n = (int)this._boxHeader.getDataLength();
        JP2Box jP2Box = null;
        LinkedList<Property> linkedList = new LinkedList<Property>();
        while (this.hasNext() && (jP2Box = (JP2Box)this.next()) != null) {
            if (!jP2Box.readBox()) {
                return false;
            }
            property = jP2Box.selfDescProperty();
            if (property == null) continue;
            linkedList.add(property);
        }
        if (!this.associations.isEmpty()) {
            linkedList.add(new Property("Associations", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this.associations));
        }
        property = new Property("Association", PropertyType.PROPERTY, PropertyArity.LIST, linkedList);
        if (this._parentBox != null) {
            this._parentBox.addAssociation(property);
        } else {
            this._module.addAssociationProp(property);
        }
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected Property selfDescProperty() {
        return null;
    }

    @Override
    protected String getSelfPropName() {
        return "Association Box";
    }
}

