/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import org.fest.assertions.Assertions;
import org.fest.swing.util.Modifiers;
import org.fest.swing.util.OSFamily;
import org.fest.swing.util.OSIdentifier;
import org.fest.swing.util.ToolkitProvider;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

public final class Platform {
    private static OSIdentifier osIdentifier;
    private static ToolkitProvider toolkitProvider;

    @VisibleForTesting
    static void reload() {
        Platform.initialize(new OSIdentifier(), new ToolkitProvider());
    }

    @VisibleForTesting
    static void initialize(OSIdentifier newOSIdentifier, ToolkitProvider newToolkitProvider) {
        osIdentifier = newOSIdentifier;
        toolkitProvider = newToolkitProvider;
    }

    public static int controlOrCommandKey() {
        int menuShortcutKeyMask = Platform.controlOrCommandMask();
        int[] keys = Modifiers.keysFor(menuShortcutKeyMask);
        Assertions.assertThat((int[])keys).as(Strings.concat((Object[])new Object[]{"Key code for mask ", String.valueOf(menuShortcutKeyMask)})).isNotNull().hasSize(1);
        return keys[0];
    }

    public static int controlOrCommandMask() {
        return toolkitProvider.toolkit().getMenuShortcutKeyMask();
    }

    public static boolean canResizeWindows() {
        return !Platform.isWindows() && !Platform.isMacintosh();
    }

    public static boolean canMoveWindows() {
        return !Platform.isWindows() && !Platform.isMacintosh();
    }

    public static boolean isWindows() {
        return osIdentifier.isWindows();
    }

    public static boolean isWindows9x() {
        return osIdentifier.isWindows9x();
    }

    public static boolean isWindowsXP() {
        return osIdentifier.isWindowsXP();
    }

    public static boolean isMacintosh() {
        return osIdentifier.isMacintosh();
    }

    public static boolean isOSX() {
        return osIdentifier.isOSX();
    }

    public static boolean isX11() {
        return osIdentifier.isX11();
    }

    public static boolean isSolaris() {
        return osIdentifier.isSolaris();
    }

    public static boolean isHPUX() {
        return osIdentifier.isHPUX();
    }

    public static boolean isLinux() {
        return osIdentifier.isLinux();
    }

    public static OSFamily osFamily() {
        return osIdentifier.osFamily();
    }

    private Platform() {
    }

    static {
        Platform.reload();
    }
}

