/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.image;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.Locale;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.FocusOwnerFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.image.ImageException;
import org.fest.swing.image.ImageFileWriter;
import org.fest.swing.query.ComponentLocationOnScreenQuery;
import org.fest.swing.query.ComponentSizeQuery;
import org.fest.swing.util.RobotFactory;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

public class ScreenshotTaker {
    @Deprecated
    public static final String PNG_EXTENSION = "png";
    private final Robot robot;
    private final ImageFileWriter writer;

    public ScreenshotTaker() {
        this(new ImageFileWriter(), new RobotFactory());
    }

    @VisibleForTesting
    ScreenshotTaker(ImageFileWriter writer, RobotFactory robotFactory) {
        this.writer = writer;
        try {
            this.robot = robotFactory.newRobotInPrimaryScreen();
        }
        catch (AWTException e) {
            throw new ImageException("Unable to create AWT Robot", e);
        }
    }

    public void saveDesktopAsPng(String imageFilePath) {
        this.saveImage(this.takeDesktopScreenshot(), imageFilePath);
    }

    public BufferedImage takeDesktopScreenshot() {
        Rectangle r = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        return this.takeScreenshot(r);
    }

    public void saveComponentAsPng(Component c, String imageFilePath) {
        this.saveImage(this.takeScreenshotOf(c), imageFilePath);
    }

    public BufferedImage takeScreenshotOf(Component c) {
        Point locationOnScreen = ComponentLocationOnScreenQuery.locationOnScreen(c);
        Dimension size = ComponentSizeQuery.sizeOf(c);
        Rectangle r = new Rectangle(locationOnScreen.x, locationOnScreen.y, size.width, size.height);
        return this.takeScreenshot(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage takeScreenshot(Rectangle r) {
        JTextComponent textComponent = ScreenshotTaker.findFocusOwnerAndHideItsCaret();
        this.robot.waitForIdle();
        try {
            BufferedImage bufferedImage = ScreenshotTaker.takeScreenshot(this.robot, r);
            return bufferedImage;
        }
        finally {
            this.showCaretIfPossible(textComponent);
        }
    }

    @RunsInEDT
    private static JTextComponent findFocusOwnerAndHideItsCaret() {
        return GuiActionRunner.execute(new GuiQuery<JTextComponent>(){

            @Override
            protected JTextComponent executeInEDT() {
                Component focusOwner = FocusOwnerFinder.focusOwner();
                if (!(focusOwner instanceof JTextComponent)) {
                    return null;
                }
                JTextComponent textComponent = (JTextComponent)focusOwner;
                Caret caret = textComponent.getCaret();
                if (caret == null || !caret.isVisible()) {
                    return null;
                }
                caret.setVisible(false);
                return textComponent;
            }
        });
    }

    private static BufferedImage takeScreenshot(final Robot robot, final Rectangle r) {
        return GuiActionRunner.execute(new GuiQuery<BufferedImage>(){

            @Override
            protected BufferedImage executeInEDT() {
                return robot.createScreenCapture(r);
            }
        });
    }

    private void showCaretIfPossible(JTextComponent textComponent) {
        if (textComponent == null) {
            return;
        }
        ScreenshotTaker.showCaretOf(textComponent);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void showCaretOf(final JTextComponent textComponent) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                Caret caret = textComponent.getCaret();
                if (caret != null) {
                    caret.setVisible(true);
                }
            }
        });
    }

    public void saveImage(BufferedImage image, String filePath) {
        this.validate(filePath);
        try {
            this.writer.writeAsPng(image, filePath);
        }
        catch (Exception e) {
            throw new ImageException(Strings.concat((Object[])new Object[]{"Unable to save image as ", Strings.quote((String)filePath)}), e);
        }
    }

    private void validate(String imageFilePath) {
        if (Strings.isEmpty((String)imageFilePath)) {
            throw new ImageException("The image path cannot be empty");
        }
        if (!imageFilePath.endsWith(PNG_EXTENSION)) {
            throw new ImageException(Strings.concat((Object[])new Object[]{"The image file should be a ", PNG_EXTENSION.toUpperCase(Locale.getDefault())}));
        }
    }
}

