/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JTreeAddRootIfInvisibleTask;
import org.fest.swing.driver.JTreePathFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;

final class JTreeMatchingPathQuery {
    @RunsInEDT
    static TreePath verifyJTreeIsReadyAndFindMatchingPath(final JTree tree, final String path, final JTreePathFinder pathFinder) {
        return GuiActionRunner.execute(new GuiQuery<TreePath>(){

            @Override
            protected TreePath executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(tree);
                return JTreeMatchingPathQuery.matchingPathWithRootIfInvisible(tree, path, pathFinder);
            }
        });
    }

    @RunsInEDT
    static TreePath matchingPathFor(final JTree tree, final String path, final JTreePathFinder pathFinder) {
        return GuiActionRunner.execute(new GuiQuery<TreePath>(){

            @Override
            protected TreePath executeInEDT() {
                return JTreeMatchingPathQuery.matchingPathWithRootIfInvisible(tree, path, pathFinder);
            }
        });
    }

    @RunsInCurrentThread
    static TreePath matchingPathWithRootIfInvisible(JTree tree, String path, JTreePathFinder pathFinder) {
        TreePath matchingPath = pathFinder.findMatchingPath(tree, path);
        return JTreeAddRootIfInvisibleTask.addRootIfInvisible(tree, matchingPath);
    }

    private JTreeMatchingPathQuery() {
    }
}

