/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.regex.Pattern;
import javax.swing.JLabel;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JLabelTextQuery;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.driver.TextDisplayDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JLabelDriver
extends JComponentDriver
implements TextDisplayDriver<JLabel> {
    private static final String TEXT_PROPERTY = "text";

    public JLabelDriver(Robot robot) {
        super(robot);
    }

    @Override
    @RunsInEDT
    public void requireText(JLabel label, String expected) {
        TextAssert.verifyThat(this.textOf(label)).as(JLabelDriver.propertyName(label, TEXT_PROPERTY)).isEqualOrMatches(expected);
    }

    @Override
    @RunsInEDT
    public void requireText(JLabel label, Pattern pattern) {
        TextAssert.verifyThat(this.textOf(label)).as(JLabelDriver.propertyName(label, TEXT_PROPERTY)).matches(pattern);
    }

    @Override
    @RunsInEDT
    public String textOf(JLabel label) {
        return JLabelTextQuery.textOf(label);
    }
}

