/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Collections;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Actions {
    static Object findActionKey(String name, ActionMap actionMap) {
        Action action = actionMap.get(name);
        if (action != null) {
            return name;
        }
        for (Object key : actionMap.allKeys()) {
            action = actionMap.get(key);
            if (!name.equals(action.getValue("Name"))) continue;
            return key;
        }
        String message = Strings.concat((Object[])new Object[]{"The action ", Strings.quote((String)name), " is not available"});
        List<String> allKeys = Actions.formatAllActionKeys(actionMap);
        if (!Collections.isEmpty(allKeys)) {
            message = Strings.concat((Object[])new Object[]{message, ", available actions:", allKeys});
        }
        throw ActionFailedException.actionFailure(message);
    }

    private static List<String> formatAllActionKeys(ActionMap actionMap) {
        ArrayList<String> keys = new ArrayList<String>();
        Object[] allKeys = actionMap.allKeys();
        if (allKeys == null) {
            return keys;
        }
        for (Object key : allKeys) {
            String keyAsString = Actions.keyAsString(key);
            if (keyAsString == null) continue;
            keys.add(keyAsString);
        }
        java.util.Collections.sort(keys);
        return keys;
    }

    private static String keyAsString(Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof String) {
            return (String)Strings.quote((Object)key);
        }
        return Strings.concat((Object[])new Object[]{key.toString(), " (", key.getClass().getName(), ") "});
    }

    private Actions() {
    }
}

