/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import proguard.Configuration;

public class PrintWriterUtil {
    public static PrintWriter createPrintWriterOut(File file) throws FileNotFoundException, UnsupportedEncodingException {
        return PrintWriterUtil.createPrintWriterOut(file, false);
    }

    public static PrintWriter createPrintWriterOut(File file, boolean bl) throws FileNotFoundException, UnsupportedEncodingException {
        return PrintWriterUtil.createPrintWriter(file, new PrintWriter(System.out, true), bl);
    }

    public static PrintWriter createPrintWriterErr(File file) throws FileNotFoundException, UnsupportedEncodingException {
        return PrintWriterUtil.createPrintWriter(file, new PrintWriter(System.err, true));
    }

    public static PrintWriter createPrintWriter(File file, PrintWriter printWriter) throws FileNotFoundException, UnsupportedEncodingException {
        return PrintWriterUtil.createPrintWriter(file, printWriter, false);
    }

    public static PrintWriter createPrintWriter(File file, PrintWriter printWriter, boolean bl) throws FileNotFoundException, UnsupportedEncodingException {
        return file == Configuration.STD_OUT ? printWriter : new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, bl), "UTF-8")));
    }

    public static void closePrintWriter(File file, PrintWriter printWriter) {
        if (file == Configuration.STD_OUT) {
            printWriter.flush();
        } else {
            printWriter.close();
        }
    }

    public static String fileName(File file) {
        if (file == Configuration.STD_OUT) {
            return "standard output";
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getPath();
        }
    }

    private PrintWriterUtil() {
    }
}

